/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.phesa.EncodeFunctions;
import java.util.Base64;

public class Scaling
implements Transformation {
    private double scalingFactor;

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double d) {
        this.scalingFactor = d;
    }

    public Scaling(double d) {
        this.scalingFactor = d;
    }

    @Override
    public void apply(Coordinates coordinates) {
        coordinates.scale(this.scalingFactor);
    }

    @Override
    public void apply(double[] dArray) {
        dArray[0] = dArray[0] * this.scalingFactor;
        dArray[1] = dArray[1] * this.scalingFactor;
        dArray[2] = dArray[2] * this.scalingFactor;
    }

    @Override
    public String encode() {
        Base64.Encoder encoder = Base64.getEncoder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("s");
        stringBuilder.append(" ");
        stringBuilder.append(encoder.encodeToString(EncodeFunctions.doubleToByteArray(this.scalingFactor)));
        return stringBuilder.toString();
    }

    public static Scaling decode(String string) {
        double d = EncodeFunctions.byteArrayToDouble(Base64.getDecoder().decode(string));
        return new Scaling(d);
    }
}

