/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.util.IntArrayComparator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public class TautomerHelper {
    private static final int MAX_TAUTOMERS = 100000;
    private static int sMaxTautomers = 100000;
    private static boolean sSuppressWarning = false;
    private StereoMolecule mOriginalMol;
    private boolean[] mIsTautomerBond;
    private boolean[] mHasFreeValence;
    private int[] mRegionPiCount;
    private int[] mRegionDCount;
    private int[] mRegionTCount;
    private int[] mAtomRegionNo;
    private int[] mAtomDCount;
    private int[] mAtomTCount;
    private int mRegionCount;
    private Iterator<BondOrders> mBondOrderIterator;
    private TreeSet<BondOrders> mBondOrderSet;
    private ArrayDeque<BondOrders> mBondOrderDeque;

    public static void setMaxTautomers(int n) {
        sMaxTautomers = n;
    }

    public static void setSuppressWarning(boolean bl) {
        sSuppressWarning = bl;
    }

    public TautomerHelper(StereoMolecule stereoMolecule) {
        this.mOriginalMol = stereoMolecule.getCompactCopy();
        this.moveDeuteriumAndTritiumToTableEnd();
        this.mOriginalMol.ensureHelperArrays(7);
        this.mIsTautomerBond = new boolean[this.mOriginalMol.getBonds()];
        this.mHasFreeValence = new boolean[this.mOriginalMol.getAtoms()];
        for (int i = 0; i < this.mOriginalMol.getAtoms(); ++i) {
            byte by = Molecule.getAllowedValences(this.mOriginalMol.getAtomicNo(i))[0];
            this.mHasFreeValence[i] = this.mOriginalMol.getNonHydrogenNeighbourCount(i) < by;
        }
        this.createAllTautomers();
        this.assignRegionNumbers();
        this.countAndRemoveDAndT();
        this.compileRegionCounts();
    }

    public StereoMolecule getNextTautomer(StereoMolecule stereoMolecule) {
        if (this.mBondOrderIterator == null) {
            this.mBondOrderIterator = this.mBondOrderSet.iterator();
        }
        if (!this.mBondOrderIterator.hasNext()) {
            return null;
        }
        if (stereoMolecule != null) {
            stereoMolecule.clear();
            this.mOriginalMol.copyMolecule(stereoMolecule);
        } else {
            stereoMolecule = this.mOriginalMol.getCompactCopy();
        }
        this.mBondOrderIterator.next().copyToTautomer(stereoMolecule);
        if (this.mAtomDCount != null || this.mAtomTCount != null) {
            int n;
            int n2;
            int n3;
            stereoMolecule.ensureHelperArrays(1);
            int[] nArray = new int[stereoMolecule.getAtoms()];
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                nArray[i] = stereoMolecule.getFreeValence(i);
            }
            if (this.mAtomDCount != null) {
                int[] nArray2 = (int[])this.mRegionDCount.clone();
                for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                    n2 = Math.min(nArray[n3], this.mAtomDCount[n3]);
                    for (n = 0; n < n2; ++n) {
                        this.addHydrogen(stereoMolecule, n3, 2);
                        int n4 = n3;
                        nArray[n4] = nArray[n4] - 1;
                        int n5 = this.mAtomRegionNo[n3] - 1;
                        nArray2[n5] = nArray2[n5] - 1;
                    }
                }
                for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                    if (this.mAtomRegionNo[n3] == 0 || nArray2[this.mAtomRegionNo[n3] - 1] <= 0 || stereoMolecule.getAtomPi(n3) >= this.mOriginalMol.getAtomPi(n3) || nArray[n3] == 0) continue;
                    this.addHydrogen(stereoMolecule, n3, 2);
                    int n6 = n3;
                    nArray[n6] = nArray[n6] - 1;
                    int n7 = this.mAtomRegionNo[n3] - 1;
                    nArray2[n7] = nArray2[n7] - 1;
                }
            }
            if (this.mAtomTCount != null) {
                int[] nArray3 = (int[])this.mRegionTCount.clone();
                for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                    n2 = Math.min(nArray[n3], this.mAtomTCount[n3]);
                    for (n = 0; n < n2; ++n) {
                        this.addHydrogen(stereoMolecule, n3, 3);
                        int n8 = n3;
                        nArray[n8] = nArray[n8] - 1;
                        int n9 = this.mAtomRegionNo[n3] - 1;
                        nArray3[n9] = nArray3[n9] - 1;
                    }
                }
                for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
                    if (this.mAtomRegionNo[n3] == 0 || nArray3[this.mAtomRegionNo[n3] - 1] <= 0 || stereoMolecule.getAtomPi(n3) >= this.mOriginalMol.getAtomPi(n3) || nArray[n3] == 0) continue;
                    this.addHydrogen(stereoMolecule, n3, 3);
                    int n10 = n3;
                    nArray[n10] = nArray[n10] - 1;
                    int n11 = this.mAtomRegionNo[n3] - 1;
                    nArray3[n11] = nArray3[n11] - 1;
                }
            }
        }
        stereoMolecule.ensureHelperArrays(15);
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (stereoMolecule.getBondType(i) != 386 || stereoMolecule.getBondParity(i) != 0) continue;
            stereoMolecule.setBondType(i, 2);
        }
        return stereoMolecule;
    }

    private void moveDeuteriumAndTritiumToTableEnd() {
        int n;
        int n2;
        this.mOriginalMol.ensureHelperArrays(1);
        int n3 = this.mOriginalMol.getAtoms();
        while (--n3 >= 0 && this.mOriginalMol.getAtomicNo(n3) == 1) {
        }
        for (int i = 0; i < n3; ++i) {
            if (this.mOriginalMol.getAtomicNo(i) != 1) continue;
            this.mOriginalMol.swapAtoms(i, n3);
            while (this.mOriginalMol.getAtomicNo(--n3) == 1) {
            }
        }
        if (n3 == this.mOriginalMol.getAtoms() - 1) {
            return;
        }
        boolean[] blArray = new boolean[this.mOriginalMol.getBonds()];
        for (n2 = 0; n2 < this.mOriginalMol.getBonds(); ++n2) {
            n = this.mOriginalMol.getBondAtom(0, n2);
            int n4 = this.mOriginalMol.getBondAtom(1, n2);
            if (this.mOriginalMol.getAtomicNo(n) != 1 && this.mOriginalMol.getAtomicNo(n4) != 1) continue;
            blArray[n2] = true;
        }
        n2 = this.mOriginalMol.getBonds();
        while (--n2 >= 0 && blArray[n2]) {
        }
        for (n = 0; n < n2; ++n) {
            if (!blArray[n]) continue;
            this.mOriginalMol.swapBonds(n, n2);
            blArray[n] = false;
            while (blArray[--n2]) {
            }
        }
    }

    private void addHydrogen(StereoMolecule stereoMolecule, int n, int n2) {
        int n3 = stereoMolecule.addAtom(1);
        stereoMolecule.setAtomMass(n3, n2);
        stereoMolecule.addBond(n, n3, 1);
    }

    public int getTautomerCount() {
        return this.mBondOrderSet.size();
    }

    private void countAndRemoveDAndT() {
        for (int i = 0; i < this.mOriginalMol.getAllBonds(); ++i) {
            for (int j = 0; j < 2; ++j) {
                int n = this.mOriginalMol.getBondAtom(j, i);
                int n2 = this.mOriginalMol.getBondAtom(1 - j, i);
                if (this.mOriginalMol.getAtomicNo(n) != 1 || this.mOriginalMol.getAtomMass(n) <= 1 || this.mOriginalMol.getAtomicNo(n2) <= 1 || this.mAtomRegionNo[n2] == 0) continue;
                if (this.mOriginalMol.getAtomMass(n) == 2) {
                    if (this.mAtomDCount == null) {
                        this.mAtomDCount = new int[this.mOriginalMol.getAllAtoms()];
                    }
                    int n3 = n2;
                    this.mAtomDCount[n3] = this.mAtomDCount[n3] + 1;
                } else {
                    if (this.mAtomTCount == null) {
                        this.mAtomTCount = new int[this.mOriginalMol.getAllAtoms()];
                    }
                    int n4 = n2;
                    this.mAtomTCount[n4] = this.mAtomTCount[n4] + 1;
                }
                this.mOriginalMol.markAtomForDeletion(n);
            }
        }
        if (this.mAtomDCount != null || this.mAtomTCount != null) {
            this.mOriginalMol.deleteMarkedAtomsAndBonds();
        }
    }

    public int getAtomRegionCount() {
        return this.mRegionCount;
    }

    public int[] getAtomRegionNumbers() {
        return this.mAtomRegionNo;
    }

    private void assignRegionNumbers() {
        this.mAtomRegionNo = new int[this.mOriginalMol.getAtoms()];
        int[] nArray = new int[this.mOriginalMol.getAtoms()];
        boolean[] blArray = new boolean[this.mOriginalMol.getBonds()];
        int n = 0;
        for (int i = 0; i < this.mOriginalMol.getBonds(); ++i) {
            if (blArray[i] || !this.mIsTautomerBond[i]) continue;
            this.mAtomRegionNo[this.mOriginalMol.getBondAtom((int)0, (int)i)] = ++n;
            this.mAtomRegionNo[this.mOriginalMol.getBondAtom((int)1, (int)i)] = n;
            blArray[i] = true;
            for (int j = 0; j < 2; ++j) {
                int n2 = this.mOriginalMol.getBondAtom(j, i);
                this.mAtomRegionNo[n2] = n;
                int n3 = 0;
                nArray[0] = n2;
                for (int k = 0; k <= n3; ++k) {
                    for (int i2 = 0; i2 < this.mOriginalMol.getConnAtoms(nArray[k]); ++i2) {
                        int n4 = this.mOriginalMol.getConnBond(nArray[k], i2);
                        if (blArray[n4] || !this.mIsTautomerBond[n4]) continue;
                        blArray[n4] = true;
                        int n5 = this.mOriginalMol.getConnAtom(nArray[k], i2);
                        if (this.mAtomRegionNo[n5] != 0) continue;
                        this.mAtomRegionNo[n5] = n;
                        nArray[++n3] = n5;
                    }
                }
            }
        }
        this.mRegionCount = n;
    }

    private void compileRegionCounts() {
        int n;
        this.mRegionPiCount = new int[this.mRegionCount];
        this.mRegionDCount = new int[this.mRegionCount];
        this.mRegionTCount = new int[this.mRegionCount];
        for (n = 0; n < this.mOriginalMol.getAtoms(); ++n) {
            if (this.mAtomRegionNo[n] == 0) continue;
            int n2 = this.mAtomRegionNo[n] - 1;
            if (this.mAtomDCount != null) {
                int n3 = n2;
                this.mRegionDCount[n3] = this.mRegionDCount[n3] + this.mAtomDCount[n];
            }
            if (this.mAtomTCount == null) continue;
            int n4 = n2;
            this.mRegionTCount[n4] = this.mRegionTCount[n4] + this.mAtomTCount[n];
        }
        for (n = 0; n < this.mOriginalMol.getBonds(); ++n) {
            if (!this.mIsTautomerBond[n] || this.mOriginalMol.getBondOrder(n) != 2) continue;
            int n5 = this.mAtomRegionNo[this.mOriginalMol.getBondAtom(0, n)] - 1;
            this.mRegionPiCount[n5] = this.mRegionPiCount[n5] + 2;
        }
    }

    private boolean hasAcidicHydrogen(StereoMolecule stereoMolecule, int n) {
        if (stereoMolecule.getAllHydrogens(n) <= 0) {
            return false;
        }
        if (stereoMolecule.isElectronegative(n)) {
            return true;
        }
        return stereoMolecule.getAtomPi(n) == 0;
    }

    public StereoMolecule createGenericTautomer() {
        int n;
        int n2;
        if (this.mBondOrderSet.size() == 1) {
            return this.mOriginalMol;
        }
        StereoMolecule stereoMolecule = this.mOriginalMol.getCompactCopy();
        stereoMolecule.setFragment(true);
        stereoMolecule.ensureHelperArrays(7);
        for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
            if (!this.mIsTautomerBond[n2]) continue;
            stereoMolecule.setBondType(n2, 1);
            stereoMolecule.setBondQueryFeature(n2, 3, true);
        }
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            if (this.mAtomRegionNo[n2] == 0 || this.mOriginalMol.getNonHydrogenNeighbourCount(n2) >= 4) continue;
            stereoMolecule.convertStereoBondsToSingleBonds(n2);
            stereoMolecule.setAtomConfigurationUnknown(n2, false);
            stereoMolecule.setAtomESR(n2, 0, -1);
        }
        int[] nArray = new int[this.mRegionCount];
        int[] nArray2 = new int[this.mRegionCount];
        int[] nArray3 = new Canonizer(stereoMolecule).getFinalRank();
        for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
            int n3;
            if (this.mAtomRegionNo[n] == 0 || nArray2[n3 = this.mAtomRegionNo[n] - 1] >= nArray3[n]) continue;
            nArray2[n3] = nArray3[n];
            nArray[n3] = n;
        }
        for (n = 0; n < this.mRegionCount; ++n) {
            String string = "" + this.mRegionPiCount[n] + "|" + this.mRegionDCount[n] + "|" + this.mRegionTCount[n];
            stereoMolecule.setAtomCustomLabel(nArray[n], string);
        }
        return stereoMolecule;
    }

    private void createAllTautomers() {
        this.mBondOrderSet = new TreeSet();
        this.mBondOrderDeque = new ArrayDeque();
        this.addTautomerIfNew(new BondOrders(this.mOriginalMol));
        StereoMolecule stereoMolecule = this.mOriginalMol.getCompactCopy();
        while (!this.mBondOrderDeque.isEmpty()) {
            this.mBondOrderDeque.poll().copyToTautomer(stereoMolecule);
            this.addAllTautomers(stereoMolecule);
            if (this.mBondOrderSet.size() < sMaxTautomers) continue;
            if (sSuppressWarning) break;
            System.out.println("Tautomer count exceeds maximum: " + new Canonizer(this.mOriginalMol).getIDCode());
            break;
        }
    }

    private void addAllTautomers(StereoMolecule stereoMolecule) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        stereoMolecule.ensureHelperArrays(1);
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (!this.isValidHeteroAtom(i)) continue;
            blArray[i] = true;
            for (int j = 0; j < stereoMolecule.getConnAtoms(i); ++j) {
                int n = stereoMolecule.getConnAtom(i, j);
                int n2 = stereoMolecule.getConnBond(i, j);
                int n3 = stereoMolecule.getConnBondOrder(i, j);
                if (stereoMolecule.getAtomPi(n) == 0 || stereoMolecule.getAtomPi(i) >= n3) continue;
                blArray[n] = true;
                arrayList.add(n2);
                for (int k = 0; k < stereoMolecule.getConnAtoms(n); ++k) {
                    int n4 = stereoMolecule.getConnAtom(n, k);
                    if (blArray[n4]) continue;
                    blArray[n4] = true;
                    int n5 = stereoMolecule.getConnBond(n, k);
                    int n6 = stereoMolecule.getConnBondOrder(n, k);
                    if (stereoMolecule.getAtomPi(n) + 2 == n3 + n6) {
                        arrayList.add(n5);
                        if (n3 >= n6) {
                            if (stereoMolecule.getAtomPi(n4) < n6) {
                                if (this.hasAcidicHydrogen(stereoMolecule, n4)) {
                                    this.addVinylogousTautomers(stereoMolecule, n4, true, false, blArray, arrayList);
                                }
                            } else {
                                this.addVinylogousTautomers(stereoMolecule, n4, true, true, blArray, arrayList);
                            }
                        }
                        if (n6 >= n3 && this.hasAcidicHydrogen(stereoMolecule, i)) {
                            this.addVinylogousTautomers(stereoMolecule, n4, false, false, blArray, arrayList);
                        }
                        if (this.isValidDonorAtom(n4) && stereoMolecule.getAtomPi(n4) < n6) {
                            if (n3 <= 2 && n6 >= 2 && this.hasAcidicHydrogen(stereoMolecule, i)) {
                                this.addDirectTautomer(stereoMolecule, n2, n5);
                            }
                            if (n3 >= 2 && n6 <= 2 && this.hasAcidicHydrogen(stereoMolecule, n4)) {
                                this.addDirectTautomer(stereoMolecule, n5, n2);
                            }
                        }
                        arrayList.remove(arrayList.size() - 1);
                    }
                    blArray[n4] = false;
                }
                arrayList.remove(arrayList.size() - 1);
                blArray[n] = false;
            }
            blArray[i] = false;
        }
    }

    private boolean isValidDonorAtom(int n) {
        return this.mHasFreeValence[n] && (this.mOriginalMol.getAtomicNo(n) == 5 || this.mOriginalMol.getAtomicNo(n) == 6 || this.mOriginalMol.getAtomicNo(n) == 7 || this.mOriginalMol.getAtomicNo(n) == 8 || this.mOriginalMol.getAtomicNo(n) == 16 || this.mOriginalMol.getAtomicNo(n) == 34 || this.mOriginalMol.getAtomicNo(n) == 52);
    }

    private boolean isValidHeteroAtom(int n) {
        return this.mHasFreeValence[n] && (this.mOriginalMol.getAtomicNo(n) == 7 || this.mOriginalMol.getAtomicNo(n) == 8 || this.mOriginalMol.getAtomicNo(n) == 16 || this.mOriginalMol.getAtomicNo(n) == 34 || this.mOriginalMol.getAtomicNo(n) == 52);
    }

    private void addDirectTautomer(StereoMolecule stereoMolecule, int n, int n2) {
        BondOrders bondOrders = new BondOrders(stereoMolecule);
        bondOrders.setBond(n, stereoMolecule.getBondOrder(n) == 1 ? 2 : 3);
        bondOrders.setBond(n2, stereoMolecule.getBondOrder(n2) == 2 ? 1 : 2);
        this.mIsTautomerBond[n] = true;
        this.mIsTautomerBond[n2] = true;
        this.addTautomerIfNew(bondOrders);
    }

    private boolean addVinylogousTautomers(StereoMolecule stereoMolecule, int n, boolean bl, boolean bl2, boolean[] blArray, ArrayList<Integer> arrayList) {
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            if (blArray[n2]) continue;
            int n3 = stereoMolecule.getConnBond(n, i);
            int n4 = stereoMolecule.getBondOrder(n3);
            if ((!bl || n4 < 2) && (bl || n4 > 2)) continue;
            blArray[n2] = true;
            arrayList.add(n3);
            for (int j = 0; j < stereoMolecule.getConnAtoms(n2); ++j) {
                int n5 = stereoMolecule.getConnAtom(n2, j);
                if (blArray[n5]) continue;
                int n6 = stereoMolecule.getConnBond(n2, j);
                int n7 = stereoMolecule.getBondOrder(n6);
                if (stereoMolecule.getAtomPi(n2) + 2 != n4 + n7 || (!bl || n7 > 2) && (bl || n7 < 2)) continue;
                blArray[n5] = true;
                arrayList.add(n6);
                if (this.isValidDonorAtom(n5) && (!bl || this.hasAcidicHydrogen(stereoMolecule, n5))) {
                    BondOrders bondOrders = new BondOrders(stereoMolecule);
                    for (int k = 0; k < arrayList.size(); ++k) {
                        boolean bl3;
                        int n8 = arrayList.get(k);
                        boolean bl4 = k < 2 ? bl ^ (k & 1) == 0 : (bl3 = bl2 ^ (k & 1) == 0);
                        if (bl3) {
                            bondOrders.setBond(n8, stereoMolecule.getBondOrder(n8) == 1 ? 2 : 3);
                        } else {
                            bondOrders.setBond(n8, stereoMolecule.getBondOrder(n8) == 2 ? 1 : 2);
                        }
                        this.mIsTautomerBond[n8] = true;
                    }
                    this.addTautomerIfNew(bondOrders);
                } else {
                    this.addVinylogousTautomers(stereoMolecule, n5, bl, bl2, blArray, arrayList);
                }
                arrayList.remove(arrayList.size() - 1);
                blArray[n5] = false;
            }
            arrayList.remove(arrayList.size() - 1);
            blArray[n2] = false;
        }
        return false;
    }

    private void addTautomerIfNew(BondOrders bondOrders) {
        if (this.mBondOrderSet.add(bondOrders)) {
            this.mBondOrderDeque.add(bondOrders);
        }
    }

    class BondOrders
    implements Comparable<BondOrders> {
        private int[] encoding;

        public BondOrders(StereoMolecule stereoMolecule) {
            this.encoding = new int[(TautomerHelper.this.mOriginalMol.getBonds() + 15) / 16];
            for (int i = 0; i < TautomerHelper.this.mOriginalMol.getBonds(); ++i) {
                int n = i >> 4;
                this.encoding[n] = this.encoding[n] | Math.min(3, stereoMolecule.getBondOrder(i)) << 2 * (i & 0xF);
            }
        }

        @Override
        public int compareTo(BondOrders bondOrders) {
            return new IntArrayComparator().compare(this.encoding, bondOrders.encoding);
        }

        public void setBond(int n, int n2) {
            int n3 = n >> 4;
            int n4 = 2 * (n & 0xF);
            int n5 = n3;
            this.encoding[n5] = this.encoding[n5] & ~(3 << n4);
            int n6 = n3;
            this.encoding[n6] = this.encoding[n6] | n2 << n4;
        }

        public void copyToTautomer(StereoMolecule stereoMolecule) {
            for (int i = 0; i < TautomerHelper.this.mOriginalMol.getBonds(); ++i) {
                if (!TautomerHelper.this.mIsTautomerBond[i]) continue;
                int n = 3 & this.encoding[i >> 4] >> 2 * (i & 0xF);
                stereoMolecule.setBondType(i, n == 1 ? 1 : (n == 2 ? (TautomerHelper.this.mIsTautomerBond[i] && !TautomerHelper.this.mOriginalMol.isSmallRingBond(i) ? 386 : 2) : (n == 3 ? 4 : 32)));
            }
        }
    }
}

