/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class StereoMolecule
extends ExtendedMolecule {
    static final long serialVersionUID = 537316094L;
    public static final String VALIDATION_ERROR_ESR_CENTER_UNKNOWN = "Members of ESR groups must only be stereo centers with known configuration.";
    public static final String VALIDATION_ERROR_OVER_UNDER_SPECIFIED = "Over- or under-specified stereo feature or more than one racemic type bond";
    public static final String VALIDATION_ERROR_AMBIGUOUS_CONFIGURATION = "Ambiguous configuration at stereo center because of 2 parallel bonds";
    public static final String[] VALIDATION_ERRORS_STEREO = new String[]{"Members of ESR groups must only be stereo centers with known configuration.", "Over- or under-specified stereo feature or more than one racemic type bond", "Ambiguous configuration at stereo center because of 2 parallel bonds"};
    private transient Canonizer mCanonizer;
    private transient boolean mAssignParitiesToNitrogen;

    public StereoMolecule() {
    }

    public StereoMolecule(int n, int n2) {
        super(n, n2);
    }

    public StereoMolecule(Molecule molecule) {
        super(molecule);
    }

    public StereoMolecule createMolecule(int n, int n2) {
        return new StereoMolecule(n, n2);
    }

    @Override
    public StereoMolecule getCompactCopy() {
        StereoMolecule stereoMolecule = new StereoMolecule(this.mAllAtoms, this.mAllBonds);
        this.copyMolecule(stereoMolecule);
        return stereoMolecule;
    }

    @Override
    public void copyMoleculeProperties(Molecule molecule) {
        super.copyMoleculeProperties(molecule);
        if (this.mCanonizer != null) {
            molecule.mValidHelperArrays = 0;
        }
    }

    public StereoMolecule[] getFragments() {
        int[] nArray = new int[this.mAllAtoms];
        int n = this.getFragmentNumbers(nArray, false, false);
        return this.getFragments(nArray, n);
    }

    public StereoMolecule[] getFragments(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        StereoMolecule[] stereoMoleculeArray = new StereoMolecule[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[this.mAllAtoms];
        for (n4 = 0; n4 < this.mAllAtoms; ++n4) {
            if (nArray[n4] == -1) continue;
            int n5 = nArray[n4];
            nArray2[n5] = nArray2[n5] + 1;
        }
        for (n4 = 0; n4 < this.mAllBonds; ++n4) {
            n3 = nArray[this.mBondAtom[0][n4]];
            n2 = nArray[this.mBondAtom[1][n4]];
            if (n3 != n2 || n3 == -1) continue;
            int n6 = n3;
            nArray3[n6] = nArray3[n6] + 1;
        }
        for (n4 = 0; n4 < n; ++n4) {
            stereoMoleculeArray[n4] = this.createMolecule(nArray2[n4], nArray3[n4]);
            this.copyMoleculeProperties(stereoMoleculeArray[n4]);
        }
        for (n4 = 0; n4 < this.mAllAtoms; ++n4) {
            if (nArray[n4] == -1) continue;
            this.copyAtom(stereoMoleculeArray[nArray[n4]], n4, 0, 0);
        }
        for (n4 = 0; n4 < this.mAllBonds; ++n4) {
            n3 = nArray[this.mBondAtom[0][n4]];
            n2 = nArray[this.mBondAtom[1][n4]];
            if (n3 != n2 || n3 == -1) continue;
            this.copyBond(stereoMoleculeArray[n3], n4, 0, 0, nArray4, false);
        }
        for (StereoMolecule stereoMolecule : stereoMoleculeArray) {
            stereoMolecule.renumberESRGroups(1);
            stereoMolecule.renumberESRGroups(2);
        }
        return stereoMoleculeArray;
    }

    @Override
    public void ensureHelperArrays(int n) {
        super.ensureHelperArrays(n);
        if ((n & ~this.mValidHelperArrays) == 0) {
            return;
        }
        if (this.mAssignParitiesToNitrogen) {
            n |= 0x80;
        }
        int n2 = 0;
        while (n2 < this.getAllAtoms()) {
            int n3 = n2++;
            this.mAtomFlags[n3] = this.mAtomFlags[n3] & 0xFBFE3FF8;
        }
        n2 = 0;
        while (n2 < this.getBonds()) {
            int n4 = n2++;
            this.mBondFlags[n4] = this.mBondFlags[n4] & 0xFFFFFFC0;
        }
        n2 = 0;
        int n5 = 0;
        if ((n & 0x20) != 0) {
            n2 = 32;
            n5 = 1;
        } else if ((n & 0x40) != 0) {
            n2 = 64;
            n5 = 3;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x80;
            n5 |= 0x20;
        }
        this.mCanonizer = new Canonizer(this, n5);
        this.mCanonizer.setParities();
        this.mCanonizer.setStereoCenters();
        this.mCanonizer.setCIPParities();
        if (this.validateESR()) {
            this.mCanonizer = new Canonizer(this, n5);
        }
        this.mValidHelperArrays |= 0x18 | n2;
    }

    private boolean validateESR() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.getAtoms(); ++n) {
            if (this.isAtomStereoCenter(n) && this.getAtomParity(n) != 3) continue;
            int n2 = n;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] & 0xFE03FFFF;
        }
        for (n = 0; n < this.getBonds(); ++n) {
            if (this.getBondOrder(n) == 1 && this.getBondParity(n) != 0 && this.getBondParity(n) != 3) continue;
            int n3 = n;
            this.mBondFlags[n3] = this.mBondFlags[n3] & 0xFFFF80FF;
        }
        if (this.mIsRacemate) {
            if ((this.mChirality & 0xFFFF0000) != 131072) {
                int n4;
                boolean[] blArray = new boolean[this.getAtoms()];
                for (n4 = 0; n4 < this.getAtoms(); ++n4) {
                    if (!this.isAtomStereoCenter(n4) || this.getAtomParity(n4) == 3 || this.getAtomESRType(n4) != 1) continue;
                    blArray[n4] = true;
                }
                for (n4 = 0; n4 < this.getAtoms(); ++n4) {
                    if (!this.isAtomStereoCenter(n4) || this.getAtomParity(n4) == 3) continue;
                    this.setAtomESR(n4, 1, 0);
                    bl = true;
                }
                for (n4 = 0; n4 < this.getAtoms(); ++n4) {
                    if (!blArray[n4]) continue;
                    this.setAtomParity(n4, 1, false);
                    this.setAtomESR(n4, 1, -1);
                    bl = true;
                }
            }
            this.mIsRacemate = false;
        }
        this.renumberESRGroups(1);
        this.renumberESRGroups(2);
        return bl;
    }

    public void stripStereoInformation() {
        int n;
        this.ensureHelperArrays(15);
        this.mIsRacemate = false;
        for (n = 0; n < this.mAllAtoms; ++n) {
            int n2 = n;
            this.mAtomFlags[n2] = this.mAtomFlags[n2] & 0xFE03FFFF;
            if ((this.mAtomFlags[n] & 3) != 0) {
                int n3 = n;
                this.mAtomFlags[n3] = this.mAtomFlags[n3] | 0x2000000;
                continue;
            }
            int n4 = n;
            this.mAtomFlags[n4] = this.mAtomFlags[n4] & 0xFDFFFFFF;
        }
        for (n = 0; n < this.mAllBonds; ++n) {
            if ((this.mBondFlags[n] & 3) != 0 && this.getBondOrder(n) == 2) {
                this.mBondType[n] = 386;
                continue;
            }
            int n5 = n;
            this.mBondType[n5] = this.mBondType[n5] & 0xFFFFFE7F;
        }
        this.mValidHelperArrays &= 0xFFFFFF07;
    }

    public int getAbsoluteAtomParity(int n) {
        return this.mCanonizer.getTHParity(n);
    }

    public int getAbsoluteBondParity(int n) {
        return this.mCanonizer.getEZParity(n);
    }

    public int getSymmetryRank(int n) {
        return this.mCanonizer.getSymmetryRank(n);
    }

    public String getIDCode() {
        this.ensureHelperArrays(15);
        if (!(this.mCanonizer != null || this.getAtoms() >= 2 && this.mCoordinates[0].equals(this.mCoordinates[1]))) {
            this.mCanonizer = new Canonizer(this);
        }
        return this.mCanonizer == null ? null : this.mCanonizer.getIDCode();
    }

    public String getIDCoordinates() {
        this.ensureHelperArrays(15);
        if (!(this.mCanonizer != null || this.getAtoms() >= 2 && this.mCoordinates[0].equals(this.mCoordinates[1]))) {
            this.mCanonizer = new Canonizer(this);
        }
        return this.mCanonizer == null ? null : this.mCanonizer.getEncodedCoordinates();
    }

    public Canonizer getCanonizer() {
        this.ensureHelperArrays(15);
        return this.mCanonizer;
    }

    public int getStereoCenterCount() {
        this.ensureHelperArrays(31);
        int n = 0;
        for (int i = 0; i < this.getAtoms(); ++i) {
            if (this.getAtomParity(i) == 0 || this.isAtomParityPseudo(i)) continue;
            ++n;
        }
        return n;
    }

    public int[][] getESRGroupMemberCounts() {
        int n;
        int n2;
        int n3;
        this.ensureHelperArrays(15);
        int[] nArray = new int[3];
        for (n3 = 0; n3 < this.getAtoms(); ++n3) {
            if (!this.isAtomStereoCenter(n3) || (n2 = this.getAtomESRType(n3)) == 0) continue;
            nArray[n2] = Math.max(nArray[n2], this.getAtomESRGroup(n3));
        }
        for (n3 = 0; n3 < this.getBonds(); ++n3) {
            if (this.getBondParity(n3) != 1 && this.getBondParity(n3) != 2 || this.getBondType(n3) != 1 || (n2 = this.getBondESRType(n3)) == 0) continue;
            nArray[n2] = Math.max(nArray[n2], this.getBondESRGroup(n3));
        }
        int[][] nArrayArray = new int[3][];
        nArrayArray[1] = new int[1 + nArray[1]];
        nArrayArray[2] = new int[1 + nArray[2]];
        for (n2 = 0; n2 < this.getAtoms(); ++n2) {
            if (!this.isAtomStereoCenter(n2) || (n = this.getAtomESRType(n2)) == 0) continue;
            int[] nArray2 = nArrayArray[n];
            int n4 = this.getAtomESRGroup(n2);
            nArray2[n4] = nArray2[n4] + 1;
        }
        for (n2 = 0; n2 < this.getBonds(); ++n2) {
            if (this.getBondParity(n2) != 1 && this.getBondParity(n2) != 2 || this.getBondType(n2) != 1 || (n = this.getBondESRType(n2)) == 0) continue;
            int[] nArray3 = nArrayArray[n];
            int n5 = this.getBondESRGroup(n2);
            nArray3[n5] = nArray3[n5] + 1;
        }
        return nArrayArray;
    }

    public void setUnknownParitiesToExplicitlyUnknown() {
        this.ensureHelperArrays(31);
        if (this.mCanonizer != null) {
            this.mCanonizer.setUnknownParitiesToExplicitlyUnknown();
        }
    }

    public void setAssignParitiesToNitrogen(boolean bl) {
        this.mAssignParitiesToNitrogen = bl;
        this.mValidHelperArrays &= 0xFFFFFF70;
    }

    public int translateTHParity(int n, int[] nArray) {
        int n2 = this.getAtomParity(n);
        if (n2 == 1 || n2 == 2) {
            boolean bl = false;
            if (this.isCentralAlleneAtom(n)) {
                for (int i = 0; i < this.getConnAtoms(n); ++i) {
                    int n3 = this.getConnAtom(n, i);
                    int n4 = 0;
                    int[] nArray2 = new int[3];
                    for (int j = 0; j < this.getConnAtoms(n3); ++j) {
                        nArray2[n4] = this.getConnAtom(n3, j);
                        if (nArray2[n4] == n) continue;
                        ++n4;
                    }
                    if (n4 != 2 || !(nArray2[0] < nArray2[1] ^ nArray[nArray2[0]] < nArray[nArray2[1]])) continue;
                    bl = !bl;
                }
            } else {
                for (int i = 1; i < this.getConnAtoms(n); ++i) {
                    for (int j = 0; j < i; ++j) {
                        int n5;
                        int n6 = this.getConnAtom(n, i);
                        if (!(n6 < (n5 = this.getConnAtom(n, j)) ^ nArray[n6] < nArray[n5])) continue;
                        bl = !bl;
                    }
                }
            }
            if (bl) {
                n2 = n2 == 1 ? 2 : 1;
            }
        }
        return n2;
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        this.ensureHelperArrays(31);
        for (int i = 0; i < this.getAtoms(); ++i) {
            int n;
            if (!(this.getAtomESRType(i) != 1 && this.getAtomESRType(i) != 2 || this.isAtomStereoCenter(i) && this.getAtomParity(i) != 3)) {
                throw new Exception(VALIDATION_ERROR_ESR_CENTER_UNKNOWN);
            }
            if ((this.mAtomFlags[i] & 0x10000) != 0) {
                throw new Exception(VALIDATION_ERROR_OVER_UNDER_SPECIFIED);
            }
            if (this.getAtomParity(i) != 1 && this.getAtomParity(i) != 2 || this.getAtomPi(i) != 0) continue;
            double[] dArray = new double[this.getConnAtoms(i)];
            for (n = 0; n < this.getConnAtoms(i); ++n) {
                dArray[n] = this.getBondAngle(i, this.getConnAtom(i, n));
            }
            for (n = 1; n < this.getConnAtoms(i); ++n) {
                if (this.isStereoBond(this.getConnBond(i, n), i)) continue;
                for (int j = 0; j < n; ++j) {
                    if (this.isStereoBond(this.getConnBond(i, j), i) || !this.bondsAreParallel(dArray[n], dArray[j])) continue;
                    throw new Exception(VALIDATION_ERROR_AMBIGUOUS_CONFIGURATION);
                }
            }
        }
    }

    @Override
    public String getChiralText() {
        this.ensureHelperArrays(31);
        int n = this.mChirality & 0xFFFF;
        switch (this.mChirality & 0xFFFF0000) {
            case 65536: {
                return null;
            }
            case 131072: {
                return n == 1 ? "meso" : "" + n + " meso diastereomers";
            }
            case 0: {
                return "unknown chirality";
            }
            case 196608: {
                return "both enantiomers";
            }
            case 262144: {
                return "this enantiomer";
            }
            case 327680: {
                return "this or other enantiomer";
            }
            case 393216: {
                return "two epimers";
            }
        }
        return n == 1 ? "one stereo isomer" : "" + n + " stereo isomers";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
    }
}

