/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Element;
import java.util.Hashtable;

public class PeriodicTable {
    public static final int ConnectionPoint = 0;
    public static final int Hydrogen = 1;
    public static final int Carbon = 6;
    public static final int Nitrogen = 7;
    public static final int Oxygen = 8;
    public static final int Fluorine = 9;
    public static final int Silicon = 14;
    public static final int Phosphorus = 15;
    public static final int Sulfur = 16;
    public static final int Chlorine = 17;
    public static final int Bromine = 35;
    public static final int Iodine = 53;
    private static Element[] arrData;
    private boolean[] arrAlkaline;
    private Hashtable<Integer, Element> htblDataAtNo = new Hashtable();
    private Hashtable<String, Element> htblDataName = new Hashtable();
    private Hashtable<String, Element> htblDataSymbol = new Hashtable();
    private static PeriodicTable tbl;

    private PeriodicTable() {
        arrData = new Element[]{new Element(1, "Hydrogen", "H", 1.008, 0.435, 1.185, 2.2), new Element(2, "Helium", "He", 4.003, 0.93, 1.785, 0.0), new Element(3, "Lithium", "Li", 6.94, 1.52, 0.0, 0.98), new Element(4, "Beryllium", "Be", 9.013, 1.143, 0.0, 1.57), new Element(5, "Boron", "B", 10.82, 0.975, 1.7, 2.04), new Element(6, "Carbon", "C", 12.011, 0.655, 1.75, 2.55), new Element(7, "Nitrogen", "N", 14.008, 0.75, 1.525, 3.04), new Element(8, "Oxygen", "O", 16.0, 0.73, 1.4, 3.44), new Element(9, "Fluorine", "F", 19.0, 0.72, 1.35, 3.98), new Element(10, "Neon", "Ne", 20.183, 0.71, 1.6, 0.0), new Element(11, "Sodium", "Na", 22.991, 1.858, 0.0, 0.93), new Element(12, "Magnesium", "Mg", 24.32, 1.605, 0.0, 1.31), new Element(13, "Aluminum", "Al", 26.98, 1.432, 0.0, 1.61), new Element(14, "Silicon", "Si", 28.09, 1.176, 2.0, 1.9), new Element(15, "Phosphorus", "P", 30.975, 1.06, 1.9, 2.19), new Element(16, "Sulfur", "S", 32.066, 1.02, 1.85, 2.58), new Element(17, "Chlorine", "Cl", 35.457, 0.99, 1.78, 3.16), new Element(18, "Argon", "Ar", 39.944, 0.98, 1.9, 0.0), new Element(19, "Potassium", "K", 39.1, 2.262, 0.0, 1.0), new Element(20, "Calcium", "Ca", 40.08, 1.976, 0.0, 1.36), new Element(21, "Scandium", "Sc", 44.96, 1.655, 0.0, 1.54), new Element(22, "Titanium", "Ti", 47.9, 1.476, 0.0, 1.63), new Element(23, "Vanadium", "V", 50.95, 1.309, 0.0, 1.66), new Element(24, "Chromium", "Cr", 52.01, 1.249, 0.0, 1.55), new Element(25, "Manganese", "Mn", 54.94, 1.35, 0.0, 1.83), new Element(26, "Iron", "Fe", 55.85, 1.241, 0.0, 1.88), new Element(27, "Cobalt", "Co", 58.94, 1.254, 0.0, 1.91), new Element(28, "Nickel", "Ni", 58.69, 1.246, 0.0, 1.9), new Element(29, "Copper", "Cu", 63.54, 1.278, 0.0, 1.65), new Element(30, "Zinc", "Zn", 65.38, 1.333, 0.0, 1.81), new Element(31, "Gallium", "Ga", 69.72, 1.35, 0.0, 2.01), new Element(32, "Germanium", "Ge", 72.6, 1.225, 0.0, 0.0), new Element(33, "Arsenic", "As", 74.91, 1.2, 2.1, 2.18), new Element(34, "Selenium", "Se", 78.96, 1.16, 2.0, 2.55), new Element(35, "Bromine", "Br", 79.916, 1.14, 1.97, 0.0), new Element(36, "Krypton", "Kr", 83.8, 1.12, 2.0, 2.96), new Element(37, "Rubidium", "Rb", 85.48, 2.47, 0.0, 0.0), new Element(38, "Strontium", "Sr", 87.63, 2.151, 0.0, 0.82), new Element(39, "Yttrium", "Y", 88.92, 1.824, 0.0, 0.95), new Element(40, "Zirconium", "Zr", 91.22, 1.616, 0.0, 1.22), new Element(41, "Niobium", "Nb", 92.91, 1.432, 0.0, 1.33), new Element(42, "Molybdenum", "Mo", 95.95, 1.363, 0.0, 1.6), new Element(43, "Technetium", "Tc", 99.0, 1.367, 0.0, 2.16), new Element(44, "Ruthenium", "Ru", 101.1, 1.353, 0.0, 1.9), new Element(45, "Rhodium", "Rh", 102.91, 1.345, 0.0, 2.2), new Element(46, "Palladium", "Pd", 106.7, 1.375, 0.0, 2.28), new Element(47, "Silver", "Ag", 107.88, 1.445, 0.0, 2.2), new Element(48, "Cadmium", "Cd", 112.41, 1.489, 0.0, 1.93), new Element(49, "Indium", "In", 114.76, 1.666, 0.0, 1.69), new Element(50, "Tin", "Sn", 118.7, 1.538, 0.0, 1.78), new Element(51, "Antimony", "Sb", 121.76, 1.4, 2.2, 1.96), new Element(52, "Tellurium", "Te", 127.61, 1.36, 2.2, 0.0), new Element(53, "Iodine", "I", 126.91, 1.33, 2.2, 2.05), new Element(54, "Xenon", "Xe", 131.3, 1.31, 2.2, 2.1), new Element(55, "Cesium", "Cs", 132.91, 2.632, 0.0, 2.66), new Element(56, "Barium", "Ba", 137.36, 2.171, 0.0, 2.6), new Element(57, "Lanthanum", "La", 138.92, 1.873, 0.0, 0.79), new Element(58, "Cerium", "Ce", 140.13, 1.824, 0.0, 0.89), new Element(59, "Praesodymium", "Pr", 140.92, 1.836, 0.0, 1.1), new Element(60, "Neodymium", "Nd", 144.27, 1.829, 0.0, 1.12), new Element(61, "Promethium", "Pm", 145.0, 1.809, 0.0, 1.13), new Element(62, "Samarium", "Sm", 150.43, 1.804, 0.0, 1.14), new Element(63, "Europium", "Eu", 152.0, 1.984, 0.0, 0.0), new Element(64, "Gadolinium", "Gd", 156.9, 1.818, 0.0, 1.17), new Element(65, "Terbium", "Tb", 158.93, 1.8, 0.0, 0.0), new Element(66, "Dyprosium", "Dy", 162.46, 1.795, 0.0, 1.2), new Element(67, "Holmium", "Ho", 164.94, 1.789, 0.0, 0.0), new Element(68, "Erbium", "Er", 167.2, 1.779, 0.0, 1.22), new Element(69, "Thulium", "Tm", 168.94, 1.769, 0.0, 1.23), new Element(70, "Ytterbium", "Yb", 173.04, 1.94, 0.0, 1.24), new Element(71, "Lutetium", "Lu", 174.99, 1.752, 0.0, 1.25), new Element(72, "Hafnium", "Hf", 178.6, 1.597, 0.0, 0.0), new Element(73, "Tantalium", "Ta", 180.95, 1.428, 0.0, 1.27), new Element(74, "Wolfram", "W", 183.92, 1.371, 0.0, 1.3), new Element(75, "Rhenium", "Re", 186.31, 1.38, 0.0, 1.5), new Element(76, "Osmium", "Os", 190.2, 1.368, 0.0, 2.36), new Element(77, "Iridium", "Ir", 192.2, 1.357, 0.0, 1.9), new Element(78, "Platinum", "Pt", 195.23, 1.387, 0.0, 2.2), new Element(79, "Gold", "Au", 197.0, 1.442, 0.0, 2.2), new Element(80, "Mercury", "Hg", 200.61, 1.502, 0.0, 2.28), new Element(81, "Thallium", "Tl", 204.39, 1.728, 0.0, 2.54), new Element(82, "Lead", "Pb", 207.21, 1.75, 0.0, 2.0), new Element(83, "Bismuth", "Bi", 209.0, 1.46, 0.0, 1.62), new Element(84, "Polonium", "Po", 210.0, 1.46, 0.0, 2.33), new Element(85, "Astatine", "At", 210.0, 1.45, 0.0, 2.02), new Element(86, "Radon", "Rn", 222.0, 1.43, 0.0, 2.0), new Element(87, "Francium", "Fr", 223.0, 2.5, 0.0, 2.2), new Element(88, "Radium", "Ra", 226.05, 2.14, 0.0, 0.0), new Element(89, "Actinium", "Ac", 227.0, 1.877, 0.0, 0.7), new Element(90, "Thorium", "Th", 232.05, 1.798, 0.0, 0.89), new Element(91, "Protactinium", "Pa", 231.0, 1.609, 0.0, 1.1), new Element(92, "Uranium", "U", 238.07, 1.568, 0.0, 1.3), new Element(93, "Neptunium", "Np", 237.0, 0.0, 0.0, 1.5), new Element(94, "Plutonium", "Pu", 242.0, 0.0, 0.0, 1.38), new Element(95, "Americium", "Am", 243.0, 0.0, 0.0, 1.36), new Element(96, "Curium", "Cm", 243.0, 0.0, 0.0, 1.28), new Element(97, "Berkelium", "Bk", 245.0, 0.0, 0.0, 1.3), new Element(98, "Californium", "Cf", 246.0, 0.0, 0.0, 1.3), new Element(99, "Einsteinium", "E", -999.0, 0.0, 0.0, 1.3), new Element(100, "Fermium", "Fm", -999.0, 0.0, 0.0, 1.3), new Element(101, "Mendelevium", "Mv", -999.0, 0.0, 0.0, 1.3)};
        for (int i = 0; i < arrData.length; ++i) {
            this.htblDataAtNo.put(new Integer(arrData[i].getOrderNumber()), arrData[i]);
            this.htblDataName.put(arrData[i].getName(), arrData[i]);
            this.htblDataSymbol.put(arrData[i].getSymbol(), arrData[i]);
        }
        this.arrAlkaline = new boolean[arrData.length];
        this.arrAlkaline[3] = true;
        this.arrAlkaline[11] = true;
        this.arrAlkaline[19] = true;
        this.arrAlkaline[37] = true;
        this.arrAlkaline[55] = true;
        this.arrAlkaline[87] = true;
    }

    private static PeriodicTable getInstance() {
        if (tbl == null) {
            tbl = new PeriodicTable();
        }
        return tbl;
    }

    public static boolean isAlkaline(int n) {
        return PeriodicTable.getInstance().arrAlkaline[n];
    }

    public static int number(String string) {
        int n = 0;
        Element element = PeriodicTable.getInstance().htblDataName.get(string);
        if (element == null) {
            element = PeriodicTable.getInstance().htblDataSymbol.get(string);
        }
        if (element != null) {
            n = element.getOrderNumber();
        }
        return n;
    }

    public static String symbol(int n) {
        String string = "";
        Element element = PeriodicTable.getInstance().htblDataAtNo.get(n);
        if (element != null) {
            string = element.getSymbol();
        }
        return string;
    }

    public static int size() {
        return PeriodicTable.getInstance().htblDataAtNo.size();
    }

    public static double getWeight(int n) {
        Element element = PeriodicTable.getInstance().htblDataAtNo.get(n);
        return element.getWeight();
    }

    public static String name(int n) {
        String string = "";
        Element element = PeriodicTable.getInstance().htblDataAtNo.get(n);
        if (element != null) {
            string = element.getName();
        }
        return string;
    }

    public static Element getElement(int n) {
        return PeriodicTable.getInstance().htblDataAtNo.get(n);
    }

    public String toString() {
        String string = "";
        return string;
    }
}

