/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.StereoMolecule;

public class MoleculeNeutralizer {
    private static final int cInitialMultiChargeFragmentMembers = 16;

    public static int neutralizeChargedMolecule(StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        stereoMolecule.ensureHelperArrays(7);
        int n4 = 0;
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        boolean[] blArray2 = null;
        int[] nArray = new int[stereoMolecule.getAtoms()];
        for (n3 = 0; n3 < stereoMolecule.getBonds(); ++n3) {
            int n5 = stereoMolecule.getBondAtom(0, n3);
            int n6 = stereoMolecule.getBondAtom(1, n3);
            n2 = stereoMolecule.getAtomCharge(n5);
            n = stereoMolecule.getAtomCharge(n6);
            if (n2 != 0 && n != 0 && n2 < 0 ^ n < 0) {
                blArray[n5] = true;
                blArray[n6] = true;
            }
            int n7 = n5;
            nArray[n7] = nArray[n7] + stereoMolecule.getBondOrder(n3);
            int n8 = n6;
            nArray[n8] = nArray[n8] + stereoMolecule.getBondOrder(n3);
        }
        block1: for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            int n9;
            int n10;
            int n11;
            Object[] objectArray;
            n4 += stereoMolecule.getAtomCharge(n3);
            if (stereoMolecule.getAtomCharge(n3) == 1) {
                if (stereoMolecule.getAtomicNo(n3) != 7 || blArray[n3]) continue;
                if (nArray[n3] <= 3) {
                    --n4;
                    stereoMolecule.setAtomCharge(n3, 0);
                    if (stereoMolecule.getConnAtoms(n3) == stereoMolecule.getAllConnAtoms(n3)) continue;
                    stereoMolecule.deleteAtom(stereoMolecule.getConnAtom(n3, stereoMolecule.getAllConnAtoms(n3) - 1));
                    stereoMolecule.ensureHelperArrays(7);
                    continue;
                }
                if (!stereoMolecule.isAromaticAtom(n3)) continue;
                objectArray = new boolean[stereoMolecule.getAtoms()];
                boolean[] blArray3 = new boolean[stereoMolecule.getBonds()];
                stereoMolecule.findRingSystem(n3, true, (boolean[])objectArray, blArray3);
                for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
                    if (objectArray[n2] == 0 || stereoMolecule.getAtomicNo(n2) != 7 || stereoMolecule.getAtomCharge(n2) != 0 || nArray[n2] != 2 || !MoleculeNeutralizer.removeHydrogenAndDelocalize(stereoMolecule, blArray3, n3, n2)) continue;
                    --n4;
                    continue block1;
                }
                continue;
            }
            if (stereoMolecule.getAtomCharge(n3) >= 0 || stereoMolecule.getAtomicNo(n3) != 6 && stereoMolecule.getAtomicNo(n3) != 7 && stereoMolecule.getAtomicNo(n3) != 8 && stereoMolecule.getAtomicNo(n3) != 16) continue;
            if (!blArray[n3]) {
                n4 -= stereoMolecule.getAtomCharge(n3);
                stereoMolecule.setAtomCharge(n3, 0);
                continue;
            }
            objectArray = new int[16];
            objectArray[0] = n3;
            int n12 = 1;
            for (n2 = 0; n2 < n12; ++n2) {
                for (n = 0; n < stereoMolecule.getAllBonds(); ++n) {
                    n11 = -1;
                    if (stereoMolecule.getBondAtom(0, n) == objectArray[n2]) {
                        n11 = stereoMolecule.getBondAtom(1, n);
                    } else if (stereoMolecule.getBondAtom(1, n) == objectArray[n2]) {
                        n11 = stereoMolecule.getBondAtom(0, n);
                    }
                    if (n11 == -1 || stereoMolecule.getAtomCharge(n11) == 0) continue;
                    n10 = 0;
                    for (n9 = 0; n9 < n12; ++n9) {
                        if (n11 != objectArray[n9]) continue;
                        n10 = 1;
                        break;
                    }
                    if (n10 != 0) continue;
                    if (n12 == objectArray.length) {
                        int[] nArray2 = new int[2 * objectArray.length];
                        System.arraycopy(objectArray, 0, nArray2, 0, objectArray.length);
                        objectArray = nArray2;
                    }
                    objectArray[n12++] = n11;
                }
            }
            n = 0;
            for (n11 = 0; n11 < n12; ++n11) {
                n += stereoMolecule.getAtomCharge(objectArray[n11]);
            }
            if (n >= 0) continue;
            n11 = -1;
            n10 = 99;
            for (n9 = 0; n9 < n12; ++n9) {
                if (stereoMolecule.getAtomCharge(objectArray[n9]) >= 0 || n10 <= MoleculeNeutralizer.electronegativity(stereoMolecule.getAtomicNo(objectArray[n9]))) continue;
                n10 = MoleculeNeutralizer.electronegativity(stereoMolecule.getAtomicNo(objectArray[n9]));
                n11 = objectArray[n9];
            }
            if (n11 == -1) continue;
            n4 -= stereoMolecule.getAtomCharge(n11);
            stereoMolecule.setAtomCharge(n11, 0);
        }
        if (blArray2 != null) {
            stereoMolecule.deleteAtoms(blArray2);
        }
        if (n4 > 0) {
            n4 = MoleculeNeutralizer.removeAcidicHydrogens(stereoMolecule, n4);
        }
        return n4;
    }

    private static boolean removeHydrogenAndDelocalize(StereoMolecule stereoMolecule, boolean[] blArray, int n, int n2) {
        int n3;
        int n4;
        int[] nArray = new int[stereoMolecule.getBonds()];
        boolean[] blArray2 = new boolean[stereoMolecule.getBonds()];
        for (n4 = 0; n4 < stereoMolecule.getBonds(); ++n4) {
            nArray[n4] = stereoMolecule.getBondType(n4);
            if (!blArray[n4]) continue;
            blArray2[n4] = true;
            stereoMolecule.setBondType(n4, 1);
        }
        for (n4 = 0; n4 < stereoMolecule.getAtoms(); ++n4) {
            if (n4 == n2 || stereoMolecule.getAtomPi(n4) != 0 || !blArray2[stereoMolecule.getConnBond(n2, 0)]) continue;
            for (n3 = 0; n3 < stereoMolecule.getConnAtoms(n4); ++n3) {
                int n5 = stereoMolecule.getConnBond(n4, n3);
                stereoMolecule.setBondType(n5, 1);
                blArray2[n5] = false;
            }
        }
        for (n4 = 0; n4 < stereoMolecule.getConnAtoms(n); ++n4) {
            n3 = stereoMolecule.getConnBond(n, n4);
            stereoMolecule.setBondType(n3, 1);
            blArray2[n3] = false;
        }
        if (new AromaticityResolver(stereoMolecule).locateDelocalizedDoubleBonds(blArray2)) {
            stereoMolecule.setAtomCharge(n, 0);
            if (stereoMolecule.getConnAtoms(n2) != stereoMolecule.getAllConnAtoms(n2)) {
                stereoMolecule.deleteAtom(stereoMolecule.getConnAtom(n2, stereoMolecule.getAllConnAtoms(n2) - 1));
            }
            stereoMolecule.ensureHelperArrays(7);
            return true;
        }
        for (n4 = 0; n4 < stereoMolecule.getBonds(); ++n4) {
            stereoMolecule.setBondType(n4, nArray[n4]);
        }
        return false;
    }

    private static int removeAcidicHydrogens(StereoMolecule stereoMolecule, int n) {
        if (n > 0) {
            n = MoleculeNeutralizer.removeHydrogensFromHalogene(stereoMolecule, n, 9);
        }
        if (n > 0) {
            n = MoleculeNeutralizer.removeHydrogensFromHalogene(stereoMolecule, n, 17);
        }
        if (n > 0) {
            n = MoleculeNeutralizer.removeHydrogensFromHalogene(stereoMolecule, n, 35);
        }
        if (n > 0) {
            n = MoleculeNeutralizer.removeHydrogensFromHalogene(stereoMolecule, n, 53);
        }
        if (n > 0) {
            for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
                if (stereoMolecule.getAtomCharge(i) <= 0) continue;
                boolean bl = false;
                for (int j = 0; j < stereoMolecule.getConnAtoms(i); ++j) {
                    int n2 = stereoMolecule.getConnAtom(i, j);
                    if (stereoMolecule.getAtomCharge(n2) != 0 || !stereoMolecule.isElectronegative(n2) || stereoMolecule.getImplicitHydrogens(n2) <= 0) continue;
                    stereoMolecule.setAtomCharge(n2, -1);
                    if (--n == 0) {
                        return 0;
                    }
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
        }
        if (n > 0) {
            n = MoleculeNeutralizer.removeAcidicHydrogensFromAcid(stereoMolecule, n, 8, 16);
        }
        if (n > 0) {
            n = MoleculeNeutralizer.removeAcidicHydrogensFromAcid(stereoMolecule, n, 8, 15);
        }
        if (n > 0) {
            n = MoleculeNeutralizer.removeAcidicHydrogensFromAcid(stereoMolecule, n, 8, 6);
        }
        if (n > 0) {
            n = MoleculeNeutralizer.removeAcidicHydrogensFromAcid(stereoMolecule, n, 7, 16);
        }
        return n;
    }

    private static int removeHydrogensFromHalogene(StereoMolecule stereoMolecule, int n, int n2) {
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != n2 || stereoMolecule.getAtomCharge(i) != 0 || stereoMolecule.getConnAtoms(i) != 0) continue;
            stereoMolecule.setAtomCharge(i, -1);
            if (--n != 0) continue;
            return 0;
        }
        return n;
    }

    private static int removeAcidicHydrogensFromAcid(StereoMolecule stereoMolecule, int n, int n2, int n3) {
        block0: for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != n2 || stereoMolecule.getAtomCharge(i) != 0 || stereoMolecule.getImplicitHydrogens(i) <= 0) continue;
            boolean bl = false;
            for (int j = 0; j < stereoMolecule.getConnAtoms(i); ++j) {
                int n4;
                if (stereoMolecule.getConnBondOrder(i, j) == 1 && stereoMolecule.getAtomicNo(n4 = stereoMolecule.getConnAtom(i, j)) == n3) {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (int k = 0; k < stereoMolecule.getConnAtoms(n4); ++k) {
                        int n5 = stereoMolecule.getConnAtom(n4, k);
                        if (stereoMolecule.getAtomCharge(n5) < 0) {
                            bl3 = true;
                            break;
                        }
                        if (n5 == i || stereoMolecule.getAtomicNo(n5) != 8 || stereoMolecule.getConnBondOrder(n4, k) != 2) continue;
                        bl2 = true;
                    }
                    if (!bl3 && bl2) {
                        stereoMolecule.setAtomCharge(i, -1);
                        if (--n == 0) {
                            return 0;
                        }
                        bl = true;
                    }
                }
                if (bl) continue block0;
            }
        }
        return n;
    }

    private static int electronegativity(int n) {
        switch (n) {
            case 6: {
                return 1;
            }
            case 53: {
                return 2;
            }
            case 33: {
                return 3;
            }
            case 34: {
                return 4;
            }
            case 35: {
                return 5;
            }
            case 15: {
                return 6;
            }
            case 16: {
                return 7;
            }
            case 17: {
                return 8;
            }
            case 7: {
                return 9;
            }
            case 8: {
                return 10;
            }
            case 9: {
                return 11;
            }
        }
        return 0;
    }
}

