/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import java.io.Serializable;
import java.util.ArrayList;

public class MarkushStructure
implements Serializable {
    static final long serialVersionUID = 537396501L;
    private static final int MAX_RGROUP_DEPTH = 5;
    private ArrayList<StereoMolecule> mCoreList = new ArrayList();
    private ArrayList<StereoMolecule> mRGroupList = new ArrayList();
    private StereoMolecule[][] mSubstituent;
    private int mCoreIndex;
    private int[] mSubstituentCount;
    private int[] mSubstituentIndex;
    private int[][] mCoreRGroup;
    private int[][][] mSubstituentRGroup;

    public MarkushStructure() {
    }

    public MarkushStructure(StereoMolecule[] stereoMoleculeArray, int n) {
        this();
        if (stereoMoleculeArray != null) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                this.mCoreList.add(stereoMoleculeArray[n2]);
            }
            for (n2 = n; n2 < stereoMoleculeArray.length; ++n2) {
                this.mRGroupList.add(stereoMoleculeArray[n2]);
            }
        }
    }

    public StereoMolecule getCoreStructure(int n) {
        return this.mCoreList.get(n);
    }

    public int getCoreCount() {
        return this.mCoreList.size();
    }

    public StereoMolecule getRGroup(int n) {
        return this.mRGroupList.get(n);
    }

    public int getRGroupCount() {
        return this.mRGroupList.size();
    }

    public void addCore(StereoMolecule stereoMolecule) {
        this.mCoreList.add(stereoMolecule);
    }

    public void addRGroup(StereoMolecule stereoMolecule) {
        this.mRGroupList.add(stereoMolecule);
    }

    public String validate() throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.mCoreList.size() == 0) {
            throw new Exception("You didn't define a core structure.");
        }
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        this.mCoreRGroup = new int[this.mCoreList.size()][];
        for (int i = 0; i < this.mCoreList.size() + this.mRGroupList.size(); ++i) {
            StereoMolecule stereoMolecule = i < this.mCoreList.size() ? this.mCoreList.get(i) : this.mRGroupList.get(i - this.mCoreList.size());
            stereoMolecule.ensureHelperArrays(1);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (n5 = 0; n5 < stereoMolecule.getAllAtoms(); ++n5) {
                int n9 = this.getRGroupIndex(stereoMolecule.getAtomicNo(n5));
                if (n9 == -1) continue;
                if (stereoMolecule.getConnAtoms(n5) != 1) {
                    throw new Exception("R" + (n9 + 1) + " has multiple neighbours.");
                }
                n7 = Math.max(n7, n9);
                n4 = 1 << n9;
                if ((n6 & n4) == 0) {
                    n6 |= n4;
                    ++n8;
                }
                if (i >= this.mCoreList.size()) continue;
                arrayList.add(new Integer(n9));
            }
            if (i >= this.mCoreList.size()) continue;
            this.mCoreRGroup[i] = new int[arrayList.size()];
            for (n5 = 0; n5 < arrayList.size(); ++n5) {
                this.mCoreRGroup[i][n5] = (Integer)arrayList.get(n5);
            }
        }
        if (n7 >= this.mRGroupList.size()) {
            throw new Exception("Not all used R-groups are defined.");
        }
        String string = null;
        if (n8 < this.mRGroupList.size()) {
            string = "One or more defined R-group(s) are unreferenced.";
        }
        this.mSubstituent = new StereoMolecule[this.mRGroupList.size()][];
        this.mSubstituentRGroup = new int[this.mRGroupList.size()][][];
        for (n3 = 0; n3 < this.mRGroupList.size(); ++n3) {
            this.mSubstituent[n3] = this.mRGroupList.get(n3).getFragments();
            this.mSubstituentRGroup[n3] = new int[this.mSubstituent[n3].length][];
            for (int i = 0; i < this.mSubstituent[n3].length; ++i) {
                this.mSubstituent[n3][i].ensureHelperArrays(1);
                n5 = 0;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (n4 = 0; n4 < this.mSubstituent[n3][i].getAllAtoms(); ++n4) {
                    if (this.mSubstituent[n3][i].getAtomicNo(n4) == 0) {
                        if (n5 != 0) {
                            throw new Exception("Variation " + (i + 1) + " of R" + (n3 + 1) + " has multiple attachment points.");
                        }
                        if (this.mSubstituent[n3][i].getConnAtoms(n4) != 1) {
                            throw new Exception("The attachment point of variation " + (i + 1) + " of R" + (n3 + 1) + " has multiple neighbours.");
                        }
                        n5 = 1;
                        continue;
                    }
                    n2 = this.getRGroupIndex(this.mSubstituent[n3][i].getAtomicNo(n4));
                    if (n2 == -1) continue;
                    arrayList.add(new Integer(n2));
                }
                if (n5 == 0) {
                    throw new Exception("Variation " + (i + 1) + " of R" + (n3 + 1) + " has no attachment point ('?'-atom).");
                }
                this.mSubstituentRGroup[n3][i] = new int[arrayList.size()];
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    this.mSubstituentRGroup[n3][i][n4] = (Integer)arrayList.get(n4);
                }
            }
        }
        n3 = 0;
        for (n = 0; n < this.mCoreRGroup.length; ++n) {
            for (n5 = 0; n5 < this.mCoreRGroup[n].length; ++n5) {
                n3 |= 1 << this.mCoreRGroup[n][n5];
            }
        }
        n = n3;
        for (n5 = 1; n5 <= 5; ++n5) {
            int n10 = 0;
            for (n4 = 0; n4 <= n7; ++n4) {
                if ((n & 1 << n4) == 0) continue;
                for (n2 = 0; n2 < this.mSubstituentRGroup[n4].length; ++n2) {
                    for (int i = 0; i < this.mSubstituentRGroup[n4][n2].length; ++i) {
                        n10 |= 1 << this.mSubstituentRGroup[n4][n2][i];
                        n3 |= 1 << this.mSubstituentRGroup[n4][n2][i];
                    }
                }
            }
            if (n10 == 0) break;
            if (n5 == 5) {
                throw new Exception("R-Groups are recursively definined or maximum depth of indirection (5) exceeded");
            }
            n = n10;
        }
        this.mSubstituentCount = new int[this.mRGroupList.size()];
        for (n5 = 0; n5 < this.mRGroupList.size(); ++n5) {
            this.mSubstituentCount[n5] = (n3 & 1 << n5) == 0 ? 0 : this.mSubstituent[n5].length;
        }
        this.mSubstituentIndex = new int[this.mRGroupList.size()];
        this.mCoreIndex = 0;
        return string;
    }

    public StereoMolecule getNextEnumeration() {
        if (this.mCoreIndex == this.mCoreList.size()) {
            return null;
        }
        StereoMolecule stereoMolecule = this.createCurrentEnumeration();
        boolean bl = true;
        for (int i = 0; i < this.mRGroupList.size(); ++i) {
            if (this.mSubstituentCount[i] <= 1) continue;
            if (this.mSubstituentIndex[i] + 1 < this.mSubstituentCount[i]) {
                int n = i;
                this.mSubstituentIndex[n] = this.mSubstituentIndex[n] + 1;
                bl = false;
                break;
            }
            this.mSubstituentIndex[i] = 0;
        }
        if (bl) {
            ++this.mCoreIndex;
        }
        return stereoMolecule;
    }

    private int getRGroupIndex(int n) {
        if (n < 129 || n > 144) {
            return -1;
        }
        return n >= 142 ? n - 142 : n - 126;
    }

    private StereoMolecule createCurrentEnumeration() {
        int n;
        int n2;
        StereoMolecule stereoMolecule = new StereoMolecule();
        stereoMolecule.addMolecule(this.mCoreList.get(this.mCoreIndex));
        for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
            n = this.getRGroupIndex(stereoMolecule.getAtomicNo(n2));
            if (n == -1) continue;
            stereoMolecule.addSubstituent(this.mSubstituent[n][this.mSubstituentIndex[n]], this.getAttachmentAtom(stereoMolecule, n2));
        }
        for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
            stereoMolecule.setAtomSelection(n2, this.getRGroupIndex(stereoMolecule.getAtomicNo(n2)) != -1);
        }
        stereoMolecule.deleteSelectedAtoms();
        n2 = this.mCoreList.get(this.mCoreIndex).getAllAtoms() - this.mCoreRGroup[this.mCoreIndex].length;
        for (n = 0; n < n2; ++n) {
            stereoMolecule.setAtomMarker(n, true);
        }
        new CoordinateInventor(10).invent(stereoMolecule);
        return stereoMolecule;
    }

    private int getAttachmentAtom(Molecule molecule, int n) {
        for (int i = 0; i < molecule.getAllBonds(); ++i) {
            if (molecule.getBondAtom(0, i) == n) {
                return molecule.getBondAtom(1, i);
            }
            if (molecule.getBondAtom(1, i) != n) continue;
            return molecule.getBondAtom(0, i);
        }
        return -1;
    }
}

