/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.util.Formatter;
import java.util.Comparator;

public class Element {
    private int orderNumber;
    private String name;
    private String symbol;
    private double weight;
    private double covalentRadius;
    private double vdwRadius;
    private double electronegativity;

    public Element() {
    }

    public Element(int n, String string, String string2, double d, double d2, double d3, double d4) {
        this.orderNumber = n;
        this.name = string;
        this.symbol = string2;
        this.weight = d;
        this.covalentRadius = d2;
        this.vdwRadius = d3;
        this.electronegativity = d4;
    }

    public int getOrderNumber() {
        return this.orderNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public double getWeight() {
        return this.weight;
    }

    public double getCovalentRadius() {
        return this.covalentRadius;
    }

    public double getVDWRadius() {
        return this.vdwRadius;
    }

    public double getElectronegativity() {
        return this.electronegativity;
    }

    public void setElectronegativity(double d) {
        this.electronegativity = d;
    }

    public String toString() {
        return this.symbol;
    }

    public String toStringForValueTable() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("new Element(");
        stringBuilder.append(this.orderNumber);
        stringBuilder.append(",");
        stringBuilder.append("\"" + this.name + "\"");
        stringBuilder.append(",");
        stringBuilder.append("\"" + this.symbol + "\"");
        stringBuilder.append(",");
        stringBuilder.append(Formatter.format3(this.weight));
        stringBuilder.append(",");
        stringBuilder.append(Formatter.format3(this.covalentRadius));
        stringBuilder.append(",");
        stringBuilder.append(Formatter.format3(this.vdwRadius));
        stringBuilder.append(",");
        stringBuilder.append(Formatter.format3(this.electronegativity));
        stringBuilder.append("),");
        return stringBuilder.toString();
    }

    public static Comparator<Element> getComparatorOrderNumber() {
        return new Comparator<Element>(){

            @Override
            public int compare(Element element, Element element2) {
                int n = 0;
                if (element.getOrderNumber() > element2.getOrderNumber()) {
                    n = 1;
                } else if (element.getOrderNumber() < element2.getOrderNumber()) {
                    n = -1;
                }
                return n;
            }
        };
    }
}

