/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Random;

public final class Coordinates
implements Serializable,
Comparable<Coordinates> {
    public double x;
    public double y;
    public double z;

    public Coordinates() {
    }

    public Coordinates(Coordinates coordinates) {
        this(coordinates.x, coordinates.y, coordinates.z);
    }

    public Coordinates(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Coordinates set(Coordinates coordinates) {
        this.set(coordinates.x, coordinates.y, coordinates.z);
        return this;
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double getLength() {
        return this.dist();
    }

    public final double dist() {
        return Math.sqrt(this.distSq());
    }

    public final double distSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final double distanceSquared(Coordinates coordinates) {
        return (coordinates.x - this.x) * (coordinates.x - this.x) + (coordinates.y - this.y) * (coordinates.y - this.y) + (coordinates.z - this.z) * (coordinates.z - this.z);
    }

    public final double distSquareTo(Coordinates coordinates) {
        return this.distanceSquared(coordinates);
    }

    public final double distance(Coordinates coordinates) {
        return Math.sqrt(this.distanceSquared(coordinates));
    }

    public final double dot(Coordinates coordinates) {
        return this.x * coordinates.x + this.y * coordinates.y + this.z * coordinates.z;
    }

    public final Coordinates cross(Coordinates coordinates) {
        return new Coordinates(this.y * coordinates.z - this.z * coordinates.y, -(this.x * coordinates.z - this.z * coordinates.x), this.x * coordinates.y - this.y * coordinates.x);
    }

    public final double getAngle(Coordinates coordinates) {
        double d = this.distSq();
        double d2 = coordinates.distSq();
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.dot(coordinates) / Math.sqrt(d * d2);
        if (d3 >= 1.0) {
            return 0.0;
        }
        if (d3 <= -1.0) {
            return Math.PI;
        }
        return Math.acos(d3);
    }

    public double getAngleXY(Coordinates coordinates) {
        double d = coordinates.x - this.x;
        double d2 = coordinates.y - this.y;
        if (d2 == 0.0) {
            return d > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double d3 = Math.atan(d / d2);
        if (d2 < 0.0) {
            return d < 0.0 ? d3 - Math.PI : d3 + Math.PI;
        }
        return d3;
    }

    public final double getDihedral(Coordinates coordinates, Coordinates coordinates2, Coordinates coordinates3) {
        return Coordinates.getDihedral(this, coordinates, coordinates2, coordinates3);
    }

    public final Coordinates subC(Coordinates coordinates) {
        return new Coordinates(this.x - coordinates.x, this.y - coordinates.y, this.z - coordinates.z);
    }

    public final Coordinates addC(Coordinates coordinates) {
        return new Coordinates(this.x + coordinates.x, this.y + coordinates.y, this.z + coordinates.z);
    }

    public final Coordinates scaleC(double d) {
        return new Coordinates(this.x * d, this.y * d, this.z * d);
    }

    public final Coordinates sub(Coordinates coordinates) {
        this.x -= coordinates.x;
        this.y -= coordinates.y;
        this.z -= coordinates.z;
        return this;
    }

    public final Coordinates add(Coordinates coordinates) {
        this.x += coordinates.x;
        this.y += coordinates.y;
        this.z += coordinates.z;
        return this;
    }

    public void add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
    }

    public final Coordinates scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public Coordinates rotate(double[][] dArray) {
        double d = this.x;
        double d2 = this.y;
        double d3 = this.z;
        this.x = d * dArray[0][0] + d2 * dArray[1][0] + d3 * dArray[2][0];
        this.y = d * dArray[0][1] + d2 * dArray[1][1] + d3 * dArray[2][1];
        this.z = d * dArray[0][2] + d2 * dArray[1][2] + d3 * dArray[2][2];
        return this;
    }

    public Coordinates rotateC(double[][] dArray) {
        return new Coordinates(this.x * dArray[0][0] + this.y * dArray[1][0] + this.z * dArray[2][0], this.x * dArray[0][1] + this.y * dArray[1][1] + this.z * dArray[2][1], this.x * dArray[0][2] + this.y * dArray[1][2] + this.z * dArray[2][2]);
    }

    public final Coordinates rotate(Coordinates coordinates, double d) {
        if (Math.abs(coordinates.x * coordinates.x + coordinates.y * coordinates.y + coordinates.z * coordinates.z - 1.0) > 1.0E-6) {
            throw new IllegalArgumentException("normal needs to a unit vector: " + coordinates);
        }
        double d2 = coordinates.x;
        double d3 = coordinates.y;
        double d4 = coordinates.z;
        double d5 = Math.cos(d);
        double d6 = Math.sin(d);
        double d7 = 1.0 - d5;
        Coordinates coordinates2 = new Coordinates((d7 * d2 * d2 + d5) * this.x + (d7 * d2 * d3 + d6 * d4) * this.y + (d7 * d2 * d4 - d6 * d3) * this.z, (d7 * d2 * d3 - d6 * d4) * this.x + (d7 * d3 * d3 + d5) * this.y + (d7 * d3 * d4 + d6 * d2) * this.z, (d7 * d2 * d4 + d6 * d3) * this.x + (d7 * d4 * d3 - d6 * d2) * this.y + (d7 * d4 * d4 + d5) * this.z);
        return coordinates2;
    }

    public final Coordinates unitC() {
        double d = this.dist();
        if (d == 0.0) {
            System.err.println("Cannot call unitC() on a null vector");
            return new Coordinates(1.0, 0.0, 0.0);
        }
        return new Coordinates(this.x / d, this.y / d, this.z / d);
    }

    public final Coordinates unit() {
        double d = this.dist();
        if (d == 0.0) {
            System.err.println("Cannot call unit() on a null vector. Returned (1,0,0)");
            this.x = 1.0;
            this.y = 0.0;
            this.z = 0.0;
            return this;
        }
        this.x /= d;
        this.y /= d;
        this.z /= d;
        return this;
    }

    public Coordinates center(Coordinates coordinates) {
        this.x = (this.x + coordinates.x) / 2.0;
        this.y = (this.y + coordinates.y) / 2.0;
        this.z = (this.z + coordinates.z) / 2.0;
        return this;
    }

    public void center(Coordinates coordinates, Coordinates coordinates2) {
        this.x = (coordinates.x + coordinates2.x) / 2.0;
        this.y = (coordinates.y + coordinates2.y) / 2.0;
        this.z = (coordinates.z + coordinates2.z) / 2.0;
    }

    public Coordinates between(Coordinates coordinates, Coordinates coordinates2, double d) {
        this.x = coordinates.x + d * (coordinates2.x - coordinates.x);
        this.y = coordinates.y + d * (coordinates2.y - coordinates.y);
        this.z = coordinates.z + d * (coordinates2.z - coordinates.z);
        return this;
    }

    public final boolean insideBounds(Coordinates[] coordinatesArray) {
        return coordinatesArray != null && coordinatesArray[0].x <= this.x && this.x <= coordinatesArray[1].x && coordinatesArray[0].y <= this.y && this.y <= coordinatesArray[1].y && coordinatesArray[0].z <= this.z && this.z <= coordinatesArray[1].z;
    }

    public final String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        return "[" + decimalFormat.format(this.x) + ", " + decimalFormat.format(this.y) + ", " + decimalFormat.format(this.z) + "]";
    }

    public final String toStringSpaceDelimited() {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        return decimalFormat.format(this.x) + " " + decimalFormat.format(this.y) + " " + decimalFormat.format(this.z);
    }

    public final String toStringSpaceDelimited(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        decimalFormat.applyPattern("0.00");
        return decimalFormat.format(this.x) + " " + decimalFormat.format(this.y) + " " + decimalFormat.format(this.z);
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof Coordinates)) {
            return false;
        }
        Coordinates coordinates = (Coordinates)object;
        return Math.abs(coordinates.x - this.x) + Math.abs(coordinates.y - this.y) + Math.abs(coordinates.z - this.z) < 1.0E-6;
    }

    public final boolean isNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z);
    }

    public final Coordinates min(Coordinates coordinates) {
        return new Coordinates(Math.min(this.x, coordinates.x), Math.min(this.y, coordinates.y), Math.min(this.z, coordinates.z));
    }

    public final Coordinates max(Coordinates coordinates) {
        return new Coordinates(Math.max(this.x, coordinates.x), Math.max(this.y, coordinates.y), Math.max(this.z, coordinates.z));
    }

    public double cosAngle(Coordinates coordinates) {
        double d = this.dist() * coordinates.dist();
        if (d <= 0.0) {
            return 0.0;
        }
        return this.dot(coordinates) / d;
    }

    public static final Coordinates min(Coordinates[] coordinatesArray) {
        Coordinates coordinates = new Coordinates(coordinatesArray[0]);
        for (int i = 1; i < coordinatesArray.length; ++i) {
            coordinates.x = Math.min(coordinatesArray[i].x, coordinates.x);
            coordinates.y = Math.min(coordinatesArray[i].y, coordinates.y);
            coordinates.z = Math.min(coordinatesArray[i].z, coordinates.z);
        }
        return coordinates;
    }

    public static final Coordinates max(Coordinates[] coordinatesArray) {
        Coordinates coordinates = new Coordinates(coordinatesArray[0]);
        for (int i = 1; i < coordinatesArray.length; ++i) {
            coordinates.x = Math.max(coordinatesArray[i].x, coordinates.x);
            coordinates.y = Math.max(coordinatesArray[i].y, coordinates.y);
            coordinates.z = Math.max(coordinatesArray[i].z, coordinates.z);
        }
        return coordinates;
    }

    public static final Coordinates createBarycenter(Coordinates ... coordinatesArray) {
        if (coordinatesArray == null) {
            throw new IllegalArgumentException("The coordinates are null");
        }
        Coordinates coordinates = new Coordinates();
        for (int i = 0; i < coordinatesArray.length; ++i) {
            coordinates.x += coordinatesArray[i].x;
            coordinates.y += coordinatesArray[i].y;
            coordinates.z += coordinatesArray[i].z;
        }
        coordinates.x /= (double)coordinatesArray.length;
        coordinates.y /= (double)coordinatesArray.length;
        coordinates.z /= (double)coordinatesArray.length;
        return coordinates;
    }

    public static final Coordinates getMirror(Coordinates coordinates, Coordinates coordinates2, Coordinates coordinates3, Coordinates coordinates4) {
        Coordinates coordinates5 = new Coordinates(coordinates4);
        coordinates5.sub(coordinates2);
        Coordinates coordinates6 = new Coordinates(coordinates3);
        coordinates6.sub(coordinates2);
        Coordinates coordinates7 = coordinates5.cross(coordinates6);
        if (coordinates7.distSq() < 0.05) {
            return new Coordinates(coordinates);
        }
        Coordinates coordinates8 = coordinates7.unitC();
        Coordinates coordinates9 = new Coordinates(coordinates2);
        coordinates9.sub(coordinates);
        double d = coordinates9.dot(coordinates8);
        coordinates8.scale(2.0 * d);
        Coordinates coordinates10 = new Coordinates(coordinates);
        coordinates10.add(coordinates8);
        return coordinates10;
    }

    public static final double getDihedral(Coordinates coordinates, Coordinates coordinates2, Coordinates coordinates3, Coordinates coordinates4) {
        Coordinates coordinates5 = coordinates2.subC(coordinates);
        Coordinates coordinates6 = coordinates3.subC(coordinates2);
        Coordinates coordinates7 = coordinates4.subC(coordinates3);
        Coordinates coordinates8 = coordinates5.cross(coordinates6);
        Coordinates coordinates9 = coordinates6.cross(coordinates7);
        return -Math.atan2(coordinates6.getLength() * coordinates5.dot(coordinates9), coordinates8.dot(coordinates9));
    }

    @Override
    public int compareTo(Coordinates coordinates) {
        if (this.x != coordinates.x) {
            return this.x < coordinates.x ? -1 : 1;
        }
        if (this.y != coordinates.y) {
            return this.y < coordinates.y ? -1 : 1;
        }
        if (this.z != coordinates.z) {
            return this.z < coordinates.z ? -1 : 1;
        }
        return 0;
    }

    public static final Coordinates random() {
        Random random = new Random();
        return new Coordinates(random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 2.0 - 1.0, random.nextDouble() * 2.0 - 1.0);
    }

    public static double getRmsd(Coordinates[] coordinatesArray, Coordinates[] coordinatesArray2) {
        return Coordinates.getRmsd(coordinatesArray, coordinatesArray2, Math.min(coordinatesArray.length, coordinatesArray2.length));
    }

    public static double getRmsd(Coordinates[] coordinatesArray, Coordinates[] coordinatesArray2, int n) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += coordinatesArray[i].distanceSquared(coordinatesArray2[i]);
        }
        return n > 0 ? Math.sqrt(d / (double)n) : 0.0;
    }
}

