/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.gui.editor.AtomQueryFeatureDialogBuilder;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericPolygon;
import com.actelion.research.gui.generic.GenericRectangle;
import com.actelion.research.util.ColorHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractDepictor<T> {
    private static final int[] ATOM_LABEL_COLOR = new int[]{0, 0xFFFFFF, 0xD9FFFF, 13402367, 12779264, 0xFFB5B5, 0x909090, 3166456, 0xFF0D0D, 9494608, 11789301, 11230450, 9109248, 12560038, 15780000, 0xFF8000, 0xFFFF30, 0x1FF01F, 8442339, 9388244, 4062976, 0xE6E6E6, 12567239, 0xA6A6AB, 9083335, 10255047, 14706227, 15765664, 0x50D050, 13140019, 8224944, 12750735, 0x668F8F, 12419299, 16752896, 10889513, 6076625, 7351984, 65280, 0x94FFFF, 9756896, 7586505, 0x54B5B5, 3907230, 2396047, 687500, 27013, 0xC0C0C0, 16767375, 10909043, 0x668080, 10380213, 13924864, 0x940094, 4366000, 5707663, 51456, 7394559, 0xFFFFC7, 14286791, 0xC7FFC7, 10747847, 9437127, 6422471, 4587463, 3211207, 2097095, 65436, 58997, 54354, 48952, 43812, 5096191, 5089023, 2200790, 2522539, 0x266696, 1528967, 0xD0D0E0, 16765219, 12105936, 10900557, 5724513, 10375093, 11230208, 7688005, 4358806, 4325478, 32000, 7384058, 47871, 41471, 36863, 33023, 27647, 5528818, 7888099, 9064419, 10565332, 11739092, 11739066, 11734438, 12389767, 13041766, 13369433, 13697103, 14221381, 14680120, 15073326, 15400998, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0xC8C8C8, 1334015, 56540, 15075850, 0xE6E600, 56540, 15075850, 0xEBEBEB, 0x8282D2, 1016335, 1016335, 1334015, 0xE6E600, 0x3232AA, 14456450, 16422400, 16422400, 11819700, 0x3232AA, 1016335};
    private static final int BOND_FG_HILITE_COLOR = Short.MIN_VALUE;
    private static final int BOND_BG_HILITE_COLOR = -10706689;
    private static final int FG_EXCLUDE_GROUP_COLOR = -6291392;
    private static final int BG_EXCLUDE_GROUP_COLOR = -24321;
    private static final int COLOR_SELECTED = 128;
    private static final int COLOR_CIP_LETTER = 448;
    private static final int COLOR_CHIRALITY_TEXT = 448;
    private static final int COLOR_UNDEFINED = -1;
    private static final int COLOR_HILITE_BOND_BG = -2;
    private static final int COLOR_HILITE_BOND_FG = -3;
    private static final int COLOR_OVERRULED = -4;
    private static final int COLOR_RGB = -5;
    private static final int COLOR_CUSTOM_FOREGROUND = -6;
    private static final int COLOR_EXCLUDE_GROUP_BG = -7;
    private static final int COLOR_EXCLUDE_GROUP_FG = -8;
    private static final int COLOR_RESTORE_PREVIOUS = -9;
    private static final int COLOR_INITIALIZE = -10;
    public static final int COLOR_BLUE = -14655233;
    public static final int COLOR_RED = -65536;
    public static final int COLOR_GREEN = -16711936;
    public static final int COLOR_MAGENTA = -4194049;
    public static final int COLOR_ORANGE = -24576;
    public static final int COLOR_DARK_GREEN = -16744448;
    public static final int COLOR_DARK_RED = -6291456;
    public static final int cOptAvBondLen = 24;
    public static final int cColorGray = 1;
    protected static final int cModeMaxBondLength = 65535;
    protected static final int cModeInflateToAVBL = 196608;
    private static final int cModeChiralTextLocation = 786432;
    public static final int cModeInflateToMaxAVBL = 65536;
    public static final int cModeInflateToHighResAVBL = 131072;
    public static final int cModeChiralTextBelowMolecule = 0;
    public static final int cModeChiralTextAboveMolecule = 262144;
    public static final int cModeChiralTextOnFrameTop = 524288;
    public static final int cModeChiralTextOnFrameBottom = 786432;
    public static final int cDModeNoTabus = 1;
    public static final int cDModeAtomNo = 2;
    public static final int cDModeBondNo = 4;
    public static final int cDModeHiliteAllQueryFeatures = 8;
    public static final int cDModeShowMapping = 16;
    public static final int cDModeSuppressChiralText = 32;
    public static final int cDModeSuppressCIPParity = 64;
    public static final int cDModeSuppressESR = 128;
    private static final int cDModeShowSymmetryAny = 768;
    public static final int cDModeShowSymmetrySimple = 256;
    public static final int cDModeShowSymmetryStereoHeterotopicity = 512;
    public static final int cDModeNoImplicitAtomLabelColors = 1024;
    public static final int cDModeNoStereoProblem = 2048;
    public static final int cDModeNoColorOnESRAndCIP = 4096;
    public static final int cDModeNoImplicitHydrogen = 8192;
    public static final int cDModeDrawBondsInGray = 16384;
    public static final int cDModeBHNoSimpleHydrogens = 0x100000;
    private static final double cFactorTextSize = 0.6;
    private static final double cFactorChiralTextSize = 0.5;
    private static final double cFactorBondSpacing = 0.15;
    private static final double cFactorBondHiliteRadius = 0.38;
    private static final double cFactorExcludeGroupRadius = 0.47;
    private static final double cFactorDotDiameter = 0.12;
    private static final double cFactorQFDiameter = 0.4;
    private static final double cFactorLineWidth = 0.06;
    private boolean[] mAtomIsConnected;
    private boolean[] mAtomLabelDisplayed;
    private double mpBondSpacing;
    private double mpDotDiameter;
    private double mpLineWidth;
    private double mpQFDiameter;
    private double mpBondHiliteRadius;
    private double mFactorTextSize;
    private double mpExcludeGroupRadius;
    private double mChiralTextSize;
    private int mpLabelSize;
    private int mStandardForegroundColor;
    private int mDisplayMode;
    private int mCurrentColor;
    private int mPreviousColor;
    private boolean mIsValidatingView;
    private ArrayList<GenericRectangle> mpTabuZone;
    private ArrayList<DepictorDot> mpDot;
    private StereoMolecule mMol;
    private GenericRectangle mBoundingRect = new GenericRectangle();
    private DepictorTransformation mTransformation;
    private GenericPoint mChiralTextLocation;
    private int[] mAtomColor;
    private int[] mAtomHiliteColor;
    private float[] mAtomHiliteRadius;
    private String[] mAtomText;
    private GenericPoint[] mAlternativeCoords;
    private int mOverruleForeground;
    private int mOverruleBackground;
    private int mBondBGHiliteColor;
    private int mBondFGHiliteColor;
    private int mExcludeGroupFGColor;
    private int mExcludeGroupBGColor;
    private int mCustomForeground;
    private int mCustomBackground;
    private int mRGBColor;
    protected T mContext;
    private boolean noSimpleH;

    public AbstractDepictor(StereoMolecule stereoMolecule) {
        this(stereoMolecule, 0);
    }

    public AbstractDepictor(StereoMolecule stereoMolecule, int n) {
        this.mMol = stereoMolecule;
        this.mDisplayMode = n;
        this.init();
    }

    public void setDisplayMode(int n) {
        this.mDisplayMode = n;
    }

    public void setAtomText(String[] stringArray) {
        this.mAtomText = stringArray;
    }

    @Deprecated
    public void setForegroundColor(Color color, Color color2) {
        this.setForegroundColor(color == null ? 0 : color.getRGB(), color2 == null ? 0 : color2.getRGB());
    }

    public void setForegroundColor(int n, int n2) {
        this.mStandardForegroundColor = -6;
        this.mCustomForeground = n;
        this.mCustomBackground = n2;
        this.updateBondHiliteColor();
    }

    @Deprecated
    public void setOverruleColor(Color color, Color color2) {
        this.setOverruleColor(color == null ? 0 : color.getRGB(), color2 == null ? 0 : color2.getRGB());
    }

    public void setOverruleColor(int n, int n2) {
        this.mOverruleForeground = n;
        this.mOverruleBackground = n2;
        this.updateBondHiliteColor();
    }

    public void setAtomHighlightColors(int[] nArray, float[] fArray) {
        this.mAtomHiliteColor = nArray;
        this.mAtomHiliteRadius = fArray;
    }

    public void setTransformation(DepictorTransformation depictorTransformation) {
        this.mTransformation = depictorTransformation;
    }

    public void setFactorTextSize(double d) {
        this.mFactorTextSize = d;
    }

    public DepictorTransformation getTransformation() {
        return this.mTransformation;
    }

    public void applyTransformation(DepictorTransformation depictorTransformation) {
        depictorTransformation.applyTo(this.mTransformation);
        depictorTransformation.applyTo(this.mBoundingRect);
        depictorTransformation.applyTo(this.mChiralTextLocation);
    }

    public DepictorTransformation updateCoords(T t, GenericRectangle genericRectangle, int n) {
        this.validateView(t, genericRectangle, n);
        if (this.mTransformation.isVoidTransformation()) {
            return null;
        }
        DepictorTransformation depictorTransformation = this.mTransformation;
        this.mTransformation.applyTo(this.mMol);
        this.mTransformation = new DepictorTransformation();
        return depictorTransformation;
    }

    public DepictorTransformation simpleUpdateCoords(GenericRectangle genericRectangle, int n) {
        this.simpleValidateView(genericRectangle, n);
        if (this.mTransformation.isVoidTransformation()) {
            return null;
        }
        DepictorTransformation depictorTransformation = this.mTransformation;
        this.mTransformation.applyTo(this.mMol);
        this.mTransformation = new DepictorTransformation();
        return depictorTransformation;
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public DepictorTransformation validateView(T t, GenericRectangle genericRectangle, int n) {
        if (this.mMol.getAllAtoms() == 0) {
            return null;
        }
        this.noSimpleH = (this.mDisplayMode & 0x100000) == 0x100000;
        this.mMol.ensureHelperArrays(this.requiredHelperArrays());
        DepictorTransformation depictorTransformation = this.simpleValidateView(genericRectangle, n);
        this.markIsolatedAtoms();
        this.mpDot.clear();
        this.mpTabuZone.clear();
        this.mContext = t;
        this.calculateParameters();
        this.mpSetNormalLabelSize();
        this.mIsValidatingView = true;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            this.mpDrawAtom(i, null);
        }
        this.mIsValidatingView = false;
        double d = this.mTransformation.getScaling() * this.mMol.getAverageBondLength();
        this.expandBoundsByTabuZones(d);
        this.setChiralTextLocation(genericRectangle, d, n);
        if (genericRectangle == null || genericRectangle.contains(this.mBoundingRect)) {
            return depictorTransformation;
        }
        DepictorTransformation depictorTransformation2 = new DepictorTransformation(this.mBoundingRect, genericRectangle, d, n);
        depictorTransformation2.applyTo(this.mTransformation);
        depictorTransformation2.applyTo(this.mBoundingRect);
        depictorTransformation2.applyTo(this.mChiralTextLocation);
        if (depictorTransformation == null) {
            return depictorTransformation2;
        }
        depictorTransformation2.applyTo(depictorTransformation);
        return depictorTransformation;
    }

    public DepictorTransformation simpleValidateView(GenericRectangle genericRectangle, int n) {
        if (this.mMol.getAllAtoms() == 0) {
            return null;
        }
        this.mBoundingRect = this.simpleCalculateBounds();
        double d = this.mTransformation.getScaling() * this.mMol.getAverageBondLength();
        DepictorTransformation depictorTransformation = new DepictorTransformation(this.mBoundingRect, genericRectangle, d, n);
        if (depictorTransformation.isVoidTransformation()) {
            depictorTransformation = null;
        } else {
            depictorTransformation.applyTo(this.mTransformation);
            depictorTransformation.applyTo(this.mBoundingRect);
        }
        this.setChiralTextLocation(genericRectangle, d, n);
        return depictorTransformation;
    }

    protected void onDrawBond(int n, double d, double d2, double d3, double d4) {
    }

    protected void onDrawAtom(int n, String string, double d, double d2) {
    }

    public GenericRectangle simpleCalculateBounds() {
        int n;
        double d = Double.NaN;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
        }
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            if (this.noSimpleH && this.isSimpleH(n, -1)) continue;
            if (Double.isNaN(d)) {
                d = this.getAtomX(n);
                d2 = this.getAtomX(n);
                d3 = this.getAtomY(n);
                d4 = this.getAtomY(n);
            }
            if (d > this.getAtomX(n)) {
                d = this.getAtomX(n);
            }
            if (d2 < this.getAtomX(n)) {
                d2 = this.getAtomX(n);
            }
            if (d3 > this.getAtomY(n)) {
                d3 = this.getAtomY(n);
            }
            if (!(d4 < this.getAtomY(n))) continue;
            d4 = this.getAtomY(n);
        }
        return new GenericRectangle(d, d3, d2 - d, d4 - d3);
    }

    private void expandBoundsByTabuZones(double d) {
        for (int i = 0; i < this.mpTabuZone.size(); ++i) {
            this.mBoundingRect = this.mBoundingRect.union(this.mpTabuZone.get(i));
        }
        this.expandByHiliteBackgrounds(d);
        double d2 = 0.1 * d;
        this.mBoundingRect.x -= d2;
        this.mBoundingRect.y -= d2;
        this.mBoundingRect.width += 2.0 * d2;
        this.mBoundingRect.height += 2.0 * d2;
    }

    private void expandByHiliteBackgrounds(double d) {
        boolean[] blArray = new boolean[this.mMol.getAllAtoms()];
        for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
            if (!this.mMol.isBondBackgroundHilited(i)) continue;
            blArray[this.mMol.getBondAtom((int)0, (int)i)] = true;
            blArray[this.mMol.getBondAtom((int)1, (int)i)] = true;
        }
        GenericRectangle genericRectangle = new GenericRectangle();
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            double d2;
            double d3 = (this.mMol.getAtomQueryFeatures(i) & 0x20000000L) != 0L ? d * 0.47 : (d2 = blArray[i] ? d * 0.38 : 0.0);
            if (this.noSimpleH && this.isSimpleH(i, -1)) {
                return;
            }
            if (d2 == 0.0) continue;
            double d4 = this.mTransformation.transformX(this.mMol.getAtomX(i));
            double d5 = this.mTransformation.transformY(this.mMol.getAtomY(i));
            genericRectangle.set(d4 - d2, d5 - d2, d2 * 2.0, d2 * 2.0);
            this.mBoundingRect = this.mBoundingRect.union(genericRectangle);
        }
    }

    private void setChiralTextLocation(GenericRectangle genericRectangle, double d, int n) {
        double d2 = d / 2.0;
        switch (n & 0xC0000) {
            case 786432: {
                if (genericRectangle != null) {
                    this.mChiralTextLocation.x = genericRectangle.x + genericRectangle.width / 2.0;
                    this.mChiralTextLocation.y = genericRectangle.y + genericRectangle.height - d2;
                    break;
                }
            }
            case 0: {
                this.mChiralTextLocation.x = this.mBoundingRect.x + this.mBoundingRect.width / 2.0;
                this.mChiralTextLocation.y = this.mBoundingRect.y + this.mBoundingRect.height + d2;
                if (genericRectangle == null || !(this.mChiralTextLocation.y > genericRectangle.y + genericRectangle.height - d2)) break;
                this.mChiralTextLocation.y = genericRectangle.y + genericRectangle.height - d2;
                break;
            }
            case 524288: {
                if (genericRectangle != null) {
                    this.mChiralTextLocation.x = genericRectangle.x + genericRectangle.width / 2.0;
                    this.mChiralTextLocation.y = genericRectangle.y + d2;
                    break;
                }
            }
            case 262144: {
                this.mChiralTextLocation.x = this.mBoundingRect.x + this.mBoundingRect.width / 2.0;
                this.mChiralTextLocation.y = this.mBoundingRect.y - d2;
                if (genericRectangle == null || !(this.mChiralTextLocation.y < genericRectangle.y + d2)) break;
                this.mChiralTextLocation.y = genericRectangle.y + d2;
            }
        }
    }

    public double getAtomX(int n) {
        return this.mTransformation.transformX(this.mMol.getAtomX(n));
    }

    public double getAtomY(int n) {
        return this.mTransformation.transformY(this.mMol.getAtomY(n));
    }

    public final GenericRectangle getBoundingRect() {
        return this.mBoundingRect;
    }

    protected void init() {
        this.mFactorTextSize = 1.0;
        this.mTransformation = new DepictorTransformation();
        this.mpTabuZone = new ArrayList();
        this.mpDot = new ArrayList();
        this.mAtomLabelDisplayed = new boolean[this.mMol.getAllAtoms()];
        this.mChiralTextLocation = new GenericPoint();
        this.mStandardForegroundColor = 0;
        this.mCurrentColor = -1;
        this.updateBondHiliteColor();
    }

    private void updateBondHiliteColor() {
        int n = this.mOverruleBackground != 0 ? this.mOverruleBackground : (this.mCustomBackground != 0 ? this.mCustomBackground : -1);
        this.mBondBGHiliteColor = ColorHelper.intermediateColor(n, -10706689, 0.3f);
        this.mBondFGHiliteColor = ColorHelper.getContrastColor(Short.MIN_VALUE, n);
        this.mExcludeGroupBGColor = -24321;
        this.mExcludeGroupFGColor = -6291392;
    }

    private void calculateParameters() {
        double d = this.mTransformation.getScaling() * this.mMol.getAverageBondLength();
        this.mpLineWidth = d * 0.06;
        this.mpBondSpacing = d * 0.15;
        this.mpBondHiliteRadius = d * 0.38;
        this.mpExcludeGroupRadius = d * 0.47;
        this.mpLabelSize = (int)(d * this.mFactorTextSize * 0.6 + 0.5);
        this.mpDotDiameter = d * 0.12;
        this.mpQFDiameter = d * 0.4;
        this.mChiralTextSize = d * 0.5 + 0.5;
    }

    public synchronized void paint(T t) {
        int n;
        if (this.mMol.getAllAtoms() == 0) {
            return;
        }
        this.mMol.ensureHelperArrays(this.requiredHelperArrays());
        this.mContext = t;
        this.calculateParameters();
        int[][] nArray = this.mMol.getESRGroupMemberCounts();
        boolean bl = false;
        this.mAtomColor = new int[this.mMol.getAllAtoms()];
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            this.mAtomColor[n] = this.mMol.getAtomColor(n);
            if (this.mAtomColor[n] != 0) {
                bl = true;
            }
            if (this.mMol.isSelectedAtom(n)) {
                this.mAtomColor[n] = 128;
            }
            if (!this.mMol.getStereoProblem(n) || (this.mDisplayMode & 0x800) != 0) continue;
            this.mAtomColor[n] = 256;
        }
        this.setColor_(-10);
        if (this.mAtomHiliteColor != null && this.mAtomHiliteColor.length >= this.mMol.getAtoms()) {
            this.hiliteAtomBackgrounds(this.mAtomHiliteColor, this.mAtomHiliteRadius);
        }
        this.hiliteExcludeGroups();
        this.hiliteBondBackgrounds();
        this.indicateQueryFeatures();
        this.addChiralInfo();
        this.mpSetNormalLabelSize();
        this.setLineWidth(this.mpLineWidth);
        this.setColor_(this.mStandardForegroundColor);
        this.markIsolatedAtoms();
        this.mpDot.clear();
        this.mpTabuZone.clear();
        if ((this.mDisplayMode & 1) != 0) {
            this.mpDrawAllBonds(nArray);
            this.mpDrawAllDots();
            this.mpDrawBondQueryFeatures();
        }
        for (n = 0; n < this.mMol.getAllAtoms(); ++n) {
            if (this.isHighlightedAtom(n)) {
                this.setColor_(-3);
                this.mpDrawAtom(n, nArray);
                this.setColor_(this.mStandardForegroundColor);
                continue;
            }
            if (this.mAtomColor[n] != 0) {
                this.setColor_(this.mAtomColor[n]);
                this.mpDrawAtom(n, nArray);
                this.setColor_(this.mStandardForegroundColor);
                continue;
            }
            if (!bl && this.mMol.getMoleculeColor() != 1 && this.mMol.getAtomicNo(n) != 1 && this.mMol.getAtomicNo(n) != 6 && (this.mDisplayMode & 0x400) == 0 && this.mMol.getAtomList(n) == null && this.mMol.getAtomicNo(n) < ATOM_LABEL_COLOR.length) {
                this.setRGBColor(this.getContrastColor(ATOM_LABEL_COLOR[this.mMol.getAtomicNo(n)], n));
                this.mpDrawAtom(n, nArray);
                this.setColor_(this.mStandardForegroundColor);
                continue;
            }
            this.mpDrawAtom(n, nArray);
        }
        if ((this.mDisplayMode & 1) == 0) {
            this.mpDrawAllDots();
            this.mpDrawBondQueryFeatures();
            this.mpDrawAllBonds(nArray);
        }
    }

    public Color getBackgroundColor() {
        return new Color(this.getBackgroundRGB());
    }

    public int getBackgroundRGB() {
        return this.mOverruleBackground != 0 ? this.mOverruleBackground : (this.mCustomBackground != 0 ? this.mCustomBackground : -1);
    }

    private int getContrastColor(int n, int n2) {
        int n3 = this.mOverruleBackground != 0 ? this.mOverruleBackground : (this.mAtomHiliteColor != null && n2 < this.mAtomHiliteColor.length && (this.mAtomHiliteColor[n2] & 0xFF000000) != 0 ? this.mAtomHiliteColor[n2] : (this.mCustomBackground != 0 ? this.mCustomBackground : -1));
        return ColorHelper.getContrastColor(n, n3);
    }

    private boolean isHighlightedAtom(int n) {
        if (this.mMol.getAllConnAtoms(n) == 0) {
            return false;
        }
        for (int i = 0; i < this.mMol.getAllConnAtoms(n); ++i) {
            if (this.mMol.isBondForegroundHilited(this.mMol.getConnBond(n, i))) continue;
            return false;
        }
        return true;
    }

    private int requiredHelperArrays() {
        return (this.mDisplayMode & 0x100) != 0 ? 63 : ((this.mDisplayMode & 0x200) != 0 ? 95 : 31);
    }

    private void markIsolatedAtoms() {
        this.mAtomIsConnected = new boolean[this.mMol.getAllAtoms()];
        for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
            this.mAtomIsConnected[this.mMol.getBondAtom((int)0, (int)i)] = true;
            this.mAtomIsConnected[this.mMol.getBondAtom((int)1, (int)i)] = true;
        }
    }

    private void addChiralInfo() {
        if ((this.mDisplayMode & 0x20) != 0) {
            return;
        }
        String string = this.mMol.getChiralText();
        if (string != null) {
            if (this.mChiralTextLocation.x == 0.0 && this.mChiralTextLocation.y == 0.0) {
                double d = this.mTransformation.getScaling() * this.mMol.getAverageBondLength();
                this.mBoundingRect = this.simpleCalculateBounds();
                this.expandBoundsByTabuZones(d);
                this.setChiralTextLocation(null, d, 0);
            }
            this.setTextSize((int)this.mChiralTextSize);
            if (this.mMol.getMoleculeColor() != 1) {
                this.setColor_(448);
            }
            this.drawString(string, this.mChiralTextLocation.x, this.mChiralTextLocation.y + (double)0.3f * this.mChiralTextSize);
        }
    }

    public void hiliteAtomBackgrounds(int[] nArray, float[] fArray) {
        int n = this.mOverruleBackground != 0 ? this.mOverruleBackground : (this.mCustomBackground != 0 ? this.mCustomBackground : -1);
        double d = this.mTransformation.getScaling() * this.mMol.getAverageBondLength();
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n2 = (nArray[i] & 0xFF000000) >>> 24;
            if (n2 == 0) continue;
            int n3 = nArray[i];
            if (n2 != 255) {
                n3 = ColorHelper.intermediateColor(n, nArray[i], (float)n2 / 255.0f);
            }
            double d2 = fArray == null ? 0.5 * d : 0.6 * (double)fArray[i] * d;
            this.setRGB(n3);
            this.fillCircle(this.getAtomX(i) - d2, this.getAtomY(i) - d2, 2.0 * d2);
        }
    }

    private void hiliteBondBackgrounds() {
        this.setLineWidth(2.0 * this.mpBondHiliteRadius);
        DepictorLine depictorLine = new DepictorLine();
        for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
            int n = this.mMol.getBondAtom(0, i);
            int n2 = this.mMol.getBondAtom(1, i);
            if (!this.mMol.isBondBackgroundHilited(i)) continue;
            depictorLine.x1 = this.getAtomX(n);
            depictorLine.y1 = this.getAtomY(n);
            depictorLine.x2 = this.getAtomX(n2);
            depictorLine.y2 = this.getAtomY(n2);
            this.setColor_(-2);
            this.drawBlackLine(depictorLine);
        }
    }

    private void hiliteExcludeGroups() {
        if (this.mMol.isFragment()) {
            double d = this.mpExcludeGroupRadius;
            this.setColor_(-7);
            for (int i = 0; i < this.mMol.getAtoms(); ++i) {
                if ((this.mMol.getAtomQueryFeatures(i) & 0x20000000L) == 0L) continue;
                this.fillCircle(this.getAtomX(i) - d, this.getAtomY(i) - d, 2.0 * d);
            }
            this.setLineWidth(2.0 * this.mpExcludeGroupRadius);
            DepictorLine depictorLine = new DepictorLine();
            for (int i = 0; i < this.mMol.getAllBonds(); ++i) {
                int n = this.mMol.getBondAtom(0, i);
                int n2 = this.mMol.getBondAtom(1, i);
                if ((this.mMol.getAtomQueryFeatures(n) & this.mMol.getAtomQueryFeatures(n2) & 0x20000000L) == 0L) continue;
                depictorLine.x1 = this.getAtomX(n);
                depictorLine.y1 = this.getAtomY(n);
                depictorLine.x2 = this.getAtomX(n2);
                depictorLine.y2 = this.getAtomY(n2);
                this.drawBlackLine(depictorLine);
            }
        }
    }

    private void indicateQueryFeatures() {
        if (this.mMol.isFragment()) {
            int n;
            this.setColor_(320);
            if ((this.mDisplayMode & 8) != 0) {
                for (n = 0; n < this.mMol.getAtoms(); ++n) {
                    if ((this.mMol.getAtomQueryFeatures(n) & 0xFFFFFFFFDFFFFFFFL) == 0L) continue;
                    this.fillCircle(this.getAtomX(n) - this.mpQFDiameter / 2.0, this.getAtomY(n) - this.mpQFDiameter / 2.0, this.mpQFDiameter);
                }
            }
            for (n = 0; n < this.mMol.getBonds(); ++n) {
                if (this.mMol.getBondQueryFeatures(n) == 0) continue;
                int n2 = this.mMol.getBondAtom(0, n);
                int n3 = this.mMol.getBondAtom(1, n);
                this.fillCircle((this.getAtomX(n2) + this.getAtomX(n3) - this.mpQFDiameter) / 2.0, (this.getAtomY(n2) + this.getAtomY(n3) - this.mpQFDiameter) / 2.0, this.mpQFDiameter);
            }
        }
    }

    private void mpDrawAllBonds(int[][] nArray) {
        double d;
        double d2;
        int n;
        int n2;
        int n3 = this.mStandardForegroundColor;
        int n4 = this.mCustomForeground;
        if ((this.mDisplayMode & 0x4000) != 0) {
            this.mStandardForegroundColor = -6;
            this.mCustomForeground = -8355712;
            this.setColor_(1);
        }
        this.mAlternativeCoords = new GenericPoint[this.mMol.getAllAtoms()];
        for (n2 = 0; n2 < this.mMol.getAllBonds(); ++n2) {
            if (this.mMol.getBondType(n2) != 2 && this.mMol.getBondType(n2) != 386 && this.mMol.getBondType(n2) != 64) continue;
            this.mpDrawBond(n2);
        }
        for (n2 = 0; n2 < this.mMol.getAllBonds(); ++n2) {
            if (this.mMol.getBondType(n2) == 2 || this.mMol.getBondType(n2) == 386 || this.mMol.getBondType(n2) == 64) continue;
            this.mpDrawBond(n2);
        }
        if ((this.mDisplayMode & 0x40) == 0) {
            for (n2 = 0; n2 < this.mMol.getAllBonds(); ++n2) {
                if (this.mMol.getBondCIPParity(n2) == 0) continue;
                String string = null;
                if (this.mMol.getBondCIPParity(n2) == 1 || this.mMol.getBondCIPParity(n2) == 2) {
                    if (this.mMol.getBondOrder(n2) == 2 || this.mMol.getBondESRType(n2) == 0 || nArray == null || nArray[this.mMol.getBondESRType(n2)][this.mMol.getBondESRGroup(n2)] > 1) {
                        string = this.mMol.getBondCIPParity(n2) == 1 ? (this.mMol.getBondOrder(n2) == 2 ? "E" : (this.mMol.isBondParityPseudo(n2) ? "p" : "P")) : (this.mMol.getBondOrder(n2) == 2 ? "Z" : (this.mMol.isBondParityPseudo(n2) ? "m" : "M"));
                    }
                } else {
                    string = "?";
                }
                if (string == null) continue;
                this.mpSetSmallLabelSize();
                this.setColor_(this.mMol.isBondForegroundHilited(n2) ? -3 : (this.mMol.getMoleculeColor() == 1 || (this.mDisplayMode & 0x1000) != 0 ? this.mStandardForegroundColor : 448));
                n = this.mMol.getBondAtom(0, n2);
                int n5 = this.mMol.getBondAtom(1, n2);
                d2 = (this.getAtomX(n) + this.getAtomX(n5)) / 2.0;
                d = (this.getAtomY(n) + this.getAtomY(n5)) / 2.0;
                double d3 = (this.getAtomX(n) - this.getAtomX(n5)) / 3.0;
                double d4 = (this.getAtomY(n) - this.getAtomY(n5)) / 3.0;
                this.mpDrawString(d2 + d4, d - d3, string, true);
                this.setColor_(this.mStandardForegroundColor);
                this.mpSetNormalLabelSize();
            }
        }
        if ((this.mDisplayMode & 4) != 0) {
            this.mpSetSmallLabelSize();
            this.setColor_(384);
            for (n2 = 0; n2 < this.mMol.getAllBonds(); ++n2) {
                int n6 = this.mMol.getBondAtom(0, n2);
                n = this.mMol.getBondAtom(1, n2);
                String string = this.mMol.isDelocalizedBond(n2) ? "d" : (this.mMol.isAromaticBond(n2) ? "a" : "");
                d2 = (this.getAtomX(n6) + this.getAtomX(n)) / 2.0;
                d = (this.getAtomY(n6) + this.getAtomY(n)) / 2.0;
                this.mpDrawString(d2, d, string + String.valueOf(n2), true);
            }
            this.setColor_(this.mStandardForegroundColor);
            this.mpSetNormalLabelSize();
        }
        if ((this.mDisplayMode & 0x4000) != 0) {
            this.mStandardForegroundColor = n3;
            this.mCustomForeground = n4;
        }
    }

    private void mpDrawBond(int n) {
        int n2 = this.mMol.getBondAtom(0, n);
        int n3 = this.mMol.getBondAtom(1, n);
        this.onDrawBond(n, this.getAtomX(n2), this.getAtomY(n2), this.getAtomX(n3), this.getAtomY(n3));
        if (!this.mMol.isSelectedAtom(n2) && !this.mMol.isSelectedAtom(n3) && ((this.mMol.getAtomQueryFeatures(n2) | this.mMol.getAtomQueryFeatures(n3)) & 0x20000000L) != 0L) {
            this.setColor_(-8);
        }
        DepictorLine depictorLine = new DepictorLine();
        if (this.mAlternativeCoords[n2] == null) {
            depictorLine.x1 = this.getAtomX(n2);
            depictorLine.y1 = this.getAtomY(n2);
        } else {
            depictorLine.x1 = this.mAlternativeCoords[n2].x;
            depictorLine.y1 = this.mAlternativeCoords[n2].y;
        }
        if (this.mAlternativeCoords[n3] == null) {
            depictorLine.x2 = this.getAtomX(n3);
            depictorLine.y2 = this.getAtomY(n3);
        } else {
            depictorLine.x2 = this.mAlternativeCoords[n3].x;
            depictorLine.y2 = this.mAlternativeCoords[n3].y;
        }
        if ((this.mMol.getBondQueryFeatures(n) & 0x1FE00) != 0) {
            this.mpHandleDottedLine(depictorLine, n2, n3);
            this.setColor_(-9);
            return;
        }
        int n4 = this.mMol.getBondType(n) == 64 ? 0 : (this.mMol.getBondType(n) == 32 ? 1 : this.mMol.getBondOrder(n));
        block0 : switch (n4) {
            case 1: {
                int n5;
                int n6;
                int n7;
                int n8 = this.mMol.getBondType(n);
                if ((this.mDisplayMode & 0x80) != 0 && (n8 == 257 || n8 == 129) && (n7 = this.mMol.getAtomESRType(n6 = this.mMol.getBondAtom(0, n))) != 0) {
                    int n9 = this.mMol.getAtomESRGroup(n6);
                    int n10 = 0;
                    for (n5 = 0; n5 < this.mMol.getAtoms(); ++n5) {
                        if (this.mMol.getAtomESRType(n5) != n7 || this.mMol.getAtomESRGroup(n5) != n9) continue;
                        ++n10;
                    }
                    if (n10 == 1) {
                        n8 = 1;
                    }
                }
                switch (n8) {
                    case 1: {
                        if (this.noSimpleH && (this.mMol.getAtomicNo(n2) == 1 && this.isSimpleH(n2, n3) || this.mMol.getAtomicNo(n3) == 1 && this.isSimpleH(n3, n2))) {
                            return;
                        }
                        this.mpHandleLine(depictorLine, n2, n3);
                        break;
                    }
                    case 257: {
                        this.mpHandleWedge(depictorLine, n2, n3);
                        break;
                    }
                    case 129: {
                        int n11;
                        double d = depictorLine.x2 - depictorLine.x1;
                        double d2 = depictorLine.y2 - depictorLine.y1;
                        if (this.mMol.isBondForegroundHilited(this.mMol.getBond(n2, n3))) {
                            n5 = -3;
                            n11 = -3;
                        } else {
                            n5 = this.mAtomColor[n2];
                            n11 = this.getESRColor(n2);
                            if (n5 == this.mMol.getAtomColor(n2)) {
                                n5 = n11;
                            }
                        }
                        DepictorLine depictorLine2 = new DepictorLine();
                        for (int i = 2; i < 17; i += 2) {
                            depictorLine2.x1 = depictorLine.x1 + (double)i * d / 17.0 - (double)i * d2 / 128.0;
                            depictorLine2.y1 = depictorLine.y1 + (double)i * d2 / 17.0 + (double)i * d / 128.0;
                            depictorLine2.x2 = depictorLine.x1 + (double)i * d / 17.0 + (double)i * d2 / 128.0;
                            depictorLine2.y2 = depictorLine.y1 + (double)i * d2 / 17.0 - (double)i * d / 128.0;
                            if (!this.mpProperLine(depictorLine2)) continue;
                            this.setColor_(i < 9 ? n5 : n11);
                            this.drawBlackLine(depictorLine2);
                            this.setColor_(this.mStandardForegroundColor);
                        }
                        break block0;
                    }
                    case 32: {
                        this.mpHandleShortDashedLine(depictorLine, n2, n3);
                    }
                }
                break;
            }
            case 0: 
            case 2: {
                DepictorLine depictorLine3 = new DepictorLine();
                DepictorLine depictorLine4 = new DepictorLine();
                GenericPoint genericPoint = new GenericPoint();
                GenericPoint genericPoint2 = new GenericPoint();
                if (!(!this.mAtomLabelDisplayed[n2] && this.mMol.getAtomPi(n2) != 2 || !this.mAtomLabelDisplayed[n3] && this.mMol.getAtomPi(n3) != 2 || this.mMol.isRingBond(n) || n4 != 2)) {
                    if (!this.mpProperLine(depictorLine)) break;
                    this.mpCalcPiBondOffset(depictorLine.x2 - depictorLine.x1, depictorLine.y2 - depictorLine.y1, genericPoint);
                    double d = genericPoint.x / 2.0;
                    double d3 = genericPoint.y / 2.0;
                    depictorLine3.x1 = depictorLine.x1 + d;
                    depictorLine3.y1 = depictorLine.y1 + d3;
                    depictorLine3.x2 = depictorLine.x2 + d;
                    depictorLine3.y2 = depictorLine.y2 + d3;
                    depictorLine4.x1 = depictorLine.x1 - d;
                    depictorLine4.y1 = depictorLine.y1 - d3;
                    depictorLine4.x2 = depictorLine.x2 - d;
                    depictorLine4.y2 = depictorLine.y2 - d3;
                    if (this.mMol.getBondType(n) == 386) {
                        this.mpMakeCrossBond(depictorLine3, depictorLine4);
                    }
                    this.drawLine(depictorLine3, n2, n3);
                    if (n4 == 2) {
                        this.drawLine(depictorLine4, n2, n3);
                        break;
                    }
                    this.drawDashedLine(depictorLine4, n2, n3);
                    break;
                }
                if ((this.mAtomLabelDisplayed[n3] || this.mMol.getAtomPi(n3) == 2) && n4 == 2) {
                    this.mpDBFromNonLabelToLabel(depictorLine, n, false);
                    break;
                }
                if ((this.mAtomLabelDisplayed[n2] || this.mMol.getAtomPi(n2) == 2) && n4 == 2) {
                    this.mpDBFromNonLabelToLabel(depictorLine, n, true);
                    break;
                }
                int n12 = this.mMol.mpPreferredSide(n);
                if (n12 == 0) {
                    n12 = 1;
                }
                depictorLine3.x1 = depictorLine.x1;
                depictorLine3.y1 = depictorLine.y1;
                depictorLine3.x2 = depictorLine.x2;
                depictorLine3.y2 = depictorLine.y2;
                this.mpCalcPiBondOffset(depictorLine.x2 - depictorLine.x1, depictorLine.y2 - depictorLine.y1, genericPoint);
                if (n12 > 0) {
                    depictorLine4.x1 = depictorLine.x1 + genericPoint.x;
                    depictorLine4.y1 = depictorLine.y1 + genericPoint.y;
                    depictorLine4.x2 = depictorLine.x2 + genericPoint.x;
                    depictorLine4.y2 = depictorLine.y2 + genericPoint.y;
                    if (this.mpCalcNextBondOffset(n2, n3, 1, genericPoint2) || this.mMol.getConnAtoms(n2) > 1) {
                        depictorLine4.x1 += genericPoint2.x + genericPoint.y;
                        depictorLine4.y1 += genericPoint2.y - genericPoint.x;
                    }
                    if (this.mpCalcNextBondOffset(n3, n2, -1, genericPoint2) || this.mMol.getConnAtoms(n3) > 1) {
                        depictorLine4.x2 += genericPoint2.x - genericPoint.y;
                        depictorLine4.y2 += genericPoint2.y + genericPoint.x;
                    }
                } else {
                    depictorLine4.x1 = depictorLine.x1 - genericPoint.x;
                    depictorLine4.y1 = depictorLine.y1 - genericPoint.y;
                    depictorLine4.x2 = depictorLine.x2 - genericPoint.x;
                    depictorLine4.y2 = depictorLine.y2 - genericPoint.y;
                    if (this.mpCalcNextBondOffset(n2, n3, -1, genericPoint2) || this.mMol.getConnAtoms(n2) > 1) {
                        depictorLine4.x1 += genericPoint2.x + genericPoint.y;
                        depictorLine4.y1 += genericPoint2.y - genericPoint.x;
                    }
                    if (this.mpCalcNextBondOffset(n3, n2, 1, genericPoint2) || this.mMol.getConnAtoms(n3) > 1) {
                        depictorLine4.x2 += genericPoint2.x - genericPoint.y;
                        depictorLine4.y2 += genericPoint2.y + genericPoint.x;
                    }
                }
                if (this.mMol.getBondType(n) == 386) {
                    this.mpMakeCrossBond(depictorLine3, depictorLine4);
                }
                this.mpHandleLine(depictorLine3, n2, n3);
                if (n4 == 2) {
                    this.mpHandleLine(depictorLine4, n2, n3);
                    break;
                }
                this.mpHandleDashedLine(depictorLine4, n2, n3);
                break;
            }
            case 3: {
                if (!this.mpProperLine(depictorLine)) break;
                this.drawLine(depictorLine, n2, n3);
                GenericPoint genericPoint = new GenericPoint();
                this.mpCalcPiBondOffset(depictorLine.x2 - depictorLine.x1, depictorLine.y2 - depictorLine.y1, genericPoint);
                DepictorLine depictorLine5 = new DepictorLine();
                this.drawOffsetLine(depictorLine, n2, n3, genericPoint.x, genericPoint.y, depictorLine5);
                this.drawOffsetLine(depictorLine, n2, n3, -genericPoint.x, -genericPoint.y, depictorLine5);
                break;
            }
            case 4: {
                if (!this.mpProperLine(depictorLine)) break;
                this.drawLine(depictorLine, n2, n3);
                GenericPoint genericPoint = new GenericPoint();
                this.mpCalcPiBondOffset(depictorLine.x2 - depictorLine.x1, depictorLine.y2 - depictorLine.y1, genericPoint);
                DepictorLine depictorLine6 = new DepictorLine();
                this.drawOffsetLine(depictorLine, n2, n3, 1.5 * genericPoint.x, 1.5 * genericPoint.y, depictorLine6);
                this.drawOffsetLine(depictorLine, n2, n3, 0.5 * genericPoint.x, 0.5 * genericPoint.y, depictorLine6);
                this.drawOffsetLine(depictorLine, n2, n3, -0.5 * genericPoint.x, -0.5 * genericPoint.y, depictorLine6);
                this.drawOffsetLine(depictorLine, n2, n3, -1.5 * genericPoint.x, -1.5 * genericPoint.y, depictorLine6);
                break;
            }
            case 5: {
                if (!this.mpProperLine(depictorLine)) break;
                this.drawLine(depictorLine, n2, n3);
                this.drawLine(depictorLine, n2, n3);
                GenericPoint genericPoint = new GenericPoint();
                this.mpCalcPiBondOffset(depictorLine.x2 - depictorLine.x1, depictorLine.y2 - depictorLine.y1, genericPoint);
                DepictorLine depictorLine7 = new DepictorLine();
                this.drawOffsetLine(depictorLine, n2, n3, 2.0 * genericPoint.x, 2.0 * genericPoint.y, depictorLine7);
                this.drawOffsetLine(depictorLine, n2, n3, genericPoint.x, genericPoint.y, depictorLine7);
                this.drawOffsetLine(depictorLine, n2, n3, -genericPoint.x, -genericPoint.y, depictorLine7);
                this.drawOffsetLine(depictorLine, n2, n3, -2.0 * genericPoint.x, -2.0 * genericPoint.y, depictorLine7);
            }
        }
        if (this.mCurrentColor == -8) {
            this.setColor_(-9);
        }
    }

    private void drawOffsetLine(DepictorLine depictorLine, int n, int n2, double d, double d2, DepictorLine depictorLine2) {
        depictorLine2.x1 = depictorLine.x1 + d;
        depictorLine2.y1 = depictorLine.y1 + d2;
        depictorLine2.x2 = depictorLine.x2 + d;
        depictorLine2.y2 = depictorLine.y2 + d2;
        this.drawLine(depictorLine2, n, n2);
    }

    private void mpDBFromNonLabelToLabel(DepictorLine depictorLine, int n, boolean bl) {
        double d;
        DepictorLine depictorLine2 = new DepictorLine();
        DepictorLine depictorLine3 = new DepictorLine();
        GenericPoint genericPoint = new GenericPoint();
        GenericPoint genericPoint2 = new GenericPoint();
        int n2 = this.mMol.getBondAtom(0, n);
        int n3 = this.mMol.getBondAtom(1, n);
        if (bl) {
            d = depictorLine.x1;
            depictorLine.x1 = depictorLine.x2;
            depictorLine.x2 = d;
            d = depictorLine.y1;
            depictorLine.y1 = depictorLine.y2;
            depictorLine.y2 = d;
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        if (!this.mpProperLine(depictorLine)) {
            return;
        }
        if (this.mMol.isRingBond(n)) {
            int n5;
            depictorLine2.x1 = depictorLine.x1;
            depictorLine2.y1 = depictorLine.y1;
            depictorLine2.x2 = depictorLine.x2;
            depictorLine2.y2 = depictorLine.y2;
            int n6 = n5 = bl ? -this.mMol.mpPreferredSide(n) : this.mMol.mpPreferredSide(n);
            if (n5 == 0) {
                n5 = 1;
            }
            this.mpCalcPiBondOffset(depictorLine.x2 - depictorLine.x1, depictorLine.y2 - depictorLine.y1, genericPoint);
            if (n5 > 0) {
                depictorLine3.x1 = depictorLine.x1 + genericPoint.x;
                depictorLine3.y1 = depictorLine.y1 + genericPoint.y;
                depictorLine3.x2 = depictorLine.x2 + genericPoint.x;
                depictorLine3.y2 = depictorLine.y2 + genericPoint.y;
                if (this.mpCalcNextBondOffset(n2, n3, 1, genericPoint2) || this.mMol.getConnAtoms(n2) > 1) {
                    depictorLine3.x1 += genericPoint2.x + genericPoint.y;
                    depictorLine3.y1 += genericPoint2.y - genericPoint.x;
                }
            } else {
                depictorLine3.x1 = depictorLine.x1 - genericPoint.x;
                depictorLine3.y1 = depictorLine.y1 - genericPoint.y;
                depictorLine3.x2 = depictorLine.x2 - genericPoint.x;
                depictorLine3.y2 = depictorLine.y2 - genericPoint.y;
                if (this.mpCalcNextBondOffset(n2, n3, -1, genericPoint2) || this.mMol.getConnAtoms(n2) > 1) {
                    depictorLine3.x1 += genericPoint2.x + genericPoint.y;
                    depictorLine3.y1 += genericPoint2.y - genericPoint.x;
                }
            }
            if (this.mMol.getBondType(n) == 386) {
                this.mpMakeCrossBond(depictorLine2, depictorLine3);
            }
            this.mpHandleLine(depictorLine2, n2, n3);
            if (this.mMol.getBondType(n) == 64) {
                this.mpHandleDashedLine(depictorLine3, n2, n3);
            } else {
                this.mpHandleLine(depictorLine3, n2, n3);
            }
        } else {
            this.mpCalcPiBondOffset(depictorLine.x2 - depictorLine.x1, depictorLine.y2 - depictorLine.y1, genericPoint);
            d = genericPoint.x / 2.0;
            double d2 = genericPoint.y / 2.0;
            boolean bl2 = false;
            depictorLine2.x1 = depictorLine.x1 + d;
            depictorLine2.y1 = depictorLine.y1 + d2;
            depictorLine2.x2 = depictorLine.x2 + d;
            depictorLine2.y2 = depictorLine.y2 + d2;
            if (this.mMol.getConnAtoms(n2) > 1) {
                if (!this.mpCalcNextBondOffset(n2, n3, 1, genericPoint2)) {
                    this.mAlternativeCoords[n2] = new GenericPoint(depictorLine2.x1, depictorLine2.y1);
                } else {
                    depictorLine2.x1 += genericPoint2.x;
                    depictorLine2.y1 += genericPoint2.y;
                    if (this.mMol.getConnAtoms(n2) == 2 && (genericPoint2.x != 0.0 || genericPoint2.y != 0.0)) {
                        depictorLine2.x1 += genericPoint.y;
                        depictorLine2.y1 -= genericPoint.x;
                    }
                }
            }
            depictorLine3.x1 = depictorLine.x1 - d;
            depictorLine3.y1 = depictorLine.y1 - d2;
            depictorLine3.x2 = depictorLine.x2 - d;
            depictorLine3.y2 = depictorLine.y2 - d2;
            if (this.mMol.getConnAtoms(n2) > 1) {
                if (!this.mpCalcNextBondOffset(n2, n3, 0, genericPoint2)) {
                    this.mAlternativeCoords[n2] = new GenericPoint(depictorLine3.x1, depictorLine3.y1);
                    bl2 = true;
                } else {
                    depictorLine3.x1 += genericPoint2.x;
                    depictorLine3.y1 += genericPoint2.y;
                    if (this.mMol.getConnAtoms(n2) == 2 && (genericPoint2.x != 0.0 || genericPoint2.y != 0.0)) {
                        depictorLine3.x1 += genericPoint.y;
                        depictorLine3.y1 -= genericPoint.x;
                    }
                }
            }
            if (this.mMol.getBondType(n) == 386) {
                this.mpMakeCrossBond(depictorLine2, depictorLine3);
            }
            if (this.mMol.getBondType(n) == 64) {
                if (bl2) {
                    this.drawDashedLine(depictorLine2, n2, n3);
                    this.drawLine(depictorLine3, n2, n3);
                } else {
                    this.drawLine(depictorLine2, n2, n3);
                    this.drawDashedLine(depictorLine3, n2, n3);
                }
            } else {
                this.drawLine(depictorLine2, n2, n3);
                this.drawLine(depictorLine3, n2, n3);
            }
        }
    }

    private void mpMakeCrossBond(DepictorLine depictorLine, DepictorLine depictorLine2) {
        double d = depictorLine.x2;
        depictorLine.x2 = depictorLine2.x2;
        depictorLine2.x2 = d;
        d = depictorLine.y2;
        depictorLine.y2 = depictorLine2.y2;
        depictorLine2.y2 = d;
    }

    private void mpCalcPiBondOffset(double d, double d2, GenericPoint genericPoint) {
        if (d == 0.0) {
            genericPoint.x = d2 < 0.0 ? this.mpBondSpacing : -this.mpBondSpacing;
            genericPoint.y = 0.0;
            return;
        }
        double d3 = Math.atan(d2 / d);
        if (d < 0.0) {
            d3 += Math.PI;
        }
        genericPoint.x = -(this.mpBondSpacing * Math.sin(d3));
        genericPoint.y = this.mpBondSpacing * Math.cos(d3);
    }

    private boolean mpProperLine(DepictorLine depictorLine) {
        if (depictorLine.x1 == depictorLine.x2 && depictorLine.y1 == depictorLine.y2) {
            for (GenericRectangle genericRectangle : this.mpTabuZone) {
                if (!genericRectangle.contains(depictorLine.x1, depictorLine.y1)) continue;
                return false;
            }
            return true;
        }
        GenericRectangle genericRectangle = this.mpGetFrame(depictorLine);
        boolean bl = false;
        if (depictorLine.x1 > depictorLine.x2) {
            this.mpExchangeLineEnds(depictorLine);
            bl = true;
        }
        for (int i = 0; i < this.mpTabuZone.size(); ++i) {
            GenericRectangle genericRectangle2 = this.mpTabuZone.get(i);
            if (genericRectangle2.x > genericRectangle.x + genericRectangle.width || genericRectangle2.y > genericRectangle.y + genericRectangle.height || genericRectangle.x > genericRectangle2.x + genericRectangle2.width || genericRectangle.y > genericRectangle2.y + genericRectangle2.height) continue;
            if (this.mpInTabuZone(depictorLine.x1, depictorLine.y1, i)) {
                if (this.mpInTabuZone(depictorLine.x2, depictorLine.y2, i)) {
                    if (bl) {
                        this.mpExchangeLineEnds(depictorLine);
                    }
                    return false;
                }
                this.mpShortenLine(depictorLine, 0, i);
                boolean bl2 = this.mpProperLine(depictorLine);
                if (bl) {
                    this.mpExchangeLineEnds(depictorLine);
                }
                return bl2;
            }
            if (!this.mpInTabuZone(depictorLine.x2, depictorLine.y2, i)) continue;
            this.mpShortenLine(depictorLine, 1, i);
            boolean bl3 = this.mpProperLine(depictorLine);
            if (bl) {
                this.mpExchangeLineEnds(depictorLine);
            }
            return bl3;
        }
        if (bl) {
            this.mpExchangeLineEnds(depictorLine);
        }
        return true;
    }

    private boolean mpCalcNextBondOffset(int n, int n2, int n3, GenericPoint genericPoint) {
        boolean bl = false;
        genericPoint.x = 0.0;
        genericPoint.y = 0.0;
        double d = n3 > 0 ? 2.617993878 : 3.665191429;
        double d2 = this.mMol.getBondAngle(n, n2);
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            double d3;
            int n4 = this.mMol.getConnBond(n, i);
            double d4 = d2;
            int n5 = this.mMol.getBondAtom(0, n4) == n ? this.mMol.getBondAtom(1, n4) : this.mMol.getBondAtom(0, n4);
            if (n5 == n2) continue;
            double d5 = this.mMol.getBondAngle(n, n5);
            if (d4 < d5) {
                d4 += Math.PI * 2;
            }
            double d6 = d4 - d5;
            if (n3 > 0) {
                if (d6 < Math.PI) {
                    bl = true;
                }
                if (d6 > 2.617993878) {
                    d6 = 2.617993878;
                }
                if (d6 < 0.523598776) {
                    d6 = 0.523598776;
                }
                if (!(d6 <= d)) continue;
                d = d6;
                d3 = this.mpBondSpacing * Math.tan(d - 1.5707963267948966) / 2.0;
                genericPoint.x = -(d3 * Math.sin(d4));
                genericPoint.y = -(d3 * Math.cos(d4));
                continue;
            }
            if (d6 >= Math.PI) {
                bl = true;
            }
            if (d6 < 3.665191429) {
                d6 = 3.665191429;
            }
            if (d6 > 5.759586531) {
                d6 = 5.759586531;
            }
            if (!(d6 >= d)) continue;
            d = d6;
            d3 = this.mpBondSpacing * Math.tan(4.712388981 - d) / 2.0;
            genericPoint.x = -(d3 * Math.sin(d4));
            genericPoint.y = -(d3 * Math.cos(d4));
        }
        return bl;
    }

    private void mpExchangeLineEnds(DepictorLine depictorLine) {
        double d = depictorLine.x1;
        depictorLine.x1 = depictorLine.x2;
        depictorLine.x2 = d;
        d = depictorLine.y1;
        depictorLine.y1 = depictorLine.y2;
        depictorLine.y2 = d;
    }

    private void mpHandleLine(DepictorLine depictorLine, int n, int n2) {
        if (this.mpProperLine(depictorLine)) {
            this.drawLine(depictorLine, n, n2);
        }
    }

    private void mpHandleDashedLine(DepictorLine depictorLine, int n, int n2) {
        if (this.mpProperLine(depictorLine)) {
            this.drawDashedLine(depictorLine, n, n2);
        }
    }

    private void mpHandleShortDashedLine(DepictorLine depictorLine, int n, int n2) {
        if (this.mpProperLine(depictorLine)) {
            this.drawShortDashedLine(depictorLine, n, n2);
        }
    }

    private void mpHandleDottedLine(DepictorLine depictorLine, int n, int n2) {
        if (this.mpProperLine(depictorLine)) {
            this.drawDottedLine(depictorLine);
        }
    }

    private void mpHandleWedge(DepictorLine depictorLine, int n, int n2) {
        DepictorLine depictorLine2 = new DepictorLine();
        if (depictorLine.x1 == depictorLine.x2 && depictorLine.y1 == depictorLine.y2) {
            return;
        }
        depictorLine2.x1 = depictorLine.x1;
        depictorLine2.y1 = depictorLine.y1;
        depictorLine2.x2 = depictorLine.x2;
        depictorLine2.y2 = depictorLine.y2;
        GenericRectangle genericRectangle = this.mpGetFrame(depictorLine2);
        for (int i = 0; i < this.mpTabuZone.size(); ++i) {
            GenericRectangle genericRectangle2 = this.mpTabuZone.get(i);
            if (genericRectangle2.x > genericRectangle.x + genericRectangle.width || genericRectangle2.y > genericRectangle.y + genericRectangle.height || genericRectangle.x > genericRectangle2.x + genericRectangle2.width || genericRectangle.y > genericRectangle2.y + genericRectangle2.height) continue;
            if (this.mpInTabuZone(depictorLine2.x1, depictorLine2.y1, i)) {
                if (this.mpInTabuZone(depictorLine2.x2, depictorLine2.y2, i)) {
                    return;
                }
                this.mpShortenLine(depictorLine2, 0, i);
                this.mpHandleWedge(depictorLine2, n, n2);
                return;
            }
            if (!this.mpInTabuZone(depictorLine2.x2, depictorLine2.y2, i)) continue;
            this.mpShortenLine(depictorLine2, 1, i);
            this.mpHandleWedge(depictorLine2, n, n2);
            return;
        }
        this.drawWedge(depictorLine2, n, n2);
    }

    private GenericRectangle mpGetFrame(DepictorLine depictorLine) {
        GenericRectangle genericRectangle = new GenericRectangle();
        if (depictorLine.x1 <= depictorLine.x2) {
            genericRectangle.x = depictorLine.x1;
            genericRectangle.width = depictorLine.x2 - depictorLine.x1;
        } else {
            genericRectangle.x = depictorLine.x2;
            genericRectangle.width = depictorLine.x1 - depictorLine.x2;
        }
        if (depictorLine.y1 <= depictorLine.y2) {
            genericRectangle.y = depictorLine.y1;
            genericRectangle.height = depictorLine.y2 - depictorLine.y1;
        } else {
            genericRectangle.y = depictorLine.y2;
            genericRectangle.height = depictorLine.y1 - depictorLine.y2;
        }
        return genericRectangle;
    }

    private boolean mpInTabuZone(double d, double d2, int n) {
        if ((this.mDisplayMode & 1) != 0) {
            return false;
        }
        GenericRectangle genericRectangle = this.mpTabuZone.get(n);
        return d > genericRectangle.x && d < genericRectangle.x + genericRectangle.width && d2 > genericRectangle.y && d2 < genericRectangle.y + genericRectangle.height;
    }

    private void mpShortenLine(DepictorLine depictorLine, int n, int n2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (n == 0) {
            d6 = depictorLine.x1;
            d5 = depictorLine.y1;
            d4 = depictorLine.x2;
            d3 = depictorLine.y2;
        } else {
            d6 = depictorLine.x2;
            d5 = depictorLine.y2;
            d4 = depictorLine.x1;
            d3 = depictorLine.y1;
        }
        GenericRectangle genericRectangle = this.mpTabuZone.get(n2);
        double d7 = d4 > d6 ? genericRectangle.x + genericRectangle.width : genericRectangle.x;
        double d8 = d3 > d5 ? genericRectangle.y + genericRectangle.height : genericRectangle.y;
        double d9 = d4 - d6;
        double d10 = d3 - d5;
        if (Math.abs(d9) > Math.abs(d10)) {
            if (d5 == d3) {
                d2 = d7;
                d = d5;
            } else if (d4 > d6 == d7 > (d2 = d6 + d9 * (d8 - d5) / d10)) {
                d = d8;
            } else {
                d2 = d7;
                d = d5 + d10 * (d7 - d6) / d9;
            }
        } else if (d6 == d4) {
            d2 = d6;
            d = d8;
        } else if (d3 > d5 == d8 > (d = d5 + d10 * (d7 - d6) / d9)) {
            d2 = d7;
        } else {
            d2 = d6 + d9 * (d8 - d5) / d10;
            d = d8;
        }
        if (n == 0) {
            depictorLine.x1 = d2;
            depictorLine.y1 = d;
        } else {
            depictorLine.x2 = d2;
            depictorLine.y2 = d;
        }
    }

    private void mpDrawAtom(int n, int[][] nArray) {
        double d;
        double d2;
        double d3;
        int n2;
        int n3;
        double d4;
        double d5;
        int n4;
        String string;
        if (this.noSimpleH && this.isSimpleH(n, -1)) {
            return;
        }
        if (!this.mIsValidatingView) {
            this.onDrawAtom(n, this.mMol.getAtomLabel(n), this.getAtomX(n), this.getAtomY(n));
        }
        String string2 = null;
        if (this.mMol.getAtomCharge(n) != 0) {
            string = Math.abs(this.mMol.getAtomCharge(n)) == 1 ? "" : String.valueOf(Math.abs(this.mMol.getAtomCharge(n)));
            String string3 = string2 = this.mMol.getAtomCharge(n) < 0 ? string + "-" : string + "+";
        }
        if (this.mAtomText != null && n < this.mAtomText.length && this.mAtomText[n] != null && this.mAtomText[n].length() > 0) {
            string2 = this.append(string2, this.mAtomText[n]);
        }
        string = null;
        long l = this.mMol.getAtomQueryFeatures(n);
        if (l != 0L) {
            long l2;
            if ((l & 0x100000000000L) != 0L) {
                string = this.append(string, "*");
            }
            if ((l & 0x200000000000L) != 0L) {
                string = this.append(string, "!*");
            }
            if ((l & 0x400000000000L) != 0L) {
                string = this.append(string, "ha");
            } else if ((l & 2L) != 0L) {
                string = this.append(string, "a");
            } else if ((l & 4L) != 0L) {
                string = this.append(string, "!a");
            }
            if ((l & 0x1000L) != 0L) {
                string = this.append(string, "s");
            }
            if ((l & 0x780L) != 0L) {
                l2 = l & 0x780L;
                if (l2 == 1792L) {
                    string = this.append(string, "h0");
                } else if (l2 == 1664L) {
                    string = this.append(string, "h1");
                } else if (l2 == 1408L) {
                    string = this.append(string, "h2");
                } else if (l2 == 128L) {
                    string = this.append(string, "h>0");
                } else if (l2 == 384L) {
                    string = this.append(string, "h>1");
                } else if (l2 == 896L) {
                    string = this.append(string, "h>2");
                } else if (l2 == 1024L) {
                    string = this.append(string, "h<3");
                } else if (l2 == 1536L) {
                    string = this.append(string, "h<2");
                }
            }
            if ((l & 0xE000000L) != 0L) {
                l2 = l & 0xE000000L;
                if (l2 == 0xA000000L) {
                    string = this.append(string, "c0");
                } else if (l2 == 0x6000000L) {
                    string = this.append(string, "c+");
                } else if (l2 == 0xC000000L) {
                    string = this.append(string, "c-");
                }
            }
            if ((l & 0x1C000L) != 0L) {
                l2 = l & 0x1C000L;
                if (l2 == 98304L) {
                    string = this.append(string, "pi0");
                } else if (l2 == 81920L) {
                    string = this.append(string, "pi1");
                } else if (l2 == 49152L) {
                    string = this.append(string, "pi2");
                } else if (l2 == 16384L) {
                    string = this.append(string, "pi>0");
                }
            }
            if ((l & 0x3E0000L) != 0L) {
                l2 = l & 0x3E0000L;
                if (l2 == 0x3A0000L) {
                    string = this.append(string, "n1");
                } else if (l2 == 0x360000L) {
                    string = this.append(string, "n2");
                } else if (l2 == 0x2E0000L) {
                    string = this.append(string, "n3");
                } else if (l2 == 0x300000L) {
                    string = this.append(string, "n<3");
                } else if (l2 == 0x200000L) {
                    string = this.append(string, "n<4");
                } else if (l2 == 393216L) {
                    string = this.append(string, "n>1");
                } else if (l2 == 917504L) {
                    string = this.append(string, "n>2");
                } else if (l2 == 0x1E0000L) {
                    string = this.append(string, "n>3");
                }
            }
            if ((l & 0xF8000000000L) != 0L) {
                l2 = l & 0xF8000000000L;
                if (l2 == 0xF0000000000L) {
                    string = this.append(string, "e0");
                } else if (l2 == 0xE8000000000L) {
                    string = this.append(string, "e1");
                } else if (l2 == 0xD8000000000L) {
                    string = this.append(string, "e2");
                } else if (l2 == 0xB8000000000L) {
                    string = this.append(string, "e3");
                } else if (l2 == 0xE0000000000L) {
                    string = this.append(string, "e<2");
                } else if (l2 == 0xC0000000000L) {
                    string = this.append(string, "e<3");
                } else if (l2 == 0x80000000000L) {
                    string = this.append(string, "e<4");
                } else if (l2 == 0x8000000000L) {
                    string = this.append(string, "e>0");
                } else if (l2 == 0x18000000000L) {
                    string = this.append(string, "e>1");
                } else if (l2 == 0x38000000000L) {
                    string = this.append(string, "e>2");
                } else if (l2 == 0x78000000000L) {
                    string = this.append(string, "e>3");
                } else if (l2 == 0x48000000000L) {
                    string = this.append(string, "e1-2");
                } else if (l2 == 0x88000000000L) {
                    string = this.append(string, "e1-3");
                } else if (l2 == 0x98000000000L) {
                    string = this.append(string, "e2-3");
                }
            }
            if ((l & 0x78L) != 0L) {
                l2 = l & 0x78L;
                if (l2 == 112L) {
                    string = this.append(string, "!r");
                } else if (l2 == 8L) {
                    string = this.append(string, "r");
                } else if (l2 == 96L) {
                    string = this.append(string, "rb<3");
                } else if (l2 == 104L) {
                    string = this.append(string, "rb2");
                } else if (l2 == 88L) {
                    string = this.append(string, "rb3");
                } else if (l2 == 56L) {
                    string = this.append(string, "rb4");
                }
            }
            if ((l & 0x1C00000L) != 0L) {
                string = this.append(string, "r" + ((l & 0x1C00000L) >> 22));
            }
            if ((l & 0x7F00000000L) != 0L) {
                string = this.append(string, this.createRingSizeText(l));
            }
            if ((l & 0x10000000L) != 0L) {
                string = this.append(string, "f");
            }
        }
        if (this.mMol.getAtomMass(n) != 0) {
            string = this.append(string, String.valueOf(this.mMol.getAtomMass(n)));
        }
        int n5 = 0;
        if (this.mMol.getAtomRadical(n) != 0) {
            switch (this.mMol.getAtomRadical(n)) {
                case 16: {
                    string2 = this.append(string2, "|");
                    break;
                }
                case 32: {
                    n5 = 1;
                    break;
                }
                case 48: {
                    n5 = 2;
                }
            }
        }
        String string4 = null;
        if ((this.mDisplayMode & 0x40) == 0) {
            if (this.mMol.isAtomConfigurationUnknown(n)) {
                string4 = "?";
            } else if (this.mMol.getAtomCIPParity(n) != 0 && (this.mMol.getAtomESRType(n) == 0 || nArray == null || nArray[this.mMol.getAtomESRType(n)][this.mMol.getAtomESRGroup(n)] > 1)) {
                if (this.mMol.getConnAtoms(n) == 2) {
                    switch (this.mMol.getAtomCIPParity(n)) {
                        case 2: {
                            string4 = this.mMol.isAtomParityPseudo(n) ? "p" : "P";
                            break;
                        }
                        case 1: {
                            string4 = this.mMol.isAtomParityPseudo(n) ? "m" : "M";
                            break;
                        }
                        default: {
                            string4 = "*";
                            break;
                        }
                    }
                } else {
                    switch (this.mMol.getAtomCIPParity(n)) {
                        case 1: {
                            string4 = this.mMol.isAtomParityPseudo(n) ? "r" : "R";
                            break;
                        }
                        case 2: {
                            string4 = this.mMol.isAtomParityPseudo(n) ? "s" : "S";
                            break;
                        }
                        default: {
                            string4 = "*";
                        }
                    }
                }
            }
        }
        if ((this.mDisplayMode & 0x300) != 0) {
            string4 = this.append(string4, String.valueOf(this.mMol.getSymmetryRank(n)));
        }
        String string5 = null;
        if ((this.mDisplayMode & 0x10) != 0 && this.mMol.getAtomMapNo(n) != 0) {
            string5 = "" + this.mMol.getAtomMapNo(n);
        }
        String string6 = null;
        if (this.mMol.getStereoBond(n) != -1 && (n4 = this.getESRTypeToDisplayAt(n)) != -1) {
            string6 = n4 == 0 ? "abs" : ((n4 & 0xFF) == 1 ? "&" : "or") + (1 + (n4 >> 8));
        }
        n4 = 0;
        if ((this.mDisplayMode & 0x2000) == 0) {
            if (this.mMol.isFragment()) {
                if ((this.mMol.getAtomQueryFeatures(n) & 0x800L) != 0L) {
                    n4 = this.mMol.getImplicitHydrogens(n);
                }
            } else if (this.mMol.getAtomicNo(n) != 6 || this.mMol.getAtomMass(n) != 0 || !this.mAtomIsConnected[n] || this.mMol.getAtomRadical(n) != 0) {
                n4 = this.mMol.getImplicitHydrogens(n);
            }
        }
        boolean bl = false;
        String string7 = this.mMol.getAtomCustomLabel(n);
        if (string7 != null && string7.startsWith("]")) {
            string = this.append(string7.substring(1), string);
            string7 = null;
            bl = true;
        }
        if (string7 != null) {
            n4 = 0;
        } else if (this.mMol.getAtomList(n) != null) {
            String string8 = (this.mMol.getAtomQueryFeatures(n) & 1L) != 0L ? "[!" : "[";
            string7 = string8 + this.mMol.getAtomListString(n) + "]";
            if (string7.length() > 5) {
                string7 = string8 + this.mMol.getAtomList(n).length + "]";
            }
            if ((this.mMol.getAtomQueryFeatures(n) & 0x800L) != 0L) {
                n4 = -1;
            }
        } else if ((this.mMol.getAtomQueryFeatures(n) & 1L) != 0L) {
            string7 = "?";
            if ((this.mMol.getAtomQueryFeatures(n) & 0x800L) != 0L) {
                n4 = -1;
            }
        } else if (this.mMol.getAtomicNo(n) != 6 || string2 != null || string != null || n4 > 0 || !this.mAtomIsConnected[n]) {
            string7 = this.mMol.getAtomLabel(n);
        }
        double d6 = 0.0;
        if (!this.mMol.isSelectedAtom(n) & (this.mMol.getAtomQueryFeatures(n) & 0x20000000L) != 0L) {
            this.setColor_(-8);
        }
        if (string7 != null) {
            d6 = this.getStringWidth(string7);
            this.mpDrawString(this.getAtomX(n), this.getAtomY(n), string7, true);
            this.mAtomLabelDisplayed[n] = true;
        } else if (this.mpAlleneCenter(n)) {
            this.mpDrawDot(this.getAtomX(n), this.getAtomY(n), n);
        }
        if (string2 != null) {
            this.mpSetSmallLabelSize();
            d5 = this.getAtomX(n) + ((d6 + this.getStringWidth(string2)) / 2.0 + 1.0);
            d4 = this.getAtomY(n) - (double)((this.getTextSize() * 4 - 4) / 8);
            this.mpDrawString(d5, d4, string2, true);
            this.mpSetNormalLabelSize();
        }
        if ((this.mDisplayMode & 2) != 0) {
            string = String.valueOf(n);
        }
        if (string != null) {
            if (bl) {
                this.mpSetReducedLabelSize();
            } else {
                this.mpSetSmallLabelSize();
            }
            d5 = this.getAtomX(n) - (d6 + this.getStringWidth(string)) / 2.0;
            d4 = this.getAtomY(n) - (double)((this.getTextSize() * 4 - 4) / 8);
            this.mpDrawString(d5, d4, string, true);
            this.mpSetNormalLabelSize();
        }
        if (string4 != null) {
            this.mpSetSmallLabelSize();
            d5 = this.getAtomX(n) - (d6 + this.getStringWidth(string4)) / 2.0;
            d4 = this.getAtomY(n) + (double)((this.getTextSize() * 4 + 4) / 8);
            n3 = this.mCurrentColor;
            if (this.mMol.getMoleculeColor() != 1 && (this.mDisplayMode & 0x1000) == 0) {
                this.setColor_(448);
            }
            this.mpDrawString(d5, d4, string4, false);
            this.setColor_(n3);
            this.mpSetNormalLabelSize();
        }
        if (string5 != null) {
            this.mpSetSmallLabelSize();
            d5 = this.getAtomX(n) + ((d6 + this.getStringWidth(string5)) / 2.0 + 1.0);
            d4 = this.getAtomY(n) + (double)((this.getTextSize() * 4 + 4) / 8);
            n3 = this.mCurrentColor;
            this.setColor_(this.mMol.isAutoMappedAtom(n) ? 384 : 448);
            this.mpDrawString(d5, d4, string5, true);
            this.setColor_(n3);
            this.mpSetNormalLabelSize();
        }
        if (string6 != null) {
            double d7 = this.mpGetFreeSpaceAngle(n);
            this.mpSetSmallLabelSize();
            d5 = this.getAtomX(n) + 0.7 * (double)this.getTextSize() * Math.sin(d7);
            d4 = this.getAtomY(n) + 0.7 * (double)this.getTextSize() * Math.cos(d7);
            n2 = this.mCurrentColor;
            if (!this.mIsValidatingView && this.mMol.getMoleculeColor() != 1) {
                this.setColor_(this.getESRColor(n));
            }
            this.mpDrawString(d5, d4, string6, false);
            this.setColor_(n2);
            this.mpSetNormalLabelSize();
        }
        if (n4 == 0 && n5 == 0) {
            if (this.mCurrentColor == -8) {
                this.setColor_(-9);
            }
            return;
        }
        double[] dArray = new double[4];
        for (int i = 0; i < this.mMol.getAllConnAtomsPlusMetalBonds(n); ++i) {
            n2 = this.mMol.getConnBond(n, i);
            for (int j = 0; j < 2; ++j) {
                if (this.mMol.getBondAtom(j, n2) != n) continue;
                d3 = this.mMol.getBondAngle(this.mMol.getBondAtom(j, n2), this.mMol.getBondAtom(1 - j, n2));
                if (d3 < -1.5707963267948966) {
                    dArray[0] = dArray[0] - (d3 + 1.5707963267948966);
                    dArray[3] = dArray[3] + (d3 + Math.PI);
                    continue;
                }
                if (d3 < 0.0) {
                    dArray[2] = dArray[2] + (d3 + 1.5707963267948966);
                    dArray[3] = dArray[3] - d3;
                    continue;
                }
                if (d3 < 1.5707963267948966) {
                    dArray[1] = dArray[1] + d3;
                    dArray[2] = dArray[2] + (1.5707963267948966 - d3);
                    continue;
                }
                dArray[0] = dArray[0] + (d3 - 1.5707963267948966);
                dArray[1] = dArray[1] + (Math.PI - d3);
            }
        }
        if (this.mMol.getConnAtoms(n) == 0) {
            if (this.mMol.isElectronegative(n)) {
                dArray[3] = dArray[3] - 0.2;
            } else {
                dArray[1] = dArray[1] - 0.2;
            }
        } else {
            dArray[1] = dArray[1] - 0.1;
        }
        if (string2 != null || string5 != null) {
            dArray[1] = dArray[1] + 10.0;
        }
        if (string != null || string4 != null) {
            dArray[3] = dArray[3] + 10.0;
        }
        String string9 = "";
        if (n4 != 0) {
            double d8 = this.getStringWidth("H");
            d3 = 0.0;
            double d9 = this.getTextSize();
            if (n4 == -1) {
                string9 = "n";
                this.mpSetSmallLabelSize();
                d3 = this.getStringWidth(string9);
            } else if (n4 > 1) {
                string9 = String.valueOf(n4);
                this.mpSetSmallLabelSize();
                d3 = this.getStringWidth(string9);
            }
            if (dArray[1] < 0.6 || dArray[3] < 0.6) {
                d2 = this.getAtomY(n);
                if (dArray[1] <= dArray[3]) {
                    dArray[1] = dArray[1] + 10.0;
                    d = this.getAtomX(n) + (d6 + d8) / 2.0;
                } else {
                    dArray[3] = dArray[3] + 10.0;
                    d = this.getAtomX(n) - (d6 + d8) / 2.0 - d3;
                }
            } else {
                d = this.getAtomX(n);
                if (dArray[0] < dArray[2]) {
                    dArray[0] = dArray[0] + 10.0;
                    d2 = this.getAtomY(n) - d9;
                } else {
                    dArray[2] = dArray[2] + 10.0;
                    d2 = this.getAtomY(n) + d9;
                }
            }
            if (d3 > 0.0) {
                d5 = d + (d8 + d3) / 2.0;
                d4 = d2 + (double)((this.getTextSize() * 4 + 4) / 8);
                this.mpDrawString(d5, d4, string9, true);
                this.mpSetNormalLabelSize();
            }
            this.mpDrawString(d, d2, "H", true);
        }
        n2 = 0;
        if (n5 != 0) {
            double d10 = 50.0;
            double d11 = 0.0;
            for (int i = 0; i < 4; ++i) {
                int n6;
                int n7 = n6 = i > 1 ? i - 2 : i + 2;
                if (dArray[i] < d10) {
                    n2 = i;
                    d10 = dArray[i];
                    d11 = dArray[n6];
                    continue;
                }
                if (dArray[i] != d10 || !(dArray[n6] > d11)) continue;
                n2 = i;
                d11 = dArray[n6];
            }
            switch (n2) {
                case 0: {
                    d = this.getAtomX(n);
                    d2 = this.getAtomY(n) - this.mpDotDiameter - d6 / 2.0;
                    break;
                }
                case 1: {
                    d = this.getAtomX(n) + this.mpDotDiameter + d6 / 2.0;
                    d2 = this.getAtomY(n);
                    break;
                }
                case 2: {
                    d = this.getAtomX(n);
                    d2 = this.getAtomY(n) + this.mpDotDiameter + d6 / 2.0;
                    break;
                }
                default: {
                    d = this.getAtomX(n) - this.mpDotDiameter - d6 / 2.0;
                    d2 = this.getAtomY(n);
                }
            }
            if (n5 == 1) {
                this.mpDrawDot(d, d2, n);
            } else {
                double d12;
                double d13;
                switch (n2) {
                    case 0: {
                        d13 = 2.0 * this.mpDotDiameter;
                        d12 = 0.0;
                        d -= this.mpDotDiameter;
                        break;
                    }
                    case 1: {
                        d13 = 0.0;
                        d12 = 2.0 * this.mpDotDiameter;
                        d2 -= this.mpDotDiameter;
                        break;
                    }
                    case 2: {
                        d13 = 2.0 * this.mpDotDiameter;
                        d12 = 0.0;
                        d -= this.mpDotDiameter;
                        break;
                    }
                    default: {
                        d13 = 0.0;
                        d12 = 2.0 * this.mpDotDiameter;
                        d2 -= this.mpDotDiameter;
                    }
                }
                this.mpDrawDot(d, d2, n);
                this.mpDrawDot(d + d13, d2 + d12, n);
            }
        }
        if (this.mCurrentColor == -8) {
            this.setColor_(-9);
        }
    }

    private boolean isSimpleH(int n, int n2) {
        if (this.mMol.getAtomicNo(n) != 1 || !this.mMol.isReallySimpleHydrogen(n)) {
            return false;
        }
        if (n2 < 0 && this.mMol.getConnAtoms(n) > 0) {
            n2 = this.mMol.getConnAtom(n, 0);
        }
        return n2 >= 0 && this.mMol.getAtomicNo(n2) == 6 && (this.mMol.getAtomParity(n2) & 3) == 0;
    }

    private String createRingSizeText(long l) {
        l &= 0x7F00000000L;
        for (int i = 0; i < AtomQueryFeatureDialogBuilder.RING_SIZE_VALUES.length; ++i) {
            if (l != AtomQueryFeatureDialogBuilder.RING_SIZE_VALUES[i]) continue;
            return AtomQueryFeatureDialogBuilder.RING_SIZE_SHORT_TEXT[i];
        }
        StringBuilder stringBuilder = new StringBuilder("R");
        if ((l & 0x100000000L) != 0L) {
            stringBuilder.append("0");
        }
        if ((l & 0x200000000L) != 0L) {
            stringBuilder.append("3");
        }
        if ((l & 0x400000000L) != 0L) {
            stringBuilder.append("4");
        }
        if ((l & 0x800000000L) != 0L) {
            stringBuilder.append("5");
        }
        if ((l & 0x1000000000L) != 0L) {
            stringBuilder.append("6");
        }
        if ((l & 0x2000000000L) != 0L) {
            stringBuilder.append("7");
        }
        if ((l & 0x4000000000L) != 0L) {
            stringBuilder.append("8");
        }
        return stringBuilder.toString();
    }

    private void mpSetNormalLabelSize() {
        this.setTextSize(this.mpLabelSize);
    }

    private void mpSetReducedLabelSize() {
        this.setTextSize((this.mpLabelSize * 5 + 1) / 6);
    }

    private void mpSetSmallLabelSize() {
        this.setTextSize((this.mpLabelSize * 2 + 1) / 3);
    }

    private double mpGetFreeSpaceAngle(int n) {
        double[] dArray = new double[this.mMol.getAllConnAtoms(n)];
        for (int i = 0; i < this.mMol.getAllConnAtoms(n); ++i) {
            dArray[i] = this.mMol.getBondAngle(n, this.mMol.getConnAtom(n, i));
        }
        Arrays.sort(dArray);
        double d = this.mpGetMeanAngle(dArray, 0);
        double d2 = this.mpGetAngleESRScore(dArray, 0, d);
        for (int i = 1; i < dArray.length; ++i) {
            double d3 = this.mpGetMeanAngle(dArray, i);
            double d4 = this.mpGetAngleESRScore(dArray, i, d3);
            if (!(d2 < d4)) continue;
            d2 = d4;
            d = d3;
        }
        return d;
    }

    private double mpGetAngleESRScore(double[] dArray, int n, double d) {
        double d2;
        double d3 = d2 = n == 0 ? Math.PI * 2 + dArray[0] - dArray[dArray.length - 1] : dArray[n] - dArray[n - 1];
        d2 = d > -2.0943951023931953 && d < 1.0471975511965976 ? (d2 -= 2.0 * Math.cos(d + 0.5235987755982988)) : (d2 -= 0.5 * Math.cos(d + 0.5235987755982988));
        return d2;
    }

    private double mpGetMeanAngle(double[] dArray, int n) {
        if (n > 0) {
            return (dArray[n] + dArray[n - 1]) / 2.0;
        }
        double d = Math.PI + (dArray[0] + dArray[dArray.length - 1]) / 2.0;
        return d > Math.PI ? d - Math.PI * 2 : d;
    }

    private String append(String string, String string2) {
        return string == null ? string2 : (string2 == null ? string : string + "," + string2);
    }

    private void mpDrawString(double d, double d2, String string, boolean bl) {
        if (bl) {
            double d3 = this.getStringWidth(string);
            double d4 = d3 / 2.0 + (double)(this.getTextSize() / 8);
            double d5 = this.getTextSize() / 2;
            if (string == "+" || string == "-") {
                d5 = d5 * 2.0 / 3.0;
            }
            this.mpTabuZone.add(new GenericRectangle(d - d4, d2 - d5, 2.0 * d4, 2.0 * d5));
        }
        if (!this.mIsValidatingView) {
            this.drawString(string, d, d2);
        }
    }

    private void mpDrawDot(double d, double d2, int n) {
        this.mpTabuZone.add(new GenericRectangle(d - this.mpDotDiameter, d2 - this.mpDotDiameter, 2.0 * this.mpDotDiameter, 2.0 * this.mpDotDiameter));
        if (!this.mIsValidatingView) {
            this.mpDot.add(new DepictorDot(d, d2, this.isHighlightedAtom(n) ? -3 : this.mAtomColor[n]));
        }
    }

    private void mpDrawAllDots() {
        for (DepictorDot depictorDot : this.mpDot) {
            this.setColor_(depictorDot.color);
            this.drawDot(depictorDot.x, depictorDot.y);
        }
        this.setColor_(this.mStandardForegroundColor);
    }

    private boolean mpAlleneCenter(int n) {
        if (this.mMol.getConnAtoms(n) != 2) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (this.mMol.getConnBondOrder(n, i) == 2) continue;
            return false;
        }
        return true;
    }

    private void mpDrawBondQueryFeatures() {
        boolean bl = false;
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            int n;
            int n2;
            String string = null;
            if (this.mMol.isBondBridge(i)) {
                n2 = this.mMol.getBondBridgeMinSize(i);
                string = n2 == (n = this.mMol.getBondBridgeMaxSize(i)) ? "[" + n2 + "]" : "[" + n2 + ":" + n + "]";
            } else if ((this.mMol.getBondQueryFeatures(i) & 0x600000) != 0) {
                string = (this.mMol.getBondQueryFeatures(i) & 0x600000) == 0x200000 ? "a" : ((this.mMol.getBondQueryFeatures(i) & 0x180) == 256 ? "r!a" : "!a");
            } else if ((this.mMol.getBondQueryFeatures(i) & 0x180) != 0) {
                string = (this.mMol.getBondQueryFeatures(i) & 0x180) == 256 ? "r" : "!r";
            }
            n2 = (this.mMol.getBondQueryFeatures(i) & 0xE0000) >> 17;
            if (n2 != 0) {
                string = (string == null ? "" : string) + n2;
            }
            if (string == null) continue;
            n = this.mMol.getBondAtom(0, i);
            int n3 = this.mMol.getBondAtom(1, i);
            if (!bl) {
                this.mpSetSmallLabelSize();
                bl = true;
            }
            double d = (this.getAtomX(n) + this.getAtomX(n3)) / 2.0;
            double d2 = (this.getAtomY(n) + this.getAtomY(n3)) / 2.0;
            double d3 = this.getAtomX(n3) - this.getAtomX(n);
            double d4 = this.getAtomY(n3) - this.getAtomY(n);
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = 0.6 * this.getStringWidth(string);
            double d7 = 0.55 * (double)this.getTextSize();
            if (d5 == 0.0) continue;
            if (d3 > 0.0) {
                this.mpDrawString(d + d6 * d4 / d5, d2 - d7 * d3 / d5, string, true);
                continue;
            }
            this.mpDrawString(d - d6 * d4 / d5, d2 + d7 * d3 / d5, string, true);
        }
        if (bl) {
            this.mpSetNormalLabelSize();
        }
    }

    private void drawLine(DepictorLine depictorLine, int n, int n2) {
        if (this.mMol.isBondForegroundHilited(this.mMol.getBond(n, n2))) {
            this.setColor_(-3);
            this.drawBlackLine(depictorLine);
            this.setColor_(this.mStandardForegroundColor);
        } else if (this.mAtomColor[n] != this.mAtomColor[n2]) {
            this.drawColorLine(depictorLine, n, n2);
        } else if (this.mAtomColor[n] != 0) {
            this.setColor_(this.mAtomColor[n]);
            this.drawBlackLine(depictorLine);
            this.setColor_(this.mStandardForegroundColor);
        } else {
            this.drawBlackLine(depictorLine);
        }
    }

    private void drawColorLine(DepictorLine depictorLine, int n, int n2) {
        DepictorLine depictorLine2 = new DepictorLine();
        DepictorLine depictorLine3 = new DepictorLine();
        depictorLine2.x1 = depictorLine.x1;
        depictorLine2.y1 = depictorLine.y1;
        depictorLine2.x2 = (depictorLine.x1 + depictorLine.x2) / 2.0;
        depictorLine2.y2 = (depictorLine.y1 + depictorLine.y2) / 2.0;
        depictorLine3.x1 = depictorLine2.x2;
        depictorLine3.y1 = depictorLine2.y2;
        depictorLine3.x2 = depictorLine.x2;
        depictorLine3.y2 = depictorLine.y2;
        if (this.mpProperLine(depictorLine2)) {
            this.setColor_(this.mAtomColor[n]);
            this.drawBlackLine(depictorLine2);
        }
        if (this.mpProperLine(depictorLine3)) {
            this.setColor_(this.mAtomColor[n2]);
            this.drawBlackLine(depictorLine3);
        }
        this.setColor_(this.mStandardForegroundColor);
    }

    private void drawDashedLine(DepictorLine depictorLine, int n, int n2) {
        int n3;
        int n4;
        double d = (depictorLine.x2 - depictorLine.x1) / 10.0;
        double d2 = (depictorLine.y2 - depictorLine.y1) / 10.0;
        DepictorLine depictorLine2 = new DepictorLine();
        if (this.mMol.isBondForegroundHilited(this.mMol.getBond(n, n2))) {
            n4 = -3;
            n3 = -3;
        } else {
            n4 = this.mAtomColor[n];
            n3 = this.mAtomColor[n2];
        }
        this.setColor_(n4);
        depictorLine2.x1 = depictorLine.x1;
        depictorLine2.y1 = depictorLine.y1;
        depictorLine2.x2 = depictorLine.x1 + d * 2.0;
        depictorLine2.y2 = depictorLine.y1 + d2 * 2.0;
        this.drawBlackLine(depictorLine2);
        depictorLine2.x1 = depictorLine.x1 + d * 4.0;
        depictorLine2.y1 = depictorLine.y1 + d2 * 4.0;
        depictorLine2.x2 = depictorLine.x1 + d * 5.0;
        depictorLine2.y2 = depictorLine.y1 + d2 * 5.0;
        this.drawBlackLine(depictorLine2);
        this.setColor_(n3);
        depictorLine2.x1 = depictorLine.x1 + d * 5.0;
        depictorLine2.y1 = depictorLine.y1 + d2 * 5.0;
        depictorLine2.x2 = depictorLine.x1 + d * 6.0;
        depictorLine2.y2 = depictorLine.y1 + d2 * 6.0;
        this.drawBlackLine(depictorLine2);
        depictorLine2.x1 = depictorLine.x1 + d * 8.0;
        depictorLine2.y1 = depictorLine.y1 + d2 * 8.0;
        depictorLine2.x2 = depictorLine.x2;
        depictorLine2.y2 = depictorLine.y2;
        this.drawBlackLine(depictorLine2);
        this.setColor_(this.mStandardForegroundColor);
    }

    private void drawShortDashedLine(DepictorLine depictorLine, int n, int n2) {
        int n3;
        int n4;
        int n5;
        double d = depictorLine.x2 - depictorLine.x1;
        double d2 = depictorLine.y2 - depictorLine.y1;
        double d3 = Math.sqrt(d * d + d2 * d2);
        int n6 = 2 * (int)Math.round(d3 / (4.0 * this.mpLineWidth));
        double d4 = d / (double)(n6 - 1);
        double d5 = d2 / (double)(n6 - 1);
        if (this.mMol.isBondForegroundHilited(this.mMol.getBond(n, n2))) {
            n5 = -3;
            n4 = -3;
        } else {
            n5 = this.mAtomColor[n];
            n4 = this.mAtomColor[n2];
        }
        double d6 = depictorLine.x1 - this.mpLineWidth / 2.0;
        double d7 = depictorLine.y1 - this.mpLineWidth / 2.0;
        this.setColor_(n5);
        for (n3 = 0; n3 < n6 / 2; ++n3) {
            this.fillCircle(d6, d7, this.mpLineWidth);
            d6 += d4;
            d7 += d5;
        }
        this.setColor_(n4);
        for (n3 = 0; n3 < n6 / 2; ++n3) {
            this.fillCircle(d6, d7, this.mpLineWidth);
            d6 += d4;
            d7 += d5;
        }
        this.setColor_(this.mStandardForegroundColor);
    }

    private void drawWedge(DepictorLine depictorLine, int n, int n2) {
        int n3;
        int n4;
        double d = (depictorLine.y1 - depictorLine.y2) / 9.0;
        double d2 = (depictorLine.x2 - depictorLine.x1) / 9.0;
        double d3 = depictorLine.x2 + d;
        double d4 = depictorLine.y2 + d2;
        double d5 = depictorLine.x2 - d;
        double d6 = depictorLine.y2 - d2;
        double d7 = (depictorLine.x1 + d3) / 2.0;
        double d8 = (depictorLine.y1 + d4) / 2.0;
        double d9 = (depictorLine.x1 + d5) / 2.0;
        double d10 = (depictorLine.y1 + d6) / 2.0;
        GenericPolygon genericPolygon = new GenericPolygon(3);
        GenericPolygon genericPolygon2 = new GenericPolygon(4);
        genericPolygon.addPoint(depictorLine.x1, depictorLine.y1);
        genericPolygon.addPoint(d7, d8);
        genericPolygon.addPoint(d9, d10);
        genericPolygon2.addPoint(d9, d10);
        genericPolygon2.addPoint(d7, d8);
        genericPolygon2.addPoint(d3, d4);
        genericPolygon2.addPoint(d5, d6);
        if (this.mMol.isBondForegroundHilited(this.mMol.getBond(n, n2))) {
            n4 = -3;
            n3 = -3;
        } else {
            n4 = this.mAtomColor[n];
            n3 = this.mAtomColor[n2];
            if (this.mMol.getMoleculeColor() != 1) {
                n3 = this.getESRColor(n);
                if (n4 == this.mMol.getAtomColor(n)) {
                    n4 = n3;
                }
            }
        }
        this.setColor_(n4);
        this.drawPolygon(genericPolygon);
        this.setColor_(n3);
        this.drawPolygon(genericPolygon2);
        this.setColor_(this.mStandardForegroundColor);
    }

    protected void drawDot(double d, double d2) {
        this.fillCircle(d - this.mpDotDiameter / 2.0, d2 - this.mpDotDiameter / 2.0, this.mpDotDiameter);
    }

    private void setRGBColor(int n) {
        if (this.mOverruleForeground != 0) {
            if (this.mCurrentColor != -4) {
                this.mCurrentColor = -4;
                this.setRGB(this.mOverruleForeground);
            }
            return;
        }
        this.mCurrentColor = -5;
        this.mRGBColor = n;
        this.setRGB(n);
    }

    private void setColor_(int n) {
        if (this.mIsValidatingView) {
            return;
        }
        if (n == -10) {
            this.mCurrentColor = -999;
            n = this.mStandardForegroundColor;
        }
        if (n != -2 && n != -7 && this.mOverruleForeground != 0) {
            n = -4;
        }
        if (n == this.mCurrentColor) {
            return;
        }
        if (this.mCurrentColor == -8 && n != -9) {
            return;
        }
        if (n == -8) {
            this.mPreviousColor = this.mCurrentColor;
        }
        if (n == -9) {
            n = this.mPreviousColor;
        }
        this.mCurrentColor = n;
        switch (n) {
            case 0: {
                this.setRGB(this.mCustomForeground == 0 ? -16777216 : this.mCustomForeground);
                break;
            }
            case -6: {
                this.setRGB(this.mCustomForeground);
                break;
            }
            case -4: {
                this.setRGB(this.mOverruleForeground);
                break;
            }
            case -2: {
                this.setRGB(this.mBondBGHiliteColor);
                break;
            }
            case -3: {
                this.setRGB(this.mBondFGHiliteColor);
                break;
            }
            case -7: {
                this.setRGB(this.mExcludeGroupBGColor);
                break;
            }
            case -8: {
                this.setRGB(this.mExcludeGroupFGColor);
                break;
            }
            case -5: {
                this.setRGB(this.mRGBColor);
                break;
            }
            case 64: {
                this.setRGB(-14655233);
                break;
            }
            case 128: {
                this.setRGB(-65536);
                break;
            }
            case 256: {
                this.setRGB(-4194049);
                break;
            }
            case 192: {
                this.setRGB(-16711936);
                break;
            }
            case 320: {
                this.setRGB(-24576);
                break;
            }
            case 384: {
                this.setRGB(-16744448);
                break;
            }
            case 448: {
                this.setRGB(-6291456);
                break;
            }
            case 1: {
                this.setRGB(-8355712);
                break;
            }
            default: {
                this.setRGB(-16777216);
            }
        }
    }

    private int getESRTypeToDisplayAt(int n) {
        int n2;
        int n3 = -1;
        int n4 = -1;
        if ((this.mDisplayMode & 0x80) != 0) {
            return n3;
        }
        if (this.mMol.isAtomStereoCenter(n)) {
            n3 = this.mMol.getAtomESRType(n);
            n4 = this.mMol.getAtomESRGroup(n);
        }
        if ((n2 = this.mMol.findBINAPChiralityBond(n)) != -1) {
            n3 = this.mMol.getBondESRType(n2);
            n4 = this.mMol.getBondESRGroup(n2);
        }
        if (n3 != -1 && n3 != 0) {
            n3 |= n4 << 8;
        }
        return n3;
    }

    private int getESRColor(int n) {
        int n2;
        if ((this.mDisplayMode & 0x1080) != 0) {
            return this.mAtomColor[n];
        }
        int n3 = this.getESRTypeToDisplayAt(n);
        if (n3 == -1 && (n2 = this.mMol.findAlleneCenterAtom(n)) != -1) {
            n = n2;
            n3 = this.getESRTypeToDisplayAt(n);
        }
        if (n3 == -1) {
            return this.mAtomColor[n];
        }
        switch (n3 & 0xFF) {
            case 1: {
                return 384;
            }
            case 2: {
                return 64;
            }
        }
        return 448;
    }

    protected abstract void drawBlackLine(DepictorLine var1);

    protected abstract void drawDottedLine(DepictorLine var1);

    protected abstract void drawPolygon(GenericPolygon var1);

    protected abstract void drawString(String var1, double var2, double var4);

    protected abstract void fillCircle(double var1, double var3, double var5);

    protected abstract double getLineWidth();

    protected abstract double getStringWidth(String var1);

    protected abstract int getTextSize();

    protected abstract void setTextSize(int var1);

    protected abstract void setLineWidth(double var1);

    protected abstract void setRGB(int var1);

    public static class DepictorLine {
        public double x1;
        public double y1;
        public double x2;
        public double y2;

        public DepictorLine(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.y1 = d2;
            this.x2 = d3;
            this.y2 = d4;
        }

        public DepictorLine() {
        }
    }

    public static class DepictorDot {
        public double x;
        public double y;
        public int color;

        DepictorDot(double d, double d2, int n) {
            this.x = d;
            this.y = d2;
            this.color = n;
        }
    }
}

