/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.svm;

import com.actelion.research.calc.regression.ParameterRegressionMethod;
import com.actelion.research.calc.regression.svm.SVMParameterHelper;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.machinelearning.svm.libsvm.svm_parameter;

public class ParameterSVM
extends ParameterRegressionMethod {
    public static final String TAG_SVM_TYPE = "SVMRegressionType";
    public static final String TAG_KERNEL = "Kernel";
    public static final String TAG_DEGREE = "Degree";
    public static final String TAG_GAMMA = "Gamma";
    public static final String TAG_COEF0 = "Coef0";
    public static final String TAG_CACHE_SIZE = "CacheSize";
    public static final String TAG_EPSILON = "Epsilon";
    public static final String TAG_C = "C";
    public static final String TAG_NR_WEIGHT = "nrWeight";
    public static final String TAG_NU = "Nu";
    public static final String TAG_P = "p";
    public static final String TAG_SHRINKING = "Shrinking";
    public static final String TAG_PROBABILITY = "Probability";
    private int svmType;
    private int kernelType;
    private int degree;
    private double gamma;
    private double coef0;
    private double cache_size;
    private double eps;
    private double C;
    private int nr_weight;
    private int[] weight_label;
    private double[] weight;
    private double nu;
    private double p;
    private int shrinking;
    private int probability;

    public ParameterSVM() {
        this(SVMParameterHelper.regressionEpsilonSVR());
        this.initializeProperties();
    }

    public ParameterSVM(double d) {
        this(SVMParameterHelper.standard());
        this.setNu(d);
    }

    public ParameterSVM(ParameterSVM parameterSVM) {
        super("SVM regression");
        this.svmType = parameterSVM.svmType;
        this.kernelType = parameterSVM.kernelType;
        this.degree = parameterSVM.degree;
        this.gamma = parameterSVM.gamma;
        this.coef0 = parameterSVM.coef0;
        this.cache_size = parameterSVM.cache_size;
        this.eps = parameterSVM.eps;
        this.C = parameterSVM.C;
        this.nr_weight = parameterSVM.nr_weight;
        this.weight_label = parameterSVM.weight_label;
        this.weight = parameterSVM.weight;
        this.nu = parameterSVM.nu;
        this.p = parameterSVM.p;
        this.shrinking = parameterSVM.shrinking;
        this.probability = parameterSVM.probability;
        this.initializeProperties();
    }

    public ParameterSVM(svm_parameter svm_parameter2) {
        super("SVM regression");
        this.svmType = svm_parameter2.svm_type;
        this.kernelType = svm_parameter2.kernel_type;
        this.degree = svm_parameter2.degree;
        this.gamma = svm_parameter2.gamma;
        this.coef0 = svm_parameter2.coef0;
        this.cache_size = svm_parameter2.cache_size;
        this.eps = svm_parameter2.eps;
        this.C = svm_parameter2.C;
        this.nr_weight = svm_parameter2.nr_weight;
        this.weight_label = svm_parameter2.weight_label;
        this.weight = svm_parameter2.weight;
        this.nu = svm_parameter2.nu;
        this.p = svm_parameter2.p;
        this.shrinking = svm_parameter2.shrinking;
        this.probability = svm_parameter2.probability;
        this.initializeProperties();
    }

    private void initializeProperties() {
        if (this.svmType != 3) {
            System.out.println("Error: only Epsilon support vector regression possible!");
            System.out.println("Error: opsilon support vector regression possible!");
            System.out.println("Error: opsilon support vector regression possible!");
            throw new RuntimeException("Only Epsilon support vector regression possible!");
        }
        this.setSVMRegressionType(this.svmType);
        this.setKernelType(this.kernelType);
        this.setEpsilon(this.eps);
        this.setC(this.C);
        this.setGamma(this.gamma);
    }

    public svm_parameter getSvmParameter() {
        svm_parameter svm_parameter2 = new svm_parameter();
        svm_parameter2.svm_type = this.svmType;
        svm_parameter2.kernel_type = this.kernelType;
        svm_parameter2.degree = this.degree;
        svm_parameter2.gamma = this.gamma;
        svm_parameter2.coef0 = this.coef0;
        svm_parameter2.cache_size = this.cache_size;
        svm_parameter2.eps = this.eps;
        svm_parameter2.C = this.C;
        svm_parameter2.nr_weight = this.nr_weight;
        svm_parameter2.weight_label = this.weight_label;
        svm_parameter2.weight = this.weight;
        svm_parameter2.nu = this.nu;
        svm_parameter2.p = this.p;
        svm_parameter2.shrinking = this.shrinking;
        svm_parameter2.probability = this.probability;
        return svm_parameter2;
    }

    protected ParameterSVM(String string) {
        super(string);
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getNu() {
        return this.nu;
    }

    public void setGamma(double d) {
        this.gamma = d;
        this.properties.put(TAG_GAMMA, Double.toString(d));
    }

    public void setNu(double d) {
        this.nu = d;
        this.properties.put(TAG_NU, Double.toString(d));
    }

    public void setSVMRegressionType(int n) {
        if (n != 3) {
            throw new RuntimeException("Only Epsilon support vector regression possible!");
        }
        this.svmType = n;
        this.properties.put(TAG_SVM_TYPE, Integer.toString(n));
    }

    public void setEpsilon(double d) {
        this.eps = d;
        this.properties.put(TAG_EPSILON, Double.toString(d));
    }

    public void setKernelType(int n) {
        this.kernelType = n;
        this.properties.put(TAG_KERNEL, Integer.toString(n));
    }

    public void setC(double d) {
        this.C = d;
        this.properties.put(TAG_C, Double.toString(d));
    }

    @Override
    public int compareTo(ParameterRegressionMethod parameterRegressionMethod) {
        int n = 0;
        ParameterSVM parameterSVM = (ParameterSVM)parameterRegressionMethod;
        if (this.svmType > parameterSVM.svmType) {
            n = 1;
        } else if (this.svmType < parameterSVM.svmType) {
            n = -1;
        }
        if (n == 0) {
            if (this.kernelType > parameterSVM.kernelType) {
                n = 1;
            } else if (this.kernelType < parameterSVM.kernelType) {
                n = -1;
            }
        }
        if (n == 0) {
            if (this.degree > parameterSVM.degree) {
                n = 1;
            } else if (this.degree < parameterSVM.degree) {
                n = -1;
            }
        }
        if (n == 0) {
            if (this.gamma > parameterSVM.gamma) {
                n = 1;
            } else if (this.gamma < parameterSVM.gamma) {
                n = -1;
            }
        }
        if (n == 0) {
            if (this.nu > parameterSVM.nu) {
                n = 1;
            } else if (this.nu < parameterSVM.nu) {
                n = -1;
            }
        }
        if (n == 0) {
            if (this.C > parameterSVM.C) {
                n = 1;
            } else if (this.C < parameterSVM.C) {
                n = -1;
            }
        }
        if (n == 0) {
            if (this.eps > parameterSVM.eps) {
                n = 1;
            } else if (this.eps < parameterSVM.eps) {
                n = -1;
            }
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (!bl) {
            return false;
        }
        if (!(object instanceof ParameterSVM)) {
            return false;
        }
        ParameterSVM parameterSVM = (ParameterSVM)object;
        if (this.nr_weight != parameterSVM.nr_weight) {
            return false;
        }
        if ((double)Math.abs(this.nr_weight - parameterSVM.nr_weight) > 1.0E-8) {
            return false;
        }
        if (Math.abs(this.gamma - parameterSVM.gamma) > 1.0E-8) {
            return false;
        }
        if (Math.abs(this.eps - parameterSVM.eps) > 1.0E-8) {
            return false;
        }
        if (Math.abs(this.C - parameterSVM.C) > 1.0E-8) {
            return false;
        }
        if (Math.abs(this.nu - parameterSVM.nu) > 1.0E-8) {
            return false;
        }
        if (Math.abs(this.cache_size - parameterSVM.cache_size) > 1.0E-8) {
            return false;
        }
        if (Math.abs(this.coef0 - parameterSVM.coef0) > 1.0E-8) {
            return false;
        }
        if (Math.abs(this.p - parameterSVM.p) > 1.0E-8) {
            return false;
        }
        if (this.svmType != parameterSVM.svmType) {
            return false;
        }
        if (this.degree != parameterSVM.degree) {
            return false;
        }
        if (this.kernelType != parameterSVM.kernelType) {
            return false;
        }
        if (this.probability != parameterSVM.probability) {
            return false;
        }
        if (this.shrinking != parameterSVM.shrinking) {
            return false;
        }
        if (!Arrays.equals(this.weight, parameterSVM.weight)) {
            return false;
        }
        if (!Arrays.equals(this.weight_label, parameterSVM.weight_label)) {
            return false;
        }
        return bl;
    }

    @Override
    protected void decodeProperties2Parameter() {
        this.svmType = Integer.parseInt(this.properties.getProperty(TAG_SVM_TYPE));
        this.kernelType = Integer.parseInt(this.properties.getProperty(TAG_KERNEL));
        this.C = Double.parseDouble(this.properties.getProperty(TAG_C));
        this.gamma = Double.parseDouble(this.properties.getProperty(TAG_GAMMA));
        this.eps = Double.parseDouble(this.properties.getProperty(TAG_EPSILON));
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        StringBuilder stringBuilder = new StringBuilder("ParameterSVM{");
        stringBuilder.append("name=").append(this.getName());
        stringBuilder.append(" svm type=").append(SVMParameterHelper.getSVMType(this.svmType));
        stringBuilder.append(" kernel_type=").append(SVMParameterHelper.getKernelType(this.kernelType));
        stringBuilder.append(" degree=").append(this.degree);
        stringBuilder.append(" gamma=").append(decimalFormat.format(this.gamma));
        stringBuilder.append(" coef0=").append(decimalFormat.format(this.coef0));
        stringBuilder.append(" cache_size=").append(decimalFormat.format(this.cache_size));
        stringBuilder.append(" eps=").append(decimalFormat.format(this.eps));
        stringBuilder.append(" C=").append(decimalFormat.format(this.C));
        stringBuilder.append(" nr_weight=").append(this.nr_weight);
        stringBuilder.append(" nu=").append(decimalFormat.format(this.nu));
        stringBuilder.append(" p=").append(decimalFormat.format(this.p));
        stringBuilder.append(" shrinking=").append(this.shrinking);
        stringBuilder.append(" probability=").append(this.probability);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static List<String> getHeader() {
        List<String> list = ParameterRegressionMethod.getHeader();
        list.add(TAG_SVM_TYPE);
        list.add(TAG_KERNEL);
        list.add(TAG_DEGREE);
        list.add(TAG_GAMMA);
        list.add(TAG_COEF0);
        list.add(TAG_CACHE_SIZE);
        list.add(TAG_EPSILON);
        list.add(TAG_C);
        list.add(TAG_NR_WEIGHT);
        list.add(TAG_NU);
        list.add(TAG_P);
        list.add(TAG_SHRINKING);
        list.add(TAG_PROBABILITY);
        return list;
    }
}

