/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.linear.pls;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.MatrixFunctions;
import com.actelion.research.calc.MatrixTests;

public class SimPLS {
    protected Matrix R = new Matrix();
    protected Matrix T = new Matrix();
    protected Matrix P = new Matrix();
    protected Matrix Q = new Matrix();
    protected Matrix U = new Matrix();
    protected Matrix V = new Matrix();
    protected Matrix B = new Matrix();
    protected Matrix EX = new Matrix();
    protected Matrix EY = new Matrix();
    protected Matrix ES = new Matrix();

    public static Matrix invLinReg_Yhat(Matrix matrix, Matrix matrix2, Matrix matrix3, Matrix matrix4) {
        Matrix matrix5 = new Matrix(matrix3);
        Matrix matrix6 = new Matrix();
        Matrix matrix7 = new Matrix(matrix3.getRowDim(), matrix4.getColDim());
        Matrix matrix8 = matrix2.getMeanCols();
        double[] dArray = matrix8.toArray();
        if (matrix.getMaximumValue() < Double.MAX_VALUE) {
            int n;
            int n2 = matrix3.rows();
            int n3 = matrix2.cols();
            for (n = 0; n < n2; ++n) {
                double[] dArray2 = matrix5.getRow(n);
                for (int i = 0; i < n3; ++i) {
                    int n4 = i;
                    dArray2[n4] = dArray2[n4] - dArray[i];
                }
            }
            matrix6 = matrix5.multiply(matrix);
            for (n = 0; n < matrix4.getColDim(); ++n) {
                double d = matrix4.getMeanCol(n);
                for (int i = 0; i < matrix7.getRowDim(); ++i) {
                    double d2 = matrix6.get(i, n) + d;
                    matrix7.set(i, n, d2);
                }
            }
        } else {
            matrix7.resize(matrix3.getRowDim(), matrix4.getColDim());
            matrix7.set(2.147483647E9);
        }
        return matrix7;
    }

    public static Matrix invLinReg_Yhat(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = new Matrix();
        if (matrix.getMaximumValue() < Double.MAX_VALUE) {
            matrix3 = matrix2.multiply(matrix);
        } else {
            matrix3.resize(matrix2.getRowDim(), matrix.cols());
            matrix3.set(2.147483647E9);
        }
        return matrix3;
    }

    public Matrix getExplainedVarS() {
        return this.ES;
    }

    public Matrix getExplainedVarX() {
        return this.EX;
    }

    public Matrix getExplainedVarY() {
        return this.EY;
    }

    public Matrix getP() {
        return this.P;
    }

    public Matrix getQ() {
        return this.Q;
    }

    public Matrix getR() {
        return this.R;
    }

    public Matrix getT() {
        return this.T;
    }

    public Matrix getU() {
        return this.U;
    }

    public Matrix getV() {
        return this.V;
    }

    public void simPlsSave(Matrix matrix, Matrix matrix2, int n) {
        Matrix matrix3 = new Matrix(matrix2);
        Matrix matrix4 = matrix.multiply(true, false, matrix3);
        Matrix matrix5 = new Matrix();
        Matrix matrix6 = new Matrix();
        Matrix matrix7 = new Matrix();
        this.B = null;
        this.EX = null;
        this.EY = null;
        this.ES = null;
        int n2 = 0;
        int n3 = n;
        if (matrix.getRowDim() <= matrix.getColDim()) {
            n2 = matrix.getRowDim();
        } else if (matrix.getRowDim() > matrix.getColDim()) {
            n2 = matrix.getColDim();
        }
        if (n3 > n2) {
            n3 = n2;
        }
        for (int i = 1; i < n3 + 1; ++i) {
            Matrix matrix8;
            int n4;
            Matrix matrix9 = matrix4.multiply(true, false, matrix4);
            Matrix.getEigenvector(matrix9, matrix9.getRowDim(), matrix5, matrix6);
            int n5 = 0;
            double d = matrix5.get(0, 0);
            for (n4 = 1; n4 < matrix5.getRowDim(); ++n4) {
                if (!(d < matrix5.get(n4, 0))) continue;
                d = matrix5.get(n4, 0);
                n5 = n4;
            }
            matrix7.resize(matrix9.getRowDim(), 1);
            for (n4 = 0; n4 < matrix5.getRowDim(); ++n4) {
                matrix7.set(n4, 0, matrix9.get(n4, n5));
            }
            Matrix matrix10 = matrix4.multiply(false, false, matrix7);
            Matrix matrix11 = matrix.multiply(false, false, matrix10);
            Matrix matrix12 = (matrix11 = matrix11.getCenteredMatrix()).multiply(true, false, matrix11);
            if (!(Math.sqrt(matrix12.get(0, 0)) > 1.0E-49)) {
                System.err.println("Division by ZERO error in SimPls(...), normt. Factor " + i + ".");
                break;
            }
            double d2 = Math.sqrt(matrix12.get(0, 0));
            matrix11 = matrix11.devide(d2);
            matrix10 = matrix10.devide(d2);
            Matrix matrix13 = matrix.multiply(true, false, matrix11);
            matrix7 = matrix3.multiply(true, false, matrix11);
            Matrix matrix14 = matrix3.multiply(false, false, matrix7);
            Matrix matrix15 = matrix13;
            if (i > 1) {
                Matrix matrix16 = this.V.multiply(true, false, matrix13);
                matrix15 = matrix15.subtract(this.V.multiply(false, false, matrix16));
                Matrix matrix17 = this.T.multiply(true, false, matrix14);
                matrix14 = matrix14.subtract(this.T.multiply(false, false, matrix17));
            }
            if (!((matrix8 = matrix15.multiply(true, false, matrix15)).get(0, 0) > 1.0E-49)) {
                System.err.println("Division by ZERO error in SimPlsSave(...), normv. Factor " + i + ".");
                break;
            }
            d2 = Math.sqrt(matrix8.get(0, 0));
            matrix15 = matrix15.devide(d2);
            Matrix matrix18 = matrix15.multiply(true, false, matrix4);
            matrix4 = matrix4.subtract(matrix15.multiply(false, false, matrix18));
            this.R.resize(matrix10.getRowDim(), i);
            this.R.assignCol(i - 1, matrix10);
            this.T.resize(matrix11.getRowDim(), i);
            this.T.assignCol(i - 1, matrix11);
            this.P.resize(matrix13.getRowDim(), i);
            this.P.assignCol(i - 1, matrix13);
            this.Q.resize(matrix7.getRowDim(), i);
            this.Q.assignCol(i - 1, matrix7);
            this.U.resize(matrix14.getRowDim(), i);
            this.U.assignCol(i - 1, matrix14);
            this.V.resize(matrix15.getRowDim(), i);
            this.V.assignCol(i - 1, matrix15);
        }
    }

    public void simPlsSaveExplainedVariance(Matrix matrix, Matrix matrix2, int n) {
        Matrix matrix3 = new Matrix(matrix2);
        Matrix matrix4 = matrix.multiply(true, false, matrix3);
        Matrix matrix5 = new Matrix(matrix4);
        Matrix matrix6 = new Matrix();
        Matrix matrix7 = new Matrix();
        Matrix matrix8 = new Matrix();
        int n2 = 0;
        int n3 = n;
        if (matrix.getRowDim() <= matrix.getColDim()) {
            n2 = matrix.getRowDim();
        } else if (matrix.getRowDim() > matrix.getColDim()) {
            n2 = matrix.getColDim();
        }
        if (n3 > n2) {
            n3 = n2;
        }
        for (int i = 1; i < n3 + 1; ++i) {
            Matrix matrix9;
            int n4;
            Matrix matrix10 = matrix4.multiply(true, false, matrix4);
            Matrix.getEigenvector(matrix10, matrix10.getRowDim(), matrix6, matrix7);
            int n5 = 0;
            double d = matrix6.get(0, 0);
            for (n4 = 1; n4 < matrix6.getRowDim(); ++n4) {
                if (!(d < matrix6.get(n4, 0))) continue;
                d = matrix6.get(n4, 0);
                n5 = n4;
            }
            matrix8.resize(matrix10.getRowDim(), 1);
            for (n4 = 0; n4 < matrix6.getRowDim(); ++n4) {
                matrix8.set(n4, 0, matrix10.get(n4, n5));
            }
            Matrix matrix11 = matrix4.multiply(false, false, matrix8);
            Matrix matrix12 = matrix.multiply(false, false, matrix11);
            Matrix matrix13 = (matrix12 = matrix12.getCenteredMatrix()).multiply(true, false, matrix12);
            if (!(Math.sqrt(matrix13.get(0, 0)) > 1.0E-49)) {
                System.err.println("Division by ZERO error in SimPlsSave(...), normt. Factor " + i + ".");
                break;
            }
            double d2 = Math.sqrt(matrix13.get(0, 0));
            matrix12 = matrix12.devide(d2);
            matrix11 = matrix11.devide(d2);
            Matrix matrix14 = matrix.multiply(true, false, matrix12);
            matrix8 = matrix3.multiply(true, false, matrix12);
            Matrix matrix15 = matrix3.multiply(false, false, matrix8);
            Matrix matrix16 = matrix14;
            if (i > 1) {
                Matrix matrix17 = this.V.multiply(true, false, matrix14);
                matrix16 = matrix16.subtract(this.V.multiply(false, false, matrix17));
                Matrix matrix18 = this.T.multiply(true, false, matrix15);
                matrix15 = matrix15.subtract(this.T.multiply(false, false, matrix18));
            }
            if (!((matrix9 = matrix16.multiply(true, false, matrix16)).get(0, 0) > 1.0E-49)) {
                System.err.println("Division by ZERO error in SimPlsSave(...), normv. Factor " + i + ".");
                break;
            }
            d2 = Math.sqrt(matrix9.get(0, 0));
            matrix16 = matrix16.devide(d2);
            Matrix matrix19 = matrix16.multiply(true, false, matrix4);
            matrix4 = matrix4.subtract(matrix16.multiply(false, false, matrix19));
            this.R.resize(matrix11.getRowDim(), i);
            this.R.assignCol(i - 1, matrix11);
            this.T.resize(matrix12.getRowDim(), i);
            this.T.assignCol(i - 1, matrix12);
            this.P.resize(matrix14.getRowDim(), i);
            this.P.assignCol(i - 1, matrix14);
            this.Q.resize(matrix8.getRowDim(), i);
            this.Q.assignCol(i - 1, matrix8);
            this.U.resize(matrix15.getRowDim(), i);
            this.U.assignCol(i - 1, matrix15);
            this.V.resize(matrix16.getRowDim(), i);
            this.V.assignCol(i - 1, matrix16);
            Matrix matrix20 = this.T.multiply(false, true, this.P);
            double d3 = MatrixFunctions.getCorrPearson(matrix20, matrix);
            this.EX.resize(1, i);
            this.EX.set(0, i - 1, d3);
            Matrix matrix21 = matrix11.multiply(false, true, matrix8);
            this.B.resize(matrix21.getRowDim(), matrix21.getColDim());
            this.B = this.B.plus(matrix21);
            Matrix matrix22 = matrix.multiply(this.B);
            this.EY.resize(1, i);
            double d4 = MatrixFunctions.getCorrPearson(matrix22, matrix3);
            this.EY.set(0, i - 1, d4);
            Matrix matrix23 = matrix20.multiply(true, false, matrix22);
            double d5 = MatrixFunctions.getCorrPearson(matrix23, matrix5);
            this.ES.resize(1, i);
            this.ES.set(0, i - 1, d5);
        }
    }

    private static double explainedVariance(Matrix matrix, Matrix matrix2) {
        double d = 0.0;
        Matrix matrix3 = null;
        matrix3 = matrix.devideDivisorBigger(matrix2);
        System.out.println("percent\n" + matrix3.toString(3));
        d = Math.abs(matrix3.getMean());
        return d;
    }

    public void simPlsSave(Matrix matrix, Matrix matrix2, Matrix matrix3, Matrix matrix4, int n) {
        Matrix matrix5 = new Matrix(matrix2);
        Matrix matrix6 = matrix.multiply(true, false, matrix5);
        Matrix matrix7 = new Matrix();
        Matrix matrix8 = new Matrix();
        Matrix matrix9 = new Matrix();
        int n2 = 0;
        int n3 = n;
        if (matrix.getRowDim() <= matrix.getColDim()) {
            n2 = matrix.getRowDim();
        } else if (matrix.getRowDim() > matrix.getColDim()) {
            n2 = matrix.getColDim();
        }
        if (n3 > n2) {
            n3 = n2;
        }
        for (int i = 1; i < n3 + 1; ++i) {
            Matrix matrix10;
            int n4;
            Matrix matrix11 = matrix6.multiply(true, false, matrix6);
            Matrix.getEigenvector(matrix11, matrix11.getRowDim(), matrix7, matrix8);
            int n5 = 0;
            double d = matrix7.get(0, 0);
            for (n4 = 1; n4 < matrix7.getRowDim(); ++n4) {
                if (!(d < matrix7.get(n4, 0))) continue;
                d = matrix7.get(n4, 0);
                n5 = n4;
            }
            matrix9.resize(matrix11.getRowDim(), 1);
            for (n4 = 0; n4 < matrix7.getRowDim(); ++n4) {
                matrix9.set(n4, 0, matrix11.get(n4, n5));
            }
            Matrix matrix12 = matrix6.multiply(false, false, matrix9);
            Matrix matrix13 = matrix.multiply(false, false, matrix12);
            Matrix matrix14 = (matrix13 = matrix13.getCenteredMatrix()).multiply(true, false, matrix13);
            if (!(Math.sqrt(matrix14.get(0, 0)) > 1.0E-49)) {
                System.err.println("Division by ZERO error in SimPlsSave(...), normt.");
                this.B.set(3.4028234663852886E38);
                break;
            }
            double d2 = Math.sqrt(matrix14.get(0, 0));
            matrix13 = matrix13.devide(d2);
            matrix12 = matrix12.devide(d2);
            Matrix matrix15 = matrix.multiply(true, false, matrix13);
            matrix9 = matrix5.multiply(true, false, matrix13);
            Matrix matrix16 = matrix5.multiply(false, false, matrix9);
            Matrix matrix17 = matrix15;
            if (i > 1) {
                Matrix matrix18 = this.V.multiply(true, false, matrix15);
                matrix17 = matrix17.subtract(this.V.multiply(false, false, matrix18));
                Matrix matrix19 = this.T.multiply(true, false, matrix16);
                matrix16 = matrix16.subtract(this.T.multiply(false, false, matrix19));
            }
            if (!((matrix10 = matrix17.multiply(true, false, matrix17)).get(0, 0) > 1.0E-49)) {
                System.err.println("Division by ZERO error in SimPlsSave(...), normv.");
                this.B.set(3.4028234663852886E38);
                break;
            }
            d2 = Math.sqrt(matrix10.get(0, 0));
            matrix17 = matrix17.devide(d2);
            Matrix matrix20 = matrix17.multiply(true, false, matrix6);
            matrix6 = matrix6.subtract(matrix17.multiply(false, false, matrix20));
            this.R.resize(matrix12.getRowDim(), i);
            this.R.assignCol(i - 1, matrix12);
            this.T.resize(matrix13.getRowDim(), i);
            this.T.assignCol(i - 1, matrix13);
            this.P.resize(matrix15.getRowDim(), i);
            this.P.assignCol(i - 1, matrix15);
            this.Q.resize(matrix9.getRowDim(), i);
            this.Q.assignCol(i - 1, matrix9);
            this.U.resize(matrix16.getRowDim(), i);
            this.U.assignCol(i - 1, matrix16);
            this.V.resize(matrix17.getRowDim(), i);
            this.V.assignCol(i - 1, matrix17);
            Matrix matrix21 = matrix12.multiply(false, true, matrix9);
            this.B.resize(matrix21.getRowDim(), matrix21.getColDim());
            this.B = this.B.plus(matrix21);
        }
    }

    public Matrix getT(Matrix matrix) {
        Matrix matrix2 = matrix.multiply(this.getR());
        return matrix2;
    }

    public static void main(String[] stringArray) {
        Matrix matrix = MatrixTests.testDescriptor01X();
        Matrix matrix2 = MatrixTests.testDescriptor01Y();
        Matrix matrix3 = matrix.getCenteredMatrix();
        Matrix matrix4 = matrix2.getCenteredMatrix();
        SimPLS simPLS = new SimPLS();
        int n = 2;
        simPLS.simPlsSave(matrix3, matrix4, n);
        System.out.println(simPLS.toString(4));
        Matrix matrix5 = simPLS.getP();
        Matrix matrix6 = simPLS.getR();
        Matrix matrix7 = simPLS.getU();
        Matrix matrix8 = simPLS.getV();
        Matrix matrix9 = simPLS.getQ();
        Matrix matrix10 = simPLS.getT();
        Matrix matrix11 = matrix3.multiply(matrix6);
        System.out.println("That\n" + matrix11.toString(4));
        Matrix matrix12 = matrix6.multiply(false, true, matrix9);
        System.out.println("U\n" + matrix7.toString(4));
        System.out.println("G\n" + matrix12.toString(4));
        Matrix matrix13 = matrix10.multiply(false, true, matrix5);
        System.out.println(matrix13.toString(4));
        Matrix matrix14 = matrix.multiply(false, false, matrix12);
        System.out.println("XG\n" + matrix14.toString(4));
    }

    public String toString(int n) {
        String string = "";
        string = string + "E [%]\n" + this.EX.toString(n) + "\n";
        string = string + "P:\n" + this.P.toString(n) + "\n";
        string = string + "Q:\n" + this.Q.toString(n) + "\n";
        string = string + "R:\n" + this.R.toString(n) + "\n";
        string = string + "T:\n" + this.T.toString(n) + "\n";
        string = string + "U:\n" + this.U.toString(n) + "\n";
        string = string + "V:\n" + this.V.toString(n) + "\n";
        return string;
    }
}

