/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression;

import com.actelion.research.calc.Matrix;
import com.actelion.research.calc.MatrixFunctions;
import com.actelion.research.calc.classification.PrecisionAndRecall;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.datamodel.DoubleArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class ModelError {
    public double error;
    public double errorMedian;
    public double errorRelative;
    public double errorRelativeMedian;
    public double errorRelativeWeighted;
    public double errSumSquared;
    public double errMax;
    public double errMin;
    public double corrSquared;
    public double corrSquaredSpearman;
    public boolean classification;
    public PrecisionAndRecall precisionAndRecall;
    public boolean failed = false;
    public int nNotFiniteRelError;

    public void setFailed() {
        this.failed = true;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.failed) {
            stringBuilder.append("ModelError [error=failed]");
        } else {
            stringBuilder.append("ModelError [error=");
            stringBuilder.append(Formatter.format3(this.error));
            stringBuilder.append(", errRelativeMedian=");
            stringBuilder.append(Formatter.format3(this.errorRelativeMedian));
            if (this.nNotFiniteRelError != 0) {
                stringBuilder.append(", NotFiniteRelError=");
                stringBuilder.append(this.nNotFiniteRelError);
            }
            stringBuilder.append(", errMax=");
            stringBuilder.append(Formatter.format3(this.errMax));
            stringBuilder.append(", errMin=");
            stringBuilder.append(Formatter.format3(this.errMin));
            stringBuilder.append(", corrSquared=");
            stringBuilder.append(Formatter.format3(this.corrSquared));
            if (this.precisionAndRecall != null) {
                stringBuilder.append(", Cohen's kappa=");
                stringBuilder.append(Formatter.format3(this.precisionAndRecall.calculateCohensKappa()));
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public static ModelError calculateError(Matrix matrix, Matrix matrix2) {
        double d;
        int n;
        ModelError modelError = new ModelError();
        modelError.errMax = 0.0;
        modelError.errMin = 2.147483647E9;
        DoubleArray doubleArray = new DoubleArray(matrix.rows() * matrix2.cols());
        double d2 = 0.0;
        for (int i = 0; i < matrix2.cols(); ++i) {
            for (n = 0; n < matrix2.rows(); ++n) {
                double d3 = Math.abs(matrix.get(n, i) - matrix2.get(n, i));
                d2 += d3 * d3;
                modelError.errMax = Math.max(modelError.errMax, d3);
                modelError.errMin = Math.min(modelError.errMin, d3);
                modelError.error += d3;
                doubleArray.add(d3);
            }
        }
        modelError.error /= (double)(matrix2.rows() * matrix2.cols());
        modelError.errSumSquared = d2;
        modelError.errorMedian = doubleArray.median();
        DoubleArray doubleArray2 = new DoubleArray(matrix2.rows() * matrix2.cols());
        modelError.nNotFiniteRelError = 0;
        for (n = 0; n < matrix2.cols(); ++n) {
            for (int i = 0; i < matrix2.rows(); ++i) {
                double d4;
                double d5 = matrix.get(i, n);
                double d6 = ModelError.getRelativeError(d5, d4 = matrix2.get(i, n));
                if (Double.isFinite(d6)) {
                    doubleArray2.add(d6);
                    continue;
                }
                ++modelError.nNotFiniteRelError;
            }
        }
        if (doubleArray2.size() > 0) {
            modelError.errorRelative = doubleArray2.avr();
            modelError.errorRelativeMedian = doubleArray2.median();
        }
        DoubleArray doubleArray3 = new DoubleArray(matrix2.rows() * matrix2.cols());
        for (int i = 0; i < matrix2.cols(); ++i) {
            for (int j = 0; j < matrix2.rows(); ++j) {
                double d7;
                d = matrix.get(j, i);
                double d8 = matrix2.get(j, i);
                double d9 = Math.log10(10.0 + d);
                if (Math.abs(d) > 1.0E-4) {
                    d7 = Math.abs((d8 - d) / d) * (1.0 / d9);
                    if (!Double.isFinite(d7)) continue;
                    doubleArray3.add(d7);
                    continue;
                }
                d7 = Math.abs((d8 - d) / 1.0E-4) * (1.0 / d9);
                if (!Double.isFinite(d7)) continue;
                doubleArray3.add(d7);
            }
        }
        modelError.errorRelativeWeighted = doubleArray3.avr();
        double d10 = 0.0;
        d = 0.0;
        try {
            d10 = MatrixFunctions.getCorrPearson(matrix2, matrix);
            d = MatrixFunctions.getCorrSpearman(matrix2, matrix);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("YHat");
            System.err.println(matrix2.toString());
            System.err.println("Y");
            System.err.println(matrix.toString());
        }
        if (!Double.isFinite(d10)) {
            d10 = 0.0;
        }
        if (!Double.isFinite(d)) {
            d = 0.0;
        }
        modelError.corrSquared = d10 * d10;
        modelError.corrSquaredSpearman = d * d;
        return modelError;
    }

    public static double getRelativeError(double d, double d2) {
        double d3 = 0.0;
        d3 = Math.abs(d) > 1.0E-4 ? Math.abs((d2 - d) / d) : Math.abs((d2 - d) / 1.0E-4);
        return d3;
    }

    public static ModelError calculateError(Matrix matrix, Matrix matrix2, double d, boolean bl) {
        ModelError modelError = ModelError.calculateError(matrix, matrix2);
        modelError.precisionAndRecall = new PrecisionAndRecall();
        for (int i = 0; i < matrix2.cols(); ++i) {
            for (int j = 0; j < matrix2.rows(); ++j) {
                double d2 = matrix.get(j, i);
                double d3 = matrix2.get(j, i);
                if (bl) {
                    if (d2 >= d && d3 >= d) {
                        ++modelError.precisionAndRecall.truePositive;
                        continue;
                    }
                    if (d2 < d && d3 < d) {
                        ++modelError.precisionAndRecall.trueNegative;
                        continue;
                    }
                    if (d3 >= d) {
                        ++modelError.precisionAndRecall.falsePositive;
                        continue;
                    }
                    if (!(d3 < d)) continue;
                    ++modelError.precisionAndRecall.falseNegative;
                    continue;
                }
                if (d2 <= d && d3 <= d) {
                    ++modelError.precisionAndRecall.truePositive;
                    continue;
                }
                if (d2 > d && d3 > d) {
                    ++modelError.precisionAndRecall.trueNegative;
                    continue;
                }
                if (d3 <= d) {
                    ++modelError.precisionAndRecall.falsePositive;
                    continue;
                }
                if (!(d3 > d)) continue;
                ++modelError.precisionAndRecall.falseNegative;
            }
        }
        modelError.classification = true;
        return modelError;
    }

    public static List<Double> getError(List<ModelError> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (ModelError modelError : list) {
            arrayList.add(modelError.error);
        }
        return arrayList;
    }

    public static ModelError getErrorAverage(List<ModelError> list) {
        ModelError modelError = new ModelError();
        for (ModelError modelError2 : list) {
            modelError.errMax += modelError2.errMax;
            modelError.errMin += modelError2.errMin;
            modelError.error += modelError2.error;
            modelError.corrSquared += modelError2.corrSquared;
        }
        int n = list.size();
        modelError.errMax /= (double)n;
        modelError.errMin /= (double)n;
        modelError.error /= (double)n;
        modelError.corrSquared /= (double)n;
        return modelError;
    }

    public static Comparator<ModelError> getComparatorError() {
        return new Comparator<ModelError>(){

            @Override
            public int compare(ModelError modelError, ModelError modelError2) {
                int n = 0;
                if (modelError.error > modelError2.error) {
                    n = 1;
                } else if (modelError.error < modelError2.error) {
                    n = -1;
                }
                return n;
            }
        };
    }

    public static void main(String[] stringArray) {
        int n = 11;
        double d = 0.1;
        Random random = new Random();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = random.nextDouble();
            dArray2[i] = random.nextDouble();
        }
        ModelError modelError = ModelError.calculateError(new Matrix(false, dArray), new Matrix(false, dArray2));
        System.out.println(modelError.toString());
        Arrays.sort(dArray);
        Arrays.sort(dArray2);
        ModelError modelError2 = ModelError.calculateError(new Matrix(false, dArray), new Matrix(false, dArray2));
        System.out.println(modelError2.toString());
        for (int i = 0; i < n; ++i) {
            if (!(random.nextDouble() < d)) continue;
            dArray[i] = random.nextDouble();
        }
        ModelError modelError3 = ModelError.calculateError(new Matrix(false, dArray), new Matrix(false, dArray2));
        System.out.println(modelError3.toString());
    }
}

