/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.SelfOrganizedMap;
import com.actelion.research.util.DoubleFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Random;

public class VectorSOM
extends SelfOrganizedMap {
    private double[] mMeanParameter;
    private double[] mStandardDeviation;
    private int mParameterCount;

    public VectorSOM() {
    }

    public VectorSOM(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public void setParameterCount(int n) {
        this.mParameterCount = n;
    }

    @Override
    protected void initializeNormalization() {
        int n;
        double[] dArray;
        int n2;
        this.startProgress("Calculating mean parameters...", 0, this.mController.getInputVectorCount());
        if (this.mController.getInputVectorCount() == -1) {
            this.mMeanParameter = new double[this.mParameterCount];
            this.mStandardDeviation = new double[this.mParameterCount];
            for (int i = 0; i < this.mParameterCount; ++i) {
                this.mMeanParameter[i] = 0.0;
                this.mStandardDeviation[i] = 1.0;
            }
            return;
        }
        this.mMeanParameter = new double[this.mParameterCount];
        for (n2 = 0; n2 < this.mController.getInputVectorCount() && !this.threadMustDie(); ++n2) {
            this.updateProgress(n2);
            dArray = (double[])this.mController.getInputVector(n2);
            for (n = 0; n < this.mParameterCount; ++n) {
                int n3 = n;
                this.mMeanParameter[n3] = this.mMeanParameter[n3] + dArray[n];
            }
        }
        if (!this.threadMustDie()) {
            n2 = 0;
            while (n2 < this.mParameterCount) {
                int n4 = n2++;
                this.mMeanParameter[n4] = this.mMeanParameter[n4] / (double)this.mController.getInputVectorCount();
            }
        }
        this.startProgress("Calculating variance...", 0, this.mController.getInputVectorCount());
        this.mStandardDeviation = new double[this.mParameterCount];
        for (n2 = 0; n2 < this.mController.getInputVectorCount() && !this.threadMustDie(); ++n2) {
            this.updateProgress(n2);
            dArray = (double[])this.mController.getInputVector(n2);
            n = 0;
            while (n < this.mParameterCount) {
                double d = dArray[n] - this.mMeanParameter[n];
                int n5 = n++;
                this.mStandardDeviation[n5] = this.mStandardDeviation[n5] + d * d;
            }
        }
        if (!this.threadMustDie()) {
            for (n2 = 0; n2 < this.mParameterCount; ++n2) {
                this.mStandardDeviation[n2] = Math.sqrt(this.mStandardDeviation[n2] / (double)this.mController.getInputVectorCount());
            }
        }
    }

    @Override
    public void write(BufferedWriter bufferedWriter) throws IOException {
        super.write(bufferedWriter);
        bufferedWriter.write("<meanParameter=\"" + VectorSOM.doubleArrayToString(this.mMeanParameter) + "\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<standardDeviation=\"" + VectorSOM.doubleArrayToString(this.mStandardDeviation) + "\">");
        bufferedWriter.newLine();
    }

    @Override
    public void read(BufferedReader bufferedReader) throws Exception {
        boolean bl;
        super.read(bufferedReader);
        String string = bufferedReader.readLine();
        boolean bl2 = bl = !string.startsWith("<meanParameter=");
        if (!bl) {
            this.mMeanParameter = VectorSOM.stringToDoubleArray(VectorSOM.extractValue(string));
            this.mParameterCount = this.mMeanParameter.length;
            string = bufferedReader.readLine();
            if (string.startsWith("<variance=")) {
                this.mStandardDeviation = VectorSOM.stringToDoubleArray(VectorSOM.extractValue(string));
                for (int i = 0; i < this.mStandardDeviation.length; ++i) {
                    this.mStandardDeviation[i] = Math.sqrt(this.mStandardDeviation[i]);
                }
            } else if (string.startsWith("<standardDeviation=")) {
                this.mStandardDeviation = VectorSOM.stringToDoubleArray(VectorSOM.extractValue(string));
            } else {
                bl = true;
            }
        }
        if (bl) {
            throw new IOException("Invalid SOM file format");
        }
    }

    @Override
    protected String referenceVectorToString(int n, int n2) {
        return VectorSOM.doubleArrayToString((double[])this.mReferenceVector[n][n2]);
    }

    public static String doubleArrayToString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < dArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append('\t');
            }
            stringBuffer.append(DoubleFormat.toString(dArray[i]));
        }
        return stringBuffer.toString();
    }

    @Override
    protected void setReferenceVector(int n, int n2, String string) throws Exception {
        this.mReferenceVector[n][n2] = VectorSOM.stringToDoubleArray(string);
    }

    public static double[] stringToDoubleArray(String string) {
        int n;
        int n2 = 1;
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != '\t') continue;
            ++n2;
        }
        n = 0;
        int n3 = string.indexOf(9);
        double[] dArray = new double[n2];
        for (int i = 0; i < n2 - 1; ++i) {
            dArray[i] = Double.parseDouble(string.substring(n, n3));
            n = n3 + 1;
            n3 = string.indexOf(9, n);
        }
        dArray[n2 - 1] = Double.parseDouble(string.substring(n));
        return dArray;
    }

    @Override
    public double getDissimilarity(Object object, Object object2) {
        double[] dArray = (double[])object;
        double[] dArray2 = (double[])object2;
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = Math.abs(dArray[i] - dArray2[i]);
            d += d2 * d2;
        }
        return Math.sqrt(d) / Math.sqrt(dArray.length);
    }

    @Override
    protected void updateReference(Object object, Object object2, double d) {
        double[] dArray = (double[])object;
        double[] dArray2 = (double[])object2;
        for (int i = 0; i < dArray2.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] + d * (dArray[i] - dArray2[i]);
        }
    }

    @Override
    protected Object getRandomVector() {
        Random random = new Random();
        double[] dArray = new double[this.mParameterCount];
        for (int i = 0; i < this.mParameterCount; ++i) {
            dArray[i] = random.nextGaussian();
        }
        return dArray;
    }

    @Override
    protected Object getMeanVector(Object object, Object object2) {
        double[] dArray = (double[])object;
        double[] dArray2 = (double[])object2;
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = 0.5 * (dArray[i] + dArray2[i]);
        }
        return dArray3;
    }

    @Override
    public Object normalizeVector(Object object) {
        double[] dArray = (double[])object;
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (dArray[i] - this.mMeanParameter[i]) / this.mStandardDeviation[i];
            }
        }
        return dArray;
    }
}

