/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.Matrix;
import com.actelion.research.chem.descriptor.ISimilarityCalculator;
import com.actelion.research.util.Pipeline;
import com.actelion.research.util.datamodel.IIdentifiedObject;
import com.actelion.research.util.datamodel.IdentifiedObject;
import com.actelion.research.util.datamodel.ScorePoint;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class SimilarityMulticore<T> {
    private static final int MAX_KERNELS = 80;
    private static final double DEFAULT_MINIMUM_SIMILARITY = 0.01;
    private static final long SLEEP_SHORT = 10L;
    private static final long SLEEP_ULTRA_SHORT = 1L;
    private ISimilarityCalculator<T> similarityCalculator;
    private List<IdentifiedObject<T>> liDescriptor1;
    private List<IdentifiedObject<T>> liDescriptor2;
    private int kernels;
    private AtomicLong sleep;
    private Pipeline<Point> queueIndices;
    private ConcurrentLinkedQueue<ScorePoint> queueScore;
    private List<RunSimilarityCalc> liRun;
    private int similarities2Calculate;
    private AtomicLong calculationsPerSecond;
    private Matrix maSimilarity;
    private boolean verbose;

    public SimilarityMulticore(ISimilarityCalculator<T> iSimilarityCalculator) {
        this(iSimilarityCalculator, Math.min(Runtime.getRuntime().availableProcessors() - 1, 80));
    }

    public SimilarityMulticore(ISimilarityCalculator<T> iSimilarityCalculator, int n) {
        this.similarityCalculator = iSimilarityCalculator;
        this.kernels = n;
        this.queueIndices = new Pipeline();
        this.queueScore = new ConcurrentLinkedQueue();
        this.sleep = new AtomicLong();
        this.calculationsPerSecond = new AtomicLong();
        this.verbose = false;
    }

    public void setVerbose() {
        this.verbose = true;
    }

    public void run(IdentifiedObject<T> identifiedObject, List<IdentifiedObject<T>> list) {
        ArrayList<IdentifiedObject<T>> arrayList = new ArrayList<IdentifiedObject<T>>();
        arrayList.add(identifiedObject);
        this.run(arrayList, list);
    }

    public void run(List<IdentifiedObject<T>> list) {
        this.run(list, list, true);
    }

    public void run(List<IdentifiedObject<T>> list, List<IdentifiedObject<T>> list2) {
        this.run(list, list2, false);
    }

    private void run(List<IdentifiedObject<T>> list, List<IdentifiedObject<T>> list2, boolean bl) {
        this.calculationsPerSecond.set(-1L);
        long l = new Date().getTime();
        this.sleep.set(1L);
        if (this.verbose) {
            System.out.println("SimilarityMulticore start.");
            System.out.println("SimilarityMulticore kernels\t" + this.kernels);
        }
        this.liDescriptor1 = list;
        this.liDescriptor2 = list2;
        if (this.verbose) {
            System.out.println("liDescriptor1 " + list.size() + " liDescriptor2 " + list2.size() + ".");
        }
        this.queueScore.clear();
        this.maSimilarity = new Matrix(list.size(), list2.size());
        if (bl) {
            this.fillCalculationIndexQueueSingleList();
        } else {
            this.fillCalculationIndexQueueTwoLists();
        }
        this.liRun = new ArrayList<RunSimilarityCalc>();
        ExecutorService executorService = Executors.newFixedThreadPool(this.kernels);
        for (int i = 0; i < this.kernels; ++i) {
            RunSimilarityCalc runSimilarityCalc = new RunSimilarityCalc(i, this.similarityCalculator, this.queueIndices, list, list2, this.maSimilarity, bl, this.queueScore);
            this.liRun.add(runSimilarityCalc);
            executorService.execute(runSimilarityCalc);
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        long l2 = new Date().getTime();
        long l3 = (l2 - l) / 1000L;
        if (l3 != 0L) {
            this.calculationsPerSecond.set(this.getCalculatedSimilarityValues() / l3);
        }
        if (this.verbose) {
            System.out.println("Similarity calculations " + this.getCalculatedSimilarityValues());
            System.out.println("Similarity calculations per second " + this.calculationsPerSecond.get());
            int n = 0;
            for (int i = 0; i < this.liRun.size(); ++i) {
                RunSimilarityCalc runSimilarityCalc = this.liRun.get(i);
                n = (int)((long)n + runSimilarityCalc.getNSimilarityCalculations());
                System.out.println("Thread " + runSimilarityCalc.getIndexThread() + " calcs " + runSimilarityCalc.getNSimilarityCalculations());
            }
            System.out.println("Sum calcs " + n + ".");
        }
        this.sleep.set(10L);
    }

    public long getCalculationsPerSecond() {
        return this.calculationsPerSecond.get();
    }

    public int getSimilarities2Calculate() {
        return this.similarities2Calculate;
    }

    public long getCalculatedSimilarityValues() {
        long l = 0L;
        for (RunSimilarityCalc runSimilarityCalc : this.liRun) {
            l += runSimilarityCalc.getNSimilarityCalculations();
        }
        return l;
    }

    private boolean isFinished() {
        if (!this.queueIndices.isAllDataIn()) {
            return false;
        }
        if (!this.queueIndices.isEmpty()) {
            return false;
        }
        boolean bl = true;
        if (this.queueScore.size() != this.similarities2Calculate) {
            bl = false;
        }
        return bl;
    }

    public boolean hasMoreResults() {
        return !this.queueScore.isEmpty();
    }

    public ScorePoint getNextResult() {
        return this.queueScore.poll();
    }

    private void fillCalculationIndexQueueTwoLists() {
        this.queueIndices.setAllDataIn(false);
        this.similarities2Calculate = this.liDescriptor1.size() * this.liDescriptor2.size();
        for (int i = 0; i < this.liDescriptor1.size(); ++i) {
            for (int j = 0; j < this.liDescriptor2.size(); ++j) {
                Point point = new Point(i, j);
                this.queueIndices.addData(point);
            }
        }
        this.queueIndices.setAllDataIn(true);
        if (this.verbose) {
            System.out.println("SimilarityMulticore sim to calc " + this.similarities2Calculate + ".");
        }
    }

    private void fillCalculationIndexQueueSingleList() {
        this.queueIndices.setAllDataIn(false);
        this.similarities2Calculate = (this.liDescriptor1.size() * this.liDescriptor1.size() - this.liDescriptor1.size()) / 2;
        for (int i = 0; i < this.liDescriptor1.size(); ++i) {
            for (int j = i; j < this.liDescriptor1.size(); ++j) {
                Point point = new Point(i, j);
                this.queueIndices.addData(point);
            }
        }
        this.queueIndices.setAllDataIn(true);
        if (this.verbose) {
            System.out.println("SimilarityMulticore sim to calc " + this.similarities2Calculate + ".");
        }
    }

    public Matrix getSimilarityMatrix() {
        return this.maSimilarity;
    }

    private static class RunSimilarityCalc<T>
    implements Runnable {
        private ISimilarityCalculator iSimilarityCalculator;
        private Pipeline<Point> queueIndices;
        private List<IIdentifiedObject<T>> liDescriptor1;
        private List<IIdentifiedObject<T>> liDescriptor2;
        private Matrix maSimilarity;
        private boolean singleList;
        private ConcurrentLinkedQueue<ScorePoint> queueScore;
        private AtomicLong calculatedSimilarities;
        private int indexThread;

        public RunSimilarityCalc(int n, ISimilarityCalculator iSimilarityCalculator, Pipeline<Point> pipeline, List<IIdentifiedObject<T>> list, List<IIdentifiedObject<T>> list2, Matrix matrix, boolean bl, ConcurrentLinkedQueue<ScorePoint> concurrentLinkedQueue) {
            this.indexThread = n;
            this.iSimilarityCalculator = iSimilarityCalculator.getThreadSafeCopy();
            this.queueIndices = pipeline;
            this.liDescriptor1 = list;
            this.liDescriptor2 = list2;
            this.maSimilarity = matrix;
            this.singleList = bl;
            this.queueScore = concurrentLinkedQueue;
            this.calculatedSimilarities = new AtomicLong();
        }

        @Override
        public void run() {
            while (!this.queueIndices.wereAllDataFetched()) {
                Point point = this.queueIndices.pollData();
                if (point == null) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                int n = point.x;
                int n2 = point.y;
                IIdentifiedObject<T> iIdentifiedObject = null;
                iIdentifiedObject = this.liDescriptor1.get(n);
                IIdentifiedObject<T> iIdentifiedObject2 = null;
                iIdentifiedObject2 = this.liDescriptor2.get(n2);
                ScorePoint scorePoint = new ScorePoint((int)iIdentifiedObject.getId(), (int)iIdentifiedObject2.getId());
                try {
                    double d = this.iSimilarityCalculator.getSimilarity(iIdentifiedObject.getData(), iIdentifiedObject2.getData());
                    if (d < 0.01) {
                        d = 0.01;
                    }
                    this.calculatedSimilarities.incrementAndGet();
                    scorePoint.setScore(d);
                    this.maSimilarity.set(n, n2, d);
                    if (this.singleList) {
                        this.maSimilarity.set(n2, n, d);
                    }
                    this.queueScore.add(scorePoint);
                }
                catch (Exception exception) {
                    scorePoint.setScore(Double.NaN);
                    this.queueScore.add(scorePoint);
                    exception.printStackTrace();
                }
            }
        }

        protected int getIndexThread() {
            return this.indexThread;
        }

        public long getNSimilarityCalculations() {
            return this.calculatedSimilarities.get();
        }
    }
}

