/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.DataProcessor;
import com.actelion.research.calc.SOMController;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class SelfOrganizedMap
extends DataProcessor {
    private static final int cModeNeighbourhoodMask = 7;
    public static final int cModeNeighbourhoodGaussean = 0;
    public static final int cModeNeighbourhoodMexicanHat = 1;
    public static final int cModeNeighbourhoodLinear = 2;
    public static final int cModeTopologyUnlimited = 8;
    public static final int cModeGrowDuringOptimization = 16;
    public static final int cModeFastBestMatchFinding = 32;
    protected SOMController mController;
    protected Object[][] mReferenceVector;
    protected int mNX;
    protected int mNY;
    protected int mMode;
    private int mCycle;
    private int mCyclesPerNode;
    private int mConstantInfluenceCycles;
    private int mThreadCount;
    private int mInputVectorCount;
    private int mInputVectorIndex;
    private int mCorrectQuickBestMatches;
    private boolean mFindBestMatchQuickly;
    private double mMaxRange;
    private double mDiagonal;
    protected double[][] mInfluence;
    private Point[] mLastBestMatch;
    private int[][] mSMPSOMIndex;
    private int[][] mSMPInfluenceIndex;
    private Rectangle mSMPInfluenceRect;
    private ExecutorService mExecutor;
    private SOMWorker[] mSOMWorker;

    public SelfOrganizedMap() {
        this.initializeSMP();
    }

    public SelfOrganizedMap(int n, int n2, int n3) {
        this.initializeSMP();
        this.initializeReferenceVectors(n, n2, n3);
    }

    public void initializeReferenceVectors(int n, int n2, int n3) {
        this.mNX = n;
        this.mNY = n2;
        this.mMode = n3;
        this.mReferenceVector = new Object[n][n2];
        if (this.mThreadCount != 1) {
            this.mSMPSOMIndex = this.getSMPArraySplitting(n, n2);
        }
    }

    private void initializeSMP() {
        this.mThreadCount = Runtime.getRuntime().availableProcessors();
        if (this.mThreadCount != 1) {
            this.mExecutor = Executors.newFixedThreadPool(this.mThreadCount);
            this.mSOMWorker = new SOMWorker[this.mThreadCount];
            for (int i = 0; i < this.mThreadCount; ++i) {
                this.mSOMWorker[i] = new SOMWorker(i);
            }
        }
    }

    public void setController(SOMController sOMController) {
        this.mController = sOMController;
    }

    public int getWidth() {
        return this.mNX;
    }

    public int getHeight() {
        return this.mNY;
    }

    public int getCreationMode() {
        return this.mMode;
    }

    public void organize() {
        int n;
        int n2;
        if (this.mController.getInputVectorCount() == 0) {
            return;
        }
        this.initializeNormalization();
        this.mDiagonal = Math.sqrt((this.mNX - 1) * (this.mNX - 1) + (this.mNY - 1) * (this.mNY - 1));
        this.mCyclesPerNode = 16;
        this.mConstantInfluenceCycles = Math.max(1, this.mNX * this.mNY * this.mCyclesPerNode / 2560);
        if ((this.mMode & 0x10) != 0) {
            this.mNX /= 8;
            this.mNY /= 8;
        }
        this.mReferenceVector = new Object[this.mNX][this.mNY];
        for (n2 = 0; n2 < this.mNX; ++n2) {
            for (n = 0; n < this.mNY; ++n) {
                this.mReferenceVector[n2][n] = this.getRandomVector();
            }
        }
        this.mInputVectorCount = this.mController.getInputVectorCount();
        if (this.mInputVectorCount == -1) {
            this.mMode &= 0xFFFFFFDF;
        }
        if ((this.mMode & 0x20) != 0) {
            this.mLastBestMatch = new Point[this.mInputVectorCount];
            this.mFindBestMatchQuickly = false;
        }
        if ((this.mMode & 0x10) != 0) {
            n2 = this.mCyclesPerNode * this.mNX * this.mNY;
            n = n2 + n2 / 3 * 4 + n2 / 3 * 16 + n2 / 3 * 64;
            this.mCycle = 0;
            this.startProgress("Self-Organizing map...", 0, n);
            this.optimize(0, n2);
            int n3 = n2;
            for (int i = 2; i <= 4; ++i) {
                this.grow();
                this.optimize((n3 *= 4) - n3 / 3, n3);
            }
            this.stopProgress("Map completed.");
        } else {
            n2 = this.mCyclesPerNode * this.mNX * this.mNY;
            this.mCycle = 0;
            this.startProgress("Self-Organizing map...", 0, n2);
            this.optimize(0, n2);
            this.stopProgress("Map completed.");
        }
    }

    public Object getReferenceVector(int n, int n2) {
        return this.mReferenceVector[n][n2];
    }

    public double[][] getInfluence() {
        return this.mInfluence;
    }

    public double getChaos() {
        double d = 0.0;
        for (int i = 0; i < this.mNX; ++i) {
            for (int j = 0; j < this.mNY; ++j) {
                d += Math.sqrt(i == 0 ? this.getDissimilarity(this.mReferenceVector[0][j], this.mReferenceVector[this.mNX - 1][j]) : this.getDissimilarity(this.mReferenceVector[i][j], this.mReferenceVector[i - 1][j]));
                d += Math.sqrt(j == 0 ? this.getDissimilarity(this.mReferenceVector[i][0], this.mReferenceVector[i][this.mNY - 1]) : this.getDissimilarity(this.mReferenceVector[i][j], this.mReferenceVector[i][j - 1]));
            }
        }
        return d / (double)(this.mNX * this.mNY);
    }

    public double getMatchScore() {
        double d = 0.0;
        for (int i = 0; i < 1; ++i) {
            Object object = this.getRandomVector();
            Object object2 = null;
            double d2 = Double.POSITIVE_INFINITY;
            for (int j = 0; j < this.mNX; ++j) {
                for (int k = 0; k < this.mNY; ++k) {
                    double d3 = this.getDissimilarity(this.mReferenceVector[j][k], object);
                    if (!(d2 > d3)) continue;
                    d2 = d3;
                    object2 = this.mReferenceVector[j][k];
                }
            }
            d += Math.sqrt(this.getDissimilarity(object, object2));
        }
        return d / 1.0;
    }

    protected double getTimeInfluence(double d) {
        return 1.0 - d;
    }

    protected double getNeighbourInfluence(int n, int n2, double d) {
        double d2 = Math.sqrt(n * n + n2 * n2) / this.mDiagonal;
        double d3 = 0.0;
        switch (this.mMode & 7) {
            case 0: {
                d3 = Math.exp(d2 * d2 * Math.log(0.001) / (this.mMaxRange * this.mMaxRange));
                return d3 < 0.001 ? 0.0 : d3;
            }
            case 1: {
                d3 = 1.0 - d2 * d2 / (this.mMaxRange * this.mMaxRange);
                return d3 < 0.0 ? 0.0 : d3;
            }
            case 2: {
                d3 = 1.0 - d2 / this.mMaxRange;
                return d3 < 0.0 ? 0.0 : d3;
            }
        }
        return d3;
    }

    private int[][] getSMPArraySplitting(int n, int n2) {
        int n3 = n * n2;
        int n4 = n3 / this.mThreadCount;
        int n5 = n3 % this.mThreadCount;
        int[][] nArray = new int[this.mThreadCount + 1][2];
        for (int i = 0; i < this.mThreadCount; ++i) {
            int n6 = i < n5 ? n4 + 1 : n4;
            int n7 = n6 % n;
            int n8 = n6 / n;
            if (nArray[i][0] + n7 >= n) {
                n7 -= n;
                ++n8;
            }
            nArray[i + 1][0] = nArray[i][0] + n7;
            nArray[i + 1][1] = nArray[i][1] + n8;
        }
        return nArray;
    }

    private void optimize(int n, int n2) {
        this.mInfluence = null;
        for (int i = n; i < n2; ++i) {
            if ((i - n) % this.mConstantInfluenceCycles == 0) {
                this.calculateInfluences((double)i / (double)n2);
            }
            this.updateProgress(this.mCycle++);
            if (this.threadMustDie()) break;
            Object object = this.normalizeVector(this.mController.getInputVector(this.mInputVectorIndex));
            if ((this.mMode & 0x20) != 0) {
                if (this.mFindBestMatchQuickly) {
                    this.mLastBestMatch[this.mInputVectorIndex] = this.findBestMatchLocationQuickly(object);
                } else {
                    Point point = this.mLastBestMatch[this.mInputVectorIndex] == null ? null : this.findBestMatchLocationQuickly(object);
                    this.mLastBestMatch[this.mInputVectorIndex] = this.findBestMatchLocation(object);
                    this.mCorrectQuickBestMatches = point != null && point.equals(this.mLastBestMatch[this.mInputVectorIndex]) ? ++this.mCorrectQuickBestMatches : 0;
                    if (this.mCorrectQuickBestMatches == 2 * this.mInputVectorCount) {
                        this.mFindBestMatchQuickly = true;
                    }
                }
                this.applyInfluences(object, this.mLastBestMatch[this.mInputVectorIndex]);
            } else {
                this.applyInfluences(object, this.findBestMatchLocation(object));
            }
            if (++this.mInputVectorIndex < this.mInputVectorCount) continue;
            this.mInputVectorIndex = 0;
        }
    }

    protected void applyInfluences(Object object, Point point) {
        int n = (int)(this.mDiagonal * this.mMaxRange);
        int n2 = point.x - n;
        int n3 = point.x + n;
        int n4 = point.y - n;
        int n5 = point.y + n;
        if ((this.mMode & 8) != 0) {
            if (n3 - n2 >= this.mNX) {
                n2 = 0;
                n3 = this.mNX;
            }
            if (n5 - n4 >= this.mNY) {
                n4 = 0;
                n5 = this.mNY;
            }
            if (this.mThreadCount != 1 && n != 0) {
                if (this.mSMPInfluenceRect == null || this.mSMPInfluenceRect.width != n3 - n2 || this.mSMPInfluenceRect.height != n5 - n4) {
                    this.mSMPInfluenceIndex = this.getSMPArraySplitting(n3 - n2, n5 - n4);
                }
                this.mSMPInfluenceRect = new Rectangle(n2, n4, n3 - n2, n5 - n4);
                this.applyInfluencesSMP(object, point);
            } else {
                for (int i = n2; i < n3; ++i) {
                    for (int j = n4; j < n5; ++j) {
                        int n6 = Math.abs(point.x - i);
                        int n7 = Math.abs(point.y - j);
                        if (n6 > this.mNX / 2) {
                            n6 = this.mNX - n6;
                        }
                        if (n7 > this.mNY / 2) {
                            n7 = this.mNY - n7;
                        }
                        if (!(this.mInfluence[n6][n7] > 0.0)) continue;
                        this.updateReference(object, this.mReferenceVector[i < 0 ? i + this.mNX : (i < this.mNX ? i : i - this.mNX)][j < 0 ? j + this.mNY : (j < this.mNY ? j : j - this.mNY)], this.mInfluence[n6][n7]);
                    }
                }
            }
        } else {
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > this.mNX) {
                n3 = this.mNX;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 > this.mNY) {
                n5 = this.mNY;
            }
            if (this.mThreadCount != 1 && n != 0) {
                this.mSMPInfluenceRect = new Rectangle(n2, n4, n3 - n2, n5 - n4);
                this.mSMPInfluenceIndex = this.getSMPArraySplitting(n3 - n2, n5 - n4);
                this.applyInfluencesSMP(object, point);
            } else {
                for (int i = n2; i < n3; ++i) {
                    for (int j = n4; j < n5; ++j) {
                        int n8;
                        int n9 = Math.abs(point.x - i);
                        if (!(this.mInfluence[n9][n8 = Math.abs(point.y - j)] > 0.0)) continue;
                        this.updateReference(object, this.mReferenceVector[i][j], this.mInfluence[n9][n8]);
                    }
                }
            }
        }
    }

    protected void applyInfluencesSMP(Object object, Point point) {
        CountDownLatch countDownLatch = new CountDownLatch(this.mThreadCount);
        for (SOMWorker sOMWorker : this.mSOMWorker) {
            sOMWorker.initApplyInfluences(object, point, countDownLatch);
            this.mExecutor.execute(sOMWorker);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Point findBestMatchLocation(Object object) {
        if (object == null) {
            return null;
        }
        if (this.mThreadCount != 1) {
            return this.findBestMatchLocationSMP(object);
        }
        Point point = new Point(-1, -1);
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.mNX; ++i) {
            for (int j = 0; j < this.mNY; ++j) {
                double d2 = this.getDissimilarity(this.mReferenceVector[i][j], object);
                if (!(d > d2)) continue;
                d = d2;
                point.x = i;
                point.y = j;
            }
        }
        return point;
    }

    /*
     * WARNING - void declaration
     */
    public Point findBestMatchLocationSMP(Object object) {
        void var3_7;
        if (object == null) {
            return null;
        }
        CountDownLatch countDownLatch = new CountDownLatch(this.mThreadCount);
        for (SOMWorker sOMWorker : this.mSOMWorker) {
            sOMWorker.initFindBestMatch(object, countDownLatch);
            this.mExecutor.execute(sOMWorker);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Point point = new Point(-1, -1);
        double d = Double.POSITIVE_INFINITY;
        for (SOMWorker sOMWorker : this.mSOMWorker) {
            double d2 = sOMWorker.getBestMatchDissimilarity();
            if (!(d > d2)) continue;
            d = d2;
            Point point2 = sOMWorker.getBestMatchLocation();
        }
        return var3_7;
    }

    public Point findBestMatchLocationQuickly(Object object) {
        boolean bl;
        if (object == null) {
            return null;
        }
        Point point = this.mLastBestMatch[this.mInputVectorIndex];
        double d = this.getDissimilarity(this.mReferenceVector[point.x][point.y], object);
        boolean[][] blArray = new boolean[this.mNX][this.mNY];
        blArray[point.x][point.y] = true;
        do {
            Point point2 = point;
            bl = false;
            for (int i = -1; i < 2; ++i) {
                int n = point2.x + i;
                if ((this.mMode & 8) != 0) {
                    if (n < 0) {
                        n = this.mNX - 1;
                    } else if (n >= this.mNX) {
                        n = 0;
                    }
                } else if (n < 0 || n >= this.mNX) continue;
                for (int j = -1; j < 2; ++j) {
                    int n2 = point2.y + j;
                    if ((this.mMode & 8) != 0) {
                        if (n2 < 0) {
                            n2 = this.mNY - 1;
                        } else if (n2 >= this.mNY) {
                            n2 = 0;
                        }
                    } else if (n2 < 0 || n2 >= this.mNY) continue;
                    if (blArray[n][n2]) continue;
                    blArray[n][n2] = true;
                    double d2 = this.getDissimilarity(this.mReferenceVector[n][n2], object);
                    if (!(d > d2)) continue;
                    d = d2;
                    point = new Point(n, n2);
                    bl = true;
                }
            }
        } while (bl);
        return point;
    }

    public double[] findExactMatchLocation(Object object) {
        double d;
        if (object == null) {
            return null;
        }
        Point point = this.findBestMatchLocation(object);
        double[] dArray = new double[3];
        dArray[0] = point.x;
        dArray[1] = point.y;
        int n = point.x - 1;
        int n2 = point.x + 1;
        int n3 = point.y - 1;
        int n4 = point.y + 1;
        if ((this.mMode & 8) != 0) {
            if (n == -1) {
                n += this.mNX;
            }
            if (n2 == this.mNX) {
                n2 = 0;
            }
            if (n3 == -1) {
                n3 += this.mNY;
            }
            if (n4 == this.mNY) {
                n4 = 0;
            }
        }
        if ((d = Math.sqrt(this.getDissimilarity(this.mReferenceVector[point.x][point.y], object))) > 0.0) {
            double d2;
            double d3;
            if (n == -1) {
                dArray[0] = dArray[0] + 0.5 * d / Math.sqrt(this.getDissimilarity(this.mReferenceVector[n2][point.y], object));
            } else if (n2 == this.mNX) {
                dArray[0] = dArray[0] - 0.5 * d / Math.sqrt(this.getDissimilarity(this.mReferenceVector[n][point.y], object));
            } else {
                d3 = Math.sqrt(this.getDissimilarity(this.mReferenceVector[n][point.y], object)) - d;
                if (d3 + (d2 = Math.sqrt(this.getDissimilarity(this.mReferenceVector[n2][point.y], object)) - d) != 0.0) {
                    dArray[0] = dArray[0] + (d3 / (d3 + d2) - 0.5);
                }
            }
            if (n3 == -1) {
                dArray[1] = dArray[1] + 0.5 * d / Math.sqrt(this.getDissimilarity(this.mReferenceVector[point.x][n4], object));
            } else if (n4 == this.mNY) {
                dArray[1] = dArray[1] - 0.5 * d / Math.sqrt(this.getDissimilarity(this.mReferenceVector[point.x][n3], object));
            } else {
                d3 = Math.sqrt(this.getDissimilarity(this.mReferenceVector[point.x][n3], object)) - d;
                if (d3 + (d2 = Math.sqrt(this.getDissimilarity(this.mReferenceVector[point.x][n4], object)) - d) != 0.0) {
                    dArray[1] = dArray[1] + (d3 / (d3 + d2) - 0.5);
                }
            }
        }
        dArray[2] = d;
        return dArray;
    }

    private void grow() {
        int n;
        Object[][] objectArray = this.mReferenceVector;
        this.mReferenceVector = new Object[this.mNX * 2][this.mNY * 2];
        for (n = 0; n < this.mNX; ++n) {
            for (int i = 0; i < this.mNY; ++i) {
                int n2 = n == this.mNX - 1 ? 0 : n + 1;
                int n3 = i == this.mNY - 1 ? 0 : i + 1;
                this.mReferenceVector[n * 2][i * 2] = objectArray[n][i];
                this.mReferenceVector[n * 2 + 1][i * 2] = this.getMeanVector(objectArray[n][i], objectArray[n2][i]);
                this.mReferenceVector[n * 2][i * 2 + 1] = this.getMeanVector(objectArray[n][i], objectArray[n][n3]);
                this.mReferenceVector[n * 2 + 1][i * 2 + 1] = this.getMeanVector(objectArray[n][i], objectArray[n2][n3]);
            }
        }
        this.mNX *= 2;
        this.mNY *= 2;
        if ((this.mMode & 0x20) != 0) {
            for (n = 0; n < this.mLastBestMatch.length; ++n) {
                if (this.mLastBestMatch[n] == null) continue;
                this.mLastBestMatch[n].x *= 2;
                this.mLastBestMatch[n].y *= 2;
            }
        }
    }

    protected void calculateInfluences(double d) {
        this.mMaxRange = 1.0 * Math.exp(Math.log(0.05) * Math.pow(d, 0.3));
        double d2 = this.getTimeInfluence(d);
        int n = Math.min(1 + (int)(this.mDiagonal * this.mMaxRange), this.mNX);
        int n2 = Math.min(1 + (int)(this.mDiagonal * this.mMaxRange), this.mNY);
        this.mInfluence = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.mInfluence[i][j] = 0.5 * d2 * this.getNeighbourInfluence(i, j, d);
            }
        }
    }

    public void write(BufferedWriter bufferedWriter) throws IOException {
        bufferedWriter.write("<width=\"" + this.mNX + "\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<height=\"" + this.mNY + "\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<creationMode=\"" + this.mMode + "\">");
        bufferedWriter.newLine();
        this.startProgress("Writing SOM Vectors...", 0, this.mNY);
        for (int i = 0; i < this.mNY; ++i) {
            this.updateProgress(i);
            for (int j = 0; j < this.mNX; ++j) {
                bufferedWriter.write("<reference[" + j + "][" + i + "]=\"" + this.referenceVectorToString(j, i) + "\">");
                bufferedWriter.newLine();
            }
        }
        this.stopProgress("SOM Vectors Written");
    }

    public void read(BufferedReader bufferedReader) throws Exception {
        boolean bl;
        String string = bufferedReader.readLine();
        boolean bl2 = bl = !string.startsWith("<width=");
        if (!bl) {
            this.mNX = Integer.parseInt(SelfOrganizedMap.extractValue(string));
            string = bufferedReader.readLine();
            boolean bl3 = bl = !string.startsWith("<height=");
        }
        if (!bl) {
            this.mNY = Integer.parseInt(SelfOrganizedMap.extractValue(string));
            string = bufferedReader.readLine();
            boolean bl4 = bl = !string.startsWith("<creationMode=");
        }
        if (!bl) {
            this.mMode = Integer.parseInt(SelfOrganizedMap.extractValue(string));
        }
        if (!bl && this.mThreadCount != 1) {
            this.mSMPSOMIndex = this.getSMPArraySplitting(this.mNX, this.mNY);
        }
        this.mReferenceVector = new Object[this.mNX][this.mNY];
        this.startProgress("Reading SOM Vectors...", 0, this.mNY);
        for (int i = 0; i < this.mNY && !bl; ++i) {
            this.updateProgress(i);
            for (int j = 0; j < this.mNX && !bl; ++j) {
                string = bufferedReader.readLine();
                boolean bl5 = bl = !string.startsWith("<reference[" + j + "][" + i + "]=");
                if (bl) continue;
                this.setReferenceVector(j, i, SelfOrganizedMap.extractValue(string));
            }
        }
        this.stopProgress("SOM Vectors Reading Done");
        if (bl) {
            throw new IOException("Invalid SOM file format");
        }
    }

    public static String extractValue(String string) {
        int n = string.indexOf("=\"") + 2;
        int n2 = string.indexOf("\"", n);
        return string.substring(n, n2);
    }

    protected abstract String referenceVectorToString(int var1, int var2);

    protected abstract void setReferenceVector(int var1, int var2, String var3) throws Exception;

    protected abstract void initializeNormalization();

    protected abstract void updateReference(Object var1, Object var2, double var3);

    protected abstract Object getMeanVector(Object var1, Object var2);

    protected abstract Object getRandomVector();

    public abstract Object normalizeVector(Object var1);

    public abstract double getDissimilarity(Object var1, Object var2);

    private class SOMWorker
    implements Runnable {
        private static final int FIND_BEST_MATCH = 1;
        private static final int APPLY_INFLUENCES = 2;
        private CountDownLatch mDoneSignal;
        private int mThreadIndex;
        private Object mInputVector;
        private int mWhatToDo;
        private Point mLocation;
        private double mMinDissimilarity;

        private SOMWorker(int n) {
            this.mThreadIndex = n;
        }

        public void initFindBestMatch(Object object, CountDownLatch countDownLatch) {
            this.mWhatToDo = 1;
            this.mInputVector = object;
            this.mDoneSignal = countDownLatch;
        }

        public void initApplyInfluences(Object object, Point point, CountDownLatch countDownLatch) {
            this.mWhatToDo = 2;
            this.mInputVector = object;
            this.mLocation = point;
            this.mDoneSignal = countDownLatch;
        }

        @Override
        public void run() {
            switch (this.mWhatToDo) {
                case 1: {
                    this.mLocation = new Point(-1, -1);
                    this.mMinDissimilarity = Double.POSITIVE_INFINITY;
                    int n = SelfOrganizedMap.this.mSMPSOMIndex[this.mThreadIndex][1];
                    int n2 = SelfOrganizedMap.this.mSMPSOMIndex[this.mThreadIndex + 1][1];
                    for (int i = n; i <= n2; ++i) {
                        int n3 = i == n ? SelfOrganizedMap.this.mSMPSOMIndex[this.mThreadIndex][0] : 0;
                        int n4 = i == n2 ? SelfOrganizedMap.this.mSMPSOMIndex[this.mThreadIndex + 1][0] : SelfOrganizedMap.this.mNX;
                        for (int j = n3; j < n4; ++j) {
                            double d = SelfOrganizedMap.this.getDissimilarity(SelfOrganizedMap.this.mReferenceVector[j][i], this.mInputVector);
                            if (!(this.mMinDissimilarity > d)) continue;
                            this.mMinDissimilarity = d;
                            this.mLocation.x = j;
                            this.mLocation.y = i;
                        }
                    }
                    break;
                }
                case 2: {
                    if ((SelfOrganizedMap.this.mMode & 8) != 0) {
                        int n = SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex][1];
                        int n5 = SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex + 1][1];
                        for (int i = n; i <= n5; ++i) {
                            int n6 = i == n ? SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex][0] : 0;
                            int n7 = i == n5 ? SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex + 1][0] : ((SelfOrganizedMap)SelfOrganizedMap.this).mSMPInfluenceRect.width;
                            int n8 = i + ((SelfOrganizedMap)SelfOrganizedMap.this).mSMPInfluenceRect.y;
                            for (int j = n6; j < n7; ++j) {
                                int n9 = j + ((SelfOrganizedMap)SelfOrganizedMap.this).mSMPInfluenceRect.x;
                                int n10 = Math.abs(this.mLocation.x - n9);
                                int n11 = Math.abs(this.mLocation.y - n8);
                                if (n10 > SelfOrganizedMap.this.mNX / 2) {
                                    n10 = SelfOrganizedMap.this.mNX - n10;
                                }
                                if (n11 > SelfOrganizedMap.this.mNY / 2) {
                                    n11 = SelfOrganizedMap.this.mNY - n11;
                                }
                                if (!(SelfOrganizedMap.this.mInfluence[n10][n11] > 0.0)) continue;
                                SelfOrganizedMap.this.updateReference(this.mInputVector, SelfOrganizedMap.this.mReferenceVector[n9 < 0 ? n9 + SelfOrganizedMap.this.mNX : (n9 < SelfOrganizedMap.this.mNX ? n9 : n9 - SelfOrganizedMap.this.mNX)][n8 < 0 ? n8 + SelfOrganizedMap.this.mNY : (n8 < SelfOrganizedMap.this.mNY ? n8 : n8 - SelfOrganizedMap.this.mNY)], SelfOrganizedMap.this.mInfluence[n10][n11]);
                            }
                        }
                    } else {
                        int n = SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex][1];
                        int n12 = SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex + 1][1];
                        for (int i = n; i <= n12; ++i) {
                            int n13 = i == n ? SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex][0] : 0;
                            int n14 = i == n12 ? SelfOrganizedMap.this.mSMPInfluenceIndex[this.mThreadIndex + 1][0] : ((SelfOrganizedMap)SelfOrganizedMap.this).mSMPInfluenceRect.width;
                            int n15 = i + ((SelfOrganizedMap)SelfOrganizedMap.this).mSMPInfluenceRect.y;
                            for (int j = n13; j < n14; ++j) {
                                int n16;
                                int n17 = j + ((SelfOrganizedMap)SelfOrganizedMap.this).mSMPInfluenceRect.x;
                                int n18 = Math.abs(this.mLocation.x - n17);
                                if (!(SelfOrganizedMap.this.mInfluence[n18][n16 = Math.abs(this.mLocation.y - n15)] > 0.0)) continue;
                                SelfOrganizedMap.this.updateReference(this.mInputVector, SelfOrganizedMap.this.mReferenceVector[n17][n15], SelfOrganizedMap.this.mInfluence[n18][n16]);
                            }
                        }
                    }
                    break;
                }
            }
            this.mDoneSignal.countDown();
        }

        public Point getBestMatchLocation() {
            return this.mLocation;
        }

        public double getBestMatchDissimilarity() {
            return this.mMinDissimilarity;
        }
    }
}

