/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.calc.CorrelationCalculator;
import com.actelion.research.calc.Matrix;
import com.actelion.research.chem.descriptor.SimilarityCalculatorDoubleArray;
import com.actelion.research.util.DoubleVec;
import com.actelion.research.util.Formatter;
import com.actelion.research.util.datamodel.DoubleArray;
import com.actelion.research.util.datamodel.IdentifiedObject;
import com.actelion.research.util.datamodel.IntVec;
import com.actelion.research.util.datamodel.IntegerDouble;
import com.actelion.research.util.datamodel.ScorePoint;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;

public class MatrixFunctions {
    private static final double TINY = 1.0E-7;

    public static Matrix convert2Binary(Matrix matrix, double d) {
        int n = matrix.rows();
        int n2 = matrix.cols();
        Matrix matrix2 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!(matrix.get(i, j) > d)) continue;
                matrix2.set(i, j, 1.0);
            }
        }
        return matrix2;
    }

    public static Matrix[] split(Matrix matrix, int n) {
        int n2;
        int n3;
        int n4 = matrix.rows();
        int n5 = matrix.cols();
        int n6 = n4 - n;
        Matrix matrix2 = new Matrix(n, n5);
        Matrix matrix3 = new Matrix(n6, n5);
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                matrix2.set(n3, n2, matrix.get(n3, n2));
            }
        }
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                matrix3.set(n3, n2, matrix.get(n3 + n, n2));
            }
        }
        Matrix[] matrixArray = new Matrix[]{matrix2, matrix3};
        return matrixArray;
    }

    public static Matrix[] splitCol(Matrix matrix, int n) {
        int n2;
        int n3;
        int n4 = matrix.rows();
        int n5 = matrix.cols();
        int n6 = n5 - n;
        Matrix matrix2 = new Matrix(n4, n);
        Matrix matrix3 = new Matrix(n4, n6);
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                matrix2.set(n3, n2, matrix.get(n3, n2));
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                matrix3.set(n3, n2, matrix.get(n3, n2 + n));
            }
        }
        Matrix[] matrixArray = new Matrix[]{matrix2, matrix3};
        return matrixArray;
    }

    public static boolean isEqualCol(Matrix matrix, int n, Matrix matrix2, int n2, double d) {
        boolean bl = true;
        int n3 = matrix.rows();
        if (n3 != matrix2.rows()) {
            throw new RuntimeException("Row number differs!");
        }
        for (int i = 0; i < n3; ++i) {
            double d2 = Math.abs(matrix.get(i, n) - matrix2.get(i, n2));
            if (!(d2 > d)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean equals(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-7;
    }

    public static double[][] id(int n) {
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return dArray;
    }

    public static Matrix inv(Matrix matrix) {
        int n;
        int n2 = matrix.rows();
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double[][] dArray3 = MatrixFunctions.id(n2);
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                dArray2[n][i] = matrix.get(n, i);
            }
        }
        for (n = 0; n < n2 - 1; ++n) {
            int n3;
            double d = Math.abs(dArray2[n][n]);
            for (n3 = n + 1; n3 < n2; ++n3) {
                if (!(Math.abs(dArray2[n3][n]) > d)) continue;
                d = Math.abs(dArray2[n3][n]);
                double[] dArray4 = dArray2[n3];
                dArray2[n3] = dArray2[n];
                dArray2[n] = dArray4;
                dArray4 = dArray3[n3];
                dArray3[n3] = dArray3[n];
                dArray3[n] = dArray4;
            }
            for (n3 = n + 1; n3 < n2; ++n3) {
                int n4;
                double d2 = dArray2[n3][n] / dArray2[n][n];
                for (n4 = n; n4 < n2; ++n4) {
                    dArray2[n3][n4] = dArray2[n3][n4] - d2 * dArray2[n][n4];
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    dArray3[n3][n4] = dArray3[n3][n4] - d2 * dArray3[n][n4];
                }
            }
        }
        for (n = 0; n < dArray3.length; ++n) {
            for (int i = n2 - 1; i > -1; --i) {
                double d = 0.0;
                for (int j = i + 1; j < n2; ++j) {
                    d += dArray2[i][j] * dArray[j][n];
                }
                dArray[i][n] = (dArray3[i][n] - d) / dArray2[i][i];
            }
        }
        return new Matrix(dArray);
    }

    public static boolean isSymmetric(Matrix matrix) {
        int n = matrix.rows();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (matrix.get(i, j) == matrix.get(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSquare(Matrix matrix) {
        int n;
        int n2 = matrix.rows();
        return n2 == (n = matrix.cols());
    }

    public static Matrix cholesky(Matrix matrix) {
        if (!MatrixFunctions.isSquare(matrix)) {
            throw new RuntimeException("Matrix is not square");
        }
        if (!MatrixFunctions.isSymmetric(matrix)) {
            throw new RuntimeException("Matrix is not symmetric");
        }
        int n = matrix.rows();
        double[][] dArray = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                double d = 0.0;
                for (int k = 0; k < j; ++k) {
                    d += dArray[i][k] * dArray[j][k];
                }
                if (i == j) {
                    dArray[i][i] = Math.sqrt(matrix.get(i, i) - d);
                    continue;
                }
                dArray[i][j] = 1.0 / dArray[j][j] * (matrix.get(i, j) - d);
            }
            if (!(dArray[i][i] <= 0.0)) continue;
            throw new RuntimeException("Matrix not positive definite");
        }
        return new Matrix(dArray);
    }

    public static Matrix calculateSimilarityMatrixRowWise(Matrix matrix, Matrix matrix2) {
        SimilarityCalculatorDoubleArray similarityCalculatorDoubleArray = new SimilarityCalculatorDoubleArray();
        int n = matrix.rows();
        int n2 = matrix2.rows();
        Matrix matrix3 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            double[] dArray = matrix.getRow(i);
            for (int j = 0; j < n2; ++j) {
                double[] dArray2 = matrix2.getRow(j);
                double d = similarityCalculatorDoubleArray.getSimilarity(dArray, dArray2);
                matrix3.set(i, j, d);
            }
        }
        return matrix3;
    }

    public static double[] calculateMaxSimilarity(Matrix matrix, Matrix matrix2) {
        double[] dArray = new double[matrix2.rows()];
        int n = matrix2.rows();
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = matrix2.getRow(i);
            IntegerDouble integerDouble = MatrixFunctions.calculateMaxSimilarity(matrix, dArray2);
            dArray[i] = integerDouble.getDouble();
        }
        return dArray;
    }

    public static IntegerDouble[] calculateMaxSimilarity(Matrix matrix, double[] dArray, int n) {
        int n2;
        ArrayList<IntegerDouble> arrayList = new ArrayList<IntegerDouble>();
        int n3 = matrix.rows();
        for (n2 = 0; n2 < n3; ++n2) {
            double d = DoubleVec.getTanimotoSimilarity(matrix.getRow(n2), dArray);
            arrayList.add(new IntegerDouble(n2, d));
        }
        Collections.sort(arrayList, IntegerDouble.getComparatorDouble());
        Collections.reverse(arrayList);
        n2 = Math.min(arrayList.size(), n);
        IntegerDouble[] integerDoubleArray = new IntegerDouble[n2];
        for (int i = 0; i < n2; ++i) {
            integerDoubleArray[i] = (IntegerDouble)arrayList.get(i);
        }
        return integerDoubleArray;
    }

    public static IntegerDouble calculateMaxSimilarity(Matrix matrix, double[] dArray) {
        int n = matrix.rows();
        IntegerDouble integerDouble = new IntegerDouble(-1, 0.0);
        for (int i = 0; i < n; ++i) {
            double d = DoubleVec.getTanimotoSimilarity(matrix.getRow(i), dArray);
            if (!(d > integerDouble.getDouble())) continue;
            integerDouble.setInteger(i);
            integerDouble.setDouble(d);
        }
        return integerDouble;
    }

    public static double[] upperTriangle(Matrix matrix) {
        int n = matrix.rows();
        int n2 = (n * n - n) / 2;
        double[] dArray = new double[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                dArray[n3++] = matrix.get(i, j);
            }
        }
        return dArray;
    }

    public static Matrix appendRows(List<Matrix> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        int n = list.get(0).cols();
        int n2 = 0;
        for (Matrix matrix : list) {
            n2 += matrix.rows();
        }
        Matrix matrix = new Matrix(n2, n);
        int n3 = 0;
        for (Matrix matrix2 : list) {
            matrix.copy(n3, matrix2);
            n3 += matrix2.rows();
        }
        return matrix;
    }

    public static Matrix appendRows(Matrix matrix, Matrix matrix2) {
        int n;
        int n2;
        Matrix matrix3 = new Matrix(matrix.rows() + matrix2.rows(), matrix.cols());
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            for (n = 0; n < matrix.cols(); ++n) {
                matrix3.set(n2, n, matrix.get(n2, n));
            }
        }
        n2 = matrix.rows();
        for (n = 0; n < matrix2.rows(); ++n) {
            for (int i = 0; i < matrix2.cols(); ++i) {
                matrix3.set(n + n2, i, matrix2.get(n, i));
            }
        }
        return matrix3;
    }

    public static Matrix appendCols(Matrix matrix, Matrix matrix2) {
        int n;
        int n2;
        if (matrix.rows() != matrix2.rows()) {
            throw new RuntimeException("Number rows differ!");
        }
        Matrix matrix3 = new Matrix(matrix.rows(), matrix.cols() + matrix2.cols());
        for (n2 = 0; n2 < matrix.rows(); ++n2) {
            for (n = 0; n < matrix.cols(); ++n) {
                matrix3.set(n2, n, matrix.get(n2, n));
            }
        }
        n2 = matrix.cols();
        for (n = 0; n < matrix2.rows(); ++n) {
            for (int i = 0; i < matrix2.cols(); ++i) {
                matrix3.set(n, i + n2, matrix2.get(n, i));
            }
        }
        return matrix3;
    }

    public static Matrix create(List<double[]> list) {
        double[][] dArrayArray = new double[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            dArrayArray[i] = list.get(i);
        }
        return new Matrix(dArrayArray);
    }

    public static int countFieldsBiggerThan(Matrix matrix, int n, double d) {
        int n2 = 0;
        for (int i = 0; i < matrix.getColDim(); ++i) {
            if (!(matrix.get(n, i) > d)) continue;
            ++n2;
        }
        return n2;
    }

    public static int countFieldsBiggerThanThreshColWise(Matrix matrix, int n, double d) {
        int n2 = 0;
        for (int i = 0; i < matrix.rows(); ++i) {
            if (!(matrix.get(i, n) > d)) continue;
            ++n2;
        }
        return n2;
    }

    public static Matrix countFieldsBiggerThanThreshColWise(Matrix matrix, double d) {
        Matrix matrix2 = new Matrix(1, matrix.cols());
        for (int i = 0; i < matrix.cols(); ++i) {
            int n = MatrixFunctions.countFieldsBiggerThanThreshColWise(matrix, i, d);
            matrix2.set(0, i, n);
        }
        return matrix2;
    }

    public static Matrix getDistanceMatrixTanimotoInv(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = new Matrix(matrix.getRowDim(), matrix2.getRowDim());
        for (int i = 0; i < matrix.getRowDim(); ++i) {
            for (int j = 0; j < matrix2.getRowDim(); ++j) {
                double d = MatrixFunctions.getDistanceTanimotoInv(matrix, i, matrix2, j);
                matrix3.set(i, j, d);
            }
        }
        return matrix3;
    }

    public static Matrix getDistanceMatrix(List<Point> list) {
        Matrix matrix = new Matrix(list.size(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                double d = list.get(i).distance(list.get(j));
                matrix.set(i, j, d);
            }
        }
        return matrix;
    }

    public static Matrix getDistTanimotoInvReduced(Matrix matrix, Matrix matrix2) {
        Matrix matrix3 = new Matrix(matrix.getRowDim(), matrix2.getRowDim());
        for (int i = 0; i < matrix.getRowDim(); ++i) {
            for (int j = 0; j < matrix2.getRowDim(); ++j) {
                double d = MatrixFunctions.getDistTanimotoInvReduced(matrix, i, matrix2, j);
                matrix3.set(i, j, d);
            }
        }
        return matrix3;
    }

    public static double getDistanceTanimotoInv(Matrix matrix, int n, Matrix matrix2, int n2) {
        double d = 0.0;
        double d2 = matrix.multiply(n, matrix2, n2);
        double d3 = matrix.multiply(n, matrix, n);
        double d4 = matrix2.multiply(n2, matrix2, n2);
        d = d2 / (d3 + d4 - d2);
        return 1.0 - d;
    }

    public static double getSumSquaredDiff(Matrix matrix, int n, Matrix matrix2, int n2) {
        double d = 0.0;
        for (int i = 0; i < matrix.cols(); ++i) {
            double d2 = matrix.get(n, i) - matrix2.get(n2, i);
            d += d2 * d2;
        }
        return d;
    }

    public static double getTotalSumSquaredDiffRowWise(Matrix matrix, Matrix matrix2) {
        int n = matrix.rows();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = MatrixFunctions.getSumSquaredDiff(matrix, i, matrix2, i);
            d += d2;
            System.out.println(Formatter.format1(d2));
        }
        return d;
    }

    public static double getDistTanimotoInvReduced(Matrix matrix, int n, Matrix matrix2, int n2) {
        double d = 0.0;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (int i = 0; i < matrix.getColDim(); ++i) {
            if (matrix.get(n, i) == 0.0 && matrix2.get(n2, i) == 0.0) continue;
            arrayList.add(new Double(matrix.get(n, i)));
            arrayList2.add(new Double(matrix2.get(n2, i)));
        }
        Matrix matrix3 = new Matrix(true, arrayList);
        Matrix matrix4 = new Matrix(true, arrayList2);
        double d2 = matrix3.multiply(0, matrix4, 0);
        double d3 = matrix3.multiply(0, matrix3, 0);
        double d4 = matrix4.multiply(0, matrix4, 0);
        d = d2 / (d3 + d4 - d2);
        return 1.0 - d;
    }

    public static List<Point> getMooreNeighborhood(Point point, Matrix matrix) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = Math.max(0, point.x - 1);
        int n2 = Math.min(matrix.cols(), point.x + 2);
        int n3 = Math.max(0, point.y - 1);
        int n4 = Math.min(matrix.rows(), point.y + 2);
        for (int i = n3; i < n4; ++i) {
            for (int j = n; j < n2; ++j) {
                if (i == point.y && j == point.x || !(matrix.get(i, j) > 0.0)) continue;
                arrayList.add(new Point(j, i));
            }
        }
        return arrayList;
    }

    public static List<Point> getMooreNeighborhood(Point point, int n, Matrix matrix) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n2 = Math.max(0, point.x - n);
        int n3 = Math.min(matrix.cols(), point.x + n + 1);
        int n4 = Math.max(0, point.y - n);
        int n5 = Math.min(matrix.rows(), point.y + n + 1);
        for (int i = n4; i < n5; ++i) {
            for (int j = n2; j < n3; ++j) {
                if (i == point.y && j == point.x || !(matrix.get(i, j) > 0.0)) continue;
                arrayList.add(new Point(j, i));
            }
        }
        return arrayList;
    }

    public static Matrix getRowMinUnique(Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix);
        Matrix matrix3 = new Matrix(matrix2.getRowDim(), 1);
        for (int i = 0; i < matrix2.getRowDim(); ++i) {
            ScorePoint scorePoint = matrix2.getMinPos();
            matrix3.set(scorePoint.y, 0, scorePoint.getScore());
            matrix2.setRow(scorePoint.y, Double.MAX_VALUE);
            matrix2.setCol(scorePoint.x, Double.MAX_VALUE);
        }
        return matrix3;
    }

    public static List<Point> getPoints(Matrix matrix) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        for (int i = 0; i < matrix.rows(); ++i) {
            for (int j = 0; j < matrix.cols(); ++j) {
                if (!(matrix.get(i, j) > 0.0)) continue;
                arrayList.add(new Point(j, i));
            }
        }
        return arrayList;
    }

    public static List<Point> getIndicesUniqueMaxRowWise(Matrix matrix) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Matrix matrix2 = new Matrix(matrix);
        for (int i = 0; i < matrix2.rows(); ++i) {
            Point point = matrix2.getMaxIndex();
            arrayList.add(point);
            int n = point.y;
            for (int j = 0; j < matrix2.cols(); ++j) {
                matrix2.set(n, j, -1.7976931348623157E308);
            }
        }
        return arrayList;
    }

    public static List<Point> getIndicesUniqueMaxColumnWise(Matrix matrix) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Matrix matrix2 = new Matrix(matrix);
        for (int i = 0; i < matrix2.cols(); ++i) {
            Point point = matrix2.getMaxIndex();
            arrayList.add(point);
            int n = point.x;
            for (int j = 0; j < matrix2.rows(); ++j) {
                matrix2.set(j, n, -1.7976931348623157E308);
            }
        }
        return arrayList;
    }

    public static Matrix getScaledByFactor(Matrix matrix, double d) {
        int n = (int)((double)matrix.cols() * d + 0.5);
        int n2 = (int)((double)matrix.rows() * d + 0.5);
        Matrix matrix2 = new Matrix(n2, n);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d2 = matrix.get((int)((double)i / d), (int)((double)j / d));
                matrix2.set(i, j, d2);
            }
        }
        return matrix2;
    }

    public static Matrix getScaled(Matrix matrix) {
        Matrix matrix2 = matrix.getCenteredMatrix();
        Matrix matrix3 = matrix.getStandardDeviationCols();
        int n = matrix.rows();
        int n2 = matrix.cols();
        Matrix matrix4 = new Matrix(n, n2);
        for (int i = 0; i < n2; ++i) {
            double d = matrix3.get(0, i);
            for (int j = 0; j < n; ++j) {
                matrix4.set(j, i, matrix2.get(j, i) / d);
            }
        }
        return matrix4;
    }

    public static Matrix getKMeanClusters(Matrix matrix, int n) {
        int n2;
        Matrix matrix2 = new Matrix(n, matrix.getColDim());
        int n3 = 100;
        int[] nArray = new int[matrix.getRowDim()];
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            n2 = random.nextInt(matrix.getRowDim());
            matrix2.assignRow(i, matrix.getRow(n2));
        }
        matrix2 = matrix2.getSorted();
        Matrix matrix3 = new Matrix(matrix2);
        n2 = 0;
        do {
            int n4;
            matrix2 = new Matrix(matrix3);
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = -1;
            }
            Matrix matrix4 = MatrixFunctions.getDistTanimotoInvReduced(matrix, matrix2);
            for (int i = 0; i < matrix4.getRowDim(); ++i) {
                nArray[i] = n4 = matrix4.getMinRowIndexRND(i);
            }
            double[] dArray = new double[n];
            matrix3.set(0.0);
            for (n4 = 0; n4 < matrix.getRowDim(); ++n4) {
                int n5 = nArray[n4];
                matrix3.add2Row(n5, matrix, n4);
                int n6 = n5;
                dArray[n6] = dArray[n6] + 1.0;
            }
            for (n4 = 0; n4 < matrix3.getRowDim(); ++n4) {
                if (dArray[n4] > 0.0) {
                    matrix3.devideRow(n4, dArray[n4]);
                    continue;
                }
                matrix3.assignRow(n4, matrix2.getRow(n4));
            }
            matrix3 = matrix3.getSorted();
            if (++n2 <= n3) continue;
            System.err.print("Max num iterations reached.\n");
            break;
        } while (!matrix2.equal(matrix3));
        System.out.println("Number iterations: " + n2);
        return matrix2;
    }

    public static final double getCorrPearson(Matrix matrix, Matrix matrix2) {
        double[] dArray = matrix.toArray();
        double[] dArray2 = ArrayUtilsCalc.getCentered(dArray);
        double[] dArray3 = ArrayUtilsCalc.getNormalized(dArray2);
        double[] dArray4 = matrix2.toArray();
        double[] dArray5 = ArrayUtilsCalc.getCentered(dArray4);
        double[] dArray6 = ArrayUtilsCalc.getNormalized(dArray5);
        double d = ArrayUtilsCalc.getCorrPearsonStandardized(dArray3, dArray6);
        return d;
    }

    public static final double getCorrSpearman(Matrix matrix, Matrix matrix2) {
        double[] dArray = matrix.toArray();
        double[] dArray2 = matrix2.toArray();
        DoubleArray doubleArray = new DoubleArray(dArray);
        DoubleArray doubleArray2 = new DoubleArray(dArray2);
        CorrelationCalculator correlationCalculator = new CorrelationCalculator();
        double d = correlationCalculator.calculateCorrelation(doubleArray, doubleArray2, 1);
        return d;
    }

    public static double getCorrPearson(Matrix matrix, int n, int n2) {
        double d = 0.0;
        Matrix matrix2 = matrix.getCol(n);
        matrix2 = matrix2.getCenteredMatrix();
        matrix2 = matrix2.getNormalizedMatrix();
        Matrix matrix3 = matrix.getCol(n2);
        matrix3 = matrix3.getCenteredMatrix();
        matrix3 = matrix3.getNormalizedMatrix();
        d = MatrixFunctions.getCorrPearsonStandardized(matrix2, matrix3);
        return d;
    }

    private static double getCorrPearsonStandardized(Matrix matrix, Matrix matrix2) {
        double d = 0.0;
        double d2 = MatrixFunctions.getCovarianceCentered(matrix, matrix2);
        double d3 = matrix.getVarianceCentered();
        double d4 = matrix2.getVarianceCentered();
        d = d2 / (d3 * d4);
        return d;
    }

    public static double getCovariance(Matrix matrix, Matrix matrix2) {
        double d = 0.0;
        double d2 = matrix.getMean();
        double d3 = matrix2.getMean();
        double d4 = 0.0;
        for (int i = 0; i < matrix.getRowDim(); ++i) {
            for (int j = 0; j < matrix.getColDim(); ++j) {
                d4 += (matrix.get(i, j) - d2) * (matrix2.get(i, j) - d3);
            }
        }
        d = d4 / (double)(matrix.getNumElements() - 1);
        return d;
    }

    public static double getCovarianceCentered(Matrix matrix, Matrix matrix2) {
        double d = 0.0;
        double d2 = 0.0;
        int n = matrix.cols();
        int n2 = matrix.rows();
        for (int i = 0; i < n2; ++i) {
            double[] dArray = matrix.getRow(i);
            double[] dArray2 = matrix2.getRow(i);
            for (int j = 0; j < n; ++j) {
                d2 += dArray[j] * dArray2[j];
            }
        }
        d = d2 / (double)(matrix.getNumElements() - 1);
        return d;
    }

    public static Matrix getRandomMatrix(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        Random random = new Random();
        for (int i = 0; i < matrix.getRowDim(); ++i) {
            for (int j = 0; j < matrix.getColDim(); ++j) {
                matrix.set(i, j, random.nextDouble());
            }
        }
        return matrix;
    }

    public static Matrix rnorm(int n, double d, double d2) {
        Matrix matrix = new Matrix(n, 1);
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            double d3 = random.nextGaussian();
            d3 = d3 * d2 + d;
            matrix.set(i, 0, d3);
        }
        return matrix;
    }

    public static IntVec getNonZeroCols(Matrix matrix) {
        int n = matrix.cols() / 32;
        if (matrix.cols() % 32 > 0) {
            ++n;
        }
        IntVec intVec = new IntVec(n);
        int n2 = matrix.rows();
        int n3 = matrix.cols();
        for (int i = 0; i < n3; ++i) {
            boolean bl = true;
            for (int j = 0; j < n2; ++j) {
                if (!(Math.abs(matrix.get(j, i)) > Matrix.TINY16)) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            intVec.setBit(i);
        }
        return intVec;
    }

    public static void vecvec2Matrix(Vector<Vector<Double>> vector, Matrix matrix) {
        int n;
        Iterator<Vector<Double>> iterator = vector.iterator();
        int n2 = iterator.next().size();
        while (iterator.hasNext()) {
            n = iterator.next().size();
            if (n == n2) continue;
            throw new RuntimeException("All vectors must have the same length.");
        }
        n = vector.size();
        matrix.resize(n, n2);
        iterator = vector.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Vector<Double> vector2 = new Vector<Double>(iterator.next());
            for (int i = 0; i < vector2.size(); ++i) {
                matrix.set(n3, i, vector2.get(i));
            }
            ++n3;
        }
    }

    public static Matrix readCSV(File file) throws IOException {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = -1;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            object = string.split(",");
            if (n == -1) {
                n = ((String[])object).length;
            } else if (((String[])object).length != n) {
                throw new RuntimeException("Number of columns differ!");
            }
            arrayList.add(object);
        }
        object = new Matrix(arrayList.size(), n);
        for (int i = 0; i < arrayList.size(); ++i) {
            String[] stringArray = (String[])arrayList.get(i);
            for (int j = 0; j < stringArray.length; ++j) {
                double d = Double.parseDouble(stringArray[j]);
                ((Matrix)object).set(i, j, d);
            }
        }
        return object;
    }

    public static Matrix read(File file) throws IOException {
        return MatrixFunctions.read(file, false);
    }

    public static Matrix read(File file, boolean bl) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Matrix matrix = MatrixFunctions.read(fileInputStream, bl);
        fileInputStream.close();
        return matrix;
    }

    public static Matrix read(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        Matrix matrix = MatrixFunctions.read(byteArrayInputStream, false);
        ((InputStream)byteArrayInputStream).close();
        return matrix;
    }

    public static Matrix readAsLineBase64Encoded(String string) throws IOException {
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] byArray = decoder.decode(string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Matrix matrix = MatrixFunctions.read(byteArrayInputStream, false);
        ((InputStream)byteArrayInputStream).close();
        return matrix;
    }

    public static Matrix read(InputStream inputStream) {
        return MatrixFunctions.read(inputStream, false);
    }

    public static Matrix read(InputStream inputStream, boolean bl) {
        Object object;
        ArrayList<DoubleArray> arrayList = new ArrayList<DoubleArray>();
        Scanner scanner = new Scanner(inputStream);
        if (bl) {
            scanner.nextLine();
        }
        int n = 0;
        int n2 = 0;
        while (scanner.hasNextLine()) {
            double d;
            ++n;
            object = new Scanner(scanner.nextLine());
            DoubleArray doubleArray = null;
            if (n2 == 0) {
                doubleArray = new DoubleArray();
                while (((Scanner)object).hasNextDouble()) {
                    d = ((Scanner)object).nextDouble();
                    doubleArray.add(d);
                    ++n2;
                }
            } else {
                doubleArray = new DoubleArray(n2);
                while (((Scanner)object).hasNextDouble()) {
                    d = ((Scanner)object).nextDouble();
                    doubleArray.add(d);
                }
            }
            arrayList.add(doubleArray);
        }
        scanner.close();
        object = new double[n][n2];
        for (int i = 0; i < arrayList.size(); ++i) {
            DoubleArray doubleArray = (DoubleArray)arrayList.get(i);
            for (int j = 0; j < n2; ++j) {
                object[i][j] = doubleArray.get(j);
            }
        }
        return new Matrix((double[][])object);
    }

    public static void writeQuadraticSymmetricMatrixPairwise(Matrix matrix, File file) throws IOException {
        if (matrix.rows() != matrix.cols()) {
            throw new RuntimeException("Not a quadratic matrix");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        int n = matrix.rows();
        int n2 = (n * n - n) / 2;
        int n3 = 0;
        for (int i = 0; i < matrix.rows(); ++i) {
            for (int j = i + 1; j < matrix.cols(); ++j) {
                double d;
                double d2 = matrix.get(i, j);
                if (d2 != (d = matrix.get(j, i))) {
                    throw new RuntimeException("Matrix not symmetric");
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(i);
                stringBuilder.append("\t");
                stringBuilder.append(j);
                stringBuilder.append("\t");
                stringBuilder.append(d2);
                if (n3 < n2 - 1) {
                    stringBuilder.append("\n");
                }
                ++n3;
                bufferedWriter.write(stringBuilder.toString());
            }
        }
        bufferedWriter.close();
    }

    public static void columnIntoDoubleArray(Matrix matrix, int n, DoubleArray doubleArray) {
        doubleArray.clear();
        int n2 = matrix.rows();
        for (int i = 0; i < n2; ++i) {
            doubleArray.add(matrix.get(i, n));
        }
    }

    public static List<IdentifiedObject<double[]>> createIdentifiedObject(Matrix matrix) {
        int n = matrix.rows();
        ArrayList<IdentifiedObject<double[]>> arrayList = new ArrayList<IdentifiedObject<double[]>>(n);
        for (int i = 0; i < n; ++i) {
            double[] dArray = matrix.getRow(i);
            IdentifiedObject<double[]> identifiedObject = new IdentifiedObject<double[]>(dArray, i);
            arrayList.add(identifiedObject);
        }
        return arrayList;
    }
}

