/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.calc.LUDecomposition;
import com.actelion.research.util.DoubleVec;
import com.actelion.research.util.convert.String2DoubleArray;
import com.actelion.research.util.datamodel.IntegerDouble;
import com.actelion.research.util.datamodel.ScorePoint;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Vector;

public class Matrix {
    public static final double TINY04 = 1.0E-4;
    public static final double TINY08 = 1.0E-8;
    public static final double TINY16 = Math.pow(10.0, -16.0);
    public static String OUT_SEPARATOR_COL = "\t";
    public static String OUT_SEPARATOR_ROW = "\n";
    private static final String FORMAT = "0.############";
    public static final double TINY = 1.0E-11;
    private double[][] data;
    private int identifier;

    public Matrix() {
        this.data = new double[1][1];
    }

    public Matrix(int n, int n2) {
        this.data = new double[n][n2];
    }

    public Matrix(Matrix matrix) {
        this(matrix.getArray());
    }

    public Matrix(boolean bl, double[] dArray) {
        if (bl) {
            this.data = new double[1][];
            this.data[0] = dArray;
        } else {
            this.data = new double[dArray.length][1];
            for (int i = 0; i < this.getRowDim(); ++i) {
                this.data[i][0] = dArray[i];
            }
        }
    }

    public Matrix(boolean bl, byte[] byArray) {
        if (bl) {
            this.data = new double[1][byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                this.data[0][i] = byArray[i];
            }
        } else {
            this.data = new double[byArray.length][1];
            for (int i = 0; i < this.getRowDim(); ++i) {
                this.data[i][0] = byArray[i];
            }
        }
    }

    public Matrix(boolean bl, int[] nArray) {
        if (bl) {
            this.data = new double[1][nArray.length];
            for (int i = 0; i < this.getColDim(); ++i) {
                this.data[0][i] = nArray[i];
            }
        } else {
            this.data = new double[nArray.length][1];
            for (int i = 0; i < this.getRowDim(); ++i) {
                this.data[i][0] = nArray[i];
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.data = new double[dArray.length][];
        int n = dArray.length;
        int n2 = dArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = new double[n2];
            System.arraycopy(dArray[i], 0, dArray2, 0, n2);
            this.data[i] = dArray2;
        }
    }

    public Matrix(double[][] dArray, boolean bl) {
        if (!bl) {
            throw new RuntimeException("Only flat constructor!");
        }
        this.data = dArray;
    }

    public Matrix(float[][] fArray) {
        this.data = new double[fArray.length][fArray[0].length];
        int n = fArray.length;
        int n2 = fArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            for (int j = 0; j < dArray.length; ++j) {
                this.data[i][j] = fArray[i][j];
            }
        }
    }

    public Matrix(int[][] nArray) {
        this.data = new double[nArray.length][];
        int n = nArray.length;
        int n2 = nArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArray[j] = nArray[i][j];
            }
            this.data[i] = dArray;
        }
    }

    public Matrix(byte[][] byArray) {
        this.data = new double[byArray.length][];
        int n = byArray.length;
        int n2 = byArray[0].length;
        for (int i = 0; i < n; ++i) {
            double[] dArray = new double[n2];
            System.arraycopy(byArray[i], 0, dArray, 0, n2);
            this.data[i] = dArray;
        }
    }

    public Matrix(List<DoubleVec> list) {
        DoubleVec doubleVec = list.get(0);
        this.data = new double[list.size()][doubleVec.size()];
        for (int i = 0; i < this.getRowDim(); ++i) {
            doubleVec = list.get(i);
            for (int j = 0; j < this.getColDim(); ++j) {
                this.data[i][j] = doubleVec.get(j);
            }
        }
    }

    public Matrix(boolean bl, List<Double> list) {
        if (bl) {
            this.data = new double[1][list.size()];
            for (int i = 0; i < this.getColDim(); ++i) {
                this.data[0][i] = list.get(i);
            }
        } else {
            this.data = new double[list.size()][1];
            for (int i = 0; i < this.getRowDim(); ++i) {
                this.data[i][0] = list.get(i);
            }
        }
    }

    public Matrix add(double d) {
        int n = this.rows();
        int n2 = this.cols();
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2 = this.get(i, j) + d;
                matrix.set(i, j, d2);
            }
        }
        return matrix;
    }

    public void addRow(double[] dArray) {
        if (this.getColDim() != dArray.length) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        this.resize(this.getRowDim() + 1, this.getColDim());
        for (int i = 0; i < dArray.length; ++i) {
            this.data[this.getRowDim() - 1][i] = dArray[i];
        }
    }

    public void addRow(int[] nArray) {
        if (this.getColDim() != nArray.length) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        this.resize(this.getRowDim() + 1, this.getColDim());
        for (int i = 0; i < nArray.length; ++i) {
            this.data[this.getRowDim() - 1][i] = nArray[i];
        }
    }

    public void add2Row(int n, Matrix matrix, int n2) {
        for (int i = 0; i < this.getColDim(); ++i) {
            double[] dArray = this.data[n];
            int n3 = i;
            dArray[n3] = dArray[n3] + matrix.data[n2][i];
        }
    }

    public void addToElement(int n, int n2, double d) {
        double[] dArray = this.data[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    public Matrix add2CompleteCol(Matrix matrix) {
        Matrix matrix2 = new Matrix(this);
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                double[] dArray = matrix2.data[i];
                int n = j;
                dArray[n] = dArray[n] + matrix.data[0][j];
            }
        }
        return matrix2;
    }

    public void assignCol(int n, Matrix matrix) {
        if (this.getRowDim() != matrix.getRowDim()) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][n] = matrix.data[i][0];
        }
    }

    public void assignCol(int n, Matrix matrix, int n2) {
        if (this.getRowDim() != matrix.getRowDim()) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][n] = matrix.data[i][n2];
        }
    }

    public void assignRow(int n, Vector<Double> vector) {
        if (this.getColDim() != vector.size()) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int i = 0; i < this.data[0].length; ++i) {
            this.data[n][i] = vector.get(i);
        }
    }

    public void assignRow(int n, double[] dArray) {
        if (this.getColDim() != dArray.length) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.data[n][i] = dArray[i];
        }
    }

    public void assignRow(int n, int[] nArray) {
        if (this.getColDim() != nArray.length) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.data[n][i] = nArray[i];
        }
    }

    public void assignRow(int n, DoubleVec doubleVec) {
        if (this.getColDim() != doubleVec.size()) {
            throw new RuntimeException("Matrix and Vector have wrong dimensions.");
        }
        for (int i = 0; i < doubleVec.size(); ++i) {
            this.data[n][i] = doubleVec.get(i);
        }
    }

    public boolean containsRow(DoubleVec doubleVec) {
        boolean bl = false;
        int n = this.getRowDim();
        int n2 = this.getColDim();
        for (int i = 0; i < n; ++i) {
            bl = true;
            for (int j = 0; j < n2; ++j) {
                if (this.data[i][j] == doubleVec.get(j)) continue;
                bl = false;
                break;
            }
            if (bl) break;
        }
        return bl;
    }

    public void copy(Matrix matrix) {
        int n = matrix.rows();
        int n2 = matrix.cols();
        if (this.rows() == n && this.cols() == n2) {
            for (int i = 0; i < n; ++i) {
                System.arraycopy(matrix.data[i], 0, this.data[i], 0, n2);
            }
        } else {
            this.data = new double[n][];
            for (int i = 0; i < n; ++i) {
                double[] dArray = new double[n2];
                System.arraycopy(matrix.data[i], 0, dArray, 0, n2);
                this.data[i] = dArray;
            }
        }
    }

    public void copy(int n, Matrix matrix) {
        if (this.cols() != matrix.cols()) {
            throw new RuntimeException("Matrix col dimension error. Number of cols differ!");
        }
        int n2 = this.cols();
        int n3 = matrix.rows();
        for (int i = 0; i < n3; ++i) {
            System.arraycopy(matrix.data[i], 0, this.data[n + i], 0, n2);
        }
    }

    public void copyColumn(Matrix matrix, int n, int n2) {
        int n3 = matrix.rows();
        for (int i = 0; i < n3; ++i) {
            this.data[i][n2] = matrix.get(i, n);
        }
    }

    public final double get(int n, int n2) {
        return this.data[n][n2];
    }

    public Matrix getAbs() {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix.data[i][j] = Math.abs(this.data[i][j]);
            }
        }
        return matrix;
    }

    public final double[][] getArray() {
        return this.data;
    }

    public int[][] getArrayAsInt() throws NumberFormatException {
        int[][] nArray = new int[this.data.length][this.data[0].length];
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                if (this.data[i][j] > 2.147483647E9 || this.data[i][j] < -2.147483648E9) {
                    String string = "Double value instead of int " + this.data[i][j] + ".";
                    throw new NumberFormatException(string);
                }
                nArray[i][j] = (int)this.data[i][j];
            }
        }
        return nArray;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.data.length][this.data[0].length];
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                dArray[i][j] = this.data[i][j];
            }
        }
        return dArray;
    }

    public Matrix getCenteredMatrix() {
        int n = this.cols();
        int n2 = this.rows();
        double[][] dArrayArray = new double[n2][];
        Matrix matrix = this.getMeanCols();
        double[] dArray = matrix.getRow(0);
        for (int i = 0; i < n2; ++i) {
            double[] dArray2 = this.getRow(i);
            double[] dArray3 = new double[n];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            for (int j = 0; j < n; ++j) {
                dArray3[j] = dArray3[j] - dArray[j];
            }
            dArrayArray[i] = dArray3;
        }
        Matrix matrix2 = new Matrix();
        matrix2.setFlat(dArrayArray);
        return matrix2;
    }

    public Matrix getCenteredMatrix(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                matrix2.data[i][j] = this.data[i][j] - matrix.data[0][j];
            }
        }
        return matrix2;
    }

    public Matrix getCol(int n) {
        Matrix matrix = new Matrix(this.rows(), 1);
        int n2 = this.getRowDim();
        for (int i = 0; i < n2; ++i) {
            matrix.data[i][0] = this.data[i][n];
        }
        return matrix;
    }

    public Matrix removeCol(int n) {
        int n2 = this.rows();
        int n3 = this.cols();
        Matrix matrix = new Matrix(n2, n3 - 1);
        for (int i = 0; i < n2; ++i) {
            int n4 = 0;
            for (int j = 0; j < n3; ++j) {
                if (j == n) continue;
                matrix.data[i][n4++] = this.data[i][j];
            }
        }
        return matrix;
    }

    public double[] getColAsDouble(int n) {
        double[] dArray = new double[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            dArray[i] = this.data[i][n];
        }
        return dArray;
    }

    public List<Double> getColAsList(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(this.rows());
        for (int i = 0; i < this.rows(); ++i) {
            arrayList.add(this.data[i][n]);
        }
        return arrayList;
    }

    public float[] getColAsFloat(int n) {
        float[] fArray = new float[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            fArray[i] = (float)this.data[i][n];
        }
        return fArray;
    }

    public int[] getColAsInt(int n) {
        int[] nArray = new int[this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            nArray[i] = (int)(this.data[i][n] + 0.5);
        }
        return nArray;
    }

    public Matrix getColumns(Vector<Integer> vector) {
        Matrix matrix = new Matrix(this.getRowDim(), vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            int n = vector.get(i);
            matrix.assignCol(i, this, n);
        }
        return matrix;
    }

    public Matrix getColumns(List<Integer> list) {
        Matrix matrix = new Matrix(this.getRowDim(), list.size());
        for (int i = 0; i < list.size(); ++i) {
            int n = list.get(i);
            matrix.assignCol(i, this, n);
        }
        return matrix;
    }

    public Matrix getColumns(int[] nArray) {
        Matrix matrix = new Matrix(this.getRowDim(), nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            matrix.assignCol(i, this, n);
        }
        return matrix;
    }

    public int getColDim() {
        return this.data[0].length;
    }

    public int cols() {
        return this.data[0].length;
    }

    public Matrix getDeleteColsZeroVar(List<Integer> list) {
        list.clear();
        Matrix matrix = new Matrix(0, 0);
        Matrix matrix2 = this.getVarianceCols();
        list.clear();
        for (int i = 0; i < matrix2.getColDim(); ++i) {
            if (!(matrix2.get(0, i) > 0.0)) continue;
            list.add(new Integer(i));
        }
        matrix = this.getColumns(list);
        return matrix;
    }

    public Matrix covariance() {
        int n = this.getColDim();
        int n2 = this.getRowDim();
        Matrix matrix = new Matrix(n, n);
        int n3 = n2 - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    d2 += this.get(n4, i);
                    d3 += this.get(n4, j);
                }
                d2 /= (double)n2;
                d3 /= (double)n2;
                for (n4 = 0; n4 < n2; ++n4) {
                    d += (this.get(n4, i) - d2) * (this.get(n4, j) - d3);
                }
                matrix.set(i, j, d / (double)n3);
            }
        }
        return matrix;
    }

    public Matrix correlation() {
        int n;
        int n2;
        int n3 = this.getColDim();
        int n4 = this.getRowDim();
        Matrix matrix = new Matrix(n3, n3);
        int n5 = n4 - 1;
        Matrix matrix2 = new Matrix(n3, n3);
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                int n6;
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (n6 = 0; n6 < n4; ++n6) {
                    d2 += this.get(n6, n2);
                    d3 += this.get(n6, n);
                }
                d2 /= (double)n4;
                d3 /= (double)n4;
                for (n6 = 0; n6 < n4; ++n6) {
                    d += (this.get(n6, n2) - d2) * (this.get(n6, n) - d3);
                }
                matrix2.set(n2, n, d / (double)n5);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                matrix.set(n2, n, matrix2.get(n2, n) / Math.sqrt(matrix2.get(n2, n2) * matrix2.get(n, n)));
            }
        }
        return matrix;
    }

    public Matrix getDiagonal() {
        int n = Math.min(this.getRowDim(), this.getColDim());
        Matrix matrix = new Matrix(n, 1);
        for (int i = 0; i < n; ++i) {
            matrix.set(i, 0, this.data[i][i]);
        }
        return matrix;
    }

    public Matrix getLinedCol() {
        Matrix matrix = new Matrix(this.getNumElements(), 1);
        int n = 0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix.data[n][0] = this.data[i][j];
                ++n;
            }
        }
        return matrix;
    }

    public List<Double> getList() {
        ArrayList<Double> arrayList = new ArrayList<Double>(this.getRowDim() * this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                arrayList.add(this.data[i][j]);
            }
        }
        return arrayList;
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    dArray[i - n][j - n3] = this.data[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    dArray[i][j] = this.data[nArray[i]][nArray2[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int n, int n2, int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[i - n][j] = this.data[i][nArray[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    dArray[i][j - n] = this.data[nArray[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public int getNumElements() {
        return this.cols() * this.rows();
    }

    public int getNumElementsLarger(double d) {
        int n = 0;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                if (!(this.data[i][j] > d)) continue;
                ++n;
            }
        }
        return n;
    }

    public int getNumElementsEqual(double d) {
        int n = 0;
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                if (this.data[i][j] != d) continue;
                ++n;
            }
        }
        return n;
    }

    public Matrix log() {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                matrix.data[i][j] = this.data[i][j] > 0.0 ? Math.log(this.data[i][j]) : 0.0;
            }
        }
        return matrix;
    }

    public Matrix diagonalize() {
        Matrix matrix;
        block3: {
            block2: {
                matrix = new Matrix();
                if (this.getRowDim() <= 1 || this.cols() != 1) break block2;
                matrix.resize(this.rows(), this.rows());
                for (int i = 0; i < matrix.rows(); ++i) {
                    matrix.data[i][i] = this.data[i][0];
                }
                break block3;
            }
            if (this.cols() <= 1 || this.rows() != 1) break block3;
            matrix.resize(this.cols(), this.cols());
            for (int i = 0; i < matrix.cols(); ++i) {
                matrix.data[i][i] = this.data[0][i];
            }
        }
        return matrix;
    }

    public Matrix devide(double d) {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix.data[i][j] = this.data[i][j] / d;
            }
        }
        return matrix;
    }

    public Matrix devide(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix2.data[i][j] = this.data[i][j] / matrix.data[i][j];
            }
        }
        return matrix2;
    }

    public Matrix devideDivisorBigger(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix2.data[i][j] = this.data[i][j] < matrix.data[i][j] ? this.data[i][j] / matrix.data[i][j] : matrix.data[i][j] / this.data[i][j];
            }
        }
        return matrix2;
    }

    public Matrix devideCols(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix2.data[i][j] = this.data[i][j] / matrix.get(0, j);
            }
        }
        return matrix2;
    }

    public void devideRow(int n, double d) {
        int n2 = 0;
        while (n2 < this.getColDim()) {
            double[] dArray = this.data[n];
            int n3 = n2++;
            dArray[n3] = dArray[n3] / d;
        }
    }

    public static final void getEigenvector(Matrix matrix, int n, Matrix matrix2, Matrix matrix3) {
        int n2;
        double d;
        double d2;
        int n3;
        int n4;
        int n5;
        double[] dArray = matrix.toArray();
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        int n6 = n;
        for (n5 = n - 1; n5 >= 1; --n5) {
            n4 = n5;
            double d3 = 0.0;
            double d4 = 0.0;
            if (n4 > 0) {
                for (n3 = 0; n3 < n4; ++n3) {
                    d3 += Math.abs(dArray[n5 * n6 + n3]);
                }
                if (d3 == 0.0) {
                    dArray3[n5] = dArray[n5 * n6 + n4 - 1];
                } else {
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n7 = n5 * n6 + n3;
                        dArray[n7] = dArray[n7] / d3;
                        d4 += dArray[n5 * n6 + n3] * dArray[n5 * n6 + n3];
                    }
                    d2 = dArray[n5 * n6 + n4 - 1];
                    d = d2 >= 0.0 ? -Math.sqrt(d4) : Math.sqrt(d4);
                    dArray3[n5] = d3 * d;
                    d4 -= d2 * d;
                    dArray[n5 * n6 + n4 - 1] = d2 - d;
                    d2 = 0.0;
                    for (n2 = 0; n2 < n4; ++n2) {
                        dArray[n2 * n6 + n5] = dArray[n5 * n6 + n2] / d4;
                        d = 0.0;
                        for (n3 = 0; n3 < n2 + 1; ++n3) {
                            d += dArray[n2 * n6 + n3] * dArray[n5 * n6 + n3];
                        }
                        for (n3 = n2 + 1; n3 < n4; ++n3) {
                            d += dArray[n3 * n6 + n2] * dArray[n5 * n6 + n3];
                        }
                        dArray3[n2] = d / d4;
                        d2 += dArray3[n2] * dArray[n5 * n6 + n2];
                    }
                    double d5 = d2 / (d4 + d4);
                    for (n2 = 0; n2 < n4; ++n2) {
                        d2 = dArray[n5 * n6 + n2];
                        dArray3[n2] = d = dArray3[n2] - d5 * d2;
                        for (n3 = 0; n3 < n2 + 1; ++n3) {
                            int n8 = n2 * n6 + n3;
                            dArray[n8] = dArray[n8] - (d2 * dArray3[n3] + d * dArray[n5 * n6 + n3]);
                        }
                    }
                }
            } else {
                dArray3[n5] = dArray[n5 * n6 + n4 - 1];
            }
            dArray2[n5] = d4;
        }
        dArray2[0] = 0.0;
        dArray3[0] = 0.0;
        for (n5 = 0; n5 < n; ++n5) {
            n4 = n5;
            if (dArray2[n5] != 0.0) {
                for (n2 = 0; n2 < n4; ++n2) {
                    d = 0.0;
                    for (n3 = 0; n3 < n4; ++n3) {
                        d += dArray[n5 * n6 + n3] * dArray[n3 * n6 + n2];
                    }
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n9 = n3 * n6 + n2;
                        dArray[n9] = dArray[n9] - d * dArray[n3 * n6 + n5];
                    }
                }
            }
            dArray2[n5] = dArray[n5 * n6 + n5];
            dArray[n5 * n6 + n5] = 1.0;
            for (n2 = 0; n2 < n4; ++n2) {
                dArray[n5 * n6 + n2] = 0.0;
                dArray[n2 * n6 + n5] = 0.0;
            }
        }
        for (n5 = 1; n5 < n; ++n5) {
            dArray3[n5 - 1] = dArray3[n5];
        }
        dArray3[n - 1] = 0.0;
        for (n4 = 0; n4 < n; ++n4) {
            int n10;
            int n11 = 0;
            do {
                for (n10 = n4; n10 <= n - 2; ++n10) {
                    double d6 = Math.abs(dArray2[n10]) + Math.abs(dArray2[n10 + 1]);
                    if (Math.abs(dArray3[n10]) + d6 == d6) break;
                }
                if (n10 == n4) continue;
                if (n11++ == 30) {
                    System.err.println("Too many iterations in tqli");
                }
                d = (dArray2[n4 + 1] - dArray2[n4]) / (2.0 * dArray3[n4]);
                double d7 = Matrix.getPythag(d, 1.0);
                d = dArray2[n10] - dArray2[n4] + dArray3[n4] / (d + Matrix.Sign(d7, d));
                double d8 = 1.0;
                double d9 = 1.0;
                double d10 = 0.0;
                for (n5 = n10 - 1; n5 >= n4; --n5) {
                    d2 = d9 * dArray3[n5];
                    double d11 = d8 * dArray3[n5];
                    dArray3[n5 + 1] = d7 = Matrix.getPythag(d2, d);
                    if (d7 == 0.0) {
                        int n12 = n5 + 1;
                        dArray2[n12] = dArray2[n12] - d10;
                        dArray3[n10] = 0.0;
                        break;
                    }
                    d9 = d2 / d7;
                    d8 = d / d7;
                    d = dArray2[n5 + 1] - d10;
                    d7 = (dArray2[n5] - d) * d9 + 2.0 * d8 * d11;
                    d10 = d9 * d7;
                    dArray2[n5 + 1] = d + d10;
                    d = d8 * d7 - d11;
                    for (n3 = 0; n3 < n; ++n3) {
                        d2 = dArray[n3 * n6 + n5 + 1];
                        dArray[n3 * n6 + n5 + 1] = d9 * dArray[n3 * n6 + n5] + d8 * d2;
                        dArray[n3 * n6 + n5] = d8 * dArray[n3 * n6 + n5] - d9 * d2;
                    }
                }
                if (d7 == 0.0 && n5 >= n4) continue;
                int n13 = n4;
                dArray2[n13] = dArray2[n13] - d10;
                dArray3[n4] = d;
                dArray3[n10] = 0.0;
            } while (n10 != n4);
        }
        for (int i = 0; i < matrix.rows(); ++i) {
            for (int j = 0; j < matrix.cols(); ++j) {
                matrix.set(i, j, dArray[i * n + j]);
            }
        }
        matrix2.resize(n, 1);
        matrix2.setCol(0, dArray2);
        matrix3.resize(n, 1);
        matrix3.setCol(0, dArray3);
    }

    public double getMinRow(int n) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (!(this.data[n][i] < d)) continue;
            d = this.data[n][i];
        }
        return d;
    }

    public int getMinRowIndex(int n) {
        int n2 = 0;
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (!(this.data[n][i] < d)) continue;
            d = this.data[n][i];
            n2 = i;
        }
        return n2;
    }

    public int getMinRowIndexRND(int n) {
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.getColDim(); ++i) {
            arrayList.add(new Integer(i));
        }
        Collections.shuffle(arrayList);
        int[] nArray = new int[this.getColDim()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.getColDim(); ++i) {
            int n3 = nArray[i];
            if (!(this.data[n][n3] < d)) continue;
            d = this.data[n][n3];
            n2 = n3;
        }
        return n2;
    }

    public int getID() {
        return this.identifier;
    }

    public double getEuclideanDistanceFastRows(int n, Matrix matrix, int n2) {
        double d = 0.0;
        int n3 = this.cols();
        for (int i = 0; i < n3; ++i) {
            d += (this.data[n][i] - matrix.data[n2][i]) * (this.data[n][i] - matrix.data[n2][i]);
        }
        return d;
    }

    public double getEuclideanDistanceFastRows(int n, int n2) {
        double d = 0.0;
        int n3 = this.cols();
        for (int i = 0; i < n3; ++i) {
            d += (this.data[n][i] - this.data[n2][i]) * (this.data[n][i] - this.data[n2][i]);
        }
        return d;
    }

    public double getMaximumValue() {
        double d = Double.MIN_VALUE;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                if (!(d < this.data[i][j])) continue;
                d = this.data[i][j];
            }
        }
        return d;
    }

    public double getMean() {
        int n = this.getColDim();
        int n2 = this.getRowDim();
        double d = this.getSum() / (double)(n * n2);
        return d;
    }

    public Matrix getMeanCols() {
        int n;
        int n2 = this.cols();
        int n3 = this.rows();
        double[] dArray = new double[n2];
        for (n = 0; n < n3; ++n) {
            double[] dArray2 = this.data[n];
            for (int i = 0; i < dArray2.length; ++i) {
                int n4 = i;
                dArray[n4] = dArray[n4] + dArray2[i];
            }
        }
        n = 0;
        while (n < n2) {
            int n5 = n++;
            dArray[n5] = dArray[n5] / (double)n3;
        }
        return new Matrix(true, dArray);
    }

    public Matrix getMeanCols(int[] nArray) {
        Matrix matrix = new Matrix(1, this.getColDim());
        int n = this.getColDim();
        for (int i = 0; i < n; ++i) {
            matrix.data[0][i] = this.getMeanCol(i, nArray);
        }
        return matrix;
    }

    public double getMeanCol(int n) {
        int n2 = this.rows();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += this.data[i][n];
        }
        return d / (double)n2;
    }

    public double getMeanRow(int n) {
        int n2 = this.getColDim();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            d += this.data[n][i];
        }
        return d / (double)n2;
    }

    public Matrix getMeanRows() {
        Matrix matrix = new Matrix(1, this.getRowDim());
        int n = this.getRowDim();
        for (int i = 0; i < n; ++i) {
            matrix.set(0, i, this.getMeanRow(i));
        }
        return matrix;
    }

    public double getMeanCol(int n, int[] nArray) {
        int n2 = this.getRowDim();
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += this.data[nArray[i]][n];
        }
        return d / (double)n2;
    }

    public double getMedian(int n) {
        double[] dArray = this.getRowCopy(n);
        Arrays.sort(dArray);
        double d = 0.0;
        int n2 = dArray.length;
        if (n2 % 2 != 0) {
            d = dArray[n2 / 2];
        } else {
            int n3 = (int)((double)n2 / 2.0 + 0.5);
            d = (dArray[n3] + dArray[n3 - 1]) / 2.0;
        }
        return d;
    }

    public double getMedian() {
        int n = this.rows();
        int n2 = this.cols();
        double[] dArray = new double[n * n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[n3++] = this.get(i, j);
            }
        }
        Arrays.sort(dArray);
        double d = 0.0;
        int n4 = dArray.length;
        if (n4 % 2 != 0) {
            d = dArray[n4 / 2];
        } else {
            int n5 = (int)((double)n4 / 2.0 + 0.5);
            d = (dArray[n5] + dArray[n5 - 1]) / 2.0;
        }
        return d;
    }

    public Matrix getMedianCols() {
        Matrix matrix = new Matrix(1, this.cols());
        int n = this.rows();
        int n2 = this.cols();
        double[] dArray = new double[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j] = this.get(j, i);
            }
            Arrays.sort(dArray);
            double d = 0.0;
            int n3 = dArray.length;
            if (n3 % 2 != 0) {
                d = dArray[n3 / 2];
            } else {
                int n4 = (int)((double)n3 / 2.0 + 0.5);
                d = (dArray[n4] + dArray[n4 - 1]) / 2.0;
            }
            matrix.set(0, i, d);
        }
        return matrix;
    }

    public Matrix getMergeRows(Matrix matrix) {
        int n;
        int n2;
        Matrix matrix2 = new Matrix(this.getRowDim() + matrix.getRowDim(), this.getColDim());
        for (n2 = 0; n2 < this.getRowDim(); ++n2) {
            for (n = 0; n < this.getColDim(); ++n) {
                matrix2.data[n2][n] = this.data[n2][n];
            }
        }
        n2 = this.getRowDim();
        for (n = 0; n < matrix.getRowDim(); ++n) {
            for (int i = 0; i < this.getColDim(); ++i) {
                matrix2.data[n2 + n][i] = matrix.data[n][i];
            }
        }
        return matrix2;
    }

    public Matrix getMaxMin() {
        Matrix matrix = new Matrix(2, this.getColDim());
        int n = this.getColDim();
        for (int i = 0; i < n; ++i) {
            matrix.set(1, i, this.getMin(i));
            matrix.set(0, i, this.getMax(i));
        }
        return matrix;
    }

    public double getMax() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        double d = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!(this.data[i][j] > d)) continue;
                d = this.data[i][j];
            }
        }
        return d;
    }

    public double getMax(int n) {
        int n2 = this.getRowDim();
        double d = -1.7976931348623157E308;
        for (int i = 0; i < n2; ++i) {
            if (!(this.data[i][n] > d)) continue;
            d = this.data[i][n];
        }
        return d;
    }

    public Point getMaxIndex() {
        Point point = new Point(0, 0);
        int n = this.rows();
        int n2 = this.cols();
        double d = this.data[0][0];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!(this.data[i][j] > d)) continue;
                d = this.data[i][j];
                point.y = i;
                point.x = j;
            }
        }
        return point;
    }

    public double getMaxRow(int n) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (!(this.data[n][i] > d)) continue;
            d = this.data[n][i];
        }
        return d;
    }

    public int getMaxRowIndexRND(int n) {
        int n2 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < this.cols(); ++i) {
            arrayList.add(i);
        }
        Collections.shuffle(arrayList);
        int[] nArray = new int[this.getColDim()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.getColDim(); ++i) {
            int n3 = nArray[i];
            if (!(this.data[n][n3] > d)) continue;
            d = this.data[n][n3];
            n2 = n3;
        }
        return n2;
    }

    public int getMaxRowIndex(int n) {
        int n2 = -1;
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.rows(); ++i) {
            if (!(this.data[i][n] > d)) continue;
            d = this.data[i][n];
            n2 = i;
        }
        return n2;
    }

    public double getMin() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!(this.data[i][j] < d)) continue;
                d = this.data[i][j];
            }
        }
        return d;
    }

    public ScorePoint getMinPos() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        ScorePoint scorePoint = new ScorePoint();
        scorePoint.setScore(Double.MAX_VALUE);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (!(this.data[i][j] < scorePoint.getScore())) continue;
                scorePoint.y = i;
                scorePoint.x = j;
                scorePoint.setScore(this.data[i][j]);
            }
        }
        return scorePoint;
    }

    public Matrix getMinRows() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        Matrix matrix = new Matrix(n, 1);
        for (int i = 0; i < n; ++i) {
            double d = Double.MAX_VALUE;
            for (int j = 0; j < n2; ++j) {
                if (!(this.data[i][j] < d)) continue;
                d = this.data[i][j];
            }
            matrix.set(i, 0, d);
        }
        return matrix;
    }

    public Matrix getMinRowsPosCol() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        Matrix matrix = new Matrix(n, 2);
        for (int i = 0; i < n; ++i) {
            double d = Double.MAX_VALUE;
            for (int j = 0; j < n2; ++j) {
                if (!(this.data[i][j] < d)) continue;
                matrix.set(i, 0, j);
                matrix.set(i, 1, this.data[i][j]);
            }
        }
        return matrix;
    }

    public double getMin(int n) {
        int n2 = this.getRowDim();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < n2; ++i) {
            if (!(this.data[i][n] < d)) continue;
            d = this.data[i][n];
        }
        return d;
    }

    public int getMinColIndex(int n) {
        int n2 = this.getColDim();
        double d = Double.MAX_VALUE;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            if (!(this.data[n][i] < d)) continue;
            d = this.data[n][i];
            n3 = i;
        }
        return n3;
    }

    public int getColIndexContainingMaxVal(int n) {
        int n2 = this.getColDim();
        double d = -1.7976931348623157E308;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            if (!(this.data[n][i] > d)) continue;
            d = this.data[n][i];
            n3 = i;
        }
        return n3;
    }

    public ScorePoint getColIndexContainingMaxVal(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        double d = -1.7976931348623157E308;
        int n5 = -1;
        int n6 = -1;
        for (int i = 0; i < n3; ++i) {
            double d2 = -1.7976931348623157E308;
            int n7 = -1;
            for (int j = 0; j < n4; ++j) {
                if (!(this.data[j][i] > d2)) continue;
                d2 = this.data[j][i];
                n7 = j;
            }
            if (!(d2 > d)) continue;
            d = d2;
            n5 = n7;
            n6 = i;
        }
        ScorePoint scorePoint = new ScorePoint(n5, n6);
        scorePoint.setScore(d);
        return scorePoint;
    }

    public Matrix getNormalizedMatrix() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        Matrix matrix = new Matrix(n, n2);
        Matrix matrix2 = this.getStandardDeviationCols();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = matrix2.get(0, j);
                if (d == 0.0) {
                    d = 1.4E-45f;
                }
                double d2 = this.get(i, j) / d;
                matrix.set(i, j, d2);
            }
        }
        return matrix;
    }

    public Matrix getNormalizedMatrix(Matrix matrix) {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        Matrix matrix2 = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d = matrix.get(0, j);
                if (d == 0.0) {
                    d = 1.4E-45f;
                }
                double d2 = this.get(i, j) / d;
                matrix2.set(i, j, d2);
            }
        }
        return matrix2;
    }

    public double[] getUpperTriangle() {
        int n;
        int n2 = this.rows();
        if (n2 != (n = this.cols())) {
            throw new RuntimeException("Not a quadratic matrix.");
        }
        int n3 = (n2 * n2 - n2) / 2;
        double[] dArray = new double[n3];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                dArray[n4++] = this.get(i, j);
            }
        }
        return dArray;
    }

    public static double getPythag(double d, double d2) {
        double d3;
        double d4 = Math.abs(d);
        if (d4 > (d3 = Math.abs(d2))) {
            double d5 = d3 / d4 * (d3 / d4);
            return d4 * Math.sqrt(1.0 + d5);
        }
        if (d3 == 0.0) {
            return 0.0;
        }
        double d6 = d4 / d3 * (d4 / d3);
        return d3 * Math.sqrt(1.0 + d6);
    }

    public static double getPythag2(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public boolean areRowsEqual(int n, int n2) {
        boolean bl = true;
        int n3 = this.cols();
        for (int i = 0; i < n3; ++i) {
            double d = Math.abs(this.data[n][i] - this.data[n2][i]);
            if (!(d > 1.0E-11)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean equal(Matrix matrix) {
        boolean bl = true;
        if (this.equalDimension(matrix)) {
            block0: for (int i = 0; i < this.getRowDim(); ++i) {
                for (int j = 0; j < this.getColDim(); ++j) {
                    if (this.data[i][j] == matrix.data[i][j]) continue;
                    bl = false;
                    continue block0;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean equal(Matrix matrix, double d) {
        boolean bl = true;
        if (this.equalDimension(matrix)) {
            block0: for (int i = 0; i < this.getRowDim(); ++i) {
                for (int j = 0; j < this.getColDim(); ++j) {
                    double d2 = Math.abs(this.data[i][j] - matrix.data[i][j]);
                    if (!(d2 > d)) continue;
                    bl = false;
                    continue block0;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean equalDimension(Matrix matrix) {
        boolean bl = false;
        if (this.getColDim() == matrix.getColDim() && this.getRowDim() == matrix.getRowDim()) {
            bl = true;
        }
        return bl;
    }

    public boolean hasOnlyFinite() {
        boolean bl = true;
        int n = this.rows();
        int n2 = this.cols();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (Double.isFinite(this.data[i][j])) continue;
                bl = false;
                break block0;
            }
        }
        return bl;
    }

    public Matrix multiplyValByVal(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.rows(), this.cols());
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                matrix2.set(i, j, this.get(i, j) * matrix.get(i, j));
            }
        }
        return matrix2;
    }

    public Matrix multCols(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix2.data[i][j] = this.data[i][j] * matrix.get(0, j);
            }
        }
        return matrix2;
    }

    public Matrix multiply(double d) {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix.data[i][j] = this.data[i][j] * d;
            }
        }
        return matrix;
    }

    public Matrix multiply(Matrix matrix) {
        return this.multiply(false, false, matrix);
    }

    public double multiply(int n, Matrix matrix, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.getColDim(); ++i) {
            d += this.data[n][i] * matrix.data[n2][i];
        }
        return d;
    }

    public final Matrix multiply(boolean bl, boolean bl2, Matrix matrix) {
        double d;
        Object object;
        Object object2;
        reference var19_37;
        int n;
        int n2;
        Object object3;
        Object object4;
        Object object5;
        double[][] dArray;
        int n3;
        int n4;
        int n5;
        Matrix matrix2 = null;
        if (!bl && !bl2) {
            n5 = this.cols();
            n4 = this.rows();
            n3 = matrix.cols();
            if (n5 != matrix.rows()) {
                throw new RuntimeException("Error in Routine Matrix.multiply(...). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            matrix2 = new Matrix(this.rows(), matrix.cols());
            dArray = matrix2.getArray();
            object5 = matrix.getTranspose();
            double[][] dArray2 = ((Matrix)object5).getArray();
            object4 = null;
            object3 = null;
            n2 = n5 / 4 * 4;
            for (n = 0; n < n3; ++n) {
                object4 = dArray2[n];
                for (int i = 0; i < n4; ++i) {
                    int n6;
                    object3 = this.data[i];
                    double d2 = 0.0;
                    for (n6 = 0; n6 < n2; n6 += 4) {
                        var19_37 = object3[n6] * object4[n6];
                        object2 = object3[n6 + 1] * object4[n6 + 1];
                        object = object3[n6 + 2] * object4[n6 + 2];
                        d = (double)(object3[n6 + 3] * object4[n6 + 3]);
                        d2 += var19_37 + object2 + object + d;
                    }
                    for (n6 = n2; n6 < n5; ++n6) {
                        d2 += object3[n6] * object4[n6];
                    }
                    dArray[i][n] = d2;
                }
            }
        }
        if (bl && !bl2) {
            n5 = this.rows();
            n4 = this.cols();
            n3 = matrix.cols();
            if (n5 != matrix.rows()) {
                throw new RuntimeException("Error in Routine SMatrix::Mult(). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            matrix2 = new Matrix(this.cols(), matrix.cols());
            dArray = matrix2.getArray();
            object5 = null;
            int n7 = n5 / 4 * 4;
            object4 = this.getTranspose();
            object3 = ((Matrix)object4).getArray();
            Matrix matrix3 = matrix.getTranspose();
            double[][] dArray3 = matrix3.getArray();
            double[] dArray4 = null;
            for (int i = 0; i < n3; ++i) {
                object5 = dArray3[i];
                for (int j = 0; j < n4; ++j) {
                    int n8;
                    dArray4 = object3[j];
                    double d3 = 0.0;
                    for (n8 = 0; n8 < n7; n8 += 4) {
                        object2 = dArray4[n8] * object5[n8];
                        object = dArray4[n8 + 1] * object5[n8 + 1];
                        d = dArray4[n8 + 2] * object5[n8 + 2];
                        double d4 = dArray4[n8 + 3] * object5[n8 + 3];
                        d3 += object2 + object + d + d4;
                    }
                    for (n8 = n7; n8 < n5; ++n8) {
                        d3 += dArray4[n8] * object5[n8];
                    }
                    dArray[j][i] = d3;
                }
            }
        }
        if (!bl && bl2) {
            n5 = this.cols();
            n4 = this.rows();
            n3 = matrix.rows();
            if (n5 != matrix.cols()) {
                throw new RuntimeException("Error in Routine SMatrix::Mult(). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            matrix2 = new Matrix(this.rows(), n3);
            dArray = matrix2.getArray();
            object5 = null;
            int n9 = n5 / 4 * 4;
            object4 = null;
            for (int i = 0; i < n3; ++i) {
                object5 = matrix.data[i];
                for (n2 = 0; n2 < n4; ++n2) {
                    int n10;
                    object4 = this.data[n2];
                    double d5 = 0.0;
                    for (n10 = 0; n10 < n9; n10 += 4) {
                        reference var17_43 = object4[n10] * object5[n10];
                        var19_37 = object4[n10 + 1] * object5[n10 + 1];
                        object2 = object4[n10 + 2] * object5[n10 + 2];
                        object = object4[n10 + 3] * object5[n10 + 3];
                        d5 += var17_43 + var19_37 + object2 + object;
                    }
                    for (n10 = n9; n10 < n5; ++n10) {
                        d5 += object4[n10] * object5[n10];
                    }
                    dArray[n2][i] = d5;
                }
            }
        }
        if (bl && bl2) {
            n5 = this.rows();
            n4 = this.cols();
            n3 = matrix.rows();
            if (n5 != matrix.cols()) {
                throw new RuntimeException("Error in Routine SMatrix::Mult(). Attempt to calculate the product of two incompatible matrices. Do nothing and return.");
            }
            matrix2 = new Matrix(this.cols(), n3);
            dArray = matrix2.getArray();
            object5 = null;
            int n11 = n5 / 4 * 4;
            object4 = this.getTranspose();
            double[][] dArray5 = ((Matrix)object4).getArray();
            double[] dArray6 = null;
            for (n = 0; n < n3; ++n) {
                object5 = matrix.data[n];
                for (int i = 0; i < n4; ++i) {
                    int n12;
                    dArray6 = dArray5[i];
                    double d6 = 0.0;
                    for (n12 = 0; n12 < n11; n12 += 4) {
                        var19_37 = (reference)(dArray6[n12] * object5[n12]);
                        object2 = dArray6[n12 + 1] * object5[n12 + 1];
                        object = dArray6[n12 + 2] * object5[n12 + 2];
                        d = dArray6[n12 + 3] * object5[n12 + 3];
                        d6 += var19_37 + object2 + object + d;
                    }
                    for (n12 = n11; n12 < n5; ++n12) {
                        d6 += dArray6[n12] * object5[n12];
                    }
                    dArray[i][n] = d6;
                }
            }
        }
        return matrix2;
    }

    public static Matrix getParsed(Vector<String> vector) throws Exception {
        int n;
        Matrix matrix = new Matrix();
        String string = vector.get(0);
        int n2 = 0;
        double[] dArray = String2DoubleArray.convert(string);
        n2 = dArray.length;
        matrix.resize(vector.size(), dArray.length);
        for (n = 0; n < dArray.length; ++n) {
            matrix.set(0, n, dArray[n]);
        }
        for (n = 1; n < vector.size(); ++n) {
            string = vector.get(n);
            dArray = String2DoubleArray.convert(string);
            if (n2 != dArray.length) {
                System.err.println("Vectors for matrix generation differ in length");
                new RuntimeException().printStackTrace();
                break;
            }
            for (int i = 0; i < dArray.length; ++i) {
                matrix.set(n, i, dArray[i]);
            }
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        if (!this.equalDimension(matrix)) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix2.data[i][j] = this.data[i][j] + matrix.data[i][j];
            }
        }
        return matrix2;
    }

    public Matrix pow(double d) {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix.data[i][j] = Math.pow(this.data[i][j], d);
            }
        }
        return matrix;
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public void resize(int n, int n2) {
        double[] dArray;
        int n3;
        double[][] dArrayArray = new double[n][];
        int n4 = Math.min(this.rows(), n);
        int n5 = Math.min(this.cols(), n2);
        for (n3 = 0; n3 < n4; ++n3) {
            dArray = new double[n2];
            System.arraycopy(this.data[n3], 0, dArray, 0, n5);
            dArrayArray[n3] = dArray;
        }
        for (n3 = n4; n3 < n; ++n3) {
            dArray = new double[n2];
            dArrayArray[n3] = dArray;
        }
        this.data = dArrayArray;
    }

    public double[] getRow(int n) {
        return this.data[n];
    }

    public double[] getRowCopy(int n) {
        double[] dArray = new double[this.data[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.data[n][i];
        }
        return dArray;
    }

    public List<Double> getRowAsList(int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.data[0].length; ++i) {
            arrayList.add(new Double(this.data[n][i]));
        }
        return arrayList;
    }

    public float[] getRowAsFloat(int n) {
        float[] fArray = new float[this.data[0].length];
        for (int i = 0; i < this.data[0].length; ++i) {
            fArray[i] = (float)this.data[n][i];
        }
        return fArray;
    }

    public int getRowDim() {
        return this.data.length;
    }

    public int rows() {
        return this.data.length;
    }

    public Matrix getSorted() {
        int n;
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        ArrayList<DoubleVec> arrayList = new ArrayList<DoubleVec>();
        for (n = 0; n < this.data.length; ++n) {
            arrayList.add(new DoubleVec(this.data[n]));
        }
        Collections.sort(arrayList);
        for (n = 0; n < this.data.length; ++n) {
            matrix.assignRow(n, (DoubleVec)arrayList.get(n));
        }
        return matrix;
    }

    public Matrix getSQRT() {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                matrix.data[i][j] = Math.sqrt(this.data[i][j]);
            }
        }
        return matrix;
    }

    public double getSquaredSum() {
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                d += this.data[i][j] * this.data[i][j];
            }
        }
        return d;
    }

    public Matrix getStandardDeviationCols() {
        int n;
        Matrix matrix = this.getMeanCols();
        double[] dArray = matrix.getRow(0);
        int n2 = this.cols();
        int n3 = this.rows();
        double[] dArray2 = new double[n2];
        for (n = 0; n < n3; ++n) {
            double[] dArray3 = this.data[n];
            for (int i = 0; i < n2; ++i) {
                int n4 = i;
                dArray2[n4] = dArray2[n4] + (dArray3[i] - dArray[i]) * (dArray3[i] - dArray[i]);
            }
        }
        for (n = 0; n < n2; ++n) {
            double d;
            dArray2[n] = d = Math.sqrt(dArray2[n] / (double)(n3 - 1));
        }
        return new Matrix(true, dArray2);
    }

    public double getStandardDeviation() {
        double d = 0.0;
        double d2 = this.rows() * this.cols();
        double d3 = this.getMean();
        double d4 = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                d4 += (this.data[i][j] - d3) * (this.data[i][j] - d3);
            }
        }
        d = Math.sqrt(d4 / (d2 - 1.0));
        return d;
    }

    public double getVariance() {
        double d = 0.0;
        double d2 = this.getMean();
        double d3 = 0.0;
        for (int i = 0; i < this.data[0].length; ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                d3 += (this.data[j][i] - d2) * (this.data[j][i] - d2);
            }
        }
        d = d3 / (double)(this.getNumElements() - 1);
        return d;
    }

    public double getCoefficientVariation() {
        double d = this.getMean();
        double d2 = 0.0;
        for (int i = 0; i < this.data[0].length; ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                d2 += (this.data[j][i] - d) * (this.data[j][i] - d);
            }
        }
        double d3 = d2 / (double)(this.getNumElements() - 1);
        double d4 = Math.sqrt(d3);
        double d5 = d4 / d;
        return d5;
    }

    public double getVarianceCol(int n) {
        double d = 0.0;
        double d2 = this.getMeanCol(n);
        double d3 = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            d3 += (this.data[i][n] - d2) * (this.data[i][n] - d2);
        }
        d = d3 / ((double)this.data.length - 1.0);
        return d;
    }

    public double getVarianceCentered() {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.data[0].length; ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                d2 += this.data[j][i] * this.data[j][i];
            }
        }
        d = d2 / (double)(this.getNumElements() - 1);
        return d;
    }

    public Matrix getVarianceCols() {
        Matrix matrix = new Matrix(1, this.getColDim());
        Matrix matrix2 = this.getMeanCols();
        for (int i = 0; i < this.data[0].length; ++i) {
            double d;
            double d2 = 0.0;
            for (int j = 0; j < this.data.length; ++j) {
                d2 += (this.data[j][i] - matrix2.data[0][i]) * (this.data[j][i] - matrix2.data[0][i]);
            }
            matrix.data[0][i] = d = d2 / (double)(this.getRowDim() - 1);
        }
        return matrix;
    }

    public void increase(int n, int n2, double d) {
        double[] dArray = this.data[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    public final void set(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    public void set(Matrix matrix) {
        this.resize(matrix.getRowDim(), matrix.getColDim());
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                this.data[i][j] = matrix.data[i][j];
            }
        }
    }

    public void set(double[][] dArray) {
        this.resize(dArray.length, dArray[0].length);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                this.data[i][j] = dArray[i][j];
            }
        }
    }

    public void setFlat(double[][] dArray) {
        this.data = dArray;
    }

    public void set(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                this.data[i][j] = d;
            }
        }
    }

    public void setID(int n) {
        this.identifier = n;
    }

    public void setCol(int n, double d) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][n] = d;
        }
    }

    public void setCol(int n, double[] dArray) {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i][n] = dArray[i];
        }
    }

    public void setRow(int n, double d) {
        for (int i = 0; i < this.data[0].length; ++i) {
            this.data[n][i] = d;
        }
    }

    public void setRow(int n, double[] dArray) {
        for (int i = 0; i < this.data[0].length; ++i) {
            this.data[n][i] = dArray[i];
        }
    }

    public void setRow(int n, int[] nArray) {
        for (int i = 0; i < this.data[0].length; ++i) {
            this.data[n][i] = nArray[i];
        }
    }

    public static void setSeparatorCol(String string) {
        OUT_SEPARATOR_COL = string;
    }

    public static void setSeparatorRow(String string) {
        OUT_SEPARATOR_ROW = string;
    }

    public void shuffleRows() {
        int n;
        Random random = new Random();
        for (int i = n = this.rows(); i > 1; --i) {
            this.swapRows(i, random.nextInt(i));
        }
    }

    public void swapRows(int n, int n2) {
        double[] dArray = this.data[n];
        this.data[n] = this.data[n2];
        this.data[n2] = dArray;
    }

    public void sortRows(int n) {
        int n2 = this.rows();
        ArrayList<IntegerDouble> arrayList = new ArrayList<IntegerDouble>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(new IntegerDouble(i, this.get(i, n)));
        }
        Collections.sort(arrayList, IntegerDouble.getComparatorDouble());
        double[][] dArrayArray = new double[n2][];
        for (int i = 0; i < n2; ++i) {
            dArrayArray[i] = this.data[((IntegerDouble)arrayList.get(i)).getInt()];
        }
        this.data = dArrayArray;
    }

    public Matrix getStandardized() {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        Matrix matrix2 = this.getStandardDeviationCols();
        Matrix matrix3 = this.getCenteredMatrix();
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                matrix.data[i][j] = matrix3.data[i][j] / matrix2.data[0][j];
            }
        }
        return matrix;
    }

    public Matrix getSubMatrix(int n, int n2, int n3, int n4) {
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        Matrix matrix = new Matrix();
        double[][] dArray = new double[n5][n6];
        for (int i = 0; i < n5; ++i) {
            System.arraycopy(this.data[n + i], n3, dArray[i], 0, n6);
        }
        matrix.data = dArray;
        return matrix;
    }

    public Matrix getSubMatrix(List<Integer> list) {
        int n = this.cols();
        Matrix matrix = new Matrix();
        double[][] dArray = new double[list.size()][n];
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            System.arraycopy(this.data[list.get(i)], 0, dArray[n2], 0, n);
            ++n2;
        }
        matrix.data = dArray;
        return matrix;
    }

    public double getSum() {
        double d = 0.0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                d += this.data[i][j];
            }
        }
        return d;
    }

    public double getSumUpperTriangle() {
        if (this.rows() != this.cols()) {
            throw new RuntimeException("Not a quadratic matrix.");
        }
        int n = this.cols();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (Double.isNaN(this.get(i, j))) continue;
                d += this.get(i, j);
            }
        }
        return d;
    }

    public Matrix getSumCols() {
        Matrix matrix = new Matrix(1, this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                double[] dArray = matrix.data[0];
                int n = j;
                dArray[n] = dArray[n] + this.data[i][j];
            }
        }
        return matrix;
    }

    public Matrix getSumRows() {
        Matrix matrix = new Matrix(1, this.getRowDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            matrix.set(0, i, this.getSumRow(i));
        }
        return matrix;
    }

    public double getSumCol(int n) {
        double d = 0.0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            d += this.data[i][n];
        }
        return d;
    }

    public double getSumRow(int n) {
        double d = 0.0;
        for (int i = 0; i < this.getColDim(); ++i) {
            d += this.data[n][i];
        }
        return d;
    }

    public double getSumSquared() {
        double d = 0.0;
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                d += this.data[i][j] * this.data[i][j];
            }
        }
        return d;
    }

    public double[] getNext4NeighboursTorus(int n, int n2) {
        double[] dArray = new double[]{this.getTorus(n - 1, n2), this.getTorus(n, n2 - 1), this.getTorus(n, n2 + 1), this.getTorus(n + 1, n2)};
        return dArray;
    }

    public double[] getNext8NeighboursTorus(int n, int n2) {
        double[] dArray = new double[8];
        int n3 = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                dArray[n3] = this.getTorus(n + i, n2 + j);
                ++n3;
            }
        }
        return dArray;
    }

    public Matrix row2Matrix(int n, int n2) {
        Matrix matrix = new Matrix(this.getColDim() / n2, n2);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.getColDim(); ++i) {
            if (i % n2 == 0 && i > 0) {
                ++n3;
                n4 = 0;
            }
            matrix.set(n3, n4, this.get(0, i));
            ++n4;
        }
        return matrix;
    }

    public double getTorus(int n, int n2) {
        int n3;
        int n4 = n2;
        for (n3 = n; n3 < 0; n3 += this.getRowDim()) {
        }
        while (n3 >= this.getRowDim()) {
            n3 -= this.getRowDim();
        }
        while (n4 < 0) {
            n4 += this.getColDim();
        }
        while (n4 >= this.getColDim()) {
            n4 -= this.getColDim();
        }
        return this.get(n3, n4);
    }

    public double getTrace() {
        double d = 0.0;
        int n = this.getRowDim();
        int n2 = this.getColDim();
        for (int i = 0; i < Math.min(n, n2); ++i) {
            d += this.get(i, i);
        }
        return d;
    }

    public Matrix getTranspose() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        Matrix matrix = new Matrix(n2, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.data[j][i] = this.data[i][j];
            }
        }
        return matrix;
    }

    public Matrix getFlipped() {
        int n = this.getRowDim();
        int n2 = this.getColDim();
        Matrix matrix = new Matrix(n2, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.data[n2 - j - 1][i] = this.data[i][j];
            }
        }
        return matrix;
    }

    public Matrix toRow() {
        Matrix matrix = new Matrix(1, this.getRowDim() * this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix.set(0, i * this.getColDim() + j, this.get(i, j));
            }
        }
        return matrix;
    }

    public double[] toArray() {
        int n = this.rows();
        int n2 = this.cols();
        double[] dArray = new double[n * n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i * n2 + j] = this.get(i, j);
            }
        }
        return dArray;
    }

    public String toString() {
        int n = 20;
        int n2 = this.getRowDim() * this.getColDim() * n;
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length - 1; ++j) {
                stringBuilder.append(this.data[i][j] + OUT_SEPARATOR_COL);
            }
            stringBuilder.append(this.data[i][this.data[0].length - 1]);
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(OUT_SEPARATOR_ROW);
        }
        return stringBuilder.toString();
    }

    public String toStringBinary() {
        int n = this.getRowDim() * this.getColDim();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[0].length; ++j) {
                if (this.data[i][j] == 0.0) {
                    stringBuilder.append(0);
                    continue;
                }
                stringBuilder.append(1);
            }
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(OUT_SEPARATOR_ROW);
        }
        return stringBuilder.toString();
    }

    public String toString(int n) {
        return this.toString(this.rows(), this.cols(), n);
    }

    public String toString(int n, int n2, int n3) {
        int n4 = 20;
        String string = "";
        string = string + "0";
        int n5 = 0;
        if (n3 > 0) {
            string = string + ".";
        }
        while (n5 < n3) {
            string = string + "0";
            ++n5;
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        int n6 = this.getRowDim() * this.getColDim() * n4;
        StringBuilder stringBuilder = new StringBuilder(n6);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                String string2 = decimalFormat.format(this.data[i][j]);
                if (this.data[i][j] == Double.MAX_VALUE) {
                    string2 = "Max";
                }
                stringBuilder.append(string2);
                if (j >= this.data[0].length - 1) continue;
                stringBuilder.append(OUT_SEPARATOR_COL);
            }
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(OUT_SEPARATOR_ROW);
        }
        return stringBuilder.toString();
    }

    public String toStringRow(int n, int n2) {
        int n3 = 20;
        String string = "";
        string = string + "0";
        int n4 = 0;
        if (n2 > 0) {
            string = string + ".";
        }
        while (n4 < n2) {
            string = string + "0";
            ++n4;
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        int n5 = this.getRowDim() * this.getColDim() * n3;
        StringBuilder stringBuilder = new StringBuilder(n5);
        for (int i = 0; i < this.data[0].length; ++i) {
            String string2 = decimalFormat.format(this.data[n][i]);
            if (this.data[n][i] == Double.MAX_VALUE) {
                string2 = "Max";
            }
            stringBuilder.append(string2);
            if (i >= this.data[0].length - 1) continue;
            stringBuilder.append(OUT_SEPARATOR_COL);
        }
        return stringBuilder.toString();
    }

    public String toStringRowNumber(int n, String string) {
        int n2;
        int n3 = 20;
        String string2 = "##,";
        for (n2 = 0; n2 < n; ++n2) {
            string2 = string2 + "#";
        }
        string2 = string2 + "0.";
        for (n2 = 0; n2 < n; ++n2) {
            string2 = string2 + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string2);
        int n4 = this.getRowDim() * this.getColDim() * n3;
        StringBuilder stringBuilder = new StringBuilder(n4);
        for (int i = 0; i < this.data.length; ++i) {
            stringBuilder.append(i + string);
            for (int j = 0; j < this.data[0].length - 1; ++j) {
                stringBuilder.append(decimalFormat.format(this.data[i][j]) + string);
            }
            stringBuilder.append(decimalFormat.format(this.data[i][this.data[0].length - 1]));
            if (i >= this.data.length - 1) continue;
            stringBuilder.append(OUT_SEPARATOR_ROW);
        }
        return stringBuilder.toString();
    }

    public Matrix subtract(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        if (!this.equalDimension(matrix)) {
            throw new RuntimeException("Matrices have wrong dimensions.");
        }
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix2.data[i][j] = this.data[i][j] - matrix.data[i][j];
            }
        }
        return matrix2;
    }

    public Matrix subtract(double d) {
        Matrix matrix = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix.data[i][j] = this.data[i][j] - d;
            }
        }
        return matrix;
    }

    public Matrix subtractFromCols(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRowDim(), this.getColDim());
        for (int i = 0; i < this.getRowDim(); ++i) {
            for (int j = 0; j < this.getColDim(); ++j) {
                matrix2.data[i][j] = this.data[i][j] - matrix.get(0, j);
            }
        }
        return matrix2;
    }

    public static double Sign(double d, double d2) {
        if (d2 >= 0.0) {
            return Math.abs(d);
        }
        return -Math.abs(d);
    }

    public static Matrix getRND(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.set(i, j, Math.random());
            }
        }
        return matrix;
    }

    public void write(String string, boolean bl) {
        DecimalFormat decimalFormat = new DecimalFormat(FORMAT);
        this.write(new File(string), decimalFormat, bl);
    }

    public void write(String string) {
        DecimalFormat decimalFormat = new DecimalFormat(FORMAT);
        this.write(new File(string), decimalFormat, false);
    }

    public void write(File file) {
        DecimalFormat decimalFormat = new DecimalFormat(FORMAT);
        this.write(file, decimalFormat, false);
    }

    public void write(File file, boolean bl, int n) throws IOException {
        int n2;
        String string = "##,";
        for (n2 = 0; n2 < n; ++n2) {
            string = string + "#";
        }
        string = string + "0.";
        for (n2 = 0; n2 < n; ++n2) {
            string = string + "0";
        }
        DecimalFormat decimalFormat = new DecimalFormat(string);
        this.write(file, decimalFormat, bl);
    }

    public void write(String string, boolean bl, int n) throws IOException {
        this.write(new File(string), bl, n);
    }

    public void write(File file, DecimalFormat decimalFormat, boolean bl) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
            this.write(fileOutputStream, decimalFormat);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(OutputStream outputStream) {
        DecimalFormat decimalFormat = new DecimalFormat("#.###############");
        this.write(outputStream, decimalFormat);
    }

    public String writeAsLineBase64Encoded() {
        DecimalFormat decimalFormat = new DecimalFormat("#.###############");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream, decimalFormat);
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] byArray = encoder.encode(byteArrayOutputStream.toByteArray());
        return new String(byArray);
    }

    public void write(OutputStream outputStream, NumberFormat numberFormat) {
        try {
            for (int i = 0; i < this.data.length; ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < this.data[0].length; ++j) {
                    stringBuilder.append(numberFormat.format(this.data[i][j]));
                    if (j >= this.data[0].length - 1) continue;
                    stringBuilder.append(OUT_SEPARATOR_COL);
                }
                outputStream.write(stringBuilder.toString().getBytes());
                if (i >= this.data.length - 1) continue;
                outputStream.write(OUT_SEPARATOR_ROW.getBytes());
            }
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String toStringWithColTags(List<String> list, DecimalFormat decimalFormat, String string) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.cols() != list.size()) {
            throw new RuntimeException("Number of cols and col tags differ.");
        }
        int[] nArray = new int[this.cols()];
        for (n4 = 0; n4 < nArray.length; ++n4) {
            nArray[n4] = list.get(n4).length();
        }
        for (n4 = 0; n4 < nArray.length; ++n4) {
            for (n3 = 0; n3 < this.rows(); ++n3) {
                nArray[n4] = Math.max(nArray[n4], decimalFormat.format(this.get(n3, n4)).length());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            StringBuilder stringBuilder2 = new StringBuilder(list.get(n3));
            int n5 = n2 - stringBuilder2.length();
            for (n = 0; n < n5; ++n) {
                stringBuilder2.append(" ");
            }
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        for (n3 = 0; n3 < this.rows(); ++n3) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n6 = nArray[n2];
                StringBuilder stringBuilder3 = new StringBuilder(decimalFormat.format(this.get(n3, n2)));
                n = n6 - stringBuilder3.length();
                for (int i = 0; i < n; ++i) {
                    stringBuilder3.append(" ");
                }
                stringBuilder.append(stringBuilder3.toString());
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toStringWithRowTags(List<String> list, DecimalFormat decimalFormat, String string) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.rows() != list.size()) {
            throw new RuntimeException("Number of rows and row tags differ.");
        }
        int[] nArray = new int[this.cols() + 1];
        for (n4 = 0; n4 < list.size(); ++n4) {
            nArray[0] = Math.max(nArray[0], list.get(n4).length());
        }
        for (n4 = 0; n4 < this.cols(); ++n4) {
            for (n3 = 0; n3 < this.rows(); ++n3) {
                nArray[n4 + 1] = Math.max(nArray[n4 + 1], decimalFormat.format(this.get(n3, n4)).length());
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            StringBuilder stringBuilder2 = new StringBuilder(list.get(n3));
            int n5 = n2 - stringBuilder2.length();
            for (n = 0; n < n5; ++n) {
                stringBuilder2.append(" ");
            }
            stringBuilder.append(stringBuilder2.toString());
            stringBuilder.append(" ");
        }
        stringBuilder.append("\n");
        for (n3 = 0; n3 < this.rows(); ++n3) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n6 = nArray[n2];
                StringBuilder stringBuilder3 = new StringBuilder(decimalFormat.format(this.get(n3, n2)));
                n = n6 - stringBuilder3.length();
                for (int i = 0; i < n; ++i) {
                    stringBuilder3.append(" ");
                }
                stringBuilder.append(stringBuilder3.toString());
                stringBuilder.append(" ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void writeSerialized(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(this.data);
        objectOutputStream.close();
    }

    public static Matrix readSerialized(File file) throws FileNotFoundException, IOException, ClassNotFoundException {
        Matrix matrix = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        double[][] dArray = (double[][])objectInputStream.readObject();
        matrix = new Matrix(dArray);
        objectInputStream.close();
        return matrix;
    }

    public static DecimalFormat format(int n) {
        String string = "##,###";
        if (n > 0) {
            string = string + ".";
            for (int i = 0; i < n; ++i) {
                string = string + "0";
            }
        }
        return new DecimalFormat(string, new DecimalFormatSymbols(Locale.US));
    }

    public void write(String string, boolean bl, int n, int n2) {
        try {
            DecimalFormat decimalFormat = Matrix.format(n);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(string), bl));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < this.data.length; ++i) {
                stringBuffer = new StringBuffer();
                for (int j = 0; j < this.data[0].length; ++j) {
                    stringBuffer.append(Matrix.format(this.data[i][j], decimalFormat, n2) + OUT_SEPARATOR_COL);
                }
                bufferedWriter.write(stringBuffer.toString());
                if (i >= this.data.length - 1) continue;
                bufferedWriter.write(OUT_SEPARATOR_ROW);
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static String format(double d, DecimalFormat decimalFormat, int n) {
        String string = "";
        string = decimalFormat.format(d);
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }
}

