/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import smile.util.SimpleDeamonThreadFactory;

public class MulticoreExecutor {
    private static int nprocs = -1;
    private static ThreadPoolExecutor threads = null;

    private MulticoreExecutor() {
    }

    private static void createThreadPool() {
        if (nprocs == -1) {
            int n = -1;
            try {
                String string = System.getProperty("smile.threads");
                if (string != null) {
                    n = Integer.parseInt(string);
                }
            }
            catch (Exception exception) {
                System.err.println("Failed to create multi-core execution thread pool:" + exception);
            }
            nprocs = n < 1 ? Runtime.getRuntime().availableProcessors() : n;
            if (nprocs > 1) {
                threads = (ThreadPoolExecutor)Executors.newFixedThreadPool(nprocs, new SimpleDeamonThreadFactory());
            }
        }
    }

    public static int getThreadPoolSize() {
        MulticoreExecutor.createThreadPool();
        return nprocs;
    }

    public static <T> List<T> run(Collection<? extends Callable<T>> collection) throws Exception {
        MulticoreExecutor.createThreadPool();
        ArrayList<T> arrayList = new ArrayList<T>();
        if (threads == null) {
            for (Callable<T> callable : collection) {
                arrayList.add(callable.call());
            }
        } else if (threads.getActiveCount() < nprocs) {
            List list = threads.invokeAll(collection);
            for (Future future : list) {
                arrayList.add(future.get());
            }
        } else {
            for (Callable<T> callable : collection) {
                arrayList.add(callable.call());
            }
        }
        return arrayList;
    }

    public static void shutdown() {
        if (threads != null) {
            threads.shutdown();
        }
    }
}

