/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import java.util.Arrays;
import smile.math.Complex;
import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.matrix.QR;
import smile.math.matrix.SVD;

public class JMatrix
implements DenseMatrix {
    private static final long serialVersionUID = 1L;
    private double[] A;
    private int nrows;
    private int ncols;
    private boolean symmetric = false;

    public JMatrix(double[][] dArray) {
        this.nrows = dArray.length;
        this.ncols = dArray[0].length;
        this.A = new double[this.nrows * this.ncols];
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                this.set(i, j, dArray[i][j]);
            }
        }
    }

    public JMatrix(double[] dArray) {
        this.nrows = dArray.length;
        this.ncols = 1;
        this.A = dArray;
    }

    public JMatrix(int n, int n2) {
        this.nrows = n;
        this.ncols = n2;
        this.A = new double[n * n2];
    }

    public JMatrix(int n, int n2, double d) {
        this(n, n2);
        Arrays.fill(this.A, d);
    }

    public JMatrix(int n, int n2, double[] dArray) {
        this.nrows = n;
        this.ncols = n2;
        this.A = dArray;
    }

    @Override
    public boolean isSymmetric() {
        return this.symmetric;
    }

    @Override
    public void setSymmetric(boolean bl) {
        this.symmetric = bl;
    }

    @Override
    public JMatrix copy() {
        JMatrix jMatrix = new JMatrix(this.nrows, this.ncols, (double[])this.A.clone());
        jMatrix.setSymmetric(this.isSymmetric());
        return jMatrix;
    }

    @Override
    public double[] data() {
        return this.A;
    }

    @Override
    public JMatrix transpose() {
        JMatrix jMatrix = new JMatrix(this.ncols(), this.nrows());
        for (int i = 0; i < this.nrows(); ++i) {
            for (int j = 0; j < this.ncols(); ++j) {
                jMatrix.set(j, i, this.get(i, j));
            }
        }
        return jMatrix;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public int nrows() {
        return this.nrows;
    }

    @Override
    public int ncols() {
        return this.ncols;
    }

    @Override
    public int ld() {
        return this.nrows;
    }

    @Override
    public double get(int n, int n2) {
        return this.A[n2 * this.nrows + n];
    }

    @Override
    public double set(int n, int n2, double d) {
        double d2 = d;
        this.A[n2 * this.nrows + n] = d2;
        return d2;
    }

    @Override
    public double add(int n, int n2, double d) {
        int n3 = n2 * this.nrows + n;
        double d2 = this.A[n3] + d;
        this.A[n3] = d2;
        return d2;
    }

    @Override
    public double sub(int n, int n2, double d) {
        int n3 = n2 * this.nrows + n;
        double d2 = this.A[n3] - d;
        this.A[n3] = d2;
        return d2;
    }

    @Override
    public double mul(int n, int n2, double d) {
        int n3 = n2 * this.nrows + n;
        double d2 = this.A[n3] * d;
        this.A[n3] = d2;
        return d2;
    }

    @Override
    public double div(int n, int n2, double d) {
        int n3 = n2 * this.nrows + n;
        double d2 = this.A[n3] / d;
        this.A[n3] = d2;
        return d2;
    }

    @Override
    public JMatrix add(DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.add((JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.add(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    public JMatrix add(JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] + jMatrix.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix add(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (denseMatrix instanceof JMatrix && denseMatrix2 instanceof JMatrix) {
            return this.add((JMatrix)denseMatrix, (JMatrix)denseMatrix2);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) + denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    public JMatrix add(JMatrix jMatrix, JMatrix jMatrix2) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != jMatrix2.nrows() || this.ncols() != jMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix2.A[i] = this.A[i] + jMatrix.A[i];
        }
        return jMatrix2;
    }

    @Override
    public JMatrix sub(DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.sub((JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.sub(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    public JMatrix sub(JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] - jMatrix.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix sub(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (denseMatrix instanceof JMatrix && denseMatrix2 instanceof JMatrix) {
            return this.sub((JMatrix)denseMatrix, (JMatrix)denseMatrix2);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) - denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    public JMatrix sub(JMatrix jMatrix, JMatrix jMatrix2) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != jMatrix2.nrows() || this.ncols() != jMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix2.A[i] = this.A[i] - jMatrix.A[i];
        }
        return jMatrix2;
    }

    @Override
    public JMatrix mul(DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.mul((JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mul(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    public JMatrix mul(JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] * jMatrix.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix mul(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (denseMatrix instanceof JMatrix && denseMatrix2 instanceof JMatrix) {
            return this.mul((JMatrix)denseMatrix, (JMatrix)denseMatrix2);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) * denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    public JMatrix mul(JMatrix jMatrix, JMatrix jMatrix2) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != jMatrix2.nrows() || this.ncols() != jMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix2.A[i] = this.A[i] * jMatrix.A[i];
        }
        return jMatrix2;
    }

    @Override
    public JMatrix div(DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.div((JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.div(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    public JMatrix div(JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            int n = i;
            this.A[n] = this.A[n] / jMatrix.A[i];
        }
        return this;
    }

    @Override
    public DenseMatrix div(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (denseMatrix instanceof JMatrix && denseMatrix2 instanceof JMatrix) {
            return this.div((JMatrix)denseMatrix, (JMatrix)denseMatrix2);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) / denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    public JMatrix div(JMatrix jMatrix, JMatrix jMatrix2) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != jMatrix2.nrows() || this.ncols() != jMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix2.A[i] = this.A[i] / jMatrix.A[i];
        }
        return jMatrix2;
    }

    @Override
    public JMatrix add(double d) {
        int n = 0;
        while (n < this.A.length) {
            int n2 = n++;
            this.A[n2] = this.A[n2] + d;
        }
        return this;
    }

    @Override
    public DenseMatrix add(double d, DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.add(d, (JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                denseMatrix.set(j, i, this.get(j, i) + d);
            }
        }
        return denseMatrix;
    }

    public JMatrix add(double d, JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix.A[i] = this.A[i] + d;
        }
        return jMatrix;
    }

    @Override
    public JMatrix sub(double d) {
        int n = 0;
        while (n < this.A.length) {
            int n2 = n++;
            this.A[n2] = this.A[n2] - d;
        }
        return this;
    }

    @Override
    public DenseMatrix sub(double d, DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.sub(d, (JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                denseMatrix.set(j, i, this.get(j, i) - d);
            }
        }
        return denseMatrix;
    }

    public JMatrix sub(double d, JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix.A[i] = this.A[i] - d;
        }
        return jMatrix;
    }

    @Override
    public JMatrix mul(double d) {
        int n = 0;
        while (n < this.A.length) {
            int n2 = n++;
            this.A[n2] = this.A[n2] * d;
        }
        return this;
    }

    @Override
    public DenseMatrix mul(double d, DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.mul(d, (JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                denseMatrix.set(j, i, this.get(j, i) * d);
            }
        }
        return denseMatrix;
    }

    public JMatrix mul(double d, JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix.A[i] = this.A[i] * d;
        }
        return jMatrix;
    }

    @Override
    public JMatrix div(double d) {
        int n = 0;
        while (n < this.A.length) {
            int n2 = n++;
            this.A[n2] = this.A[n2] / d;
        }
        return this;
    }

    @Override
    public DenseMatrix div(double d, DenseMatrix denseMatrix) {
        if (denseMatrix instanceof JMatrix) {
            return this.div(d, (JMatrix)denseMatrix);
        }
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                denseMatrix.set(j, i, this.get(j, i) / d);
            }
        }
        return denseMatrix;
    }

    public JMatrix div(double d, JMatrix jMatrix) {
        if (this.nrows() != jMatrix.nrows() || this.ncols() != jMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        for (int i = 0; i < this.A.length; ++i) {
            jMatrix.A[i] = this.A[i] / d;
        }
        return jMatrix;
    }

    @Override
    public JMatrix replaceNaN(double d) {
        for (int i = 0; i < this.A.length; ++i) {
            if (!Double.isNaN(this.A[i])) continue;
            this.A[i] = d;
        }
        return this;
    }

    @Override
    public double sum() {
        double d = 0.0;
        for (int i = 0; i < this.A.length; ++i) {
            d += this.A[i];
        }
        return d;
    }

    @Override
    public JMatrix ata() {
        JMatrix jMatrix = new JMatrix(this.ncols, this.ncols);
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.ncols; ++j) {
                double d = 0.0;
                for (int k = 0; k < this.nrows; ++k) {
                    d += this.get(k, i) * this.get(k, j);
                }
                jMatrix.set(i, j, d);
            }
        }
        return jMatrix;
    }

    @Override
    public JMatrix aat() {
        JMatrix jMatrix = new JMatrix(this.nrows, this.nrows);
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                for (int k = 0; k < this.nrows; ++k) {
                    jMatrix.add(j, k, this.get(j, i) * this.get(k, i));
                }
            }
        }
        return jMatrix;
    }

    @Override
    public double[] ax(double[] dArray, double[] dArray2) {
        int n = Math.min(this.nrows, dArray2.length);
        int n2 = Math.min(this.ncols, dArray.length);
        Arrays.fill(dArray2, 0.0);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = j;
                dArray2[n3] = dArray2[n3] + this.get(j, i) * dArray[i];
            }
        }
        return dArray2;
    }

    @Override
    public double[] axpy(double[] dArray, double[] dArray2) {
        int n = Math.min(this.nrows, dArray2.length);
        int n2 = Math.min(this.ncols, dArray.length);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = j;
                dArray2[n3] = dArray2[n3] + this.get(j, i) * dArray[i];
            }
        }
        return dArray2;
    }

    @Override
    public double[] axpy(double[] dArray, double[] dArray2, double d) {
        int n = Math.min(this.nrows, dArray2.length);
        int n2 = Math.min(this.ncols, dArray.length);
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3++;
            dArray2[n4] = dArray2[n4] * d;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            for (int i = 0; i < n; ++i) {
                int n5 = i;
                dArray2[n5] = dArray2[n5] + this.get(i, n3) * dArray[n3];
            }
        }
        return dArray2;
    }

    @Override
    public double[] atx(double[] dArray, double[] dArray2) {
        int n = Math.min(this.ncols, dArray2.length);
        int n2 = Math.min(this.nrows, dArray.length);
        Arrays.fill(dArray2, 0.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                dArray2[n3] = dArray2[n3] + this.get(j, i) * dArray[j];
            }
        }
        return dArray2;
    }

    @Override
    public double[] atxpy(double[] dArray, double[] dArray2) {
        int n = Math.min(this.ncols, dArray2.length);
        int n2 = Math.min(this.nrows, dArray.length);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                dArray2[n3] = dArray2[n3] + this.get(j, i) * dArray[j];
            }
        }
        return dArray2;
    }

    @Override
    public double[] atxpy(double[] dArray, double[] dArray2, double d) {
        int n = Math.min(this.ncols, dArray2.length);
        int n2 = Math.min(this.nrows, dArray.length);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            dArray2[n3] = dArray2[n3] * d;
            for (int j = 0; j < n2; ++j) {
                int n4 = i;
                dArray2[n4] = dArray2[n4] + this.get(j, i) * dArray[j];
            }
        }
        return dArray2;
    }

    @Override
    public JMatrix abmm(DenseMatrix denseMatrix) {
        if (this.ncols() != denseMatrix.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), denseMatrix.nrows(), denseMatrix.ncols()));
        }
        JMatrix jMatrix = new JMatrix(this.nrows, denseMatrix.ncols());
        for (int i = 0; i < this.nrows; ++i) {
            for (int j = 0; j < denseMatrix.ncols(); ++j) {
                double d = 0.0;
                for (int k = 0; k < this.ncols; ++k) {
                    d += this.get(i, k) * denseMatrix.get(k, j);
                }
                jMatrix.set(i, j, d);
            }
        }
        return jMatrix;
    }

    @Override
    public JMatrix abtmm(DenseMatrix denseMatrix) {
        if (this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A * B': %d x %d vs %d x %d", this.nrows(), this.ncols(), denseMatrix.nrows(), denseMatrix.ncols()));
        }
        JMatrix jMatrix = new JMatrix(this.nrows, denseMatrix.nrows());
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < this.nrows; ++j) {
                for (int k = 0; k < denseMatrix.nrows(); ++k) {
                    jMatrix.add(j, k, this.get(j, i) * denseMatrix.get(k, i));
                }
            }
        }
        return jMatrix;
    }

    @Override
    public JMatrix atbmm(DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows()) {
            throw new IllegalArgumentException(String.format("Matrix multiplication A' * B: %d x %d vs %d x %d", this.nrows(), this.ncols(), denseMatrix.nrows(), denseMatrix.ncols()));
        }
        JMatrix jMatrix = new JMatrix(this.ncols, denseMatrix.ncols());
        for (int i = 0; i < this.ncols; ++i) {
            for (int j = 0; j < denseMatrix.ncols(); ++j) {
                double d = 0.0;
                for (int k = 0; k < this.nrows; ++k) {
                    d += this.get(k, i) * denseMatrix.get(k, j);
                }
                jMatrix.set(i, j, d);
            }
        }
        return jMatrix;
    }

    @Override
    public LU lu() {
        int n;
        int n2;
        int n3;
        int n4 = this.nrows();
        int n5 = this.ncols();
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = n3;
        }
        n3 = 1;
        double[] dArray = new double[n4];
        for (n2 = 0; n2 < n5; ++n2) {
            double d;
            int n6;
            for (n = 0; n < n4; ++n) {
                dArray[n] = this.get(n, n2);
            }
            for (n = 0; n < n4; ++n) {
                n6 = Math.min(n, n2);
                d = 0.0;
                for (int i = 0; i < n6; ++i) {
                    d += this.get(n, i) * dArray[i];
                }
                int n7 = n;
                dArray[n7] = dArray[n7] - d;
                this.set(n, n2, dArray[n]);
            }
            n = n2;
            for (n6 = n2 + 1; n6 < n4; ++n6) {
                if (!(Math.abs(dArray[n6]) > Math.abs(dArray[n]))) continue;
                n = n6;
            }
            if (n != n2) {
                for (n6 = 0; n6 < n5; ++n6) {
                    d = this.get(n, n6);
                    this.set(n, n6, this.get(n2, n6));
                    this.set(n2, n6, d);
                }
                n6 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n6;
                n3 = -n3;
            }
            if (!(n2 < n4 & this.get(n2, n2) != 0.0)) continue;
            for (n6 = n2 + 1; n6 < n4; ++n6) {
                this.div(n6, n2, this.get(n2, n2));
            }
        }
        n2 = 0;
        for (n = 0; n < n5; ++n) {
            if (this.get(n, n) != 0.0) continue;
            n2 = 1;
            break;
        }
        return new LU(this, nArray, n3, n2 != 0);
    }

    @Override
    public Cholesky cholesky() {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Cholesky decomposition on non-square matrix");
        }
        int n = this.nrows();
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (int j = 0; j < i; ++j) {
                double d2 = 0.0;
                for (int k = 0; k < j; ++k) {
                    d2 += this.get(j, k) * this.get(i, k);
                }
                d2 = (this.get(i, j) - d2) / this.get(j, j);
                this.set(i, j, d2);
                d += d2 * d2;
            }
            d = this.get(i, i) - d;
            if (d < 0.0) {
                throw new IllegalArgumentException("The matrix is not positive definite.");
            }
            this.set(i, i, Math.sqrt(d));
        }
        return new Cholesky(this);
    }

    @Override
    public QR qr() {
        int n;
        int n2 = this.nrows();
        int n3 = this.ncols();
        double[] dArray = new double[n3];
        for (n = 0; n < n3; ++n) {
            int n4;
            double d = 0.0;
            for (n4 = n; n4 < n2; ++n4) {
                d = Math.hypot(d, this.get(n4, n));
            }
            if (d != 0.0) {
                if (this.get(n, n) < 0.0) {
                    d = -d;
                }
                for (n4 = n; n4 < n2; ++n4) {
                    this.div(n4, n, d);
                }
                this.add(n, n, 1.0);
                for (n4 = n + 1; n4 < n3; ++n4) {
                    int n5;
                    double d2 = 0.0;
                    for (n5 = n; n5 < n2; ++n5) {
                        d2 += this.get(n5, n) * this.get(n5, n4);
                    }
                    d2 = -d2 / this.get(n, n);
                    for (n5 = n; n5 < n2; ++n5) {
                        this.add(n5, n4, d2 * this.get(n5, n));
                    }
                }
            }
            dArray[n] = -d;
        }
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            if (dArray[i] != 0.0) continue;
            n = 1;
            break;
        }
        return new QR(this, dArray, n != 0);
    }

    @Override
    public SVD svd() {
        int n;
        double d;
        double d2;
        int n2;
        double d3;
        int n3;
        int n4 = this.nrows();
        int n5 = this.ncols();
        int n6 = 0;
        int n7 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        JMatrix jMatrix = this;
        DenseMatrix denseMatrix = Matrix.zeros(n5, n5);
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            n6 = n3 + 2;
            dArray2[n3] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n3 < n4) {
                for (n2 = n3; n2 < n4; ++n2) {
                    d5 += Math.abs(jMatrix.get(n2, n3));
                }
                if (d5 != 0.0) {
                    for (n2 = n3; n2 < n4; ++n2) {
                        jMatrix.div(n2, n3, d5);
                        d3 += jMatrix.get(n2, n3) * jMatrix.get(n2, n3);
                    }
                    d2 = jMatrix.get(n3, n3);
                    d6 = -Math.copySign(Math.sqrt(d3), d2);
                    d = d2 * d6 - d3;
                    jMatrix.set(n3, n3, d2 - d6);
                    for (n = n6 - 1; n < n5; ++n) {
                        d3 = 0.0;
                        for (n2 = n3; n2 < n4; ++n2) {
                            d3 += jMatrix.get(n2, n3) * jMatrix.get(n2, n);
                        }
                        d2 = d3 / d;
                        for (n2 = n3; n2 < n4; ++n2) {
                            jMatrix.add(n2, n, d2 * jMatrix.get(n2, n3));
                        }
                    }
                    for (n2 = n3; n2 < n4; ++n2) {
                        jMatrix.mul(n2, n3, d5);
                    }
                }
            }
            dArray[n3] = d5 * d6;
            d5 = 0.0;
            d3 = 0.0;
            d6 = 0.0;
            if (n3 + 1 <= n4 && n3 + 1 != n5) {
                for (n2 = n6 - 1; n2 < n5; ++n2) {
                    d5 += Math.abs(jMatrix.get(n3, n2));
                }
                if (d5 != 0.0) {
                    for (n2 = n6 - 1; n2 < n5; ++n2) {
                        jMatrix.div(n3, n2, d5);
                        d3 += jMatrix.get(n3, n2) * jMatrix.get(n3, n2);
                    }
                    d2 = jMatrix.get(n3, n6 - 1);
                    d6 = -Math.copySign(Math.sqrt(d3), d2);
                    d = d2 * d6 - d3;
                    jMatrix.set(n3, n6 - 1, d2 - d6);
                    for (n2 = n6 - 1; n2 < n5; ++n2) {
                        dArray2[n2] = jMatrix.get(n3, n2) / d;
                    }
                    for (n = n6 - 1; n < n4; ++n) {
                        d3 = 0.0;
                        for (n2 = n6 - 1; n2 < n5; ++n2) {
                            d3 += jMatrix.get(n, n2) * jMatrix.get(n3, n2);
                        }
                        for (n2 = n6 - 1; n2 < n5; ++n2) {
                            jMatrix.add(n, n2, d3 * dArray2[n2]);
                        }
                    }
                    for (n2 = n6 - 1; n2 < n5; ++n2) {
                        jMatrix.mul(n3, n2, d5);
                    }
                }
            }
            d4 = Math.max(d4, Math.abs(dArray[n3]) + Math.abs(dArray2[n3]));
        }
        n3 = n5 - 1;
        while (n3 >= 0) {
            if (n3 < n5 - 1) {
                if (d6 != 0.0) {
                    for (n = n6; n < n5; ++n) {
                        denseMatrix.set(n, n3, jMatrix.get(n3, n) / jMatrix.get(n3, n6) / d6);
                    }
                    for (n = n6; n < n5; ++n) {
                        d3 = 0.0;
                        for (n2 = n6; n2 < n5; ++n2) {
                            d3 += jMatrix.get(n3, n2) * denseMatrix.get(n2, n);
                        }
                        for (n2 = n6; n2 < n5; ++n2) {
                            denseMatrix.add(n2, n, d3 * denseMatrix.get(n2, n3));
                        }
                    }
                }
                for (n = n6; n < n5; ++n) {
                    denseMatrix.set(n3, n, 0.0);
                    denseMatrix.set(n, n3, 0.0);
                }
            }
            denseMatrix.set(n3, n3, 1.0);
            d6 = dArray2[n3];
            n6 = n3--;
        }
        for (n3 = Math.min(n4, n5) - 1; n3 >= 0; --n3) {
            n6 = n3 + 1;
            d6 = dArray[n3];
            for (n = n6; n < n5; ++n) {
                jMatrix.set(n3, n, 0.0);
            }
            if (d6 != 0.0) {
                d6 = 1.0 / d6;
                for (n = n6; n < n5; ++n) {
                    d3 = 0.0;
                    for (n2 = n6; n2 < n4; ++n2) {
                        d3 += jMatrix.get(n2, n3) * jMatrix.get(n2, n);
                    }
                    d2 = d3 / jMatrix.get(n3, n3) * d6;
                    for (n2 = n3; n2 < n4; ++n2) {
                        jMatrix.add(n2, n, d2 * jMatrix.get(n2, n3));
                    }
                }
                for (n = n3; n < n4; ++n) {
                    jMatrix.mul(n, n3, d6);
                }
            } else {
                for (n = n3; n < n4; ++n) {
                    jMatrix.set(n, n3, 0.0);
                }
            }
            jMatrix.add(n3, n3, 1.0);
        }
        block27: for (n2 = n5 - 1; n2 >= 0; --n2) {
            for (int i = 0; i < 30; ++i) {
                double d7;
                double d8;
                double d9;
                boolean bl = true;
                for (n6 = n2; n6 >= 0; --n6) {
                    n7 = n6 - 1;
                    if (n6 == 0 || Math.abs(dArray2[n6]) <= Math.EPSILON * d4) {
                        bl = false;
                        break;
                    }
                    if (Math.abs(dArray[n7]) <= Math.EPSILON * d4) break;
                }
                if (bl) {
                    d9 = 0.0;
                    d3 = 1.0;
                    for (n3 = n6; n3 < n2 + 1; ++n3) {
                        d2 = d3 * dArray2[n3];
                        dArray2[n3] = d9 * dArray2[n3];
                        if (Math.abs(d2) <= Math.EPSILON * d4) break;
                        d6 = dArray[n3];
                        dArray[n3] = d = Math.hypot(d2, d6);
                        d = 1.0 / d;
                        d9 = d6 * d;
                        d3 = -d2 * d;
                        for (n = 0; n < n4; ++n) {
                            d8 = jMatrix.get(n, n7);
                            d7 = jMatrix.get(n, n3);
                            jMatrix.set(n, n7, d8 * d9 + d7 * d3);
                            jMatrix.set(n, n3, d7 * d9 - d8 * d3);
                        }
                    }
                }
                d7 = dArray[n2];
                if (n6 == n2) {
                    if (!(d7 < 0.0)) continue block27;
                    dArray[n2] = -d7;
                    for (n = 0; n < n5; ++n) {
                        denseMatrix.set(n, n2, -denseMatrix.get(n, n2));
                    }
                    continue block27;
                }
                if (i == 29) {
                    throw new IllegalStateException("no convergence in 30 iterations");
                }
                double d10 = dArray[n6];
                n7 = n2 - 1;
                d8 = dArray[n7];
                d6 = dArray2[n7];
                d = dArray2[n2];
                d2 = ((d8 - d7) * (d8 + d7) + (d6 - d) * (d6 + d)) / (2.0 * d * d8);
                d6 = Math.hypot(d2, 1.0);
                d2 = ((d10 - d7) * (d10 + d7) + d * (d8 / (d2 + Math.copySign(d6, d2)) - d)) / d10;
                d3 = 1.0;
                d9 = 1.0;
                for (n = n6; n <= n7; ++n) {
                    int n8;
                    n3 = n + 1;
                    d6 = dArray2[n3];
                    d8 = dArray[n3];
                    d = d3 * d6;
                    d6 = d9 * d6;
                    dArray2[n] = d7 = Math.hypot(d2, d);
                    d9 = d2 / d7;
                    d3 = d / d7;
                    d2 = d10 * d9 + d6 * d3;
                    d6 = d6 * d9 - d10 * d3;
                    d = d8 * d3;
                    d8 *= d9;
                    for (n8 = 0; n8 < n5; ++n8) {
                        d10 = denseMatrix.get(n8, n);
                        d7 = denseMatrix.get(n8, n3);
                        denseMatrix.set(n8, n, d10 * d9 + d7 * d3);
                        denseMatrix.set(n8, n3, d7 * d9 - d10 * d3);
                    }
                    dArray[n] = d7 = Math.hypot(d2, d);
                    if (d7 != 0.0) {
                        d7 = 1.0 / d7;
                        d9 = d2 * d7;
                        d3 = d * d7;
                    }
                    d2 = d9 * d6 + d3 * d8;
                    d10 = d9 * d8 - d3 * d6;
                    for (n8 = 0; n8 < n4; ++n8) {
                        d8 = jMatrix.get(n8, n);
                        d7 = jMatrix.get(n8, n3);
                        jMatrix.set(n8, n, d8 * d9 + d7 * d3);
                        jMatrix.set(n8, n3, d7 * d9 - d8 * d3);
                    }
                }
                dArray2[n6] = 0.0;
                dArray2[n2] = d2;
                dArray[n2] = d10;
            }
        }
        int n9 = 1;
        double[] dArray3 = new double[n4];
        double[] dArray4 = new double[n5];
        do {
            n9 *= 3;
        } while (++n9 <= n5);
        do {
            for (n3 = n9 /= 3; n3 < n5; ++n3) {
                double d11 = dArray[n3];
                for (n2 = 0; n2 < n4; ++n2) {
                    dArray3[n2] = jMatrix.get(n2, n3);
                }
                for (n2 = 0; n2 < n5; ++n2) {
                    dArray4[n2] = denseMatrix.get(n2, n3);
                }
                n = n3;
                while (dArray[n - n9] < d11) {
                    dArray[n] = dArray[n - n9];
                    for (n2 = 0; n2 < n4; ++n2) {
                        jMatrix.set(n2, n, jMatrix.get(n2, n - n9));
                    }
                    for (n2 = 0; n2 < n5; ++n2) {
                        denseMatrix.set(n2, n, denseMatrix.get(n2, n - n9));
                    }
                    if ((n -= n9) >= n9) continue;
                }
                dArray[n] = d11;
                for (n2 = 0; n2 < n4; ++n2) {
                    jMatrix.set(n2, n, dArray3[n2]);
                }
                for (n2 = 0; n2 < n5; ++n2) {
                    denseMatrix.set(n2, n, dArray4[n2]);
                }
            }
        } while (n9 > 1);
        for (n2 = 0; n2 < n5; ++n2) {
            d3 = 0.0;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!(jMatrix.get(n3, n2) < 0.0)) continue;
                d3 += 1.0;
            }
            for (n = 0; n < n5; ++n) {
                if (!(denseMatrix.get(n, n2) < 0.0)) continue;
                d3 += 1.0;
            }
            if (!(d3 > (double)((n4 + n5) / 2))) continue;
            for (n3 = 0; n3 < n4; ++n3) {
                jMatrix.set(n3, n2, -jMatrix.get(n3, n2));
            }
            for (n = 0; n < n5; ++n) {
                denseMatrix.set(n, n2, -denseMatrix.get(n, n2));
            }
        }
        double[] dArray5 = new double[Math.min(n4, n5)];
        System.arraycopy(dArray, 0, dArray5, 0, dArray5.length);
        return new SVD(jMatrix, denseMatrix, dArray5);
    }

    @Override
    public double[] eig() {
        double[] dArray;
        if (this.nrows() != this.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", this.nrows(), this.ncols()));
        }
        int n = this.nrows();
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        if (this.isSymmetric()) {
            JMatrix.tred(this, dArray2, dArray3);
            JMatrix.tql(dArray2, dArray3, n);
        } else {
            dArray = JMatrix.balance(this);
            int[] nArray = JMatrix.elmhes(this);
            JMatrix.hqr(this, dArray2, dArray3);
            JMatrix.sort(dArray2, dArray3);
        }
        dArray = new double[2 * n];
        System.arraycopy(dArray2, 0, dArray, 0, n);
        System.arraycopy(dArray3, 0, dArray, n, n);
        return dArray;
    }

    @Override
    public EVD eigen() {
        DenseMatrix denseMatrix;
        if (this.nrows() != this.ncols()) {
            throw new IllegalArgumentException(String.format("Matrix is not square: %d x %d", this.nrows(), this.ncols()));
        }
        int n = this.nrows();
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        if (this.isSymmetric()) {
            denseMatrix = this;
            JMatrix.tred2(denseMatrix, dArray, dArray2);
            JMatrix.tql2(denseMatrix, dArray, dArray2);
        } else {
            double[] dArray3 = JMatrix.balance(this);
            int[] nArray = JMatrix.elmhes(this);
            denseMatrix = Matrix.eye(n, n);
            JMatrix.eltran(this, denseMatrix, nArray);
            JMatrix.hqr2(this, denseMatrix, dArray, dArray2);
            JMatrix.balbak(denseMatrix, dArray3);
            JMatrix.sort(dArray, dArray2, denseMatrix);
        }
        return new EVD(denseMatrix, dArray, dArray2);
    }

    private static void tred(DenseMatrix denseMatrix, double[] dArray, double[] dArray2) {
        int n;
        int n2 = denseMatrix.nrows();
        for (n = 0; n < n2; ++n) {
            dArray[n] = denseMatrix.get(n2 - 1, n);
        }
        for (n = n2 - 1; n > 0; --n) {
            int n3;
            double d = 0.0;
            double d2 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d += Math.abs(dArray[n3]);
            }
            if (d == 0.0) {
                dArray2[n] = dArray[n - 1];
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[n3] = denseMatrix.get(n - 1, n3);
                    denseMatrix.set(n, n3, 0.0);
                    denseMatrix.set(n3, n, 0.0);
                }
            } else {
                int n4;
                int n5;
                for (n3 = 0; n3 < n; ++n3) {
                    int n6 = n3;
                    dArray[n6] = dArray[n6] / d;
                    d2 += dArray[n3] * dArray[n3];
                }
                double d3 = dArray[n - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                dArray2[n] = d * d4;
                d2 -= d3 * d4;
                dArray[n - 1] = d3 - d4;
                for (n5 = 0; n5 < n; ++n5) {
                    dArray2[n5] = 0.0;
                }
                for (n5 = 0; n5 < n; ++n5) {
                    d3 = dArray[n5];
                    denseMatrix.set(n5, n, d3);
                    d4 = dArray2[n5] + denseMatrix.get(n5, n5) * d3;
                    for (int i = n5 + 1; i <= n - 1; ++i) {
                        d4 += denseMatrix.get(i, n5) * dArray[i];
                        int n7 = i;
                        dArray2[n7] = dArray2[n7] + denseMatrix.get(i, n5) * d3;
                    }
                    dArray2[n5] = d4;
                }
                d3 = 0.0;
                for (n5 = 0; n5 < n; ++n5) {
                    int n8 = n5;
                    dArray2[n8] = dArray2[n8] / d2;
                    d3 += dArray2[n5] * dArray[n5];
                }
                double d5 = d3 / (d2 + d2);
                for (n4 = 0; n4 < n; ++n4) {
                    int n9 = n4;
                    dArray2[n9] = dArray2[n9] - d5 * dArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    d3 = dArray[n4];
                    d4 = dArray2[n4];
                    for (int i = n4; i <= n - 1; ++i) {
                        denseMatrix.sub(i, n4, d3 * dArray2[i] + d4 * dArray[i]);
                    }
                    dArray[n4] = denseMatrix.get(n - 1, n4);
                    denseMatrix.set(n, n4, 0.0);
                }
            }
            dArray[n] = d2;
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = denseMatrix.get(n, n);
        }
        dArray2[0] = 0.0;
    }

    private static void tred2(DenseMatrix denseMatrix, double[] dArray, double[] dArray2) {
        double d;
        int n;
        int n2 = denseMatrix.nrows();
        for (n = 0; n < n2; ++n) {
            dArray[n] = denseMatrix.get(n2 - 1, n);
        }
        for (n = n2 - 1; n > 0; --n) {
            int n3;
            d = 0.0;
            double d2 = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d += Math.abs(dArray[n3]);
            }
            if (d == 0.0) {
                dArray2[n] = dArray[n - 1];
                for (n3 = 0; n3 < n; ++n3) {
                    dArray[n3] = denseMatrix.get(n - 1, n3);
                    denseMatrix.set(n, n3, 0.0);
                    denseMatrix.set(n3, n, 0.0);
                }
            } else {
                int n4;
                int n5;
                for (n3 = 0; n3 < n; ++n3) {
                    int n6 = n3;
                    dArray[n6] = dArray[n6] / d;
                    d2 += dArray[n3] * dArray[n3];
                }
                double d3 = dArray[n - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                dArray2[n] = d * d4;
                d2 -= d3 * d4;
                dArray[n - 1] = d3 - d4;
                for (n5 = 0; n5 < n; ++n5) {
                    dArray2[n5] = 0.0;
                }
                for (n5 = 0; n5 < n; ++n5) {
                    d3 = dArray[n5];
                    denseMatrix.set(n5, n, d3);
                    d4 = dArray2[n5] + denseMatrix.get(n5, n5) * d3;
                    for (int i = n5 + 1; i <= n - 1; ++i) {
                        d4 += denseMatrix.get(i, n5) * dArray[i];
                        int n7 = i;
                        dArray2[n7] = dArray2[n7] + denseMatrix.get(i, n5) * d3;
                    }
                    dArray2[n5] = d4;
                }
                d3 = 0.0;
                for (n5 = 0; n5 < n; ++n5) {
                    int n8 = n5;
                    dArray2[n8] = dArray2[n8] / d2;
                    d3 += dArray2[n5] * dArray[n5];
                }
                double d5 = d3 / (d2 + d2);
                for (n4 = 0; n4 < n; ++n4) {
                    int n9 = n4;
                    dArray2[n9] = dArray2[n9] - d5 * dArray[n4];
                }
                for (n4 = 0; n4 < n; ++n4) {
                    d3 = dArray[n4];
                    d4 = dArray2[n4];
                    for (int i = n4; i <= n - 1; ++i) {
                        denseMatrix.sub(i, n4, d3 * dArray2[i] + d4 * dArray[i]);
                    }
                    dArray[n4] = denseMatrix.get(n - 1, n4);
                    denseMatrix.set(n, n4, 0.0);
                }
            }
            dArray[n] = d2;
        }
        for (n = 0; n < n2 - 1; ++n) {
            int n10;
            denseMatrix.set(n2 - 1, n, denseMatrix.get(n, n));
            denseMatrix.set(n, n, 1.0);
            d = dArray[n + 1];
            if (d != 0.0) {
                for (n10 = 0; n10 <= n; ++n10) {
                    dArray[n10] = denseMatrix.get(n10, n + 1) / d;
                }
                for (n10 = 0; n10 <= n; ++n10) {
                    int n11;
                    double d6 = 0.0;
                    for (n11 = 0; n11 <= n; ++n11) {
                        d6 += denseMatrix.get(n11, n + 1) * denseMatrix.get(n11, n10);
                    }
                    for (n11 = 0; n11 <= n; ++n11) {
                        denseMatrix.sub(n11, n10, d6 * dArray[n11]);
                    }
                }
            }
            for (n10 = 0; n10 <= n; ++n10) {
                denseMatrix.set(n10, n + 1, 0.0);
            }
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = denseMatrix.get(n2 - 1, n);
            denseMatrix.set(n2 - 1, n, 0.0);
        }
        denseMatrix.set(n2 - 1, n2 - 1, 1.0);
        dArray2[0] = 0.0;
    }

    private static void tql(double[] dArray, double[] dArray2, int n) {
        int n2;
        int n3;
        for (int i = 1; i < n; ++i) {
            dArray2[i - 1] = dArray2[i];
        }
        dArray2[n - 1] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            d2 = Math.max(d2, Math.abs(dArray[n3]) + Math.abs(dArray2[n3]));
            for (n2 = n3; n2 < n && !(Math.abs(dArray2[n2]) <= Math.EPSILON * d2); ++n2) {
            }
            if (n2 > n3) {
                int n4 = 0;
                do {
                    double d3;
                    if (++n4 >= 30) {
                        throw new RuntimeException("Too many iterations");
                    }
                    double d4 = dArray[n3];
                    double d5 = (dArray[n3 + 1] - dArray[n3]) / (2.0 * dArray2[n3]);
                    double d6 = Math.hypot(d5, 1.0);
                    if (d5 < 0.0) {
                        d6 = -d6;
                    }
                    dArray[n3] = dArray2[n3] / (d5 + d6);
                    dArray[n3 + 1] = dArray2[n3] * (d5 + d6);
                    double d7 = dArray[n3 + 1];
                    double d8 = d4 - dArray[n3];
                    int n5 = n3 + 2;
                    while (n5 < n) {
                        int n6 = n5++;
                        dArray[n6] = dArray[n6] - d8;
                    }
                    d += d8;
                    d5 = dArray[n2];
                    double d9 = d3 = 1.0;
                    double d10 = d3;
                    double d11 = dArray2[n3 + 1];
                    double d12 = 0.0;
                    double d13 = 0.0;
                    for (int i = n2 - 1; i >= n3; --i) {
                        d10 = d9;
                        d9 = d3;
                        d13 = d12;
                        d4 = d3 * dArray2[i];
                        d8 = d3 * d5;
                        d6 = Math.hypot(d5, dArray2[i]);
                        dArray2[i + 1] = d12 * d6;
                        d12 = dArray2[i] / d6;
                        d3 = d5 / d6;
                        d5 = d3 * dArray[i] - d12 * d4;
                        dArray[i + 1] = d8 + d12 * (d3 * d4 + d12 * dArray[i]);
                    }
                    d5 = -d12 * d13 * d10 * d11 * dArray2[n3] / d7;
                    dArray2[n3] = d12 * d5;
                    dArray[n3] = d3 * d5;
                } while (Math.abs(dArray2[n3]) > Math.EPSILON * d2);
            }
            dArray[n3] = dArray[n3] + d;
            dArray2[n3] = 0.0;
        }
        for (n3 = 0; n3 < n - 1; ++n3) {
            n2 = n3;
            double d14 = dArray[n3];
            for (int i = n3 + 1; i < n; ++i) {
                if (!(dArray[i] > d14)) continue;
                n2 = i;
                d14 = dArray[i];
            }
            if (n2 == n3) continue;
            dArray[n2] = dArray[n3];
            dArray[n3] = d14;
        }
    }

    static void tql2(DenseMatrix denseMatrix, double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3 = denseMatrix.nrows();
        for (int i = 1; i < n3; ++i) {
            dArray2[i - 1] = dArray2[i];
        }
        dArray2[n3 - 1] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            d2 = Math.max(d2, Math.abs(dArray[n2]) + Math.abs(dArray2[n2]));
            for (n = n2; n < n3 && !(Math.abs(dArray2[n]) <= Math.EPSILON * d2); ++n) {
            }
            if (n > n2) {
                int n4 = 0;
                do {
                    double d3;
                    if (++n4 >= 30) {
                        throw new RuntimeException("Too many iterations");
                    }
                    double d4 = dArray[n2];
                    double d5 = (dArray[n2 + 1] - d4) / (2.0 * dArray2[n2]);
                    double d6 = Math.hypot(d5, 1.0);
                    if (d5 < 0.0) {
                        d6 = -d6;
                    }
                    dArray[n2] = dArray2[n2] / (d5 + d6);
                    dArray[n2 + 1] = dArray2[n2] * (d5 + d6);
                    double d7 = dArray[n2 + 1];
                    double d8 = d4 - dArray[n2];
                    int n5 = n2 + 2;
                    while (n5 < n3) {
                        int n6 = n5++;
                        dArray[n6] = dArray[n6] - d8;
                    }
                    d += d8;
                    d5 = dArray[n];
                    double d9 = d3 = 1.0;
                    double d10 = d3;
                    double d11 = dArray2[n2 + 1];
                    double d12 = 0.0;
                    double d13 = 0.0;
                    for (int i = n - 1; i >= n2; --i) {
                        d10 = d9;
                        d9 = d3;
                        d13 = d12;
                        d4 = d3 * dArray2[i];
                        d8 = d3 * d5;
                        d6 = Math.hypot(d5, dArray2[i]);
                        dArray2[i + 1] = d12 * d6;
                        d12 = dArray2[i] / d6;
                        d3 = d5 / d6;
                        d5 = d3 * dArray[i] - d12 * d4;
                        dArray[i + 1] = d8 + d12 * (d3 * d4 + d12 * dArray[i]);
                        for (int j = 0; j < n3; ++j) {
                            d8 = denseMatrix.get(j, i + 1);
                            denseMatrix.set(j, i + 1, d12 * denseMatrix.get(j, i) + d3 * d8);
                            denseMatrix.set(j, i, d3 * denseMatrix.get(j, i) - d12 * d8);
                        }
                    }
                    d5 = -d12 * d13 * d10 * d11 * dArray2[n2] / d7;
                    dArray2[n2] = d12 * d5;
                    dArray[n2] = d3 * d5;
                } while (Math.abs(dArray2[n2]) > Math.EPSILON * d2);
            }
            dArray[n2] = dArray[n2] + d;
            dArray2[n2] = 0.0;
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            int n7;
            n = n2;
            double d14 = dArray[n2];
            for (n7 = n2 + 1; n7 < n3; ++n7) {
                if (!(dArray[n7] > d14)) continue;
                n = n7;
                d14 = dArray[n7];
            }
            if (n == n2) continue;
            dArray[n] = dArray[n2];
            dArray[n2] = d14;
            for (n7 = 0; n7 < n3; ++n7) {
                d14 = denseMatrix.get(n7, n2);
                denseMatrix.set(n7, n2, denseMatrix.get(n7, n));
                denseMatrix.set(n7, n, d14);
            }
        }
    }

    private static double[] balance(DenseMatrix denseMatrix) {
        int n;
        double d = Math.RADIX * Math.RADIX;
        int n2 = denseMatrix.nrows();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = 1.0;
        }
        n = 0;
        while (n == 0) {
            n = 1;
            for (int i = 0; i < n2; ++i) {
                int n3;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int j = 0; j < n2; ++j) {
                    if (j == i) continue;
                    d3 += Math.abs(denseMatrix.get(j, i));
                    d2 += Math.abs(denseMatrix.get(i, j));
                }
                if (d3 == 0.0 || d2 == 0.0) continue;
                double d4 = d2 / (double)Math.RADIX;
                double d5 = 1.0;
                double d6 = d3 + d2;
                while (d3 < d4) {
                    d5 *= (double)Math.RADIX;
                    d3 *= d;
                }
                d4 = d2 * (double)Math.RADIX;
                while (d3 > d4) {
                    d5 /= (double)Math.RADIX;
                    d3 /= d;
                }
                if (!((d3 + d2) / d5 < 0.95 * d6)) continue;
                n = 0;
                d4 = 1.0 / d5;
                int n4 = i;
                dArray[n4] = dArray[n4] * d5;
                for (n3 = 0; n3 < n2; ++n3) {
                    denseMatrix.mul(i, n3, d4);
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    denseMatrix.mul(n3, i, d5);
                }
            }
        }
        return dArray;
    }

    private static void balbak(DenseMatrix denseMatrix, double[] dArray) {
        int n = denseMatrix.nrows();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix.mul(i, j, dArray[i]);
            }
        }
    }

    private static int[] elmhes(DenseMatrix denseMatrix) {
        int n = denseMatrix.nrows();
        int[] nArray = new int[n];
        for (int i = 1; i < n - 1; ++i) {
            int n2;
            double d = 0.0;
            int n3 = i;
            for (n2 = i; n2 < n; ++n2) {
                if (!(Math.abs(denseMatrix.get(n2, i - 1)) > Math.abs(d))) continue;
                d = denseMatrix.get(n2, i - 1);
                n3 = n2;
            }
            nArray[i] = n3;
            if (n3 != i) {
                double d2;
                for (n2 = i - 1; n2 < n; ++n2) {
                    d2 = denseMatrix.get(n3, n2);
                    denseMatrix.set(n3, n2, denseMatrix.get(i, n2));
                    denseMatrix.set(i, n2, d2);
                }
                for (n2 = 0; n2 < n; ++n2) {
                    d2 = denseMatrix.get(n2, n3);
                    denseMatrix.set(n2, n3, denseMatrix.get(n2, i));
                    denseMatrix.set(n2, i, d2);
                }
            }
            if (d == 0.0) continue;
            for (n3 = i + 1; n3 < n; ++n3) {
                int n4;
                double d3 = denseMatrix.get(n3, i - 1);
                if (d3 == 0.0) continue;
                denseMatrix.set(n3, i - 1, d3 /= d);
                for (n4 = i; n4 < n; ++n4) {
                    denseMatrix.sub(n3, n4, d3 * denseMatrix.get(i, n4));
                }
                for (n4 = 0; n4 < n; ++n4) {
                    denseMatrix.add(n4, i, d3 * denseMatrix.get(n4, n3));
                }
            }
        }
        return nArray;
    }

    private static void eltran(DenseMatrix denseMatrix, DenseMatrix denseMatrix2, int[] nArray) {
        int n = denseMatrix.nrows();
        for (int i = n - 2; i > 0; --i) {
            int n2;
            for (n2 = i + 1; n2 < n; ++n2) {
                denseMatrix2.set(n2, i, denseMatrix.get(n2, i - 1));
            }
            n2 = nArray[i];
            if (n2 == i) continue;
            for (int j = i; j < n; ++j) {
                denseMatrix2.set(i, j, denseMatrix2.get(n2, j));
                denseMatrix2.set(n2, j, 0.0);
            }
            denseMatrix2.set(n2, i, 1.0);
        }
    }

    private static void hqr(DenseMatrix denseMatrix, double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3 = denseMatrix.nrows();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = Math.max(n2 - 1, 0); n < n3; ++n) {
                d4 += Math.abs(denseMatrix.get(n2, n));
            }
        }
        int n4 = n3 - 1;
        double d5 = 0.0;
        while (n4 >= 0) {
            int n5;
            int n6 = 0;
            do {
                int n7;
                double d6;
                double d7;
                for (n5 = n4; n5 > 0; --n5) {
                    d7 = Math.abs(denseMatrix.get(n5 - 1, n5 - 1) + Math.abs(denseMatrix.get(n5, n5)));
                    if (d7 == 0.0) {
                        d7 = d4;
                    }
                    if (!(Math.abs(denseMatrix.get(n5, n5 - 1)) <= Math.EPSILON * d7)) continue;
                    denseMatrix.set(n5, n5 - 1, 0.0);
                    break;
                }
                double d8 = denseMatrix.get(n4, n4);
                if (n5 == n4) {
                    dArray[n4--] = d8 + d5;
                    continue;
                }
                double d9 = denseMatrix.get(n4 - 1, n4 - 1);
                double d10 = denseMatrix.get(n4, n4 - 1) * denseMatrix.get(n4 - 1, n4);
                if (n5 == n4 - 1) {
                    d3 = 0.5 * (d9 - d8);
                    d2 = d3 * d3 + d10;
                    d6 = Math.sqrt(Math.abs(d2));
                    d8 += d5;
                    if (d2 >= 0.0) {
                        d6 = d3 + Math.copySign(d6, d3);
                        dArray[n4 - 1] = dArray[n4] = d8 + d6;
                        if (d6 != 0.0) {
                            dArray[n4] = d8 - d10 / d6;
                        }
                    } else {
                        dArray[n4] = d8 + d3;
                        dArray2[n4] = -d6;
                        dArray[n4 - 1] = dArray[n4];
                        dArray2[n4 - 1] = -dArray2[n4];
                    }
                    n4 -= 2;
                    continue;
                }
                if (n6 == 30) {
                    throw new IllegalStateException("Too many iterations in hqr");
                }
                if (n6 == 10 || n6 == 20) {
                    d5 += d8;
                    for (n2 = 0; n2 < n4 + 1; ++n2) {
                        denseMatrix.sub(n2, n2, d8);
                    }
                    d7 = Math.abs(denseMatrix.get(n4, n4 - 1)) + Math.abs(denseMatrix.get(n4 - 1, n4 - 2));
                    d9 = d8 = 0.75 * d7;
                    d10 = -0.4375 * d7 * d7;
                }
                ++n6;
                for (n7 = n4 - 2; n7 >= n5; --n7) {
                    double d11;
                    double d12;
                    d6 = denseMatrix.get(n7, n7);
                    d = d8 - d6;
                    d7 = d9 - d6;
                    d3 = (d * d7 - d10) / denseMatrix.get(n7 + 1, n7) + denseMatrix.get(n7, n7 + 1);
                    d2 = denseMatrix.get(n7 + 1, n7 + 1) - d6 - d - d7;
                    d = denseMatrix.get(n7 + 2, n7 + 1);
                    d7 = Math.abs(d3) + Math.abs(d2) + Math.abs(d);
                    if (n7 == n5 || (d12 = Math.abs(denseMatrix.get(n7, n7 - 1)) * (Math.abs(d2 /= d7) + Math.abs(d /= d7))) <= Math.EPSILON * (d11 = Math.abs(d3 /= d7) * (Math.abs(denseMatrix.get(n7 - 1, n7 - 1)) + Math.abs(d6) + Math.abs(denseMatrix.get(n7 + 1, n7 + 1))))) break;
                }
                for (n2 = n7; n2 < n4 - 1; ++n2) {
                    denseMatrix.set(n2 + 2, n2, 0.0);
                    if (n2 == n7) continue;
                    denseMatrix.set(n2 + 2, n2 - 1, 0.0);
                }
                for (int i = n7; i < n4; ++i) {
                    if (i != n7) {
                        d3 = denseMatrix.get(i, i - 1);
                        d2 = denseMatrix.get(i + 1, i - 1);
                        d = 0.0;
                        if (i + 1 != n4) {
                            d = denseMatrix.get(i + 2, i - 1);
                        }
                        if ((d8 = Math.abs(d3) + Math.abs(d2) + Math.abs(d)) != 0.0) {
                            d3 /= d8;
                            d2 /= d8;
                            d /= d8;
                        }
                    }
                    if ((d7 = Math.copySign(Math.sqrt(d3 * d3 + d2 * d2 + d * d), d3)) == 0.0) continue;
                    if (i == n7) {
                        if (n5 != n7) {
                            denseMatrix.set(i, i - 1, -denseMatrix.get(i, i - 1));
                        }
                    } else {
                        denseMatrix.set(i, i - 1, -d7 * d8);
                    }
                    d8 = (d3 += d7) / d7;
                    d9 = d2 / d7;
                    d6 = d / d7;
                    d2 /= d3;
                    d /= d3;
                    for (n = i; n < n4 + 1; ++n) {
                        d3 = denseMatrix.get(i, n) + d2 * denseMatrix.get(i + 1, n);
                        if (i + 1 != n4) {
                            denseMatrix.sub(i + 2, n, (d3 += d * denseMatrix.get(i + 2, n)) * d6);
                        }
                        denseMatrix.sub(i + 1, n, d3 * d9);
                        denseMatrix.sub(i, n, d3 * d8);
                    }
                    int n8 = n4 < i + 3 ? n4 : i + 3;
                    for (n2 = n5; n2 < n8 + 1; ++n2) {
                        d3 = d8 * denseMatrix.get(n2, i) + d9 * denseMatrix.get(n2, i + 1);
                        if (i + 1 != n4) {
                            denseMatrix.sub(n2, i + 2, (d3 += d6 * denseMatrix.get(n2, i + 2)) * d);
                        }
                        denseMatrix.sub(n2, i + 1, d3 * d2);
                        denseMatrix.sub(n2, i, d3);
                    }
                }
            } while (n5 + 1 < n4);
        }
    }

    private static void hqr2(DenseMatrix denseMatrix, DenseMatrix denseMatrix2, double[] dArray, double[] dArray2) {
        int n;
        int n2;
        double d;
        double d2;
        double d3;
        int n3;
        int n4;
        int n5 = denseMatrix.nrows();
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = Math.max(n4 - 1, 0); n3 < n5; ++n3) {
                d9 += Math.abs(denseMatrix.get(n4, n3));
            }
        }
        int n6 = n5 - 1;
        double d10 = 0.0;
        while (n6 >= 0) {
            int n7;
            int n8 = 0;
            do {
                for (n7 = n6; n7 > 0; --n7) {
                    d5 = Math.abs(denseMatrix.get(n7 - 1, n7 - 1)) + Math.abs(denseMatrix.get(n7, n7));
                    if (d5 == 0.0) {
                        d5 = d9;
                    }
                    if (!(Math.abs(denseMatrix.get(n7, n7 - 1)) <= Math.EPSILON * d5)) continue;
                    denseMatrix.set(n7, n7 - 1, 0.0);
                    break;
                }
                d3 = denseMatrix.get(n6, n6);
                if (n7 == n6) {
                    dArray[n6] = d3 + d10;
                    denseMatrix.set(n6, n6, d3 + d10);
                    --n6;
                    continue;
                }
                d2 = denseMatrix.get(n6 - 1, n6 - 1);
                d = denseMatrix.get(n6, n6 - 1) * denseMatrix.get(n6 - 1, n6);
                if (n7 == n6 - 1) {
                    d8 = 0.5 * (d2 - d3);
                    d7 = d8 * d8 + d;
                    d4 = Math.sqrt(Math.abs(d7));
                    denseMatrix.set(n6, n6, d3 += d10);
                    denseMatrix.set(n6 - 1, n6 - 1, d2 + d10);
                    if (d7 >= 0.0) {
                        d4 = d8 + Math.copySign(d4, d8);
                        dArray[n6 - 1] = dArray[n6] = d3 + d4;
                        if (d4 != 0.0) {
                            dArray[n6] = d3 - d / d4;
                        }
                        d3 = denseMatrix.get(n6, n6 - 1);
                        d5 = Math.abs(d3) + Math.abs(d4);
                        d8 = d3 / d5;
                        d7 = d4 / d5;
                        d6 = Math.sqrt(d8 * d8 + d7 * d7);
                        d8 /= d6;
                        d7 /= d6;
                        for (n3 = n6 - 1; n3 < n5; ++n3) {
                            d4 = denseMatrix.get(n6 - 1, n3);
                            denseMatrix.set(n6 - 1, n3, d7 * d4 + d8 * denseMatrix.get(n6, n3));
                            denseMatrix.set(n6, n3, d7 * denseMatrix.get(n6, n3) - d8 * d4);
                        }
                        for (n4 = 0; n4 <= n6; ++n4) {
                            d4 = denseMatrix.get(n4, n6 - 1);
                            denseMatrix.set(n4, n6 - 1, d7 * d4 + d8 * denseMatrix.get(n4, n6));
                            denseMatrix.set(n4, n6, d7 * denseMatrix.get(n4, n6) - d8 * d4);
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            d4 = denseMatrix2.get(n4, n6 - 1);
                            denseMatrix2.set(n4, n6 - 1, d7 * d4 + d8 * denseMatrix2.get(n4, n6));
                            denseMatrix2.set(n4, n6, d7 * denseMatrix2.get(n4, n6) - d8 * d4);
                        }
                    } else {
                        dArray[n6] = d3 + d8;
                        dArray2[n6] = -d4;
                        dArray[n6 - 1] = dArray[n6];
                        dArray2[n6 - 1] = -dArray2[n6];
                    }
                    n6 -= 2;
                    continue;
                }
                if (n8 == 30) {
                    throw new IllegalArgumentException("Too many iterations in hqr");
                }
                if (n8 == 10 || n8 == 20) {
                    d10 += d3;
                    for (n4 = 0; n4 < n6 + 1; ++n4) {
                        denseMatrix.sub(n4, n4, d3);
                    }
                    d5 = Math.abs(denseMatrix.get(n6, n6 - 1)) + Math.abs(denseMatrix.get(n6 - 1, n6 - 2));
                    d2 = d3 = 0.75 * d5;
                    d = -0.4375 * d5 * d5;
                }
                ++n8;
                for (n2 = n6 - 2; n2 >= n7; --n2) {
                    double d11;
                    double d12;
                    d4 = denseMatrix.get(n2, n2);
                    d6 = d3 - d4;
                    d5 = d2 - d4;
                    d8 = (d6 * d5 - d) / denseMatrix.get(n2 + 1, n2) + denseMatrix.get(n2, n2 + 1);
                    d7 = denseMatrix.get(n2 + 1, n2 + 1) - d4 - d6 - d5;
                    d6 = denseMatrix.get(n2 + 2, n2 + 1);
                    d5 = Math.abs(d8) + Math.abs(d7) + Math.abs(d6);
                    if (n2 == n7 || (d12 = Math.abs(denseMatrix.get(n2, n2 - 1)) * (Math.abs(d7 /= d5) + Math.abs(d6 /= d5))) <= Math.EPSILON * (d11 = Math.abs(d8 /= d5) * (Math.abs(denseMatrix.get(n2 - 1, n2 - 1)) + Math.abs(d4) + Math.abs(denseMatrix.get(n2 + 1, n2 + 1))))) break;
                }
                for (n4 = n2; n4 < n6 - 1; ++n4) {
                    denseMatrix.set(n4 + 2, n4, 0.0);
                    if (n4 == n2) continue;
                    denseMatrix.set(n4 + 2, n4 - 1, 0.0);
                }
                for (n = n2; n < n6; ++n) {
                    if (n != n2) {
                        d8 = denseMatrix.get(n, n - 1);
                        d7 = denseMatrix.get(n + 1, n - 1);
                        d6 = 0.0;
                        if (n + 1 != n6) {
                            d6 = denseMatrix.get(n + 2, n - 1);
                        }
                        if ((d3 = Math.abs(d8) + Math.abs(d7) + Math.abs(d6)) != 0.0) {
                            d8 /= d3;
                            d7 /= d3;
                            d6 /= d3;
                        }
                    }
                    if ((d5 = Math.copySign(Math.sqrt(d8 * d8 + d7 * d7 + d6 * d6), d8)) == 0.0) continue;
                    if (n == n2) {
                        if (n7 != n2) {
                            denseMatrix.set(n, n - 1, -denseMatrix.get(n, n - 1));
                        }
                    } else {
                        denseMatrix.set(n, n - 1, -d5 * d3);
                    }
                    d3 = (d8 += d5) / d5;
                    d2 = d7 / d5;
                    d4 = d6 / d5;
                    d7 /= d8;
                    d6 /= d8;
                    for (n3 = n; n3 < n5; ++n3) {
                        d8 = denseMatrix.get(n, n3) + d7 * denseMatrix.get(n + 1, n3);
                        if (n + 1 != n6) {
                            denseMatrix.sub(n + 2, n3, (d8 += d6 * denseMatrix.get(n + 2, n3)) * d4);
                        }
                        denseMatrix.sub(n + 1, n3, d8 * d2);
                        denseMatrix.sub(n, n3, d8 * d3);
                    }
                    int n9 = n6 < n + 3 ? n6 : n + 3;
                    for (n4 = 0; n4 < n9 + 1; ++n4) {
                        d8 = d3 * denseMatrix.get(n4, n) + d2 * denseMatrix.get(n4, n + 1);
                        if (n + 1 != n6) {
                            denseMatrix.sub(n4, n + 2, (d8 += d4 * denseMatrix.get(n4, n + 2)) * d6);
                        }
                        denseMatrix.sub(n4, n + 1, d8 * d7);
                        denseMatrix.sub(n4, n, d8);
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        d8 = d3 * denseMatrix2.get(n4, n) + d2 * denseMatrix2.get(n4, n + 1);
                        if (n + 1 != n6) {
                            denseMatrix2.sub(n4, n + 2, (d8 += d4 * denseMatrix2.get(n4, n + 2)) * d6);
                        }
                        denseMatrix2.sub(n4, n + 1, d8 * d7);
                        denseMatrix2.sub(n4, n, d8);
                    }
                }
            } while (n7 + 1 < n6);
        }
        if (d9 != 0.0) {
            for (n6 = n5 - 1; n6 >= 0; --n6) {
                Complex complex;
                d8 = dArray[n6];
                d7 = dArray2[n6];
                int n10 = n6 - 1;
                if (d7 == 0.0) {
                    n2 = n6;
                    denseMatrix.set(n6, n6, 1.0);
                    for (n4 = n6 - 1; n4 >= 0; --n4) {
                        d = denseMatrix.get(n4, n4) - d8;
                        d6 = 0.0;
                        for (n3 = n2; n3 <= n6; ++n3) {
                            d6 += denseMatrix.get(n4, n3) * denseMatrix.get(n3, n6);
                        }
                        if (dArray2[n4] < 0.0) {
                            d4 = d;
                            d5 = d6;
                            continue;
                        }
                        n2 = n4;
                        if (dArray2[n4] == 0.0) {
                            d10 = d;
                            if (d10 == 0.0) {
                                d10 = Math.EPSILON * d9;
                            }
                            denseMatrix.set(n4, n6, -d6 / d10);
                        } else {
                            d3 = denseMatrix.get(n4, n4 + 1);
                            d2 = denseMatrix.get(n4 + 1, n4);
                            d7 = Math.sqr(dArray[n4] - d8) + Math.sqr(dArray2[n4]);
                            d10 = (d3 * d5 - d4 * d6) / d7;
                            denseMatrix.set(n4, n6, d10);
                            if (Math.abs(d3) > Math.abs(d4)) {
                                denseMatrix.set(n4 + 1, n6, (-d6 - d * d10) / d3);
                            } else {
                                denseMatrix.set(n4 + 1, n6, (-d5 - d2 * d10) / d4);
                            }
                        }
                        d10 = Math.abs(denseMatrix.get(n4, n6));
                        if (!(Math.EPSILON * d10 * d10 > 1.0)) continue;
                        for (n3 = n4; n3 <= n6; ++n3) {
                            denseMatrix.div(n3, n6, d10);
                        }
                    }
                    continue;
                }
                if (!(d7 < 0.0)) continue;
                n2 = n10;
                if (Math.abs(denseMatrix.get(n6, n10)) > Math.abs(denseMatrix.get(n10, n6))) {
                    denseMatrix.set(n10, n10, d7 / denseMatrix.get(n6, n10));
                    denseMatrix.set(n10, n6, -(denseMatrix.get(n6, n6) - d8) / denseMatrix.get(n6, n10));
                } else {
                    complex = JMatrix.cdiv(0.0, -denseMatrix.get(n10, n6), denseMatrix.get(n10, n10) - d8, d7);
                    denseMatrix.set(n10, n10, complex.re());
                    denseMatrix.set(n10, n6, complex.im());
                }
                denseMatrix.set(n6, n10, 0.0);
                denseMatrix.set(n6, n6, 1.0);
                for (n4 = n6 - 2; n4 >= 0; --n4) {
                    d = denseMatrix.get(n4, n4) - d8;
                    double d13 = 0.0;
                    double d14 = 0.0;
                    for (n3 = n2; n3 <= n6; ++n3) {
                        d14 += denseMatrix.get(n4, n3) * denseMatrix.get(n3, n10);
                        d13 += denseMatrix.get(n4, n3) * denseMatrix.get(n3, n6);
                    }
                    if (dArray2[n4] < 0.0) {
                        d4 = d;
                        d6 = d14;
                        d5 = d13;
                    } else {
                        n2 = n4;
                        if (dArray2[n4] == 0.0) {
                            complex = JMatrix.cdiv(-d14, -d13, d, d7);
                            denseMatrix.set(n4, n10, complex.re());
                            denseMatrix.set(n4, n6, complex.im());
                        } else {
                            d3 = denseMatrix.get(n4, n4 + 1);
                            d2 = denseMatrix.get(n4 + 1, n4);
                            double d15 = Math.sqr(dArray[n4] - d8) + Math.sqr(dArray2[n4]) - d7 * d7;
                            double d16 = 2.0 * d7 * (dArray[n4] - d8);
                            if (d15 == 0.0 && d16 == 0.0) {
                                d15 = Math.EPSILON * d9 * (Math.abs(d) + Math.abs(d7) + Math.abs(d3) + Math.abs(d2) + Math.abs(d4));
                            }
                            complex = JMatrix.cdiv(d3 * d6 - d4 * d14 + d7 * d13, d3 * d5 - d4 * d13 - d7 * d14, d15, d16);
                            denseMatrix.set(n4, n10, complex.re());
                            denseMatrix.set(n4, n6, complex.im());
                            if (Math.abs(d3) > Math.abs(d4) + Math.abs(d7)) {
                                denseMatrix.set(n4 + 1, n10, (-d14 - d * denseMatrix.get(n4, n10) + d7 * denseMatrix.get(n4, n6)) / d3);
                                denseMatrix.set(n4 + 1, n6, (-d13 - d * denseMatrix.get(n4, n6) - d7 * denseMatrix.get(n4, n10)) / d3);
                            } else {
                                complex = JMatrix.cdiv(-d6 - d2 * denseMatrix.get(n4, n10), -d5 - d2 * denseMatrix.get(n4, n6), d4, d7);
                                denseMatrix.set(n4 + 1, n10, complex.re());
                                denseMatrix.set(n4 + 1, n6, complex.im());
                            }
                        }
                    }
                    d10 = Math.max(Math.abs(denseMatrix.get(n4, n10)), Math.abs(denseMatrix.get(n4, n6)));
                    if (!(Math.EPSILON * d10 * d10 > 1.0)) continue;
                    for (n3 = n4; n3 <= n6; ++n3) {
                        denseMatrix.div(n3, n10, d10);
                        denseMatrix.div(n3, n6, d10);
                    }
                }
            }
            for (n3 = n5 - 1; n3 >= 0; --n3) {
                for (n4 = 0; n4 < n5; ++n4) {
                    d4 = 0.0;
                    for (n = 0; n <= n3; ++n) {
                        d4 += denseMatrix2.get(n4, n) * denseMatrix.get(n, n3);
                    }
                    denseMatrix2.set(n4, n3, d4);
                }
            }
        }
    }

    private static Complex cdiv(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        if (Math.abs(d3) > Math.abs(d4)) {
            double d7 = d4 / d3;
            double d8 = d3 + d7 * d4;
            d6 = (d + d7 * d2) / d8;
            d5 = (d2 - d7 * d) / d8;
        } else {
            double d9 = d3 / d4;
            double d10 = d4 + d9 * d3;
            d6 = (d9 * d + d2) / d10;
            d5 = (d9 * d2 - d) / d10;
        }
        return new Complex(d6, d5);
    }

    protected static void sort(double[] dArray, double[] dArray2) {
        int n = 0;
        int n2 = dArray.length;
        for (int i = 1; i < n2; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            for (n = i - 1; n >= 0 && !(dArray[n] >= dArray[i]); --n) {
                dArray[n + 1] = dArray[n];
                dArray2[n + 1] = dArray2[n];
            }
            dArray[n + 1] = d;
            dArray2[n + 1] = d2;
        }
    }

    protected static void sort(double[] dArray, double[] dArray2, DenseMatrix denseMatrix) {
        int n = 0;
        int n2 = dArray.length;
        double[] dArray3 = new double[n2];
        for (int i = 1; i < n2; ++i) {
            int n3;
            double d = dArray[i];
            double d2 = dArray2[i];
            for (n3 = 0; n3 < n2; ++n3) {
                dArray3[n3] = denseMatrix.get(n3, i);
            }
            for (n = i - 1; n >= 0 && !(dArray[n] >= dArray[i]); --n) {
                dArray[n + 1] = dArray[n];
                dArray2[n + 1] = dArray2[n];
                for (n3 = 0; n3 < n2; ++n3) {
                    denseMatrix.set(n3, n + 1, denseMatrix.get(n3, n));
                }
            }
            dArray[n + 1] = d;
            dArray2[n + 1] = d2;
            for (n3 = 0; n3 < n2; ++n3) {
                denseMatrix.set(n3, n + 1, dArray3[n3]);
            }
        }
    }
}

