/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jsonkiosk;

import java.util.Map;
import javajs.util.P3d;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jsonkiosk.JsonNioServer;
import org.openscience.jmol.app.jsonkiosk.JsonNioService;

public interface JsonNioClient {
    public static final String TYPES = "reply.....quit......command...move......rotate....translate.zoom......sync......touch.....";

    public void nioClosed(JsonNioServer var1);

    public void processNioMessage(byte[] var1) throws Exception;

    public void serverCycle();

    public static class TouchHandler {
        public static final float swipeCutoff = 100.0f;
        public static final int swipeCount = 2;
        public static final float swipeDelayMs = 3000.0f;
        public static final float swipeFactor = 30.0f;
        public int nFast;
        public long previousMoveTime;
        public long swipeStartTime;
        public long latestMoveTime;
        public boolean wasSpinOn;
        public boolean isPaused;

        public void pauseScript(Viewer vwr, boolean isPause) {
            String script;
            if (isPause) {
                this.wasSpinOn = vwr.getBooleanProperty("spinOn");
                script = "pause; save orientation 'JsonNios-save'; spin off";
                this.isPaused = true;
            } else {
                script = "restore orientation 'JsonNios-save' 1; resume; spin " + this.wasSpinOn;
                this.wasSpinOn = false;
            }
            this.isPaused = isPause;
            vwr.evalString(script);
        }

        public void checkPaused(Viewer vwr) {
            long now = System.currentTimeMillis();
            if (this.isPaused && now - this.latestMoveTime > 5000L) {
                this.pauseScript(vwr, false);
            }
        }

        public void syncScript(Viewer vwr, String script) {
            vwr.syncScript(script, "~", 0);
        }

        public void nioSync(Viewer vwr, Map<String, Object> json) throws Exception {
            switch (JsonNioClient.TYPES.indexOf(JsonNioService.getString(json, "type"))) {
                case 30: {
                    long now = this.latestMoveTime = System.currentTimeMillis();
                    switch (JsonNioClient.TYPES.indexOf(JsonNioService.getString(json, "style"))) {
                        case 40: {
                            boolean disallowSpinGesture;
                            float dx = (float)JsonNioService.getDouble(json, "x");
                            float dy = (float)JsonNioService.getDouble(json, "y");
                            float dxdy = dx * dx + dy * dy;
                            boolean isFast = dxdy > 100.0f;
                            boolean bl = disallowSpinGesture = vwr.getBooleanProperty("isNavigating") || !vwr.getBooleanProperty("allowGestures");
                            if (disallowSpinGesture || isFast || (float)(now - this.swipeStartTime) > 3000.0f) {
                                String msg = null;
                                if (!disallowSpinGesture) {
                                    if (isFast) {
                                        if (++this.nFast > 2) {
                                            this.swipeStartTime = now;
                                            msg = "Mouse: spinXYBy " + (int)dx + " " + (int)dy + " " + Math.sqrt(dxdy) * 30.0 / (double)(now - this.previousMoveTime);
                                        }
                                    } else if (this.nFast > 0) {
                                        this.nFast = 0;
                                        msg = "Mouse: spinXYBy 0 0 0";
                                    }
                                }
                                if (msg == null) {
                                    msg = "Mouse: rotateXYBy " + dx + " " + dy;
                                }
                                this.syncScript(vwr, msg);
                            }
                            this.previousMoveTime = now;
                            break;
                        }
                        case 50: {
                            if (!this.isPaused) {
                                this.pauseScript(vwr, true);
                            }
                            this.syncScript(vwr, "Mouse: translateXYBy " + JsonNioService.getString(json, "x") + " " + JsonNioService.getString(json, "y"));
                            break;
                        }
                        case 60: {
                            if (!this.isPaused) {
                                this.pauseScript(vwr, true);
                            }
                            float zoomFactor = (float)(JsonNioService.getDouble(json, "scale") / (vwr.tm.zmPct / 100.0));
                            this.syncScript(vwr, "Mouse: zoomByFactor " + zoomFactor);
                        }
                    }
                    break;
                }
                case 70: {
                    this.syncScript(vwr, "Mouse: " + JsonNioService.getString(json, "sync"));
                    break;
                }
                case 80: {
                    vwr.acm.processMultitouchEvent(0, JsonNioService.getInt(json, "eventType"), JsonNioService.getInt(json, "touchID"), JsonNioService.getInt(json, "iData"), P3d.new3(JsonNioService.getDouble(json, "x"), JsonNioService.getDouble(json, "y"), JsonNioService.getDouble(json, "z")), JsonNioService.getLong(json, "time"));
                }
            }
        }
    }
}

