/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.calc.SingularValueDecomposition;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import java.util.ArrayList;
import org.openmolecules.chem.conf.so.ConformationRule;
import org.openmolecules.chem.conf.so.SelfOrganizedConformer;

public class StraightLineRule
extends ConformationRule {
    public static void main(String[] stringArray) {
        int n;
        int[] nArray = new int[7];
        for (int i = 0; i < 7; ++i) {
            nArray[i] = 4 + i;
        }
        new StraightLineRule(nArray);
        StereoMolecule stereoMolecule = new IDCodeParser(true).getCompactMolecule("fkA@@@DjYfYhIbnRtZjjjjjXAPbIbDUD@");
        SelfOrganizedConformer selfOrganizedConformer = new SelfOrganizedConformer(stereoMolecule);
        for (n = 0; n < 7; ++n) {
            selfOrganizedConformer.setX(4 + n, n);
            selfOrganizedConformer.setY(4 + n, n);
            selfOrganizedConformer.setZ(4 + n, n);
        }
        selfOrganizedConformer.getCoordinates((int)5).y += 1.0;
        selfOrganizedConformer.getCoordinates((int)6).y -= 1.0;
        selfOrganizedConformer.getCoordinates((int)8).y -= 1.0;
        selfOrganizedConformer.getCoordinates((int)9).y += 1.0;
        System.out.println("------------------- you may copy and paste to DataWarrior ---------------------");
        System.out.println("p\tx\ty\tz\ttime");
        for (n = 4; n <= 10; ++n) {
            System.out.println("p" + n + "\t" + selfOrganizedConformer.getX(n) + "\t" + selfOrganizedConformer.getY(n) + "\t" + selfOrganizedConformer.getZ(n) + "\tbefore");
        }
        new StraightLineRule(nArray).apply(selfOrganizedConformer, 1.0);
        for (n = 4; n <= 10; ++n) {
            System.out.println("p" + n + "\t" + selfOrganizedConformer.getX(n) + "\t" + selfOrganizedConformer.getY(n) + "\t" + selfOrganizedConformer.getZ(n) + "\tafter");
        }
        for (n = 0; n < 7; ++n) {
            selfOrganizedConformer.setX(4 + n, n);
            selfOrganizedConformer.setY(4 + n, 0.0);
            selfOrganizedConformer.setZ(4 + n, 0.0);
        }
        selfOrganizedConformer.getCoordinates((int)5).y -= 1.0;
        selfOrganizedConformer.getCoordinates((int)6).y += 1.0;
        selfOrganizedConformer.getCoordinates((int)8).y += 1.0;
        selfOrganizedConformer.getCoordinates((int)9).y -= 1.0;
        selfOrganizedConformer.getCoordinates((int)4).z -= 1.0;
        selfOrganizedConformer.getCoordinates((int)6).z += 1.0;
        selfOrganizedConformer.getCoordinates((int)8).z += 1.0;
        selfOrganizedConformer.getCoordinates((int)10).z -= 1.0;
        System.out.println("------------------- you may copy and paste to DataWarrior ---------------------");
        System.out.println("p\tx\ty\tz\ttime");
        for (n = 4; n <= 10; ++n) {
            System.out.println("p" + n + "\t" + selfOrganizedConformer.getX(n) + "\t" + selfOrganizedConformer.getY(n) + "\t" + selfOrganizedConformer.getZ(n) + "\tbefore");
        }
        new StraightLineRule(nArray).apply(selfOrganizedConformer, 1.0);
        for (n = 4; n <= 10; ++n) {
            System.out.println("p" + n + "\t" + selfOrganizedConformer.getX(n) + "\t" + selfOrganizedConformer.getY(n) + "\t" + selfOrganizedConformer.getZ(n) + "\tafter");
        }
    }

    public StraightLineRule(int[] nArray) {
        super(nArray);
    }

    public static void calculateRules(ArrayList<ConformationRule> arrayList, StereoMolecule stereoMolecule) {
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (blArray[i] || stereoMolecule.getAtomPi(i) != 2 || stereoMolecule.getAtomicNo(i) > 8) continue;
            int[] nArray = StraightLineRule.getLineFragmentAtoms(i, stereoMolecule);
            for (int j = 0; j < nArray.length; ++j) {
                blArray[nArray[j]] = true;
            }
            if (nArray[0] == nArray[nArray.length - 1]) continue;
            arrayList.add(new StraightLineRule(nArray));
        }
    }

    private static int[] getLineFragmentAtoms(int n, StereoMolecule stereoMolecule) {
        int n2;
        int n3 = n;
        int n4 = stereoMolecule.getConnAtom(n3, 0);
        while (stereoMolecule.getAllConnAtoms(n3) != 1 && stereoMolecule.getAtomPi(n3) == 2) {
            n2 = n4;
            n4 = n3;
            if ((n3 = stereoMolecule.getConnAtom(n3, 0) == n2 ? stereoMolecule.getConnAtom(n3, 1) : stereoMolecule.getConnAtom(n3, 0)) != n) continue;
            break;
        }
        n2 = n3;
        int n5 = n4;
        int n6 = 2;
        while (stereoMolecule.getAllConnAtoms(n5) != 1 && stereoMolecule.getAtomPi(n5) == 2) {
            int n7 = n2;
            n2 = n5;
            n5 = stereoMolecule.getConnAtom(n5, 0) == n7 ? stereoMolecule.getConnAtom(n5, 1) : stereoMolecule.getConnAtom(n5, 0);
            ++n6;
            if (n5 != n3) continue;
            break;
        }
        int[] nArray = new int[n6];
        nArray[0] = n3;
        nArray[1] = n4;
        for (int i = 2; i < n6; ++i) {
            nArray[i] = stereoMolecule.getConnAtom(nArray[i - 1], 0) == nArray[i - 2] ? stereoMolecule.getConnAtom(nArray[i - 1], 1) : stereoMolecule.getConnAtom(nArray[i - 1], 0);
        }
        return nArray;
    }

    @Override
    public boolean apply(Conformer conformer, double d) {
        int n;
        int n2;
        int n3;
        double[] dArray = new double[3];
        for (n3 = 0; n3 < this.mAtom.length; ++n3) {
            dArray[0] = dArray[0] + conformer.getX(this.mAtom[n3]);
            dArray[1] = dArray[1] + conformer.getY(this.mAtom[n3]);
            dArray[2] = dArray[2] + conformer.getZ(this.mAtom[n3]);
        }
        n3 = 0;
        while (n3 < 3) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] / (double)this.mAtom.length;
        }
        double[][] dArray2 = new double[this.mAtom.length][3];
        for (int i = 0; i < this.mAtom.length; ++i) {
            dArray2[i][0] = conformer.getX(this.mAtom[i]) - dArray[0];
            dArray2[i][1] = conformer.getY(this.mAtom[i]) - dArray[1];
            dArray2[i][2] = conformer.getZ(this.mAtom[i]) - dArray[2];
        }
        double[][] dArray3 = new double[3][3];
        for (int i = 0; i < this.mAtom.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (n2 = 0; n2 < 3; ++n2) {
                    double[] dArray4 = dArray3[j];
                    int n5 = n2;
                    dArray4[n5] = dArray4[n5] + dArray2[i][j] * dArray2[i][n2];
                }
            }
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(dArray3, null, null);
        double[] dArray5 = singularValueDecomposition.getSingularValues();
        n2 = 0;
        for (int i = 1; i < 3; ++i) {
            if (!(dArray5[i] > dArray5[n2])) continue;
            n2 = i;
        }
        double[][] dArray6 = singularValueDecomposition.getU();
        double[] dArray7 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray7[i] = dArray6[i][n2];
        }
        double[] dArray8 = new double[this.mAtom.length];
        for (n = 0; n < this.mAtom.length; ++n) {
            dArray8[n] = dArray7[0] * dArray2[n][0] + dArray7[1] * dArray2[n][1] + dArray7[2] * dArray2[n][2];
        }
        if (d == 1.0) {
            n = 0;
            boolean bl = dArray8[0] < dArray8[1];
            for (int i = 2; i < this.mAtom.length; ++i) {
                if (bl == dArray8[i - 1] < dArray8[i]) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                return false;
            }
        }
        for (n = 0; n < this.mAtom.length; ++n) {
            conformer.getCoordinates(this.mAtom[n]).add(d * (dArray8[n] * dArray7[0] - dArray2[n][0]), d * (dArray8[n] * dArray7[1] - dArray2[n][1]), d * (dArray8[n] * dArray7[2] - dArray2[n][2]));
        }
        return true;
    }

    @Override
    public double addStrain(Conformer conformer, double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = new double[3];
        for (n2 = 0; n2 < this.mAtom.length; ++n2) {
            dArray2[0] = dArray2[0] + conformer.getX(this.mAtom[n2]);
            dArray2[1] = dArray2[1] + conformer.getY(this.mAtom[n2]);
            dArray2[2] = dArray2[2] + conformer.getZ(this.mAtom[n2]);
        }
        n2 = 0;
        while (n2 < 3) {
            int n3 = n2++;
            dArray2[n3] = dArray2[n3] / (double)this.mAtom.length;
        }
        double[][] dArray3 = new double[this.mAtom.length][3];
        for (int i = 0; i < this.mAtom.length; ++i) {
            dArray3[i][0] = conformer.getX(this.mAtom[i]) - dArray2[0];
            dArray3[i][1] = conformer.getY(this.mAtom[i]) - dArray2[1];
            dArray3[i][2] = conformer.getZ(this.mAtom[i]) - dArray2[2];
        }
        double[][] dArray4 = new double[3][3];
        for (int i = 0; i < this.mAtom.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (n = 0; n < 3; ++n) {
                    double[] dArray5 = dArray4[j];
                    int n4 = n;
                    dArray5[n4] = dArray5[n4] + dArray3[i][j] * dArray3[i][n];
                }
            }
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(dArray4, null, null);
        double[] dArray6 = singularValueDecomposition.getSingularValues();
        n = 0;
        for (int i = 1; i < 3; ++i) {
            if (!(dArray6[i] > dArray6[n])) continue;
            n = i;
        }
        double[][] dArray7 = singularValueDecomposition.getU();
        double[] dArray8 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray8[i] = dArray7[i][n];
        }
        double d = 0.0;
        for (int i = 0; i < this.mAtom.length; ++i) {
            double d2 = dArray8[0] * dArray3[i][0] + dArray8[1] * dArray3[i][1] + dArray8[2] * dArray3[i][2];
            double d3 = d2 * dArray8[0] - dArray3[i][0];
            double d4 = d2 * dArray8[1] - dArray3[i][1];
            double d5 = d2 * dArray8[2] - dArray3[i][2];
            double d6 = d3 * d3 + d4 * d4 + d5 * d5;
            int n5 = this.mAtom[i];
            dArray[n5] = dArray[n5] + d6;
            d += d6;
        }
        return d;
    }

    @Override
    public int getRuleType() {
        return 2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("line rule:");
        super.addAtomList(stringBuilder);
        return stringBuilder.toString();
    }
}

