/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import com.actelion.research.util.SortedList;
import com.actelion.research.util.UniqueList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.openmolecules.chem.conf.gen.RigidFragment;
import org.openmolecules.chem.conf.gen.RotatableBond;
import org.openmolecules.chem.conf.gen.TorsionSet;
import org.openmolecules.chem.conf.gen.TorsionSetEliminationRule;
import org.openmolecules.chem.conf.gen.TorsionSetStrategyRandom;

public abstract class TorsionSetStrategy {
    private static final long[] BITS = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L};
    private static final int MAX_TOTAL_COUNT = 10000;
    private static final int SECOND_CHOICE_START_FRACTION = 5;
    private static final double MAX_COLLISION_INTENSITY_BASE = 0.5;
    private static final double SECOND_CHOICE_MAX_TOLERANCE = 0.2;
    public static final double MAX_ALLOWED_COLLISION_INTENSITY = 0.7;
    protected RotatableBond[] mRotatableBond;
    protected RigidFragment[] mRigidFragment;
    private int mFragmentCount;
    private int mEncodingLongCount;
    private int mCollisionCount;
    private int mTotalCount;
    private int mMaxTotalCount;
    private int mPermutationCount;
    private boolean mUsingSecondChoices;
    private int[][][] mBondsBetweenFragments;
    private int[][] mConnFragmentNo;
    private int[][] mConnRotatableBondNo;
    private int[] mEncodingBitCount;
    private int[] mEncodingBitShift;
    private int[] mEncodingLongIndex;
    private int[] mGraphFragment;
    private int[] mGraphBond;
    private int[] mGraphParent;
    private boolean[] mGraphFragmentHandled;
    private double mLowestCollisionStrain;
    private UniqueList<TorsionSet> mTorsionSetList;
    private SortedList<TorsionSet> mSecondChoiceList;
    private ArrayList<TorsionSetEliminationRule> mEliminationRuleList;

    public TorsionSetStrategy(RotatableBond[] rotatableBondArray, RigidFragment[] rigidFragmentArray) {
        int n;
        int n2;
        int n3;
        this.mRotatableBond = rotatableBondArray;
        this.mRigidFragment = rigidFragmentArray;
        this.mFragmentCount = 0;
        for (RotatableBond n32 : this.mRotatableBond) {
            this.mFragmentCount = Math.max(this.mFragmentCount, Math.max(1 + n32.getFragmentNo(0), 1 + n32.getFragmentNo(1)));
        }
        int[] nArray = new int[this.mFragmentCount];
        RotatableBond[] n22 = this.mRotatableBond;
        int n4 = n22.length;
        for (n3 = 0; n3 < n4; ++n3) {
            Object[] objectArray = n22[n3];
            int n5 = objectArray.getFragmentNo(0);
            nArray[n5] = nArray[n5] + 1;
            int n6 = objectArray.getFragmentNo(1);
            nArray[n6] = nArray[n6] + 1;
        }
        this.mConnFragmentNo = new int[nArray.length][];
        this.mConnRotatableBondNo = new int[nArray.length][];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.mConnFragmentNo[n2] = new int[nArray[n2]];
            this.mConnRotatableBondNo[n2] = new int[nArray[n2]];
        }
        Arrays.fill(nArray, 0);
        n2 = 0;
        while (n2 < this.mRotatableBond.length) {
            n4 = this.mRotatableBond[n2].getFragmentNo(0);
            this.mConnFragmentNo[n4][nArray[n4]] = n3 = this.mRotatableBond[n2].getFragmentNo(1);
            this.mConnFragmentNo[n3][nArray[n3]] = n4;
            this.mConnRotatableBondNo[n4][nArray[n4]] = n2;
            this.mConnRotatableBondNo[n3][nArray[n3]] = n2++;
            int n7 = n4;
            nArray[n7] = nArray[n7] + 1;
            int n8 = n3;
            nArray[n8] = nArray[n8] + 1;
        }
        this.mGraphFragment = new int[this.mFragmentCount];
        this.mGraphBond = new int[this.mFragmentCount];
        this.mGraphParent = new int[this.mFragmentCount];
        this.mGraphFragmentHandled = new boolean[this.mFragmentCount];
        this.mBondsBetweenFragments = new int[this.mFragmentCount][][];
        for (n2 = 1; n2 < this.mFragmentCount; ++n2) {
            this.mBondsBetweenFragments[n2] = new int[n2][];
            for (n4 = 0; n4 < n2; ++n4) {
                this.mBondsBetweenFragments[n2][n4] = this.getRotatableBondsBetween(n2, n4);
            }
        }
        this.mPermutationCount = 1;
        this.mEncodingBitCount = new int[this.mRotatableBond.length + this.mRigidFragment.length];
        this.mEncodingBitShift = new int[this.mRotatableBond.length + this.mRigidFragment.length];
        this.mEncodingLongIndex = new int[this.mRotatableBond.length + this.mRigidFragment.length];
        n2 = 0;
        n4 = 0;
        n3 = 0;
        for (RotatableBond rotatableBond : this.mRotatableBond) {
            this.mPermutationCount *= rotatableBond.getTorsionCount();
            n = this.neededBits(rotatableBond.getTorsionCount());
            if (n2 + n <= 64) {
                this.mEncodingBitShift[n3] = n2;
                n2 += n;
            } else {
                this.mEncodingBitShift[n3] = 0;
                n2 = 0;
            }
            this.mEncodingBitCount[n3] = n;
            this.mEncodingLongIndex[n3] = ++n4;
            ++n3;
        }
        for (RigidFragment rigidFragment : this.mRigidFragment) {
            this.mPermutationCount *= rigidFragment.getConformerCount();
            n = this.neededBits(rigidFragment.getConformerCount());
            if (n2 + n <= 64) {
                this.mEncodingBitShift[n3] = n2;
                n2 += n;
            } else {
                this.mEncodingBitShift[n3] = 0;
                n2 = 0;
            }
            this.mEncodingBitCount[n3] = n;
            this.mEncodingLongIndex[n3] = ++n4;
            ++n3;
        }
        this.mEncodingLongCount = n4 + 1;
        if (this.mPermutationCount <= 0) {
            this.mPermutationCount = Integer.MAX_VALUE;
        }
        this.mEliminationRuleList = new ArrayList();
        this.mTorsionSetList = new UniqueList();
        this.mSecondChoiceList = new SortedList(Comparator.comparingDouble(object -> ((TorsionSet)object).getCollisionIntensitySum()));
        this.mCollisionCount = 0;
        this.mTotalCount = 0;
        this.mLowestCollisionStrain = 0.5;
        this.mUsingSecondChoices = false;
        this.mMaxTotalCount = Math.min(10000, this.mPermutationCount);
    }

    public int[] getBondsBetweenFragments(int n, int n2) {
        return this.mBondsBetweenFragments[n][n2];
    }

    public void setMaxTotalCount(int n) {
        this.mMaxTotalCount = Math.min(n, this.mPermutationCount);
    }

    private int neededBits(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 > 0) {
            n3 >>= 1;
            ++n2;
        }
        return n2;
    }

    public int getPermutationCount() {
        return this.mPermutationCount;
    }

    public int getFailureCount() {
        return this.mCollisionCount;
    }

    public int getTorsionSetCount() {
        return this.mTotalCount;
    }

    protected TorsionSet createTorsionSet(int[] nArray, int[] nArray2) {
        int n;
        double d = 1.0;
        for (n = 0; n < this.mRotatableBond.length; ++n) {
            d *= this.mRotatableBond[n].getTorsionLikelyhood(nArray[n]);
        }
        if (nArray2 != null) {
            for (n = 0; n < this.mRigidFragment.length; ++n) {
                d *= this.mRigidFragment[n].getConformerLikelihood(nArray2[n]);
            }
        }
        return new TorsionSet(nArray, nArray2, this.mEncodingBitShift, this.mEncodingLongIndex, d);
    }

    protected boolean isNewTorsionSet(TorsionSet torsionSet) {
        return !this.mTorsionSetList.contains(torsionSet);
    }

    public final TorsionSet getNextTorsionSet(TorsionSet torsionSet) {
        double d;
        TorsionSet torsionSet2;
        if (torsionSet != null && this.mLowestCollisionStrain > torsionSet.getCollisionIntensitySum()) {
            this.mLowestCollisionStrain = torsionSet.getCollisionIntensitySum();
        }
        if (this.mUsingSecondChoices) {
            return this.getRandomSecondChoice();
        }
        if (this.mTotalCount == this.mMaxTotalCount) {
            return null;
        }
        if (torsionSet != null && !torsionSet.isUsed() && torsionSet.getCollisionIntensitySum() != 0.0) {
            this.processCollisions(torsionSet);
            if (torsionSet.getCollisionIntensitySum() < this.mLowestCollisionStrain + 0.2) {
                this.mSecondChoiceList.add(torsionSet);
            }
            ++this.mCollisionCount;
        }
        if ((torsionSet2 = this.getSecondChoiceTorsionSet(d = this.calculateCollisionTolerance())) != null) {
            return torsionSet2;
        }
        torsionSet2 = this.createTorsionSet(torsionSet);
        while (torsionSet2 != null && this.matchesEliminationRule(torsionSet2, d)) {
            ++this.mCollisionCount;
            ++this.mTotalCount;
            this.mTorsionSetList.add(torsionSet2);
            if (this.mTotalCount == this.mMaxTotalCount) {
                return null;
            }
            d = this.calculateCollisionTolerance();
            torsionSet2 = this.getSecondChoiceTorsionSet(d);
            if (torsionSet2 != null) {
                return torsionSet2;
            }
            torsionSet2 = this.createTorsionSet(torsionSet2);
        }
        if (torsionSet2 == null) {
            if (this.mSecondChoiceList.size() != 0) {
                this.mUsingSecondChoices = true;
                while (this.mSecondChoiceList.size() != 0 && this.mSecondChoiceList.get(this.mSecondChoiceList.size() - 1).getCollisionIntensitySum() > this.mLowestCollisionStrain + 0.2) {
                    this.mSecondChoiceList.remove(this.mSecondChoiceList.size() - 1);
                }
                torsionSet2 = this.getRandomSecondChoice();
            }
            if (torsionSet2 == null) {
                // empty if block
            }
            return torsionSet2;
        }
        ++this.mTotalCount;
        this.mTorsionSetList.add(torsionSet2);
        return torsionSet2;
    }

    private TorsionSet getSecondChoiceTorsionSet(double d) {
        if (d == 0.0) {
            return null;
        }
        if (this.mSecondChoiceList.size() == 0 || this.mSecondChoiceList.get(0).getCollisionIntensitySum() > d) {
            return null;
        }
        TorsionSet torsionSet = this.mSecondChoiceList.get(0);
        this.mSecondChoiceList.remove(0);
        return torsionSet;
    }

    private TorsionSet getRandomSecondChoice() {
        if (this.mSecondChoiceList.size() == 0) {
            return null;
        }
        int n = this instanceof TorsionSetStrategyRandom ? ((TorsionSetStrategyRandom)this).getRandom().nextInt(this.mSecondChoiceList.size()) : 0;
        TorsionSet torsionSet = this.mSecondChoiceList.get(n);
        this.mSecondChoiceList.remove(n);
        return torsionSet;
    }

    public TorsionSet getBestCollidingTorsionIndexes() {
        double d = Double.MAX_VALUE;
        TorsionSet torsionSet = null;
        for (int i = 0; i < this.mTorsionSetList.size(); ++i) {
            TorsionSet torsionSet2 = this.mTorsionSetList.get(i);
            if (!(d > torsionSet2.getCollisionIntensitySum())) continue;
            d = torsionSet2.getCollisionIntensitySum();
            torsionSet = torsionSet2;
        }
        return torsionSet;
    }

    public abstract TorsionSet createTorsionSet(TorsionSet var1);

    private void processCollisions(TorsionSet torsionSet) {
        double[][] dArray = torsionSet.getCollisionIntensityMatrix();
        int[] nArray = torsionSet.getTorsionIndexes();
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] == null) continue;
            for (int j = 0; j < i; ++j) {
                if (dArray[i][j] == 0.0) continue;
                int[] nArray2 = this.mBondsBetweenFragments[i][j];
                long[] lArray = new long[this.mEncodingLongCount];
                long[] lArray2 = new long[this.mEncodingLongCount];
                for (int n : nArray2) {
                    int n2 = this.mEncodingLongIndex[n];
                    lArray2[n2] = lArray2[n2] + (long)(nArray[n] << this.mEncodingBitShift[n]);
                    int n3 = this.mEncodingLongIndex[n];
                    lArray[n3] = lArray[n3] + (BITS[this.mEncodingBitCount[n]] << this.mEncodingBitShift[n]);
                }
                boolean bl = false;
                ArrayList<TorsionSetEliminationRule> arrayList = null;
                for (TorsionSetEliminationRule torsionSetEliminationRule : this.mEliminationRuleList) {
                    if (torsionSetEliminationRule.isCovered(lArray, lArray2)) {
                        bl = true;
                        break;
                    }
                    if (!torsionSetEliminationRule.isMoreGeneral(lArray, lArray2)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<TorsionSetEliminationRule>();
                    }
                    arrayList.add(torsionSetEliminationRule);
                }
                if (bl) continue;
                if (arrayList != null) {
                    this.mEliminationRuleList.removeAll(arrayList);
                }
                this.mEliminationRuleList.add(new TorsionSetEliminationRule(lArray, lArray2, dArray[i][j]));
            }
        }
    }

    protected double[] getBondAndFragmentCollisionIntensities(TorsionSet torsionSet) {
        double[] dArray = new double[this.mRotatableBond.length + this.mRigidFragment.length];
        for (TorsionSetEliminationRule torsionSetEliminationRule : this.mEliminationRuleList) {
            if (!torsionSet.matches(torsionSetEliminationRule, 0.0)) continue;
            long[] lArray = torsionSetEliminationRule.getMask();
            for (int i = 0; i < dArray.length; ++i) {
                if ((lArray[this.mEncodingLongIndex[i]] & 1L << this.mEncodingBitShift[i]) == 0L) continue;
                int n = i;
                dArray[n] = dArray[n] + torsionSetEliminationRule.getCollisionIntensity();
            }
        }
        return dArray;
    }

    public double getContribution(TorsionSet torsionSet) {
        int n;
        double d = 1.0;
        for (n = 0; n < this.mRotatableBond.length; ++n) {
            d *= this.mRotatableBond[n].getTorsionLikelyhood(torsionSet.getTorsionIndexes()[n]);
        }
        for (n = 0; n < this.mRigidFragment.length; ++n) {
            d *= this.mRigidFragment[n].getConformerLikelihood(torsionSet.getConformerIndexes()[n]);
        }
        return d;
    }

    private boolean matchesEliminationRule(TorsionSet torsionSet, double d) {
        for (TorsionSetEliminationRule torsionSetEliminationRule : this.mEliminationRuleList) {
            if (!torsionSet.matches(torsionSetEliminationRule, d)) continue;
            return true;
        }
        return false;
    }

    public double calculateCollisionTolerance() {
        int n = this.mMaxTotalCount / 5;
        return this.mTotalCount <= n ? 0.0 : this.mLowestCollisionStrain + 0.2 * (double)(this.mTotalCount - n) / (double)(this.mMaxTotalCount - n);
    }

    private int[] getRotatableBondsBetween(int n, int n2) {
        Arrays.fill(this.mGraphFragmentHandled, false);
        this.mGraphFragment[0] = n;
        this.mGraphFragmentHandled[n] = true;
        int n3 = 0;
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j < this.mConnFragmentNo[this.mGraphFragment[i]].length; ++j) {
                int n4 = this.mConnFragmentNo[this.mGraphFragment[i]][j];
                if (n4 == n2) {
                    int n5 = 1;
                    int n6 = i;
                    while (n6 != 0) {
                        ++n5;
                        n6 = this.mGraphParent[n6];
                    }
                    int[] nArray = new int[n5];
                    nArray[0] = this.mConnRotatableBondNo[this.mGraphFragment[i]][j];
                    n5 = 1;
                    while (i != 0) {
                        nArray[n5++] = this.mGraphBond[i];
                        i = this.mGraphParent[i];
                    }
                    return nArray;
                }
                if (this.mGraphFragmentHandled[n4]) continue;
                this.mGraphFragmentHandled[n4] = true;
                this.mGraphFragment[++n3] = n4;
                this.mGraphBond[n3] = this.mConnRotatableBondNo[this.mGraphFragment[i]][j];
                this.mGraphParent[n3] = i;
            }
        }
        return null;
    }

    public String eliminationRuleString(TorsionSetEliminationRule torsionSetEliminationRule) {
        int n;
        long l;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        for (n2 = 0; n2 < this.mRotatableBond.length; ++n2) {
            if (this.mRotatableBond[n2].getTorsionCount() > 1) {
                l = BITS[this.neededBits(this.mRotatableBond[n2].getTorsionCount())] << this.mEncodingBitShift[n3];
                if ((torsionSetEliminationRule.getMask()[this.mEncodingLongIndex[n3]] & l) != 0L) {
                    n = (int)((torsionSetEliminationRule.getData()[this.mEncodingLongIndex[n3]] & l) >> this.mEncodingBitShift[n3]);
                    stringBuilder.append("rb[" + n2 + "]=" + this.mRotatableBond[n2].getTorsion(n) + "(" + (int)(100.0 * this.mRotatableBond[n2].getTorsionLikelyhood(n)) + "%) ");
                }
            }
            ++n3;
        }
        for (n2 = 0; n2 < this.mRigidFragment.length; ++n2) {
            if (this.mRigidFragment[n2].getConformerCount() > 1) {
                l = BITS[this.neededBits(this.mRigidFragment[n2].getConformerCount())] << this.mEncodingBitShift[n3];
                if ((torsionSetEliminationRule.getMask()[this.mEncodingLongIndex[n3]] & l) != 0L) {
                    n = (int)((torsionSetEliminationRule.getData()[this.mEncodingLongIndex[n3]] & l) >> this.mEncodingBitShift[n3]);
                    stringBuilder.append("f[" + n2 + "]:(" + (int)(100.0 * this.mRigidFragment[n2].getConformerLikelihood(n)) + "%) ");
                }
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public ArrayList<TorsionSetEliminationRule> getEliminationRuleList() {
        return this.mEliminationRuleList;
    }
}

