/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.forcefield.mmff.BadAtomTypeException;
import com.actelion.research.chem.forcefield.mmff.ForceFieldMMFF94;
import java.util.ArrayList;
import org.openmolecules.chem.conf.gen.ConformerGenerator;
import org.openmolecules.chem.conf.gen.RigidFragment;
import org.openmolecules.chem.conf.gen.RigidFragmentCache;
import org.openmolecules.chem.conf.so.ConformationSelfOrganizer;
import org.openmolecules.chem.conf.so.SelfOrganizedConformer;

public class RigidFragmentProvider {
    private static int MAX_CONFORMERS = 16;
    private static int MAX_ATOMS_FOR_CACHING = 32;
    private long mRandomSeed;
    private boolean mOptimizeFragments;
    private RigidFragmentCache mCache;

    public RigidFragmentProvider(long l, RigidFragmentCache rigidFragmentCache, boolean bl) {
        this.mRandomSeed = l;
        this.mCache = rigidFragmentCache;
        this.mOptimizeFragments = bl;
        if (bl) {
            this.forceFieldInitialize();
        }
    }

    public void setCache(RigidFragmentCache rigidFragmentCache) {
        this.mCache = rigidFragmentCache;
    }

    /*
     * WARNING - void declaration
     */
    public RigidFragment createFragment(StereoMolecule stereoMolecule, int[] nArray, int n) {
        Object object;
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        boolean[] blArray2 = new boolean[stereoMolecule.getAllAtoms()];
        boolean[] blArray3 = new boolean[stereoMolecule.getAllAtoms()];
        for (n4 = 0; n4 < stereoMolecule.getAllAtoms(); ++n4) {
            if (nArray[n4] != n) continue;
            blArray3[n4] = true;
            blArray[n4] = true;
            ++n6;
            ++n5;
        }
        for (n4 = 0; n4 < stereoMolecule.getAllAtoms(); ++n4) {
            if (!blArray3[n4]) continue;
            for (n3 = 0; n3 < stereoMolecule.getConnAtoms(n4); ++n3) {
                n2 = stereoMolecule.getConnAtom(n4, n3);
                if (blArray[n2]) continue;
                blArray[n2] = true;
                ++n6;
                ++n7;
            }
        }
        for (n4 = 0; n4 < stereoMolecule.getAllAtoms(); ++n4) {
            if (!blArray[n4] || blArray3[n4] || blArray2[n4]) continue;
            for (n3 = 0; n3 < stereoMolecule.getAllConnAtoms(n4); ++n3) {
                n2 = stereoMolecule.getConnAtom(n4, n3);
                if (blArray[n2]) continue;
                blArray2[n2] = true;
                blArray[n2] = true;
                ++n6;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < stereoMolecule.getAllBonds(); ++n3) {
            if (!blArray[stereoMolecule.getBondAtom(0, n3)] || !blArray[stereoMolecule.getBondAtom(1, n3)]) continue;
            ++n4;
        }
        StereoMolecule stereoMolecule2 = new StereoMolecule(n6, n4);
        stereoMolecule.copyMoleculeByAtoms(stereoMolecule2, blArray, false, null);
        stereoMolecule2.setFragment(true);
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n5 + n7];
        int[] nArray5 = new int[stereoMolecule.getAllAtoms()];
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (!blArray[i]) continue;
            if (stereoMolecule.isFlatNitrogen(i)) {
                stereoMolecule2.setAtomQueryFeature(n9, 0x10000000L, true);
            }
            if (blArray2[i]) {
                stereoMolecule2.setAtomMarker(n9, true);
            }
            if (blArray3[i] || !blArray2[i]) {
                nArray4[n10] = n9;
                nArray5[i] = n10++;
            }
            if (blArray3[i]) {
                nArray2[n8] = n9;
                ++n8;
            }
            nArray3[n9] = i;
            if (stereoMolecule2.getAtomicNo(n9) == 1) {
                stereoMolecule2.setAtomMass(n9, 2);
            }
            ++n9;
        }
        ArrayList<Object> arrayList = null;
        double[] dArray = null;
        Canonizer canonizer = null;
        String string = null;
        boolean bl2 = false;
        boolean bl3 = bl = this.mCache != null && n6 <= MAX_ATOMS_FOR_CACHING;
        if (bl) {
            int n11;
            canonizer = new Canonizer(stereoMolecule2, 512);
            for (n11 = 0; n11 < stereoMolecule2.getAtoms(); ++n11) {
                if (canonizer.getTHParity(n11) != 3) continue;
                bl = false;
                break;
            }
            for (n11 = 0; n11 < stereoMolecule2.getBonds(); ++n11) {
                if (canonizer.getEZParity(n11) != 3) continue;
                bl = false;
                break;
            }
            if (bl) {
                canonizer.setParities();
            }
        }
        if (this.mCache != null && !bl) {
            this.mCache.increaseNonCachableCount();
        }
        stereoMolecule2.setParitiesValid(0);
        if (bl) {
            bl2 = canonizer.normalizeEnantiomer();
            string = canonizer.getIDCode();
            RigidFragmentCache.CacheEntry cacheEntry = this.mCache.get(string);
            if (cacheEntry != null) {
                object = canonizer.getGraphIndexes();
                arrayList = new ArrayList<Object>();
                for (Coordinates[] nArray6 : cacheEntry.coordinates) {
                    for (int i = 0; i < stereoMolecule2.getAllAtoms(); ++i) {
                        Coordinates coordinates = nArray6[object[i]];
                        stereoMolecule2.setAtomX(i, coordinates.x);
                        stereoMolecule2.setAtomY(i, coordinates.y);
                        stereoMolecule2.setAtomZ(i, bl2 ? -coordinates.z : coordinates.z);
                    }
                    arrayList.add(new Conformer(stereoMolecule2));
                }
                dArray = cacheEntry.likelihood;
            }
        }
        if (arrayList == null) {
            int n11;
            void var27_34;
            if (this.mOptimizeFragments && !this.forceFieldAllowsOpenValences()) {
                stereoMolecule2.setFragment(false);
                ConformerGenerator.addHydrogenAtoms(stereoMolecule2);
            }
            ConformationSelfOrganizer conformationSelfOrganizer = new ConformationSelfOrganizer(stereoMolecule2, true);
            conformationSelfOrganizer.initializeConformers(this.mRandomSeed, MAX_CONFORMERS);
            arrayList = new ArrayList();
            object = conformationSelfOrganizer.getNextConformer();
            arrayList.add(object);
            SelfOrganizedConformer selfOrganizedConformer = conformationSelfOrganizer.getNextConformer();
            while (var27_34 != null) {
                arrayList.add(var27_34);
                SelfOrganizedConformer selfOrganizedConformer2 = conformationSelfOrganizer.getNextConformer();
            }
            dArray = new double[arrayList.size()];
            double d = 0.0;
            for (n11 = 0; n11 < arrayList.size(); ++n11) {
                dArray[n11] = ((SelfOrganizedConformer)arrayList.get(n11)).getLikelyhood();
                d += dArray[n11];
            }
            if (d != 0.0) {
                n11 = 0;
                while (n11 < arrayList.size()) {
                    int n12 = n11++;
                    dArray[n12] = dArray[n12] / d;
                }
            }
            if (this.mOptimizeFragments) {
                double d2 = 1.36;
                int n13 = 0;
                double d3 = Double.MAX_VALUE;
                for (Conformer conformer : arrayList) {
                    double d4 = this.forceFieldMinimize(conformer.toMolecule());
                    conformer.setEnergy(d4);
                    if (!Double.isNaN(d4)) {
                        d3 = Math.min(d3, d4);
                        ++n13;
                    }
                    conformer.copyFrom(stereoMolecule2);
                }
                double d5 = 2.0 * d2;
                for (Conformer conformer : arrayList) {
                    if (Double.isNaN(conformer.getEnergy()) || !(conformer.getEnergy() > d5)) continue;
                    conformer.setEnergy(Double.NaN);
                    --n13;
                }
                if (n13 != 0) {
                    int n14;
                    Object object2 = new double[n13];
                    double d6 = 0.0;
                    int n15 = 0;
                    for (n14 = arrayList.size() - 1; n14 >= 0; --n14) {
                        Conformer conformer = (Conformer)arrayList.get(n14);
                        if (Double.isNaN(conformer.getEnergy())) {
                            arrayList.remove(n14);
                            continue;
                        }
                        int n16 = n15++;
                        double d7 = Math.pow(10.0, (d3 - conformer.getEnergy()) / d2);
                        object2[n16] = d7;
                        d6 += d7;
                    }
                    dArray = new double[n13];
                    for (n14 = 0; n14 < n13; ++n14) {
                        dArray[n14] = (double)(object2[n14] / d6);
                    }
                }
            }
            if (bl) {
                int[] nArray6 = canonizer.getGraphIndexes();
                Coordinates[][] coordinatesArray = new Coordinates[arrayList.size()][nArray6.length];
                for (int i = 0; i < coordinatesArray.length; ++i) {
                    for (int j = 0; j < nArray6.length; ++j) {
                        Coordinates coordinates = ((Conformer)arrayList.get(i)).getCoordinates(j);
                        coordinatesArray[i][nArray6[j]] = new Coordinates(coordinates.x, coordinates.y, bl2 ? -coordinates.z : coordinates.z);
                    }
                }
                this.mCache.put(string, new RigidFragmentCache.CacheEntry(coordinatesArray, dArray));
            }
        }
        return new RigidFragment(n5, nArray2, nArray3, nArray4, nArray5, arrayList.toArray(new Conformer[0]), dArray);
    }

    public void forceFieldInitialize() {
        ForceFieldMMFF94.initialize("MMFF94s+");
    }

    public boolean forceFieldAllowsOpenValences() {
        return true;
    }

    public double forceFieldMinimize(StereoMolecule stereoMolecule) {
        try {
            ForceFieldMMFF94 forceFieldMMFF94 = new ForceFieldMMFF94(stereoMolecule, "MMFF94s+");
            forceFieldMMFF94.minimise();
            return forceFieldMMFF94.getTotalEnergy();
        }
        catch (BadAtomTypeException badAtomTypeException) {
            return Double.NaN;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Double.NaN;
        }
    }
}

