/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.VDWRadii;
import com.actelion.research.util.IntArrayComparator;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeMap;
import org.openmolecules.chem.conf.gen.RigidFragment;
import org.openmolecules.chem.conf.gen.RigidFragmentCache;
import org.openmolecules.chem.conf.gen.RigidFragmentProvider;
import org.openmolecules.chem.conf.gen.RotatableBond;
import org.openmolecules.chem.conf.gen.TorsionSet;
import org.openmolecules.chem.conf.gen.TorsionSetStrategy;
import org.openmolecules.chem.conf.gen.TorsionSetStrategyAdaptiveRandom;
import org.openmolecules.chem.conf.gen.TorsionSetStrategyLikelySystematic;
import org.openmolecules.chem.conf.gen.TorsionSetStrategyRandom;
import org.openmolecules.chem.conf.so.ConformationSelfOrganizer;
import org.openmolecules.chem.conf.so.SelfOrganizedConformer;

public class ConformerGenerator {
    public static final int STRATEGY_LIKELY_SYSTEMATIC = 1;
    public static final int STRATEGY_PURE_RANDOM = 2;
    public static final int STRATEGY_LIKELY_RANDOM = 3;
    public static final int STRATEGY_ADAPTIVE_RANDOM = 4;
    protected static final double VDW_TOLERANCE_HYDROGEN = 0.8;
    protected static final double VDW_TOLERANCE_OTHER = 0.8;
    private static final int ESCAPE_ANGLE = 8;
    private static final int ESCAPE_STEPS = 4;
    private static final double MIN_ESCAPE_GAIN_PER_STEP = 0.05;
    private StereoMolecule mMolecule;
    private TreeMap<int[], Conformer> mBaseConformerMap;
    private RotatableBond[] mRotatableBond;
    private RigidFragment[] mRigidFragment;
    private ConformationSelfOrganizer mSelfOrganizer;
    private RigidFragmentProvider mRigidFragmentProvider;
    private TorsionSetStrategy mTorsionSetStrategy;
    private TorsionSet mTorsionSet;
    private long mRandomSeed;
    private int mDisconnectedFragmentCount;
    private int mConformerCount;
    private boolean mUseSelfOrganizerIfAllFails;
    private double mContribution;
    private int[] mFragmentNo;
    private int[] mDisconnectedFragmentNo;
    private int[] mDisconnectedFragmentSize;
    private boolean[][] mSkipCollisionCheck;
    private Random mRandom;
    private ThreadMaster mThreadMaster;
    public static final boolean PRINT_TORSION_AND_FRAGMENT_LIKELYHOODS = false;
    public static final boolean PRINT_DEBUG_INDEXES = false;
    public static final boolean PRINT_EXIT_REASON = false;
    public static final boolean PRINT_ELIMINATION_RULES_WITH_STRUCTURES = false;
    public static final String DW_FRAGMENTS_FILE = "/home/thomas/data/debug/conformationGeneratorFragments.dwar";
    public String mDiagnosticCollisionString;
    public String mDiagnosticTorsionString;
    public int[] mDiagnosticCollisionAtoms;
    public static boolean WRITE_DW_FRAGMENT_FILE = false;

    public static void addHydrogenAtoms(StereoMolecule stereoMolecule) {
        int n;
        boolean bl = (stereoMolecule.getHelperArrayStatus() & 8) != 0;
        stereoMolecule.ensureHelperArrays(1);
        int[] nArray = new int[stereoMolecule.getAtoms()];
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            nArray[i] = stereoMolecule.getImplicitHydrogens(i);
        }
        double d = 0.8 * stereoMolecule.getAverageBondLength();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            for (int i = 0; i < nArray[n]; ++i) {
                stereoMolecule.addBond(n, stereoMolecule.addAtom(1), 1);
            }
        }
        stereoMolecule.ensureHelperArrays(1);
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            ConformerGenerator.setHydrogenLocations(stereoMolecule, n, nArray[n], d);
        }
        if (bl) {
            stereoMolecule.setParitiesValid(0);
        }
    }

    private static void setHydrogenLocations(StereoMolecule stereoMolecule, int n, int n2, double d) {
        int n3;
        int n4 = stereoMolecule.getAllConnAtoms(n) - n2;
        int n5 = -1;
        double d2 = Double.NaN;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!stereoMolecule.isStereoBond(stereoMolecule.getConnBond(n, n3), n)) continue;
            n5 = n3;
            d2 = stereoMolecule.getBondAngle(n, stereoMolecule.getConnAtom(n, n3));
            break;
        }
        n3 = n5 == -1 ? 0 : 1;
        double[] dArray = null;
        if (n3 < n4) {
            dArray = new double[n4 - n3];
            int n6 = 0;
            for (int i = 0; i < n4; ++i) {
                if (i == n5) continue;
                dArray[n6++] = stereoMolecule.getBondAngle(n, stereoMolecule.getConnAtom(n, i));
            }
            Arrays.sort(dArray);
        }
        double d3 = Math.PI * 2 / (double)Math.max(n2, 3);
        double d4 = 0.0;
        if (dArray != null) {
            if (dArray.length == 1 && n2 == 1) {
                d4 = dArray[0];
            } else {
                double d5 = 0.0;
                for (int i = 0; i < dArray.length; ++i) {
                    double d6 = dArray[i];
                    double d7 = i == 0 ? dArray[dArray.length - 1] - Math.PI * 2 : dArray[i - 1];
                    if (!(d5 < d6 - d7)) continue;
                    d5 = d6 - d7;
                    d4 = d7;
                }
                d3 = d5 / (double)(n2 + 1);
            }
        }
        for (int i = 0; i < n2; ++i) {
            double d8;
            double d9 = d4 += d3;
            if (n3 != 0 && Math.abs(d8 = Molecule.getAngleDif(d9, d2)) < d3 / 2.0) {
                d9 = d8 < 0.0 ? d2 - d3 / 2.0 : d2 + d3 / 2.0;
            }
            int n7 = stereoMolecule.getConnAtom(n, n4 + i);
            stereoMolecule.setAtomX(n7, stereoMolecule.getAtomX(n) + d * Math.sin(d9));
            stereoMolecule.setAtomY(n7, stereoMolecule.getAtomY(n) + d * Math.cos(d9));
        }
    }

    public static double getToleratedVDWRadius(int n) {
        float f = VDWRadii.VDW_RADIUS[n < VDWRadii.VDW_RADIUS.length ? n : 6];
        return (double)f * (n == 1 ? 0.8 : 0.8);
    }

    public ConformerGenerator() {
        this(0L, RigidFragmentCache.getDefaultInstance(), false);
    }

    public ConformerGenerator(long l, boolean bl) {
        this(l, RigidFragmentCache.getDefaultInstance(), bl);
    }

    public ConformerGenerator(boolean bl) {
        this(0L, RigidFragmentCache.getDefaultInstance(), bl);
    }

    public ConformerGenerator(long l, RigidFragmentCache rigidFragmentCache, boolean bl) {
        TorsionDB.initialize(1);
        this.mRandomSeed = l;
        this.mRandom = l == 0L ? new Random() : new Random(l);
        this.mRigidFragmentProvider = new RigidFragmentProvider(l, rigidFragmentCache, bl);
    }

    public ConformerGenerator(long l, RigidFragmentProvider rigidFragmentProvider) {
        TorsionDB.initialize(1);
        this.mRandomSeed = l;
        this.mRandom = l == 0L ? new Random() : new Random(l);
        this.mRigidFragmentProvider = rigidFragmentProvider;
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.mThreadMaster = threadMaster;
    }

    public StereoMolecule getOneConformerAsMolecule(StereoMolecule stereoMolecule) {
        Conformer conformer = this.getOneConformer(stereoMolecule);
        return conformer == null ? null : conformer.toMolecule(stereoMolecule);
    }

    public Conformer getOneConformer(StereoMolecule stereoMolecule) {
        if (!this.initialize(stereoMolecule, false)) {
            return null;
        }
        if (this.mRotatableBond != null) {
            this.mTorsionSetStrategy = new TorsionSetStrategyAdaptiveRandom(this.mRotatableBond, this.mRigidFragment, true, true, this.mRandomSeed);
            this.mTorsionSetStrategy.setMaxTotalCount(400);
            this.mBaseConformerMap = new TreeMap(new IntArrayComparator());
            return this.getNextConformer();
        }
        ConformationSelfOrganizer conformationSelfOrganizer = new ConformationSelfOrganizer(stereoMolecule, true);
        SelfOrganizedConformer selfOrganizedConformer = conformationSelfOrganizer.generateOneConformer(this.mRandomSeed);
        this.separateDisconnectedFragments(selfOrganizedConformer);
        return selfOrganizedConformer;
    }

    protected boolean initialize(StereoMolecule stereoMolecule, boolean bl) {
        int n;
        this.mSelfOrganizer = null;
        stereoMolecule.ensureHelperArrays(1);
        for (int i = 0; i < stereoMolecule.getAtoms(); ++i) {
            if (stereoMolecule.getOccupiedValence(i) <= stereoMolecule.getMaxValence(i)) continue;
            return false;
        }
        ConformerGenerator.addHydrogenAtoms(stereoMolecule);
        stereoMolecule.setHydrogenProtection(true);
        int[] nArray = null;
        int[] nArray2 = null;
        boolean[] blArray = null;
        boolean[] blArray2 = null;
        if ((stereoMolecule.getHelperArrayStatus() & 8) != 0) {
            nArray = new int[stereoMolecule.getAtoms()];
            blArray = new boolean[stereoMolecule.getAtoms()];
            for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                nArray[n] = stereoMolecule.getAtomParity(n);
                blArray[n] = stereoMolecule.isAtomParityPseudo(n);
            }
            nArray2 = new int[stereoMolecule.getBonds()];
            blArray2 = new boolean[stereoMolecule.getBonds()];
            for (n = 0; n < stereoMolecule.getBonds(); ++n) {
                nArray2[n] = stereoMolecule.getBondParity(n);
                blArray2[n] = stereoMolecule.isBondParityPseudo(n);
            }
        }
        stereoMolecule.ensureHelperArrays(63);
        if (nArray != null) {
            for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                stereoMolecule.setAtomParity(n, nArray[n], blArray[n]);
            }
            for (n = 0; n < stereoMolecule.getBonds(); ++n) {
                stereoMolecule.setBondParity(n, nArray2[n], blArray2[n]);
            }
        }
        this.mMolecule = stereoMolecule;
        this.mConformerCount = 0;
        this.mTorsionSet = null;
        this.mRotatableBond = null;
        this.mDisconnectedFragmentNo = new int[stereoMolecule.getAllAtoms()];
        this.mDisconnectedFragmentCount = stereoMolecule.getFragmentNumbers(this.mDisconnectedFragmentNo, false, true);
        this.mDisconnectedFragmentSize = new int[this.mDisconnectedFragmentCount];
        for (n = 0; n < stereoMolecule.getAllAtoms(); ++n) {
            int n2 = this.mDisconnectedFragmentNo[n];
            this.mDisconnectedFragmentSize[n2] = this.mDisconnectedFragmentSize[n2] + 1;
        }
        boolean[] blArray3 = new boolean[stereoMolecule.getAllBonds()];
        int n3 = TorsionDB.findRotatableBonds(stereoMolecule, true, blArray3);
        if (n3 == 0) {
            return true;
        }
        if (!this.locateInitialFragments(blArray3)) {
            return false;
        }
        this.mRotatableBond = new RotatableBond[n3];
        int n4 = 0;
        for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
            if (!blArray3[i]) continue;
            this.mRotatableBond[n4++] = new RotatableBond(stereoMolecule, i, this.mFragmentNo, this.mDisconnectedFragmentNo, this.mDisconnectedFragmentSize[this.mDisconnectedFragmentNo[stereoMolecule.getBondAtom(0, i)]], this.mRigidFragment, this.mRandom, bl);
        }
        Arrays.sort(this.mRotatableBond, (rotatableBond, rotatableBond2) -> Integer.compare(rotatableBond2.getSmallerSideAtomCount(), rotatableBond.getSmallerSideAtomCount()));
        this.initializeCollisionCheck();
        return true;
    }

    public int getRotatableBondCount() {
        return this.mRotatableBond == null ? 0 : this.mRotatableBond.length;
    }

    private Conformer getBaseConformer(int[] nArray) {
        Conformer conformer = this.mBaseConformerMap.get(nArray);
        if (conformer != null) {
            return conformer;
        }
        conformer = new Conformer(this.mMolecule);
        boolean[] blArray = new boolean[this.mRigidFragment.length];
        RotatableBond[] rotatableBondArray = this.mRotatableBond;
        int n = rotatableBondArray.length;
        for (int i = 0; i < n; ++i) {
            RotatableBond rotatableBond = rotatableBondArray[i];
            rotatableBond.connectFragments(conformer, blArray, nArray);
        }
        for (int i = 0; i < this.mRigidFragment.length; ++i) {
            if (blArray[i]) continue;
            for (n = 0; n < this.mRigidFragment[i].getCoreSize(); ++n) {
                conformer.setCoordinates(this.mRigidFragment[i].coreToOriginalAtom(n), this.mRigidFragment[i].getCoreCoordinates(nArray[i], n));
            }
        }
        this.mBaseConformerMap.put(nArray, conformer);
        return conformer;
    }

    public StereoMolecule getNextConformerAsMolecule(StereoMolecule stereoMolecule) {
        Conformer conformer = this.getNextConformer();
        return conformer == null ? null : conformer.toMolecule(stereoMolecule);
    }

    public Conformer getNextConformer() {
        return this.getNextConformer(null);
    }

    public Conformer getNextConformer(TorsionSet[] torsionSetArray) {
        if (this.mRotatableBond == null && this.mSelfOrganizer == null) {
            return null;
        }
        if (this.mSelfOrganizer != null) {
            SelfOrganizedConformer selfOrganizedConformer = this.mSelfOrganizer.getNextConformer();
            if (selfOrganizedConformer != null) {
                this.separateDisconnectedFragments(selfOrganizedConformer);
                ++this.mConformerCount;
                return selfOrganizedConformer;
            }
            return null;
        }
        if (this.mBaseConformerMap == null) {
            return null;
        }
        if (this.mBaseConformerMap.size() == 0) {
            this.getBaseConformer(new int[this.mRigidFragment.length]);
        }
        this.mTorsionSet = this.mTorsionSetStrategy.getNextTorsionSet(this.mTorsionSet);
        while (!(this.mTorsionSet == null || this.mThreadMaster != null && this.mThreadMaster.threadMustDie())) {
            int n;
            Conformer conformer = new Conformer(this.getBaseConformer(this.mTorsionSet.getConformerIndexes()));
            for (n = this.mRotatableBond.length - 1; n >= 0; --n) {
                this.mRotatableBond[n].rotateToIndex(conformer, this.mTorsionSet.getTorsionIndexes()[n]);
            }
            if (WRITE_DW_FRAGMENT_FILE) {
                this.mDiagnosticTorsionString = "" + this.mTorsionSet.getTorsionIndexes()[0];
                for (n = 1; n < this.mTorsionSet.getTorsionIndexes().length; ++n) {
                    this.mDiagnosticTorsionString = this.mDiagnosticTorsionString + ":" + this.mTorsionSet.getTorsionIndexes()[n];
                }
                this.mDiagnosticTorsionString = this.mDiagnosticTorsionString + "<->" + this.mTorsionSet.getConformerIndexes()[0];
                for (n = 1; n < this.mTorsionSet.getConformerIndexes().length; ++n) {
                    this.mDiagnosticTorsionString = this.mDiagnosticTorsionString + ":" + this.mTorsionSet.getConformerIndexes()[n];
                }
            }
            if (this.mTorsionSet.getCollisionIntensitySum() == 0.0) {
                this.checkCollision(conformer, this.mTorsionSet);
            }
            if (this.mTorsionSet.getCollisionIntensitySum() != 0.0) {
                this.tryFixCollisions(conformer, this.mTorsionSet);
            }
            if (this.mTorsionSet.getCollisionIntensitySum() > this.mTorsionSetStrategy.calculateCollisionTolerance()) {
                this.mTorsionSet = this.mTorsionSetStrategy.getNextTorsionSet(this.mTorsionSet);
                if (this.mTorsionSet != null || this.mConformerCount != 0) continue;
                if (this.mUseSelfOrganizerIfAllFails) {
                    this.mSelfOrganizer = new ConformationSelfOrganizer(this.mMolecule, true);
                    this.mSelfOrganizer.setThreadMaster(this.mThreadMaster);
                    this.mSelfOrganizer.initializeConformers(this.mRandomSeed, -1);
                    conformer = this.mSelfOrganizer.getNextConformer();
                    if (conformer != null) {
                        this.separateDisconnectedFragments(conformer);
                        ++this.mConformerCount;
                        return conformer;
                    }
                }
                this.mTorsionSet = this.mTorsionSetStrategy.getBestCollidingTorsionIndexes();
                conformer = new Conformer(this.getBaseConformer(this.mTorsionSet.getConformerIndexes()));
                for (int i = this.mRotatableBond.length - 1; i >= 0; --i) {
                    this.mRotatableBond[i].rotateToIndex(conformer, this.mTorsionSet.getTorsionIndexes()[i]);
                }
                this.mBaseConformerMap = null;
            }
            this.separateDisconnectedFragments(conformer);
            this.mContribution = this.mTorsionSetStrategy.getContribution(this.mTorsionSet);
            this.mTorsionSet.setUsed();
            ++this.mConformerCount;
            if (torsionSetArray != null) {
                torsionSetArray[0] = new TorsionSet(this.mTorsionSet);
            }
            return conformer;
        }
        return null;
    }

    public int getConformerCount() {
        return this.mConformerCount;
    }

    public int getPotentialConformerCount() {
        return this.mTorsionSetStrategy == null ? 1 : this.mTorsionSetStrategy.getPermutationCount();
    }

    public double getPreviousConformerContribution() {
        return this.mRotatableBond == null ? 1.0 : this.mContribution;
    }

    public void setUseSelfOrganizerIfAllFails(boolean bl) {
        this.mUseSelfOrganizerIfAllFails = bl;
    }

    public boolean initializeConformers(StereoMolecule stereoMolecule) {
        return this.initializeConformers(stereoMolecule, 3, 100000, false);
    }

    public boolean initializeConformers(StereoMolecule stereoMolecule, int n, int n2, boolean bl) {
        if (!this.initialize(stereoMolecule, bl)) {
            return false;
        }
        if (this.mRotatableBond == null) {
            this.mSelfOrganizer = new ConformationSelfOrganizer(stereoMolecule, true);
            this.mSelfOrganizer.setThreadMaster(this.mThreadMaster);
            this.mSelfOrganizer.initializeConformers(this.mRandomSeed, -1);
        } else {
            switch (n) {
                case 2: {
                    this.mTorsionSetStrategy = new TorsionSetStrategyRandom(this.mRotatableBond, this.mRigidFragment, false, this.mRandomSeed);
                    break;
                }
                case 3: {
                    this.mTorsionSetStrategy = new TorsionSetStrategyRandom(this.mRotatableBond, this.mRigidFragment, true, this.mRandomSeed);
                    break;
                }
                case 4: {
                    this.mTorsionSetStrategy = new TorsionSetStrategyAdaptiveRandom(this.mRotatableBond, this.mRigidFragment, true, true, this.mRandomSeed);
                    break;
                }
                case 1: {
                    this.mTorsionSetStrategy = new TorsionSetStrategyLikelySystematic(this.mRotatableBond, this.mRigidFragment);
                }
            }
            this.mTorsionSetStrategy.setMaxTotalCount(n2);
            this.mBaseConformerMap = new TreeMap(new IntArrayComparator());
        }
        return true;
    }

    private void separateDisconnectedFragments(Conformer conformer) {
        if (this.mDisconnectedFragmentCount > 1) {
            int n;
            int n2;
            double[] dArray = new double[this.mDisconnectedFragmentCount];
            double[] dArray2 = new double[this.mDisconnectedFragmentCount];
            double[] dArray3 = new double[this.mDisconnectedFragmentCount];
            double[] dArray4 = new double[this.mDisconnectedFragmentCount];
            for (n2 = 0; n2 < this.mDisconnectedFragmentCount; ++n2) {
                dArray3[n2] = 1.0E9;
                dArray4[n2] = -1.0E9;
            }
            for (n2 = 0; n2 < conformer.getSize(); ++n2) {
                int n3 = this.mDisconnectedFragmentNo[n2];
                dArray[n3] = dArray[n3] + conformer.getX(n2);
                int n4 = this.mDisconnectedFragmentNo[n2];
                dArray2[n4] = dArray2[n4] + conformer.getY(n2);
                if (dArray3[this.mDisconnectedFragmentNo[n2]] > conformer.getZ(n2)) {
                    dArray3[this.mDisconnectedFragmentNo[n2]] = conformer.getZ(n2);
                }
                if (!(dArray4[this.mDisconnectedFragmentNo[n2]] < conformer.getZ(n2))) continue;
                dArray4[this.mDisconnectedFragmentNo[n2]] = conformer.getZ(n2);
            }
            for (n2 = 0; n2 < this.mDisconnectedFragmentCount; ++n2) {
                int n5 = n2;
                dArray[n5] = dArray[n5] / (double)this.mDisconnectedFragmentSize[n2];
                int n6 = n2;
                dArray2[n6] = dArray2[n6] / (double)this.mDisconnectedFragmentSize[n2];
            }
            double[] dArray5 = new double[this.mDisconnectedFragmentCount];
            double[] dArray6 = new double[this.mDisconnectedFragmentCount];
            double[] dArray7 = new double[this.mDisconnectedFragmentCount];
            for (n = 1; n < this.mDisconnectedFragmentCount; ++n) {
                dArray5[n] = dArray[0] - dArray[n];
                dArray6[n] = dArray2[0] - dArray2[n];
                dArray7[n] = dArray7[n - 1] + dArray4[n - 1] - dArray3[n] + 3.0;
            }
            for (n = 0; n < conformer.getSize(); ++n) {
                if (this.mDisconnectedFragmentNo[n] == 0) continue;
                Coordinates coordinates = conformer.getCoordinates(n);
                coordinates.x += dArray5[this.mDisconnectedFragmentNo[n]];
                coordinates.y += dArray6[this.mDisconnectedFragmentNo[n]];
                coordinates.z += dArray7[this.mDisconnectedFragmentNo[n]];
            }
        }
    }

    private boolean locateInitialFragments(boolean[] blArray) {
        this.mFragmentNo = new int[this.mMolecule.getAllAtoms()];
        int n = this.mMolecule.getFragmentNumbers(this.mFragmentNo, blArray, true);
        this.mRigidFragment = new RigidFragment[n];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            this.mRigidFragment[i] = this.mRigidFragmentProvider.createFragment(this.mMolecule, this.mFragmentNo, i);
            bl &= this.mRigidFragment[i] != null;
        }
        return bl;
    }

    private void initializeCollisionCheck() {
        int n;
        int n2;
        this.mSkipCollisionCheck = new boolean[this.mMolecule.getAllAtoms()][];
        for (int i = 1; i < this.mMolecule.getAllAtoms(); ++i) {
            this.mSkipCollisionCheck[i] = new boolean[i];
        }
        RigidFragment[] rigidFragmentArray = this.mRigidFragment;
        int n3 = rigidFragmentArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            RigidFragment rigidFragment = rigidFragmentArray[n2];
            for (int i = 1; i < rigidFragment.getExtendedSize(); ++i) {
                for (int j = 0; j < i; ++j) {
                    this.skipCollisionCheck(rigidFragment.extendedToOriginalAtom(i), rigidFragment.extendedToOriginalAtom(j));
                }
            }
        }
        for (n = 0; n < this.mMolecule.getAtoms(); ++n) {
            for (n3 = 1; n3 < this.mMolecule.getAllConnAtoms(n); ++n3) {
                for (n2 = 0; n2 < n3; ++n2) {
                    this.skipCollisionCheck(this.mMolecule.getConnAtom(n, n3), this.mMolecule.getConnAtom(n, n2));
                }
            }
        }
        if (this.mDisconnectedFragmentNo != null) {
            for (n = 1; n < this.mMolecule.getAllAtoms(); ++n) {
                for (n3 = 0; n3 < n; ++n3) {
                    if (this.mDisconnectedFragmentNo[n] == this.mDisconnectedFragmentNo[n3]) continue;
                    this.mSkipCollisionCheck[n][n3] = true;
                }
            }
        }
    }

    private void skipCollisionCheck(int n, int n2) {
        if (n < n2) {
            this.mSkipCollisionCheck[n2][n] = true;
        } else {
            this.mSkipCollisionCheck[n][n2] = true;
        }
    }

    private boolean checkCollision(Conformer conformer, TorsionSet torsionSet) {
        this.mDiagnosticCollisionString = "";
        this.mDiagnosticCollisionAtoms = null;
        double d = 0.0;
        Object object = null;
        StereoMolecule stereoMolecule = conformer.getMolecule();
        for (int i = 1; i < stereoMolecule.getAllAtoms(); ++i) {
            double d2 = ConformerGenerator.getToleratedVDWRadius(stereoMolecule.getAtomicNo(i));
            for (int j = 0; j < i; ++j) {
                int n;
                int n2;
                double d3;
                double d4;
                double d5;
                if (this.mSkipCollisionCheck[i][j]) continue;
                double d6 = d2 + ConformerGenerator.getToleratedVDWRadius(stereoMolecule.getAtomicNo(j));
                double d7 = Math.abs(conformer.getX(i) - conformer.getX(j));
                if (!(d7 < d6) || !((d5 = Math.abs(conformer.getY(i) - conformer.getY(j))) < d6) || !((d4 = Math.abs(conformer.getZ(i) - conformer.getZ(j))) < d6) || !((d3 = Math.sqrt(d7 * d7 + d5 * d5 + d4 * d4)) < d6)) continue;
                double d8 = (d6 - d3) / d6;
                double d9 = d8 * d8;
                d += d9;
                if (WRITE_DW_FRAGMENT_FILE) {
                    if (this.mDiagnosticCollisionString.length() != 0) {
                        this.mDiagnosticCollisionString = this.mDiagnosticCollisionString + "<NL>";
                    }
                    this.mDiagnosticCollisionString = this.mDiagnosticCollisionString + "a1:" + i + " f1:" + this.mFragmentNo[i] + " a2:" + j + " f2:" + this.mFragmentNo[j] + " distance:" + d3 + " min:" + d6;
                    if (this.mDiagnosticCollisionAtoms == null) {
                        this.mDiagnosticCollisionAtoms = new int[2];
                        this.mDiagnosticCollisionAtoms[0] = i;
                        this.mDiagnosticCollisionAtoms[1] = j;
                    }
                }
                if (object == null) {
                    object = new double[this.mRigidFragment.length][];
                }
                if ((n2 = this.mFragmentNo[i]) < (n = this.mFragmentNo[j])) {
                    if (object[n] == null) {
                        object[n] = new double[n];
                    }
                    double[] dArray = object[n];
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + d9;
                    continue;
                }
                if (object[n2] == null) {
                    object[n2] = new double[n2];
                }
                double[] dArray = object[n2];
                int n4 = n;
                dArray[n4] = dArray[n4] + d9;
            }
        }
        torsionSet.setCollisionIntensity(d, (double[][])object);
        return d != 0.0;
    }

    private boolean tryFixCollisions(Conformer conformer, TorsionSet torsionSet) {
        int n;
        if (this.mThreadMaster != null && this.mThreadMaster.threadMustDie()) {
            return false;
        }
        double[][] dArray = torsionSet.getCollisionIntensityMatrix();
        double d = 0.0;
        for (n = 1; n < dArray.length; ++n) {
            if (dArray[n] == null) continue;
            for (int i = 0; i < n; ++i) {
                if (dArray[n][i] == 0.0 || this.mTorsionSetStrategy.getBondsBetweenFragments(n, i).length == 2) continue;
                d += dArray[n][i];
            }
        }
        if (d > 0.7) {
            return false;
        }
        n = 0;
        Conformer conformer2 = null;
        Conformer conformer3 = null;
        double d2 = torsionSet.getCollisionIntensitySum();
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] == null) continue;
            block3: for (int j = 0; j < i; ++j) {
                if (!(dArray[i][j] > 0.05) || this.mTorsionSetStrategy.getBondsBetweenFragments(i, j).length != 2) continue;
                int[] nArray = this.mTorsionSetStrategy.getBondsBetweenFragments(i, j);
                int n2 = this.mRandom.nextDouble() < 0.5 ? -8 : 8;
                double d3 = dArray[i][j];
                for (int k = 1; k <= 4; ++k) {
                    if (conformer2 == null) {
                        conformer2 = new Conformer(conformer);
                    } else if (conformer3 == null) {
                        conformer3 = new Conformer(conformer2);
                    } else {
                        conformer3.copyFrom(conformer2);
                    }
                    for (int n3 : nArray) {
                        this.mRotatableBond[n3].rotateTo(conformer2, (short)(conformer2.getBondTorsion(n3) + k * n2));
                    }
                    double d4 = this.calculateCollisionIntensity(conformer2, this.mRigidFragment[i], this.mRigidFragment[j]);
                    if (d4 < d3 - 0.05) {
                        d3 = d4;
                        n = 1;
                        if (!(d4 < 0.05)) continue;
                        continue block3;
                    }
                    if (conformer3 != null) {
                        conformer2.copyFrom(conformer3);
                        continue block3;
                    }
                    conformer2.copyFrom(conformer);
                    continue block3;
                }
            }
        }
        if (n == 0) {
            return false;
        }
        this.checkCollision(conformer2, torsionSet);
        if (torsionSet.getCollisionIntensitySum() >= d2) {
            torsionSet.setCollisionIntensity(d2, dArray);
            return false;
        }
        conformer.copyFrom(conformer2);
        return true;
    }

    private double calculateCollisionIntensity(Conformer conformer, RigidFragment rigidFragment, RigidFragment rigidFragment2) {
        double d = 0.0;
        for (int i = 0; i < rigidFragment.getCoreSize(); ++i) {
            int n = rigidFragment.coreToOriginalAtom(i);
            double d2 = ConformerGenerator.getToleratedVDWRadius(this.mMolecule.getAtomicNo(n));
            for (int j = 0; j < rigidFragment2.getCoreSize(); ++j) {
                double d3;
                double d4;
                double d5;
                int n2 = rigidFragment2.coreToOriginalAtom(j);
                double d6 = d2 + ConformerGenerator.getToleratedVDWRadius(this.mMolecule.getAtomicNo(n2));
                double d7 = Math.abs(conformer.getX(n) - conformer.getX(n2));
                if (!(d7 < d6) || !((d5 = Math.abs(conformer.getY(n) - conformer.getY(n2))) < d6) || !((d4 = Math.abs(conformer.getZ(n) - conformer.getZ(n2))) < d6) || !((d3 = Math.sqrt(d7 * d7 + d5 * d5 + d4 * d4)) < d6)) continue;
                double d8 = (d6 - d3) / d6;
                double d9 = d8 * d8;
                d += d9;
            }
        }
        return d;
    }

    public Conformer generateConformerFromTorsionSet(TorsionSet torsionSet) {
        return this.generateConformerFromTorsionSet(torsionSet.getConformerIndexes(), torsionSet.getTorsionIndexes());
    }

    private Conformer generateConformerFromTorsionSet(int[] nArray, int[] nArray2) {
        Conformer conformer = new Conformer(this.getBaseConformer(nArray));
        for (int i = this.mRotatableBond.length - 1; i >= 0; --i) {
            Conformer conformer2 = new Conformer(conformer);
            this.mRotatableBond[i].rotateToIndex(conformer2, nArray2[i]);
        }
        this.separateDisconnectedFragments(conformer);
        return conformer;
    }
}

