/*
 * Decompiled with CFR 0.152.
 */
package org.nmrml.parser;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.nmrml.parser.Acqu;

public class BinaryData {
    private byte[] data;
    private int encodedLength;
    private String byteFormat;
    private boolean exists = false;
    private boolean compressed = false;
    private boolean crossvalues = true;
    private String sha1;
    private static final int tInteger = 1;
    private static final int tLong = 2;
    private static final int tFloat = 3;
    private static final int tDouble = 4;
    private static final Map<String, int[]> hByteFormat = new HashMap<String, int[]>();

    public int[] getEncodedSize() {
        return hByteFormat.get(this.getByteFormat());
    }

    private String convertToHex(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int x;
            if (i % 4 == 0 && i != 0) {
                buffer.append("");
            }
            if ((x = data[i]) < 0) {
                x += 256;
            }
            if (x < 16) {
                buffer.append("0");
            }
            buffer.append(Integer.toString(x, 16));
        }
        return buffer.toString();
    }

    public int getEncodedLength() {
        if (this.encodedLength == 0) {
            this.encodedLength = Base64.getEncoder().encode(this.getData()).length;
        }
        return this.encodedLength;
    }

    public void setEncodedLength(int encodedLength) {
        this.encodedLength = encodedLength;
    }

    public String getByteFormat() {
        return this.byteFormat;
    }

    public void setByteFormat(String byteFormat) {
        this.byteFormat = byteFormat;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCrossVallues(boolean crossvalues) {
        this.crossvalues = crossvalues;
    }

    public boolean isCrossVallues() {
        return this.crossvalues;
    }

    public double[] getDataAsDouble(ByteOrder ... byteOrder) {
        int[] encoded = this.getEncodedSize();
        int encodedSize = encoded[0];
        double[] doubles = new double[this.data.length / encodedSize];
        int ndatalen = doubles.length / 2;
        block6: for (int i = 0; i < doubles.length; ++i) {
            ByteBuffer buffer = ByteBuffer.wrap(this.data, i * encodedSize, encodedSize);
            int j = i;
            if (!this.isCrossVallues()) {
                j = i < ndatalen ? 2 * i : 2 * (i - ndatalen) + 1;
            }
            buffer.order(byteOrder.length > 0 ? byteOrder[0] : ByteOrder.LITTLE_ENDIAN);
            switch (encoded[2]) {
                case 1: {
                    doubles[j] = buffer.getInt();
                    continue block6;
                }
                case 2: {
                    doubles[j] = buffer.getLong();
                    continue block6;
                }
                case 3: {
                    doubles[j] = buffer.getFloat();
                    continue block6;
                }
                case 4: {
                    doubles[j] = buffer.getDouble();
                }
            }
        }
        return doubles;
    }

    public int[] toInt(byte[] buf, ByteOrder byteOrder) {
        int[] intArr = new int[buf.length / 4];
        int offset = 0;
        for (int i = 0; i < intArr.length; ++i) {
            intArr[i] = byteOrder.equals(ByteOrder.BIG_ENDIAN) ? buf[3 + offset] & 0xFF | (buf[2 + offset] & 0xFF) << 8 | (buf[1 + offset] & 0xFF) << 16 | (buf[0 + offset] & 0xFF) << 24 : buf[0 + offset] & 0xFF | (buf[1 + offset] & 0xFF) << 8 | (buf[2 + offset] & 0xFF) << 16 | (buf[3 + offset] & 0xFF) << 24;
            offset += 4;
        }
        return intArr;
    }

    public byte[] DoublesToByteArray(double[] values) {
        byte[] buf = new byte[8 * values.length];
        int offset = 0;
        for (int i = 0; i < values.length; ++i) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte[] bytes = buffer.putDouble(values[i]).array();
            for (int j = 0; j < 8; ++j) {
                buf[offset + j] = bytes[j];
            }
            offset += 8;
        }
        return buf;
    }

    public static byte[] deflate(byte[] data) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        deflater.finish();
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }

    public static byte[] decompress(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }

    public BinaryData() {
    }

    public BinaryData(File inputFileData, Acqu acq, boolean isComplex) throws IOException {
        this(inputFileData, acq, isComplex, false);
    }

    public BinaryData(File inputFileData, Acqu acq, boolean isComplex, boolean isCompressed) throws IOException {
        if (inputFileData.isFile() && inputFileData.canRead()) {
            RandomAccessFile fidInput = new RandomAccessFile(inputFileData, "r");
            FileChannel inChannel = fidInput.getChannel();
            int bytes2read = 0;
            boolean floattype = false;
            boolean crossvalues = true;
            switch (acq.getSpectrometer()) {
                case VARIAN: {
                    ByteBuffer bHeader = ByteBuffer.allocate(60);
                    bHeader.order(acq.getByteOrder());
                    int[] dataHeader = this.toInt(bHeader.array(), acq.getByteOrder());
                    if ((dataHeader[6] & 8) != 0) {
                        floattype = true;
                    }
                    acq.setBiteSyze(dataHeader[3]);
                    bytes2read = dataHeader[4];
                    break;
                }
                case BRUKER: {
                    bytes2read = (int)inChannel.size();
                    break;
                }
                case JEOL: {
                    inChannel.position(acq.getDataOffset());
                    bytes2read = (int)acq.getDataLength();
                    if (!isComplex) break;
                    crossvalues = false;
                    break;
                }
            }
            ByteBuffer buffer = ByteBuffer.allocate(bytes2read);
            buffer.order(acq.getByteOrder());
            inChannel.read(buffer);
            inChannel.close();
            fidInput.close();
            String byteFormat = "";
            switch (acq.getBiteSyze()) {
                case 4: {
                    if (floattype) {
                        byteFormat = "float32";
                        break;
                    }
                    byteFormat = "integer32";
                    break;
                }
                case 8: {
                    byteFormat = "float64";
                }
            }
            this.setData(buffer.array());
            this.setByteFormat(byteFormat);
            this.setCrossVallues(crossvalues);
            double[] dataValues = this.getDataAsDouble(acq.getByteOrder());
            byte[] buf = this.DoublesToByteArray(dataValues);
            byteFormat = isComplex ? "Complex128" : "float64";
            acq.setBiteSyze(8);
            acq.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            if (isCompressed) {
                this.setData(BinaryData.deflate(buf));
            } else {
                this.setData(buf);
            }
            this.compressed = isCompressed;
            this.setByteFormat(byteFormat);
            this.exists = true;
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            md.update(this.getData());
            this.setSha1(this.convertToHex(md.digest()));
        }
    }

    static {
        hByteFormat.put("integer32", new int[]{4, 1, 1});
        hByteFormat.put("integer64", new int[]{8, 1, 2});
        hByteFormat.put("float32", new int[]{4, 1, 3});
        hByteFormat.put("float64", new int[]{8, 1, 4});
        hByteFormat.put("complex64", new int[]{4, 2, 3});
        hByteFormat.put("complex128", new int[]{8, 2, 4});
    }
}

