/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.BS;
import javajs.util.V3d;
import org.jmol.util.Geodesic;

public class Normix {
    private static final int NORMIX_GEODESIC_LEVEL = 3;
    private static short normixCount;
    private static V3d[] vertexVectors;
    private static short[] inverseNormixes;
    private static short[][] neighborVertexesArrays;
    public static final short NORMIX_NULL = 9999;

    public static short getNormixCount() {
        return normixCount > 1 ? normixCount : (normixCount = Geodesic.getVertexCount(3));
    }

    public static BS newVertexBitSet() {
        return BS.newN(Normix.getNormixCount());
    }

    public static V3d[] getVertexVectors() {
        if (vertexVectors == null) {
            vertexVectors = Geodesic.getVertexVectors();
        }
        return vertexVectors;
    }

    public static void setInverseNormixes() {
        if (inverseNormixes != null) {
            return;
        }
        Normix.getNormixCount();
        Normix.getVertexVectors();
        inverseNormixes = new short[normixCount];
        BS bsTemp = new BS();
        int n = normixCount;
        while (--n >= 0) {
            V3d v = vertexVectors[n];
            Normix.inverseNormixes[n] = Normix.getNormix(-v.x, -v.y, -v.z, 3, bsTemp);
        }
    }

    public static short getInverseNormix(short normix) {
        return inverseNormixes[normix];
    }

    private static short[][] getNeighborVertexArrays() {
        if (neighborVertexesArrays == null) {
            neighborVertexesArrays = Geodesic.getNeighborVertexesArrays();
        }
        return neighborVertexesArrays;
    }

    public static short getNormixV(V3d v, BS bsTemp) {
        return Normix.getNormix(v.x, v.y, v.z, 3, bsTemp);
    }

    public static short get2SidedNormix(V3d v, BS bsTemp) {
        return ~Normix.getNormixV(v, bsTemp);
    }

    private static short getNormix(double x, double y, double z, int geodesicLevel, BS bsConsidered) {
        double t;
        short champion;
        if (z >= 0.0) {
            champion = 0;
            t = z - 1.0;
        } else {
            champion = 11;
            t = z - -1.0;
        }
        bsConsidered.clearAll();
        bsConsidered.set(champion);
        Normix.getVertexVectors();
        Normix.getNeighborVertexArrays();
        double championDist2 = x * x + y * y + t * t;
        for (int lvl = 0; lvl <= geodesicLevel; ++lvl) {
            short[] neighborVertexes = neighborVertexesArrays[lvl];
            int offsetNeighbors = 6 * champion;
            int i = offsetNeighbors + (champion < 12 ? 5 : 6);
            while (--i >= offsetNeighbors) {
                short challenger = neighborVertexes[i];
                if (bsConsidered.get(challenger)) continue;
                bsConsidered.set(challenger);
                V3d v = vertexVectors[challenger];
                double d = v.x - x;
                double d2 = d * d;
                if (d2 >= championDist2 || (d2 += (d = v.y - y) * d) >= championDist2 || (d2 += (d = v.z - z) * d) >= championDist2) continue;
                champion = challenger;
                championDist2 = d2;
            }
        }
        return champion;
    }
}

