/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.io.Serializable;
import java.util.Hashtable;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.util.Point3fi;

public class BoxInfo {
    public static final int X = 4;
    public static final int Y = 2;
    public static final int Z = 1;
    public static final int XYZ = 7;
    public final P3d bbCorner0 = new P3d();
    public final P3d bbCorner1 = new P3d();
    private final P3d bbCenter = new P3d();
    private final V3d bbVector = new V3d();
    private final Point3fi[] bbVertices = new Point3fi[8];
    private boolean isScaleSet;
    private double margin;
    public static char[] bbcageTickEdges = new char[]{'z', '\u0000', '\u0000', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static char[] uccageTickEdges = new char[]{'z', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static final byte[] edges = new byte[]{0, 1, 0, 2, 0, 4, 1, 3, 1, 5, 2, 3, 2, 6, 3, 7, 4, 5, 4, 6, 5, 7, 6, 7};
    public static final int[] faceOrder = new int[]{0, 3, 5, 2, 1, 4};
    public static final int[][] facePoints = new int[][]{{4, 0, 6}, {4, 6, 5}, {5, 7, 1}, {1, 3, 0}, {6, 2, 7}, {1, 0, 5}, {0, 2, 6}, {6, 7, 5}, {7, 3, 1}, {3, 2, 0}, {2, 3, 7}, {0, 4, 5}};
    public static final P3d[] unitCubePoints = new P3d[]{P3d.new3(0.0, 0.0, 0.0), P3d.new3(0.0, 0.0, 1.0), P3d.new3(0.0, 1.0, 0.0), P3d.new3(0.0, 1.0, 1.0), P3d.new3(1.0, 0.0, 0.0), P3d.new3(1.0, 0.0, 1.0), P3d.new3(1.0, 1.0, 0.0), P3d.new3(1.0, 1.0, 1.0)};
    private static final int[] toCanonical = new int[]{0, 3, 4, 7, 1, 2, 5, 6};
    private static final P3d[] unitBboxPoints = new P3d[8];
    P3d ptTemp;

    public BoxInfo() {
        int i;
        for (i = 0; i < 8; ++i) {
            BoxInfo.unitBboxPoints[i] = P3d.new3(-1.0, -1.0, -1.0);
            unitBboxPoints[i].scaleAdd2(2.0, unitCubePoints[i], unitBboxPoints[i]);
        }
        this.ptTemp = new P3d();
        i = 8;
        while (--i >= 0) {
            this.bbVertices[i] = new Point3fi();
        }
        this.reset();
    }

    public void reset() {
        this.isScaleSet = false;
        this.bbCorner0.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.bbCorner1.set(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public static void scaleBox(P3d[] pts, double scale) {
        int i;
        if (scale == 0.0 || scale == 1.0) {
            return;
        }
        P3d center = new P3d();
        V3d v = new V3d();
        for (i = 0; i < 8; ++i) {
            center.add(pts[i]);
        }
        center.scale(0.125);
        for (i = 0; i < 8; ++i) {
            v.sub2(pts[i], center);
            v.scale(scale);
            pts[i].add2(center, v);
        }
    }

    public static final P3d[] getVerticesFromOABC(T3d[] oabc) {
        P3d[] vertices = new P3d[8];
        for (int i = 0; i <= 7; ++i) {
            vertices[i] = P3d.newP(oabc[0]);
            if ((i & 4) == 4) {
                vertices[i].add(oabc[1]);
            }
            if ((i & 2) == 2) {
                vertices[i].add(oabc[2]);
            }
            if ((i & 1) != 1) continue;
            vertices[i].add(oabc[3]);
        }
        return vertices;
    }

    public static final P3d[] getCanonicalCopy(P3d[] boxPoints, double scale) {
        P3d[] pts = new P3d[8];
        for (int i = 0; i < 8; ++i) {
            pts[BoxInfo.toCanonical[i]] = P3d.newP(boxPoints[i]);
        }
        BoxInfo.scaleBox(pts, scale);
        return pts;
    }

    public static final P3d[] toOABC(P3d[] bbVertices, T3d offset) {
        P3d center = P3d.newP(bbVertices[0]);
        P3d a = P3d.newP(bbVertices[4]);
        P3d b = P3d.newP(bbVertices[2]);
        P3d c = P3d.newP(bbVertices[1]);
        a.sub(center);
        b.sub(center);
        c.sub(center);
        if (offset != null) {
            center.add(offset);
        }
        return new P3d[]{center, a, b, c};
    }

    public P3d getBoundBoxCenter() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0);
        }
        return this.bbCenter;
    }

    public V3d getBoundBoxCornerVector() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0);
        }
        return this.bbVector;
    }

    public P3d[] getBoundBoxPoints(boolean isAll) {
        P3d[] p3dArray;
        if (!this.isScaleSet) {
            this.setBbcage(1.0);
        }
        if (isAll) {
            P3d[] p3dArray2 = new P3d[4];
            p3dArray2[0] = this.bbCenter;
            p3dArray2[1] = P3d.newP(this.bbVector);
            p3dArray2[2] = this.bbCorner0;
            p3dArray = p3dArray2;
            p3dArray2[3] = this.bbCorner1;
        } else {
            P3d[] p3dArray3 = new P3d[2];
            p3dArray3[0] = this.bbCorner0;
            p3dArray = p3dArray3;
            p3dArray3[1] = this.bbCorner1;
        }
        return p3dArray;
    }

    public Point3fi[] getBoundBoxVertices() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0);
        }
        return this.bbVertices;
    }

    public void setBoundBoxFromOABC(T3d[] points) {
        P3d origin = P3d.newP(points[0]);
        P3d pt111 = new P3d();
        for (int i = 0; i < 4; ++i) {
            pt111.add(points[i]);
        }
        this.setBoundBox(origin, pt111, true, 1.0);
    }

    public void setBoundBox(T3d pt1, T3d pt2, boolean byCorner, double scale) {
        if (pt1 != null) {
            if (scale == 0.0) {
                return;
            }
            if (byCorner) {
                if (pt1.distance(pt2) == 0.0) {
                    return;
                }
                this.bbCorner0.set(Math.min(pt1.x, pt2.x), Math.min(pt1.y, pt2.y), Math.min(pt1.z, pt2.z));
                this.bbCorner1.set(Math.max(pt1.x, pt2.x), Math.max(pt1.y, pt2.y), Math.max(pt1.z, pt2.z));
            } else {
                if (pt2.x == 0.0 || pt2.y == 0.0 && pt2.z == 0.0) {
                    return;
                }
                this.bbCorner0.set(pt1.x - pt2.x, pt1.y - pt2.y, pt1.z - pt2.z);
                this.bbCorner1.set(pt1.x + pt2.x, pt1.y + pt2.y, pt1.z + pt2.z);
            }
        }
        this.setBbcage(scale);
    }

    public void setMargin(double m) {
        this.margin = m;
    }

    public void addBoundBoxPointD(T3d pt) {
        this.isScaleSet = false;
        this.ptTemp.set(pt.x, pt.y, pt.z);
        BoxInfo.addPoint(this.ptTemp, this.bbCorner0, this.bbCorner1, this.margin);
    }

    public void addBoundBoxPoint(T3d pt) {
        this.isScaleSet = false;
        BoxInfo.addPoint(pt, this.bbCorner0, this.bbCorner1, this.margin);
    }

    public static void addPoint(T3d pt, T3d xyzMin, T3d xyzMax, double margin) {
        if (pt.x - margin < xyzMin.x) {
            xyzMin.x = pt.x - margin;
        }
        if (pt.x + margin > xyzMax.x) {
            xyzMax.x = pt.x + margin;
        }
        if (pt.y - margin < xyzMin.y) {
            xyzMin.y = pt.y - margin;
        }
        if (pt.y + margin > xyzMax.y) {
            xyzMax.y = pt.y + margin;
        }
        if (pt.z - margin < xyzMin.z) {
            xyzMin.z = pt.z - margin;
        }
        if (pt.z + margin > xyzMax.z) {
            xyzMax.z = pt.z + margin;
        }
    }

    public static void addPointXYZ(double x, double y, double z, P3d xyzMin, P3d xyzMax, double margin) {
        if (x - margin < xyzMin.x) {
            xyzMin.x = x - margin;
        }
        if (x + margin > xyzMax.x) {
            xyzMax.x = x + margin;
        }
        if (y - margin < xyzMin.y) {
            xyzMin.y = y - margin;
        }
        if (y + margin > xyzMax.y) {
            xyzMax.y = y + margin;
        }
        if (z - margin < xyzMin.z) {
            xyzMin.z = z - margin;
        }
        if (z + margin > xyzMax.z) {
            xyzMax.z = z + margin;
        }
    }

    public void setBbcage(double scale) {
        this.isScaleSet = true;
        this.bbCenter.add2(this.bbCorner0, this.bbCorner1);
        this.bbCenter.scale(0.5);
        this.bbVector.sub2(this.bbCorner1, this.bbCenter);
        if (scale > 0.0) {
            this.bbVector.scale(scale);
        } else {
            this.bbVector.x -= scale / 2.0;
            this.bbVector.y -= scale / 2.0;
            this.bbVector.z -= scale / 2.0;
        }
        int i = 8;
        while (--i >= 0) {
            Point3fi pt = this.bbVertices[i];
            pt.setT(unitBboxPoints[i]);
            pt.x *= this.bbVector.x;
            pt.y *= this.bbVector.y;
            pt.z *= this.bbVector.z;
            pt.add(this.bbCenter);
        }
        if (scale != 1.0) {
            this.bbCorner0.setT(this.bbVertices[0]);
            this.bbCorner1.setT(this.bbVertices[7]);
        }
    }

    public boolean isWithin(P3d pt) {
        if (!this.isScaleSet) {
            this.setBbcage(1.0);
        }
        return pt.x >= this.bbCorner0.x && pt.x <= this.bbCorner1.x && pt.y >= this.bbCorner0.y && pt.y <= this.bbCorner1.y && pt.z >= this.bbCorner0.z && pt.z <= this.bbCorner1.z;
    }

    public double getMaxDim() {
        return this.bbVector.length() * 2.0;
    }

    public Object getInfo(String what) {
        Double vol = Math.abs(8.0 * this.bbVector.x * this.bbVector.y * this.bbVector.z);
        if ("volume".equals(what)) {
            return vol;
        }
        P3d c = P3d.newP(this.bbCenter);
        if ("center".equals(what)) {
            return c;
        }
        if (what == null || "info".equals(what)) {
            Hashtable<String, Serializable> m = new Hashtable<String, Serializable>();
            m.put("center", c);
            V3d v = V3d.newVsub(this.bbCorner1, this.bbCorner0);
            m.put("dimensions", v);
            m.put("girth", Double.valueOf(v.x + v.y + v.z));
            m.put("area", Double.valueOf(2.0 * (v.x * v.y + v.x * v.z + v.z * v.y)));
            m.put("volume", vol);
            return m;
        }
        return null;
    }

    public String toString() {
        return "" + this.bbCorner0 + this.bbCorner1;
    }

    public static P4d[] getBoxFacesFromOABC(P3d[] oabc) {
        P4d[] faces = new P4d[6];
        V3d vNorm = new V3d();
        V3d vAB = new V3d();
        P3d pta = new P3d();
        P3d ptb = new P3d();
        P3d ptc = new P3d();
        P3d[] vertices = oabc == null ? unitCubePoints : BoxInfo.getVerticesFromOABC(oabc);
        for (int i = 0; i < 6; ++i) {
            pta.setT(vertices[facePoints[i][0]]);
            ptb.setT(vertices[facePoints[i][1]]);
            ptc.setT(vertices[facePoints[i][2]]);
            faces[i] = MeasureD.getPlaneThroughPoints(pta, ptb, ptc, vNorm, vAB, new P4d());
        }
        return faces;
    }
}

