/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.PT;
import javajs.util.Qd;
import javajs.util.T3d;
import javajs.util.T4d;
import javajs.util.V3d;
import org.jmol.api.Interface;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.SimpleUnitCell;
import org.jmol.util.Tensor;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class UnitCell
extends SimpleUnitCell
implements Cloneable {
    private static final double twoP2 = 19.739208802178716;
    private static final V3d[] unitVectors = new V3d[]{JC.axisX, JC.axisY, JC.axisZ};
    Lst<String> moreInfo;
    public String name = "";
    private P3d[] vertices;
    private P3d fractionalOffset;
    private boolean allFractionalRelative;
    private final P3d cartesianOffset = new P3d();
    private T3d unitCellMultiplier;
    private UnitCell unitCellMultiplied;
    private double[][] f2c;

    private UnitCell() {
    }

    public static UnitCell fromOABC(T3d[] oabc, boolean setRelative) {
        UnitCell c = new UnitCell();
        if (oabc.length == 3) {
            oabc = new T3d[]{new P3d(), oabc[0], oabc[1], oabc[2]};
        }
        double[] parameters = new double[]{-1.0, 0.0, 0.0, 0.0, 0.0, 0.0, oabc[1].x, oabc[1].y, oabc[1].z, oabc[2].x, oabc[2].y, oabc[2].z, oabc[3].x, oabc[3].y, oabc[3].z};
        c.init(parameters);
        c.allFractionalRelative = setRelative;
        c.initUnitcellVertices();
        c.setCartesianOffset(oabc[0]);
        return c;
    }

    public static UnitCell fromParams(double[] params, boolean setRelative, double slop) {
        UnitCell c = new UnitCell();
        c.init(params);
        c.initUnitcellVertices();
        c.allFractionalRelative = setRelative;
        c.setPrecision(slop);
        if (params.length > 26) {
            params[26] = slop;
        }
        return c;
    }

    static UnitCell cloneUnitCell(UnitCell uc) {
        UnitCell ucnew = null;
        try {
            ucnew = (UnitCell)uc.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return ucnew;
    }

    public boolean checkDistance(P3d f1, P3d f2, double distance, double dx, int iRange, int jRange, int kRange, P3d ptOffset) {
        P3d p1 = P3d.newP(f1);
        this.toCartesian(p1, true);
        for (int i = -iRange; i <= iRange; ++i) {
            for (int j = -jRange; j <= jRange; ++j) {
                for (int k = -kRange; k <= kRange; ++k) {
                    ptOffset.set(f2.x + (double)i, f2.y + (double)j, f2.z + (double)k);
                    this.toCartesian(ptOffset, true);
                    double d = p1.distance(ptOffset);
                    if (!(dx > 0.0 ? Math.abs(d - distance) <= dx : d <= distance && d > 0.1)) continue;
                    ptOffset.set(i, j, k);
                    return true;
                }
            }
        }
        return false;
    }

    boolean checkPeriodic(P3d pt) {
        switch (this.dimension) {
            case 3: {
                if (pt.z < -this.slop || pt.z > 1.0 - this.slop) {
                    return false;
                }
            }
            case 2: {
                if (pt.y < -this.slop || pt.y > 1.0 - this.slop) {
                    return false;
                }
            }
            case 1: {
                if (!(pt.x < -this.slop) && !(pt.x > 1.0 - this.slop)) break;
                return false;
            }
        }
        return true;
    }

    String dumpInfo(boolean isDebug, boolean multiplied) {
        UnitCell m;
        UnitCell unitCell = m = multiplied ? this.getUnitCellMultiplied() : this;
        if (m != this) {
            return m.dumpInfo(isDebug, false);
        }
        return "a=" + this.a + ", b=" + this.b + ", c=" + this.c + ", alpha=" + this.alpha + ", beta=" + this.beta + ", gamma=" + this.gamma + "\noabc=" + Escape.eAP(this.getUnitCellVectors()) + "\nvolume=" + this.volume + (isDebug ? "\nfractional to cartesian: " + this.matrixFractionalToCartesian + "\ncartesian to fractional: " + this.matrixCartesianToFractional : "");
    }

    private double fix000(double x) {
        return Math.abs(x) < 0.001 ? 0.0 : x;
    }

    private double fixFloor(double d) {
        return d == 1.0 ? 0.0 : d;
    }

    P3d[] getCanonicalCopy(double scale, boolean withOffset) {
        P3d[] pts = this.getScaledCell(withOffset);
        return BoxInfo.getCanonicalCopy(pts, scale);
    }

    P3d getCartesianOffset() {
        return this.cartesianOffset;
    }

    double getCellWeight(P3d pt) {
        double f = 1.0;
        if (pt.x <= this.slop || pt.x >= 1.0 - this.slop) {
            f /= 2.0;
        }
        if (pt.y <= this.slop || pt.y >= 1.0 - this.slop) {
            f /= 2.0;
        }
        if (pt.z <= this.slop || pt.z >= 1.0 - this.slop) {
            f /= 2.0;
        }
        return f;
    }

    public T3d[] getConventionalUnitCell(String latticeType, M3d primitiveToCrystal) {
        T3d[] oabc = this.getUnitCellVectors();
        if (!latticeType.equals("P") || primitiveToCrystal != null) {
            this.toFromPrimitive(false, latticeType.charAt(0), oabc, primitiveToCrystal);
        }
        return oabc;
    }

    Lst<P3d> getEquivPoints(P3d pt, String flags, M4d[] ops, Lst<P3d> list, int i0, int n0, int dup0, int periodicity) {
        int i;
        boolean packed;
        boolean fromfractional = flags.indexOf("fromfractional") >= 0;
        boolean tofractional = flags.indexOf("tofractional") >= 0;
        boolean bl = packed = flags.indexOf("packed") >= 0;
        if (list == null) {
            list = new Lst();
        }
        P3d pf = P3d.newP(pt);
        if (!fromfractional) {
            this.toFractional(pf, true);
        }
        int n = list.size();
        boolean adjustA = (periodicity & 1) != 0;
        boolean adjustB = (periodicity & 2) != 0;
        boolean adjustC = (periodicity & 4) != 0;
        int nops = ops.length;
        for (i = 0; i < nops; ++i) {
            P3d p = P3d.newP(pf);
            ops[i].rotTrans(p);
            if (adjustA) {
                p.x = this.fixFloor(p.x - Math.floor(p.x));
            }
            if (adjustB) {
                p.y = this.fixFloor(p.y - Math.floor(p.y));
            }
            if (adjustC) {
                p.z = this.fixFloor(p.z - Math.floor(p.z));
            }
            list.addLast(p);
            ++n;
        }
        if (packed) {
            int i2;
            if (!adjustC) {
                P3d offset = P3d.new3(0.0, 0.0, 0.5);
                for (i2 = n0; i2 < n; ++i2) {
                    ((P3d)list.get(i2)).add(offset);
                }
            }
            if (!adjustB) {
                P3d offset = P3d.new3(0.0, 0.5, 0.0);
                for (i2 = n0; i2 < n; ++i2) {
                    ((P3d)list.get(i2)).add(offset);
                }
            }
            if (!adjustA) {
                P3d offset = P3d.new3(0.5, 0.0, 0.0);
                for (i2 = n0; i2 < n; ++i2) {
                    ((P3d)list.get(i2)).add(offset);
                }
            }
            for (i = n0; i < n; ++i) {
                pf.setT((T3d)list.get(i));
                this.unitizeRnd(pf);
                if (pf.x == 0.0) {
                    list.addLast(P3d.new3(0.0, pf.y, pf.z));
                    list.addLast(P3d.new3(1.0, pf.y, pf.z));
                    if (pf.y == 0.0) {
                        list.addLast(P3d.new3(1.0, 1.0, pf.z));
                        list.addLast(P3d.new3(0.0, 0.0, pf.z));
                        if (pf.z == 0.0) {
                            list.addLast(P3d.new3(1.0, 1.0, 1.0));
                            list.addLast(P3d.new3(0.0, 0.0, 0.0));
                        }
                    }
                }
                if (pf.y == 0.0) {
                    list.addLast(P3d.new3(pf.x, 0.0, pf.z));
                    list.addLast(P3d.new3(pf.x, 1.0, pf.z));
                    if (pf.z == 0.0) {
                        list.addLast(P3d.new3(pf.x, 0.0, 0.0));
                        list.addLast(P3d.new3(pf.x, 1.0, 1.0));
                    }
                }
                if (pf.z != 0.0) continue;
                list.addLast(P3d.new3(pf.x, pf.y, 0.0));
                list.addLast(P3d.new3(pf.x, pf.y, 1.0));
                if (pf.x != 0.0) continue;
                list.addLast(P3d.new3(0.0, pf.y, 0.0));
                list.addLast(P3d.new3(1.0, pf.y, 1.0));
            }
            n = list.size();
            if (!adjustA) {
                P3d offset = P3d.new3(-0.5, 0.0, 0.0);
                for (i2 = n0; i2 < n; ++i2) {
                    ((P3d)list.get(i2)).add(offset);
                }
            }
            if (!adjustB) {
                n = list.size();
                P3d offset = P3d.new3(0.0, -0.5, 0.0);
                for (i2 = n0; i2 < n; ++i2) {
                    ((P3d)list.get(i2)).add(offset);
                }
            }
            if (!adjustC) {
                n = list.size();
                P3d offset = P3d.new3(0.0, 0.0, -0.5);
                for (i2 = n0; i2 < n; ++i2) {
                    ((P3d)list.get(i2)).add(offset);
                }
            }
        }
        UnitCell.removeDuplicates(list, i0, dup0, -1);
        if (!tofractional) {
            i = list.size();
            while (--i >= n0) {
                this.toCartesian((T3d)list.get(i), true);
            }
        }
        return list;
    }

    P3d getFractionalOffset() {
        return this.fractionalOffset;
    }

    Map<String, Object> getInfo() {
        UnitCell m = this.getUnitCellMultiplied();
        if (m != this) {
            return m.getInfo();
        }
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("params", this.unitCellParams);
        info.put("oabc", this.getUnitCellVectors());
        info.put("volume", this.volume);
        info.put("matFtoC", this.matrixFractionalToCartesian);
        info.put("matCtoF", this.matrixCartesianToFractional);
        return info;
    }

    Qd getQuaternionRotation(String abc) {
        V3d v3;
        V3d v2;
        V3d v1;
        int quadrant;
        String abc0;
        int mul;
        V3d a = V3d.newVsub(this.vertices[4], this.vertices[0]);
        V3d b = V3d.newVsub(this.vertices[2], this.vertices[0]);
        V3d c = V3d.newVsub(this.vertices[1], this.vertices[0]);
        V3d x = new V3d();
        V3d v = new V3d();
        int n = mul = abc.charAt(0) == '-' ? -1 : 1;
        if (mul < 0) {
            abc = abc.substring(1);
        }
        boolean isFace = !(abc0 = abc).equals(abc = PT.rep(PT.rep(PT.rep(PT.rep(PT.rep(PT.rep(abc, "ab", "A"), "bc", "B"), "ca", "C"), "ba", "D"), "cb", "E"), "ac", "F"));
        int n2 = quadrant = isFace ? 1 : 0;
        if (abc.length() == 2) {
            quadrant = abc.charAt(1) - 48;
            abc = abc.substring(0, 1);
        }
        boolean isEven = quadrant % 2 == 0;
        int axis2 = "abcABCDEF".indexOf(abc);
        switch (axis2) {
            case 7: {
                mul = -mul;
            }
            case 4: {
                a.cross(c, b);
                quadrant = (5 - quadrant) % 4 + 1;
            }
            default: {
                v1 = a;
                v2 = c;
                v3 = b;
                break;
            }
            case 8: {
                mul = -mul;
            }
            case 5: {
                mul = -mul;
                b.cross(c, a);
                quadrant = (2 + quadrant) % 4 + 1;
            }
            case 1: {
                v1 = b;
                v2 = a;
                v3 = c;
                mul = -mul;
                break;
            }
            case 3: {
                mul = -mul;
            }
            case 6: {
                c.cross(a, b);
                if (isEven) {
                    quadrant = 6 - quadrant;
                }
            }
            case 2: {
                v1 = c;
                v2 = a;
                v3 = b;
                if (isFace || quadrant <= 0) break;
                quadrant = 5 - quadrant;
            }
        }
        if (quadrant > 0 && mul > 0 != isEven) {
            v2 = v3;
            v1.scale(-1.0);
        }
        switch (quadrant) {
            default: {
                break;
            }
            case 2: {
                v1.scale(-1.0);
                v2.scale(-1.0);
                break;
            }
            case 3: {
                v2.scale(-1.0);
                break;
            }
            case 4: {
                v1.scale(-1.0);
            }
        }
        x.cross(v1, v2);
        v.cross(x, v1);
        return Qd.getQuaternionFrame(null, v, x).inv();
    }

    private P3d[] getScaledCell(boolean withOffset) {
        return this.getScaledCellMult(null, withOffset);
    }

    private P3d[] getScaledCellMult(T3d mult, boolean withOffset) {
        boolean isFrac;
        P3d[] pts = new P3d[8];
        P3d cell0 = null;
        P3d cell1 = null;
        boolean bl = isFrac = mult != null;
        if (!isFrac) {
            mult = this.unitCellMultiplier;
        }
        if (withOffset && mult != null && mult.z == 0.0) {
            cell0 = new P3d();
            cell1 = new P3d();
            UnitCell.ijkToPoint3f((int)mult.x, cell0, 0, 0);
            UnitCell.ijkToPoint3f((int)mult.y, cell1, 0, 0);
            cell1.sub(cell0);
        }
        double scale = isFrac || mult == null || mult.z == 0.0 ? 1.0 : Math.abs(mult.z);
        for (int i = 0; i < 8; ++i) {
            P3d pt = pts[i] = P3d.newP(BoxInfo.unitCubePoints[i]);
            if (cell0 != null) {
                pts[i].add3(cell0.x + cell1.x * pt.x, cell0.y + cell1.y * pt.y, cell0.z + cell1.z * pt.z);
            } else if (isFrac) {
                pt.scaleT(mult);
            }
            pts[i].scale(scale);
            this.matrixFractionalToCartesian.rotTrans(pt);
            if (withOffset) continue;
            pt.sub(this.cartesianOffset);
        }
        return pts;
    }

    String getState() {
        String s = "";
        if (this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0) {
            s = s + "  unitcell offset " + Escape.eP(this.fractionalOffset) + ";\n";
        }
        if (this.unitCellMultiplier != null) {
            s = s + "  unitcell range " + UnitCell.escapeMultiplier(this.unitCellMultiplier) + ";\n";
        }
        return s;
    }

    public Tensor getTensor(Viewer vwr, double[] parBorU) {
        Tensor t = (Tensor)Interface.getUtil("Tensor", vwr, "file");
        if (parBorU[0] == 0.0 && parBorU[1] == 0.0 && parBorU[2] == 0.0) {
            double f = parBorU[7];
            double[] eigenValues = new double[]{f, f, f};
            return t.setFromEigenVectors(unitVectors, eigenValues, "iso", "Uiso=" + f, null);
        }
        t.parBorU = parBorU;
        double[] Bcart = new double[6];
        int ortepType = (int)parBorU[6];
        if (ortepType == 12) {
            Bcart[0] = parBorU[0] * 19.739208802178716;
            Bcart[1] = parBorU[1] * 19.739208802178716;
            Bcart[2] = parBorU[2] * 19.739208802178716;
            Bcart[3] = parBorU[3] * 19.739208802178716 * 2.0;
            Bcart[4] = parBorU[4] * 19.739208802178716 * 2.0;
            Bcart[5] = parBorU[5] * 19.739208802178716 * 2.0;
            parBorU[7] = (parBorU[0] + parBorU[1] + parBorU[3]) / 3.0;
        } else {
            boolean isFractional = ortepType == 4 || ortepType == 5 || ortepType == 8 || ortepType == 9;
            double cc = 2 - ortepType % 2;
            double dd = ortepType == 8 || ortepType == 9 || ortepType == 10 ? 19.739208802178716 : (ortepType == 4 || ortepType == 5 ? 0.25 : (ortepType == 2 || ortepType == 3 ? Math.log(2.0) : 1.0));
            double B11 = parBorU[0] * dd * (isFractional ? this.a_ * this.a_ : 1.0);
            double B22 = parBorU[1] * dd * (isFractional ? this.b_ * this.b_ : 1.0);
            double B33 = parBorU[2] * dd * (isFractional ? this.c_ * this.c_ : 1.0);
            double B12 = parBorU[3] * dd * (isFractional ? this.a_ * this.b_ : 1.0) * cc;
            double B13 = parBorU[4] * dd * (isFractional ? this.a_ * this.c_ : 1.0) * cc;
            double B23 = parBorU[5] * dd * (isFractional ? this.b_ * this.c_ : 1.0) * cc;
            parBorU[7] = Math.pow(B11 / 19.739208802178716 / this.a_ / this.a_ * B22 / 19.739208802178716 / this.b_ / this.b_ * B33 / 19.739208802178716 / this.c_ / this.c_, 0.3333);
            Bcart[0] = this.a * this.a * B11 + this.b * this.b * this.cosGamma * this.cosGamma * B22 + this.c * this.c * this.cosBeta * this.cosBeta * B33 + this.a * this.b * this.cosGamma * B12 + this.b * this.c * this.cosGamma * this.cosBeta * B23 + this.a * this.c * this.cosBeta * B13;
            Bcart[1] = this.b * this.b * this.sinGamma * this.sinGamma * B22 + this.c * this.c * this.cA_ * this.cA_ * B33 + this.b * this.c * this.cA_ * this.sinGamma * B23;
            Bcart[2] = this.c * this.c * this.cB_ * this.cB_ * B33;
            Bcart[3] = 2.0 * this.b * this.b * this.cosGamma * this.sinGamma * B22 + 2.0 * this.c * this.c * this.cA_ * this.cosBeta * B33 + this.a * this.b * this.sinGamma * B12 + this.b * this.c * (this.cA_ * this.cosGamma + this.sinGamma * this.cosBeta) * B23 + this.a * this.c * this.cA_ * B13;
            Bcart[4] = 2.0 * this.c * this.c * this.cB_ * this.cosBeta * B33 + this.b * this.c * this.cosGamma * B23 + this.a * this.c * this.cB_ * B13;
            Bcart[5] = 2.0 * this.c * this.c * this.cA_ * this.cB_ * B33 + this.b * this.c * this.cB_ * this.sinGamma * B23;
        }
        return t.setFromThermalEquation(Bcart, Escape.eAD(parBorU));
    }

    UnitCell getUnitCellMultiplied() {
        if (this.unitCellMultiplier == null || this.unitCellMultiplier.z > 0.0 && this.unitCellMultiplier.z == (double)((int)this.unitCellMultiplier.z)) {
            return this;
        }
        if (this.unitCellMultiplied == null) {
            T3d[] pts = BoxInfo.toOABC(this.getScaledCell(true), null);
            this.unitCellMultiplied = UnitCell.fromOABC(pts, false);
        }
        return this.unitCellMultiplied;
    }

    T3d getUnitCellMultiplier() {
        return this.unitCellMultiplier;
    }

    boolean isStandard() {
        return this.unitCellMultiplier == null || this.unitCellMultiplier.x == this.unitCellMultiplier.y;
    }

    P3d[] getUnitCellVectors() {
        M4d m = this.matrixFractionalToCartesian;
        return new P3d[]{P3d.newP(this.cartesianOffset), P3d.new3(this.fix000(m.m00), this.fix000(m.m10), this.fix000(m.m20)), P3d.new3(this.fix000(m.m01), this.fix000(m.m11), this.fix000(m.m21)), P3d.new3(this.fix000(m.m02), this.fix000(m.m12), this.fix000(m.m22))};
    }

    public static M4d toTrm(String transform, M4d trm) {
        if (trm == null) {
            trm = new M4d();
        }
        UnitCell.getMatrixAndUnitCell(null, transform, trm);
        return trm;
    }

    public static T3d[] getMatrixAndUnitCell(SimpleUnitCell uc, Object def, M4d retMatrix) {
        M4d m;
        if (def == null) {
            def = "a,b,c";
        }
        T3d[] pts = new P3d[4];
        P3d pt = pts[0] = P3d.new3(0.0, 0.0, 0.0);
        pts[1] = P3d.new3(1.0, 0.0, 0.0);
        pts[2] = P3d.new3(0.0, 1.0, 0.0);
        pts[3] = P3d.new3(0.0, 0.0, 1.0);
        M3d m3 = new M3d();
        if (AU.isAD(def)) {
            return UnitCell.setAbcFromParams((double[])def, pts);
        }
        boolean isString = def instanceof String;
        if (isString) {
            boolean isABC;
            String strans;
            String sdef = (String)def;
            String strans2 = null;
            if (sdef.indexOf("a=") == 0) {
                return UnitCell.setAbc(sdef, null, pts);
            }
            if (sdef.indexOf(">") > 0) {
                if (uc != null || retMatrix == null) {
                    return null;
                }
                String[] sdefs = sdef.split(">");
                retMatrix.setIdentity();
                M4d m4 = new M4d();
                int i = sdefs.length;
                while (--i >= 0) {
                    UnitCell.getMatrixAndUnitCell(null, sdefs[i], m4);
                    retMatrix.mul2(m4, retMatrix);
                }
                return pts;
            }
            String[] ret = new String[1];
            int ptc = sdef.indexOf(";");
            if (ptc >= 0) {
                strans = sdef.substring(ptc + 1).trim();
                ret[0] = sdef = sdef.substring(0, ptc);
                strans2 = UnitCell.fixABC(ret);
                if (sdef != ret[0]) {
                    sdef = ret[0];
                }
            } else if (sdef.equals("a,b,c")) {
                strans = null;
            } else {
                ret[0] = sdef;
                strans = UnitCell.fixABC(ret);
                sdef = ret[0];
            }
            sdef = sdef + ";0,0,0";
            while (sdef.startsWith("!!")) {
                sdef = sdef.substring(2);
            }
            boolean isRev = sdef.startsWith("!");
            if (isRev) {
                sdef = sdef.substring(1);
            }
            if (sdef.equals("r;0,0,0")) {
                sdef = "2/3a+1/3b+1/3c,-1/3a+1/3b+1/3c,-1/3a-2/3b+1/3c" + sdef.substring(1);
            } else if (sdef.equals("h;0,0,0")) {
                sdef = "a-b,b-c,a+b+c" + sdef.substring(1);
            }
            Symmetry symTemp = new Symmetry();
            symTemp.setSpaceGroup(false);
            int i = symTemp.addSpaceGroupOperation("=" + sdef, 0);
            if (i < 0) {
                return null;
            }
            m = symTemp.getSpaceGroupOperation(i);
            ((SymmetryOperation)m).doFinalize();
            P3d t = new P3d();
            UnitCell.addTrans(strans, t);
            UnitCell.addTrans(strans2, t);
            m.setTranslation(t);
            boolean bl = isABC = sdef.indexOf("c") >= 0;
            if (isABC) {
                m.transpose33();
            }
            if (isRev) {
                m.invert();
            }
            if (retMatrix != null) {
                retMatrix.setM4(m);
            }
            if (uc == null) {
                return pts;
            }
        } else {
            if (retMatrix != null || uc == null) {
                return null;
            }
            if (def instanceof M3d) {
                m = M4d.newMV((M3d)def, new P3d());
            } else if (def instanceof M4d) {
                m = (M4d)def;
            } else {
                M4d m2 = (M4d)((Object[])def)[0];
                m2.getRotationScale(m3);
                m2.rotTrans(pt);
                uc.toCartesian(pt, false);
                for (int i = 1; i < 4; ++i) {
                    m3.rotate(pts[i]);
                    uc.toCartesian(pts[i], true);
                }
                return pts;
            }
        }
        m.getRotationScale(m3);
        m.getTranslation(pt);
        uc.toCartesian(pt, false);
        for (int i = 1; i < 4; ++i) {
            m3.rotate(pts[i]);
            uc.toCartesian(pts[i], true);
        }
        return pts;
    }

    private static void addTrans(String strans, P3d t) {
        if (strans == null) {
            return;
        }
        String[] atrans = PT.split(strans, ",");
        double[] ftrans = new double[3];
        if (atrans.length == 3) {
            for (int j = 0; j < 3; ++j) {
                String s = atrans[j];
                int sfpt = s.indexOf("/");
                ftrans[j] = sfpt >= 0 ? PT.parseDouble(s.substring(0, sfpt)) / PT.parseDouble(s.substring(sfpt + 1)) : PT.parseDouble(s);
            }
        }
        t.add3(ftrans[0], ftrans[1], ftrans[2]);
    }

    private static String fixABC(String[] ret) {
        String[] tokens = PT.split(ret[0], ",");
        if (tokens.length != 3) {
            return null;
        }
        String trans = "";
        String abc = "";
        boolean haveT = false;
        for (int i = 0; i < 3; ++i) {
            String a = tokens[i];
            int n = 0;
            int p = a.length();
            block5: while (--p >= 0) {
                char c = a.charAt(p);
                switch (c) {
                    default: {
                        if (c < 'a') continue block5;
                        p = 0;
                        continue block5;
                    }
                    case '+': {
                        n = 1;
                    }
                    case '-': 
                }
                p = -p;
            }
            if ((p = -1 - p) == 0) {
                trans = trans + ",0";
                abc = abc + "," + a;
                continue;
            }
            haveT = true;
            trans = trans + "," + a.substring(p + n);
            abc = abc + "," + a.substring(0, p);
        }
        ret[0] = abc.substring(1);
        return haveT ? trans.substring(1) : null;
    }

    P3d[] getVertices() {
        return this.vertices;
    }

    private boolean hasOffset() {
        return this.fractionalOffset != null && this.fractionalOffset.lengthSquared() != 0.0;
    }

    void initOrientation(M3d mat) {
        if (mat == null) {
            return;
        }
        M4d m = new M4d();
        m.setToM3(mat);
        this.matrixFractionalToCartesian.mul2(m, this.matrixFractionalToCartesian);
        this.matrixCartesianToFractional.setM4(this.matrixFractionalToCartesian).invert();
        this.initUnitcellVertices();
    }

    private void initUnitcellVertices() {
        if (this.matrixFractionalToCartesian == null) {
            return;
        }
        this.matrixCtoFNoOffset = M4d.newM4(this.matrixCartesianToFractional);
        this.matrixFtoCNoOffset = M4d.newM4(this.matrixFractionalToCartesian);
        this.vertices = new P3d[8];
        int i = 8;
        while (--i >= 0) {
            this.vertices[i] = (P3d)this.matrixFractionalToCartesian.rotTrans2(BoxInfo.unitCubePoints[i], new P3d());
        }
    }

    boolean isSameAs(double[][] f2c2) {
        if (f2c2 == null) {
            return false;
        }
        double[][] f2c = this.getF2C();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (UnitCell.approx0(f2c[i][j] - f2c2[i][j])) continue;
                return false;
            }
        }
        return true;
    }

    public double[][] getF2C() {
        if (this.f2c == null) {
            this.f2c = new double[3][4];
            for (int i = 0; i < 3; ++i) {
                this.matrixFractionalToCartesian.getRow(i, this.f2c[i]);
            }
        }
        return this.f2c;
    }

    boolean isWithinUnitCell(double a, double b, double c, P3d pt) {
        switch (this.dimension) {
            case 3: {
                if (pt.z < c - 1.0 - this.slop || pt.z > c + this.slop) {
                    return false;
                }
            }
            case 2: {
                if (pt.y < b - 1.0 - this.slop || pt.y > b + this.slop) {
                    return false;
                }
            }
            case 1: {
                if (!(pt.x < a - 1.0 - this.slop) && !(pt.x > a + this.slop)) break;
                return false;
            }
        }
        return true;
    }

    void setCartesianOffset(T3d origin) {
        this.cartesianOffset.setT(origin);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        boolean wasOffset = this.hasOffset();
        this.fractionalOffset = P3d.newP(this.cartesianOffset);
        this.matrixCartesianToFractional.rotate(this.fractionalOffset);
        this.matrixCartesianToFractional.m03 = -this.fractionalOffset.x;
        this.matrixCartesianToFractional.m13 = -this.fractionalOffset.y;
        this.matrixCartesianToFractional.m23 = -this.fractionalOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
        if (!wasOffset && this.fractionalOffset.lengthSquared() == 0.0) {
            this.fractionalOffset = null;
        }
        this.f2c = null;
    }

    void setOffset(T3d pt) {
        boolean isCell555P4;
        if (pt == null) {
            return;
        }
        this.unitCellMultiplied = null;
        T4d pt4 = pt instanceof T4d ? (T4d)pt : null;
        double w = pt4 == null ? Double.MIN_VALUE : pt4.w;
        boolean bl = isCell555P4 = w > 999999.0;
        if (pt4 != null ? w <= 0.0 || isCell555P4 : pt.x >= 100.0 || pt.y >= 100.0) {
            this.unitCellMultiplier = pt.z == 0.0 && pt.x == pt.y && !isCell555P4 ? null : (isCell555P4 ? P4d.newPt((P4d)pt4) : P3d.newP(pt));
            this.unitCellMultiplied = null;
            if (pt4 == null || pt4.w == 0.0 || isCell555P4) {
                return;
            }
        }
        if (this.hasOffset() || pt.lengthSquared() > 0.0) {
            this.fractionalOffset = P3d.newP(pt);
        }
        this.matrixCartesianToFractional.m03 = -pt.x;
        this.matrixCartesianToFractional.m13 = -pt.y;
        this.matrixCartesianToFractional.m23 = -pt.z;
        this.cartesianOffset.setT(pt);
        this.matrixFractionalToCartesian.rotate(this.cartesianOffset);
        this.matrixFractionalToCartesian.m03 = this.cartesianOffset.x;
        this.matrixFractionalToCartesian.m13 = this.cartesianOffset.y;
        this.matrixFractionalToCartesian.m23 = this.cartesianOffset.z;
        if (this.allFractionalRelative) {
            this.matrixCtoFNoOffset.setM4(this.matrixCartesianToFractional);
            this.matrixFtoCNoOffset.setM4(this.matrixFractionalToCartesian);
        }
        this.f2c = null;
    }

    boolean toFromPrimitive(boolean toPrimitive, char type, T3d[] uc, M3d primitiveToCrystal) {
        int offset = uc.length - 3;
        M3d mf = null;
        if (type == 'r' || primitiveToCrystal == null) {
            switch (type) {
                default: {
                    return false;
                }
                case 'r': {
                    UnitCell.getReciprocal(uc, uc, 1.0);
                    return true;
                }
                case 'P': {
                    toPrimitive = true;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'R': 
            }
            mf = UnitCell.getPrimitiveTransform(type);
            if (!toPrimitive) {
                mf.invert();
            }
        } else {
            mf = M3d.newM3(primitiveToCrystal);
            if (toPrimitive) {
                mf.invert();
            }
        }
        int i = uc.length;
        while (--i >= offset) {
            T3d p = uc[i];
            this.toFractional(p, true);
            mf.rotate(p);
            this.toCartesian(p, true);
        }
        return true;
    }

    static M3d getPrimitiveTransform(char type) {
        switch (type) {
            case 'P': {
                return M3d.newA9(new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0});
            }
            case 'A': {
                return M3d.newA9(new double[]{1.0, 0.0, 0.0, 0.0, 0.5, 0.5, 0.0, -0.5, 0.5});
            }
            case 'B': {
                return M3d.newA9(new double[]{0.5, 0.0, 0.5, 0.0, 1.0, 0.0, -0.5, 0.0, 0.5});
            }
            case 'C': {
                return M3d.newA9(new double[]{0.5, 0.5, 0.0, -0.5, 0.5, 0.0, 0.0, 0.0, 1.0});
            }
            case 'R': {
                return M3d.newA9(new double[]{0.6666666666666666, -0.3333333333333333, -0.3333333333333333, 0.3333333333333333, 0.3333333333333333, -0.6666666666666666, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333});
            }
            case 'I': {
                return M3d.newA9(new double[]{-0.5, 0.5, 0.5, 0.5, -0.5, 0.5, 0.5, 0.5, -0.5});
            }
            case 'F': {
                return M3d.newA9(new double[]{0.0, 0.5, 0.5, 0.5, 0.0, 0.5, 0.5, 0.5, 0.0});
            }
        }
        return null;
    }

    final void toUnitCell(T3d pt, T3d offset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (offset == null) {
            this.matrixCartesianToFractional.rotTrans(pt);
            this.unitize(pt);
            this.matrixFractionalToCartesian.rotTrans(pt);
        } else {
            this.matrixCtoFNoOffset.rotTrans(pt);
            this.unitize(pt);
            pt.add(offset);
            this.matrixFtoCNoOffset.rotTrans(pt);
        }
    }

    public final void toUnitCellRnd(T3d pt, T3d offset) {
        if (this.matrixCartesianToFractional == null) {
            return;
        }
        if (offset == null) {
            this.matrixCartesianToFractional.rotTrans(pt);
            this.unitizeRnd(pt);
            this.matrixFractionalToCartesian.rotTrans(pt);
        } else {
            this.matrixCtoFNoOffset.rotTrans(pt);
            this.unitizeRnd(pt);
            pt.add(offset);
            this.matrixFtoCNoOffset.rotTrans(pt);
        }
    }

    void unitize(T3d pt) {
        this.unitizeDim(this.dimension, pt);
    }

    void unitizeRnd(T3d pt) {
        UnitCell.unitizeDimRnd(this.dimension, pt, this.slop);
    }

    private static void removeDuplicates(Lst<P3d> list, int i0, int n0, int n) {
        if (n < 0) {
            n = list.size();
        }
        for (int i = i0; i < n; ++i) {
            P3d p = (P3d)list.get(i);
            for (int j = Math.max(i + 1, n0); j < n; ++j) {
                if (!(((P3d)list.get(j)).distanceSquared(p) < 1.96E-6)) continue;
                list.removeItemAt(j);
                --n;
                --j;
            }
        }
    }

    public P3d getCenter(int periodicity) {
        int jd;
        int j2;
        P3d center = new P3d();
        P3d off = this.getCartesianOffset();
        P3d[] pts = this.getVertices();
        switch (periodicity) {
            default: {
                j2 = 8;
                jd = 1;
                break;
            }
            case 3: {
                j2 = 8;
                jd = 2;
                break;
            }
            case 4: {
                j2 = 2;
                jd = 1;
                break;
            }
            case 2: {
                j2 = 3;
                jd = 2;
                break;
            }
            case 1: {
                j2 = 8;
                jd = 4;
            }
        }
        int n = 0;
        for (int j = 0; j < j2; j += jd) {
            center.add(pts[j]);
            center.add(off);
            ++n;
        }
        center.scale(1.0 / (double)n);
        return center;
    }
}

