/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.Matrix;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class SymmetryOperation
extends M4d {
    String xyzOriginal;
    String xyzCanonical;
    String xyz;
    private boolean doNormalize = true;
    boolean isFinalized;
    private int opId;
    private V3d centering;
    private Hashtable<String, Object> info;
    static P3d atomTest;
    static final int TYPE_UNKNOWN = -1;
    static final int TYPE_IDENTITY = 0;
    static final int TYPE_TRANSLATION = 1;
    static final int TYPE_ROTATION = 2;
    static final int TYPE_INVERSION = 4;
    static final int TYPE_REFLECTION = 8;
    static final int TYPE_SCREW_ROTATION = 3;
    static final int TYPE_ROTOINVERSION = 6;
    static final int TYPE_GLIDE_REFLECTION = 9;
    private int opType = -1;
    private int opOrder;
    private V3d opTrans;
    private V3d opGlide;
    private P3d opPoint;
    private P3d opPoint2;
    private V3d opAxis;
    P4d opPlane;
    private Boolean opIsCCW;
    private int opPerDim;
    boolean isIrrelevant;
    int iCoincident;
    static final int OP_MODE_POSITION_ONLY = 0;
    static final int OP_MODE_NOTRANS = 1;
    static final int OP_MODE_FULL = 2;
    private String[] myLabels;
    int modDim;
    double[] linearRotTrans;
    Matrix rsvs;
    boolean isBio;
    Matrix sigma;
    int number;
    public String subsystemCode;
    int timeReversal;
    private boolean unCentered;
    boolean isCenteringOp;
    private int magOp = Integer.MAX_VALUE;
    int divisor = 12;
    private T3d opX;
    private String opAxisCode;
    public boolean opIsLong;
    private static final int DIVISOR_MASK = 255;
    private static final int DIVISOR_OFFSET = 8;
    private static final String[] twelfths;
    static final String[] labelsXYZ;
    static final String[] labelsXn;
    static final String[] labelsXnSub;
    private static final P3d x;
    private static final int[] C3codes;
    private static V3d xneg;
    private static P4d[] opPlanes;

    public String getOpDesc() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        switch (this.opType) {
            case 0: {
                return "I";
            }
            case 1: {
                return "Trans";
            }
            case 2: {
                return "Rot" + this.opOrder;
            }
            case 4: {
                return "Inv";
            }
            case 8: {
                return "Plane";
            }
            case 3: {
                return "Screw" + this.opOrder;
            }
            case 6: {
                return "Nbar" + this.opOrder;
            }
            case 9: {
                return "Glide";
            }
        }
        return null;
    }

    private String getOpName(int opMode) {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        switch (this.opType) {
            case 0: {
                return "I";
            }
            case 1: {
                return "Trans" + SymmetryOperation.op48(this.opTrans);
            }
            case 2: {
                return "Rot" + this.opOrder + SymmetryOperation.op48(this.opPoint) + SymmetryOperation.op48(this.opAxis) + this.opIsCCW;
            }
            case 4: {
                return "Inv" + SymmetryOperation.op48(this.opPoint);
            }
            case 8: {
                return (opMode == 0 ? "" : "Plane") + this.opRound(this.opPlane);
            }
            case 3: {
                return opMode == 0 ? "S" + SymmetryOperation.op48(this.opPoint) + SymmetryOperation.op48(this.opAxis) : "Screw" + this.opOrder + SymmetryOperation.op48(this.opPoint) + SymmetryOperation.op48(this.opAxis) + SymmetryOperation.op48(this.opTrans) + this.opIsCCW;
            }
            case 6: {
                return "Nbar" + this.opOrder + SymmetryOperation.op48(this.opPoint) + SymmetryOperation.op48(this.opAxis) + this.opIsCCW;
            }
            case 9: {
                return (opMode == 0 ? "" : "Glide") + this.opRound(this.opPlane) + (opMode == 2 ? SymmetryOperation.op48(this.opTrans) : "");
            }
        }
        System.out.println("SymmetryOperation REJECTED TYPE FOR " + this);
        return "";
    }

    private String opRound(P4d p) {
        return Math.round(p.x * 1000.0) + "," + Math.round(p.y * 1000.0) + "," + Math.round(p.z * 1000.0) + "," + Math.round(p.w * 1000.0);
    }

    String getOpTitle() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        switch (this.opType) {
            case 0: {
                return "identity ";
            }
            case 1: {
                return "translation " + SymmetryOperation.opFrac(this.opTrans);
            }
            case 2: {
                return "rotation " + this.opOrder;
            }
            case 4: {
                return "inversion center " + SymmetryOperation.opFrac(this.opPoint);
            }
            case 8: {
                return "reflection ";
            }
            case 3: {
                return "screw rotation " + this.opOrder + (this.opIsCCW == null ? "" : (this.opIsCCW == Boolean.TRUE ? "(+) " : "(-) ")) + SymmetryOperation.opFrac(this.opTrans);
            }
            case 6: {
                return this.opOrder + "-bar " + (this.opIsCCW == null ? "" : (this.opIsCCW == Boolean.TRUE ? "(+) " : "(-) ")) + SymmetryOperation.opFrac(this.opPoint);
            }
            case 9: {
                return "glide reflection " + SymmetryOperation.opFrac(this.opTrans);
            }
        }
        return "";
    }

    private static String opFrac(T3d p) {
        return "{" + SymmetryOperation.opF(p.x) + " " + SymmetryOperation.opF(p.y) + " " + SymmetryOperation.opF(p.z) + "}";
    }

    private static String opF(double x) {
        int n48;
        boolean neg;
        if (x == 0.0) {
            return "0";
        }
        boolean bl = neg = x < 0.0;
        if (neg) {
            x = -x;
        }
        int n = 0;
        if (x >= 1.0) {
            n = (int)x;
            x -= (double)n;
        }
        if (PT.approxD((double)(n48 = (int)Math.round(x * 48.0)) / 48.0 - x, 1000.0) != 0.0) {
            return "" + PT.approxD(x, 1000.0);
        }
        int div = n48 % 48 == 0 ? 1 : (n48 % 24 == 0 ? 2 : (n48 % 16 == 0 ? 3 : (n48 % 12 == 0 ? 4 : (n48 % 8 == 0 ? 6 : (n48 % 6 == 0 ? 8 : (n48 % 4 == 0 ? 12 : (n48 % 3 == 0 ? 16 : (n48 % 2 == 0 ? 24 : 48))))))));
        return (neg ? "-" : "") + (n * div + n48 * div / 48) + (div == 1 ? "" : "/" + div);
    }

    private static String op48(T3d p) {
        if (p == null) {
            System.err.println("SymmetryOperation.op48 null");
            return "(null)";
        }
        return "{" + Math.round(p.x * 48.0) + " " + Math.round(p.y * 48.0) + " " + Math.round(p.z * 48.0) + "}";
    }

    public void setSigma(String subsystemCode, Matrix sigma) {
        this.subsystemCode = subsystemCode;
        this.sigma = sigma;
    }

    SymmetryOperation(SymmetryOperation op, int id, boolean doNormalize) {
        this.doNormalize = doNormalize;
        if (op == null) {
            this.opId = id;
            return;
        }
        this.xyzOriginal = op.xyzOriginal;
        this.xyz = op.xyz;
        this.divisor = op.divisor;
        this.opId = op.opId;
        this.modDim = op.modDim;
        this.myLabels = op.myLabels;
        this.number = op.number;
        this.linearRotTrans = op.linearRotTrans;
        this.sigma = op.sigma;
        this.subsystemCode = op.subsystemCode;
        this.timeReversal = op.timeReversal;
        this.setMatrix(false);
        if (!op.isFinalized) {
            this.doFinalize();
        }
    }

    private void setGamma(boolean isReverse) {
        int j;
        int i;
        int n = 3 + this.modDim;
        this.rsvs = new Matrix(null, n + 1, n + 1);
        double[][] a = this.rsvs.getArray();
        double[] t = new double[n];
        int pt = 0;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                a[i][j] = this.linearRotTrans[pt++];
            }
            t[i] = (double)(isReverse ? -1 : 1) * this.linearRotTrans[pt++];
        }
        a[n][n] = 1.0;
        if (isReverse) {
            this.rsvs = this.rsvs.inverse();
        }
        for (i = 0; i < n; ++i) {
            a[i][n] = t[i];
        }
        a = this.rsvs.getSubmatrix(0, 0, 3, 3).getArray();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.setElement(i, j, j < 3 ? a[i][j] : t[i]);
            }
        }
        this.setElement(3, 3, 1.0);
    }

    void doFinalize() {
        SymmetryOperation.div12(this, this.divisor);
        if (this.modDim > 0) {
            double[][] a = this.rsvs.getArray();
            int i = a.length - 1;
            while (--i >= 0) {
                a[i][3 + this.modDim] = SymmetryOperation.finalizeD(a[i][3 + this.modDim], this.divisor);
            }
        }
        this.isFinalized = true;
    }

    private static M4d div12(M4d op, int divisor) {
        op.m03 = SymmetryOperation.finalizeD(op.m03, divisor);
        op.m13 = SymmetryOperation.finalizeD(op.m13, divisor);
        op.m23 = SymmetryOperation.finalizeD(op.m23, divisor);
        return op;
    }

    private static double finalizeD(double m, int divisor) {
        if (divisor == 0) {
            if (m == 0.0) {
                return 0.0;
            }
            int n = (int)m;
            return (float)(n >> 8) * 1.0f / (float)(n & 0xFF);
        }
        return m / (double)divisor;
    }

    String getXyz(boolean normalized) {
        return normalized && this.modDim == 0 || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    public String getxyzTrans(T3d t) {
        M4d m = SymmetryOperation.newM4(this);
        m.add(t);
        return SymmetryOperation.getXYZFromMatrix(m, false, false, false);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(M4d s, boolean isCanonical) {
        SB sb = new SB();
        double[] r = new double[4];
        for (int i = 0; i < 3; ++i) {
            s.getRow(i, r);
            sb.append("[\t");
            for (int j = 0; j < 3; ++j) {
                sb.appendI((int)r[j]).append("\t");
            }
            double trans = r[3];
            if (trans == 0.0) {
                sb.append("0");
            } else {
                sb.append(SymmetryOperation.twelfthsOf(isCanonical ? SymmetryOperation.normalizeTwelfths(trans / 48.0, 48, true) : (double)((int)(trans *= (double)(trans == (double)((int)trans) ? 4 : 48)))));
            }
            sb.append("\t]\n");
        }
        return sb.toString();
    }

    boolean setMatrixFromXYZ(String xyz, int modDim, boolean allowScaling) {
        if (xyz == null) {
            return false;
        }
        this.xyzOriginal = xyz;
        this.divisor = SymmetryOperation.setDivisor(xyz);
        xyz = xyz.toLowerCase();
        this.setModDim(modDim);
        boolean isReverse = false;
        boolean halfOrLess = true;
        if (xyz.startsWith("!")) {
            if (xyz.startsWith("!nohalf!")) {
                halfOrLess = false;
                this.xyzOriginal = xyz = xyz.substring(8);
            } else {
                isReverse = false;
                xyz = xyz.substring(1);
            }
        }
        if (xyz.indexOf("xyz matrix:") == 0) {
            this.xyz = xyz;
            Parser.parseStringInfestedDoubleArray(xyz, null, this.linearRotTrans);
            return this.setFromMatrix(null, isReverse);
        }
        if (xyz.indexOf("[[") == 0) {
            xyz = xyz.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedDoubleArray(xyz, null, this.linearRotTrans);
            int i = this.linearRotTrans.length;
            while (--i >= 0) {
                if (!Double.isNaN(this.linearRotTrans[i])) continue;
                return false;
            }
            this.setMatrix(isReverse);
            this.isFinalized = true;
            this.isBio = xyz.indexOf("bio") >= 0;
            this.xyz = this.isBio ? (this.xyzOriginal = super.toString()) : SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        if (modDim == 0 && xyz.indexOf("x4") >= 0) {
            int i = 14;
            while (--i >= 4) {
                if (xyz.indexOf("x" + i) < 0) continue;
                this.setModDim(i - 3);
                break;
            }
        }
        String mxyz = null;
        if (xyz.endsWith("m")) {
            this.timeReversal = xyz.indexOf("-m") >= 0 ? -1 : 1;
            allowScaling = true;
        } else if (xyz.indexOf("mz)") >= 0) {
            int pt = xyz.indexOf("(");
            mxyz = xyz.substring(pt + 1, xyz.length() - 1);
            xyz = xyz.substring(0, pt);
            allowScaling = false;
        }
        String strOut = SymmetryOperation.getMatrixFromString(this, xyz, this.linearRotTrans, allowScaling, halfOrLess, true);
        if (strOut == null) {
            return false;
        }
        this.xyzCanonical = strOut;
        if (mxyz != null) {
            boolean isProper = M4d.newA16(this.linearRotTrans).determinant3() == 1.0;
            this.timeReversal = xyz.indexOf("-x") < 0 == mxyz.indexOf("-mx") < 0 == isProper ? 1 : -1;
        }
        this.setMatrix(isReverse);
        String string = isReverse ? SymmetryOperation.getXYZFromMatrix(this, true, false, false) : (this.xyz = this.doNormalize ? strOut : xyz);
        if (this.timeReversal != 0) {
            this.xyz = this.xyz + (this.timeReversal == 1 ? ",m" : ",-m");
        }
        if (Logger.debugging) {
            Logger.debug("" + this);
        }
        return true;
    }

    private static int setDivisor(String xyz) {
        int pt = xyz.indexOf(47);
        int len = xyz.length();
        while (pt > 0 && pt < len - 1) {
            char c = xyz.charAt(pt + 1);
            if ("2346".indexOf(c) < 0 || pt < len - 2 && Character.isDigit(xyz.charAt(pt + 2))) {
                return 0;
            }
            pt = xyz.indexOf(47, pt + 1);
        }
        return 12;
    }

    private void setModDim(int dim) {
        int n = (dim + 4) * (dim + 4);
        this.modDim = dim;
        if (dim > 0) {
            this.myLabels = labelsXn;
        }
        this.linearRotTrans = new double[n];
    }

    private void setMatrix(boolean isReverse) {
        if (this.linearRotTrans.length > 16) {
            this.setGamma(isReverse);
        } else {
            this.setA(this.linearRotTrans);
            if (isReverse) {
                P3d p3 = P3d.new3(this.m03, this.m13, this.m23);
                this.invert();
                this.rotate(p3);
                p3.scale(-1.0);
                this.setTranslation(p3);
            }
        }
    }

    boolean setFromMatrix(double[] offset, boolean isReverse) {
        double v = 0.0;
        int pt = 0;
        this.myLabels = this.modDim == 0 ? labelsXYZ : labelsXn;
        int rowPt = 0;
        int n = 3 + this.modDim;
        int i = 0;
        while (rowPt < n) {
            boolean isTrans;
            if (Double.isNaN(this.linearRotTrans[i])) {
                return false;
            }
            v = this.linearRotTrans[i];
            if (Math.abs(v) < (double)1.0E-5f) {
                v = 0.0;
            }
            boolean bl = isTrans = (i + 1) % (n + 1) == 0;
            if (isTrans) {
                int denom;
                int n2 = denom = this.divisor == 0 ? (int)v & 0xFF : this.divisor;
                if (denom == 0) {
                    denom = 12;
                }
                v = SymmetryOperation.finalizeD(v, this.divisor);
                if (offset != null && pt < offset.length) {
                    v += offset[pt++];
                }
                v = SymmetryOperation.normalizeTwelfths((double)(v < 0.0 ? -1 : 1) * Math.abs(v * (double)denom) / (double)denom, denom, this.doNormalize);
                if (this.divisor == 0) {
                    v = SymmetryOperation.toDivisor(v, denom);
                }
                ++rowPt;
            }
            this.linearRotTrans[i] = v;
            ++i;
        }
        this.linearRotTrans[this.linearRotTrans.length - 1] = this.divisor;
        this.setMatrix(isReverse);
        this.isFinalized = offset == null;
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        return true;
    }

    public static M4d getMatrixFromXYZ(String xyz, double[] v, boolean halfOrLess) {
        if (v == null) {
            v = new double[16];
        }
        if ((xyz = SymmetryOperation.getMatrixFromString(null, xyz, v, false, halfOrLess, true)) == null) {
            return null;
        }
        M4d m = new M4d();
        m.setA(v);
        return SymmetryOperation.div12(m, SymmetryOperation.setDivisor(xyz));
    }

    static String getJmolCanonicalXYZ(String xyz) {
        try {
            return SymmetryOperation.getMatrixFromString(null, xyz, null, false, true, true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMatrixFromString(SymmetryOperation op, String xyz, double[] linearRotTrans, boolean allowScaling, boolean halfOrLess, boolean retString) {
        String[] myLabels;
        int transPt;
        int dimOffset;
        int divisor;
        boolean isDenominator = false;
        boolean isDecimal = false;
        boolean isNegative = false;
        xyz = PT.rep(xyz, "[bio[", "");
        int modDim = op == null ? 0 : op.modDim;
        int nRows = 4 + modDim;
        int n = divisor = op == null ? SymmetryOperation.setDivisor(xyz) : op.divisor;
        boolean doNormalize = halfOrLess && (op == null ? !xyz.startsWith("!") : op.doNormalize);
        int n2 = dimOffset = modDim > 0 ? 3 : 0;
        if (linearRotTrans != null) {
            int n3;
            int i = n3 = linearRotTrans.length - 1;
            while (--i >= 0) {
                linearRotTrans[i] = 0.0;
            }
            linearRotTrans[n3] = 1.0;
        }
        if ((transPt = xyz.indexOf(59) + 1) != 0) {
            allowScaling = true;
            if (transPt == xyz.length()) {
                xyz = xyz + "0,0,0";
            }
        }
        int rotPt = -1;
        String[] stringArray = myLabels = op == null || modDim == 0 ? null : op.myLabels;
        if (myLabels == null) {
            myLabels = labelsXYZ;
        }
        xyz = xyz.toLowerCase() + ",";
        xyz = xyz.replace('(', ',');
        if (modDim > 0) {
            xyz = SymmetryOperation.replaceXn(xyz, modDim + 3);
        }
        int xpt = 0;
        int tpt0 = 0;
        int rowPt = 0;
        double iValue = 0.0;
        int denom = 0;
        int numer = 0;
        double decimalMultiplier = 1.0;
        String strT = "";
        String strOut = retString ? "" : null;
        int[] ret = new int[1];
        int len = xyz.length();
        block12: for (int i = 0; i < len; ++i) {
            char ch = xyz.charAt(i);
            switch (ch) {
                case ';': {
                    break;
                }
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block12;
                }
                case '-': {
                    isNegative = true;
                    continue block12;
                }
                case '+': {
                    isNegative = false;
                    continue block12;
                }
                case '/': {
                    denom = 0;
                    isDenominator = true;
                    continue block12;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'x': 
                case 'y': 
                case 'z': {
                    int val;
                    tpt0 = rowPt * nRows;
                    int ipt = ch >= 'x' ? ch - 120 : ch - 97 + dimOffset;
                    xpt = tpt0 + ipt;
                    int n4 = val = isNegative ? -1 : 1;
                    if (allowScaling && iValue != 0.0) {
                        if (linearRotTrans != null) {
                            linearRotTrans[xpt] = iValue;
                        }
                        val = (int)iValue;
                        iValue = 0.0;
                    } else if (linearRotTrans != null) {
                        linearRotTrans[xpt] = val;
                    }
                    if (strOut == null) break;
                    strT = strT + SymmetryOperation.plusMinus(strT, val, myLabels[ipt], false);
                    break;
                }
                case ',': {
                    if (transPt != 0) {
                        if (transPt > 0) {
                            rotPt = i;
                            i = transPt - 1;
                            transPt = -i;
                            iValue = 0.0;
                            denom = 0;
                            continue block12;
                        }
                        transPt = i + 1;
                        i = rotPt;
                    }
                    iValue = SymmetryOperation.normalizeTwelfths(iValue, denom == 0 ? 12 : (divisor == 0 ? denom : divisor), doNormalize);
                    if (linearRotTrans != null) {
                        double d = linearRotTrans[tpt0 + nRows - 1] = divisor == 0 && denom > 0 ? (iValue = (double)SymmetryOperation.toDivisor(numer, denom)) : iValue;
                    }
                    if (strOut != null) {
                        strT = strT + SymmetryOperation.xyzFraction12(iValue, divisor == 0 ? denom : divisor, false, halfOrLess);
                        strOut = strOut + (strOut == "" ? "" : ",") + strT;
                    }
                    if (rowPt == nRows - 2) {
                        return retString ? strOut : "ok";
                    }
                    iValue = 0.0;
                    numer = 0;
                    denom = 0;
                    strT = "";
                    tpt0 += 4;
                    if (rowPt++ <= 2 || modDim != 0) break;
                    Logger.warn("Symmetry Operation? " + xyz);
                    return null;
                }
                case '.': {
                    isDecimal = true;
                    decimalMultiplier = 1.0;
                    continue block12;
                }
                case '0': {
                    if (!isDecimal && divisor == 12 && (isDenominator || !allowScaling)) continue block12;
                }
                default: {
                    int ich = ch - 48;
                    if (ich >= 0 && ich <= 9) {
                        if (isDecimal) {
                            decimalMultiplier /= 10.0;
                            if (iValue < 0.0) {
                                isNegative = true;
                            }
                            iValue += decimalMultiplier * (double)ich * (double)(isNegative ? -1 : 1);
                            continue block12;
                        }
                        if (isDenominator) {
                            ret[0] = i;
                            denom = PT.parseIntNext(xyz, ret);
                            if (denom < 0) {
                                return null;
                            }
                            i = ret[0] - 1;
                            if (iValue == 0.0) {
                                if (linearRotTrans == null) break;
                                int n5 = xpt;
                                linearRotTrans[n5] = linearRotTrans[n5] / (double)denom;
                                break;
                            }
                            numer = (int)iValue;
                            iValue /= (double)denom;
                            break;
                        }
                        iValue = iValue * 10.0 + (double)((isNegative ? -1 : 1) * ich);
                        isNegative = false;
                        break;
                    }
                    Logger.warn("symmetry character?" + ch);
                }
            }
            isNegative = false;
            isDenominator = false;
            isDecimal = false;
        }
        return null;
    }

    static String replaceXn(String xyz, int n) {
        int i = n;
        while (--i >= 0) {
            xyz = PT.rep(xyz, labelsXn[i], labelsXnSub[i]);
        }
        return xyz;
    }

    private static final int toDivisor(double numer, int denom) {
        int n = (int)numer;
        if ((double)n != numer) {
            double f = numer - (double)n;
            denom = (int)Math.abs((double)denom / f);
            n = (int)(Math.abs(numer) / f);
        }
        return (n << 8) + denom;
    }

    private static final String xyzFraction12(double n12ths, int denom, boolean allPositive, boolean halfOrLess) {
        String s;
        if (n12ths == 0.0) {
            return "";
        }
        double n = n12ths;
        if (denom != 12) {
            int in = (int)n;
            denom = in & 0xFF;
            n = in >> 8;
        }
        int half = denom / 2;
        if (allPositive) {
            while (n < 0.0) {
                n += (double)denom;
            }
        } else if (halfOrLess) {
            while (n > (double)half) {
                n -= (double)denom;
            }
            while (n < (double)(-half)) {
                n += (double)denom;
            }
        }
        String string = denom == 12 ? SymmetryOperation.twelfthsOf(n) : (s = n == 0.0 ? "0" : n + "/" + denom);
        return s.charAt(0) == '0' ? "" : (n > 0.0 ? "+" + s : s);
    }

    static final String twelfthsOf(double n12ths) {
        String str = "";
        if (n12ths < 0.0) {
            n12ths = -n12ths;
            str = "-";
        }
        int m = 12;
        int n = (int)Math.round(n12ths);
        if (Math.abs((double)n - n12ths) > (double)0.01f) {
            double fm;
            double f = n12ths / 12.0;
            int max = 20;
            for (m = 3; m < max && !(Math.abs((double)(n = (int)Math.round(fm = f * (double)m)) - fm) < (double)0.01f); ++m) {
            }
            if (m == max) {
                return str + f;
            }
        } else {
            if (n == 12) {
                return str + "1";
            }
            if (n < 12) {
                return str + twelfths[n % 12];
            }
            switch (n % 12) {
                case 0: {
                    return str + n / 12;
                }
                case 2: 
                case 10: {
                    m = 6;
                    break;
                }
                case 3: 
                case 9: {
                    m = 4;
                    break;
                }
                case 4: 
                case 8: {
                    m = 3;
                    break;
                }
                case 6: {
                    m = 2;
                    break;
                }
            }
            n = n * m / 12;
        }
        return str + n + "/" + m;
    }

    private static String plusMinus(String strT, double x, String sx, boolean allowFractions) {
        double a = Math.abs(x);
        return (a < 1.0E-4 ? "" : (x < 0.0 ? "-" : (strT.length() == 0 ? "" : "+")) + (a <= 1.0001 && a > 0.9999 ? "" : (a < 1.0 && allowFractions ? SymmetryOperation.twelfthsOf(a * 12.0) : "" + (int)a))) + sx;
    }

    private static double normalizeTwelfths(double iValue, int divisor, boolean doNormalize) {
        iValue *= (double)divisor;
        int half = divisor / 2;
        if (doNormalize) {
            while (iValue > (double)half) {
                iValue -= (double)divisor;
            }
            while (iValue <= (double)(-half)) {
                iValue += (double)divisor;
            }
        }
        return iValue;
    }

    public static final String getXYZFromMatrix(M4d mat, boolean is12ths, boolean allPositive, boolean halfOrLess) {
        return SymmetryOperation.getXYZFromMatrixFrac(mat, is12ths, allPositive, halfOrLess, false);
    }

    public static final String getXYZFromMatrixFrac(M4d mat, boolean is12ths, boolean allPositive, boolean halfOrLess, boolean allowFractions) {
        SymmetryOperation op;
        String str = "";
        SymmetryOperation symmetryOperation = op = mat instanceof SymmetryOperation ? (SymmetryOperation)mat : null;
        if (op != null && op.modDim > 0) {
            return SymmetryOperation.getXYZFromRsVs(op.rsvs.getRotation(), op.rsvs.getTranslation(), is12ths);
        }
        double[] row = new double[4];
        int denom = (int)mat.getElement(3, 3);
        if (denom == 1) {
            denom = 12;
        } else {
            mat.setElement(3, 3, 1.0);
        }
        for (int i = 0; i < 3; ++i) {
            int lpt = i < 3 ? 0 : 3;
            mat.getRow(i, row);
            String term = "";
            for (int j = 0; j < 3; ++j) {
                double x = row[j];
                if (SymmetryOperation.approx(x) == 0.0) continue;
                term = term + SymmetryOperation.plusMinus(term, x, labelsXYZ[j + lpt], allowFractions);
            }
            if ((is12ths ? row[3] : SymmetryOperation.approx(row[3])) != 0.0) {
                String f = SymmetryOperation.xyzFraction12(is12ths ? row[3] : row[3] * (double)denom, denom, allPositive, halfOrLess);
                if (term == "") {
                    f = f.charAt(0) == '+' ? f.substring(1) : f;
                }
                term = term + f;
            }
            str = str + "," + (term == "" ? "0" : term);
        }
        return str.substring(1);
    }

    public V3d[] rotateAxes(V3d[] vectors, UnitCell unitcell, P3d ptTemp, M3d mTemp) {
        V3d[] vRot = new V3d[3];
        this.getRotationScale(mTemp);
        int i = vectors.length;
        while (--i >= 0) {
            ptTemp.setT(vectors[i]);
            unitcell.toFractional(ptTemp, true);
            mTemp.rotate(ptTemp);
            unitcell.toCartesian(ptTemp, true);
            vRot[i] = V3d.newV(ptTemp);
        }
        return vRot;
    }

    public static String fcoord(T3d p, String sep) {
        return SymmetryOperation.opF(p.x) + sep + SymmetryOperation.opF(p.y) + sep + SymmetryOperation.opF(p.z);
    }

    static double approx(double f) {
        return PT.approxD(f, 100.0);
    }

    static double approx6(double f) {
        return PT.approxD(f, 1000000.0);
    }

    public static String getXYZFromRsVs(Matrix rs, Matrix vs, boolean is12ths) {
        double[][] ra = rs.getArray();
        double[][] va = vs.getArray();
        int d = ra.length;
        String s = "";
        for (int i = 0; i < d; ++i) {
            s = s + ",";
            for (int j = 0; j < d; ++j) {
                double r = ra[i][j];
                if (r == 0.0) continue;
                s = s + (r < 0.0 ? "-" : (s.endsWith(",") ? "" : "+")) + (Math.abs(r) == 1.0 ? "" : "" + (int)Math.abs(r)) + "x" + (j + 1);
            }
            s = s + SymmetryOperation.xyzFraction12((int)(va[i][0] * (double)(is12ths ? 1 : 12)), 12, false, true);
        }
        return PT.rep(s.substring(1), ",+", ",");
    }

    @Override
    public String toString() {
        return this.rsvs == null ? super.toString() : super.toString() + " " + this.rsvs.toString();
    }

    int getMagneticOp() {
        return this.magOp == Integer.MAX_VALUE ? (this.magOp = (int)(this.determinant3() * (double)this.timeReversal)) : this.magOp;
    }

    void setTimeReversal(int magRev) {
        this.timeReversal = magRev;
        if (this.xyz.indexOf("m") >= 0) {
            this.xyz = this.xyz.substring(0, this.xyz.indexOf("m"));
        }
        if (magRev != 0) {
            this.xyz = this.xyz + (magRev == 1 ? ",m" : ",-m");
        }
    }

    V3d getCentering() {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        if (this.centering == null && !this.unCentered) {
            if (this.modDim == 0 && this.m00 == 1.0 && this.m11 == 1.0 && this.m22 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m12 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && (this.m03 != 0.0 || this.m13 != 0.0 || this.m23 != 0.0)) {
                this.isCenteringOp = true;
                this.centering = V3d.new3(this.m03, this.m13, this.m23);
            } else {
                this.unCentered = true;
                this.centering = null;
            }
        }
        return this.centering;
    }

    String fixMagneticXYZ(M4d m, String xyz, boolean addMag) {
        if (this.timeReversal == 0) {
            return xyz;
        }
        int pt = xyz.indexOf("m");
        String string = xyz = (pt -= (3 - this.timeReversal) / 2) < 0 ? xyz : xyz.substring(0, pt);
        if (!addMag) {
            return xyz + (this.timeReversal > 0 ? " +1" : " -1");
        }
        M4d m2 = M4d.newM4(m);
        m2.m23 = 0.0;
        m2.m13 = 0.0;
        m2.m03 = 0.0;
        if (this.getMagneticOp() < 0) {
            m2.scale(-1.0);
        }
        xyz = xyz + "(" + PT.rep(PT.rep(PT.rep(SymmetryOperation.getXYZFromMatrix(m2, false, false, false), "x", "mx"), "y", "my"), "z", "mz") + ")";
        return xyz;
    }

    public Map<String, Object> getInfo() {
        if (this.info == null) {
            this.info = new Hashtable();
            this.info.put("xyz", this.xyz);
            if (this.centering != null) {
                this.info.put("centering", this.centering);
            }
            this.info.put("index", this.number - 1);
            this.info.put("isCenteringOp", this.isCenteringOp);
            if (this.linearRotTrans != null) {
                this.info.put("linearRotTrans", this.linearRotTrans);
            }
            this.info.put("modulationDimension", this.modDim);
            this.info.put("matrix", M4d.newM4(this));
            if ((double)this.magOp != Double.MAX_VALUE) {
                this.info.put("magOp", this.magOp);
            }
            this.info.put("id", this.opId);
            this.info.put("timeReversal", this.timeReversal);
            if (this.xyzOriginal != null) {
                this.info.put("xyzOriginal", this.xyzOriginal);
            }
        }
        return this.info;
    }

    public static void normalizeOperationToCentroid(int dim, M4d m, P3d[] fracPts, int i0, int n) {
        int i;
        if (n <= 0) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (atomTest == null) {
            atomTest = new P3d();
        }
        int i2 = i + n;
        for (i = i0; i < i2; ++i) {
            m.rotTrans2(fracPts[i], atomTest);
            x += SymmetryOperation.atomTest.x;
            y += SymmetryOperation.atomTest.y;
            z += SymmetryOperation.atomTest.z;
        }
        x /= (double)n;
        y /= (double)n;
        z /= (double)n;
        while (x < -0.001 || x >= 1.001) {
            m.m03 = m.m03 + (double)(x < 0.0 ? 1 : -1);
            x += (double)(x < 0.0 ? 1 : -1);
        }
        if (dim > 1) {
            while (y < -0.001 || y >= 1.001) {
                m.m13 = m.m13 + (double)(y < 0.0 ? 1 : -1);
                y += (double)(y < 0.0 ? 1 : -1);
            }
        }
        if (dim > 2) {
            while (z < -0.001 || z >= 1.001) {
                m.m23 = m.m23 + (double)(z < 0.0 ? 1 : -1);
                z += (double)(z < 0.0 ? 1 : -1);
            }
        }
    }

    public static Lst<P3d> getLatticeCentering(SymmetryOperation[] ops) {
        Lst<P3d> list = new Lst<P3d>();
        for (int i = 0; i < ops.length; ++i) {
            V3d c;
            V3d v3d = c = ops[i] == null ? null : ops[i].getCentering();
            if (c == null) continue;
            list.addLast(P3d.newP(c));
        }
        return list;
    }

    public Boolean getOpIsCCW() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opIsCCW;
    }

    public int getOpType() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opType;
    }

    public int getOpOrder() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opOrder;
    }

    public P3d getOpPoint() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opPoint;
    }

    public V3d getOpAxis() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opAxis;
    }

    public P3d getOpPoint2() {
        return this.opPoint2;
    }

    public V3d getOpTrans() {
        if (this.opType == -1) {
            this.setOpTypeAndOrder();
        }
        return this.opTrans == null ? (this.opTrans = new V3d()) : this.opTrans;
    }

    private static int opGet3code(M4d m) {
        int c = 0;
        double[] row = new double[4];
        for (int r = 0; r < 3; ++r) {
            m.getRow(r, row);
            block5: for (int i = 0; i < 3; ++i) {
                switch ((int)row[i]) {
                    case 1: {
                        c |= i + 1 << (2 - r << 3);
                        continue block5;
                    }
                    case -1: {
                        c |= 16 + i + 1 << (2 - r << 3);
                    }
                }
            }
        }
        return c;
    }

    private static T3d opGet3x(M4d m) {
        if (m.m22 != 0.0) {
            return x;
        }
        int c = SymmetryOperation.opGet3code(m);
        for (int i = 0; i < 8; ++i) {
            if (c != C3codes[i]) continue;
            if (xneg == null) {
                xneg = V3d.newV(x);
                xneg.scale(-1.0);
            }
            return xneg;
        }
        return x;
    }

    private void setOpTypeAndOrder() {
        this.clearOp();
        int det = (int)Math.round(this.determinant3());
        int trace = (int)Math.round(this.m00 + this.m11 + this.m22);
        int order = 0;
        int angle = 0;
        T3d px = x;
        switch (trace) {
            case 3: {
                if (SymmetryOperation.hasTrans(this)) {
                    this.opType = 1;
                    this.opTrans = new V3d();
                    this.getTranslation(this.opTrans);
                    this.opOrder = 2;
                } else {
                    this.opType = 0;
                    this.opOrder = 1;
                }
                return;
            }
            case -3: {
                this.opType = 4;
                order = 2;
                break;
            }
            default: {
                order = trace * det + 3;
                if (order == 5) {
                    order = 6;
                }
                if (det > 0) {
                    this.opType = 2;
                    angle = (int)(Math.acos((double)(trace - 1) / 2.0) * 180.0 / Math.PI);
                    if (angle != 120) break;
                    if (this.opX == null) {
                        this.opX = SymmetryOperation.opGet3x(this);
                    }
                    px = this.opX;
                    break;
                }
                if (order == 2) {
                    this.opType = 8;
                    break;
                }
                this.opType = 6;
                if (order == 3) {
                    order = 6;
                }
                if ((angle = (int)(Math.acos((double)(-trace - 1) / 2.0) * 180.0 / Math.PI)) != 120) break;
                if (this.opX == null) {
                    this.opX = SymmetryOperation.opGet3x(this);
                }
                px = this.opX;
            }
        }
        this.opOrder = order;
        M4d m4 = new M4d();
        P3d p1 = new P3d();
        P3d p2 = P3d.newP(px);
        m4.setM4(this);
        P3d p1sum = new P3d();
        P3d p2sum = P3d.newP(p2);
        P3d p2odd = new P3d();
        P3d p2even = P3d.newP(p2);
        P3d p21 = new P3d();
        for (int i = 1; i < order; ++i) {
            m4.mul(this);
            this.rotTrans(p1);
            this.rotTrans(p2);
            if (i == 1) {
                p21.setT(p2);
            }
            p1sum.add(p1);
            p2sum.add(p2);
            if (this.opType != 6) continue;
            if (i % 2 == 0) {
                p2even.add(p2);
                continue;
            }
            p2odd.add(p2);
        }
        this.opTrans = new V3d();
        m4.getTranslation(this.opTrans);
        this.opTrans.scale(1.0 / (double)order);
        double d = SymmetryOperation.approx6(this.opTrans.length());
        this.opPoint = new P3d();
        V3d v = null;
        boolean isOK = true;
        switch (this.opType) {
            case 4: {
                p2sum.add2(p2, px);
                p2sum.scale(0.5);
                this.opPoint = P3d.newP(SymmetryOperation.opClean6(p2sum));
                isOK = SymmetryOperation.checkOpPoint(this.opPoint);
                break;
            }
            case 6: {
                p2odd.scale(2.0 / (double)order);
                p2even.scale(2.0 / (double)order);
                v = V3d.newVsub(p2odd, p2even);
                v.normalize();
                this.opAxis = (V3d)SymmetryOperation.opClean6(v);
                p1sum.add2(p2odd, p2even);
                p2sum.scale(1.0 / (double)order);
                this.opPoint.setT(SymmetryOperation.opClean6(p2sum));
                isOK = SymmetryOperation.checkOpPoint(this.opPoint);
                if (angle == 180) break;
                p2.cross(px, p2);
                this.opIsCCW = p2.dot(v) < 0.0;
                break;
            }
            case 2: {
                v = V3d.newVsub(p2sum, p1sum);
                v.normalize();
                this.opAxis = (V3d)SymmetryOperation.opClean6(v);
                p1sum.scale(1.0 / (double)order);
                p1.setT(p1sum);
                if (d > 0.0) {
                    p1sum.sub(this.opTrans);
                }
                this.opPoint.setT(p1sum);
                SymmetryOperation.opClean6(this.opPoint);
                if (angle != 180) {
                    p2.cross(px, p2);
                    this.opIsCCW = p2.dot(v) < 0.0;
                }
                if (!(isOK &= SymmetryOperation.checkOpAxis(p1, d == 0.0 ? this.opAxis : this.opTrans, p1sum, new V3d(), new V3d(), null))) break;
                this.opPoint.setT(p1sum);
                if (SymmetryOperation.checkOpAxis(this.opPoint, this.opAxis, p2, new V3d(), new V3d(), this.opPoint)) {
                    this.opPoint2 = P3d.newP(p2);
                }
                if (!(d > 0.0)) break;
                p1sum.scaleAdd2(0.5, this.opTrans, this.opPoint);
                isOK = SymmetryOperation.checkOpPoint(p1sum);
                if (this.opPoint2 != null) {
                    p1sum.scaleAdd2(0.5, this.opTrans, this.opPoint2);
                    if (!SymmetryOperation.checkOpPoint(p1sum)) {
                        this.opPoint2 = null;
                    }
                }
                if (!(v.dot(p1) < 0.0)) break;
                isOK = false;
                break;
            }
            case 8: {
                p1.sub(this.opTrans);
                p1.scale(0.5);
                this.opPoint.setT(p1);
                p21.sub(this.opTrans);
                this.opAxis = V3d.newVsub(p21, px);
                p2.scaleAdd2(0.5, this.opAxis, px);
                this.opAxis.normalize();
                this.opPlane = new P4d();
                p1.set(px.x + 1.1, px.y + 1.7, px.z + 2.1);
                p1.scale(0.5);
                this.rotTrans(p1);
                p1.sub(this.opTrans);
                p1.scaleAdd(0.5, px, p1);
                p1.scale(0.5);
                v = new V3d();
                isOK = SymmetryOperation.checkOpPlane(this.opPoint, p1, p2, this.opPlane, v, new V3d());
                SymmetryOperation.opClean6(this.opPlane);
                if (SymmetryOperation.approx6(this.opPlane.w) == 0.0) {
                    this.opPlane.w = 0.0;
                }
                SymmetryOperation.approx6Pt(this.opAxis);
                SymmetryOperation.normalizePlane(this.opPlane);
            }
        }
        if (d > 0.0) {
            SymmetryOperation.opClean6(this.opTrans);
            double dmax = 1.0;
            if (this.opType == 8) {
                if (this.opTrans.z == 0.0 && this.opTrans.lengthSquared() == 1.25 || this.opTrans.z == 0.5 && this.opTrans.lengthSquared() == 1.5) {
                    dmax = 1.25;
                    this.opIsLong = true;
                } else {
                    dmax = 0.78;
                }
                this.opGlide = V3d.newV(this.opTrans);
                this.fixNegTrans(this.opGlide);
                if (this.opGlide.length() == 0.0) {
                    this.opGlide = null;
                }
                if ((this.opTrans.x == 1.0 || this.opTrans.y == 1.0 || this.opTrans.z == 1.0) && this.m22 == -1.0) {
                    isOK = false;
                }
            } else if (this.opTrans.z == 0.0 && this.opTrans.lengthSquared() == 1.25) {
                dmax = 1.25;
                this.opIsLong = true;
            }
            this.opType |= 1;
            if (Math.abs(SymmetryOperation.approx(this.opTrans.x)) >= dmax || Math.abs(SymmetryOperation.approx(this.opTrans.y)) >= dmax || Math.abs(SymmetryOperation.approx(this.opTrans.z)) >= dmax) {
                isOK = false;
            }
        } else {
            this.opTrans = null;
        }
        if (!isOK) {
            this.isIrrelevant = true;
        }
    }

    private void fixNegTrans(V3d t) {
        t.x = SymmetryOperation.normHalf(t.x);
        t.y = SymmetryOperation.normHalf(t.y);
        t.z = SymmetryOperation.normHalf(t.z);
    }

    private static void normalizePlane(P4d plane) {
        SymmetryOperation.approx6Pt(plane);
        plane.w = SymmetryOperation.approx6(plane.w);
        if (plane.w > 0.0 || plane.w == 0.0 && (plane.x < 0.0 || plane.x == 0.0 && plane.y < 0.0 || plane.y == 0.0 && plane.z < 0.0)) {
            plane.scale4(-1.0);
        }
        SymmetryOperation.opClean6(plane);
        plane.w = SymmetryOperation.approx6(plane.w);
    }

    private static boolean isCoaxial(T3d v) {
        return Math.abs(SymmetryOperation.approx(v.x)) == 1.0 || Math.abs(SymmetryOperation.approx(v.y)) == 1.0 || Math.abs(SymmetryOperation.approx(v.z)) == 1.0;
    }

    private void clearOp() {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        this.isIrrelevant = false;
        this.opTrans = null;
        this.opPoint2 = null;
        this.opPoint = null;
        this.opPlane = null;
        this.opIsCCW = null;
        this.opIsLong = false;
    }

    private static boolean hasTrans(M4d m4) {
        return SymmetryOperation.approx6(m4.m03) != 0.0 || SymmetryOperation.approx6(m4.m13) != 0.0 || SymmetryOperation.approx6(m4.m23) != 0.0;
    }

    private static boolean checkOpAxis(P3d pt, V3d axis2, P3d ptRet, V3d t1, V3d t2, P3d ptNot) {
        if (opPlanes == null) {
            opPlanes = BoxInfo.getBoxFacesFromOABC(null);
        }
        int[] map = BoxInfo.faceOrder;
        double f = ptNot == null ? 1 : -1;
        for (int i = 0; i < 6; ++i) {
            P3d p = MeasureD.getIntersection(pt, axis2, opPlanes[map[i]], ptRet, t1, t2);
            if (p == null || !SymmetryOperation.checkOpPoint(p) || !(axis2.dot(t1) * f < 0.0) || ptNot != null && !(SymmetryOperation.approx(ptNot.distance(p) - 0.5) >= 0.0)) continue;
            return true;
        }
        return false;
    }

    static T3d opClean6(T3d t) {
        if (SymmetryOperation.approx6(t.x) == 0.0) {
            t.x = 0.0;
        }
        if (SymmetryOperation.approx6(t.y) == 0.0) {
            t.y = 0.0;
        }
        if (SymmetryOperation.approx6(t.z) == 0.0) {
            t.z = 0.0;
        }
        return t;
    }

    static boolean checkOpPoint(T3d pt) {
        return SymmetryOperation.checkOK(pt.x, 0.0) && SymmetryOperation.checkOK(pt.y, 0.0) && SymmetryOperation.checkOK(pt.z, 0.0);
    }

    private static boolean checkOK(double p, double a) {
        return a != 0.0 || SymmetryOperation.approx(p) >= 0.0 && SymmetryOperation.approx(p) <= 1.0;
    }

    private static boolean checkOpPlane(P3d p1, P3d p2, P3d p3, P4d plane, V3d vtemp1, V3d vtemp2) {
        MeasureD.getPlaneThroughPoints(p1, p2, p3, vtemp1, vtemp2, plane);
        P3d[] pts = BoxInfo.unitCubePoints;
        int nPos = 0;
        int nNeg = 0;
        int i = 8;
        while (--i >= 0) {
            double d = MeasureD.getPlaneProjection(pts[i], plane, p1, vtemp1);
            switch ((int)Math.signum(SymmetryOperation.approx6(d))) {
                case 1: {
                    if (nNeg > 0) {
                        return true;
                    }
                    ++nPos;
                    break;
                }
                case 0: {
                    break;
                }
                case -1: {
                    if (nPos > 0) {
                        return true;
                    }
                    ++nNeg;
                }
            }
        }
        return nNeg != 8 && nPos != 8;
    }

    public static SymmetryOperation[] getAdditionalOperations(SymmetryOperation[] ops, int per_dim) {
        int i;
        int n = ops.length;
        Lst<SymmetryOperation> lst = new Lst<SymmetryOperation>();
        SB xyzLst = new SB();
        Hashtable<String, Lst<SymmetryOperation>> mapPlanes = new Hashtable<String, Lst<SymmetryOperation>>();
        V3d vTemp = new V3d();
        for (i = 0; i < n; ++i) {
            SymmetryOperation op = ops[i];
            op.opPerDim = per_dim;
            lst.addLast(op);
            String s = op.getOpName(1);
            xyzLst.append(s).appendC(';');
            if ((op.getOpType() & 8) != 0) {
                SymmetryOperation.addCoincidentMap(mapPlanes, op, 8, vTemp);
                continue;
            }
            if (op.getOpType() != 3) continue;
            SymmetryOperation.addCoincidentMap(mapPlanes, op, 3, null);
        }
        for (i = 1; i < n; ++i) {
            ops[i].addOps(xyzLst, lst, mapPlanes, n, i, vTemp);
        }
        return lst.toArray(new SymmetryOperation[lst.size()]);
    }

    private void addOps(SB xyzList, Lst<SymmetryOperation> lst, Map<String, Lst<SymmetryOperation>> mapCoincident, int n0, int isym, V3d vTemp) {
        V3d t0 = new V3d();
        this.getTranslation(t0);
        boolean isPlane = (this.getOpType() & 8) == 8;
        boolean isScrew = this.getOpType() == 3;
        V3d t = new V3d();
        SymmetryOperation opTemp = null;
        int i0 = 5;
        int i1 = -2;
        int j0 = 5;
        int j1 = -2;
        int k0 = 5;
        int k1 = -2;
        switch (this.opPerDim) {
            case 115: {
                break;
            }
            case 34: 
            case 51: {
                k0 = 1;
                k1 = 0;
                break;
            }
            case 18: 
            case 19: {
                j0 = 1;
                j1 = 0;
                k0 = 1;
                k1 = 0;
                break;
            }
            case 67: {
                i0 = 1;
                i1 = 0;
                j0 = 1;
                j1 = 0;
                break;
            }
            case 35: {
                i0 = 1;
                i1 = 0;
                k0 = 1;
                k1 = 0;
            }
        }
        int i = i0;
        while (--i >= i1) {
            int j = j0;
            while (--j >= j1) {
                int k = k0;
                while (--k >= k1) {
                    if (opTemp == null) {
                        opTemp = new SymmetryOperation(null, 0, false);
                    }
                    t.set(i, j, k);
                    if (this.checkOpSimilar(t, vTemp) || !opTemp.opCheckAdd(this, t0, n0, t, xyzList, lst, isym + 1)) continue;
                    if (isPlane) {
                        SymmetryOperation.addCoincidentMap(mapCoincident, opTemp, 8, vTemp);
                    } else if (isScrew) {
                        SymmetryOperation.addCoincidentMap(mapCoincident, opTemp, 3, null);
                    }
                    opTemp = null;
                }
            }
        }
    }

    private static void addCoincidentMap(Map<String, Lst<SymmetryOperation>> mapCoincident, SymmetryOperation op, int opType, V3d vTemp) {
        boolean isRotation;
        if (op.isIrrelevant) {
            return;
        }
        String s = op.getOpName(0);
        Lst<SymmetryOperation> l = mapCoincident.get(s);
        op.iCoincident = 0;
        boolean bl = isRotation = opType == 3;
        if (l == null) {
            l = new Lst();
            mapCoincident.put(s, l);
        } else if (isRotation) {
            if (op.opOrder == 6) {
                int i = l.size();
                while (--i >= 0) {
                    SymmetryOperation op1 = (SymmetryOperation)l.get(i);
                    if (op1.isIrrelevant) continue;
                    switch (op1.opOrder) {
                        case 3: {
                            op1.isIrrelevant = true;
                            break;
                        }
                    }
                }
            }
            op.iCoincident = 1;
        } else {
            SymmetryOperation op0 = null;
            int i = l.size();
            while (--i >= 0) {
                op0 = (SymmetryOperation)l.get(i);
                if (op.opGlide != null && op0.opGlide != null) {
                    vTemp.sub2(op.opGlide, op0.opGlide);
                    if (vTemp.lengthSquared() < 1.0E-6) {
                        op.isIrrelevant = true;
                        return;
                    }
                    vTemp.add2(op.opGlide, op0.opGlide);
                    if (vTemp.lengthSquared() < 1.0E-6) {
                        op.isIrrelevant = true;
                        return;
                    }
                    vTemp.add2(op.opAxis, op0.opAxis);
                    if (!(vTemp.lengthSquared() < 1.0E-6)) continue;
                    op.isIrrelevant = true;
                    return;
                }
                if (op.opGlide != null || op0.opGlide != null) continue;
                vTemp.add2(op.opAxis, op0.opAxis);
                if (vTemp.lengthSquared() < 1.0E-6) {
                    op.isIrrelevant = true;
                    return;
                }
                vTemp.sub2(op.opAxis, op0.opAxis);
                if (!(vTemp.lengthSquared() < 1.0E-6)) continue;
                op.isIrrelevant = true;
                return;
            }
            if (op0.iCoincident == 0) {
                op.iCoincident = 1;
                op0.iCoincident = -1;
            } else {
                op.iCoincident = -op0.iCoincident;
            }
        }
        l.addLast(op);
    }

    private boolean checkOpSimilar(V3d t, V3d vTemp) {
        switch (this.getOpType() & 0xFFFFFFFE) {
            default: {
                return false;
            }
            case 0: {
                return true;
            }
            case 2: {
                return SymmetryOperation.approx6(t.dot(this.opAxis) - t.length()) == 0.0;
            }
            case 8: 
        }
        vTemp.cross(t, this.opAxis);
        return SymmetryOperation.approx6(vTemp.length()) == 0.0 ? false : SymmetryOperation.approx6(t.dot(this.opAxis)) == 0.0;
    }

    private boolean opCheckAdd(SymmetryOperation opThis, V3d t0, int n0, V3d t, SB xyzList, Lst<SymmetryOperation> lst, int itno) {
        this.setM4(opThis);
        V3d t1 = V3d.newV(t);
        t1.add(t0);
        this.setTranslation(t1);
        this.isFinalized = true;
        this.setOpTypeAndOrder();
        if (this.isIrrelevant || this.opType == 0 || this.opType == 1) {
            return false;
        }
        String s = this.getOpName(1) + ";";
        if ((this.opType & 8) == 0 && xyzList.indexOf(s) >= 0) {
            return false;
        }
        xyzList.append(s);
        lst.addLast(this);
        this.isFinalized = true;
        this.xyz = SymmetryOperation.getXYZFromMatrix(this, false, false, false);
        return true;
    }

    static void approx6Pt(T3d pt) {
        if (pt != null) {
            pt.x = SymmetryOperation.approx6(pt.x);
            pt.y = SymmetryOperation.approx6(pt.y);
            pt.z = SymmetryOperation.approx6(pt.z);
        }
    }

    public static void normalize12ths(V3d vtrans) {
        vtrans.x = PT.approxD(vtrans.x, 12.0);
        vtrans.y = PT.approxD(vtrans.y, 12.0);
        vtrans.z = PT.approxD(vtrans.z, 12.0);
    }

    public String getCode() {
        if (this.opAxisCode != null) {
            return this.opAxisCode;
        }
        int t = this.getOpName(2).charAt(0);
        int o = this.opOrder;
        int ccw = this.opIsCCW == null ? 0 : (this.opIsCCW == Boolean.TRUE ? 1 : 2);
        String g = "";
        String m = "";
        switch (t) {
            case 71: {
                t = SymmetryOperation.getGlideFromTrans(this.opTrans, this.opPlane);
            }
            case 80: {
                if (SymmetryOperation.isCoaxial(this.opAxis)) break;
                t = (char)(t == 80 ? 112 : (char)(t - 32));
                break;
            }
            case 83: {
                double d = this.opTrans.length();
                if (this.opIsCCW == null || d < (d > 1.0 ? 6.0 : 0.5) != (this.opIsCCW == Boolean.TRUE)) break;
                t = 119;
                break;
            }
            case 82: {
                if (!SymmetryOperation.isCoaxial(this.opAxis)) {
                    t = 111;
                }
                if (this.opPoint.length() != 0.0) break;
                t = t == 111 ? 113 : 81;
                break;
            }
        }
        this.opAxisCode = g + m + (char)t + "." + (char)(48 + o) + "." + ccw + ".";
        return this.opAxisCode;
    }

    public static char getGlideFromTrans(T3d ftrans, T3d ax1) {
        double fx = Math.abs(SymmetryOperation.approx(ftrans.x * 12.0));
        double fy = Math.abs(SymmetryOperation.approx(ftrans.y * 12.0));
        double fz = Math.abs(SymmetryOperation.approx(ftrans.z * 12.0));
        if (fx == 9.0) {
            fx = 3.0;
        }
        if (fy == 9.0) {
            fy = 3.0;
        }
        if (fz == 9.0) {
            fz = 3.0;
        }
        int nonzero = 3;
        if (fx == 0.0) {
            --nonzero;
        }
        if (fy == 0.0) {
            --nonzero;
        }
        if (fz == 0.0) {
            --nonzero;
        }
        int sum = (int)(fx + fy + fz);
        switch (nonzero) {
            default: {
                return (char)(fx != 0.0 ? 97 : (fy != 0.0 ? 98 : 99));
            }
            case 2: {
                switch (sum) {
                    case 6: {
                        return 'd';
                    }
                    case 12: {
                        P3d n = P3d.newP(ax1);
                        n.normalize();
                        if (Math.abs(SymmetryOperation.approx(n.x + n.y + n.z)) != 1.0) break;
                        return 'n';
                    }
                }
                break;
            }
            case 3: {
                switch (sum) {
                    case 9: {
                        return 'd';
                    }
                    case 18: {
                        return 'n';
                    }
                }
            }
        }
        return 'g';
    }

    static void rotateAndTranslatePoint(M4d m, P3d src, int ta, int tb, int tc, P3d dest) {
        m.rotTrans2(src, dest);
        dest.add3(ta, tb, tc);
    }

    static String transformStr(String xyz, M4d trm, M4d trmInv, M4d t, double[] v, T3d centering, T3d targetCentering, boolean normalize, boolean allowFractions) {
        if (trmInv == null) {
            trmInv = M4d.newM4(trm);
            trmInv.invert();
        }
        if (t == null) {
            t = new M4d();
        }
        if (v == null) {
            v = new double[16];
        }
        M4d op = SymmetryOperation.getMatrixFromXYZ(xyz, v, true);
        if (centering != null) {
            op.add(centering);
        }
        t.setM4(trmInv);
        t.mul(op);
        if (trm != null) {
            t.mul(trm);
        }
        if (targetCentering != null) {
            op.add(targetCentering);
        }
        if (normalize) {
            t.getColumn(3, v);
            for (int i = 0; i < 3; ++i) {
                v[i] = (10.0 + v[i]) % 1.0;
            }
            t.setColumnA(3, v);
        }
        return SymmetryOperation.getXYZFromMatrixFrac(t, false, true, false, allowFractions);
    }

    static M4d stringToMatrix(String xyz) {
        int divisor = SymmetryOperation.setDivisor(xyz);
        double[] a = new double[16];
        SymmetryOperation.getMatrixFromString(null, xyz, a, true, false, false);
        return SymmetryOperation.div12(M4d.newA16(a), divisor);
    }

    public static String getTransformABC(Object transform, boolean normalize) {
        if (transform == null) {
            return "a,b,c";
        }
        M4d t = (M4d)transform;
        M4d m = M4d.newM4(t);
        V3d tr = new V3d();
        m.getTranslation(tr);
        tr.scale(-1.0);
        m.add(tr);
        m.transpose();
        String s = SymmetryOperation.getXYZFromMatrixFrac(m, false, true, false, true).replace('x', 'a').replace('y', 'b').replace('z', 'c');
        if (tr.lengthSquared() < 1.0E-12) {
            return s;
        }
        tr.scale(-1.0);
        return s + ";" + (normalize ? SymmetryOperation.norm3(tr) : SymmetryOperation.opF(tr.x) + "," + SymmetryOperation.opF(tr.y) + "," + SymmetryOperation.opF(tr.z));
    }

    static String norm3(T3d tr) {
        return SymmetryOperation.norm(tr.x) + "," + SymmetryOperation.norm(tr.y) + "," + SymmetryOperation.norm(tr.z);
    }

    private static String norm(double d) {
        return SymmetryOperation.opF(SymmetryOperation.normHalf(d));
    }

    private static double normHalf(double d) {
        while (d <= -0.5) {
            d += 1.0;
        }
        while (d > 0.5) {
            d -= 1.0;
        }
        return d;
    }

    static P3d toPoint(String xyz, P3d p) {
        if (p == null) {
            p = new P3d();
        }
        String[] s = PT.split(xyz, ",");
        p.set(PT.parseDoubleFraction(s[0]), PT.parseDoubleFraction(s[1]), PT.parseDoubleFraction(s[2]));
        return p;
    }

    static {
        twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};
        labelsXYZ = new String[]{"x", "y", "z"};
        labelsXn = new String[]{"x1", "x2", "x3", "x4", "x5", "x6", "x7", "x8", "x9", "x10", "x11", "x12", "x13"};
        labelsXnSub = new String[]{"x", "y", "z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j"};
        x = P3d.new3(Math.PI, Math.E, 8.539734222673566);
        C3codes = new int[]{200978, 1184513, 1245458, 135953, 1245442, 131857, 200962, 1180417};
    }
}

