/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapebio;

import javajs.util.BS;
import org.jmol.atomdata.RadiusData;
import org.jmol.modelset.Atom;
import org.jmol.shapebio.BioShape;
import org.jmol.shapebio.BioShapeCollection;

public class Backbone
extends BioShapeCollection {
    BS bsSelected;

    @Override
    public void initShape() {
        this.madOn = 1;
        this.madHelixSheet = (short)1500;
        this.madTurnRandom = (short)500;
        this.madDnaRna = (short)2000;
        this.isActive = true;
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bsSelected) {
        if ("bitset" == propertyName) {
            this.bsSelected = (BS)value;
            return;
        }
        this.setPropBSC(propertyName, value, bsSelected);
    }

    @Override
    public void setShapeSizeRD(int size, RadiusData rd, BS bsSelected) {
        boolean useThisBsSelected;
        short mad = (short)size;
        this.initialize();
        boolean bl = useThisBsSelected = this.bsSelected != null;
        if (useThisBsSelected) {
            bsSelected = this.bsSelected;
        }
        int iShape = this.bioShapes.length;
        while (--iShape >= 0) {
            boolean isVisible;
            BioShape bioShape = this.bioShapes[iShape];
            if (bioShape.monomerCount == 0) continue;
            boolean bondSelectionModeOr = this.vwr.getBoolean(0x24000024);
            int[] atomIndices = bioShape.bioPolymer.getLeadAtomIndices();
            boolean bl2 = isVisible = mad != 0;
            if (bioShape.bsSizeSet == null) {
                bioShape.bsSizeSet = new BS();
            }
            bioShape.isActive = true;
            int n = bioShape.monomerCount;
            int i = n - (bioShape.bioPolymer.isCyclic() ? 0 : 1);
            while (--i >= 0) {
                boolean wasVisible;
                int index1 = atomIndices[i];
                int index2 = atomIndices[(i + 1) % n];
                boolean isAtom1 = bsSelected.get(index1);
                boolean isAtom2 = bsSelected.get(index2);
                if (!(isAtom1 && isAtom2 || useThisBsSelected && isAtom1) && (!bondSelectionModeOr || !isAtom1 && !isAtom2)) continue;
                bioShape.monomers[i].setShapeVisibility(this.vf, isVisible);
                Atom atomA = this.ms.at[index1];
                if (rd != null) {
                    if (Double.isNaN(rd.values[index1]) || Double.isNaN(rd.values[index2])) continue;
                    mad = (short)((rd.values[index1] + rd.values[index2]) * 1000.0);
                    isVisible = mad != 0;
                }
                Atom atomB = this.ms.at[index2];
                boolean bl3 = wasVisible = bioShape.mads[i] != 0;
                if (wasVisible != isVisible) {
                    this.addDisplayedBackbone(atomA, isVisible);
                    this.addDisplayedBackbone(atomB, isVisible);
                }
                bioShape.mads[i] = mad;
                bioShape.bsSizeSet.setBitTo(i, isVisible);
                bioShape.bsSizeDefault.setBitTo(i, mad == -1);
            }
        }
        if (useThisBsSelected) {
            this.bsSelected = null;
        }
    }

    public void addDisplayedBackbone(Atom a, boolean isVisible) {
        a.nBackbonesDisplayed = a.nBackbonesDisplayed + (isVisible ? 1 : -1);
        a.setShapeVisibility(this.vf, isVisible);
    }

    @Override
    public void setAtomClickability() {
        if (this.bioShapes == null) {
            return;
        }
        int iShape = this.bioShapes.length;
        while (--iShape >= 0) {
            BioShape bioShape = this.bioShapes[iShape];
            int[] atomIndices = bioShape.bioPolymer.getLeadAtomIndices();
            int i = bioShape.monomerCount;
            while (--i >= 0) {
                Atom atom = this.ms.at[atomIndices[i]];
                if (atom.nBackbonesDisplayed <= 0 || this.ms.isAtomHidden(atom.i)) continue;
                atom.setClickable(this.vf);
            }
        }
    }
}

