/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.PT;
import javajs.util.Qd;
import javajs.util.SB;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.SymmetryInterface;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.MeshSurface;
import org.jmol.util.Normix;
import org.jmol.viewer.Viewer;

public class Mesh
extends MeshSurface {
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    public String[] title;
    public String hoverLabel;
    public short meshColix;
    public short[] normixes;
    public Lst<P3d[]> lineData;
    public String thisID;
    public boolean isValid = true;
    public String scriptCommand;
    public String colorCommand;
    public P3d lattice;
    public M4d[] symops;
    public short[][] symopNormixes;
    public boolean visible = true;
    public int lighting = 1073741958;
    public int colorType;
    public boolean reverseColor;
    public boolean haveXyPoints;
    public int diameter;
    public double width;
    public P3d ptCenter;
    public Mesh linkedMesh;
    public Map<String, BS> vertexColorMap;
    public V3d vAB;
    public V3d vTemp;
    public int color;
    public boolean useColix = true;
    public SymmetryInterface unitCell;
    public double scale3d = 0.0;
    public int index;
    public int atomIndex = -1;
    public int modelIndex = -1;
    public int visibilityFlags;
    public boolean insideOut;
    public int checkByteCount;
    private boolean normalsInverted;
    public boolean showContourLines = false;
    public boolean showPoints = false;
    public boolean drawTriangles = false;
    public boolean fillTriangles = true;
    public boolean showTriangles = false;
    public boolean frontOnly = false;
    public boolean isShell = false;
    public boolean isTwoSided = true;
    public boolean havePlanarContours = false;
    protected BS bsTemp;
    public boolean colorDensity;
    public Object cappingObject;
    public Object slabbingObject;
    public double volumeRenderPointSize = 0.15;
    public int[] connectedAtoms;
    public boolean isModelConnected;
    public boolean recalcAltVertices;
    public short[] symopColixes;
    public String scriptVariables;

    public void setVisibilityFlags(int n) {
        this.visibilityFlags = n;
    }

    public Mesh mesh1(Viewer vwr, String thisID, short colix, int index) {
        if (PREVIOUS_MESH_ID.equals(thisID)) {
            thisID = null;
        }
        this.vwr = vwr;
        this.thisID = thisID;
        this.colix = colix;
        this.index = index;
        this.ptCenter = new P3d();
        this.vAB = new V3d();
        this.vTemp = new V3d();
        return this;
    }

    public void clear(String meshType) {
        this.clearMesh(meshType);
    }

    public void clearMesh(String meshType) {
        this.altVertices = null;
        this.bsDisplay = null;
        this.bsSlabDisplay = null;
        this.bsSlabGhost = null;
        this.symops = null;
        this.symopColixes = null;
        this.cappingObject = null;
        this.colix = (short)23;
        this.colorDensity = false;
        this.connectedAtoms = null;
        this.diameter = 0;
        this.drawTriangles = false;
        this.fillTriangles = true;
        this.frontOnly = false;
        this.isShell = false;
        this.havePlanarContours = false;
        this.haveXyPoints = false;
        this.isModelConnected = false;
        this.isDrawPolygon = false;
        this.isTwoSided = false;
        this.lattice = null;
        this.mat4 = null;
        this.normixes = null;
        this.pis = null;
        this.scale3d = 0.0;
        this.showContourLines = false;
        this.showPoints = false;
        this.showTriangles = false;
        this.slabbingObject = null;
        this.slabOptions = null;
        this.oabc = null;
        this.symopNormixes = null;
        this.title = null;
        this.unitCell = null;
        this.useColix = true;
        this.pc = 0;
        this.vc = 0;
        this.polygonCount0 = 0;
        this.vertexCount0 = 0;
        this.vs = null;
        this.vertexSource = null;
        this.volumeRenderPointSize = 0.15;
        this.meshType = meshType;
    }

    public void initialize(int lighting, T3d[] vertices, P4d plane) {
        if (vertices == null) {
            vertices = this.vs;
        }
        V3d[] normals = this.getNormals(vertices, plane);
        this.setNormixes(normals);
        this.lighting = 1073741958;
        if (this.insideOut) {
            this.invertNormixes();
        }
        if (this.isShell && !this.isTwoSided) {
            this.invertNormixes();
        }
        this.setLighting(lighting);
    }

    public short[] setNormixes(V3d[] normals) {
        if (normals == null) {
            this.normixes = null;
            return null;
        }
        this.normixes = new short[this.normixCount];
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        if (this.haveXyPoints) {
            int i = this.normixCount;
            while (--i >= 0) {
                this.normixes[i] = 9999;
            }
        } else {
            int i = this.normixCount;
            while (--i >= 0) {
                this.normixes[i] = Normix.getNormixV(normals[i], this.bsTemp);
            }
        }
        return this.normixes;
    }

    public V3d[] getNormals(T3d[] vertices, P4d plane) {
        int n = this.normixCount = this.isDrawPolygon ? this.pc : this.vc;
        if (this.normixCount < 0) {
            return null;
        }
        V3d[] normals = new V3d[this.normixCount];
        int i = this.normixCount;
        while (--i >= 0) {
            normals[i] = new V3d();
        }
        if (plane == null) {
            this.sumVertexNormals(vertices, normals);
        } else {
            V3d normal = V3d.new3(plane.x, plane.y, plane.z);
            int i2 = this.normixCount;
            while (--i2 >= 0) {
                normals[i2] = normal;
            }
        }
        if (!this.isDrawPolygon) {
            i = this.normixCount;
            while (--i >= 0) {
                normals[i].normalize();
            }
        }
        return normals;
    }

    public void setLighting(int lighting) {
        boolean bl = this.isTwoSided = lighting == 1073741964;
        if (lighting == this.lighting) {
            return;
        }
        this.flipLighting(this.lighting);
        this.lighting = lighting;
        this.flipLighting(this.lighting);
    }

    private void flipLighting(int lighting) {
        if (lighting == 1073741964) {
            int i = this.normixCount;
            while (--i >= 0) {
                this.normixes[i] = ~this.normixes[i];
            }
        } else if (lighting == 1073741958 == this.insideOut) {
            this.invertNormixes();
        }
    }

    private void invertNormixes() {
        Normix.setInverseNormixes();
        this.normalsInverted = !this.normalsInverted;
        int i = this.normixCount;
        while (--i >= 0) {
            this.normixes[i] = Normix.getInverseNormix(this.normixes[i]);
        }
    }

    public void setTranslucent(boolean isTranslucent, double iLevel) {
        this.colix = C.getColixTranslucent3(this.colix, isTranslucent, iLevel);
    }

    protected void sumVertexNormals(T3d[] vertices, V3d[] normals) {
        Mesh.sumVertexNormals2(this, vertices, normals);
    }

    protected static void sumVertexNormals2(Mesh m, T3d[] vertices, V3d[] normals) {
        int adjustment = m.checkByteCount;
        double min = m.getMinDistance2ForVertexGrouping();
        int i = m.pc;
        while (--i >= 0) {
            try {
                int[] face = m.setABC(i);
                if (face == null) continue;
                T3d vA = vertices[face[0]];
                T3d vB = vertices[face[1]];
                T3d vC = vertices[face[2]];
                if (vA.distanceSquared(vB) < min || vB.distanceSquared(vC) < min || vA.distanceSquared(vC) < min) continue;
                MeasureD.calcNormalizedNormal(vA, vB, vC, m.vTemp, m.vAB);
                if (m.isDrawPolygon) {
                    normals[i].setT(m.vTemp);
                    continue;
                }
                double l = m.vTemp.length();
                if (!(l > 0.9) || !(l < 1.1)) continue;
                int j = face.length - adjustment;
                while (--j >= 0) {
                    int k = face[j];
                    normals[k].add(m.vTemp);
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    protected double getMinDistance2ForVertexGrouping() {
        return 1.0E-8;
    }

    public String getState(String type) {
        SB s = new SB();
        if (this.isValid) {
            s.append(type);
            if (!type.equals("mo") && !type.equals("nbo")) {
                s.append(" ID ").append(PT.esc(this.thisID));
            }
            if (this.lattice != null) {
                s.append(" lattice ").append(Escape.eP(this.lattice));
            }
            if (this.meshColix != 0) {
                s.append(" color mesh ").append(C.getHexCode(this.meshColix));
            }
            s.append(this.getRendering());
            if (!this.visible) {
                s.append(" hidden");
            }
            if (this.bsDisplay != null) {
                s.append(";\n  ").append(type);
                if (!type.equals("mo") && !type.equals("nbo")) {
                    s.append(" ID ").append(PT.esc(this.thisID));
                }
                s.append(" display " + Escape.eBS(this.bsDisplay));
            }
        }
        return s.toString();
    }

    protected String getRendering() {
        SB s = new SB();
        s.append(this.fillTriangles ? " fill" : " noFill");
        s.append(this.drawTriangles ? " mesh" : " noMesh");
        s.append(this.showPoints ? " dots" : " noDots");
        s.append(this.frontOnly ? " frontOnly" : " notFrontOnly");
        if (this.showContourLines) {
            s.append(" contourlines");
        }
        if (this.showTriangles) {
            s.append(" triangles");
        }
        s.append(" ").append(T.nameOf(this.lighting));
        if (this.isShell && !this.isTwoSided) {
            s.append(" backshell");
        }
        return s.toString();
    }

    public P3d[] getOffsetVertices(P4d thePlane) {
        if (this.altVertices != null && !this.recalcAltVertices) {
            return (P3d[])this.altVertices;
        }
        this.altVertices = new P3d[this.vc];
        for (int i = 0; i < this.vc; ++i) {
            this.altVertices[i] = P3d.newP(this.vs[i]);
        }
        V3d normal = null;
        double val = 0.0;
        if (this.scale3d != 0.0 && this.vvs != null && thePlane != null) {
            normal = V3d.new3(thePlane.x, thePlane.y, thePlane.z);
            normal.normalize();
            normal.scale(this.scale3d);
            if (this.mat4 != null) {
                M3d m3 = new M3d();
                this.mat4.getRotationScale(m3);
                m3.rotate(normal);
            }
        }
        for (int i = 0; i < this.vc; ++i) {
            if (this.vvs != null && Double.isNaN(val = this.vvs[i])) continue;
            P3d pt = (P3d)this.altVertices[i];
            if (this.mat4 != null) {
                this.mat4.rotTrans(pt);
            }
            if (normal == null || val == 0.0) continue;
            pt.scaleAdd2(val, normal, pt);
        }
        this.initialize(this.lighting, this.altVertices, null);
        this.recalcAltVertices = false;
        return (P3d[])this.altVertices;
    }

    public void setShowWithin(Lst<P3d> showWithinPoints, double showWithinDistance2, boolean isWithinNot) {
        if (showWithinPoints.size() == 0) {
            this.bsDisplay = isWithinNot ? BSUtil.newBitSet2(0, this.vc) : null;
            return;
        }
        this.bsDisplay = new BS();
        for (int i = 0; i < this.vc; ++i) {
            if (!Mesh.checkWithin(this.vs[i], showWithinPoints, showWithinDistance2, isWithinNot)) continue;
            this.bsDisplay.set(i);
        }
    }

    public static boolean checkWithin(T3d pti, Lst<P3d> withinPoints, double withinDistance2, boolean isWithinNot) {
        if (withinPoints.size() != 0) {
            int i = withinPoints.size();
            while (--i >= 0) {
                if (!(pti.distanceSquared((T3d)withinPoints.get(i)) <= withinDistance2)) continue;
                return !isWithinNot;
            }
        }
        return isWithinNot;
    }

    public int getVertexIndexFromNumber(int vertexIndex) {
        if (--vertexIndex < 0) {
            vertexIndex = this.vc + vertexIndex;
        }
        return this.vc <= vertexIndex ? this.vc - 1 : (vertexIndex < 0 ? 0 : vertexIndex);
    }

    public BS getVisibleVertexBitSet() {
        return this.getVisibleVBS();
    }

    protected BS getVisibleVBS() {
        BS bs = new BS();
        if (this.pc == 0 && this.bsSlabDisplay != null) {
            BSUtil.copy2(this.bsSlabDisplay, bs);
        } else {
            int i = this.pc;
            while (--i >= 0) {
                int[] vertexIndexes;
                if (this.bsSlabDisplay != null && !this.bsSlabDisplay.get(i) || (vertexIndexes = this.pis[i]) == null) continue;
                bs.set(vertexIndexes[0]);
                bs.set(vertexIndexes[1]);
                bs.set(vertexIndexes[2]);
            }
        }
        return bs;
    }

    public void setTokenProperty(int tokProp, boolean bProp) {
        switch (tokProp) {
            case 0x40000088: 
            case 1073742058: {
                this.frontOnly = tokProp == 0x40000088 ? bProp : !bProp;
                return;
            }
            case 1073741862: 
            case 1073742057: {
                if (!this.isTwoSided && this.isShell != (tokProp == 1073741862 ? bProp : !bProp)) {
                    this.isShell = !this.isShell;
                    this.invertNormixes();
                }
                return;
            }
            case 1073741861: 
            case 1073741958: 
            case 1073741964: {
                this.setLighting(tokProp);
                return;
            }
            case 1073742042: 
            case 1112150019: {
                this.showPoints = tokProp == 1112150019 ? bProp : !bProp;
                return;
            }
            case 1073742018: 
            case 0x400000E4: {
                this.drawTriangles = tokProp == 1073742018 ? bProp : !bProp;
                return;
            }
            case 1073741938: 
            case 1073742046: {
                this.fillTriangles = tokProp == 1073741938 ? bProp : !bProp;
                return;
            }
            case 1073742060: 
            case 1073742182: {
                this.showTriangles = tokProp == 1073742182 ? bProp : !bProp;
                return;
            }
            case 0x4000004A: 
            case 1073742039: {
                this.showContourLines = tokProp == 0x4000004A ? bProp : !bProp;
                return;
            }
        }
    }

    protected Object getInfo(boolean isAll) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("id", this.thisID);
        info.put("vertexCount", this.vc);
        info.put("haveQuads", this.haveQuads);
        info.put("haveValues", this.vvs != null);
        int np = this.pc;
        if (isAll) {
            if (this.vc > 0) {
                info.put("vertices", AU.arrayCopyPt(this.vs, this.vc));
                if (this.bsSlabDisplay != null) {
                    info.put("bsVertices", this.getVisibleVBS());
                }
            }
            if (this.vvs != null) {
                info.put("vertexValues", AU.arrayCopyD(this.vvs, this.vc));
            }
            if (np > 0) {
                int[][] ii = Mesh.nonNull(this.pis, np);
                info.put("polygons", ii);
                np = ii.length;
                if (this.bsSlabDisplay != null) {
                    BS bs = ii.length == this.pc ? BS.copy(this.bsSlabDisplay) : Mesh.nonNullBS(this.bsSlabDisplay, this.pis, this.pc);
                    info.put("bsPolygons", bs);
                    np = bs.cardinality();
                }
            }
        }
        info.put("polygonCount", np);
        return info;
    }

    private static BS nonNullBS(BS bsSlabDisplay, int[][] pis, int pc) {
        BS bs = new BS();
        int pt = 0;
        for (int i = 0; i < pc; ++i) {
            if (pis[i] == null) continue;
            if (bsSlabDisplay.get(i)) {
                bs.set(pt);
            }
            ++pt;
        }
        return bs;
    }

    private static int[][] nonNull(int[][] pis, int pc) {
        int n = 0;
        int i = pc;
        while (--i >= 0) {
            if (pis[i] == null) continue;
            ++n;
        }
        int[][] ii = new int[n][];
        if (n > 0) {
            int pt = 0;
            for (int i2 = 0; i2 < pc; ++i2) {
                if (pis[i2] == null) continue;
                ii[pt++] = pis[i2];
            }
        }
        return ii;
    }

    public P3d[] getBoundingBox() {
        return null;
    }

    public SymmetryInterface getUnitCell() {
        return null;
    }

    public void rotateTranslate(Qd q, T3d offset, boolean isAbsolute) {
        if (q == null && offset == null) {
            this.mat4 = null;
            return;
        }
        M3d m3 = new M3d();
        V3d v = new V3d();
        if (this.mat4 == null) {
            this.mat4 = M4d.newM4(null);
        }
        this.mat4.getRotationScale(m3);
        this.mat4.getTranslation(v);
        if (q == null) {
            if (isAbsolute) {
                v.setT(offset);
            } else {
                v.add(offset);
            }
        } else {
            m3.mul(q.getMatrix());
        }
        this.mat4 = M4d.newMV(m3, v);
        this.recalcAltVertices = true;
    }

    public V3d[] getNormalsTemp() {
        V3d[] v3dArray;
        if (this.normalsTemp == null) {
            this.normalsTemp = this.getNormals(this.vs, null);
            v3dArray = this.normalsTemp;
        } else {
            v3dArray = this.normalsTemp;
        }
        return v3dArray;
    }
}

