/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.PT;
import org.jmol.i18n.GT;
import org.jmol.script.T;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.Viewer;

abstract class ScriptTokenParser {
    protected Viewer vwr;
    protected Map<String, Boolean> htUserFunctions;
    protected String script;
    protected boolean isStateScript;
    protected short lineCurrent;
    protected int iCommand;
    protected int ichCurrentCommand;
    protected int ichComment;
    protected int ichEnd;
    protected int ichToken;
    protected T theToken;
    protected T lastFlowCommand;
    protected T tokenCommand;
    protected T lastToken;
    protected T tokenAndEquals;
    protected int theTok;
    protected int nTokens;
    protected int tokCommand;
    protected int ptNewSetModifier;
    protected boolean isNewSet;
    protected boolean haveMacro;
    protected boolean logMessages = true;
    protected T[] atokenInfix;
    protected int itokenInfix;
    protected boolean isSetBrace;
    protected boolean isMathExpressionCommand;
    protected boolean isSetOrDefine;
    private Lst<T> ltokenPostfix;
    protected boolean isEmbeddedExpression;
    protected boolean isCommaAsOrAllowed;
    private Object theValue;
    boolean haveString;
    private boolean residueSpecCodeGenerated;
    protected String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorLine;
    protected String errorType;
    protected static final int ERROR_badArgumentCount = 0;
    protected static final int ERROR_badContext = 1;
    protected static final int ERROR_commandExpected = 2;
    protected static final int ERROR_endOfCommandUnexpected = 4;
    protected static final int ERROR_invalidExpressionToken = 9;
    protected static final int ERROR_missingEnd = 11;
    protected static final int ERROR_tokenExpected = 15;
    protected static final int ERROR_tokenUnexpected = 16;
    protected static final int ERROR_unrecognizedParameter = 18;
    protected static final int ERROR_unrecognizedToken = 19;
    private static final int ERROR_coordinateExpected = 3;
    private static final int ERROR_endOfExpressionExpected = 5;
    private static final int ERROR_identifierOrResidueSpecificationExpected = 6;
    private static final int ERROR_invalidAtomSpecification = 7;
    private static final int ERROR_invalidChainSpecification = 8;
    private static final int ERROR_invalidModelSpecification = 10;
    private static final int ERROR_numberExpected = 12;
    private static final int ERROR_numberOrVariableNameExpected = 13;
    private static final int ERROR_residueSpecificationExpected = 14;
    private static final int ERROR_unrecognizedExpressionToken = 17;

    ScriptTokenParser() {
    }

    protected boolean compileExpressions() {
        boolean checkExpression;
        boolean isScriptExpression = (this.tokCommand == 134222850 || this.tokCommand == 4124) && this.tokAt(2) == 0x10000200;
        this.isEmbeddedExpression = isScriptExpression || this.tokCommand != 0 && (this.tokCommand != 134320141 && this.tokCommand != 102436 && this.tokCommand != 364558 && this.tokCommand != 102412 || this.tokenCommand.intValue != Integer.MAX_VALUE) && this.tokCommand != 102409 && !T.tokAttr(this.tokCommand, 12288) && (this.nTokens > 2 || !T.tokAttr(this.tokCommand, 20480));
        this.isMathExpressionCommand = this.tokCommand == 0x40000000 || isScriptExpression || T.tokAttr(this.tokCommand, 36864);
        boolean bl = checkExpression = this.isEmbeddedExpression || T.tokAttr(this.tokCommand, 12288);
        if (this.tokAt(1) == 1073742330 && T.tokAttr(this.tokCommand, 12288)) {
            checkExpression = false;
        }
        if (checkExpression && !this.compileExpression()) {
            return false;
        }
        int size = this.atokenInfix.length;
        int nDefined = 0;
        for (int i = 1; i < size; ++i) {
            if (this.tokAt(i) != 12290) continue;
            ++nDefined;
        }
        if (this.isNewSet && (size -= nDefined) == 1) {
            this.atokenInfix[0] = T.tv(134320141, 0, this.atokenInfix[0].value);
            this.isNewSet = false;
        }
        if ((this.isNewSet || this.isSetBrace) && this.ptNewSetModifier != Integer.MAX_VALUE && size < this.ptNewSetModifier + 2) {
            if (!this.isNewSet || !this.haveMacro) {
                return this.commandExpected();
            }
            this.htUserFunctions.put((String)this.atokenInfix[0].value, Boolean.TRUE);
        }
        return size == 1 || !T.tokAttr(this.tokCommand, 262144) ? true : this.error(0);
    }

    protected boolean compileExpression() {
        int i;
        int firstToken = this.isSetOrDefine && !this.isSetBrace ? 2 : 1;
        this.ltokenPostfix = new Lst();
        this.itokenInfix = 0;
        T tokenBegin = null;
        int tok = this.tokAt(1);
        switch (this.tokCommand) {
            case 12290: {
                int n = i = this.tokAt(1) == 12290 ? 2 : 1;
                if (this.tokAt(i) != 2 || this.tokAt(i + 1) != 0x40000200 || this.tokAt(i + 3) != 268440324) break;
                this.tokCommand = 36867;
                this.isSetBrace = true;
                this.ptNewSetModifier = i + 3;
                this.isMathExpressionCommand = true;
                this.isEmbeddedExpression = true;
                this.addTokenToPostfixToken(T.tokenSetProperty);
                this.addTokenToPostfixToken(T.tokenExpressionBegin);
                int j = 0;
                while (j++ <= i) {
                    this.addNextToken();
                }
                this.addTokenToPostfixToken(T.tokenExpressionEnd);
                firstToken = 0;
                break;
            }
            case 12295: {
                if (tok != 1677721602) break;
                firstToken = 2;
                break;
            }
            case 1275082241: {
                switch (tok) {
                    case 0x10000600: 
                    case 1073742334: 
                    case 1073742335: {
                        tok = this.tokAt(++firstToken);
                    }
                }
            }
            case 12294: 
            case 1610625028: {
                switch (tok) {
                    case 1073742119: 
                    case 1275069441: {
                        tok = this.tokAt(++firstToken);
                    }
                }
                if (tok != 1086324742 || T.tokAttr(this.tokAt(firstToken + 1), 0x10000000)) break;
                ++firstToken;
            }
        }
        for (i = 0; i < firstToken && this.addNextToken(); ++i) {
        }
        while (this.moreTokens()) {
            if (this.isEmbeddedExpression) {
                while (!this.isExpressionNext()) {
                    String name;
                    T t;
                    if (!(!this.tokPeekIs(0x40000000) || this.tokCommand == 134223363 && this.itokenInfix == 1 || (t = T.getTokenFromName(name = (String)this.atokenInfix[this.itokenInfix].value)) == null || (this.isMathExpressionCommand || this.lastToken.tok == 12290) && (this.lastToken.tok != 0x40000200 && this.tokAt(this.itokenInfix + 1) != 0x10000200 || this.isUserFunction(name)))) {
                        this.atokenInfix[this.itokenInfix] = t;
                    }
                    if (this.addNextToken()) continue;
                }
                if (!this.moreTokens()) break;
            }
            if (this.lastToken.tok == 12290) {
                if (this.clauseDefine(true, false)) continue;
                return false;
            }
            if (!this.isMathExpressionCommand) {
                tokenBegin = T.o(1073742325, "implicitExpressionBegin");
                this.addTokenToPostfixToken(tokenBegin);
            }
            if (!this.clauseOr(this.isCommaAsOrAllowed || !this.isMathExpressionCommand && this.tokPeekIs(0x10000200))) {
                return false;
            }
            if (!(this.isMathExpressionCommand || this.isEmbeddedExpression && this.lastToken == T.tokenCoordinateEnd)) {
                this.addTokenToPostfixToken(T.tokenExpressionEnd);
            }
            if (!this.moreTokens()) continue;
            if (this.tokCommand != 1275082241 && this.tokCommand != 12291 && !this.isEmbeddedExpression) {
                return this.error(5);
            }
            if (this.tokCommand != 1275082241) continue;
            tokenBegin.intValue = 0;
            this.tokCommand = 0;
            this.isEmbeddedExpression = true;
            this.isMathExpressionCommand = true;
            this.isCommaAsOrAllowed = false;
        }
        this.atokenInfix = this.ltokenPostfix.toArray(new T[this.ltokenPostfix.size()]);
        return true;
    }

    protected boolean isUserFunction(String name) {
        name = name.toLowerCase();
        return !this.isStateScript && (this.vwr.isFunction(name) || this.htUserFunctions.containsKey(name));
    }

    private boolean isExpressionNext() {
        return this.tokPeekIs(1073742332) && (this.tokAt(this.itokenInfix + 1) != 4 || this.tokAt(this.itokenInfix + 2) != 268436482) || !this.isMathExpressionCommand && this.tokPeekIs(0x10000200);
    }

    protected static boolean tokenAttr(T token, int tok) {
        return token != null && T.tokAttr(token.tok, tok);
    }

    private boolean moreTokens() {
        return this.itokenInfix < this.atokenInfix.length;
    }

    protected int tokAt(int i) {
        return i < this.atokenInfix.length ? this.atokenInfix[i].tok : 0;
    }

    private int tokPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? 0 : this.atokenInfix[this.itokenInfix].tok;
    }

    private boolean tokPeekIs(int tok) {
        return this.tokAt(this.itokenInfix) == tok;
    }

    private int intPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? Integer.MAX_VALUE : this.atokenInfix[this.itokenInfix].intValue;
    }

    private Object valuePeek() {
        return this.moreTokens() ? this.atokenInfix[this.itokenInfix].value : "";
    }

    private T tokenNext() {
        return this.itokenInfix >= this.atokenInfix.length ? null : this.atokenInfix[this.itokenInfix++];
    }

    private boolean tokenNextTok(int tok) {
        T token = this.tokenNext();
        return token != null && token.tok == tok;
    }

    private boolean returnToken() {
        --this.itokenInfix;
        return false;
    }

    private T getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    private boolean getNumericalToken() {
        return this.getToken() != null && (this.theToken.tok == 2 || this.theToken.tok == 3);
    }

    private double doubleValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Number)this.theValue).doubleValue();
            }
        }
        return 0.0;
    }

    private boolean addTokenToPostfix(int tok, Object value) {
        return this.addTokenToPostfixToken(T.o(tok, value));
    }

    private boolean addTokenToPostfixInt(int tok, int intValue, Object value) {
        return this.addTokenToPostfixToken(T.tv(tok, intValue, value));
    }

    private boolean addTokenToPostfixToken(T token) {
        if (token == null) {
            return false;
        }
        if (this.logMessages) {
            Logger.debug("addTokenToPostfix" + token);
        }
        if (token.tok == 0x10000800 && (this.lastToken.tok == 0x40000200 || this.lastToken.tok == 1073742337)) {
            int ipt = this.ltokenPostfix.size() - 1;
            this.ltokenPostfix.removeItemAt(ipt);
            this.ltokenPostfix.addLast(T.tokenRightParen);
            int pcount = 0;
            int i = this.ltokenPostfix.size();
            block4: while (--i >= 0 && pcount >= 0) {
                int tok2;
                int tok = ((T)this.ltokenPostfix.get((int)i)).tok;
                switch (tok) {
                    case 0x10000201: 
                    case 0x10000801: {
                        ++pcount;
                        continue block4;
                    }
                    case 0x10000200: 
                    case 0x10000800: {
                        if (--pcount != 1 || (tok2 = ((T)this.ltokenPostfix.get((int)(i - 1))).tok) == 0x10000201 || tok2 == 0x10000801) continue block4;
                        ipt = tok == 0x10000800 ? i - 1 : i;
                        pcount = -10;
                        continue block4;
                    }
                }
                int n = tok2 = i == 0 ? 0 : ((T)this.ltokenPostfix.get((int)(i - 1))).tok;
                if (tok2 == 0x40000200 || tok2 == 1073742337) {
                    ipt = i - 1;
                    continue;
                }
                if (i != ipt - 1) continue;
                ipt = i;
                pcount = -10;
            }
            if (pcount == -10) {
                this.ltokenPostfix.add(ipt, T.tokenLeftParen);
            }
        }
        this.ltokenPostfix.addLast(token);
        this.lastToken = token;
        return true;
    }

    private boolean addNextToken() {
        return this.addTokenToPostfixToken(this.tokenNext());
    }

    private boolean addNextTokenIf(int tok) {
        return this.tokPeekIs(tok) && this.addNextToken();
    }

    private boolean addSubstituteTokenIf(int tok, T token) {
        if (!this.tokPeekIs(tok)) {
            return false;
        }
        ++this.itokenInfix;
        return this.addTokenToPostfixToken(token);
    }

    private boolean clauseOr(boolean allowCommaAsOr) {
        int tok;
        this.haveString = false;
        if (!this.clauseAnd()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 1073742326) {
            return true;
        }
        while ((tok = this.tokPeek()) == 0x10000A00 || tok == 0x10000A01 || tok == 268438018 || allowCommaAsOr && tok == 0x10000600) {
            if (tok == 0x10000600 && !this.haveString) {
                this.addSubstituteTokenIf(0x10000600, T.tokenOr);
            } else {
                this.addNextToken();
            }
            if (!this.clauseAnd()) {
                return false;
            }
            if (!allowCommaAsOr || this.lastToken.tok != 0x40000202 && this.lastToken.tok != 10) continue;
            this.haveString = true;
        }
        return true;
    }

    private boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 1073742326) {
            return true;
        }
        while (this.tokPeekIs(0x10000C00)) {
            this.addNextToken();
            if (this.clauseNot()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseNot() {
        if (this.tokPeekIs(0x10000E00)) {
            this.addNextToken();
            return this.clauseNot();
        }
        return this.clausePrimitive();
    }

    private boolean clausePrimitive() {
        int tok = this.tokPeek();
        switch (tok) {
            case 1073742195: {
                ++this.itokenInfix;
                return this.clausePrimitive();
            }
            case 0: {
                return this.error(4);
            }
            case 10: 
            case 0x200007: 
            case 0x200008: 
            case 0x20000A: 
            case 0x200020: 
            case 136314895: 
            case 0x10001600: 
            case 1073742327: 
            case 1073742331: 
            case 1073742333: {
                return this.addNextToken();
            }
            case 4: {
                this.haveString = true;
                return this.addNextToken();
            }
            case 3: {
                return this.addTokenToPostfixInt(1073742359, this.fixModelSpec(this.getToken()), this.theValue);
            }
            case 1094713349: 
            case 1094713350: {
                return this.clauseCell(tok);
            }
            case 0x8000008: 
            case 1275203608: {
                return this.clauseConnected(tok == 1275203608);
            }
            case 0x8000404: 
            case 134218757: {
                return this.clauseSubstructure();
            }
            case 134217759: 
            case 134353926: {
                return this.clauseWithin(tok == 134217759);
            }
            case 12290: {
                return this.clauseDefine(false, false);
            }
            case 1677721602: 
            case 1745489939: {
                this.addNextToken();
                if (this.tokPeekIs(10)) {
                    this.addNextToken();
                } else if (this.tokPeekIs(12290)) {
                    return this.clauseDefine(false, false);
                }
                return true;
            }
            case 0x10000200: {
                this.addNextToken();
                if (!this.clauseOr(true)) {
                    return false;
                }
                if (!this.addNextTokenIf(0x10000201)) {
                    return this.errorStr(15, ")");
                }
                return this.checkForItemSelector(true);
            }
            case 1073742332: {
                return this.checkForCoordinate(this.isMathExpressionCommand);
            }
        }
        if (this.clauseResidueSpec()) {
            return true;
        }
        if (this.isError()) {
            return false;
        }
        if (T.tokAttr(tok, 0x40400000)) {
            int itemp = this.itokenInfix;
            boolean isOK = this.clauseComparator(true);
            if (isOK || this.itokenInfix != itemp) {
                return isOK;
            }
            if (tok == 1237320707) {
                return this.clauseSubstructure();
            }
        }
        return this.addNextToken();
    }

    private boolean checkForCoordinate(boolean isImplicitExpression) {
        boolean isCoordinate = false;
        int pt = this.ltokenPostfix.size();
        if (isImplicitExpression) {
            this.addTokenToPostfixToken(T.tokenExpressionBegin);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
            --pt;
        } else {
            this.addNextToken();
        }
        boolean isHash = this.tokPeekIs(4);
        if (isHash) {
            isImplicitExpression = false;
            this.returnToken();
            this.ltokenPostfix.removeItemAt(this.ltokenPostfix.size() - 1);
            this.addNextToken();
            int nBrace = 1;
            while (nBrace != 0) {
                if (this.tokPeekIs(1073742332)) {
                    if (this.isExpressionNext()) {
                        this.addTokenToPostfixToken(T.o(1073742325, "implicitExpressionBegin"));
                        if (!this.clauseOr(false)) {
                            return false;
                        }
                        if (this.lastToken != T.tokenCoordinateEnd) {
                            this.addTokenToPostfixToken(T.tokenExpressionEnd);
                        }
                    } else {
                        ++nBrace;
                    }
                }
                if (this.tokPeekIs(0x40000202)) {
                    --nBrace;
                }
                this.addNextToken();
            }
        } else {
            if (!this.tokPeekIs(0x40000202) && !this.clauseOr(false)) {
                return false;
            }
            int n = 1;
            while (!this.tokPeekIs(0x40000202)) {
                boolean haveComma = this.addNextTokenIf(0x10000600);
                if (!this.clauseOr(false)) {
                    return haveComma || n < 3 ? false : this.errorStr(15, "}");
                }
                ++n;
            }
            boolean bl = isCoordinate = n >= 2;
        }
        if (isCoordinate && (isImplicitExpression || this.isEmbeddedExpression)) {
            this.ltokenPostfix.set(pt, T.tokenCoordinateBegin);
            this.addTokenToPostfixToken(T.tokenCoordinateEnd);
            this.tokenNext();
        } else if (isImplicitExpression) {
            this.addTokenToPostfixToken(T.tokenExpressionEnd);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            if (!isHash) {
                this.tokenNext();
            }
        } else {
            this.addNextToken();
        }
        return this.checkForItemSelector(!isHash);
    }

    private boolean checkForItemSelector(boolean allowNumeric) {
        int tok = this.tokAt(this.itokenInfix + 1);
        if (tok == 0x10000800 || allowNumeric && tok == 1073742332) {
            return true;
        }
        while (this.addNextTokenIf(0x10000800)) {
            if (!this.clauseItemSelector()) {
                return false;
            }
            if (this.addNextTokenIf(0x10000801)) continue;
            return this.errorStr(15, "]");
        }
        return true;
    }

    private boolean clauseWithin(boolean isWithin) {
        int tok;
        this.addNextToken();
        if (!this.addNextTokenIf(0x10000200)) {
            return false;
        }
        if (this.getToken() == null) {
            return false;
        }
        double distance = Double.MAX_VALUE;
        String key = null;
        boolean allowComma = isWithin;
        int tok0 = this.theToken.tok;
        if (!isWithin) {
            tok = -1;
            int i = this.itokenInfix;
            while (tok != 0) {
                tok = this.tokAt(i);
                switch (tok) {
                    case 0x10000600: {
                        tok = 0;
                        break;
                    }
                    case 0x10000200: 
                    case 0x10000201: 
                    case 1073742332: {
                        distance = 100.0;
                        this.returnToken();
                        tok = 0;
                        tok0 = 0;
                    }
                }
                ++i;
            }
        }
        switch (tok0) {
            case 0x10001400: {
                if (this.getToken() == null) {
                    return false;
                }
                if (this.theToken.tok != 2) {
                    return this.error(12);
                }
                distance = -this.theToken.intValue;
                break;
            }
            case 2: 
            case 3: {
                distance = this.doubleValue();
                break;
            }
            case 12290: {
                this.addTokenToPostfixToken(this.theToken);
                if (!this.clauseDefine(true, false)) {
                    return false;
                }
                key = "";
                allowComma = false;
            }
        }
        if (isWithin && distance == Double.MAX_VALUE) {
            block9 : switch (tok0) {
                case 12290: {
                    break;
                }
                case 1094713349: 
                case 1094713350: {
                    this.addTokenToPostfix(4, this.theValue);
                    this.clauseCell(8);
                    key = "";
                    break;
                }
                case 0x8000404: 
                case 134218757: 
                case 1073741925: 
                case 1073742128: 
                case 1073742189: 
                case 1111490587: 
                case 1237320707: {
                    this.addTokenToPostfix(4, this.theValue);
                    if (!this.addNextTokenIf(0x10000600)) {
                        return false;
                    }
                    allowComma = false;
                    tok = this.tokPeek();
                    switch (tok) {
                        case 0: {
                            return false;
                        }
                        case 4: {
                            this.addNextToken();
                            key = "";
                            break block9;
                        }
                        case 12290: {
                            if (!this.clauseDefine(false, true)) {
                                return false;
                            }
                            key = "";
                            break block9;
                        }
                    }
                    return false;
                }
                case 1073742328: {
                    allowComma = false;
                }
                case 4: 
                case 0x200020: 
                case 134217750: 
                case 0x8000801: 
                case 136314895: 
                case 1073741863: 
                case 1073742329: 
                case 1086324742: 
                case 1086324744: 
                case 1086326785: 
                case 1086326786: 
                case 1086326788: 
                case 1086326789: 
                case 0x41400010: 
                case 1094713362: 
                case 1094713366: 
                case 1094717454: 
                case 1639976963: 
                case 1648363544: 
                case 1812599299: 
                case 1814695966: {
                    key = (String)this.theValue;
                    break;
                }
                default: {
                    key = ((String)this.theValue).toLowerCase();
                }
            }
        }
        if (key == null) {
            this.addTokenToPostfix(3, distance);
        } else if (key.length() > 0) {
            this.addTokenToPostfix(4, key);
        }
        boolean done = false;
        while (!done && (tok0 == 0 || this.addNextTokenIf(0x10000600))) {
            if (tok0 == 0) {
                tok0 = 134353926;
            }
            boolean isCoordOrPlane = false;
            tok = this.tokPeek();
            if (isWithin) {
                switch (tok0) {
                    case 2: 
                    case 3: {
                        if (tok != 1073742335 && tok != 1073742334) break;
                        this.addTokenToPostfixToken(this.getToken());
                        if (!this.addNextTokenIf(0x10000600)) break;
                        tok = this.tokPeek();
                    }
                }
                if (key == null) {
                    switch (tok) {
                        case 134217750: 
                        case 0x8000801: 
                        case 1073742329: {
                            isCoordOrPlane = true;
                            this.addNextToken();
                            break;
                        }
                        case 1073742330: {
                            this.getToken();
                            this.getToken();
                            this.addTokenToPostfix(4, "$" + this.theValue);
                            done = true;
                            break;
                        }
                        case 1086324742: 
                        case 1648363544: 
                        case 1814695966: {
                            this.getToken();
                            this.addTokenToPostfix(4, T.nameOf(tok));
                            break;
                        }
                        case 1073742332: {
                            this.returnToken();
                            isCoordOrPlane = true;
                            this.addTokenToPostfixToken(T.getTokenFromName(distance == Double.MAX_VALUE ? "plane" : "coord"));
                        }
                    }
                    if (!done) {
                        this.addNextTokenIf(0x10000600);
                    }
                }
            }
            tok = this.tokPeek();
            if (done) break;
            if (isCoordOrPlane) {
                block37: while (!this.tokPeekIs(0x10000201)) {
                    switch (this.tokPeek()) {
                        case 0: {
                            return this.error(4);
                        }
                        case 0x10000200: {
                            this.addTokenToPostfixToken(T.tokenExpressionBegin);
                            this.addNextToken();
                            if (!this.clauseOr(false)) {
                                return this.errorIntStr2(18, "WITHIN", ": ?");
                            }
                            if (!this.addNextTokenIf(0x10000201)) {
                                return this.errorStr(15, ", / )");
                            }
                            this.addTokenToPostfixToken(T.tokenExpressionEnd);
                            continue block37;
                        }
                        case 12290: {
                            if (this.clauseDefine(false, false)) continue block37;
                            return false;
                        }
                    }
                    this.addTokenToPostfixToken(this.getToken());
                }
                continue;
            }
            if (this.clauseOr(allowComma)) continue;
        }
        if (!this.addNextTokenIf(0x10000201)) {
            return this.errorStr(15, ")");
        }
        return true;
    }

    private boolean clauseConnected(boolean isPolyhedra) {
        block12: {
            block15: {
                String strOrder;
                block14: {
                    block13: {
                        block11: {
                            this.addNextToken();
                            if (!this.addNextTokenIf(0x10000200)) {
                                this.addTokenToPostfixToken(T.tokenLeftParen);
                                this.addTokenToPostfixToken(T.tokenRightParen);
                                return true;
                            }
                            if (!this.addNextTokenIf(2)) break block11;
                            if (!this.addNextTokenIf(0x10000600)) break block12;
                            if (!isPolyhedra) break block13;
                            this.returnToken();
                            break block12;
                        }
                        if (isPolyhedra && (this.addNextTokenIf(4) || this.addNextTokenIf(0x40000000))) break block12;
                    }
                    if (this.addNextTokenIf(2) && !this.addNextTokenIf(0x10000600) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10000600) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10000600)) break block12;
                    Object o = this.getToken().value;
                    strOrder = o instanceof String ? (String)o : " ";
                    int intType = Edge.getBondOrderFromString(strOrder);
                    if (intType != 131071) break block14;
                    this.returnToken();
                    break block15;
                }
                this.addTokenToPostfix(4, strOrder);
                if (!this.addNextTokenIf(0x10000600)) break block12;
            }
            if (this.addNextTokenIf(0x10000201)) {
                return true;
            }
            if (!this.clauseOr(this.tokPeekIs(0x10000200))) {
                return false;
            }
            if (this.addNextTokenIf(0x10000201)) {
                return true;
            }
            if (!this.addNextTokenIf(0x10000600)) {
                return false;
            }
            if (!this.clauseOr(this.tokPeekIs(0x10000200))) {
                return false;
            }
        }
        if (!this.addNextTokenIf(0x10000201)) {
            return this.errorStr(15, ")");
        }
        return true;
    }

    private boolean clauseSubstructure() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x10000200)) {
            return false;
        }
        if (this.tokPeekIs(12290)) {
            if (!this.clauseDefine(false, true)) {
                return false;
            }
        } else if (!this.addNextTokenIf(4)) {
            return this.errorStr(15, "\"...\"");
        }
        if (this.addNextTokenIf(0x10000600) && !this.clauseOr(this.tokPeekIs(0x10000200))) {
            return false;
        }
        if (!this.addNextTokenIf(0x10000201)) {
            return this.errorStr(15, ")");
        }
        return true;
    }

    private boolean clauseItemSelector() {
        int tok;
        int nparen = 0;
        while ((tok = this.tokPeek()) != 0 && tok != 0x10000801) {
            this.addNextToken();
            if (tok == 0x10000800) {
                ++nparen;
            }
            if (this.tokPeek() != 0x10000801 || nparen-- <= 0) continue;
            this.addNextToken();
        }
        return true;
    }

    private boolean clauseComparator(boolean isOptional) {
        T tokenAtomProperty = this.tokenNext();
        T tokenComparator = this.tokenNext();
        if (!ScriptTokenParser.tokenAttr(tokenComparator, 0x10000100)) {
            if (!isOptional) {
                return this.errorStr(15, "== != < > <= >=");
            }
            if (tokenComparator != null) {
                this.returnToken();
            }
            this.returnToken();
            return false;
        }
        if (ScriptTokenParser.tokenAttr(tokenAtomProperty, 0x40C00000) && tokenComparator.tok != 268440324 && tokenComparator.tok != 268440326 && tokenComparator.tok != 268440325) {
            return this.errorStr(15, "== !=");
        }
        if (this.tokPeek() == 0x10000800) {
            this.getToken();
            this.addTokenToPostfixToken(T.tokenLeftParen);
            while (true) {
                if (!this.addCompare(tokenAtomProperty, tokenComparator)) {
                    return false;
                }
                if (this.tokPeek() == 0x10000600) {
                    this.getToken();
                } else if (this.tokPeek() == 0x10000801) break;
                this.addTokenToPostfixToken(tokenComparator.tok == 268440325 ? T.tokenAnd : T.tokenOr);
            }
            this.getToken();
            this.addTokenToPostfixToken(T.tokenRightParen);
            return true;
        }
        return this.addCompare(tokenAtomProperty, tokenComparator);
    }

    private boolean addCompare(T tokenAtomProperty, T tokenComparator) {
        boolean isNegative;
        if (this.getToken() == null) {
            return this.errorStr(17, "" + this.valuePeek());
        }
        boolean bl = isNegative = this.theToken.tok == 0x10001400;
        if (isNegative && this.getToken() == null) {
            return this.error(12);
        }
        switch (this.theToken.tok) {
            case 2: 
            case 3: 
            case 4: 
            case 12290: 
            case 0x40000000: 
            case 1073742332: {
                break;
            }
            default: {
                if (T.tokAttr(this.theToken.tok, 0x40000000)) break;
                return this.error(13);
            }
        }
        this.addTokenToPostfixInt(tokenComparator.tok, tokenAtomProperty.tok, tokenComparator.value + (isNegative ? " -" : ""));
        if (tokenAtomProperty.tok == 1715472409) {
            this.addTokenToPostfixToken(tokenAtomProperty);
        }
        if (this.theToken.tok == 1073742332) {
            this.returnToken();
            return this.clausePrimitive();
        }
        this.addTokenToPostfixToken(this.theToken);
        if (this.theToken.tok == 12290) {
            return this.clauseDefine(true, false);
        }
        return true;
    }

    private boolean clauseCell(int tok) {
        P3d cell = new P3d();
        this.tokenNext();
        if (tok != 8 && !this.tokenNextTok(268440324)) {
            return this.errorStr(15, "=");
        }
        if (this.getToken() == null) {
            return this.error(3);
        }
        if (this.theToken.tok == 2) {
            SimpleUnitCell.ijkToPoint3f(this.theToken.intValue, cell, 1, 0);
        } else {
            if (this.theToken.tok != 1073742332 || !this.getNumericalToken()) {
                return this.error(3);
            }
            cell.x = this.doubleValue();
            if (this.tokPeekIs(0x10000600)) {
                this.tokenNext();
            }
            if (!this.getNumericalToken()) {
                return this.error(3);
            }
            cell.y = this.doubleValue();
            if (this.tokPeekIs(0x10000600)) {
                this.tokenNext();
            }
            if (!this.getNumericalToken() || !this.tokenNextTok(0x40000202)) {
                return this.error(3);
            }
            cell.z = this.doubleValue();
        }
        return this.addTokenToPostfix(tok, cell);
    }

    private boolean clauseDefine(boolean haveToken, boolean forceString) {
        if (!haveToken) {
            T token = this.tokenNext();
            if (forceString) {
                token = T.tokenDefineString;
            }
            this.addTokenToPostfixToken(token);
        }
        if (this.tokPeekIs(0)) {
            return this.error(4);
        }
        if (!this.addSubstituteTokenIf(1073742332, T.tokenExpressionBegin)) {
            if (this.tokPeek() == 12290) {
                this.addNextToken();
            }
            return this.addNextToken() && this.checkForItemSelector(true);
        }
        while (this.moreTokens() && !this.tokPeekIs(0x40000202)) {
            if (this.tokPeekIs(1073742332)) {
                if (this.checkForCoordinate(true)) continue;
                return false;
            }
            this.addNextToken();
        }
        return this.addSubstituteTokenIf(0x40000202, T.tokenExpressionEnd) && this.checkForItemSelector(true);
    }

    private boolean generateResidueSpecCode(T token) {
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfixToken(T.tokenAndSpec);
        }
        this.addTokenToPostfixToken(token);
        this.residueSpecCodeGenerated = true;
        return true;
    }

    private boolean clauseResidueSpec() {
        int tok = this.tokPeek();
        this.residueSpecCodeGenerated = false;
        boolean checkResNameSpec = false;
        switch (tok) {
            case 0: 
            case 0x200004: 
            case 2097174: {
                return false;
            }
            case 2: 
            case 5: 
            case 268436482: 
            case 268441090: {
                break;
            }
            case 0x10000800: 
            case 0x10001601: 
            case 0x40000000: {
                checkResNameSpec = true;
                break;
            }
            default: {
                if (T.tokAttr(tok, 0x10000100)) {
                    return false;
                }
                String str = "" + this.valuePeek();
                boolean bl = checkResNameSpec = str.length() == 2 || str.length() == 3;
                if (checkResNameSpec) break;
                return false;
            }
        }
        boolean specSeen = false;
        if (checkResNameSpec) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 2 || tok == 0x10001601 || tok == 5) {
            if (!this.clauseSequenceSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 268436482) {
            if (!this.clauseChainSpec(tok)) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 0x40000200) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 268441090) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 0x10001600) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (!specSeen) {
            return this.error(14);
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfixToken(T.tokenAll);
        }
        return true;
    }

    private boolean clauseResNameSpec() {
        this.getToken();
        int tok = this.tokPeek();
        switch (this.theToken.tok) {
            case 0x10001601: {
                return true;
            }
            case 0x10000800: {
                int pt;
                String strSpec = "";
                while (this.getToken() != null && this.theToken.tok != 0x10000801) {
                    strSpec = strSpec + this.theValue;
                }
                if (this.theToken == null) {
                    return false;
                }
                if (strSpec == "") {
                    return true;
                }
                return strSpec.length() > 0 && (pt = strSpec.indexOf("*")) >= 0 && pt != strSpec.length() - 1 ? this.error(14) : this.generateResidueSpecCode(T.o(1073742360, strSpec.toUpperCase()));
            }
        }
        if (T.tokAttr(tok, 0x10000100)) {
            this.returnToken();
            return false;
        }
        String res = (String)this.theValue;
        if (tok == 0x10001601) {
            res = this.theValue + "*";
            this.getToken();
        }
        return this.generateResidueSpecCode(T.o(0x40000000, res));
    }

    private boolean clauseSequenceSpec() {
        if (this.tokPeek() == 0x10001601) {
            return this.getToken() != null;
        }
        T seqToken = this.getSequenceCode(false);
        if (seqToken == null) {
            return false;
        }
        int tok = this.tokPeek();
        if (tok == 0x10001400 || tok == 2 && this.intPeek() < 0) {
            if (tok == 0x10001400) {
                this.tokenNext();
            } else {
                int i;
                this.tokenNext().intValue = i = -this.intPeek();
                this.returnToken();
            }
            seqToken.tok = 1073742363;
            this.generateResidueSpecCode(seqToken);
            return this.addTokenToPostfixToken(this.getSequenceCode(true));
        }
        return this.generateResidueSpecCode(seqToken);
    }

    private T getSequenceCode(boolean isSecond) {
        int seqcode = Integer.MAX_VALUE;
        int seqvalue = Integer.MAX_VALUE;
        switch (this.tokPeek()) {
            case 5: {
                seqcode = this.tokenNext().intValue;
                break;
            }
            case 2: {
                seqvalue = this.tokenNext().intValue;
                break;
            }
            default: {
                if (isSecond) break;
                return null;
            }
        }
        return T.tv(1073742362, seqvalue, seqcode);
    }

    private boolean clauseChainSpec(int tok) {
        String strChain;
        this.tokenNext();
        tok = this.tokPeek();
        if (this.isTerminator(tok)) {
            strChain = " ";
        } else {
            switch (tok) {
                case 0x10001601: {
                    return this.getToken() != null;
                }
                case 2: {
                    this.getToken();
                    int val = this.theToken.intValue;
                    if (val < 0 || val > 9999) {
                        return this.error(8);
                    }
                    strChain = "" + val;
                    break;
                }
                case 4: {
                    this.vwr.getChainID("a", true);
                }
                default: {
                    strChain = "" + this.getToken().value;
                }
            }
            if (strChain.length() == 0) {
                strChain = " ";
            } else if (strChain.equals("?")) {
                return true;
            }
        }
        int chain = this.vwr.getChainID(strChain, false);
        return this.generateResidueSpecCode(T.tv(1073742357, chain, "spec_chain"));
    }

    private boolean clauseAlternateSpec() {
        this.tokenNext();
        if (this.isTerminator(this.tokPeek())) {
            return this.generateResidueSpecCode(T.o(1073742355, null));
        }
        switch (this.getToken().tok) {
            case 2: 
            case 4: 
            case 0x10001601: 
            case 805307393: 
            case 0x40000000: 
            case 1111492629: 
            case 1111492630: 
            case 1111492631: 
            case 0x44000011: {
                break;
            }
            default: {
                return this.error(10);
            }
        }
        return this.generateResidueSpecCode(T.o(1073742355, this.theToken.value));
    }

    private boolean isTerminator(int tok) {
        switch (tok) {
            case 0: 
            case 0x10000201: 
            case 0x10000600: 
            case 0x10000A00: 
            case 0x10000C00: 
            case 0x10000E00: 
            case 0x10001600: 
            case 0x40000202: {
                return true;
            }
        }
        return false;
    }

    private boolean clauseModelSpec() {
        this.getToken();
        switch (this.tokPeek()) {
            case 0x10001601: {
                this.getToken();
                return true;
            }
            case 2: {
                return this.generateResidueSpecCode(T.o(1073742358, this.getToken().intValue));
            }
            case 3: {
                return this.generateResidueSpecCode(T.tv(1073742358, this.fixModelSpec(this.getToken()), this.theValue));
            }
            case 0: 
            case 0x10000600: 
            case 0x40000202: {
                return this.generateResidueSpecCode(T.o(1073742358, 1));
            }
        }
        return this.error(10);
    }

    private int fixModelSpec(T token) {
        int ival = token.intValue;
        if (ival == Integer.MAX_VALUE) {
            double f = ((Number)this.theValue).doubleValue();
            if (f == (double)((int)f)) {
                ival = (int)f * 1000000;
            }
            if (ival < 0) {
                ival = Integer.MAX_VALUE;
            }
        }
        return ival;
    }

    private boolean clauseAtomSpec() {
        if (!this.tokenNextTok(0x40000200)) {
            return this.error(7);
        }
        if (this.getToken() == null) {
            return true;
        }
        String atomSpec = "";
        if (this.theToken.tok == 2) {
            atomSpec = atomSpec + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.error(7);
            }
        }
        if (this.theToken.tok == 0x10001601) {
            return true;
        }
        atomSpec = atomSpec + "" + this.theToken.value;
        if (this.tokPeekIs(0x10001601)) {
            this.tokenNext();
            atomSpec = atomSpec + "'";
        }
        return this.generateResidueSpecCode(T.tv(1073742356, this.vwr.getJBR().lookupSpecialAtomID(atomSpec.toUpperCase()), atomSpec));
    }

    static String errorString(int iError, String value, String more, boolean translated) {
        String msg;
        boolean doTranslate = false;
        if (!translated && (doTranslate = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (iError) {
            default: {
                msg = "Unknown compiler error message number: " + iError;
                break;
            }
            case 0: {
                msg = GT.$("bad argument count");
                break;
            }
            case 1: {
                msg = GT.$("invalid context for {0}");
                break;
            }
            case 2: {
                msg = GT.$("command expected");
                break;
            }
            case 3: {
                msg = GT.$("{ number number number } expected");
                break;
            }
            case 4: {
                msg = GT.$("unexpected end of script command");
                break;
            }
            case 5: {
                msg = GT.$("end of expression expected");
                break;
            }
            case 6: {
                msg = GT.$("identifier or residue specification expected");
                break;
            }
            case 7: {
                msg = GT.$("invalid atom specification");
                break;
            }
            case 8: {
                msg = GT.$("invalid chain specification");
                break;
            }
            case 9: {
                msg = GT.$("invalid expression token: {0}");
                break;
            }
            case 10: {
                msg = GT.$("invalid model specification");
                break;
            }
            case 11: {
                msg = GT.$("missing END for {0}");
                break;
            }
            case 12: {
                msg = GT.$("number expected");
                break;
            }
            case 13: {
                msg = GT.$("number or variable name expected");
                break;
            }
            case 14: {
                msg = GT.$("residue specification (ALA, AL?, A*) expected");
                break;
            }
            case 15: {
                msg = GT.$("{0} expected");
                break;
            }
            case 16: {
                msg = GT.$("{0} unexpected");
                break;
            }
            case 17: {
                msg = GT.$("unrecognized expression token: {0}");
                break;
            }
            case 18: {
                msg = GT.$("unrecognized {0} parameter");
                break;
            }
            case 19: {
                msg = GT.$("unrecognized token: {0}");
            }
        }
        if (msg.indexOf("{0}") < 0) {
            if (value != null) {
                msg = msg + ": " + value;
            }
        } else if ((msg = PT.rep(msg, "{0}", value)).indexOf("{1}") >= 0) {
            msg = PT.rep(msg, "{1}", more);
        } else if (more != null) {
            msg = msg + ": " + more;
        }
        if (!translated) {
            GT.setDoTranslate(doTranslate);
        }
        return msg;
    }

    protected boolean commandExpected() {
        this.ichToken = this.ichCurrentCommand;
        return this.error(2);
    }

    protected boolean error(int error) {
        return this.errorIntStr2(error, null, null);
    }

    protected boolean errorStr(int error, String value) {
        return this.errorIntStr2(error, value, null);
    }

    protected boolean errorIntStr2(int iError, String value, String more) {
        String strError = ScriptTokenParser.errorString(iError, value, more, true);
        String strUntranslated = GT.getDoTranslate() ? ScriptTokenParser.errorString(iError, value, more, false) : null;
        return this.errorStr2(strError, strUntranslated);
    }

    private boolean isError() {
        return this.errorMessage != null;
    }

    protected boolean errorStr2(String errorMessage, String strUntranslated) {
        this.errorMessage = errorMessage;
        this.errorMessageUntranslated = strUntranslated;
        return false;
    }
}

