/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.BS;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.P3d;
import javajs.util.T3d;
import org.jmol.api.SymmetryInterface;
import org.jmol.render.CageRenderer;
import org.jmol.shape.Axes;
import org.jmol.shape.Uccage;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.SimpleUnitCell;

public class UccageRenderer
extends CageRenderer {
    private final P3d[] verticesT = new P3d[8];
    private P3d[] vvertA;
    private static final P3d fset0 = P3d.new3(555.0, 555.0, 1.0);
    private final P3d[] cellRange = new P3d[]{new P3d(), new P3d()};
    private final P3d offset = new P3d();
    private final P3d offsetT = new P3d();
    private SymmetryInterface unitcell;
    private int lineheight;
    private int xpos;
    private int ypos;
    private boolean isPlanarGroup;
    private BS bsVerticals;

    @Override
    protected void initRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.verticesT[i] = new P3d();
        }
        this.tickEdges = BoxInfo.uccageTickEdges;
        this.draw000 = false;
    }

    @Override
    protected void setPeriodicity(P3d[] vertices, double scale) {
        this.setShifts();
        if (this.shifting) {
            P3d p0;
            int i;
            if (this.vvert == null) {
                this.vvert = new P3d[8];
                i = 8;
                while (--i >= 0) {
                    this.vvert[i] = new P3d();
                }
            }
            if (this.shiftC && this.periodicity == 1) {
                if (this.vvertA == null) {
                    this.vvertA = new P3d[8];
                    i = 8;
                    while (--i >= 0) {
                        this.vvertA[i] = new P3d();
                    }
                }
                p0 = P3d.newP(vertices[1]);
                p0.sub(vertices[0]);
                p0.scale(0.5);
                i = 8;
                while (--i >= 0) {
                    this.pt.setT(vertices[i]);
                    this.pt.sub(vertices[0]);
                    this.pt.scaleAdd2(scale, this.pt, vertices[0]);
                    this.pt.sub(p0);
                    this.tm.transformPtNoClip(this.pt, this.vvertA[i]);
                }
            } else if (this.shiftA) {
                if (this.vvertA == null) {
                    this.vvertA = new P3d[8];
                    i = 8;
                    while (--i >= 0) {
                        this.vvertA[i] = new P3d();
                    }
                }
                p0 = P3d.newP(vertices[4]);
                p0.sub(vertices[0]);
                p0.scale(0.5);
                i = 8;
                while (--i >= 0) {
                    this.pt.setT(vertices[i]);
                    this.pt.sub(vertices[0]);
                    this.pt.scaleAdd2(scale, this.pt, vertices[0]);
                    this.pt.sub(p0);
                    this.tm.transformPtNoClip(this.pt, this.vvertA[i]);
                }
            } else {
                this.vvertA = null;
            }
            p0 = P3d.newP(vertices[this.shiftB ? 2 : 1]);
            p0.sub(vertices[0]);
            p0.scale(0.5);
            i = 8;
            while (--i >= 0) {
                this.pt.setT(vertices[i]);
                this.pt.sub(vertices[0]);
                this.pt.scaleAdd2(scale, this.pt, vertices[0]);
                this.pt.sub(p0);
                this.tm.transformPtNoClip(this.pt, this.vvert[i]);
            }
        }
    }

    @Override
    protected boolean render() {
        this.imageFontScaling = this.vwr.imageFontScaling;
        this.font3d = this.vwr.gdata.getFont3DScaled(((Uccage)this.shape).font3d, this.imageFontScaling);
        int mad10 = this.vwr.getObjectMad10(5);
        if (mad10 == 0 || this.vwr.isJmolDataFrame() || this.tm.isNavigating() && this.vwr.getBoolean(603979890)) {
            return false;
        }
        this.colix = this.vwr.getObjectColix(5);
        boolean needTranslucent = C.renderPass2(this.colix);
        if (!this.isExport && needTranslucent != this.vwr.gdata.isPass2) {
            return needTranslucent;
        }
        this.render1(mad10);
        return false;
    }

    private void render1(int mad10) {
        int[][] faces;
        boolean haveMultiple;
        this.g3d.setC(this.colix);
        this.unitcell = this.vwr.getCurrentUnitCell();
        if (this.unitcell == null) {
            return;
        }
        this.isPolymer = this.unitcell.isPolymer();
        this.isSlab = this.unitcell.isSlab();
        this.periodicity = this.unitcell.getPeriodicity();
        this.nDims = this.unitcell.getDimensionality();
        this.isPlanarGroup = this.periodicity == 3 && this.nDims == 2;
        P3d[] vertices = this.unitcell.getUnitCellVerticesNoOffset();
        this.offset.setT(this.unitcell.getCartesianOffset());
        this.offsetT.setT(this.unitcell.getFractionalOrigin());
        this.unitcell.toCartesian(this.offsetT, true);
        this.offset.sub(this.offsetT);
        boolean hiddenLines = this.vwr.getBoolean(603979856);
        T3d fset = this.unitcell.getUnitCellMultiplier();
        boolean bl = haveMultiple = fset != null && !fset.equals(fset0);
        if (!haveMultiple) {
            fset = fset0;
        }
        SimpleUnitCell.getCellRange(fset, this.cellRange);
        double scale = Math.abs(fset.z);
        Axes axes = (Axes)this.vwr.shm.getShape(34);
        if (axes != null && this.vwr.areAxesTainted()) {
            axes.reinitShape();
        }
        P3d[] axisPoints = axes == null || this.vwr.getObjectMad10(1) == 0 || axes.axisXY.z != 0.0 && (axes.axes2 == null || axes.axes2.length() == 3) || axes.fixedOrigin != null || axes.fixedOriginUC.lengthSquared() > 0.0 ? null : axes.axisPoints;
        boolean drawAllLines = this.isExport || this.vwr.getObjectMad10(1) == 0 || this.vwr.getDouble(0x22000002) < 2.0 || axisPoints == null;
        P3d[] aPoints = axisPoints;
        int[][] nArray = faces = hiddenLines ? BoxInfo.facePoints : (int[][])null;
        if (fset.z == 0.0) {
            this.offsetT.setT(this.cellRange[0]);
            this.unitcell.toCartesian(this.offsetT, true);
            this.offsetT.add(this.offset);
            aPoints = this.cellRange[0].x == 0.0 && this.cellRange[0].y == 0.0 && this.cellRange[0].z == 0.0 ? axisPoints : null;
            int firstLine = 0;
            int allow0 = 255;
            int allow1 = 255;
            P3d[] pts = BoxInfo.unitCubePoints;
            int i = 8;
            while (--i >= 0) {
                P3d v = P3d.new3(pts[i].x * (this.cellRange[1].x - this.cellRange[0].x), pts[i].y * (this.cellRange[1].y - this.cellRange[0].y), pts[i].z * (this.cellRange[1].z - this.cellRange[0].z));
                this.unitcell.toCartesian(v, true);
                this.verticesT[i].add2(v, this.offsetT);
            }
            this.renderCage(mad10, this.verticesT, faces, aPoints, firstLine, allow0, allow1, 1.0);
        } else {
            int x = (int)this.cellRange[0].x;
            while ((double)x < this.cellRange[1].x) {
                int y = (int)this.cellRange[0].y;
                while ((double)y < this.cellRange[1].y) {
                    int z = (int)this.cellRange[0].z;
                    while ((double)z < this.cellRange[1].z) {
                        int firstLine;
                        if (haveMultiple) {
                            this.offsetT.set(x, y, z);
                            this.offsetT.scale(scale);
                            this.unitcell.toCartesian(this.offsetT, true);
                            this.offsetT.add(this.offset);
                            aPoints = x == 0 && y == 0 && z == 0 ? axisPoints : null;
                            firstLine = drawAllLines || aPoints == null ? 0 : 3;
                        } else {
                            this.offsetT.setT(this.offset);
                            firstLine = drawAllLines ? 0 : 3;
                        }
                        int allow0 = 255;
                        int allow1 = 255;
                        int i = 8;
                        while (--i >= 0) {
                            this.verticesT[i].add2(vertices[i], this.offsetT);
                        }
                        this.renderCage(mad10, this.verticesT, faces, aPoints, firstLine, allow0, allow1, scale);
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        this.renderInfo();
    }

    @Override
    protected void renderCageLine(int i, int edge0, int edge1, int d, boolean drawTicks) {
        P3d p2;
        P3d p1;
        if (this.bsVerticals != null && this.bsVerticals.get(i)) {
            if (this.vvertA != null && (i == 4 || i == 8 || i == 12 || i == 16 || i == 0 && this.periodicity != 2)) {
                p1 = this.vvertA[edge0];
                p2 = this.vvertA[edge1];
            } else {
                p1 = this.vvert[edge0];
                p2 = this.vvert[edge1];
            }
        } else {
            p1 = this.p3Screens[edge0];
            p2 = this.p3Screens[edge1];
        }
        this.renderLine(p1, p2, d, drawTicks);
    }

    @Override
    protected void setBSPeriod() {
        if (this.bsVerticals != null) {
            this.bsVerticals.clearAll();
        }
        if (this.bsPeriod != null) {
            this.bsPeriod.clearAll();
        }
        switch (this.periodicity) {
            case 7: {
                return;
            }
            case 3: {
                BS bs;
                BS bS = bs = this.bsPeriod == null ? (this.bsPeriod = new BS()) : this.bsPeriod;
                if (this.nDims == 3) {
                    bs.set(0);
                    bs.set(10);
                    bs.set(16);
                    bs.set(22);
                    if (this.bsVerticals == null) {
                        this.bsVerticals = new BS();
                    }
                    BSUtil.copy2(bs, this.bsVerticals);
                }
                bs.set(2);
                bs.set(4);
                bs.set(12);
                bs.set(18);
                break;
            }
            case 4: {
                BS bs = this.bsPeriod == null ? (this.bsPeriod = new BS()) : this.bsPeriod;
                bs.set(2);
                bs.set(6);
                bs.set(4);
                bs.set(8);
                if (this.bsVerticals == null) {
                    this.bsVerticals = new BS();
                }
                BSUtil.copy2(bs, this.bsVerticals);
                bs.set(0);
                break;
            }
            case 1: {
                BS bs = this.bsPeriod == null ? (this.bsPeriod = new BS()) : this.bsPeriod;
                bs.set(2);
                bs.set(18);
                if (this.nDims == 3) {
                    bs.set(0);
                    bs.set(16);
                }
                if (this.bsVerticals == null) {
                    this.bsVerticals = new BS();
                }
                BSUtil.copy2(bs, this.bsVerticals);
                bs.set(4);
                break;
            }
            case 2: {
                BS bs = this.bsPeriod == null ? (this.bsPeriod = new BS()) : this.bsPeriod;
                bs.set(0);
                bs.set(4);
                bs.set(12);
                bs.set(10);
                if (this.bsVerticals == null) {
                    this.bsVerticals = new BS();
                }
                BSUtil.copy2(bs, this.bsVerticals);
                bs.set(2);
            }
        }
    }

    private void renderInfo() {
        boolean showDetails = this.vwr.getBoolean(603979937);
        if (this.isExport || !this.vwr.getBoolean(603979828) || this.vwr.isPreviewOnly || !this.vwr.gdata.setC(this.vwr.cm.colixBackgroundContrast) || this.vwr.gdata.getTextPosition() != 0) {
            return;
        }
        this.vwr.gdata.setFontBold("Monospaced", 14.0 * this.imageFontScaling);
        this.xpos = (int)Math.floor(10.0 * this.imageFontScaling);
        this.ypos = this.lineheight = (int)Math.floor(15.0 * this.imageFontScaling);
        if (!this.unitcell.isSimple()) {
            Lst<String> info;
            String sgName = this.unitcell.getUnitCellDisplayName();
            if (sgName != null) {
                this.drawInfo(sgName, 0, null);
            }
            if ((info = this.unitcell.getMoreInfo()) != null) {
                for (int i = 0; i < info.size(); ++i) {
                    this.drawInfo((String)info.get(i), 0, null);
                }
            }
            if (!showDetails) {
                return;
            }
        }
        this.drawInfo("a=", 0, "\u00c5");
        if (!this.isPolymer) {
            this.drawInfo("b=", 1, "\u00c5");
        }
        if (!(this.isPolymer || this.isSlab || this.isPlanarGroup)) {
            this.drawInfo("c=", 2, "\u00c5");
        }
        if (!this.isPolymer) {
            if (!this.isSlab && !this.isPlanarGroup) {
                this.drawInfo("\u03b1=", 3, "\u00b0");
                this.drawInfo("\u03b2=", 4, "\u00b0");
            }
            this.drawInfo("\u03b3=", 5, "\u00b0");
        }
    }

    private void drawInfo(String s, int type, String post) {
        this.ypos += this.lineheight;
        if (post != null) {
            s = s + DF.formatDecimal(this.unitcell.getUnitCellInfoType(type), 3) + post;
        }
        this.g3d.drawStringNoSlab(s, null, this.xpos, this.ypos, 0, (short)0);
    }
}

