/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.FFParam;

class UFFVDWCalc
extends Calculation {
    private static final double MAX_VDW_DIST2 = 50.0;

    UFFVDWCalc() {
    }

    @Override
    void setData(Lst<Object[]> calc, int ia, int ib, double dd) {
        double Xb;
        double Db;
        double Xa;
        double Da;
        this.a = this.calcs.minAtoms[ia];
        this.b = this.calcs.minAtoms[ib];
        if (this.a.atom.distanceSquared(this.b.atom) > 50.0) {
            return;
        }
        FFParam parA = (FFParam)this.calcs.getParameter(this.a.sType);
        FFParam parB = (FFParam)this.calcs.getParameter(this.b.sType);
        if (parA == null || parA.dVal == null) {
            System.out.println("OHOH");
            Da = 0.0;
            Xa = 0.0;
        } else {
            Xa = parA.dVal[2];
            Da = parA.dVal[3];
        }
        if (parB == null || parB.dVal == null) {
            System.out.println("OHOH");
            Db = 0.0;
            Xb = 0.0;
        } else {
            Xb = parB.dVal[2];
            Db = parB.dVal[3];
        }
        double Dab = 4.1868 * Math.sqrt(Da * Db);
        double Xab = Math.sqrt(Xa * Xb);
        Object[] objectArray = new Object[3];
        this.iData = new int[]{ia, ib};
        objectArray[0] = this.iData;
        objectArray[1] = new double[]{Xab, Dab};
        objectArray[2] = this.isLoggable(2);
        calc.addLast(objectArray);
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        double Xab = this.dData[0];
        double Dab = this.dData[1];
        this.calcs.setPairVariables(this);
        double term = Xab / this.rab;
        double term6 = term * term * term;
        term6 *= term6;
        this.energy = Dab * term6 * (term6 - 2.0);
        if (this.calcs.gradients) {
            this.dE = Dab * 12.0 * (1.0 - term6) * term6 * term / Xab;
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging && dataIn[2] == Boolean.TRUE) {
            this.calcs.appendLogData(this.calcs.getDebugLine(5, this));
        }
        return this.energy;
    }
}

