/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class XplorReader
extends MapFileReader {
    private int nBlock;
    private int linePt = Integer.MAX_VALUE;
    private int nRead;

    XplorReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2MFR(sg, br);
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.nSurfaces = 1;
    }

    @Override
    protected void readParameters() throws Exception {
        int nLines;
        this.jvxlFileHeaderBuffer = new SB();
        int i = nLines = this.parseIntStr(this.getLine());
        while (--i >= 0) {
            this.line = this.br.readLine().trim();
            Logger.info("XplorReader: " + this.line);
            this.jvxlFileHeaderBuffer.append("# ").append(this.line).appendC('\n');
        }
        this.jvxlFileHeaderBuffer.append("Xplor data\nJmol " + Viewer.getJmolVersion() + '\n');
        this.na = this.parseIntStr(this.getLine());
        this.xyzStart[0] = this.parseInt();
        this.n0 = (int)((double)this.parseInt() - this.xyzStart[0] + 1.0);
        this.nb = this.parseInt();
        this.xyzStart[1] = this.parseInt();
        this.n1 = (int)((double)this.parseInt() - this.xyzStart[1] + 1.0);
        this.nc = this.parseInt();
        this.xyzStart[2] = this.parseInt();
        this.n2 = (int)((double)this.parseInt() - this.xyzStart[2] + 1.0);
        this.a = this.parseDoubleStr(this.getLine());
        this.b = this.parseDouble();
        this.c = this.parseDouble();
        this.alpha = this.parseDouble();
        this.beta = this.parseDouble();
        this.gamma = this.parseDouble();
        this.getLine();
        this.maps = 3;
        this.mapr = 2;
        this.mapc = 1;
        this.getVectorsAndOrigin();
        this.setCutoffAutomatic();
        this.nBlock = this.voxelCounts[2] * this.voxelCounts[1];
    }

    private String getLine() throws Exception {
        this.rd();
        while (this.line != null && (this.line.length() == 0 || this.line.indexOf("REMARKS") >= 0 || this.line.indexOf("XPLOR:") >= 0)) {
            this.rd();
        }
        return this.line;
    }

    @Override
    protected double nextVoxel() throws Exception {
        if (this.linePt >= this.line.length()) {
            this.rd();
            this.linePt = 0;
            if (this.nRead % this.nBlock == 0) {
                this.rd();
            }
        }
        if (this.line == null) {
            return 0.0;
        }
        double val = this.parseDoubleRange(this.line, this.linePt, this.linePt + 12);
        this.linePt += 12;
        ++this.nRead;
        return val;
    }
}

