/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4d;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.M4d;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.SB;
import javajs.util.V3d;
import org.jmol.atomdata.RadiusData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ContactPair;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class Parameters {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_INITIALIZED = 1;
    public static final int STATE_DATA_READ = 2;
    public static final int STATE_DATA_COLORED = 3;
    public int state = 0;
    public int testFlags = 0;
    boolean logMessages = false;
    boolean logCompression = false;
    boolean logCube = false;
    public boolean isSilent = false;
    double assocCutoff = 0.3;
    static final int NO_ANISOTROPY = 32;
    static final int IS_SILENT = 64;
    public static final int IS_SOLVENTTYPE = 128;
    static final int HAS_MAXGRID = 256;
    static final int IS_POINTMAPPABLE = 512;
    static final int IS_SLABBABLE = 1024;
    public int dataType;
    int surfaceType;
    static final int SURFACE_NONE = 0;
    static final int SURFACE_SPHERE = 65;
    static final int SURFACE_ELLIPSOID2 = 66;
    static final int SURFACE_ELLIPSOID3 = 67;
    static final int SURFACE_LOBE = 68;
    static final int SURFACE_LCAOCARTOON = 69;
    public static final int SURFACE_LONEPAIR = 70;
    public static final int SURFACE_RADICAL = 71;
    static final int SURFACE_FUNCTIONXY = 8;
    static final int SURFACE_FUNCTIONXYZ = 9;
    static final int SURFACE_GEODESIC = 74;
    static final int SURFACE_SOLVENT = 1195;
    static final int SURFACE_SASURFACE = 1196;
    static final int SURFACE_MOLECULARORBITAL = 1837;
    static final int SURFACE_ATOMICORBITAL = 1294;
    static final int SURFACE_MEP = 1328;
    static final int SURFACE_MLP = 1329;
    static final int SURFACE_MOLECULAR = 1203;
    static final int SURFACE_NCI = 1844;
    static final int SURFACE_INTERSECT_ATOM = 1333;
    static final int SURFACE_INTERSECT_FILE = 1334;
    static final int SURFACE_NOMAP = 1207;
    static final int SURFACE_PROPERTY = 1208;
    String calculationType = "";
    public RadiusData atomRadiusData;
    boolean addHydrogens;
    double solventRadius;
    double solventExtendedAtomRadius;
    boolean propertySmoothing;
    int propertySmoothingPower = 4;
    double envelopeRadius;
    double cavityRadius;
    boolean isCavity;
    Boolean pocket;
    int minSet;
    public Lst<Object[]> slabInfo;
    double slabPlaneOffset = Double.NaN;
    double[] theProperty;
    double solvent_ptsPerAngstrom = 4.0;
    int solvent_gridMax = 60;
    double plane_ptsPerAngstrom = 4.0;
    int plane_gridMax = 81;
    static final double ANGSTROMS_PER_BOHR = 0.5291772;
    static final int defaultEdgeFractionBase = 35;
    static final int defaultEdgeFractionRange = 90;
    static final int defaultColorFractionBase = 35;
    static final int defaultColorFractionRange = 90;
    static final double defaultMappedDataMin = 0.0;
    static final double defaultMappedDataMax = 1.0;
    static final double defaultCutoff = (double)0.02f;
    static final double defaultOrbitalCutoff = 0.04;
    static final double defaultLobeCutoff = 0.14;
    static final double defaultOrbitalCutoffOld = 0.14;
    public static final double defaultQMOrbitalCutoff = 0.05;
    static final double defaultQMElectronDensityCutoff = 0.01;
    static final int defaultContourCount = 11;
    static final int nContourMax = 100;
    static final int defaultColorNegative = -65536;
    static final int defaultColorPositive = -16776961;
    static final int defaultColorNegativeLCAO = -8388480;
    static final int defaultColorPositiveLCAO = -23296;
    static final double defaultSolventRadius = 1.2;
    static final double defaultMepCutoff = 0.1;
    static final double defaultMepMin = -0.1;
    static final double defaultMepMax = 0.1;
    boolean colorBySign;
    boolean colorByPhase;
    boolean colorBySets;
    public int colorRgb;
    public int colorNeg;
    public int colorPos;
    int colorPosLCAO;
    int colorNegLCAO;
    int colorPhase;
    public boolean colorDensity;
    public boolean iAddGridPoints;
    int atomIndex;
    boolean isAngstroms;
    double scale;
    public double scale3d;
    double[] anisotropy = new double[3];
    boolean isAnisotropic;
    M3d eccentricityMatrix;
    M3d eccentricityMatrixInverse;
    boolean isEccentric;
    double eccentricityScale;
    double eccentricityRatio;
    double[] aniosU;
    double[] anisoB;
    String lcaoType;
    public Lst<Object> functionInfo;
    int psi_n = 2;
    int psi_l = 1;
    int psi_m = 1;
    double psi_Znuc = 1.0;
    double psi_ptsPerAngstrom = 5.0;
    public int psi_monteCarloCount = 0;
    public static final int MEP_MAX_GRID = 40;
    int mep_gridMax = 40;
    double mep_ptsPerAngstrom = 3.0;
    double mep_marginAngstroms = 1.0;
    public int mep_calcType = -1;
    int qmOrbitalType;
    int qmOrbitalCount;
    static final int QM_TYPE_UNKNOWN = 0;
    static final int QM_TYPE_GAUSSIAN = 1;
    static final int QM_TYPE_SLATER = 2;
    static final int QM_TYPE_NCI_PRO = 3;
    static final int QM_TYPE_NCI_SCF = 4;
    static final int QM_TYPE_VOLUME_DATA = 5;
    public Map<String, Object> moData;
    public static final int MO_MAX_GRID = 80;
    int qm_gridMax = 80;
    double qm_ptsPerAngstrom = 10.0;
    double qm_marginAngstroms = 1.0;
    int qm_nAtoms;
    int qm_moNumber = Integer.MAX_VALUE;
    double[] qm_moLinearCombination = null;
    P3d center;
    P3d point;
    double distance;
    public boolean allowVolumeRender;
    public String script;
    public BS bsSelected;
    public BS bsIgnore;
    public BS bsSolvent;
    public Object func;
    public String[] title;
    boolean blockCubeData;
    boolean readAllData;
    int fileIndex = -1;
    public String fileName;
    public int modelIndex = -1;
    public M4d modelInvRotation = null;
    public boolean isXLowToHigh;
    boolean insideOut;
    boolean dataXYReversed;
    public double cutoff = Double.MAX_VALUE;
    public double[] cutoffRange;
    public double sigma = Double.MAX_VALUE;
    boolean cutoffAutomatic = true;
    public boolean isCutoffAbsolute;
    public boolean isPositiveOnly;
    boolean rangeAll;
    boolean rangeSelected;
    public boolean rangeDefined;
    double valueMappedToRed;
    double valueMappedToBlue;
    double mappedDataMin;
    double mappedDataMax;
    boolean isColorReversed;
    public boolean isBicolorMap;
    public boolean isSquared;
    public boolean isSquaredLinear;
    public P4d thePlane;
    public boolean isContoured;
    int nContours;
    int thisContour;
    boolean contourFromZero;
    double[] parameters;
    public double resolution;
    int downsampleFactor;
    int maxSet;
    public double[] contoursDiscrete;
    public short[] contourColixes;
    P3d contourIncrements;
    public P3d[] boundingBox;
    public BS[] bsExcluded;
    public int contourType;
    public boolean colorSchemeTranslucent;
    public ColorEncoder colorEncoder;
    public boolean usePropertyForColorRange = true;
    public boolean isPeriodic;
    public boolean doFullMolecular;
    public double propertyDistanceMax = 2.147483647E9;
    public int randomSeed;
    public boolean fullyLit;
    public int[] vertexSource;
    public BS[] intersection;
    public P3d origin;
    public P3d steps;
    public P3d points;
    public VolumeData volumeData;
    public ContactPair contactPair;
    public P3d mapLattice;
    public double extendGrid;
    public boolean isMapped;
    public boolean showTiming;
    public double pointSize;
    public P3d[] probes;
    public boolean isModelConnected;
    public BS surfaceAtoms;
    public Object[] filesData;
    public double[] probeValues;
    public SB sbOut;

    void initialize() {
        this.addHydrogens = false;
        this.allowVolumeRender = true;
        this.atomRadiusData = null;
        this.atomIndex = -1;
        this.blockCubeData = false;
        this.boundingBox = null;
        this.bsExcluded = new BS[4];
        this.bsIgnore = null;
        this.bsSelected = null;
        this.bsSolvent = null;
        this.calculationType = "";
        this.center = new P3d();
        this.resetForMapping(true);
        this.colorBySets = false;
        this.colorByPhase = false;
        this.colorBySign = false;
        this.colorEncoder = null;
        this.colorNeg = -65536;
        this.colorNegLCAO = -8388480;
        this.colorPos = -16776961;
        this.colorPosLCAO = -23296;
        this.colorRgb = Integer.MIN_VALUE;
        this.colorSchemeTranslucent = false;
        this.contactPair = null;
        this.contourIncrements = null;
        this.contoursDiscrete = null;
        this.contourColixes = null;
        this.contourFromZero = true;
        this.cutoff = Double.MAX_VALUE;
        this.cutoffAutomatic = true;
        this.dataXYReversed = false;
        this.distance = Double.MAX_VALUE;
        this.doFullMolecular = false;
        this.envelopeRadius = 10.0;
        this.extendGrid = 0.0;
        this.fileIndex = 1;
        this.readAllData = true;
        this.fileName = "";
        this.filesData = null;
        this.fullyLit = false;
        this.functionInfo = null;
        this.iAddGridPoints = false;
        this.insideOut = false;
        this.isAngstroms = false;
        this.isPositiveOnly = false;
        this.isCutoffAbsolute = false;
        this.isBicolorMap = false;
        this.isCavity = false;
        this.isColorReversed = false;
        this.isModelConnected = false;
        this.isSquared = false;
        this.isSquaredLinear = false;
        this.isContoured = false;
        this.isEccentric = false;
        this.isMapped = false;
        this.isPeriodic = false;
        this.isSilent = false;
        this.logCompression = false;
        this.logCube = false;
        this.logMessages = Logger.debugging;
        this.mapLattice = null;
        this.mep_calcType = -1;
        this.minSet = 0;
        this.modelIndex = -1;
        this.modelInvRotation = null;
        this.nContours = 0;
        this.pocket = null;
        this.pointSize = Double.NaN;
        this.probes = null;
        this.probeValues = null;
        this.propertyDistanceMax = 2.147483647E9;
        this.propertySmoothing = false;
        this.propertySmoothingPower = 4;
        this.rangeDefined = false;
        this.rangeAll = false;
        this.rangeSelected = false;
        this.resolution = Double.MAX_VALUE;
        this.scale = Double.NaN;
        this.scale3d = 0.0;
        this.sigma = Double.NaN;
        this.slabInfo = null;
        this.solventExtendedAtomRadius = 0.0;
        this.state = 1;
        this.testFlags = 0;
        this.thePlane = null;
        this.theProperty = null;
        this.thisContour = -1;
        this.title = null;
        this.usePropertyForColorRange = true;
        this.vertexSource = null;
    }

    public void resetForMapping(boolean haveSurface) {
        if (!haveSurface) {
            this.state = 2;
        }
        this.center.x = Double.NaN;
        this.colorDensity = false;
        this.func = null;
        this.intersection = null;
        this.isAnisotropic = false;
        this.isMapped = true;
        this.mappedDataMin = Double.MAX_VALUE;
        this.origin = null;
        this.parameters = null;
        this.points = null;
        this.qmOrbitalType = 0;
        this.steps = null;
        this.volumeData = null;
    }

    void setAnisotropy(P3d pt) {
        this.anisotropy[0] = pt.x;
        this.anisotropy[1] = pt.y;
        this.anisotropy[2] = pt.z;
        this.isAnisotropic = true;
        if (Double.isNaN(this.center.x)) {
            this.center.set(0.0, 0.0, 0.0);
        }
    }

    void setEccentricity(P4d info) {
        V3d ecc = V3d.new3(info.x, info.y, info.z);
        double c = this.scale > 0.0 ? this.scale : (info.w < 0.0 ? 1.0 : ecc.length());
        double fab_c = Math.abs(info.w);
        ecc.normalize();
        V3d z = V3d.new3(0.0, 0.0, 1.0);
        ecc.add(z);
        ecc.normalize();
        if (Double.isNaN(ecc.x)) {
            ecc.set(1.0, 0.0, 0.0);
        }
        this.eccentricityMatrixInverse = new M3d();
        this.eccentricityMatrix = new M3d().setAA(A4d.newVA(ecc, Math.PI));
        this.eccentricityMatrixInverse.invertM(this.eccentricityMatrix);
        this.isAnisotropic = true;
        this.isEccentric = true;
        this.eccentricityScale = c;
        this.eccentricityRatio = fab_c;
        if (fab_c > 1.0) {
            this.eccentricityScale *= fab_c;
        }
        this.anisotropy[0] = fab_c * c;
        this.anisotropy[1] = fab_c * c;
        this.anisotropy[2] = c;
        if (Double.isNaN(this.center.x)) {
            this.center.set(0.0, 0.0, 0.0);
        }
    }

    void setPlane(P4d plane) {
        this.thePlane = plane;
        if (this.thePlane.x == 0.0 && this.thePlane.y == 0.0 && this.thePlane.z == 0.0) {
            this.thePlane.z = 1.0;
        }
        this.isContoured = true;
    }

    void setSphere(double radius, boolean isGeodesic) {
        this.dataType = isGeodesic ? 74 : 65;
        this.distance = radius;
        this.setEccentricity(P4d.new4(0.0, 0.0, 1.0, 1.0));
        this.cutoff = Double.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
        this.script = this.getScriptParams() + " SPHERE " + radius + ";";
    }

    void setEllipsoidP4(P4d v) {
        this.dataType = 66;
        this.distance = 1.0;
        this.setEccentricity(v);
        this.cutoff = Double.MIN_VALUE;
        this.isCutoffAbsolute = false;
        this.isSilent = !this.logMessages;
    }

    public void setEllipsoidAF(double[] bList) {
        this.anisoB = bList;
        this.dataType = 67;
        this.distance = 0.3 * (Double.isNaN(this.scale) ? 1.0 : this.scale);
        this.cutoff = Double.MIN_VALUE;
        this.isCutoffAbsolute = false;
        boolean bl = this.isSilent = !this.logMessages;
        if (Double.isNaN(this.center.x)) {
            this.center.set(0.0, 0.0, 0.0);
        }
        if (this.resolution == Double.MAX_VALUE) {
            this.resolution = 6.0;
        }
    }

    void setLobe(P4d v) {
        this.dataType = 68;
        this.setEccentricity(v);
        if (this.cutoff == Double.MAX_VALUE) {
            this.cutoff = 0.14;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = this.getScriptParams() + " LOBE {" + v.x + " " + v.y + " " + v.z + " " + v.w + "};";
    }

    private String getScriptParams() {
        return " center " + Escape.eP(this.center) + (Double.isNaN(this.scale) ? "" : " scale " + this.scale);
    }

    void setLp(P4d v) {
        this.dataType = 70;
        this.setEccentricity(v);
        if (this.cutoff == Double.MAX_VALUE) {
            this.cutoff = 0.14;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.eP(this.center) + (Double.isNaN(this.scale) ? "" : " scale " + this.scale) + " LP {" + v.x + " " + v.y + " " + v.z + " " + v.w + "};";
    }

    void setRadical(P4d v) {
        this.dataType = 71;
        this.setEccentricity(v);
        if (this.cutoff == Double.MAX_VALUE) {
            this.cutoff = 0.14;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isSilent = !this.logMessages;
        this.script = " center " + Escape.eP(this.center) + (Double.isNaN(this.scale) ? "" : " scale " + this.scale) + " RAD {" + v.x + " " + v.y + " " + v.z + " " + v.w + "};";
    }

    void setLcao(String type, int colorPtr) {
        this.lcaoType = type;
        if (colorPtr == 1) {
            this.colorPosLCAO = this.colorNegLCAO;
        }
        this.isSilent = !this.logMessages;
    }

    void setSolvent(String propertyName, double radius) {
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.solventRadius = Math.abs(radius);
        int n = this.intersection != null ? 1333 : ("nomap" == propertyName ? 1207 : ("molecular" == propertyName ? 1203 : (this.dataType = "sasurface" == propertyName || this.solventRadius == 0.0 ? 1196 : 1195)));
        if (!(this.state >= 2 || !this.cutoffAutomatic && this.colorDensity || this.intersection != null && this.cutoff != Double.MAX_VALUE)) {
            this.cutoff = 0.0;
        }
        switch (this.dataType) {
            case 1333: {
                this.calculationType = "VDW intersection";
                break;
            }
            case 1207: {
                this.calculationType = "unmapped plane";
                break;
            }
            case 1203: {
                this.calculationType = "molecular surface with radius " + this.solventRadius;
                if (this.minSet != 0) break;
                this.minSet = 50;
                break;
            }
            case 1195: {
                this.calculationType = "solvent-excluded surface with radius " + this.solventRadius;
                if (this.minSet != 0) break;
                this.minSet = 50;
                break;
            }
            case 1196: {
                this.calculationType = "solvent-accessible surface with radius " + this.solventRadius;
                if (this.minSet != 0) break;
                this.minSet = 50;
            }
        }
        switch (this.dataType) {
            case 1207: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0;
                this.isContoured = false;
                break;
            }
            case 1203: {
                this.solventExtendedAtomRadius = 0.0;
                break;
            }
            case 1195: {
                this.solventExtendedAtomRadius = 0.0;
                if (this.bsIgnore == null) {
                    this.bsIgnore = this.bsSolvent;
                    break;
                }
                if (this.bsSolvent == null) break;
                this.bsIgnore.or(this.bsSolvent);
                break;
            }
            case 1196: {
                this.solventExtendedAtomRadius = this.solventRadius;
                this.solventRadius = 0.0;
                if (this.bsIgnore == null) {
                    this.bsIgnore = this.bsSolvent;
                    break;
                }
                if (this.bsSolvent == null) break;
                this.bsIgnore.or(this.bsSolvent);
            }
        }
    }

    void setFunctionXY(Lst<Object> value) {
        this.dataType = 8;
        this.functionInfo = value;
        this.cutoff = Double.MIN_VALUE;
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    void setFunctionXYZ(Lst<Object> value) {
        this.dataType = 9;
        this.functionInfo = value;
        if (this.cutoff == Double.MAX_VALUE) {
            this.cutoff = Double.MIN_VALUE;
        }
        this.isAnisotropic = false;
        this.isEccentric = false;
    }

    boolean setAtomicOrbital(double[] nlmZprs) {
        this.dataType = 1294;
        this.setEccentricity(P4d.new4(0.0, 0.0, 1.0, 1.0));
        this.psi_n = (int)nlmZprs[0];
        this.psi_l = (int)nlmZprs[1];
        this.psi_m = (int)nlmZprs[2];
        this.psi_Znuc = nlmZprs[3];
        this.psi_monteCarloCount = (int)nlmZprs[4];
        this.distance = nlmZprs[5];
        if (this.distance != 0.0 || this.thePlane != null) {
            this.allowVolumeRender = false;
        }
        this.randomSeed = (int)nlmZprs[6];
        this.psi_ptsPerAngstrom = 10.0;
        if (this.cutoff == Double.MAX_VALUE || this.cutoff == 0.14) {
            double d = this.cutoff = this.psi_monteCarloCount > 0 ? 0.0 : 0.04;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = true;
        if (this.state < 2 && this.thePlane == null && this.colorBySign) {
            this.isBicolorMap = true;
        }
        return this.psi_Znuc > 0.0 && Math.abs(this.psi_m) <= this.psi_l && this.psi_l < this.psi_n;
    }

    void setMep(double[] charges, boolean isMLP) {
        this.dataType = isMLP ? 1329 : 1328;
        this.theProperty = charges;
        this.usePropertyForColorRange = false;
        this.isAnisotropic = false;
        this.isEccentric = false;
        if (this.cutoff == Double.MAX_VALUE) {
            this.cutoff = 0.1;
            if (this.isSquared) {
                this.cutoff *= this.cutoff;
            }
        }
        this.isCutoffAbsolute = this.cutoff > 0.0 && !this.isPositiveOnly;
        this.contourFromZero = false;
        if (this.state >= 2 || this.thePlane != null) {
            if (!this.rangeDefined && !this.rangeAll) {
                this.valueMappedToRed = -0.1;
                this.valueMappedToBlue = 0.1;
                this.rangeDefined = true;
            }
        } else {
            this.colorBySign = true;
            this.isBicolorMap = true;
        }
    }

    void setNci(boolean isPromolecular) {
        this.fullyLit = true;
        this.qm_gridMax = 200;
        if (isPromolecular) {
            this.dataType = 1844;
        }
        this.qm_marginAngstroms = 2.0;
        int n = this.qmOrbitalType = isPromolecular ? 3 : 4;
        if (isPromolecular && (this.parameters == null || this.parameters.length < 2)) {
            this.parameters = new double[]{this.cutoff, 2.0};
        }
        if (this.cutoff == Double.MAX_VALUE || this.cutoff == 0.0) {
            this.cutoff = 0.3;
        }
        if (this.isSquared) {
            this.cutoff *= this.cutoff;
        }
        if (this.title == null) {
            this.title = new String[0];
        }
        this.moData = new Hashtable<String, Object>();
    }

    void setMO(int iMo, double[] linearCombination) {
        boolean isElectronDensity;
        this.isModelConnected = true;
        this.qm_moLinearCombination = linearCombination;
        int n = this.qm_moNumber = linearCombination == null ? Math.abs(iMo) : (int)linearCombination[1];
        this.qmOrbitalType = this.moData.containsKey("haveVolumeData") ? 5 : (this.moData.containsKey("gaussians") ? 1 : (this.moData.containsKey("slaters") ? 2 : 0));
        boolean bl = isElectronDensity = iMo <= 0 && linearCombination == null;
        if (this.qmOrbitalType == 0) {
            Logger.error("MO ERROR: No basis functions found in file for MO calculation. (GAUSSIAN 'gfprint' keyword may be missing?)");
            this.title = new String[]{"no basis functions found in file"};
        } else {
            Lst mos = (Lst)this.moData.get("mos");
            this.qmOrbitalCount = mos.size();
            this.calculationType = (String)this.moData.get("calculationType");
            this.calculationType = "Molecular orbital #" + this.qm_moNumber + "/" + this.qmOrbitalCount + " " + (this.calculationType == null ? "" : this.calculationType);
            if (!isElectronDensity && this.title == null) {
                this.title = new String[5];
                this.title[0] = "%F";
                this.title[1] = "Model %M  MO %I/%N %T";
                this.title[2] = "?Energy = %E %U";
                this.title[3] = "?Symmetry = %S";
                this.title[4] = "?Occupancy = %O";
            }
        }
        this.dataType = 1837;
        if (this.cutoff == Double.MAX_VALUE) {
            double d = this.cutoff = isElectronDensity ? 0.01 : 0.05;
        }
        if (this.isSquared || this.isSquaredLinear) {
            this.cutoff *= this.cutoff;
        }
        this.isAnisotropic = false;
        this.isEccentric = false;
        boolean bl2 = this.isCutoffAbsolute = this.cutoff > 0.0 && !this.isPositiveOnly;
        if (this.state >= 2 || this.thePlane != null) {
            return;
        }
        this.colorBySign = true;
        if (this.colorByPhase && this.colorPhase == 0) {
            this.colorByPhase = false;
        }
        this.isBicolorMap = true;
    }

    void setMapRanges(SurfaceReader surfaceReader, boolean haveData) {
        if (!this.colorDensity && (this.colorByPhase || this.colorBySign || (this.thePlane != null || this.isBicolorMap) && !this.isContoured)) {
            this.mappedDataMin = -1.0;
            this.mappedDataMax = 1.0;
        }
        if (this.mappedDataMin == Double.MAX_VALUE || this.mappedDataMin == this.mappedDataMax) {
            double[] minMax = surfaceReader.getMinMaxMappedValues(haveData);
            System.out.println("parameters - setmapranges " + minMax[0] + " " + minMax[1]);
            this.mappedDataMin = minMax[0];
            this.mappedDataMax = minMax[1];
        }
        if (this.mappedDataMin == 0.0 && this.mappedDataMax == 0.0) {
            this.mappedDataMin = -1.0;
            this.mappedDataMax = 1.0;
        }
        if (!this.rangeDefined) {
            this.valueMappedToRed = this.mappedDataMin;
            this.valueMappedToBlue = this.mappedDataMax;
        }
    }

    public void addSlabInfo(Object[] slabObject) {
        if (this.slabInfo == null) {
            this.slabInfo = new Lst();
        }
        this.slabInfo.addLast(slabObject);
    }

    public boolean isInsideOut() {
        return this.insideOut != this.dataXYReversed;
    }

    public boolean isFullyLit() {
        return this.thePlane != null || this.fullyLit;
    }
}

