/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4d;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.PT;
import javajs.util.Qd;
import javajs.util.T3d;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.util.Font;
import org.jmol.util.Geodesic;
import org.jmol.viewer.Viewer;

public class _VrmlExporter
extends __CartesianExporter {
    protected UseTable useTable;
    private Map<String, Boolean> htSpheresRendered = new Hashtable<String, Boolean>();
    private T3d[] plateVertices;
    private int[][] plateIndices;
    private short[] plateColixes;
    protected P3d tempQ1 = new P3d();
    protected P3d tempQ2 = new P3d();
    protected P3d tempQ3 = new P3d();
    private int[][] oneFace;
    private P3d[] threeVertices;
    protected double fontSize;
    protected String fontFace;
    protected String fontStyle;
    protected String fontChild;

    public _VrmlExporter() {
        this.useTable = new UseTable("USE ");
        this.commentChar = "# ";
        this.canCapCylinders = true;
        this.solidOnly = true;
    }

    @Override
    protected void output(T3d pt) {
        this.output(_VrmlExporter.round(pt));
    }

    @Override
    protected void outputHeader() {
        this.output("#VRML V2.0 utf8 Generated by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("WorldInfo { \n");
        this.output(" title " + PT.esc(this.vwr.ms.modelSetName) + "\n");
        this.output(" info [ \"Generated by Jmol " + Viewer.getJmolVersion() + " \", \n");
        this.output("  \"http://www.jmol.org \", \n");
        this.output("  \"Creation date: " + this.getExportDate() + " \" ]\n");
        this.output("} \n");
        this.output("NavigationInfo { type \"EXAMINE\" } \n");
        this.output("Background { skyColor [" + this.rgbFractionalFromColix(this.backgroundColix) + "] } \n");
        double angle = this.getViewpoint();
        this.output("Viewpoint{fieldOfView " + angle);
        this.output(" position ");
        this.cameraPosition.scale(this.exportScale);
        this.output(this.cameraPosition);
        this.output(" orientation ");
        this.output(this.tempP1);
        this.output(" " + -this.viewpoint.angle);
        this.output("\n jump TRUE description \"v1\"\n}\n\n");
        this.output(this.getJmolPerspective());
        this.outputInitialTransform();
        this.output("\n");
    }

    protected void outputInitialTransform() {
        this.pushMatrix();
        this.outputAttr("scale", this.exportScale, this.exportScale, this.exportScale);
        this.outputCloseTag();
        this.outputChildStart();
        this.pushMatrix();
        this.tempP1.setT(this.center);
        this.tempP1.scale(-1.0);
        this.outputAttrPt("translation", this.tempP1);
        this.outputCloseTag();
        this.outputChildStart();
    }

    protected double getViewpoint() {
        this.viewpoint.setM(this.vwr.tm.matrixRotate);
        this.tempP1.set(this.viewpoint.x, this.viewpoint.y, this.viewpoint.angle == 0.0 ? 1.0 : this.viewpoint.z);
        return this.apertureAngle * Math.PI / 180.0;
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.output("\n]}\n");
        this.output("]}");
    }

    protected void outputAppearance(short colix, boolean isText) {
        String def = this.getDef((isText ? "T" : "") + colix);
        this.output("appearance ");
        if (def.charAt(0) == '_') {
            String color = this.rgbFractionalFromColix(colix);
            this.output(" DEF " + def + " Appearance{material Material{diffuseColor ");
            if (isText) {
                this.output(" 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + color + " }}");
            } else {
                this.output(color + " transparency " + _VrmlExporter.translucencyFractionalFromColix(colix) + "}}");
            }
            return;
        }
        this.output(def);
    }

    protected void pushMatrix() {
        this.output("Transform{");
    }

    protected void popMatrix() {
        this.output("}\n");
    }

    protected void outputAttrPt(String attr, T3d pt) {
        this.output(" " + attr + " " + pt.x + " " + pt.y + " " + pt.z);
    }

    protected void outputAttr(String attr, double x, double y, double z) {
        this.output(" " + attr + " " + _VrmlExporter.round(x) + " " + _VrmlExporter.round(y) + " " + _VrmlExporter.round(z));
    }

    protected void outputRotation(A4d a) {
        this.output(" rotation " + a.x + " " + a.y + " " + a.z + " " + a.angle);
    }

    protected void outputTransRot(P3d pt1, P3d pt2, int x, int y, int z) {
        this.tempV1.ave(pt2, pt1);
        this.outputAttrPt("translation", this.tempV1);
        this.tempV1.sub(pt1);
        this.tempV1.normalize();
        this.tempV2.set(x, y, z);
        this.tempV2.add(this.tempV1);
        this.outputRotation(A4d.newVA(this.tempV2, Math.PI));
    }

    protected void outputQuaternionFrame(P3d ptCenter, P3d ptX, P3d ptY, P3d ptZ, double xScale, double yScale, double zScale) {
        this.tempQ1.setT(ptX);
        this.tempQ2.setT(ptY);
        A4d a = Qd.getQuaternionFrame(ptCenter, this.tempQ1, this.tempQ2).toA4d();
        if (!Double.isNaN(a.x)) {
            this.tempQ1.set(a.x, a.y, a.z);
            this.outputRotation(a);
        }
        double sx = ptX.distance(ptCenter) * xScale;
        double sy = ptY.distance(ptCenter) * yScale;
        double sz = ptZ.distance(ptCenter) * zScale;
        this.outputAttr("scale", sx, sy, sz);
    }

    protected void outputChildShapeStart() {
        this.outputChildStart();
        this.outputShapeStart();
    }

    protected void outputChildStart() {
        this.output(" children[");
    }

    protected void outputShapeStart() {
        this.output(" Shape{geometry ");
    }

    protected void outputDefChildFaceSet(String child) {
        if (child != null) {
            this.output("DEF " + child + " ");
        }
        this.outputFaceSetStart();
    }

    protected void outputFaceSetStart() {
        this.output("IndexedFaceSet {");
    }

    protected void outputFaceSetClose() {
        this.output("}\n");
    }

    protected void outputUseChildClose(String child) {
        this.output(child);
    }

    protected void outputChildShapeClose() {
        this.outputShapeClose();
        this.outputChildClose();
    }

    protected void outputChildClose() {
        this.output("]");
    }

    protected void outputShapeClose() {
        this.output("}");
    }

    protected void outputCloseTag() {
    }

    @Override
    protected void outputCircle(P3d pt1, P3d pt2, double radius, short colix, boolean doFill) {
        if (doFill) {
            this.pushMatrix();
            this.tempV1.ave(pt1, pt2);
            this.outputAttr("translation", this.tempV1.x, this.tempV1.y, this.tempV1.z);
            this.output(" children [ Billboard{axisOfRotation 0 0 0 children [ Transform{rotation 1 0 0 1.5708");
            double height = pt1.distance(pt2);
            this.outputAttr("scale", radius, height, radius);
            this.outputCylinderChildScaled(colix, (byte)2);
            this.output("}] }]\n");
            this.popMatrix();
            return;
        }
        String child = this.getDef("C" + colix + "_" + radius);
        this.pushMatrix();
        this.outputTransRot(pt1, pt2, 0, 0, 1);
        this.outputAttr("scale", radius, radius, radius);
        this.output(" children [");
        if (child.charAt(0) == '_') {
            int i;
            this.output("DEF " + child);
            this.output(" Billboard{axisOfRotation 0 0 0 children [ Transform{children[");
            this.output(" Shape{");
            this.output("geometry Extrusion{beginCap FALSE convex FALSE endCap FALSE creaseAngle 1.57");
            this.output(" crossSection [");
            double rpd = 0.017453292222222222;
            double scale = (double)0.02f / radius;
            for (i = 0; i <= 360; i += 10) {
                this.output(_VrmlExporter.round(Math.cos((double)i * rpd) * scale) + " ");
                this.output(_VrmlExporter.round(Math.sin((double)i * rpd) * scale) + " ");
            }
            this.output("] spine [");
            for (i = 0; i <= 360; i += 10) {
                this.output(_VrmlExporter.round(Math.cos((double)i * rpd)) + " ");
                this.output(_VrmlExporter.round(Math.sin((double)i * rpd)) + " 0 ");
            }
            this.output("]");
            this.output("}");
            this.outputAppearance(colix, false);
            this.output("}");
            this.output("]} ]}");
        } else {
            this.output(child);
        }
        this.output("]");
        this.popMatrix();
    }

    @Override
    protected void outputCone(P3d ptBase, P3d ptTip, double radius, short colix) {
        double height = ptBase.distance(ptTip);
        this.pushMatrix();
        this.outputTransRot(ptBase, ptTip, 0, 1, 0);
        this.outputAttr("scale", radius, height, radius);
        this.outputCloseTag();
        this.outputChildShapeStart();
        String child = this.getDef("c");
        if (child.charAt(0) == '_') {
            this.outputDefChildFaceSet(child);
            this.outputConeGeometry(true);
            this.outputFaceSetClose();
        } else {
            this.outputUseChildClose(child);
        }
        this.outputAppearance(colix, false);
        this.outputChildShapeClose();
        this.popMatrix();
    }

    private void outputConeGeometry(boolean addBase) {
        int ndeg = 10;
        int n = 360 / ndeg;
        int vertexCount = n + (addBase ? 2 : 1);
        int[][] faces = AU.newInt2(n * (addBase ? 2 : 1));
        int fpt = 0;
        for (int i = 0; i < n; ++i) {
            faces[fpt++] = new int[]{i, (i + n - 1) % n, n};
            if (!addBase) continue;
            faces[fpt++] = new int[]{i, (i + 1) % n, n + 1};
        }
        T3d[] vertexes = new P3d[vertexCount];
        for (int i = 0; i < n; ++i) {
            double x = Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            double y = Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3d.new3(x, -0.5, y);
        }
        vertexes[n++] = P3d.new3(0.0, 0.5, 0.0);
        if (addBase) {
            vertexes[n++] = P3d.new3(0.0, -0.5, 0.0);
        }
        this.outputGeometry(vertexes, null, null, faces, null, vertexCount, faces.length, null, 3, null, null, null);
    }

    @Override
    protected boolean outputCylinder(P3d ptCenter, P3d pt1, P3d pt2, short colix, byte endcaps, double radius, P3d ptX, P3d ptY, boolean checkRadius) {
        double height = pt1.distance(pt2);
        if (radius < (double)0.01f || height == 0.0) {
            return false;
        }
        this.pushMatrix();
        if (ptX == null) {
            this.outputTransRot(pt1, pt2, 0, 1, 0);
            this.outputAttr("scale", radius, height, radius);
        } else {
            this.outputAttrPt("translation", ptCenter);
            this.outputQuaternionFrame(ptCenter, ptY, pt1, ptX, 2.0, 2.0, 2.0);
            pt1.set(0.0, 0.0, -0.5);
            pt2.set(0.0, 0.0, 0.5);
        }
        this.outputCloseTag();
        this.outputCylinderChildScaled(colix, endcaps);
        this.popMatrix();
        if (radius > 0.1) {
            switch (endcaps) {
                case 3: {
                    this.outputSphere(pt1, radius * (double)1.01f, colix, checkRadius);
                }
                case 4: 
                case 5: {
                    this.outputSphere(pt2, radius * (double)1.01f, colix, checkRadius);
                    break;
                }
            }
        }
        return true;
    }

    protected void outputCylinderChildScaled(short colix, byte endcaps) {
        this.outputChildShapeStart();
        String child = this.getDef("C_" + endcaps);
        if (child.charAt(0) == '_') {
            this.outputDefChildFaceSet(child);
            this.outputCylinderGeometry(endcaps);
            this.outputFaceSetClose();
        } else {
            this.outputUseChildClose(child);
        }
        this.outputAppearance(colix, false);
        this.outputChildShapeClose();
    }

    private void outputCylinderGeometry(int endcaps) {
        double y;
        double x;
        int i;
        int ndeg = 10;
        int n = 360 / ndeg;
        int vertexCount = n * 2;
        boolean addEndcaps = false;
        switch (endcaps) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                vertexCount += 2;
                addEndcaps = true;
            }
        }
        int[][] faces = AU.newInt2(n * (addEndcaps ? 4 : 2));
        int fpt = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            faces[fpt++] = new int[]{i2, (i2 + 1) % n, i2 + n};
            faces[fpt++] = new int[]{(i2 + 1) % n, (i2 + 1) % n + n, i2 + n};
            if (!addEndcaps) continue;
            faces[fpt++] = new int[]{i2, (i2 + n - 1) % n, vertexCount - 2};
            faces[fpt++] = new int[]{i2 + n, (i2 + n + 1) % n + n, vertexCount - 1};
        }
        T3d[] vertexes = new P3d[vertexCount];
        for (i = 0; i < n; ++i) {
            x = Math.cos((double)(i * ndeg) / 180.0 * Math.PI);
            y = Math.sin((double)(i * ndeg) / 180.0 * Math.PI);
            vertexes[i] = P3d.new3(x, 0.5, y);
        }
        for (i = 0; i < n; ++i) {
            x = Math.cos(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            y = Math.sin(((double)i + 0.5) * (double)ndeg / 180.0 * Math.PI);
            vertexes[i + n] = P3d.new3(x, -0.5, y);
        }
        if (addEndcaps) {
            vertexes[vertexCount - 2] = P3d.new3(0.0, 0.5, 0.0);
            vertexes[vertexCount - 1] = P3d.new3(0.0, -0.5, 0.0);
        }
        this.outputGeometry(vertexes, null, null, faces, null, vertexCount, faces.length, null, 3, null, null, null);
    }

    @Override
    protected void outputSphere(P3d ptCenter, double radius, short colix, boolean checkRadius) {
        String check = _VrmlExporter.round(ptCenter) + (checkRadius ? " " + (int)(radius * 100.0) : "");
        if (this.htSpheresRendered.get(check) != null) {
            return;
        }
        this.htSpheresRendered.put(check, Boolean.TRUE);
        this.outputSphereChildScaled(ptCenter, radius, null, colix);
    }

    @Override
    protected void outputEllipsoid(P3d ptCenter, P3d[] points, short colix) {
        this.outputSphereChildScaled(ptCenter, 1.0, points, colix);
    }

    private void outputSphereChildScaled(P3d ptCenter, double radius, P3d[] points, short colix) {
        this.pushMatrix();
        this.outputAttrPt("translation", ptCenter);
        if (points == null) {
            this.outputAttr("scale", radius, radius, radius);
        } else {
            this.outputQuaternionFrame(ptCenter, points[1], points[3], points[5], 1.0, 1.0, 1.0);
        }
        this.outputCloseTag();
        this.outputChildShapeStart();
        String child = this.getDef("S");
        if (child.charAt(0) == '_') {
            this.outputDefChildFaceSet(child);
            this.outputSphereGeometry();
            this.outputFaceSetClose();
        } else {
            this.outputUseChildClose(child);
        }
        this.outputAppearance(colix, false);
        this.outputChildShapeClose();
        this.popMatrix();
    }

    private void outputSphereGeometry() {
        T3d[] vertices = Geodesic.getVertexVectors();
        int nVertices = 162;
        short[] faceList = Geodesic.getFaceVertexes(2);
        int nFaces = faceList.length / 3;
        int[][] indices = new int[nFaces][3];
        int p = 0;
        for (int i = 0; i < nFaces; ++i) {
            for (int j = 0; j < 3; ++j) {
                indices[i][j] = faceList[p++];
            }
        }
        this.outputGeometry(vertices, null, null, indices, null, nVertices, nFaces, null, 3, null, null, null);
    }

    @Override
    protected void outputSolidPlate(P3d tempP1, P3d tempP2, P3d tempP3, short colix) {
        int i;
        if (this.plateVertices == null) {
            this.plateVertices = new P3d[6];
            for (i = 0; i < 6; ++i) {
                this.plateVertices[i] = new P3d();
            }
            this.plateIndices = new int[][]{{0, 1, 2}, {5, 4, 3}, {0, 3, 1}, {1, 3, 4}, {1, 4, 2}, {2, 4, 5}, {2, 5, 0}, {0, 5, 3}};
        }
        MeasureD.calcNormalizedNormal(tempP1, tempP2, tempP3, this.tempV1, this.tempV2);
        this.tempV1.scale(0.2);
        this.plateVertices[0].setT(tempP1);
        this.plateVertices[1].setT(tempP2);
        this.plateVertices[2].setT(tempP3);
        for (i = 0; i < 3; ++i) {
            this.plateVertices[i].add(this.tempV1);
        }
        this.tempV1.scale(-2.0);
        for (i = 3; i < 6; ++i) {
            this.plateVertices[i].add2(this.plateVertices[i - 3], this.tempV1);
        }
        this.outputSurface(this.plateVertices, null, null, this.plateIndices, this.plateColixes, 6, 8, 8, null, 3, colix, null, null, null);
    }

    @Override
    protected void outputSurface(T3d[] vertices, T3d[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, int nTriangles, BS bsPolygons, int faceVertexMax, short colix, Lst<Short> colorList, Map<Short, Integer> htColixes, P3d offset) {
        this.outputShapeStart();
        this.outputDefChildFaceSet(null);
        this.outputGeometry(vertices, normals, colixes, indices, polygonColixes, nVertices, nPolygons, bsPolygons, faceVertexMax, colorList, htColixes, offset);
        this.outputFaceSetClose();
        this.outputAppearance(colix, false);
        this.outputShapeClose();
    }

    protected void outputGeometry(T3d[] vertices, T3d[] normals, short[] colixes, int[][] indices, short[] polygonColixes, int nVertices, int nPolygons, BS bsPolygons, int faceVertexMax, Lst<Short> colorList, Map<Short, Integer> htColixes, P3d offset) {
        if (polygonColixes == null) {
            this.output("  creaseAngle 0.5  \n");
        } else {
            this.output(" colorPerVertex FALSE\n");
        }
        this.output("coord Coordinate {\npoint [\n");
        this.outputVertices(vertices, nVertices, offset);
        this.output("   ]\n");
        this.output("  }\n");
        this.output("  coordIndex [\n");
        int[] map = new int[nVertices];
        this.getCoordinateMap(vertices, map, null);
        this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
        this.output("  ]\n");
        if (normals != null) {
            Lst<String> vNormals = new Lst<String>();
            map = this.getNormalMap(normals, nVertices, null, vNormals);
            this.output("  solid FALSE\n  normalPerVertex TRUE\n   normal Normal {\n  vector [\n");
            this.outputNormals(vNormals);
            this.output("   ]\n");
            this.output("  }\n");
            this.output("  normalIndex [\n");
            this.outputIndices(indices, map, nPolygons, bsPolygons, faceVertexMax);
            this.output("  ]\n");
        }
        map = null;
        if (colorList != null) {
            this.output("  color Color { color [\n");
            this.outputColors(colorList);
            this.output("  ] } \n");
            this.output("  colorIndex [\n");
            this.outputColorIndices(indices, nPolygons, bsPolygons, faceVertexMax, htColixes, colixes, polygonColixes);
            this.output("  ]\n");
        }
    }

    @Override
    protected void outputFace(int[] face, int[] map, int faceVertexMax) {
        this.output(map[face[0]] + " " + map[face[1]] + " " + map[face[2]] + " -1\n");
        if (faceVertexMax == 4 && face.length == 4) {
            this.output(map[face[0]] + " " + map[face[2]] + " " + map[face[3]] + " -1\n");
        }
    }

    protected void outputNormals(Lst<String> vNormals) {
        int n = vNormals.size();
        for (int i = 0; i < n; ++i) {
            this.output((String)vNormals.get(i));
        }
    }

    protected void outputColors(Lst<Short> colorList) {
        int nColors = colorList.size();
        for (int i = 0; i < nColors; ++i) {
            String color = this.rgbFractionalFromColix((Short)colorList.get(i));
            this.output(" ");
            this.output(color);
            this.output("\n");
        }
    }

    protected void outputColorIndices(int[][] indices, int nPolygons, BS bsPolygons, int faceVertexMax, Map<Short, Integer> htColixes, short[] colixes, short[] polygonColixes) {
        int i0;
        boolean isAll = bsPolygons == null;
        int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        while (i >= 0) {
            if (polygonColixes == null) {
                this.output(htColixes.get(colixes[indices[i][0]]) + " " + htColixes.get(colixes[indices[i][1]]) + " " + htColixes.get(colixes[indices[i][2]]) + " -1\n");
                if (faceVertexMax == 4 && indices[i].length == 4) {
                    this.output(htColixes.get(colixes[indices[i][0]]) + " " + htColixes.get(colixes[indices[i][2]]) + " " + htColixes.get(colixes[indices[i][3]]) + " -1\n");
                }
            } else {
                this.output(htColixes.get(polygonColixes[i]) + "\n");
            }
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
    }

    @Override
    protected void outputTriangle(T3d pt1, T3d pt2, T3d pt3, short colix) {
        this.output("Shape{geometry IndexedFaceSet{ ");
        this.outputTriangleGeometry(pt1, pt2, pt3, colix);
        this.output("}\n");
        this.outputAppearance(colix, false);
        this.output("}\n");
    }

    private void outputTriangleGeometry(T3d pt1, T3d pt2, T3d pt3, short colix) {
        if (this.oneFace == null) {
            this.oneFace = new int[][]{{0, 1, 2}};
            this.threeVertices = new P3d[]{this.tempP1, this.tempP2, this.tempP3};
        }
        this.threeVertices[0].setT(pt1);
        this.threeVertices[1].setT(pt2);
        this.threeVertices[2].setT(pt3);
        this.outputGeometry(this.threeVertices, null, null, this.oneFace, null, 3, 1, null, 3, null, null, null);
    }

    @Override
    protected void outputTextPixel(P3d pt, int argb) {
    }

    @Override
    void plotText(int x, int y, int z, short colix, String text, Font font3d) {
        this.pushMatrix();
        this.tempP3.set(x, y, this.fixScreenZ(z));
        this.tm.unTransformPoint(this.tempP3, this.tempP1);
        this.outputAttrPt("translation", this.tempP1);
        this.setFont(colix, text, font3d);
        this.outputChildStart();
        if (this.fontChild.charAt(0) == '_') {
            this.output("DEF " + this.fontChild + " Billboard{");
            this.outputAttr("axisOfRotation", 0.0, 0.0, 0.0);
            this.outputChildStart();
            this.pushMatrix();
            this.outputChildShapeStart();
            this.output("Text{fontStyle ");
            String fontstyle = this.getDef("F" + this.fontFace + this.fontStyle);
            if (fontstyle.charAt(0) == '_') {
                this.output("DEF " + fontstyle + " FontStyle{size " + this.fontSize + " family \"" + this.fontFace + "\" style \"" + this.fontStyle + "\"}");
            } else {
                this.output(fontstyle);
            }
            this.output(" string " + PT.esc(text) + "}");
            this.outputAppearance(colix, true);
            this.outputChildShapeClose();
            this.popMatrix();
            this.outputChildClose();
            this.output("}");
        } else {
            this.output(this.fontChild);
        }
        this.outputChildClose();
        this.popMatrix();
    }

    private void setFont(short colix, String text, Font font3d) {
        this.fontStyle = font3d.fontStyle.toUpperCase();
        this.fontFace = font3d.fontFace.toUpperCase();
        this.fontFace = this.fontFace.equals("MONOSPACED") ? "TYPEWRITER" : (this.fontFace.equals("SERIF") ? "SERIF" : "Arial");
        this.fontSize = font3d.fontSize * 0.015;
        this.fontChild = this.getDef("T" + colix + this.fontFace + this.fontStyle + this.fontSize + "_" + text);
    }

    protected String getDef(String key) {
        return this.useTable == null ? "_" : this.useTable.getDef(key);
    }
}

