/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public abstract class MOReader
extends BasisFunctionReader {
    public int shellCount = 0;
    public int gaussianCount = 0;
    public double[][] gaussians;
    protected String energyUnits = "";
    protected Lst<String> moTypes;
    private boolean getNBOs;
    private boolean getNBOCharges;
    protected boolean haveNboCharges;
    protected boolean haveNboOrbitals;
    protected boolean orbitalsRead;
    protected Map<String, Object> lastMoData;
    protected boolean allowNoOrbitals;
    protected boolean forceMOPAC;
    protected final int HEADER_GAMESS_UK_MO = 3;
    protected final int HEADER_GAMESS_OCCUPANCIES = 2;
    protected final int HEADER_GAMESS_ORIGINAL = 1;
    protected final int HEADER_NONE = 0;
    private boolean haveCoeffMap;
    private static final String P_LIST = "(PX)  (PY)  (PZ)";
    private static final String DS_LIST = "(D5)  (D2)  (D3)  (D4)  (D1)";
    private static final String DC_LIST = "(D1)  (D4)  (D6)  (D2)  (D3)  (D5)";
    private static final String FS_LIST = "(F1)  (F2)  (F3)  (F4)  (F5)  (F6)  (F7)";
    private static String FC_LIST = "(F1)  (F2)  (F10) (F4)  (F2)  (F3)  (F6)  (F9)  (F8)  (F5)";
    private int iMo0 = 1;

    @Override
    protected void initializeReader() throws Exception {
        this.line = "\nNBOs";
        this.getNBOs = this.filter != null && this.filterMO();
        this.line = "\nNBOCHARGES";
        this.getNBOCharges = this.filter != null && this.filterMO();
        this.checkAndRemoveFilterKey("NBOCHARGES");
        this.forceMOPAC = this.checkAndRemoveFilterKey("MOPAC");
    }

    protected boolean checkNboLine() throws Exception {
        if (this.getNBOs) {
            if (this.line.indexOf("(Occupancy)   Bond orbital/ Coefficients/ Hybrids") >= 0) {
                this.getNboTypes();
                return false;
            }
            if (this.line.indexOf("NBOs in the AO basis:") >= 0) {
                this.readMolecularOrbitals(0);
                return false;
            }
            if (this.line.indexOf(" SECOND ORDER PERTURBATION THEORY ANALYSIS") >= 0) {
                this.readSecondOrderData();
                return false;
            }
        }
        if (this.getNBOCharges && this.line.indexOf("Summary of Natural Population Analysis:") >= 0) {
            this.getNboCharges();
            return true;
        }
        return true;
    }

    private void getNboCharges() throws Exception {
        if (this.haveNboCharges) {
            return;
        }
        this.discardLinesUntilContains("----");
        this.discardLinesUntilContains("----");
        this.haveNboCharges = true;
        int ac = this.asc.ac;
        int i0 = this.asc.getLastAtomSetAtomIndex();
        Atom[] atoms = this.asc.atoms;
        for (int i = i0; i < ac; ++i) {
            double charge;
            while (atoms[i].elementNumber == 0) {
                ++i;
            }
            String[] tokens = PT.getTokens(this.rd());
            if (tokens == null || tokens.length < 3 || Double.isNaN(charge = this.parseDoubleStr(tokens[2]))) {
                Logger.info("Error reading NBO charges: " + this.line);
                return;
            }
            atoms[i].partialCharge = charge;
            if (!this.debugging) continue;
            Logger.debug("Atom " + i + " using NBOcharge: " + charge);
        }
        Logger.info("Using NBO charges for Model " + this.asc.atomSetCount);
    }

    protected void getNboTypes() throws Exception {
        this.moTypes = new Lst();
        this.iMo0 = (this.orbitals == null ? 0 : this.orbitals.size()) + 1;
        this.rd();
        this.rd();
        int n = 0;
        int pt = 0;
        while (this.line != null && (pt = this.line.indexOf(".")) >= 0 && pt < 10 && this.parseIntRange(this.line, 0, pt) == n + 1) {
            this.moTypes.add(n++, this.line.substring(pt + 1, Math.min(40, this.line.length())).trim());
            while (this.rd() != null && this.line.startsWith("       ")) {
            }
        }
        Logger.info(n + " natural bond AO basis functions found");
    }

    protected void readMolecularOrbitals(int headerType) throws Exception {
        if (this.ignoreMOs) {
            this.rd();
            return;
        }
        this.addSlaterBasis();
        this.dfCoefMaps = null;
        if (this.haveNboOrbitals) {
            this.orbitals = new Lst();
            this.alphaBeta = "";
        }
        this.haveNboOrbitals = this.getNBOs;
        this.orbitalsRead = true;
        Map<K, V>[] mos = null;
        Lst<type>[] data = null;
        String dCoeffLabels = "";
        String fCoeffLabels = "";
        String pCoeffLabels = "";
        int ptOffset = -1;
        int fieldSize = 0;
        int nThisLine = 0;
        this.rd();
        int moCount = 0;
        int nBlank = 0;
        boolean haveMOs = false;
        if (this.line.indexOf("---") >= 0) {
            this.rd();
        }
        while (this.rd() != null) {
            int ch;
            String str;
            String[] tokens = this.getTokens();
            if (this.debugging) {
                Logger.debug(tokens.length + " --- " + this.line);
            }
            if (this.line.indexOf("end") >= 0) break;
            if (this.line.indexOf(" ALPHA SET ") >= 0) {
                this.alphaBeta = "alpha";
                if (this.rd() == null) {
                    break;
                }
            } else if (this.line.indexOf(" BETA SET ") >= 0) {
                if (haveMOs) break;
                this.alphaBeta = "beta";
                if (this.rd() == null) break;
            }
            if ((str = this.line.toUpperCase()).length() == 0 || str.indexOf("--") >= 0 || str.indexOf(".....") >= 0 || str.indexOf("NBO BASIS") >= 0 || str.indexOf("CI EIGENVECTORS WILL BE LABELED") >= 0 || str.indexOf("LZ VALUE") >= 0 || str.indexOf("   THIS LOCALIZATION HAD") >= 0) {
                if (!this.haveCoeffMap) {
                    this.haveCoeffMap = true;
                    boolean isOK = true;
                    if (pCoeffLabels.length() > 0) {
                        isOK = this.getDFMap("P", pCoeffLabels, 1, P_LIST, 4);
                    }
                    if (dCoeffLabels.length() > 0) {
                        isOK = dCoeffLabels.indexOf("X") >= 0 ? this.getDFMap("DC", dCoeffLabels, 4, "DXX   DYY   DZZ   DXY   DXZ   DYZ", 2) : (dCoeffLabels.indexOf("(D6)") >= 0 ? this.getDFMap("DC", dCoeffLabels, 4, DC_LIST, 4) : this.getDFMap("DS", dCoeffLabels, 3, DS_LIST, 4));
                    }
                    if (fCoeffLabels.length() > 0) {
                        isOK = fCoeffLabels.indexOf("X") >= 0 ? this.getDFMap("FC", fCoeffLabels, 6, "XXX   YYY   ZZZ   XYY   XXY   XXZ   XZZ   YZZ   YYZ   XYZ", 2) : (fCoeffLabels.indexOf("(F10)") >= 0 ? this.getDFMap("FC", fCoeffLabels, 6, FC_LIST, 5) : this.getDFMap("FS", fCoeffLabels, 5, FS_LIST, 4));
                    }
                    if (!isOK) {
                        // empty if block
                    }
                }
                nBlank = str.length() == 0 ? ++nBlank : 0;
                if (nBlank == 2) break;
                if (str.indexOf("LZ VALUE") >= 0) {
                    this.discardLinesUntilBlank();
                }
                for (int iMo = 0; iMo < nThisLine; ++iMo) {
                    double[] coefs = new double[data[iMo].size()];
                    for (int iCoeff = 0; iCoeff < coefs.length; ++iCoeff) {
                        coefs[iCoeff] = this.parseDoubleStr((String)data[iMo].get(iCoeff));
                    }
                    haveMOs = true;
                    this.addCoef((Map<String, Object>)mos[iMo], coefs, null, Double.NaN, Double.NaN, moCount++);
                }
                nThisLine = 0;
                if (this.line.length() != 0) break;
                continue;
            }
            nBlank = 0;
            if (nThisLine == 0) {
                nThisLine = tokens.length;
                if (tokens[0].equals("AO")) {
                    --nThisLine;
                    ptOffset = 16;
                    fieldSize = 8;
                }
                if (mos == null || nThisLine > mos.length) {
                    mos = AU.createArrayOfHashtable(nThisLine);
                    data = AU.createArrayOfArrayList(nThisLine);
                }
                for (int i = 0; i < nThisLine; ++i) {
                    mos[i] = new Hashtable();
                    data[i] = new Lst();
                }
                this.getMOHeader(headerType, tokens, mos, nThisLine);
                continue;
            }
            int nSkip = tokens.length - nThisLine;
            String type = tokens[nSkip - 1];
            if (type.charAt(0) == '(') {
                ch = type.charAt(1);
                if (!this.haveCoeffMap) {
                    switch (ch) {
                        case 112: {
                            pCoeffLabels = pCoeffLabels + " " + type.toUpperCase();
                            break;
                        }
                        case 100: {
                            dCoeffLabels = dCoeffLabels + " " + MOReader.canonicalizeQuantumSubshellTag(type.toUpperCase());
                            break;
                        }
                        case 102: {
                            fCoeffLabels = fCoeffLabels + " " + MOReader.canonicalizeQuantumSubshellTag(type.toUpperCase());
                            break;
                        }
                    }
                }
            } else {
                int nChar = type.length();
                int n = nChar < 4 ? 83 : (nChar == 4 ? 71 : (ch = nChar == 5 ? 72 : 63));
                if (!this.haveCoeffMap && nChar == 3) {
                    fCoeffLabels = fCoeffLabels + " " + MOReader.canonicalizeQuantumSubshellTag(type.toUpperCase());
                } else if (!this.haveCoeffMap && nChar == 2) {
                    dCoeffLabels = dCoeffLabels + " " + MOReader.canonicalizeQuantumSubshellTag(type.toUpperCase());
                }
            }
            if (QS.isQuantumBasisSupported((char)ch)) {
                if (ptOffset < 0) {
                    for (int i = 0; i < nThisLine; ++i) {
                        data[i].addLast(tokens[i + nSkip]);
                    }
                } else {
                    int pt = ptOffset;
                    int i = 0;
                    while (i < nThisLine) {
                        data[i].addLast(this.line.substring(pt, pt + fieldSize).trim());
                        ++i;
                        pt += fieldSize;
                    }
                }
            }
            this.line = "";
        }
        this.energyUnits = "a.u.";
        this.setMOData(!this.alphaBeta.equals("alpha"));
        this.haveCoeffMap = false;
        this.dfCoefMaps = null;
    }

    protected void addSlaterBasis() {
    }

    public void addCoef(Map<String, Object> mo, double[] coefs, String type, double energy, double occ, int moCount) {
        mo.put("coefficients", coefs);
        if (this.moTypes != null) {
            type = (String)this.moTypes.get(moCount % this.moTypes.size());
            occ = type.indexOf("*") >= 0 ? 0 : 2;
        } else if (this.alphaBeta.length() > 0) {
            type = this.alphaBeta;
        }
        if (type != null) {
            mo.put("type", type);
        }
        if (!Double.isNaN(energy)) {
            mo.put("energy", energy);
        }
        if (!Double.isNaN(occ)) {
            mo.put("occupancy", occ);
        }
        this.setMO(mo);
    }

    protected void getMOHeader(int headerType, String[] tokens, Map<String, Object>[] mos, int nThisLine) throws Exception {
        int i;
        this.rd();
        switch (headerType) {
            default: {
                return;
            }
            case 3: {
                for (int i2 = 0; i2 < nThisLine; ++i2) {
                    mos[i2].put("energy", Double.valueOf(tokens[i2]));
                }
                this.readLines(5);
                return;
            }
            case 1: {
                tokens = this.getTokens();
                if (tokens.length == 0) {
                    tokens = PT.getTokens(this.rd());
                }
                for (i = 0; i < nThisLine; ++i) {
                    mos[i].put("energy", Double.valueOf(tokens[i]));
                }
                this.rd();
                break;
            }
            case 2: {
                boolean haveSymmetry = this.line.length() > 0 || this.rd() != null;
                tokens = this.getTokens();
                for (int i3 = 0; i3 < nThisLine; ++i3) {
                    mos[i3].put("occupancy", tokens[i3].charAt(0) == '-' ? 2.0 : this.parseDoubleStr(tokens[i3]));
                }
                this.rd();
                if (haveSymmetry) break;
                return;
            }
        }
        if (this.line.length() > 0) {
            tokens = this.getTokens();
            for (i = 0; i < nThisLine; ++i) {
                mos[i].put("symmetry", tokens[i]);
            }
        }
    }

    protected void addMOData(int nColumns, Lst<String>[] data, Map<String, Object>[] mos) {
        for (int i = 0; i < nColumns; ++i) {
            double[] coefs = new double[data[i].size()];
            int j = coefs.length;
            while (--j >= 0) {
                coefs[j] = this.parseDoubleStr((String)data[i].get(j));
            }
            mos[i].put("coefficients", coefs);
            this.setMO(mos[i]);
        }
    }

    public void setMOData(boolean clearOrbitals) {
        if (!this.allowNoOrbitals && this.orbitals.size() == 0) {
            return;
        }
        if (this.shells != null && this.gaussians != null) {
            this.moData.put("calculationType", this.calculationType);
            this.moData.put("energyUnits", this.energyUnits);
            this.moData.put("shells", this.shells);
            this.moData.put("gaussians", this.gaussians);
            this.moData.put("mos", this.orbitals);
            this.lastMoData = this.moData;
            this.finalizeMOData(this.lastMoData);
        }
        if (clearOrbitals) {
            this.clearOrbitals();
        }
    }

    private void readSecondOrderData() throws Exception {
        this.readLines(5);
        if (this.lastMoData == null || this.moTypes == null) {
            return;
        }
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        int i = this.moTypes.size();
        while (--i >= 0) {
            ht.put(PT.rep(((String)this.moTypes.get(i)).substring(10), " ", ""), i + this.iMo0);
        }
        Lst<String[]> strSecondOrderData = new Lst<String[]>();
        while (this.rd() != null && this.line.indexOf("NBO") < 0) {
            if (this.line.length() < 5 || this.line.charAt(4) != '.') continue;
            strSecondOrderData.addLast(new String[]{PT.rep(this.line.substring(5, 27).trim(), " ", ""), PT.rep(this.line.substring(32, 54).trim(), " ", ""), this.line.substring(55, 62).trim(), this.line.substring(71).trim()});
        }
        double[][] secondOrderData = new double[strSecondOrderData.size()][4];
        this.lastMoData.put("secondOrderData", secondOrderData);
        this.lastMoData = null;
        int i2 = strSecondOrderData.size();
        while (--i2 >= 0) {
            String[] a = (String[])strSecondOrderData.get(i2);
            Integer IMO = (Integer)ht.get(a[0]);
            if (IMO != null) {
                secondOrderData[i2][0] = IMO.intValue();
            }
            if ((IMO = (Integer)ht.get(a[1])) != null) {
                secondOrderData[i2][1] = IMO.intValue();
            }
            secondOrderData[i2][2] = this.parseDoubleStr(a[2]);
            secondOrderData[i2][3] = this.parseDoubleStr(a[3]);
        }
    }
}

