/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDUtil;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDReference;
import org.iupac.fairdata.core.IFDRepresentation;

public abstract class IFDRepresentableObject<T extends IFDRepresentation>
extends IFDObject<T> {
    protected final Map<String, IFDRepresentation> map = new LinkedHashMap<String, IFDRepresentation>();

    protected abstract IFDRepresentation newRepresentation(IFDReference var1, Object var2, long var3, String var5, String var6);

    public IFDRepresentableObject(String label, String type) {
        super(label, type);
    }

    public IFDRepresentation findOrAddRepresentation(String resourceID, String originPath, String rootPath, String localName, Object data, String type, String mediaType) {
        String key = localName != null ? localName : (data instanceof byte[] ? new String((byte[])data) : data.toString());
        IFDRepresentation rep = this.getRepresentation(resourceID, key);
        if (rep == null) {
            rep = this.newRepresentation(localName == null ? null : new IFDReference(resourceID, originPath, rootPath, localName), data, 0L, type, mediaType);
            this.add(rep);
            this.map.put(resourceID + "::" + key, rep);
            if (localName != null && data != null) {
                this.map.put(resourceID + "::" + localName, rep);
            }
        }
        return rep;
    }

    public IFDRepresentation getRepresentation(String resourceID, String key) {
        return this.map.get(resourceID + "::" + key);
    }

    public void removeRepresentationFor(String localName) {
        if (localName == null) {
            return;
        }
        int i = this.size();
        while (--i >= 0) {
            if (!localName.equals(((IFDRepresentation)this.get(i)).getRef().getLocalName())) continue;
            this.remove(i);
            break;
        }
    }

    @Override
    protected void serializeTop(IFDSerializerI serializer) {
        super.serializeTop(serializer);
    }

    @Override
    protected void serializeProps(IFDSerializerI serializer) {
        super.serializeProps(serializer);
    }

    @Override
    protected void serializeList(IFDSerializerI serializer) {
        if (this.size() > 0) {
            serializer.addList("representations", this);
        }
    }

    public boolean allowEmpty() {
        return false;
    }

    public void setRepresentationDOIandURLs(Map<String, Map<String, Object>> htDOIURL) {
        int i = this.size();
        while (--i >= 0) {
            String key;
            Map<String, Object> ref;
            Object path;
            IFDRepresentation c = (IFDRepresentation)this.get(i);
            IFDReference r = c.getRef();
            if (r == null || (path = r.getOriginPath()) == null || (ref = htDOIURL.get(key = IFDUtil.getShortFileName(path.toString()))) == null) continue;
            Object o = ref.get("url");
            if (o != null) {
                r.setURL(o.toString());
            }
            if ((o = ref.get("doi")) == null) continue;
            r.setDOI(o.toString());
        }
    }
}

