/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.core.IFDAssociationCollection;
import org.iupac.fairdata.core.IFDCollection;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDRepresentableObject;

public class IFDCollectionSet
extends IFDCollection<IFDCollection<IFDObject<?>>> {
    private static String propertyPrefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_COLLECTIONSET_FLAG);
    private boolean byID = true;

    @Override
    protected String getIFDPropertyPrefix() {
        return propertyPrefix;
    }

    public IFDCollectionSet(String label) {
        this(label, null);
    }

    public IFDCollectionSet(String label, String type) {
        super(label, type);
        this.setProperties(propertyPrefix, null);
    }

    public void setById(boolean b) {
        this.byID = b;
    }

    protected void finalizeCollections(Map<String, Map<String, Object>> htURLReferences) {
        for (int ic = 0; ic < this.size(); ++ic) {
            IFDRepresentableObject o;
            IFDCollection c = (IFDCollection)this.get(ic);
            if (c == null || c.size() == 0) continue;
            if (c instanceof IFDAssociationCollection) {
                ((IFDAssociationCollection)c).removeOrphanedAssociations();
                continue;
            }
            int i = c.size();
            while (--i >= 0) {
                o = (IFDRepresentableObject)c.get(i);
                if (o.size() != 0 || o.allowEmpty()) continue;
                System.out.println("IFDC removing " + i + " " + o + " from " + c);
                c.remove(i);
                o.setValid(false);
            }
            i = c.size();
            while (--i >= 0) {
                o = (IFDRepresentableObject)c.get(i);
                o.setIndex(i);
                o.setParentCollection(c);
                if (htURLReferences == null) continue;
                o.setRepresentationDOIandURLs(htURLReferences);
            }
        }
    }

    @Override
    public void serializeTop(IFDSerializerI serializer) {
        super.serializeTop(serializer);
        if (this.byID) {
            serializer.addAttrBoolean("byID", true);
        }
    }

    @Override
    public void serializeList(IFDSerializerI serializer) {
        IFDCollectionSet list = new IFDCollectionSet(null);
        for (int i = 0; i < this.size(); ++i) {
            IFDCollection c = (IFDCollection)this.get(i);
            if (c == null || c.size() == 0) continue;
            list.add(c);
        }
        if (list.size() > 0) {
            serializer.addCollection(this.byID ? "itemsByID" : "items", list, this.byID);
        }
    }

    public void getContents(Map<String, Object> map) {
        ArrayList<TreeMap<String, Object>> list = new ArrayList<TreeMap<String, Object>>();
        for (int i = 0; i < this.size(); ++i) {
            IFDCollection c = (IFDCollection)this.get(i);
            if (c.size() == 0) continue;
            TreeMap<String, Object> m = new TreeMap<String, Object>();
            m.put("id", c.getID());
            IFDCollectionSet.getTypeAndExtends(c.getClass(), m);
            m.put("count", c.size());
            list.add(m);
        }
        if (list.size() > 0) {
            map.put("collections", list);
        }
    }
}

