/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iupac.fairdata.api.IFDSerializerI;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.common.IFDException;
import org.iupac.fairdata.common.IFDUtil;
import org.iupac.fairdata.core.IFDObject;
import org.iupac.fairdata.core.IFDRepresentableObject;
import org.iupac.fairdata.core.IFDRepresentation;

public abstract class IFDCollection<T extends IFDObject<?>>
extends IFDObject<T> {
    private static String propertyPrefix = IFDConst.concat(IFDConst.IFD_PROPERTY_FLAG, IFDConst.IFD_COLLECTION_FLAG);
    private boolean isSorted;
    private boolean hasRepresentations = false;
    protected Map<String, T> map = new HashMap<String, T>();
    private boolean haveCommonClass;
    private static Comparator<IFDObject<?>> sorter;

    @Override
    protected String getIFDPropertyPrefix() {
        return propertyPrefix;
    }

    protected IFDCollection(String label, String type) {
        super(label, type);
    }

    @SafeVarargs
    public IFDCollection(String label, String type, T ... initialSet) throws IFDException {
        super(label, type, initialSet.length, initialSet);
    }

    public List<String> getIDList() {
        ArrayList<String> list = new ArrayList<String>();
        for (IFDObject o : this) {
            String id = o.getID();
            list.add(id == null ? "" + o.getIndex() : id);
        }
        return list;
    }

    public List<Integer> getIndexList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (IFDObject c : this) {
            list.add(c.getIndex());
        }
        return list;
    }

    @Override
    public boolean add(T t) {
        if (t == null || this.contains(t)) {
            return false;
        }
        if (!this.hasRepresentations && t instanceof IFDRepresentableObject) {
            this.hasRepresentations = true;
        }
        return super.add(t);
    }

    public IFDRepresentation getRepresentation(String resourceID, String localizedPath) {
        if (!this.hasRepresentations) {
            return null;
        }
        for (IFDObject c : this) {
            IFDRepresentation r;
            if (!(c instanceof IFDRepresentableObject) || (r = ((IFDRepresentableObject)c).getRepresentation(resourceID, localizedPath)) == null) continue;
            return r;
        }
        return null;
    }

    public T getPath(String path) {
        return (T)((IFDObject)this.map.get(path));
    }

    public T addWithPath(String path, T sd) {
        if (path != null && this.map.get(path) != null) {
            return null;
        }
        this.map.put(path, sd);
        return (T)(this.add(sd) ? sd : null);
    }

    public void replaceObject(T data, T newData) {
        this.remove(data);
        this.add(newData);
    }

    public T getObjectByLabel(String label) {
        int i = this.size();
        while (--i >= 0) {
            IFDObject o = (IFDObject)this.get(i);
            if (!label.equals(o.getLabel())) continue;
            return (T)o;
        }
        return null;
    }

    @Override
    protected void serializeTop(IFDSerializerI serializer) {
        this.haveCommonClass = false;
        super.serializeTop(serializer);
        Class<?> commonClass = null;
        int i = this.size();
        while (--i >= 0) {
            Class<?> c = ((IFDObject)this.get(i)).getClass();
            if (commonClass == null) {
                commonClass = c;
            }
            if (c == commonClass) continue;
            commonClass = null;
            break;
        }
        if (commonClass != null) {
            this.haveCommonClass = true;
            IFDCollection.serializeClass(serializer, commonClass, "itemType");
            i = this.size();
            while (--i >= 0) {
                ((IFDObject)this.get(i)).setSerializeType(false);
            }
        }
    }

    @Override
    protected void serializeList(IFDSerializerI serializer) {
        if (this.size() > 0) {
            boolean byid = serializer.isByID();
            int i = this.size();
            while (--i >= 0 && ((IFDObject)this.get(i)).getID() != null) {
            }
            if (i >= 0) {
                i = this.size();
                while (--i >= 0) {
                    ((IFDObject)this.get(i)).setID("" + (i + 1));
                }
            }
            if (!this.isSorted) {
                this.sortList();
            }
            serializer.addCollection(byid ? "itemsByID" : "items", this, byid);
        }
        if (this.haveCommonClass) {
            int i = this.size();
            while (--i >= 0) {
                ((IFDObject)this.get(i)).setSerializeType(true);
            }
        }
    }

    public T getObjectByID(String value) {
        int i = this.size();
        while (--i >= 0) {
            IFDObject v = (IFDObject)this.get(i);
            if (!value.equals(v.getID())) continue;
            return (T)v;
        }
        return null;
    }

    public void removeInvalidData() {
        int i = this.size();
        while (--i >= 0) {
            IFDObject o = (IFDObject)this.get(i);
            if (o.isValid()) continue;
            this.remove(i);
        }
    }

    public void setSorted() {
        this.isSorted = true;
    }

    protected void sortList() {
        int i = this.size();
        while (--i >= 0) {
            IFDObject o = (IFDObject)this.get(i);
            if (o.getSortKey() != null) continue;
            o.setSortKey(IFDUtil.getNumericalSortKey(o.getID()));
        }
        this.sort(this.getSorter());
    }

    private Comparator<IFDObject<?>> getSorter() {
        if (sorter == null) {
            sorter = new Comparator<IFDObject<?>>(){

                @Override
                public int compare(IFDObject<?> o1, IFDObject<?> o2) {
                    return o1.getSortKey().compareTo(o2.getSortKey());
                }
            };
        }
        return sorter;
    }
}

