/*
 * Decompiled with CFR 0.152.
 */
package org.iupac.fairdata.contrib.fairspec;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.util.Rdr;
import org.iupac.fairdata.common.IFDConst;
import org.iupac.fairdata.contrib.fairspec.FAIRSpecExtractorHelper;
import org.iupac.fairdata.util.JSJSONParser;

public class FAIRSpecUtilities {
    public static final String DATA_KEY = "DATA";
    public static final String INDEX_COL = "INDEX_COL";
    private static String logFile;
    public static OutputStream logStream;
    private static final String escapable = "\\\\\tt\rr\nn\"\"";
    private static byte[] IFDTAG;

    public static byte[] getLimitedStreamBytes(InputStream is, long n, OutputStream out, boolean andCloseInput, boolean andCloseOutput) throws IOException {
        boolean toOut = out != null;
        int buflen = n > 0L && n < 1024L ? (int)n : 1024;
        byte[] buf = new byte[buflen];
        byte[] bytes = out == null ? new byte[n < 0L ? 4096 : (int)n] : null;
        int len = 0;
        int totalLen = 0;
        if (n < 0L) {
            n = Integer.MAX_VALUE;
        }
        while ((long)totalLen < n && (len = is.read(buf, 0, buflen)) > 0) {
            totalLen += len;
            if (toOut) {
                out.write(buf, 0, len);
                continue;
            }
            if (totalLen > bytes.length) {
                bytes = Arrays.copyOf(bytes, totalLen * 2);
            }
            System.arraycopy(buf, 0, bytes, totalLen - len, len);
            if (n == Integer.MAX_VALUE || totalLen + buflen <= bytes.length) continue;
            buflen = bytes.length - totalLen;
        }
        if (andCloseInput) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (toOut) {
            if (andCloseOutput) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
        if (totalLen == bytes.length) {
            return bytes;
        }
        buf = new byte[totalLen];
        System.arraycopy(bytes, 0, buf, 0, totalLen);
        return buf;
    }

    public static String getFileStringData(File f) throws MalformedURLException, IOException {
        return FAIRSpecUtilities.getURLContentsAsString(f.toURI().toString());
    }

    public static byte[] getURLBytes(String url) throws MalformedURLException, IOException {
        return FAIRSpecUtilities.getLimitedStreamBytes(new URL(url).openStream(), -1L, null, true, true);
    }

    public static String getURLContentsAsString(String url) throws MalformedURLException, IOException {
        return new String(FAIRSpecUtilities.getURLBytes(url));
    }

    public static void writeBytesToFile(byte[] bytes, File fileTarget) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileTarget);
        fos.write(bytes);
        fos.close();
    }

    public static void setLogging(String fname) {
        FAIRSpecUtilities.setLogging(fname, false);
    }

    public static void setLogging(String fname, boolean refresh) {
        try {
            if (fname == null || refresh) {
                if (logStream != null) {
                    logStream.close();
                    logStream = null;
                }
                if (!refresh) {
                    return;
                }
            }
            if (!refresh) {
                logFile = fname;
            }
            logStream = new FileOutputStream(logFile, refresh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getResource(Class<?> c, String fileName) throws FileNotFoundException, IOException {
        return new String(FAIRSpecUtilities.getLimitedStreamBytes(c.getResourceAsStream(fileName), -1L, null, true, true));
    }

    public static byte[] getResourceBytes(Class<?> c, String fileName) throws FileNotFoundException, IOException {
        return FAIRSpecUtilities.getLimitedStreamBytes(c.getResourceAsStream(fileName), -1L, null, true, true);
    }

    public static Map<String, Object> getJSONResource(Class<?> c, String fileName) throws FileNotFoundException, IOException {
        return new JSJSONParser().parseMap(FAIRSpecUtilities.getResource(c, fileName), false);
    }

    public static Map<String, Object> getJSONURL(String url) throws MalformedURLException, IOException {
        return new JSJSONParser().parseMap(FAIRSpecUtilities.getURLContentsAsString(url), false);
    }

    public static long zip(String fileName, int prefixLength, List<Object> products) throws IOException {
        if (prefixLength < 0) {
            prefixLength = 0;
        }
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(fileName));
        for (int i = 0; i < products.size(); ++i) {
            String name;
            File f;
            Object o = products.get(i);
            if (o instanceof File) {
                f = (File)o;
                name = f.getName();
                if (!f.exists()) continue;
                FAIRSpecUtilities.zipAddEntry(zos, name, new FileInputStream(f), f.length());
                continue;
            }
            if (o instanceof byte[]) {
                byte[] bytes = (byte[])o;
                name = (String)products.get(++i);
                FAIRSpecUtilities.zipAddEntry(zos, name, new ByteArrayInputStream(bytes), bytes.length);
                continue;
            }
            f = new File(o.toString());
            FAIRSpecUtilities.copyFiles(zos, f, new File(fileName).getParentFile(), prefixLength);
        }
        zos.close();
        return new File(fileName).length();
    }

    private static void copyFiles(ZipOutputStream zos, File dirOrFile, File target, int prefixLength) throws IOException {
        File[] fileArray;
        if (dirOrFile.isDirectory()) {
            fileArray = dirOrFile.listFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = dirOrFile;
        }
        File[] files = fileArray;
        if (files == null) {
            return;
        }
        if (dirOrFile.isDirectory()) {
            FAIRSpecUtilities.zipAddFile(zos, dirOrFile, prefixLength);
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f == null) continue;
            if (f.isDirectory()) {
                FAIRSpecUtilities.copyFiles(zos, f, new File(target, f.getName()), prefixLength);
                continue;
            }
            if (f.length() <= 0L) continue;
            FAIRSpecUtilities.zipAddFile(zos, f, prefixLength);
        }
    }

    private static void zipAddFile(ZipOutputStream zos, File entryFile, int prefixLength) throws IOException {
        boolean isDir = entryFile.isDirectory();
        String name = entryFile.getPath().substring(prefixLength).replace('\\', '/') + (isDir ? "/" : "");
        if (entryFile.isDirectory()) {
            FAIRSpecUtilities.zipAddEntry(zos, name, null, 0L);
        } else {
            FAIRSpecUtilities.zipAddEntry(zos, name, new FileInputStream(entryFile), entryFile.length());
        }
    }

    private static void zipAddEntry(ZipOutputStream zos, String name, InputStream is, long len) throws IOException {
        ZipEntry e = new ZipEntry(name);
        e.setSize(len);
        zos.putNextEntry(e);
        if (is != null) {
            FAIRSpecUtilities.getLimitedStreamBytes(is, -1L, zos, true, false);
        }
        zos.closeEntry();
    }

    public static String mediaTypeFromFileName(String fname) {
        if (fname == null) {
            return null;
        }
        int pt = Math.max(fname.lastIndexOf(47), fname.lastIndexOf(46));
        String t = IFDConst.getMediaTypesForExtension(fname.substring(pt + 1));
        return t == null ? "?" : t;
    }

    public static String esc(String str) {
        int i;
        if (str == null || str.length() == 0) {
            return "\"\"";
        }
        boolean haveEscape = false;
        for (i = 0; i < escapable.length(); i += 2) {
            if (str.indexOf(escapable.charAt(i)) < 0) continue;
            haveEscape = true;
            break;
        }
        if (haveEscape) {
            while (i < escapable.length()) {
                int pt = -1;
                char ch = escapable.charAt(i++);
                char ch2 = escapable.charAt(i++);
                StringBuffer sb = new StringBuffer();
                int pt0 = 0;
                while ((pt = str.indexOf(ch, pt + 1)) >= 0) {
                    sb.append(str.substring(pt0, pt)).append('\\').append(ch2);
                    pt0 = pt + 1;
                }
                sb.append(str.substring(pt0, str.length()));
                str = sb.toString();
            }
        }
        return "\"" + FAIRSpecUtilities.escUnicode(str) + "\"";
    }

    public static String escUnicode(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) <= '\u007f') continue;
            String s = "0000" + Integer.toHexString(str.charAt(i));
            str = str.substring(0, i) + "\\u" + s.substring(s.length() - 4) + str.substring(i + 1);
        }
        return str;
    }

    public static String rep(String str, String strFrom, String strTo) {
        if (str == null || strFrom.length() == 0 || str.indexOf(strFrom) < 0) {
            return str;
        }
        boolean isOnce = strTo.indexOf(strFrom) >= 0;
        do {
            str = str.replace(strFrom, strTo);
        } while (!isOnce && str.indexOf(strFrom) >= 0);
        return str;
    }

    public static String replaceStrings(String s, List<String> list, List<String> newList) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String name = list.get(i);
            String newName = newList.get(i);
            if (newName.equals(name)) continue;
            s = FAIRSpecUtilities.rep(s, name, newName);
        }
        return s;
    }

    public static String getQuotedOrUnquotedAttribute(String line, String key) {
        if (line == null || key == null) {
            return null;
        }
        int pt = line.toLowerCase().indexOf(key.toLowerCase() + "=");
        if (pt < 0 || (pt = pt + key.length() + 1) >= line.length()) {
            return "";
        }
        int c = line.charAt(pt);
        switch (c) {
            case 34: 
            case 39: {
                ++pt;
                break;
            }
            default: {
                c = 32;
                line = line + " ";
            }
        }
        int pt1 = line.indexOf(c, pt);
        return pt1 < 0 ? null : line.substring(pt, pt1);
    }

    public static void main(String[] args) {
        SpreadsheetReader.test();
    }

    public static void refreshLog() {
        if (logStream != null) {
            FAIRSpecUtilities.setLogging(null, true);
        }
    }

    public static String[] split(String text, String run) {
        if (text.length() == 0) {
            return new String[0];
        }
        int n = 1;
        int i = text.indexOf(run);
        int runLen = run.length();
        if (i < 0 || runLen == 0) {
            String[] lines = new String[]{text};
            return lines;
        }
        int len = text.length() - runLen;
        while (i >= 0 && i < len) {
            i = text.indexOf(run, i + runLen);
            ++n;
        }
        String[] lines = new String[n];
        i = 0;
        int ipt = 0;
        int pt = 0;
        while ((ipt = text.indexOf(run, i)) >= 0 && pt + 1 < n) {
            lines[pt++] = text.substring(i, ipt);
            i = ipt + runLen;
        }
        if (text.indexOf(run, len) != len) {
            len += runLen;
        }
        lines[pt] = text.substring(i, len);
        return lines;
    }

    public static String getQuotedAttribute(String info, String name) {
        int i = info.indexOf(name + "=\"");
        if (i < 0) {
            return null;
        }
        int pt = i += name.length() + 2;
        int len = info.length();
        while (++i < len && info.charAt(i) != '\"') {
            if (info.charAt(i) != '\\') continue;
            ++i;
        }
        return info.substring(pt, i);
    }

    public static boolean isIFDParameterFile(String originPath, byte[] bytes) {
        if (bytes.length < 6) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (bytes[i] == IFDTAG[i]) continue;
            return false;
        }
        return true;
    }

    public static List<String[]> getIFDPropertyMap(String data) {
        String[] lines = data.split("\n");
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < lines.length; ++i) {
            int pt;
            String s = lines[i];
            if (!s.startsWith("##$IFD") || (pt = s.indexOf("=")) <= 0) continue;
            list.add(new String[]{s.substring(3, pt).trim(), s.substring(pt + 1).trim()});
        }
        return list;
    }

    public static byte[] getBytesAndClose(InputStream is) throws IOException {
        return (byte[])Rdr.getStreamAsBytes(new BufferedInputStream(is), null);
    }

    public static String cleanFileName(String s) {
        return s.replaceAll("[\\/?&:+=]", "_");
    }

    public static int putToFile(byte[] bytes, File f) {
        if (bytes == null || bytes.length == 0) {
            return 0;
        }
        try {
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(bytes);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return bytes.length;
    }

    public static boolean isOneOf(String key, String semiList) {
        if (semiList.length() == 0) {
            return false;
        }
        if (semiList.charAt(0) != ';') {
            semiList = ";" + semiList + ";";
        }
        return key.indexOf(";") < 0 && semiList.indexOf(';' + key + ';') >= 0;
    }

    public static String loadFileMetadata(String param, Map<String, Object> map, String fileName) {
        String indexKey = null;
        try {
            Object[][] data;
            int icol;
            indexKey = (String)map.get(FAIRSpecExtractorHelper.FAIRSPEC_EXTRACTOR_METADATA_KEY);
            int pt = fileName.indexOf("#");
            String sheetRef = null;
            File metadataFile = null;
            if (pt >= 0) {
                sheetRef = fileName.substring(pt + 1);
                fileName = fileName.substring(0, pt);
            }
            if ((icol = SpreadsheetReader.setMapData(map, data = SpreadsheetReader.getCellData(new FileInputStream(metadataFile = new File(fileName)), sheetRef, "", true), indexKey)) < 1) {
                return "METADATA file " + fileName + " did not have a column titled " + indexKey;
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (!map.containsKey(DATA_KEY)) {
            map.put(DATA_KEY, null);
        }
        return null;
    }

    public static boolean isZip(String name) {
        return name.endsWith(".zip") || name.endsWith(".tgz") || name.endsWith(".tar") || name.endsWith(".rar") || name.endsWith("tar.gz");
    }

    public static void showUrl(String url) throws Exception {
        Class<?> c = Class.forName("java.awt.Desktop");
        Method getDesktop = c.getMethod("getDesktop", new Class[0]);
        Object deskTop = getDesktop.invoke(null, new Object[0]);
        Method browse = c.getMethod("browse", URI.class);
        Object[] arguments = new Object[]{new URI(url)};
        browse.invoke(deskTop, arguments);
    }

    public static String toJSON(StringBuffer sb, String[] list, String rootPath, boolean withBrackets) {
        boolean returnString;
        boolean bl = returnString = sb == null;
        if (returnString) {
            sb = new StringBuffer();
        }
        if (withBrackets) {
            sb.append("[");
        }
        String sep = "";
        for (int i = 0; i < list.length; ++i) {
            String fname = list[i];
            sb.append(sep + "\"" + (rootPath == null ? "" : rootPath + "/") + fname + "\"");
            sep = ",\n";
        }
        sb.append("\n");
        if (withBrackets) {
            sb.append("]");
        }
        return returnString ? sb.toString() : null;
    }

    static {
        IFDTAG = new byte[]{35, 35, 36, 73, 70, 68};
    }

    public static class SpreadsheetReader {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object[][] getCellData(InputStream is, String sheetName, String emptyValue, boolean closeStream) throws IOException {
            ZipInputStream zis = null;
            Map<Integer, String> sparseData = null;
            int[] retMaxRC = new int[2];
            try {
                ZipEntry entry;
                zis = new ZipInputStream(is);
                String xlsSheetXML = null;
                String xlsSharedXML = null;
                String odsXML = null;
                String xlsSheetName = sheetName;
                if (xlsSheetName == null) {
                    xlsSheetName = "sheet1";
                }
                xlsSheetName = xlsSheetName + ".xml";
                while ((entry = zis.getNextEntry()) != null && (xlsSheetXML == null || xlsSharedXML == null)) {
                    String name = entry.getName();
                    if (name.equals("content.xml")) {
                        odsXML = new String(FAIRSpecUtilities.getLimitedStreamBytes(zis, entry.getSize(), null, false, true), "UTF-8");
                        break;
                    }
                    if (name.endsWith(xlsSheetName)) {
                        xlsSheetXML = new String(FAIRSpecUtilities.getLimitedStreamBytes(zis, entry.getSize(), null, false, true), "UTF-8");
                        continue;
                    }
                    if (!name.endsWith("sharedStrings.xml")) continue;
                    xlsSharedXML = new String(FAIRSpecUtilities.getLimitedStreamBytes(zis, entry.getSize(), null, false, true), "UTF-8");
                }
                if (xlsSheetXML == null && odsXML == null) {
                    throw new IOException("SheetReader - no sheet named " + sheetName + " found");
                }
                sparseData = odsXML != null ? SpreadsheetReader.processODSData(odsXML, sheetName, retMaxRC) : SpreadsheetReader.processXLSXData(xlsSheetXML, xlsSharedXML, retMaxRC);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (zis != null && closeStream) {
                    zis.close();
                }
            }
            return SpreadsheetReader.sparseDataToObjectArray(sparseData, retMaxRC[0], retMaxRC[1], emptyValue);
        }

        private static Object[][] sparseDataToObjectArray(Map<Integer, String> rrrcccData, int nRows, int nCols, String emptyValue) {
            Object[][] cells = new Object[nRows][nCols];
            for (int r = 0; r < nRows; ++r) {
                for (int c = 0; c < nCols; ++c) {
                    String val = rrrcccData.get(SpreadsheetReader.encodeRC(r + 1, c + 1));
                    if (val == null || "".equals(val)) {
                        val = emptyValue;
                    }
                    cells[r][c] = val;
                }
            }
            return cells;
        }

        private static Map<Integer, String> processODSData(String odsXML, String sheetName, int[] retMaxRC) {
            if (sheetName == null) {
                sheetName = "Sheet 1";
            }
            sheetName = sheetName.replace(' ', '_');
            LinkedHashMap<Integer, String> sparseData = new LinkedHashMap<Integer, String>();
            String[] sheets = FAIRSpecUtilities.split(odsXML, "<table:table ");
            for (int i = 1; i < sheets.length; ++i) {
                String xml = sheets[i];
                if (!sheetName.equals(FAIRSpecUtilities.getQuotedAttribute(xml, "table:name"))) continue;
                String[] rows = FAIRSpecUtilities.split(xml, "<table:table-row ");
                retMaxRC[0] = rows.length;
                for (int r = 1; r < rows.length; ++r) {
                    int ncolEmpty = 0;
                    String[] cols = FAIRSpecUtilities.split(rows[r], "<table:table-cell ");
                    if (cols.length > retMaxRC[1]) {
                        retMaxRC[1] = cols.length;
                    }
                    int c = 1;
                    int pc = 1;
                    while (c < cols.length) {
                        xml = cols[c];
                        String s = FAIRSpecUtilities.getQuotedAttribute(xml, "table:number-columns-repeated");
                        if (s != null) {
                            ncolEmpty = Integer.parseInt(s);
                        } else {
                            xml = xml.substring(xml.indexOf(">") + 1);
                            ncolEmpty = 0;
                            sparseData.put(SpreadsheetReader.encodeRC(r, pc += ncolEmpty), SpreadsheetReader.stripXMLStyles(xml));
                        }
                        ++c;
                        ++pc;
                    }
                }
                break;
            }
            return sparseData;
        }

        private static Map<Integer, String> processXLSXData(String sheetXML, String sharedXML, int[] retMaxRC) {
            String[] sharedStrings = null;
            if (sharedXML != null) {
                String[] tokens = sharedXML.split("\\<si\\>\\<t");
                sharedStrings = new String[tokens.length - 1];
                for (int i = 1; i < tokens.length; ++i) {
                    sharedStrings[i - 1] = tokens[i].substring(tokens[i].indexOf(">") + 1, tokens[i].indexOf("</t>"));
                }
            }
            LinkedHashMap<Integer, String> sparseData = new LinkedHashMap<Integer, String>();
            String[] tokens = sheetXML.split("\\<c r");
            for (int i = 1; i < tokens.length; ++i) {
                String val = "";
                int pt = tokens[i].indexOf("</c>");
                String cell = tokens[i].substring(0, pt < 0 ? tokens[i].indexOf("/>") : pt);
                String cr = cell.substring(2, cell.indexOf(34, 3));
                int rowCol = SpreadsheetReader.getRRRCCC(cr);
                if (pt >= 0) {
                    int r = SpreadsheetReader.rcToRow(rowCol);
                    int c = SpreadsheetReader.rcToCol(rowCol);
                    if (r > retMaxRC[0]) {
                        retMaxRC[0] = r;
                    }
                    if (c > retMaxRC[1]) {
                        retMaxRC[1] = c;
                    }
                    boolean isShared = cell.indexOf("t=\"s\"") >= 0;
                    pt = cell.indexOf("<v>");
                    val = cell.substring(pt + 3);
                    val = val.substring(0, val.indexOf("</v>"));
                    if (isShared) {
                        System.out.println("FAIRSpecUtilities.processXLS " + cell);
                        val = sharedStrings[Integer.parseInt(val)];
                    }
                    val = SpreadsheetReader.stripXMLStyles(val);
                }
                if (val.length() <= 0) continue;
                sparseData.put(rowCol, val);
            }
            return sparseData;
        }

        private static String stripXMLStyles(String xml) {
            if (xml.length() == 0) {
                return null;
            }
            String[] a = FAIRSpecUtilities.split(xml, ">");
            StringBuffer sb = new StringBuffer(a[0]);
            for (int i = 1; i < a.length; ++i) {
                sb.append(a[i].substring(0, a[i].indexOf("<")));
            }
            return sb.toString().replace('\u00a0', ' ').trim();
        }

        private static int encodeRC(int r, int c) {
            return r * 1000 + c;
        }

        public static int rcToRow(int rc) {
            return rc / 1000;
        }

        public static int rcToCol(int rc) {
            return rc % 1000;
        }

        public static int getRRRCCC(String cr) {
            int r = 0;
            int c = 0;
            int n = cr.length();
            for (int i = 0; i < n; ++i) {
                char ch = cr.charAt(i);
                if (ch >= 'A') {
                    c = c * 26 + ch - 64;
                    continue;
                }
                r = r * 10 + ch - 48;
            }
            return SpreadsheetReader.encodeRC(r, c);
        }

        public static boolean hasDataKey(Map<String, Object> map) {
            return map.containsKey(FAIRSpecUtilities.DATA_KEY);
        }

        public static int setMapData(Map<String, Object> map, Object data, String indexKey) throws ClassCastException {
            int icol = 1;
            if (!(data instanceof Object[][])) {
                throw new ClassCastException("Data must be Object[][]");
            }
            Object[] row0 = ((Object[][])data)[0];
            for (int c = 0; c < row0.length; ++c) {
                if (indexKey != null && !row0[c].equals(indexKey)) continue;
                icol = c + 1;
                break;
            }
            map.put(FAIRSpecUtilities.INDEX_COL, icol);
            map.put(FAIRSpecUtilities.DATA_KEY, data);
            return icol;
        }

        public static List<Object[]> getRowDataForIndex(Map<String, Object> map, String index) {
            Object[][] cellData = (Object[][])map.get(FAIRSpecUtilities.DATA_KEY);
            int icol = (Integer)map.get(FAIRSpecUtilities.INDEX_COL) - 1;
            return SpreadsheetReader.getRowData(cellData, icol, index);
        }

        private static List<Object[]> getRowData(Object[][] cellData, int icol, String index) {
            int ncol = 0;
            if (cellData == null || icol < 0 || icol >= (ncol = cellData[0].length)) {
                return null;
            }
            ArrayList<Object[]> data = new ArrayList<Object[]>();
            Object[] headerRow = cellData[0];
            for (int r = 1; r < cellData.length; ++r) {
                Object[] rowData = cellData[r];
                if (!index.equals(rowData[icol])) continue;
                for (int i = 0; i < ncol; ++i) {
                    if (i == icol || rowData[i] == null) continue;
                    data.add(new Object[]{headerRow[i], rowData[i]});
                }
            }
            return data.size() == 0 ? null : data;
        }

        public static void dumpData(Object[][] data) {
            StringBuffer sb = new StringBuffer();
            for (int r = 0; r < data.length; ++r) {
                Object[] row = data[r];
                for (int c = 0; c < row.length; ++c) {
                    sb.append(row[c]).append('\t');
                }
                sb.append("\n");
            }
            System.out.println(sb.toString());
        }

        public static void test() {
            try {
                FileInputStream fis = new FileInputStream(new File("c:/temp/manifest.xlsx"));
                Object[][] data = SpreadsheetReader.getCellData(fis, "sheet1", "", true);
                SpreadsheetReader.dumpData(data);
                List<Object[]> list = SpreadsheetReader.getRowData(data, 0, "15");
                System.out.println(list.size());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

