/*
 * Decompiled with CFR 0.152.
 */
package jspecview.js2d;

import java.io.OutputStream;
import javajs.api.GenericColor;
import javajs.util.Base64;
import javajs.util.Lst;
import javajs.util.OC;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPdfWriter;
import jspecview.common.ColorParameters;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PrintLayout;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import org.jmol.api.GenericFileInterface;
import org.jmol.api.GenericMouseInterface;
import org.jmol.api.GenericPlatform;
import org.jmol.util.Font;
import org.jmol.util.Logger;

public class JsPanel
implements JSVPanel {
    private GenericPlatform apiPlatform;
    private PanelData pd;
    private GenericMouseInterface mouse;
    private JSViewer vwr;
    String name;
    private GenericColor bgcolor;

    public void finalize() {
        Logger.info("JSVPanel " + this + " finalized");
    }

    @Override
    public GenericPlatform getApiPlatform() {
        return this.apiPlatform;
    }

    @Override
    public PanelData getPanelData() {
        return this.pd;
    }

    public static JsPanel getEmptyPanel(JSViewer viewer) {
        JsPanel p = new JsPanel(viewer, false);
        p.pd = null;
        return p;
    }

    public static JsPanel getPanelMany(JSViewer viewer, Lst<Spectrum> spectra) {
        JsPanel p = new JsPanel(viewer, true);
        p.pd.initMany(spectra, viewer.initialStartIndex, viewer.initialEndIndex);
        return p;
    }

    private JsPanel(JSViewer viewer, boolean withPd) {
        this.vwr = viewer;
        this.pd = withPd ? new PanelData(this, viewer) : null;
        this.apiPlatform = viewer.apiPlatform;
        this.mouse = this.apiPlatform.getMouseManager(0.0, this);
    }

    @Override
    public String getTitle() {
        return this.pd.getTitle();
    }

    @Override
    public void dispose() {
        if (this.pd != null) {
            this.pd.dispose();
        }
        this.pd = null;
        this.mouse.dispose();
        this.mouse = null;
    }

    @Override
    public void setTitle(String title) {
        this.pd.title = title;
        this.name = title;
    }

    public void setColorOrFont(ColorParameters ds, ScriptToken st) {
        this.pd.setColorOrFont(ds, st);
    }

    @Override
    public void setBackgroundColor(GenericColor color) {
        this.bgcolor = color;
    }

    @Override
    public String getInput(String message, String title, String sval) {
        String ret = null;
        this.getFocusNow(true);
        return ret;
    }

    @Override
    public void showMessage(String msg, String title) {
        Logger.info(msg);
        if (this.vwr.html5Applet != null) {
            this.vwr.html5Applet._showStatus(msg, title);
        }
        this.getFocusNow(true);
    }

    @Override
    public void getFocusNow(boolean asThread) {
        if (this.pd != null) {
            this.pd.dialogsToFront(null);
        }
    }

    @Override
    public int getFontFaceID(String name) {
        return Font.getFontFaceID("SansSerif");
    }

    @Override
    public void doRepaint(boolean andTaintAll) {
        if (this.pd == null) {
            return;
        }
        if (andTaintAll) {
            this.pd.setTaintedAll();
        }
        if (!this.pd.isPrinting) {
            this.vwr.requestRepaint();
        }
    }

    @Override
    public void paintComponent(Object context) {
        Object contextFront = null;
        Object contextRear = null;
        if (this.vwr == null) {
            return;
        }
        if (this.pd == null) {
            if (this.bgcolor == null) {
                this.bgcolor = this.vwr.g2d.getColor1(-1);
            }
            this.vwr.g2d.fillBackground(context, this.bgcolor);
            this.vwr.g2d.fillBackground(contextRear, this.bgcolor);
            this.vwr.g2d.fillBackground(contextFront, this.bgcolor);
            return;
        }
        if (this.pd.graphSets == null || this.pd.isPrinting) {
            return;
        }
        this.pd.g2d = this.pd.g2d0;
        this.pd.drawGraph(context, contextFront, contextRear, this.getWidth(), this.getHeight(), false);
        this.vwr.repaintDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printPanel(PrintLayout pl, OutputStream os, String title) {
        pl.title = title;
        pl.date = this.apiPlatform.getDateFormat("8824");
        this.pd.setPrint(pl, "Helvetica");
        try {
            ((JSVPdfWriter)JSViewer.getInterface("jspecview.common.PDFWriter")).createPdfDocument(this, pl, os);
        }
        catch (Exception ex) {
            this.showMessage(ex.toString(), "creating PDF");
        }
        finally {
            this.pd.setPrint(null, null);
        }
    }

    @Override
    public String saveImage(String type, GenericFileInterface file, OC out) {
        String fname = file.getName();
        boolean isPNG = type.equals("png");
        String s = isPNG ? "png" : "jpeg";
        try {
            out = this.vwr.getOutputChannel(fname, true);
            byte[] data = Base64.decodeBase64(s);
            out.write(data, 0, data.length);
            out.closeChannel();
            return "OK " + out.getByteCount() + " bytes";
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public void repaint() {
    }

    @Override
    public void setToolTipText(String s) {
        int x = this.pd.mouseX;
        int y = this.pd.mouseY;
        if (this.vwr.html5Applet != null) {
            this.vwr.html5Applet._showTooltip(s, x, y);
        }
    }

    @Override
    public int getHeight() {
        return this.vwr.getHeight();
    }

    @Override
    public int getWidth() {
        return this.vwr.getWidth();
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public void setFocusable(boolean b) {
    }

    public String toString() {
        return this.pd == null ? "<closed>" : "" + this.pd.getSpectrumAt(0);
    }

    @Override
    public boolean processMouseEvent(int id, int x, int y, int modifiers, long time) {
        return this.mouse != null && this.mouse.processEvent(id, x, y, modifiers, time);
    }

    @Override
    public void processKeyEvent(Object event) {
        this.mouse.processKeyEvent(event);
    }

    @Override
    public void processTwoPointGesture(double[][][] touches) {
        if (this.mouse != null) {
            this.mouse.processTwoPointGesture(touches);
        }
    }

    @Override
    public void showMenu(int x, int y) {
        this.vwr.showMenu(x, y);
    }
}

