/*
 * Decompiled with CFR 0.152.
 */
package jspecview.js2d;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import javajs.util.PT;
import org.jmol.api.GenericFileInterface;

class JsFile
extends File
implements GenericFileInterface {
    private static final String[] urlPrefixPairs = new String[]{"http:", "http://", "www.", "http://www.", "https:", "https://", "ftp:", "ftp://", "file:", "file:///"};

    JsFile(String name) {
        super(name);
    }

    @Override
    public GenericFileInterface getParentAsFile() {
        JsFile f = null;
        try {
            File file = this.getParentFile();
            f = new JsFile(file.getAbsolutePath());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return f;
    }

    static Object getBufferedFileInputStream(String name) {
        File file = new File(name);
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    static Object getURLContents(URL url, byte[] outputBytes, String post) {
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            String type = null;
            if (outputBytes != null) {
                type = "application/octet-stream;";
            } else if (post != null) {
                type = "application/x-www-form-urlencoded";
            }
            if (type != null) {
                conn.setRequestProperty("Content-Type", type);
                conn.setDoOutput(true);
                if (outputBytes == null) {
                    OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                    wr.write(post);
                    wr.flush();
                } else {
                    conn.getOutputStream().write(outputBytes);
                    conn.getOutputStream().flush();
                }
            }
            return new BufferedInputStream(conn.getInputStream());
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    @Override
    public String getFullPath() {
        try {
            return this.getAbsolutePath();
        }
        catch (Exception e) {
            return null;
        }
    }

    static String getLocalUrl(GenericFileInterface file) {
        int i;
        if (file.getName().startsWith("=")) {
            return file.getName();
        }
        String path = file.getFullPath();
        if (path == null) {
            return null;
        }
        path = path.replace('\\', '/');
        for (i = 0; i < urlPrefixPairs.length; ++i) {
            if (path.indexOf(urlPrefixPairs[i]) != 0) continue;
            return null;
        }
        for (i = 0; i < urlPrefixPairs.length; i += 2) {
            if (path.indexOf(urlPrefixPairs[i]) <= 0) continue;
            return urlPrefixPairs[i + 1] + PT.trim(path.substring(path.indexOf(urlPrefixPairs[i]) + urlPrefixPairs[i].length()), "/");
        }
        return null;
    }
}

