/*
 * Decompiled with CFR 0.152.
 */
package jme.util;

public class ChangeManager<T> {
    protected Node<T> currentIndex = null;
    protected Node<T> parentNode = new Node();

    public ChangeManager() {
        this.currentIndex = this.parentNode;
    }

    public ChangeManager(ChangeManager<T> manager) {
        this();
        this.currentIndex = manager.currentIndex;
    }

    public void clear() {
        this.currentIndex = this.parentNode;
        ((Node)this.parentNode).right = null;
    }

    public void insertItem(T item) {
        if (item == null) {
            System.err.println("Null item");
        }
        Node<T> node = new Node<T>(item);
        assert (item != null);
        Node savedRight = ((Node)this.currentIndex).right;
        ((Node)this.currentIndex).right = (Node)node;
        ((Node)node).left = (Node)this.currentIndex;
        if (savedRight != null) {
            ((Node)node).right = savedRight;
            savedRight.left = (Node)node;
        }
        this.currentIndex = node;
    }

    public T removeLast() {
        if (!this.canUndo()) {
            return null;
        }
        Node savedRight = ((Node)this.currentIndex).right;
        Object lastItem = ((Node)this.currentIndex).item;
        this.undo();
        ((Node)this.currentIndex).right = savedRight;
        return (T)lastItem;
    }

    public boolean canUndo() {
        return this.currentIndex != this.parentNode && ((Node)this.currentIndex).left != this.parentNode;
    }

    public boolean canRedo() {
        return ((Node)this.currentIndex).right != null;
    }

    public T undo() {
        if (!this.canUndo()) {
            throw new IllegalStateException("Cannot undo. Index is out of range.");
        }
        this.moveLeft();
        Object item = ((Node)this.currentIndex).item;
        return (T)item;
    }

    private void moveLeft() {
        if (((Node)this.currentIndex).left == null) {
            throw new IllegalStateException("Internal index set to null.");
        }
        this.currentIndex = ((Node)this.currentIndex).left;
    }

    private void moveRight() {
        if (((Node)this.currentIndex).right == null) {
            throw new IllegalStateException("Internal index set to null.");
        }
        this.currentIndex = ((Node)this.currentIndex).right;
    }

    public T redo() {
        if (!this.canRedo()) {
            throw new IllegalStateException("Cannot redo. Index is out of range.");
        }
        this.moveRight();
        Object item = ((Node)this.currentIndex).item;
        return (T)item;
    }

    private class Node<N> {
        private Node<N> left = null;
        private Node<N> right = null;
        private final N item;

        public Node(N c) {
            this.item = c;
        }

        public Node() {
            this.item = null;
        }
    }
}

