/*
 * Decompiled with CFR 0.152.
 */
package jme.io;

import com.actelion.research.chem.SVGDepictor;
import com.actelion.research.chem.StereoMolecule;
import jme.io.ChemicalMimeType;
import jme.util.JMEUtil;

public class JMESVGWriter
extends SVGDepictor {
    String mdlMOL;
    String tag;

    public JMESVGWriter(StereoMolecule mol, String mdlMol) {
        super(mol, "");
        if (mdlMol != null && mdlMol.length() > 0) {
            this.mdlMOL = mdlMol;
        }
        int mode = 224;
        this.setDisplayMode(mode);
    }

    public String additionalMetaInfo(String indent) {
        String result = "";
        if (this.mdlMOL != null) {
            String molData = JMEUtil.wrapCDATA(this.mdlMOL);
            result = indent + "<" + ChemicalMimeType.chemicalMimeTag() + ">" + molData + "</" + ChemicalMimeType.chemicalMimeTag() + ">\n";
        }
        return result;
    }

    @Override
    public String toString() {
        String svg = super.toString();
        if (this.mdlMOL != null) {
            int pt = svg.lastIndexOf("</");
            if (pt > 0) {
                svg = svg.substring(0, pt) + this.additionalMetaInfo("") + svg.substring(pt);
            }
            if ((pt = svg.indexOf("xmlns")) > 0) {
                svg = svg.substring(0, pt) + ChemicalMimeType.additionalNameSpaces(" ") + svg.substring(pt);
            }
        }
        return svg;
    }
}

