/*
 * Decompiled with CFR 0.152.
 */
package jme.core;

import jme.core.Atom;
import jme.core.AtomBondCommon;
import jme.core.Bond;
import jme.core.JMECore;
import jme.util.Isotopes;

public class JMESmiles
extends JMECore {
    private int[] a;
    private int[] btype;
    private boolean doMark;
    private boolean isQuery;
    private boolean autoez;
    private boolean smartsMode = false;

    public JMESmiles(JMECore mol, int part, boolean isQuery) {
        super(mol, part);
        this.isQuery = isQuery;
    }

    String createSmilesWithSideEffect(JMECore.Parameters mpars) {
        int i;
        int step;
        if (this.natoms == 0) {
            return "";
        }
        this.parameters = mpars;
        this.doMark = mpars.mark;
        this.autoez = mpars.smilesParams.autoez;
        int[] con1 = new int[this.natoms + 10];
        int[] con2 = new int[this.natoms + 10];
        int[] branch = new int[this.natoms + 1];
        int[] candidate = new int[7];
        int[] parent = new int[this.natoms + 1];
        boolean[] isAromatic = new boolean[this.natoms + 1];
        boolean[] isRingBond = new boolean[this.nbonds + 1];
        int[] bondMinimumRingSize = new int[this.nbonds + 1];
        int nconnections = 0;
        if (mpars.smilesParams.canonize && !this.haveQueryOrCoordBonds()) {
            this.smartsMode = mpars.smilesParams.smarts;
            JMECore.Parameters.HydrogenParams pars = JMESmiles.setHydrogenParams(mpars);
            this.deleteHydrogens(pars);
            this.cleanPolarBonds(mpars.smilesParams.polarnitro);
            this.findRingBonds(bondMinimumRingSize);
            boolean allowAromatic = mpars.smilesParams.allowaromatic;
            this.setBondTypes(isAromatic, bondMinimumRingSize, allowAromatic);
            this.canonize(mpars.computeValenceState);
            this.setValenceState();
            this.findRingBonds(bondMinimumRingSize);
            this.setBondTypes(isAromatic, bondMinimumRingSize, allowAromatic);
        } else {
            this.findRingBonds(bondMinimumRingSize);
            this.btype = new int[this.nbonds + 1];
            for (int i2 = 1; i2 <= this.nbonds; ++i2) {
                this.btype[i2] = this.bonds[i2].bondType;
            }
        }
        for (int b = 1; b <= this.nbonds; ++b) {
            isRingBond[b] = bondMinimumRingSize[b] > 0;
        }
        int atom = 1;
        this.a = new int[this.natoms + 1];
        this.a[atom] = step = 1;
        int nbranch = 0;
        while (true) {
            int b;
            int i3;
            int ncandidates = 0;
            for (int i4 = 1; i4 <= this.nv(atom); ++i4) {
                int atomx = this.v(atom)[i4];
                if (this.a[atomx] > 0) {
                    if (this.a[atomx] > this.a[atom] || atomx == parent[atom]) continue;
                    boolean newcon = true;
                    for (int k = 1; k <= nconnections; ++k) {
                        if ((con1[k] != atom || con2[k] != atomx) && (con1[k] != atomx || con2[k] != atom)) continue;
                        newcon = false;
                        break;
                    }
                    if (!newcon) continue;
                    con1[++nconnections] = atom;
                    con2[nconnections] = atomx;
                    continue;
                }
                candidate[++ncandidates] = atomx;
            }
            if (ncandidates == 0) {
                if (step == this.natoms) break;
                atom = branch[nbranch--];
                continue;
            }
            if (ncandidates == 1) {
                parent[candidate[1]] = atom;
                atom = candidate[1];
                this.a[atom] = ++step;
                continue;
            }
            branch[++nbranch] = atom;
            int atomnew = 0;
            for (i3 = 1; i3 <= ncandidates; ++i3) {
                b = this.getBondIndex(candidate[i3], atom);
                if (isRingBond[b]) continue;
                atomnew = candidate[i3];
                break;
            }
            if (atomnew == 0) {
                for (i3 = 1; i3 <= ncandidates; ++i3) {
                    b = this.getBondIndex(candidate[i3], atom);
                    if (this.btype[b] != 2 && this.btype[b] != 3) continue;
                    atomnew = candidate[i3];
                    break;
                }
            }
            if (atomnew == 0) {
                atomnew = candidate[1];
            }
            parent[atomnew] = atom;
            atom = atomnew;
            this.a[atom] = ++step;
        }
        parent = new int[this.natoms + 1];
        int[] aa = new int[this.natoms + 1];
        boolean[] leftBracket = new boolean[this.natoms + 1];
        boolean[] rightBracket = new boolean[this.natoms + 1];
        nbranch = 0;
        step = 0;
        int atomold = 0;
        for (int i5 = 1; i5 <= this.natoms; ++i5) {
            if (this.a[i5] != 1) continue;
            atom = i5;
            break;
        }
        block8: while (true) {
            int ncandidates;
            int atomnew;
            if (atomold > 0) {
                parent[atom] = atomold;
            }
            aa[++step] = atom;
            this.a[atom] = 0;
            while (true) {
                atomnew = 0;
                ncandidates = 0;
                int min = this.natoms + 1;
                block10: for (int i6 = 1; i6 <= this.nv(atom); ++i6) {
                    int atomx = this.v(atom)[i6];
                    for (int j = 1; j <= nconnections; ++j) {
                        if (con1[j] == atomx && con2[j] == atom || con1[j] == atom && con2[j] == atomx) continue block10;
                    }
                    if (this.a[atomx] <= 0) continue;
                    ++ncandidates;
                    if (this.a[atomx] >= min) continue;
                    atomnew = atomx;
                    min = this.a[atomx];
                }
                if (atomnew != 0) break;
                if (nbranch == 0) break block8;
                rightBracket[atom] = true;
                atom = branch[nbranch--];
            }
            atomold = atom;
            atom = atomnew;
            if (ncandidates <= true) continue;
            branch[++nbranch] = atomold;
            leftBracket[atom] = true;
        }
        int[] slashBond = new int[this.nbonds + 1];
        int[] stereo = new int[this.natoms + 1];
        if (mpars.smilesParams.stereo) {
            this.smilesStereo(aa, parent, slashBond, stereo, bondMinimumRingSize, con1, con2, nconnections);
        }
        boolean queryMode = false;
        StringBuffer smiles = new StringBuffer("");
        int[] ax = new int[this.natoms + 1];
        for (i = 1; i <= this.natoms; ++i) {
            ax[aa[i]] = i;
        }
        for (i = 1; i <= this.natoms; ++i) {
            atom = aa[i];
            if (leftBracket[atom]) {
                smiles.append("(");
            }
            if (parent[i] > 0) {
                this.smilesAddBond(atom, parent[atom], smiles, slashBond, queryMode);
            }
            this.smilesAddAtom(atom, smiles, isAromatic[atom], stereo);
            for (int j = 1; j <= nconnections; ++j) {
                if (con1[j] != atom && con2[j] != atom) continue;
                int atom2 = con2[j];
                if (atom2 == atom) {
                    atom2 = con1[j];
                }
                if (ax[atom] < ax[atom2]) {
                    this.smilesAddBond(con1[j], con2[j], smiles, slashBond, queryMode);
                }
                if (j > 9) {
                    smiles.append("%");
                }
                smiles.append(new Integer(j).toString());
            }
            if (!rightBracket[atom]) continue;
            smiles.append(")");
        }
        return smiles.toString();
    }

    private static JMECore.Parameters.HydrogenParams setHydrogenParams(JMECore.Parameters mpars) {
        JMECore.Parameters.HydrogenParams pars = new JMECore.Parameters().hydrogenParams;
        pars.keepStereoHs = !mpars.smilesParams.stereo;
        pars.removeOnlyCHs = mpars.smilesParams.smarts;
        return pars;
    }

    private void smilesAddAtom(int at, StringBuffer smiles, boolean isAromatic, int[] stereo) {
        String z = "X";
        Atom atom = this.atoms[at];
        int iso = atom.iso;
        int nh = atom.nh;
        int q = atom.q;
        int an = atom.an;
        int map = this.findAtomMapForOutput(at);
        boolean isMapped = map != 0;
        boolean bracket = q != 0 || iso != 0 || stereo[at] != 0 || isMapped || this.doMark && atom.backgroundColors[0] > 0 || this.smartsMode && nh > 0 && an != 3;
        switch (an) {
            case 2: {
                z = "B";
                break;
            }
            case 3: {
                if (isAromatic) {
                    z = "c";
                    break;
                }
                z = "C";
                break;
            }
            case 4: {
                if (isAromatic) {
                    z = "n";
                    if (nh <= 0) break;
                    bracket = true;
                    break;
                }
                z = "N";
                break;
            }
            case 5: {
                if (isAromatic) {
                    z = "o";
                    break;
                }
                z = "O";
                break;
            }
            case 7: {
                if (isAromatic) {
                    z = "p";
                    if (nh <= 0) break;
                    bracket = true;
                    break;
                }
                z = "P";
                break;
            }
            case 8: {
                if (isAromatic) {
                    z = "s";
                    break;
                }
                z = "S";
                break;
            }
            case 13: {
                z = isAromatic ? "se" : "Se";
                bracket = true;
                break;
            }
            case 6: {
                z = "Si";
                bracket = true;
                break;
            }
            case 9: {
                z = "F";
                break;
            }
            case 10: {
                z = "Cl";
                break;
            }
            case 11: {
                z = "Br";
                break;
            }
            case 12: {
                z = "I";
                break;
            }
            case 1: {
                z = "H";
                bracket = true;
                break;
            }
            case 32: {
                bracket = true;
                z = atom.label;
                if (z == null) {
                    z = "X";
                }
                if (isMapped || !z.equals("*") && !z.equals("a") && !z.equals("A")) break;
                bracket = false;
            }
        }
        if (Atom.chargedMetalType(an) > 0) {
            z = Atom.zlabel[an];
            bracket = true;
        }
        if (an >= 33 && an <= 42) {
            bracket = true;
            z = Atom.zlabel[an];
        }
        if (bracket) {
            z = iso != 0 ? "[" + iso + z : "[" + z;
            if (stereo[at] == 1) {
                z = z + "@";
            } else if (stereo[at] == -1) {
                z = z + "@@";
            }
            if (nh == 1) {
                z = z + "H";
            } else if (nh > 1) {
                z = z + "H" + nh;
            }
            if (q != 0) {
                z = q > 0 ? z + "+" : z + "-";
                if (Math.abs(q) > 1) {
                    z = z + Math.abs(q);
                }
            }
            if (isMapped) {
                z = z + ":" + map;
            }
            z = z + "]";
        }
        smiles.append(z);
    }

    private void smilesAddBond(int atom1, int atom2, StringBuffer smiles, int[] slashBond, boolean queryMode) {
        int b = this.getBondIndex(atom1, atom2);
        Bond bond = this.bonds[b];
        if (this.btype[b] != 5 && bond.isDouble()) {
            smiles.append("=");
        } else if (bond.isTriple()) {
            smiles.append("#");
        } else if (bond.isQuery()) {
            String z = "?";
            String o = bond.btag;
            if (o != null) {
                z = o;
            }
            smiles.append(z);
        } else if (this.btype[b] == 5 && queryMode) {
            smiles.append(":");
        } else if (bond.isCoordination()) {
            smiles.append("~");
        } else if (slashBond[b] == 1) {
            smiles.append("/");
        } else if (slashBond[b] == -1) {
            smiles.append("\\");
        }
    }

    private void smilesStereo(int[] aa, int[] parent, int[] slashBond, int[] stereo, int[] bondMinimumRingSize, int[] con1, int[] con2, int nconnections) {
        int i;
        int[] ax = new int[this.natoms + 1];
        for (int at = 1; at <= this.natoms; ++at) {
            ax[aa[at]] = at;
        }
        boolean[] doneEZ = new boolean[this.nbonds + 1];
        for (i = 1; i <= this.natoms; ++i) {
            int atom1 = aa[i];
            int atom2 = parent[atom1];
            int bi = this.getBondIndex(atom1, atom2);
            if (bi == 0) continue;
            this.stereoEZ(bi, ax, slashBond, bondMinimumRingSize);
            doneEZ[bi] = true;
        }
        for (i = 1; i <= this.nbonds; ++i) {
            if (doneEZ[i]) continue;
            this.stereoEZ(i, ax, slashBond, bondMinimumRingSize);
        }
        doneEZ = null;
        block3: for (int at = 1; at <= this.natoms; ++at) {
            if (this.nv(at) < 2 || this.nv(at) > 4) continue;
            int nstereo = 0;
            int doubleBonded = 0;
            for (int neighbor = 1; neighbor <= this.nv(at); ++neighbor) {
                int bi = this.getBondIndex(at, this.v(at)[neighbor]);
                if (this.btype[bi] == 5) continue block3;
                if (this.bonds[bi].bondType == 1 && JMESmiles.upDownBond(this.bonds[bi], at) != 0) {
                    ++nstereo;
                }
                if (this.bonds[bi].bondType != 2) continue;
                doubleBonded = this.v(at)[neighbor];
            }
            if (nstereo == 0) continue;
            if (doubleBonded > 0) {
                this.stereoAllene(at, ax, stereo, parent, con1, con2, nconnections);
                continue;
            }
            this.stereoC4(at, parent, ax, con1, con2, nconnections, stereo);
        }
    }

    private void stereoC4(int atom, int[] parent, int[] ax, int[] con1, int[] con2, int nconnections, int[] stereo) {
        int[] ref = new int[4];
        int[] refx = new int[4];
        this.identifyNeighbors(atom, ax, parent, con1, con2, nconnections, ref);
        int nup = 0;
        int ndown = 0;
        int up = 0;
        int down = 0;
        int marked = 0;
        int nonmarked = 0;
        for (int i = 0; i < 4; ++i) {
            if (ref[i] <= 0) continue;
            int bi = this.getBondIndex(atom, ref[i]);
            refx[i] = JMESmiles.upDownBond(this.bonds[bi], atom);
            if (refx[i] > 0) {
                ++nup;
                up = ref[i];
                marked = ref[i];
                continue;
            }
            if (refx[i] < 0) {
                ++ndown;
                down = ref[i];
                marked = ref[i];
                continue;
            }
            nonmarked = ref[i];
        }
        int nstereo = nup + ndown;
        int[] t = new int[4];
        int stereoRef = 0;
        if (this.atoms[atom].nv == 3) {
            if (nup == 1 && ndown == 1 || nstereo == 3 && nup > 0 && ndown > 0) {
                this.info("Error in C3H stereospecification !");
                return;
            }
            int refAtom = ref[0];
            if (nstereo == 1) {
                refAtom = marked;
            } else if (nstereo == 2) {
                refAtom = nonmarked;
            }
            int[] ox = this.C4order(atom, refAtom, ref);
            t[0] = marked;
            t[1] = -1;
            t[2] = ox[2];
            t[3] = ox[1];
            stereoRef = nup > 0 ? 1 : -1;
        } else if (this.nv(atom) == 4) {
            if (nstereo == 1) {
                int[] ox = this.C4order(atom, marked, ref);
                t[0] = ox[0];
                t[1] = ox[3];
                t[2] = ox[2];
                t[3] = ox[1];
                stereoRef = nup > 0 ? 1 : -1;
            } else {
                int i;
                int refAtom = ref[0];
                if (nonmarked > 1) {
                    refAtom = nonmarked;
                }
                if (nup == 1) {
                    refAtom = up;
                } else if (ndown == 1) {
                    refAtom = down;
                }
                int[] ox = this.C4order(atom, refAtom, ref);
                int[] box = new int[4];
                for (i = 0; i < 4; ++i) {
                    int bi = this.getBondIndex(atom, ox[i]);
                    box[i] = JMESmiles.upDownBond(this.bonds[bi], atom);
                }
                if (nstereo == 4) {
                    if (nup == 0 || ndown == 0) {
                        this.info("Error in C4 stereospecification !");
                        return;
                    }
                    if (nup == 1 || ndown == 1) {
                        t[0] = ox[0];
                        t[1] = ox[3];
                        t[2] = ox[2];
                        t[3] = ox[1];
                        stereoRef = box[0];
                    } else {
                        for (i = 0; i < 4; ++i) {
                            if (box[i] != -1) continue;
                            box[i] = 0;
                        }
                        nstereo = 2;
                    }
                } else if (nstereo == 3) {
                    if (nup == 3 || ndown == 3) {
                        t[0] = ox[0];
                        t[1] = ox[3];
                        t[2] = ox[2];
                        t[3] = ox[1];
                        stereoRef = nup > 0 ? -1 : 1;
                    } else {
                        int d = 0;
                        if (nup == 1) {
                            d = 1;
                            nup = 1;
                        } else {
                            d = -1;
                            ndown = -1;
                        }
                        for (int i2 = 0; i2 < 4; ++i2) {
                            if (box[i2] != d) continue;
                            box[i2] = 0;
                        }
                        nstereo = 2;
                    }
                }
                if (nstereo == 2) {
                    if (nup == 1 && ndown == 1) {
                        if (ox[1] == down) {
                            ox[1] = ox[2];
                            ox[2] = ox[3];
                        } else if (ox[2] == down) {
                            ox[2] = ox[3];
                        }
                        t[0] = up;
                        t[1] = down;
                        t[2] = ox[2];
                        t[3] = ox[1];
                        stereoRef = 1;
                    } else {
                        if (box[0] == box[1] || box[1] == box[2]) {
                            this.info("Error in C4 stereospecification ! 2/0r");
                            return;
                        }
                        if (box[0] != 0) {
                            t[0] = ox[0];
                            t[1] = ox[2];
                            t[2] = ox[1];
                            t[3] = ox[3];
                        } else {
                            t[0] = ox[1];
                            t[1] = ox[3];
                            t[2] = ox[2];
                            t[3] = ox[0];
                        }
                        stereoRef = nup > 1 ? 1 : -1;
                    }
                }
            }
        }
        JMESmiles.stereoTransformation(t, ref);
        if (t[2] == ref[2]) {
            stereo[atom] = 1;
        } else if (t[2] == ref[3]) {
            stereo[atom] = -1;
        } else {
            this.info("Error in stereoprocessing ! - t30");
        }
        int n = atom;
        stereo[n] = stereo[n] * stereoRef;
    }

    private void identifyNeighbors(int atom, int[] ax, int[] parent, int[] con1, int[] con2, int nconnections, int[] ref) {
        int i;
        int nref = -1;
        if (parent[atom] > 0) {
            ref[++nref] = parent[atom];
        }
        for (i = 1; i <= nconnections; ++i) {
            if (con1[i] == atom) {
                ref[++nref] = con2[i];
            }
            if (con2[i] != atom) continue;
            ref[++nref] = con1[i];
        }
        for (i = nref + 1; i < this.nv(atom); ++i) {
            int min = this.natoms + 1;
            block2: for (int j = 1; j <= this.nv(atom); ++j) {
                int atomx = this.v(atom)[j];
                for (int k = 0; k < i; ++k) {
                    if (atomx == ref[k]) continue block2;
                }
                if (ax[atomx] >= min) continue;
                min = ax[atomx];
                ref[i] = atomx;
            }
        }
        if (parent[atom] == 0 && this.atoms[atom].nh > 0) {
            ref[3] = ref[2];
            ref[2] = ref[1];
            ref[1] = ref[0];
            ref[0] = -1;
            System.out.println("stereowarning #7");
        } else if (this.atoms[atom].nh > 0) {
            ref[3] = ref[2];
            ref[2] = ref[1];
            ref[1] = -1;
        }
    }

    int[] C4order(int center, int ref0, int[] ref) {
        int[] ox = new int[4];
        this.setCosSin(center, ref0);
        int[] p = new int[4];
        for (int i = 0; i < 4; ++i) {
            if (ref[i] == ref0 || ref[i] <= 0) continue;
            if (p[1] == 0) {
                p[1] = ref[i];
                continue;
            }
            if (p[2] == 0) {
                p[2] = ref[i];
                continue;
            }
            if (p[3] != 0) continue;
            p[3] = ref[i];
        }
        double[] sin = new double[4];
        double[] cos = new double[4];
        for (int i = 1; i <= 3; ++i) {
            if (i == 3 && p[3] == 0) continue;
            this.setCosSin(center, p[i]);
            cos[i] = this.temp[0];
            sin[i] = this.temp[1];
        }
        int c12 = JMESmiles.compareAngles(sin[1], cos[1], sin[2], cos[2]);
        if (p[3] > 0) {
            int c23 = JMESmiles.compareAngles(sin[2], cos[2], sin[3], cos[3]);
            int c13 = JMESmiles.compareAngles(sin[1], cos[1], sin[3], cos[3]);
            if (c12 > 0 && c23 > 0) {
                ox[1] = p[1];
                ox[2] = p[2];
                ox[3] = p[3];
            } else if (c13 > 0 && c23 < 0) {
                ox[1] = p[1];
                ox[2] = p[3];
                ox[3] = p[2];
            } else if (c12 < 0 && c13 > 0) {
                ox[1] = p[2];
                ox[2] = p[1];
                ox[3] = p[3];
            } else if (c23 > 0 && c13 < 0) {
                ox[1] = p[2];
                ox[2] = p[3];
                ox[3] = p[1];
            } else if (c13 < 0 && c12 > 0) {
                ox[1] = p[3];
                ox[2] = p[1];
                ox[3] = p[2];
            } else if (c23 < 0 && c12 < 0) {
                ox[1] = p[3];
                ox[2] = p[2];
                ox[3] = p[1];
            }
        } else {
            if (c12 > 0) {
                ox[1] = p[1];
                ox[2] = p[2];
            } else {
                ox[1] = p[2];
                ox[2] = p[1];
            }
            double u12 = this.angle(center, p[1], p[2]);
            double u23 = this.angle(center, p[2], ref0);
            double u13 = this.angle(center, p[1], ref0);
            if ((u12 + u23 < Math.PI || u23 + u13 < Math.PI || u12 + u13 < Math.PI) && u12 > u23 && u12 > u13) {
                int o = ox[1];
                ox[1] = ox[2];
                ox[2] = o;
            }
        }
        ox[0] = ref0;
        return ox;
    }

    private double angle(int p1, int p2, int p3) {
        double r12 = this.distance(p1, p2);
        double r13 = this.distance(p1, p3);
        double r23 = this.distance(p2, p3);
        return Math.acos((r12 * r12 + r13 * r13 - r23 * r23) / (2.0 * r12 * r13));
    }

    private int[] doubleBondNeighborsOfAtom1WithoutDoubleBondedAtom(int atom1) {
        int[] neighbors = new int[]{0, 0};
        int n = 0;
        for (int j = 1; j <= this.nv(atom1); ++j) {
            int atomx = this.v(atom1)[j];
            int bi = this.getBondIndex(atom1, atomx);
            if (this.bondType(bi) == 2) continue;
            neighbors[n++] = atomx;
        }
        return neighbors;
    }

    private void stereoEZ(int bond, int[] ax, int[] slashBond, int[] bondMinimumRingSize) {
        int bi;
        int[] a;
        if (this.bondType(bond) != 2 || this.btype[bond] == 5) {
            return;
        }
        if (bondMinimumRingSize[bond] > 0 && bondMinimumRingSize[bond] <= 7) {
            return;
        }
        if (!this.autoez && this.bonds[bond].stereo != 10) {
            return;
        }
        if (this.bonds[bond].stereo == 10) {
            return;
        }
        int atom1 = this.bonds[bond].va;
        int atom2 = this.bonds[bond].vb;
        if (this.atoms[atom1].isCumuleneSP() && this.atoms[atom2].isCumuleneSP()) {
            return;
        }
        int[] cumuleneAtoms = null;
        if (this.atoms[atom1].isCumuleneSP()) {
            cumuleneAtoms = this.findCumuleneChain(atom2);
        } else if (this.atoms[atom2].isCumuleneSP()) {
            cumuleneAtoms = this.findCumuleneChain(atom1);
        }
        if (cumuleneAtoms != null) {
            if ((cumuleneAtoms[0] - 1) % 2 == 1) {
                atom1 = cumuleneAtoms[1];
                atom2 = cumuleneAtoms[cumuleneAtoms[0]];
            } else {
                return;
            }
        }
        for (int eachBondAtom : a = new int[]{atom1, atom2}) {
            int nv = this.nv(eachBondAtom);
            if (nv >= 2 && nv <= 3) continue;
            return;
        }
        if (ax[atom1] > ax[atom2]) {
            int d = atom1;
            atom1 = atom2;
            atom2 = d;
        }
        int[] neighbors = this.doubleBondNeighborsOfAtom1WithoutDoubleBondedAtom(atom1);
        int ref11 = neighbors[0];
        int ref12 = neighbors[1];
        int ref1 = 0;
        boolean ref1x = false;
        if (ref12 > 0 && ax[ref11] > ax[ref12]) {
            int d = ref11;
            ref11 = ref12;
            ref12 = d;
        }
        if (slashBond[bi = this.getBondIndex(atom1, ref11)] != 0) {
            ref1 = ref11;
        } else if (this.bondType(bi) == 1 && this.btype[bi] != 5) {
            ref1 = ref11;
        }
        if (ref1 == 0 && ref12 > 0) {
            bi = this.getBondIndex(atom1, ref12);
            if (slashBond[bi] != 0) {
                ref1 = ref12;
            } else if (this.bondType(bi) == 1 && this.btype[bi] != 5) {
                ref1 = ref12;
            }
        }
        if (ax[ref1] > ax[atom1]) {
            ref1x = true;
        }
        neighbors = this.doubleBondNeighborsOfAtom1WithoutDoubleBondedAtom(atom2);
        int ref21 = neighbors[0];
        int ref22 = neighbors[1];
        if (ref21 == 0 && ref22 == 0) {
            return;
        }
        int ref2 = 0;
        if (ref22 > 0 && ax[ref21] < ax[ref22]) {
            int d = ref21;
            ref21 = ref22;
            ref22 = d;
        }
        if (this.bondType(bi = this.getBondIndex(atom2, ref21)) == 1 && this.btype[bi] != 5 && slashBond[bi] == 0) {
            ref2 = ref21;
        }
        if (ref2 == 0 && ref22 > 0 && this.bondType(bi = this.getBondIndex(atom2, ref22)) == 1 && this.btype[bi] != 5) {
            ref2 = ref22;
        }
        if (ref1 == 0 || ref2 == 0) {
            return;
        }
        this.setCosSin(atom1, atom2);
        double y1 = (this.y(ref1) - this.y(atom1)) * this.temp[0] - (this.x(ref1) - this.x(atom1)) * this.temp[1];
        double y2 = (this.y(ref2) - this.y(atom1)) * this.temp[0] - (this.x(ref2) - this.x(atom1)) * this.temp[1];
        if (Math.abs(y1) < 2.0 || Math.abs(y2) < 2.0) {
            this.info("Not unique E/Z geometry !");
            return;
        }
        int b1 = this.getBondIndex(ref1, atom1);
        int b2 = this.getBondIndex(ref2, atom2);
        int newSlash = 1;
        if (slashBond[b1] == 0) {
            for (int j = 1; j <= this.nv(ref1); ++j) {
                int atomx = this.v(ref1)[j];
                if (atomx == atom1 || slashBond[bi = this.getBondIndex(ref1, atomx)] == 0) continue;
                if (ax[atomx] > ax[ref1]) {
                    newSlash = -slashBond[bi];
                    break;
                }
                newSlash = slashBond[bi];
                break;
            }
            slashBond[b1] = newSlash;
        }
        if (slashBond[b2] != 0) {
            System.err.println("E/Z internal error !");
            return;
        }
        slashBond[b2] = y1 > 0.0 && y2 > 0.0 || y1 < 0.0 && y2 < 0.0 ? -slashBond[b1] : slashBond[b1];
        if (ref1x) {
            slashBond[b2] = -slashBond[b2];
        }
    }

    static int upDownBond(Bond bond, int atom) {
        int sb = bond.stereo;
        if (sb == 0 || sb > 4) {
            return 0;
        }
        if (sb == 1 && bond.va == atom) {
            return 1;
        }
        if (sb == 2 && bond.va == atom) {
            return -1;
        }
        if (sb == 3 && bond.vb == atom) {
            return 1;
        }
        if (sb == 4 && bond.vb == atom) {
            return -1;
        }
        return 0;
    }

    private int[] findCumuleneChain(int startAtom) {
        int numberCumuleneAtoms = 1;
        int currentCumuleneAtom = startAtom;
        int[] cumuleneAtoms = new int[this.natoms + 1];
        if (this.atoms[startAtom].isCumuleneSP()) {
            cumuleneAtoms[0] = 0;
            return cumuleneAtoms;
        }
        cumuleneAtoms[1] = startAtom;
        while (true) {
            for (int ni = 1; ni <= this.nv(currentCumuleneAtom); ++ni) {
                int atomx = this.v(currentCumuleneAtom)[ni];
                if (atomx == cumuleneAtoms[1] || atomx == cumuleneAtoms[numberCumuleneAtoms - 1]) continue;
                int bi = this.getBondIndex(currentCumuleneAtom, atomx);
                if (this.bonds[bi].bondType != 2 || this.btype[bi] == 5) continue;
                cumuleneAtoms[++numberCumuleneAtoms] = atomx;
                currentCumuleneAtom = atomx;
            }
            break;
        }
        cumuleneAtoms[0] = numberCumuleneAtoms;
        return cumuleneAtoms;
    }

    private void stereoAllene(int ati, int[] ax, int[] stereo, int[] parent, int[] con1, int[] con2, int nconnections) {
        int ref22x;
        int d;
        int atomx;
        int[] cumuleneAtoms = this.findCumuleneChain(ati);
        int numberCumuleneAtoms = cumuleneAtoms[0];
        if (numberCumuleneAtoms % 2 == 0) {
            return;
        }
        int start = cumuleneAtoms[1];
        int center = cumuleneAtoms[(numberCumuleneAtoms + 1) / 2];
        int end = cumuleneAtoms[numberCumuleneAtoms];
        if (this.nv(end) < 2 || this.nv(end) > 3) {
            return;
        }
        int ref11 = 0;
        int ref12 = 0;
        int ref21 = 0;
        int ref22 = 0;
        int ref1 = 0;
        int ref2 = 0;
        boolean ref1x = false;
        boolean ref2x = false;
        for (int ni = 1; ni <= this.nv(start); ++ni) {
            atomx = this.v(start)[ni];
            if (atomx == cumuleneAtoms[2]) continue;
            if (ref11 == 0) {
                ref11 = atomx;
                continue;
            }
            ref12 = atomx;
        }
        if (ax[ref12] > 0 && ax[ref11] > ax[ref12]) {
            d = ref11;
            ref11 = ref12;
            ref12 = d;
        }
        if ((ref1 = ref11) == 0) {
            ref1 = ref12;
            ref1x = true;
        }
        for (int j = 1; j <= this.nv(end); ++j) {
            atomx = this.v(end)[j];
            if (atomx == cumuleneAtoms[numberCumuleneAtoms - 1]) continue;
            if (ref21 == 0) {
                ref21 = atomx;
                continue;
            }
            ref22 = atomx;
        }
        if (ax[ref22] > 0 && ax[ref21] > ax[ref22]) {
            d = ref21;
            ref21 = ref22;
            ref22 = d;
        }
        if ((ref2 = ref21) == 0) {
            ref2 = ref22;
            ref2x = true;
        }
        int ref11x = ref11 > 0 ? JMESmiles.upDownBond(this.bonds[this.getBondIndex(start, ref11)], start) : 0;
        int ref12x = ref12 > 0 ? JMESmiles.upDownBond(this.bonds[this.getBondIndex(start, ref12)], start) : 0;
        int ref21x = ref21 > 0 ? JMESmiles.upDownBond(this.bonds[this.getBondIndex(end, ref21)], end) : 0;
        int n = ref22x = ref22 > 0 ? JMESmiles.upDownBond(this.bonds[this.getBondIndex(end, ref22)], end) : 0;
        if (Math.abs(ref11x + ref12x) > 1 || ref21x != 0 || ref22x != 0) {
            this.info("Bad stereoinfo on allene !");
            return;
        }
        int atom2 = cumuleneAtoms[numberCumuleneAtoms - 1];
        this.setCosSin(end, atom2);
        double y2 = (this.y(ref2) - this.y(atom2)) * this.temp[0] - (this.x(ref2) - this.x(atom2)) * this.temp[1];
        stereo[center] = y2 > 0.0 ? 1 : -1;
        if (ref1x) {
            int n2 = center;
            stereo[n2] = stereo[n2] * -1;
        }
        if (ref2x) {
            int n3 = center;
            stereo[n3] = stereo[n3] * -1;
        }
        if (ref1 == ref11 && ref11x < 0) {
            int n4 = center;
            stereo[n4] = stereo[n4] * -1;
        }
        if (ref1 == ref12 && ref12x < 0) {
            int n5 = center;
            stereo[n5] = stereo[n5] * -1;
        }
        if (ax[ref1] > ax[ref2]) {
            int n6 = center;
            stereo[n6] = stereo[n6] * -1;
        }
    }

    public static String getSmiles(JMECore deepCopy, JMECore.Parameters pars, boolean isQuery) {
        int nparts = deepCopy.computeMultiPartIndices();
        JMESmiles[] parts = new JMESmiles[nparts];
        for (int part = 1; part <= nparts; ++part) {
            parts[part - 1] = new JMESmiles(deepCopy, part, isQuery);
        }
        String result = "";
        for (int p = 0; p < parts.length; ++p) {
            String smiles = parts[p].createSmilesWithSideEffect(pars);
            if (result.length() > 0) {
                result = result + ".";
            }
            result = result + smiles;
            parts[p] = null;
        }
        return result;
    }

    public void findRingBonds(int[] sizes) {
        for (int i = 1; i <= this.nbonds; ++i) {
            sizes[i] = this.minimumRingSize(this.bonds[i]);
        }
    }

    boolean isInRing(int atom, int[] minBondRingSizes) {
        for (int i = 1; i <= this.nv(atom); ++i) {
            if (minBondRingSizes[this.getBondIndex(atom, this.v(atom)[i])] <= 0) continue;
            return true;
        }
        return false;
    }

    void setBondTypes(boolean[] isAromatic, int[] minBondRingSizes, boolean allowAromatic) {
        int b;
        this.btype = new int[this.nbonds + 1];
        boolean[] pa = new boolean[this.natoms + 1];
        if (allowAromatic) {
            block4: for (int i = 1; i <= this.natoms; ++i) {
                pa[i] = false;
                isAromatic[i] = false;
                if (!this.isInRing(i, minBondRingSizes) || this.nv(i) + this.atoms[i].nh > 3) continue;
                switch (this.an(i)) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 13: {
                        pa[i] = true;
                        continue block4;
                    }
                    case 32: {
                        pa[i] = !this.atoms[i].label.startsWith("A");
                    }
                }
            }
        }
        if (this.isQuery) {
            this.doRingQueryCheck(isAromatic, minBondRingSizes);
        }
        for (b = 1; b <= this.nbonds; ++b) {
            if (this.isSingle(b)) {
                this.btype[b] = 1;
                continue;
            }
            if (this.isDouble(b)) {
                this.btype[b] = 2;
                continue;
            }
            if (this.bonds[b].bondType == 3) {
                this.btype[b] = 3;
                continue;
            }
            System.err.println("problems in findAromatic " + this.bonds[b].bondType);
        }
        block6: for (b = 1; b <= this.nbonds; ++b) {
            if (minBondRingSizes[b] == 0) continue;
            int atom1 = this.bonds[b].va;
            int atom2 = this.bonds[b].vb;
            if (!pa[atom1] || !pa[atom2]) continue;
            boolean[] a = new boolean[this.natoms + 1];
            for (int i = 1; i <= this.nv(atom1); ++i) {
                int atom = this.v(atom1)[i];
                if (atom == atom2 || !pa[atom]) continue;
                a[atom] = true;
            }
            boolean ok = false;
            block8: do {
                for (int i = 1; i <= this.natoms; ++i) {
                    ok = false;
                    if (a[i] && pa[i] && i != atom1) {
                        for (int j = 1; j <= this.nv(i); ++j) {
                            int atom = this.v(i)[j];
                            if (atom == atom2) {
                                isAromatic[atom1] = true;
                                isAromatic[atom2] = true;
                                this.btype[b] = 5;
                                continue block6;
                            }
                            if (a[atom] || !pa[atom]) continue;
                            a[atom] = true;
                            ok = true;
                        }
                    }
                    if (ok) continue block8;
                }
            } while (ok);
        }
    }

    void doRingQueryCheck(boolean[] isAromatic, int[] minBondRingSizes) {
        int atom2;
        int atom1;
        int b;
        boolean[] ra = new boolean[this.natoms + 1];
        boolean doCheck = false;
        for (b = 1; b <= this.nbonds; ++b) {
            atom1 = this.bonds[b].va;
            atom2 = this.bonds[b].vb;
            ra[atom1] = true;
            ra[atom2] = true;
            if (this.an(atom1) != 32 && this.an(atom2) != 32) continue;
            doCheck = true;
        }
        if (!doCheck) {
            return;
        }
        block1: for (b = 1; b <= this.nbonds; ++b) {
            if (minBondRingSizes[b] == 0) continue;
            atom1 = this.bonds[b].va;
            atom2 = this.bonds[b].vb;
            boolean[] a = new boolean[this.natoms + 1];
            for (int i = 1; i <= this.nv(atom1); ++i) {
                int atom = this.v(atom1)[i];
                if (atom == atom2 || !ra[atom]) continue;
                a[atom] = true;
            }
            boolean ok = false;
            block3: do {
                for (int i = 1; i <= this.natoms; ++i) {
                    ok = false;
                    if (a[i] && ra[i] && i != atom1) {
                        for (int j = 1; j <= this.nv(i); ++j) {
                            int atom = this.v(i)[j];
                            if (atom == atom2) {
                                for (int k = 1; k <= this.natoms; ++k) {
                                    if (!a[k]) continue;
                                    if (this.an(k) == 5) {
                                        this.AN(k, 32);
                                        this.atoms[k].label = "#8";
                                    }
                                    if (this.an(k) == 4) {
                                        this.AN(k, 32);
                                        this.atoms[k].label = "#7";
                                    }
                                    if (this.an(k) != 8) continue;
                                    this.AN(k, 32);
                                    this.atoms[k].label = "#16";
                                }
                                continue block1;
                            }
                            if (a[atom] || !ra[atom]) continue;
                            a[atom] = true;
                            ok = true;
                        }
                    }
                    if (ok) continue block3;
                }
            } while (ok);
        }
    }

    void canonize(boolean computeValenceState) {
        int i;
        int[] a = new int[this.natoms + 1];
        int[] aold = new int[this.natoms + 1];
        long[] d = new long[this.natoms + 1];
        long[] prime = new long[this.natoms + 2];
        prime = JMESmiles.generatePrimes(this.natoms);
        for (int i2 = 1; i2 <= this.natoms; ++i2) {
            String zlabel;
            Atom atom = this.atoms[i2];
            int xbo = 1;
            for (int j = 1; j <= this.nbonds; ++j) {
                if (this.bonds[j].va != i2 && this.bonds[j].vb != i2) continue;
                xbo *= this.btype[j];
            }
            int xan = this.an(i2);
            if (xan == 32 && (zlabel = this.atoms[i2].label) != null && zlabel.length() > 0) {
                int c1 = zlabel.charAt(0) - 65 + 1;
                int c2 = 0;
                if (zlabel.length() > 1) {
                    c2 = zlabel.charAt(1) - 97;
                }
                if (c1 < 0) {
                    c1 = 0;
                }
                if (c2 < 0) {
                    c2 = 0;
                }
                xan = c1 * 28 + c2;
            }
            int qq = 0;
            if (this.q(i2) != 0) {
                if (this.q(i2) < -2) {
                    qq = 1;
                } else if (this.q(i2) == -2) {
                    qq = 2;
                } else if (this.q(i2) == -1) {
                    qq = 3;
                } else if (this.q(i2) == 1) {
                    qq = 4;
                } else if (this.q(i2) == 2) {
                    qq = 5;
                } else if (this.q(i2) > 2) {
                    qq = 6;
                }
            }
            int deltaIso = 0;
            if (atom.iso != 0 && (deltaIso = Isotopes.getDeltaIsotopicMassOfElement(this.getAtomLabel(i2), atom.iso)) < 0) {
                deltaIso = 10 - deltaIso;
            }
            int xx = 126;
            int dFactor = xbo;
            dFactor += this.atoms[i2].nh * xx;
            dFactor += qq * (xx *= 7);
            xx *= 7;
            if (deltaIso != 0) {
                dFactor += deltaIso * xx;
            }
            dFactor += xan * (xx *= 7);
            d[i2] = dFactor += this.nv(i2) * (xx *= 783);
        }
        int breaklevel = 0;
        while (!this.canonsort(a, d)) {
            int i3;
            block44: {
                int j;
                boolean ok = false;
                for (i3 = 1; i3 <= this.natoms; ++i3) {
                    if (a[i3] == aold[i3]) continue;
                    aold[i3] = a[i3];
                    ok = true;
                }
                if (ok) {
                    for (i3 = 1; i3 <= this.natoms; ++i3) {
                        d[i3] = 1L;
                        for (j = 1; j <= this.nv(i3); ++j) {
                            int n = i3;
                            d[n] = d[n] * prime[a[this.v(i3)[j]]];
                        }
                    }
                    breaklevel = 0;
                } else if (breaklevel > 0) {
                    for (i3 = 1; i3 <= this.natoms; ++i3) {
                        d[i3] = 1L;
                    }
                    for (i3 = 1; i3 <= this.natoms - 1; ++i3) {
                        for (j = i3 + 1; j <= this.natoms; ++j) {
                            if (a[i3] != a[j]) continue;
                            d[i3] = 2L;
                            break block44;
                        }
                    }
                } else {
                    for (i3 = 1; i3 <= this.natoms; ++i3) {
                        d[i3] = 1L;
                        for (j = 1; j <= this.nv(i3); ++j) {
                            int atom = this.v(i3)[j];
                            int n = i3;
                            d[n] = d[n] * (long)(this.an(atom) * this.btype[this.getBondIndex(i3, atom)]);
                        }
                    }
                    breaklevel = 1;
                }
            }
            this.canonsort(a, d);
            for (i3 = 1; i3 <= this.natoms; ++i3) {
                d[i3] = aold[i3] * this.natoms + a[i3];
            }
        }
        for (i = 1; i <= this.natoms; ++i) {
            aold[i] = a[i];
        }
        block13: for (int s = 1; s <= this.natoms; ++s) {
            for (int i4 = 1; i4 <= this.natoms; ++i4) {
                if (aold[i4] != s) continue;
                JMESmiles.swap(this.atoms, i4, s);
                aold[i4] = aold[s];
                aold[s] = s;
                continue block13;
            }
        }
        for (i = 1; i <= this.nbonds; ++i) {
            this.bonds[i].va = a[this.bonds[i].va];
            this.bonds[i].vb = a[this.bonds[i].vb];
            if (this.bonds[i].va <= this.bonds[i].vb) continue;
            int du = this.bonds[i].va;
            this.bonds[i].va = this.bonds[i].vb;
            this.bonds[i].vb = du;
            if (this.bonds[i].stereo == 1) {
                this.bonds[i].stereo = 3;
                continue;
            }
            if (this.bonds[i].stereo == 2) {
                this.bonds[i].stereo = 4;
                continue;
            }
            if (this.bonds[i].stereo == 3) {
                this.bonds[i].stereo = 1;
                continue;
            }
            if (this.bonds[i].stereo != 4) continue;
            this.bonds[i].stereo = 2;
        }
        for (i = 1; i < this.nbonds; ++i) {
            int minva = this.natoms;
            int minvb = this.natoms;
            int b = 0;
            for (int j = i; j <= this.nbonds; ++j) {
                if (this.bonds[j].va < minva) {
                    minva = this.bonds[j].va;
                    minvb = this.bonds[j].vb;
                    b = j;
                    continue;
                }
                if (this.bonds[j].va != minva || this.bonds[j].vb >= minvb) continue;
                minvb = this.bonds[j].vb;
                b = j;
            }
            JMESmiles.swap(this.bonds, i, b);
        }
        this.complete(computeValenceState);
    }

    public static void swap(AtomBondCommon[] array, int i, int j) {
        AtomBondCommon temp = array[j];
        array[j] = array[i];
        array[i] = temp;
    }

    boolean canonsort(int[] a, long[] d) {
        long min = 0L;
        int nth = 0;
        int ndone = 0;
        do {
            int i;
            ++nth;
            for (i = 1; i <= this.natoms; ++i) {
                if (d[i] <= 0L) continue;
                min = d[i];
                break;
            }
            for (i = 1; i <= this.natoms; ++i) {
                if (d[i] <= 0L || d[i] >= min) continue;
                min = d[i];
            }
            for (i = 1; i <= this.natoms; ++i) {
                if (d[i] != min) continue;
                a[i] = nth;
                d[i] = 0L;
                ++ndone;
            }
        } while (ndone != this.natoms);
        return nth == this.natoms;
    }

    public static long[] generatePrimes(int n) {
        long[] pn = new long[n + 2];
        int[] prime = new int[100];
        int index = 0;
        int num = 0;
        boolean check = true;
        prime[0] = 3;
        pn[1] = 2L;
        pn[2] = 3L;
        int npn = 2;
        if (n < 3) {
            return pn;
        }
        for (int test = 5; test < prime[num] * prime[num]; test += 2) {
            index = 0;
            check = true;
            while (check && index <= num && test >= prime[index] * prime[index]) {
                if (test % prime[index] == 0) {
                    check = false;
                    continue;
                }
                ++index;
            }
            if (!check) continue;
            pn[++npn] = test;
            if (npn >= n) {
                return pn;
            }
            if (num >= prime.length - 1) continue;
            prime[++num] = test;
        }
        System.err.println("ERROR - Prime Number generator failed !");
        return pn;
    }

    public static void stereoTransformation(int[] t, int[] ref) {
        int d = 0;
        if (ref[0] == t[1]) {
            d = t[0];
            t[0] = t[1];
            t[1] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        } else if (ref[0] == t[2]) {
            d = t[2];
            t[2] = t[0];
            t[0] = d;
            d = t[1];
            t[1] = t[3];
            t[3] = d;
        } else if (ref[0] == t[3]) {
            d = t[3];
            t[3] = t[0];
            t[0] = d;
            d = t[1];
            t[1] = t[2];
            t[2] = d;
        }
        if (ref[1] == t[2]) {
            d = t[1];
            t[1] = t[2];
            t[2] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        } else if (ref[1] == t[3]) {
            d = t[1];
            t[1] = t[3];
            t[3] = d;
            d = t[2];
            t[2] = t[3];
            t[3] = d;
        }
    }

    public static int compareAngles(double sina, double cosa, double sinb, double cosb) {
        int qa = 0;
        int qb = 0;
        if (sina >= 0.0 && cosa >= 0.0) {
            qa = 1;
        } else if (sina >= 0.0 && cosa < 0.0) {
            qa = 2;
        } else if (sina < 0.0 && cosa < 0.0) {
            qa = 3;
        } else if (sina < 0.0 && cosa >= 0.0) {
            qa = 4;
        }
        if (sinb >= 0.0 && cosb >= 0.0) {
            qb = 1;
        } else if (sinb >= 0.0 && cosb < 0.0) {
            qb = 2;
        } else if (sinb < 0.0 && cosb < 0.0) {
            qb = 3;
        } else if (sinb < 0.0 && cosb >= 0.0) {
            qb = 4;
        }
        if (qa < qb) {
            return 1;
        }
        if (qa > qb) {
            return -1;
        }
        switch (qa) {
            case 1: 
            case 4: {
                if (sina < sinb) {
                    return 1;
                }
                return -1;
            }
            case 2: 
            case 3: {
                if (sina > sinb) {
                    return 1;
                }
                return -1;
            }
        }
        System.err.println("stereowarning #31");
        return 0;
    }
}

