/*
 * Decompiled with CFR 0.152.
 */
package com.junrar.rarfile;

import com.junrar.io.Raw;
import com.junrar.rarfile.BlockHeader;
import com.junrar.rarfile.SubBlockHeaderType;

public class SubBlockHeader
extends BlockHeader {
    public static final short SubBlockHeaderSize = 3;
    private final short subType;
    private byte level;

    public SubBlockHeader(SubBlockHeader sb) {
        super(sb);
        this.subType = sb.getSubType().getSubblocktype();
        this.level = sb.getLevel();
    }

    public SubBlockHeader(BlockHeader bh, byte[] subblock) {
        super(bh);
        int position = 0;
        this.subType = Raw.readShortLittleEndian(subblock, position);
        this.level = (byte)(this.level | subblock[position += 2] & 0xFF);
    }

    public byte getLevel() {
        return this.level;
    }

    public SubBlockHeaderType getSubType() {
        return SubBlockHeaderType.findSubblockHeaderType(this.subType);
    }

    @Override
    public void print() {
        super.print();
    }
}

