/*
 * Decompiled with CFR 0.152.
 */
package com.junrar;

import com.junrar.Archive;
import com.junrar.exception.RarException;
import com.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class LocalFolderExtractor {
    private final File folderDestination;

    LocalFolderExtractor(File destination) {
        this.folderDestination = destination;
    }

    File createDirectory(FileHeader fh) {
        String fileName = null;
        if (fh.isDirectory()) {
            fileName = fh.getFileName();
        }
        if (fileName == null) {
            return null;
        }
        File f = new File(this.folderDestination, fileName);
        try {
            String fileCanonPath = f.getCanonicalPath();
            if (!fileCanonPath.startsWith(this.folderDestination.getCanonicalPath())) {
                String errorMessage = "Rar contains invalid path: '" + fileCanonPath + "'";
                throw new IllegalStateException(errorMessage);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return f;
    }

    File extract(Archive arch, FileHeader fileHeader) throws RarException, IOException {
        File f = this.createFile(fileHeader, this.folderDestination);
        try (FileOutputStream stream = new FileOutputStream(f);){
            arch.extractFile(fileHeader, stream);
        }
        return f;
    }

    private File createFile(FileHeader fh, File destination) throws IOException {
        String name = fh.getFileName();
        File f = new File(destination, name);
        String dirCanonPath = f.getCanonicalPath();
        if (!dirCanonPath.startsWith(destination.getCanonicalPath())) {
            String errorMessage = "Rar contains file with invalid path: '" + dirCanonPath + "'";
            throw new IllegalStateException(errorMessage);
        }
        if (!f.exists()) {
            try {
                f = this.makeFile(destination, name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    private File makeFile(File destination, String name) throws IOException {
        String[] dirs = name.split("\\\\");
        String path = "";
        int size = dirs.length;
        if (size == 1) {
            return new File(destination, name);
        }
        if (size > 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                path = path + File.separator + dirs[i];
                File dir = new File(destination, path);
                dir.mkdir();
            }
            path = path + File.separator + dirs[dirs.length - 1];
            File f = new File(destination, path);
            f.createNewFile();
            return f;
        }
        return null;
    }
}

