/*
 * Decompiled with CFR 0.152.
 */
package com.integratedgraphics.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import swingjs.jzlib.CRC32;
import swingjs.jzlib.Inflater;
import swingjs.jzlib.InflaterInputStream;

public class ZipInputStream
extends InflaterInputStream {
    private static final long LOCSIG = 67324752L;
    private static final long EXTSIG = 134695760L;
    private static final int LOCHDR = 30;
    private static final int EXTHDR = 16;
    private static final int LOCFLG = 6;
    private static final int LOCHOW = 8;
    private static final int LOCCRC = 14;
    private static final int LOCSIZ = 18;
    private static final int LOCLEN = 22;
    private static final int LOCNAM = 26;
    private static final int LOCEXT = 28;
    private static final int EXTCRC = 4;
    private static final int EXTSIZ = 8;
    private static final int EXTLEN = 12;
    private static final int ZIP64_EXTHDR = 24;
    private static final int ZIP64_EXTID = 1;
    private static final long ZIP64_MAGICVAL = 0xFFFFFFFFL;
    private static final int ZIP64_EXTCRC = 4;
    private static final int ZIP64_EXTSIZ = 8;
    private static final int ZIP64_EXTLEN = 16;
    private static final int EFS = 2048;
    private ZipEntry entry;
    private int flag;
    private CRC32 crc = new CRC32();
    private long remaining;
    private byte[] tmpbuf = new byte[512];
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean entryEOF = false;
    private String zc;
    protected static final int GET_BYTE_STREAM_FOR_ZIP = -2;
    protected static final int GET_BYTE_STREAM_OR_NULL = -1;
    private byte[] b = new byte[256];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipInputStream(InputStream in) {
        super(new PushbackInputStream(in, 512), ZipInputStream.newInflater(), 512, true);
        String charset;
        this.zc = charset = "UTF-8";
    }

    private static Inflater newInflater() {
        return new Inflater().init(0, true);
    }

    private void initEntry() {
        this.crc.reset();
        this.inflater = new Inflater().init(0, true);
        if (this.entry.getMethod() == 0) {
            this.remaining = this.entry.getSize();
        }
        this.entryEOF = false;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.entryEOF ? 0 : 1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.entry == null) {
            return -1;
        }
        switch (this.entry.getMethod()) {
            case 8: {
                len = this.readInf(b, off, len);
                if (len == -1) {
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                } else {
                    this.crc.update(b, off, len);
                }
                return len;
            }
            case 0: {
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                if ((long)len > this.remaining) {
                    len = (int)this.remaining;
                }
                if ((len = this.in.read(b, off, len)) == -1) {
                    throw new ZipException("unexpected EOF");
                }
                this.crc.update(b, off, len);
                this.remaining -= (long)len;
                if (this.remaining == 0L && this.entry.getCrc() != this.crc.getValue()) {
                    throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(this.entry.getCrc()) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                return len;
            }
        }
        throw new ZipException("invalid compression method");
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IllegalArgumentException("ZipInputStream.skip not implemented");
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private ZipEntry readLOC() throws IOException {
        boolean readSizes;
        int blen;
        try {
            this.readFully(this.tmpbuf, 0, 30);
        }
        catch (EOFException e) {
            return null;
        }
        if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
            return null;
        }
        this.flag = ZipInputStream.get16(this.tmpbuf, 6);
        int len = ZipInputStream.get16(this.tmpbuf, 26);
        if (len > (blen = this.b.length)) {
            while (len > (blen *= 2)) {
            }
            this.b = new byte[blen];
        }
        this.readFully(this.b, 0, len);
        String name = (this.flag & 0x800) != 0 ? this.toStringUTF8(this.b, len) : this.toStringb2(this.b, len);
        ZipEntry e = this.createZipEntry(name);
        if ((this.flag & 1) == 1) {
            throw new ZipException("encrypted ZIP entry not supported");
        }
        e.setMethod(ZipInputStream.get16(this.tmpbuf, 8));
        boolean bl = readSizes = (this.flag & 8) != 8 || e.getMethod() != 8;
        if (readSizes) {
            e.setCrc(ZipInputStream.get32(this.tmpbuf, 14));
            e.setCompressedSize(ZipInputStream.get32(this.tmpbuf, 18));
            e.setSize(ZipInputStream.get32(this.tmpbuf, 22));
        }
        if ((len = ZipInputStream.get16(this.tmpbuf, 28)) > 0) {
            byte[] bb = new byte[len + 4];
            this.readFully(bb, 0, len);
            if (e.getCompressedSize() == 0xFFFFFFFFL || e.getSize() == 0xFFFFFFFFL) {
                int off = 0;
                while (off + 4 < len) {
                    int sz = ZipInputStream.get16(bb, off + 2);
                    if (ZipInputStream.get16(bb, off) == 1) {
                        if (sz < 16 || (off += 4) + sz > len) {
                            return e;
                        }
                        e.setSize(ZipInputStream.get64(bb, off));
                        e.setCompressedSize(ZipInputStream.get64(bb, off + 8));
                        break;
                    }
                    off += sz + 4;
                }
            }
        }
        this.eof = false;
        return e;
    }

    private String toStringUTF8(byte[] b2, int len) {
        try {
            return new String(b2, 0, len, this.zc);
        }
        catch (UnsupportedEncodingException e) {
            return this.toStringb2(b2, len);
        }
    }

    private String toStringb2(byte[] b2, int len) {
        return new String(b2, 0, len);
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    private void readEnd(ZipEntry e) throws IOException {
        int n = this.inflater.getAvailIn();
        if (n > 0) {
            this.unread(this.buf, this.len, n);
            this.eof = false;
        }
        if ((this.flag & 8) == 8) {
            if (this.inflater.getTotalOutL() > 0xFFFFFFFFL || this.inflater.getTotalInL() > 0xFFFFFFFFL) {
                this.readFully(this.tmpbuf, 0, 24);
                long sig = ZipInputStream.get32(this.tmpbuf, 0);
                if (sig != 134695760L) {
                    e.setCrc(sig);
                    e.setCompressedSize(ZipInputStream.get64(this.tmpbuf, 4));
                    e.setSize(ZipInputStream.get64(this.tmpbuf, 12));
                    this.unread(this.tmpbuf, 23, 4);
                } else {
                    e.setCrc(ZipInputStream.get32(this.tmpbuf, 4));
                    e.setCompressedSize(ZipInputStream.get64(this.tmpbuf, 8));
                    e.setSize(ZipInputStream.get64(this.tmpbuf, 16));
                }
            } else {
                this.readFully(this.tmpbuf, 0, 16);
                long sig = ZipInputStream.get32(this.tmpbuf, 0);
                if (sig != 134695760L) {
                    e.setCrc(sig);
                    e.setCompressedSize(ZipInputStream.get32(this.tmpbuf, 4));
                    e.setSize(ZipInputStream.get32(this.tmpbuf, 8));
                    this.unread(this.tmpbuf, 15, 4);
                } else {
                    e.setCrc(ZipInputStream.get32(this.tmpbuf, 4));
                    e.setCompressedSize(ZipInputStream.get32(this.tmpbuf, 8));
                    e.setSize(ZipInputStream.get32(this.tmpbuf, 12));
                }
            }
        }
        if (e.getSize() != this.inflater.getTotalOutL()) {
            throw new ZipException("invalid entry size (expected " + e.getSize() + " but got " + this.inflater.getTotalOutL() + " bytes)");
        }
        if (e.getCompressedSize() != this.inflater.getTotalInL()) {
            throw new ZipException("invalid entry compressed size (expected " + e.getCompressedSize() + " but got " + this.inflater.getTotalInL() + " bytes)");
        }
        if (e.getCrc() != this.crc.getValue()) {
            throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(e.getCrc()) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
        }
    }

    private void unread(byte[] b, int len, int n) throws IOException {
        ((PushbackInputStream)this.in).unread(b, len - n, n);
    }

    private void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = this.in.read(b, off, len);
            if (n == -1) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    private static final int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] b, int off) {
        return ((long)ZipInputStream.get16(b, off) | (long)ZipInputStream.get16(b, off + 2) << 16) & 0xFFFFFFFFL;
    }

    private static final long get64(byte[] b, int off) {
        return ZipInputStream.get32(b, off) | ZipInputStream.get32(b, off + 4) << 32;
    }

    public ZipEntry getNextEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        if ((this.entry = this.readLOC()) == null) {
            return null;
        }
        this.initEntry();
        return this.entry;
    }
}

